/*
 *               Copyright (C) 2006, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __NC_MP3_H_
#define __NC_MP3_H_

#include <sc/aud.h>

#define MP3_DEV                    "/dev/media/mp3"

/* ioctl commands for MP3 driver */

/* parameters for ioctl commands */
#define MP3_GET_VOLUME                   0
#define MP3_SET_VOLUME                   1
#define MP3_PLAY                         2
#define MP3_STOP                         3
#define MP3_GET_HEADSET                  4
#define MP3_GET_SAMPLE_RATE              5
#define MP3_GET_STATUS                   6

#define MP3_STOPPED                      0
#define MP3_PLAYING                      1

/* mp3 volume settings for MP3_SET_VOLUME and MP3_GET_VOLUME ioctl commands.
 */
#define MP3_VOLUME_MIN           AUD_VOLUME_MIN
#define MP3_VOLUME_MAX           AUD_VOLUME_MAX
#define MP3_VOLUME_DEFAULT       AUD_VOLUME_DEFAULT
#define MP3_VOLUME_MUTE          AUD_VOLUME_MUTE

#endif
