#ifndef	__RTC_H__
#define	__RTC_H__

#define	RTC_POWER_FLAG		0x80
#define	RTC_BKUP_FLAG		0x40
#define	RTC_FLAGS			0xC0

#define	RTC_INTMOD_MASK	0x07

typedef struct {
	u8	year;
	u8	month;
	u8	day;
	u8	week;
	u8	hour;
	u8	minute;
	u8	second;
	u8	stat;
	u8	alarm_hour;
	u8	alarm_minute;
} RTCDataOrg;

void RTCIoEnable(void);
void RTCIoDisable(void);

u8 RTCPowerOnCheck(void);
u8 RTCReset(void);
u8 RTCReadStat(RTCDataOrg* rtc_dat_org);
u8 RTCWriteStat(RTCDataOrg* rtc_dat_org);
u8 RTCReadDate(RTCDataOrg* rtc_dat_org);
u8 RTCWriteDate(RTCDataOrg* rtc_dat_org);
u8 RTCReadTime(RTCDataOrg* rtc_dat_org);
u8 RTCWriteTime(RTCDataOrg* rtc_dat_org);
u8 RTCReadAlarm(RTCDataOrg* rtc_dat_org);
u8 RTCWriteAlarm(RTCDataOrg* rtc_dat_org);

#endif	/*__RTC_H__*/
