/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __SEMIHOST_USB_H__
#define __SEMIHOST_USB_H__

#define USB_SEMI_REQ_MAGIC         0x534D6874        /* SMht */
#define USB_SEMI_REPLY_MAGIC       0x74684D53

#define USB_SEMI_RECV_DATA_READY   0x08000000
#define USB_SEMIHOST_START         0x08000001
#define USB_SEMIHOST_END           0x08000002

#define VN_MAX_SIZE                16384

/* 
 * Since USB hw need buffer to be cacheline(16 Bytes) aligned,
 * Please make sure the following two data structures 
 * size can be divide by cacheline
 */
typedef struct {
    unsigned int  magic;            /* Magic number */
    int           req;              /* Semihost request command */
    unsigned int  pcFd;             /* Host Fd */
    unsigned int  len;              /* length of data to send */    
    unsigned int  data[4];          /* 4 additional request data */
} USBSemihostRequest;

typedef struct {
    unsigned int  magic;            /* Magic number */
    int           reply;            /* Reply code */
    unsigned int  pcFd;             /* Host Fd */
    unsigned int  len;              /* length of data to send */    
    unsigned int  data[4];          /* 4 additional reply data */
} USBSemihostReply;

int vioUSB_InitLib(char *buf);
int vioUSB_CloseLib();

#endif
