/*
 *              Copyright (C) 2005, BroadOn Communications Corp.
 *
 * These coded instructions, statements, and computer programs contain
 * unpublished  proprietary information of BroadOn Communications Corp.,
 * and  are protected by Federal copyright law. They may not be disclosed
 * to  third  parties or copied or duplicated in any form, in whole or in
 * part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __NC_SHELL_H_
#define __NC_SHELL_H_

#define SHELL_REQ_PING            1
#define SHELL_REQ_FORMAT          2
#define SHELL_REQ_LS              3
#define SHELL_REQ_PWD             4
#define SHELL_REQ_CD              5
#define SHELL_REQ_MKDIR           6
#define SHELL_REQ_RM              7
#define SHELL_REQ_MV              8
#define SHELL_REQ_PUT             9
#define SHELL_REQ_GET             10
#define SHELL_REQ_LAUNCH          11
#define SHELL_REQ_CP              12
#define SHELL_REQ_VER             13
#define SHELL_REQ_IMPORT          14
#define SHELL_REQ_USAGE           15
#define SHELL_REQ_DIAG            0x20
#define SHELL_REQ_READBOOT        0x30
#define SHELL_REQ_WRITEBOOT       0x31

#define SHELL_RET_ERR_OK          0
#define SHELL_RET_ERR_BUS         1

/* Same as FS_ERROR_XXXX, but re-encoded to u8 */
#define SHELL_RET_ERR_UNKNOWN     2
#define SHELL_RET_ERR_ACCESS      3      
#define SHELL_RET_ERR_CORRUPT     4
#define SHELL_RET_ERR_INVALID     5
#define SHELL_RET_ERR_NOTREADY    6
#define SHELL_RET_ERR_EXISTS      7
#define SHELL_RET_ERR_MAXFILES    8
#define SHELL_RET_ERR_NOEXISTS    9
#define SHELL_RET_ERR_MAXBLOCKS   10

#define SHELL_RET_INVALID_PATH     30
#define SHELL_RET_EXCEED_MAX      31
#define SHELL_RET_ERR_CMD_FAIL    100

#define SHELL_LS_DIR              1
#define SHELL_LS_FILE             2

#define SHELL_DIAG_AUD            1
#define SHELL_DIAG_RTC            2
#define SHELL_DIAG_USB            3
#define SHELL_DIAG_GBA            4
#define SHELL_DIAG_FLASH          5

#define DCACHE_ALIGN  __attribute__ ((aligned (16)))

#endif

