/*
 *              Copyright (C) 2005, BroadOn Communications Corp.
 *
 * These coded instructions, statements, and computer programs contain
 * unpublished  proprietary information of BroadOn Communications Corp.,
 * and  are protected by Federal copyright law. They may not be disclosed
 * to  third  parties or copied or duplicated in any form, in whole or in
 * part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __NC_USB_H_
#define __NC_USB_H_

#define USB_DEV_MUX_BULK_ID         0
#define USB_DEV_MUX_ISO_ID          1
#define USB_DEV_MSD_ID              2
#define USB_DEV_PTP_ID              3
#define USB_NUM_DEV                 4

#define USB_DEV                     "/dev/usb"
#define USB_DEV_MSD                 "/dev/usb/msd"
#define USB_DEV_PTP                 "/dev/usb/ptp"
#define USB_DEV_MUX_BULK            "/dev/usb/mux/bulk"
#define USB_DEV_MUX_ISO             "/dev/usb/mux/iso"

#define USB_DEV_MUX_BULK_CTRL       "/dev/usb/mux/bulk/ctrl"
#define USB_DEV_MUX_BULK_GDB        "/dev/usb/mux/bulk/gdb"
#define USB_DEV_MUX_BULK_PRINTF     "/dev/usb/mux/bulk/printf"
#define USB_DEV_MUX_BULK_VN         "/dev/usb/mux/bulk/vn"
#define USB_DEV_MUX_BULK_SHELL      "/dev/usb/mux/bulk/shell"
#define USB_DEV_MUX_BULK_MEDIA      "/dev/usb/mux/bulk/media"

#define USB_DEV_MUX_ISO_CTRL        "/dev/usb/mux/iso/ctrl"
#define USB_DEV_MUX_ISO_GDB         "/dev/usb/mux/iso/gdb"
#define USB_DEV_MUX_ISO_PRINTF      "/dev/usb/mux/iso/printf"
#define USB_DEV_MUX_ISO_VN          "/dev/usb/mux/iso/vn"
#define USB_DEV_MUX_ISO_SHELL       "/dev/usb/mux/iso/shell"
#define USB_DEV_MUX_ISO_MEDIA       "/dev/usb/mux/iso/media"

/* usb device status */
#define USB_STATUS_NOT_OPEN         1
#define USB_STATUS_UNPLUG           2  
#define USB_STATUS_ENUM             3      
#define USB_STATUS_ENUM_DONE        4
#define USB_STATUS_READY            5 

/* ioctl command for USB driver */
#define USB_GET_DEV_TYPE            0
#define USB_SET_DEV_TYPE            1
#define USB_GET_DEV_STATUS          2 
#define USB_WAIT_DEV_READY          3 
#define USB_MUX_STALL_CLEAR         0x30 

#define USB_DEV_MUX_CTRL_ID         0 
#define USB_DEV_MUX_GDB_ID          1
#define USB_DEV_MUX_PRINTF_ID       2
#define USB_DEV_MUX_VN_ID           3
#define USB_DEV_MUX_SHELL_ID        4
#define USB_DEV_MUX_MEDIA_ID        5
#define USB_DEV_MUX_MAX_ID          6

#define USB_MUX_STREAM_MAGIC   0xbacf
#define USB_MUX_TR_SIZE        64
#define USB_MUX_HD_SIZE        16
#define USB_MUX_PAD_SIZE       48

typedef struct {
    u16 magic;                 /* magic number */  
    u16 protonum;              /* type (to make simple, it is id) */
    u16 length;                /* length */
    u16 check;                 /* not used */
    u8  cachelinePad[8];       /* Make header cacheline align to eliminate bcopy */
    u8  pad[USB_MUX_PAD_SIZE]; /* padding to 64 Byte to increase performance */
} USBStreamHeader;

#endif

