#ifndef __WA_H__
#define __WA_H__

/*
 * Wolfson WM8731 Register definitions
 */
#define WM_LLINE_REG		0
#define WM_LLINE_VOL_MASK	0x1f
#define WM_LLINE_VOL_SHIFT	0x0
#define WM_LLINE_VOL(v)		(((v) & WM_LLINE_VOL_MASK) >> WM_LLINE_VOL_SHIFT)
#define WM_LLINE_MUTE		0x80
#define WM_LLINE_BOTH		0x100

#define WM_RLINE_REG		1
#define WM_RLINE_VOL_MASK	0x1f
#define WM_RLINE_VOL_SHIFT	0x0
#define WM_RLINE_VOL(v)		(((v) & WM_RLINE_VOL_MASK) >> WM_RLINE_VOL_SHIFT)
#define WM_RLINE_MUTE		0x80
#define WM_RLINE_BOTH		0x100

#define WM_LPHONE_REG		2
#define WM_LPHONE_VOL_MASK	0x7f
#define WM_LPHONE_VOL_SHIFT	0x0
#define WM_LPHONE_VOL(v)	(((v) & WM_LPHONE_VOL_MASK) >> WM_LPHONE_VOL_SHIFT)
#define WM_LPHONE_LZCEN		0x80
#define WM_LPHONE_BOTH		0x100

#define WM_RPHONE_REG		3
#define WM_RPHONE_VOL_MASK	0x7f
#define WM_RPHONE_VOL_SHIFT	0x0
#define WM_RPHONE_VOL(v)	(((v) & WM_RPHONE_VOL_MASK) >> WM_RPHONE_VOL_SHIFT)
#define WM_RPHONE_LZCEN		0x80
#define WM_RPHONE_BOTH		0x100

#define WM_APATH_REG		4
#define WM_APATH_MICBOOST	0x1
#define WM_APATH_MICMUTE	0x2
#define WM_APATH_INSEL		0x4
#define WM_APATH_BYPASS		0x8
#define WM_APATH_DACSEL		0x10
#define WM_APATH_SIDETONE	0x20
#define WM_APATH_SIDEATT_MASK	0xc0
#define WM_APATH_SIDEATT_SHIFT	6
#define WM_APATH_SIDEATT(v)	(((v) & WM_APATH_SIDEATT_MASK) >> WM_APATH_SIDEATT_SHIFT)

#define WM_DPATH_REG		5
#define WM_DPATH_ADCHPD		0x1
#define WM_DPATH_DEEMP_MASK	0x6
#define WM_DPATH_DEEMP_SHIFT	1
#define WM_DPATH_DEEMP(v)	(((v) & WM_DPATH_DEEMP_MASK) >> WM_DPATH_DEEP_SHIFT)
#define WM_DPATH_DACMUTE	0x8
#define WM_DPATH_HPOR		0x10

#define WM_PWRDOWN_REG		6
#define WM_PWRDOWN_LINEIN	0x1
#define WM_PWRDOWN_MIC		0x2
#define WM_PWRDOWN_ADC		0x4
#define WM_PWRDOWN_DAC		0x8
#define WM_PWRDOWN_OUT		0x10
#define WM_PWRDOWN_OSC		0x20
#define WM_PWRDOWN_CLKOUT	0x40
#define WM_PWRDOWN_PWROFF	0x80

#define WM_DAFMT_REG		7
#define WM_DAFMT_RIGHTMSB	0
#define WM_DAFMT_LEFTMSB	1
#define WM_DAFMT_I2S	        2
#define WM_DAFMT_DSP	        3

#define WM_DAFMT_IWL_MASK	0xc
#define WM_DAFMT_IWL_SHIFT	0x2
#define WM_DAFMT_IWL(v)		(((v) & WM_DAFMT_IWL_MASK) >> WM_DAFMT_FMT_SHIFT)
#define WM_DAFMT_IWL_16		0
#define WM_DAFMT_IWL_20		1
#define WM_DAFMT_IWL_24		2
#define WM_DAFMT_IWL_32		3

#define WM_DAFMT_LRP		0x10
#define WM_DAFMT_LRSWAP		0x20
#define WM_DAFMT_MS		0x40
#define WM_DAFMT_BCLKINV	0x80

#define WM_SCTL_REG		8
#define WM_SCTL_USB		1
#define WM_SCTL_NORMAL		0
#define WM_SCTL_BOSR_256	0x0
#define WM_SCTL_BOSR_384	0x2
#define WM_SCTL_SR_MASK		0x3c
#define WM_SCTL_SR_SHIFT	0x2
#define WM_SCTL_SR(v)		(((v) & WM_SCTL_SR_MASK) >> WM_SCTL_SR_SHIFT)
#define WM_SCTL_CLKDIV2		0x40
#define WM_SCTL_CLKODIV2	0x80

#define WM_ACTL_REG		9
#define WM_ACTL_ACTIVE		0x1
#define WM_ACTL_INACTIVE	0x0

#define WM_RESET_REG		15
#define WM_RESET_RESET		0

void WAInit();
void WAWrite(int addr, int data);
#endif
