;*********************************************************************
;*			Game Debug Switch			*
;*********************************************************************
	IFEQ	debuginfo
kportinfo	equ	0	; 0/1 ... sound port display off/on 
kdemoinfo	equ	0	; 0/1 ... polygon demo on / off
kexplain	equ	0	; 0/1 ... explain on / off
kobjsub	equ	0	; 0/1 ... obj sub switch on / off
kspeedup	equ	0	; 0/1 ... speed up off / on
kenemygone	equ	0	; 0/1 ... enemy out of range check on/off
	ELSEIF
kportinfo	equ	0	; 0/1 ... sound port display off/on 
kdemoinfo	equ	0	; 0/1 ... polygon demo on / off
kexplain	equ	0	; 0/1 ... explain on / off
kobjsub	equ	0	; 0/1 ... obj sub switch  on / off
kspeedup	equ	1	; 0/1 ... speed up off / on
kenemygone	equ	1	; 0/1 ... enemy out of range check on/off
ktdifficulty	equ	0	; difficulty (0:easy,1:normal,2:hard)
	ENDC
;*********************************************************************
;*			Freeze Timer				*
;*********************************************************************
allfreezetm	equ	10	;Game Start no tokino WAIT
safetywaittm	equ	5	;map ni modotte kitatokino enemy wait time

;*********************************************************************
;*		Mission Game Clear Condition			*
;*********************************************************************
;====================== Clear no tameno Kazu =========================
;**** Planet no kazu ****
planetkazu_max	equ	6
planetkazu_easy	equ	2
planetkazu_normal	equ	4
planetkazu_hard	equ	6

;**** Battle Ship no kazu ****
bskazu_easy		equ	2
bskazu_normal	equ	4
bskazu_hard		equ	4

;**** clear total enemy kazu ****
clrtotal_easy	equ	planetkazu_easy+bskazu_easy
clrtotal_normal	equ	planetkazu_normal+bskazu_normal
clrtotal_hard	equ	planetkazu_hard+bskazu_hard

;**** Zaco Enemy no Max Number ***
mm_missilemax	equ	4
mm_zacomax		equ	2
mm_bshipmax		equ	3
mm_enemymax		equ	mm_missilemax+mm_zacomax+mm_bshipmax


;*** battle Ship Zaco Enemy Kazu ***
	IFEQ	1
zaico_easy		equ	2
zaico_normal		equ	2
zaico_hard		equ	3
	ENDC
;*********************************************************************
;*			GameTimer				*
;*********************************************************************
gmframe	equ	5
mapgftm	equ	60			;60 frame/sec
timescale	equ	20			;map : mission = 1:20 (kanarazu 5 no baisuu!!)
secframe	equ	60/gmframe		;12game frame/sec (60frame/sec)
missgftm	equ	secframe*timescale	;mission 1 sec timer
enstrattm	equ	timescale/gmframe	;stratage moving timer (5 game frame *2 =10 game frame ni 1 kai no syori)
decimaltm	equ	timescale*secframe/10	;0~9 made decimal sec timer
;*********************************************************************
;*			Radar Scaleing				*
;*********************************************************************
;------ Radar Character -------
YajiChr	equ	$0
EnshipChr	equ	$69
BuildChr	equ	$97
ItemChr	equ	$2d
EnemyChr	equ	$5b

;*********************************************************************
;*								*
;*			Arwing Label				*
;*								*
;*********************************************************************
arwingspeed		equ	32*8	;(0~32)

;*********************************************************************
;*								*
;*			MotherShip Label			*
;*								*
;*********************************************************************
mshipcoll		equ	16		;My ship Collision Area
mshipx		equ	$02*8+4		;My Ship Center Postion X
mshipy		equ	$13*8		;My Ship Center Postion Y

spr_mshipL		equ	$128		;my ship sprite  Left Chara
spr_mshipR		equ	$12A		;my ship sprite  Right Cara

recovertm		equ	8		;Arwing kaifuku timer (8 frame/sec)

;*********************************************************************
;*			Cursor					*
;*********************************************************************
init_cursorX		equ	$8*8	;mshipx+$40
init_cursorY		equ	$10*8	;mshipy
curor_leftedge	equ	$10
curor_rightedge	equ	$f0
curor_topedge	equ	$18
curor_bottomedge	equ	$15*8

clip_cursorsx	equ	$08
clip_cursorex	equ	$f8
clip_cursorsy	equ	$08
clip_cursorey	equ	$f8

init_cursorwidth	equ	$28
cursor_shuttime	equ	16
cursor_vel		equ	((init_cursorwidth-1+0)<<8)/cursor_shuttime
cursor_colpaltm	equ	cursor_shuttime-4
;*********************************************************************
;*								*
;*			Enemy Sprite Base Number		*
;*								*
;*********************************************************************
spr_enoffset		equ	$160

sproff_zaco1		equ	$20
sproff_zaco2		equ	$00
sproff_zaco3		equ	$60
sproff_missile	equ	$40

;*********************************************************************
;*								*
;*			Planet List Label			*
;*								*
;*********************************************************************
;**** Mother Planet Center Postion ****
corneriaX		equ	$4*8	;corneria center X
corneriaY		equ	$12*8	;corneria center Y

corneriaHP		equ	100	;Corneria Planet Hit Point
corneriaAttentionHP	equ	50	;Corneria Attention HP
corneriaDangerHP	equ	20	;Corneria Danger HP
corneriaAttentionDamage	equ	corneriaHP-corneriaAttentionHP	;Corneria Danger Damage
corneriaDangerDamage		equ	corneriaHP-corneriaDangerHP	;Corneria Danger Damage

nearplanetarea	equ	16	;Near Planet Collision Area

;* planet skill offset *
planetoff_easy	equ	4	;0~3
planetoff_normal	equ	8	;0~7
planetoff_hard	equ	13	;0~12

venomCX	equ	$15*8
venomCY	equ	$04*8
venomDX	equ	$05*8
venomDY	equ	$12*8

taitaniaCX	equ	$04*8
taitaniaCY	equ	$05*8
taitaniaDX	equ	$02*8
taitaniaDY	equ	$0f*8

macbethCX	equ	$18*8
macbethCY	equ	$0b*8
macbethDX	equ	$06*8
macbethDY	equ	$12*8

eladardCX	equ	$1c*8
eladardCY	equ	$11*8
eladardDX	equ	$07*8
eladardDY	equ	$13*8

meteorCX	equ	$0c*8
meteorCY	equ	$09*8
meteorDX	equ	$05*8
meteorDY	equ	$12*8

fortunaCX	equ	$12*8
fortunaCY	equ	$14*8
fortunaDX	equ	$08*8
fortunaDY	equ	$13*8

;*********************************************************************
;*								*
;*			Enemy Base				*
;*								*
;*********************************************************************
;---------------------------------------------------------------------
enemybaseX	equ	$ec
enemybaseY	equ	$38-$3*8
;---------------------------------------------------------------------
planetcanontm_easy		equ	300
planetcanontm_normal		equ	600
planetcanontm_hard		equ	1000
;---------------------------------------------------------------------
planetCanonAp		equ	10
;*********************************************************************
;*								*
;*			BattleShip List				*
;*								*
;*********************************************************************
btship_aptm	equ	1	;Battle Ship Appear Timing
;---------------------------------------------------------------------
btship_collision	equ	8
;---------------------------------------------------------------------
btship_speed	equ	70
;---------------------------------------------------------------------
bsskill_easy		equ	0
bsskill_normal	equ	4
bsskill_hard		equ	10
;---------------------------------------------------------------------
btship_ASX	equ	$0a*8
btship_ASY	equ	$05*8
btship_AEX	equ	$06*8
btship_AEY	equ	$0B*8
canon_AEX	equ	$01*8
canon_AEY	equ	$12*8

btship_BSX	equ	$18*8
btship_BSY	equ	($08-3)*8
btship_BEX	equ	$0c*8
btship_BEY	equ	($10-3)*8
canon_BEX	equ	$04*8
canon_BEY	equ	($16-3)*8

btship_CSX	equ	$1c*8
btship_CSY	equ	$0c*8
btship_CEX	equ	$0e*8
btship_CEY	equ	$0f*8
canon_CEX	equ	$08*8
canon_CEY	equ	$15*8
;---------------------------------------------------------------------
	km_labelstart
	km_label	btship_zacotype1,2
	km_label	btship_zacotype2,2
	km_label	btship_zacotype3,2
	km_label	btship_zacotype4,2
	km_label	btship_zacotype5,2
	km_label	btship_zacotype6,2
	km_label	btship_zacotype7,2
	km_label	btship_zacotype8,2
	km_label	btship_zacotype9,2
	km_label	btship_zacotype10,2
	km_label	btship_zacotype11,2
	km_label	btship_zacotype12,2
	km_label	btship_zacotype13,2

;*********************************************************************
;*								*
;*			Step Up LIST				*
;*								*
;*********************************************************************
;* Step Up Collision *
stup_collision	equ	10
;=====================================================================
;*		Step Up Appear Postion				*
;=====================================================================
;* STEP UP Params *
stepup_posx0	equ	$04*8
stepup_posy0	equ	$08*8
stepup_posx1	equ	$0c*8
stepup_posy1	equ	$08*8
stepup_posx2	equ	$14*8
stepup_posy2	equ	$08*8
stepup_posx3	equ	$1c*8
stepup_posy3	equ	$08*8

;=====================================================================
;*		Step Up Skill OFFSET				*
;=====================================================================
stupoff_easy		equ	0
stupoff_normal	equ	4
stupoff_hard		equ	4

;=====================================================================
;*			Step Up Speed				*
;=====================================================================
stup_speed1	equ	128
stup_speed2	equ	128

;=====================================================================
;*			Step Up Appear Time			*
;=====================================================================
stup_appeartmEasy	equ	30*8
stup_appeartmNormal	equ	30*8
stup_appeartmHard	equ	30*8

stup_easytmbase	equ	00*2
stup_normaltmbase	equ	06*2
stup_hardtmbase	equ	12*2

;* EASY *
stup_initappeartmE1	equ	1*8
stup_initappeartmE2	equ	2*8
stup_initappeartmE3	equ	3*8
stup_initappeartmE4	equ	4*8
stup_initappeartmE5	equ	90*8
stup_initappeartmE6	equ	120*8

;* NORMAL *
stup_initappeartmN1	equ	1*8
stup_initappeartmN2	equ	2*8
stup_initappeartmN3	equ	3*8
stup_initappeartmN4	equ	60*8
stup_initappeartmN5	equ	90*8
stup_initappeartmN6	equ	120*8

;* HARD *
stup_initappeartmH1	equ	1*8
stup_initappeartmH2	equ	2*8
stup_initappeartmH3	equ	3*8
stup_initappeartmH4	equ	60*8
stup_initappeartmH5	equ	90*8
stup_initappeartmH6	equ	120*8


;*********************************************************************
;*								*
;*			SOS LIST				*
;*								*
;*********************************************************************
sos_demoappeartm	equ	3*8
sos_collision	equ	10
sos_plsearchcoll	equ	$30

;=====================================================================
;*		SOS Destination Postion				*
;=====================================================================
endestposAX		equ	$03*8
endestposAY		equ	$14*8
endestvelAX		equ	$3000
endestvelAY		equ	$4000

endestposBX		equ	$05*8
endestposBY		equ	$15*8
endestvelBX		equ	-$1000
endestvelBY		equ	$3000

endestposCX		equ	$06*8
endestposCY		equ	$16*8
endestvelCX		equ	-$3000
endestvelCY		equ	$3000

endestposDX		equ	$07*8
endestposDY		equ	$17*8
endestvelDX		equ	-$4000
endestvelDY		equ	-$2000

;=====================================================================
;*		SOS Skill OFFSET				*
;=====================================================================
sosoff_easy		equ	$00
sosoff_normal	equ	$06	;08
sosoff_hard		equ	$0c	;10

misoff_easy		equ	$0	;not use
misoff_normal	equ	$0	;not use
misoff_hard		equ	$0	;not use
;=====================================================================
;*			SOS Speed				*
;=====================================================================
;Speed = 0~255 : 1byte
sos_zacosp1_easy		equ	80*2
sos_zacosp2_easy		equ	180*2
sos_zacosp3_easy		equ	130*2
sos_missilesp_easy		equ	230*2

sos_zacosp1_normal		equ	80*2
sos_zacosp2_normal		equ	180*2
sos_zacosp3_normal		equ	130*2
sos_missilesp_normal		equ	230*2

sos_zacosp1_hard		equ	80*2
sos_zacosp2_hard		equ	180*2
sos_zacosp3_hard		equ	130*2
sos_missilesp_hard		equ	230*2

sos_specialsp		equ	400*2
;---------------------------------------------------------------------
sos_appearspeed	equ	256/8
sos_aroundspeed	equ	96*8
;---------------------------------------------------------------------
;=====================================================================
;*			Missile Appear Time			*
;=====================================================================
sos_easytmbase	equ	00
sos_normaltmbase	equ	06
sos_hardtmbase	equ	12
;---------------------------------------------------------------------
sos_stg1tmE	equ	20*60
sos_stg2tmE	equ	30*60
sos_stg3tmE	equ	25*60
sos_stg4tmE	equ	35*60
sos_stg5tmE	equ	28*60
sos_stg6tmE	equ	22*60
sos_shiptmE	equ	80*60
;-------------------------------------------------------------------
sos_stg1tmN	equ	50*60
sos_stg2tmN	equ	50*60
sos_stg3tmN	equ	60*60
sos_stg4tmN	equ	60*60
sos_stg5tmN	equ	70*60
sos_stg6tmN	equ	70*60
sos_shiptmN	equ	80*60
;-------------------------------------------------------------------
sos_stg1tmH	equ	20*60
sos_stg2tmH	equ	20*60
sos_stg3tmH	equ	20*60
sos_stg4tmH	equ	30*60
sos_stg5tmH	equ	30*60
sos_stg6tmH	equ	30*60
sos_shiptmH	equ	80*60
;-------------------------------------------------------------------
sos_intstg1tm	equ	30*60
sos_intstg2tm	equ	20*60
sos_intstg3tm	equ	25*60
sos_intstg4tm	equ	30*60
sos_intstg5tm	equ	35*60
sos_intstg6tm	equ	40*60
sos_intshiptm	equ	4*60
;-------------------------------------------------------------------
;=====================================================================
;*		SOS Attack Corneria Time & Attack Point		*
;=====================================================================
sos_zacoattm		equ	1
sos_misattm		equ	1
sos_shipattm		equ	1
sos_stupattm		equ	1
sos_guardattm	equ	2
;-------------------------------------------------------------------
sos_zacoatpo		equ	2
sos_misatpo		equ	10
sos_shipatpo		equ	2
