;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: gameobj.asm				*
;* 	Description	: Game Object 				*
;*	Date		: 1994.10.1				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  gameobj
;---------------------------------------------------------------------
;
;
;
;
;
;
;*********************************************************************
;	-------------------------
;	* game object initalize *
;	-------------------------
;*********************************************************************

;---------------------------------------------------------------------
; INITIALIZE
;---------------------------------------------------------------------
init_gameobj_l
	Mbankprog
	php
	ai16

	km_cmpcheckgamemode	initmission
	bne	.nogame

;--------------------------------------------------------
	stz	gameobjstruct

	ifeq	1
	km_bitcheckmismapflag	enemy
	bne	.exit
	endc

	Mset	gameobjstruct,idx_demo_stagestart

.exit
;--------------------------------------------------------
	jsr	Init_objlist	; initialize object list
	jsl	init_hell_l	; game-BG-demo programs 
;--------------------------------------------------------

.nogame	plp
	Mbankrtl

;---------------------------------------------------------------------
; MAIN
;---------------------------------------------------------------------
gameobj_l
	Mbankprog
	php
	ai16
	sty	sprite_register	

	jsr	debug_display	; ROM debug display

	km_cmpcheckgamemode	initmission
	bne	.nogame

;-------------------------------------------------------

	jsr	Bigtarget_SETcheck
	jsr	gameclear_SETcheck
	jsr	gameobj_mainprog
	jsr	set_bombcorneria
	jsl	hell_l		; helldemo

;-------------------------------------------------------


.nogame	ldy	sprite_register
	plp
	Mbankrtl


;---------------------------------------------------------------------
; IRQ
;---------------------------------------------------------------------
irq_gameobj_l
	Mbankprog
	php
	ai16

	km_cmpcheckgamemode	initmission
	bne	.nogame

	jsl	irq_hell_l	; hell/heaven BG2-VRAM draw

.nogame	plp
	Mbankrtl

;---------------------------------------------------------------------
;=====================================================================
;=====================================================================
;===========	gameobj programs ========================================
;===========	gameobj programs ========================================
;=====================================================================
;=====================================================================
;********************************************************************
;	Kenemy number check
;********************************************************************

Bigtarget_SETcheck

	lda	KEnemyNumber
	and	#00ffh
	cmp.l	Kenemy_backup
	beq	.exit
	sta.l	Kenemy_backup
	cmp	#0
	bne	.skip1
	Mset	gameobjstruct,idx_demo_gameclearobj
	bra	.exit
.skip1	Mset	gameobjstruct,idx_demo_targetcount
.exit
	rts

;********************************************************************
;	gameclear check 
;********************************************************************

gameclear_SETcheck
	lda	gameclear_flag	; gameclear sprite
	cmp	#gameclear_messagestart
	bne	.exit
	inc	gameclear_flag	; pointer inc
;----------------------------------- ; gameclear ON
;
; clear program
;
;----------------------------------- ; gameclear ON
.exit	rts

;********************************************************************
;	gameobj demo
;********************************************************************

gameobj_mainprog
	Mset	dcregister,gameobjstruct
	jsr	dc_select
	Mindexliststart
	Mindexlist	.demoexit		; (0)
	Mindexlist	demo_stagestart	 	; (1)
	Mindexlist	demo_targetcount 	; (2)
	Mindexlist	demo_gameclearobj	; (3)
	Mindexlist	demo_enemygone		; (4)



.demoexit	rts

;--------------------------------------------------------------------



;********************************************************************
;		************************************************
; enemygone		************************************************
;		************************************************
;********************************************************************



demo_enemygone
	jsr	dc_program
	dwstart
	dwwait	2
	dwnext	gone_init
	dwstop	gone_main

;********************************************************************
gone_init
	jsr	Init_objlist
	Mobjinit 0,ys_enemygone,xxoamset,88h,70h
	rts

;********************************************************************

gone_main	jmp	Main_OBJ
	

;********************************************************************

xxoamset	ldx	register
	lda	_objlimit,x
	inc	a
	inc	a
	cmp	#40
	bcs	.skip
	sta	_objlimit,x
.skip	jmp	Newoamset

;********************************************************************

;
;
;
;
;
;
;********************************************************************
;		************************************************
; corneria bomb	************************************************
;		************************************************
;********************************************************************


set_bombcorneria

;--------------------------------------------------

		
	km_bitcheckmismapflag	attackcorneria
	bne	.entry

.exit	lda	#0
	sta.l	corneria_bombanime	; animation reset
	rts

;--------------------------------------------------
.entry
	lda.l	meterswitch
	beq	.exit
	lda.l	corneria_bombanime	; counter inc
	inc	a
	cmp	#4*3
	bcc	.set
	lda	#1
.set	sta.l	corneria_bombanime

	asl	a
	asl	a
	tax				; INDEX

	lda.l	bombdatatable+2,x	; ROM pointer
	tay
	lda.l	bombdatatable+0,x	; position
	jmp	common_oamset		; (RTS)

;--------------------------------------------------

bombdatatable
	dw	1e1dh,.data_3&WM
	dw	1e1dh,.data_0&WM
	dw	1e1dh,.data_1&WM
	dw	1e1dh,.data_2&WM

	dw	2228h,.data_3&WM
	dw	2228h,.data_0&WM
	dw	2228h,.data_1&WM
	dw	2228h,.data_2&WM

	dw	2c22h,.data_3&WM
	dw	2c22h,.data_0&WM
	dw	2c22h,.data_1&WM
	dw	2c22h,.data_2&WM

;--------------------------------------------------

.data_0	MSoam_small	1
	db	-4,-4,0a8h,30h
.data_1	MSoam_big	1
	db	-8,-8,0c8h,30h
.data_2	MSoam_big	1
	db	-8,-8,0cah,30h
.data_3	db	0	
	
;--------------------------------------------------





;********************************************************************
;		************************************************
; demo_gameclearobj	************************************************
;		************************************************
;********************************************************************
demo_gameclearobj
	jsr	dc_program
	dwstart
	dwwait	20
	dwflag	clearobj_1

;---------------------------------------------------------------------
clearobj_1

	Moff_objmeter

	lda	sprite_register
	pha

;---------------------------------------------

	ldy	#obj_cleartime&WM	; << TIME MESSAGE >>
	lda	#06838h
	jsr	common_oamset

	ldx	dcregister		; << TIME DATA >>
	lda	_dccounter,x

	lda.l	kw_gametimer
	jsr	dec_00_65535

	ldy	#068a0h
	lda	Xwork0
	jsr	WOBJ_three

	ldy	#070bch	
	lda	#34ceh			; S character
	jsr	OBJ_set

;---------------------------------------------

	ldy	#obj_clearscore&WM	; << SCORE MESSAGE >>
	lda	#8450h
	jsr	common_oamset

	ldx	dcregister
	lda	_dccounter,x		; << SCORE DATA >>

	lda.l	kw_totalscore1
	jsr	dec_00_65535

	ldy	#8488h			; display score position
	lda	Xwork1			; display score number
	jsr	OBJ_digit
	lda	Xwork0			; display score number
	jsr	OBJ_word

;---------------------------------------------
;; obj display 
;---------------------------------------------

	plx				; << start sprite pointer
	ldy	dcregister
	lda.w	_dccounter,y
	cmp	#003fh
	bcs	.exit
	asl	a
	tay
	jsr	Lanime_objerace

.exit
	rts





;********************************************************************
;		************************************************
; DISP BIG TARGET	************************************************
;		************************************************
;********************************************************************

demo_targetcount
	jsr	dc_program
	dwnext	init_gametarget
	dwloop	24,main_gametarget
	dwstop	exit_gametarget

;---------------------------------------------------------------------

init_gametarget
	jsr	Init_objlist
      	Mobjinit 0,ys_big0,oamset_gametarget,080h,30h
	rts

;---------------------------------------------------------------------
oamset_gametarget
	jmp	Newoamset

;---------------------------------------------------------------------
main_gametarget
	lda.w	_dccounter,y
	lsr	a
	lsr	a
	lsr	a
	bcc	.exit

 	lda	KEnemyNumber
	and	#00ffh
	cmp	#10
	bcc	.skip
	lda	#0
.skip	clc
	adc	#ys_big0
 	Mobjanime 0
	

	jsr	Main_OBJ

.exit	rts

;---------------------------------------------------------------------
exit_gametarget
	stz	gameobjstruct
	rts


;********************************************************************
;		************************************************
; STAGE START	************************************************
;		************************************************
;********************************************************************

demo_stagestart
	jsr	dc_program
	dwstart
	dwwait	16/2
	dwnext	init_stageready
	dwloop	20h,main_stageready
	dwend	

;---------------------------------------------------------------------

init_stageready
	jsr	Init_objlist
      	Mobjinit 0,ys_ready4,oamset_stagestart,080h,70h
      	Mobjinit 1,ys_ready3,oamset_stagestart,080h,70h
      	Mobjinit 2,ys_ready2,oamset_stagestart,080h,70h
      	Mobjinit 3,ys_ready1,oamset_stagestart,080h,70h
      	Mobjinit 4,ys_ready0,oamset_stagestart,080h,70h

	rts
;---------------------------------------------------------------------
oamset_stagestart	

	jsr	moveXY
	jmp	Newoamset

;---------------------------------------------------------------------
main_stageready
	jsr	Main_OBJ
	rts

;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;********************************************************************
;	--------------------
;	* LIBRARY PROGRAMS *
;	--------------------
;********************************************************************



;********************************************************************
;	sprite erase Animation
;********************************************************************
;
; X reg		= sprite buffer pointer
; Y reg		= skip obj count
; sprite_register	= NOW sprite pointer
;
;--------------------------------------------------------------------
anime_objerace_loop
	dey
	bpl	.skip
	lda	#0e0e0h
	sta.l	sprites,x
.skip
	inx
	inx
	inx
	inx
Lanime_objerace
	cpx	sprite_register
	bcc	anime_objerace_loop

	rts

;---------------------------------------------


;********************************************************************
;	gamemode select index jump
;********************************************************************
;
; x = data address
; y = total counter
;
;--------------------------------------------------------------------

Lgamemode_idxjmp
.loop	lda.l	Lgamemode_idxjmp&0ff0000h,x
	and	#00ffh
	cmp	kw_GameMode
	beq	.entry
	inx
	inx
	inx
	dey
	bne	.loop
	rts
.entry	jmp	(1,x)

;====================================================================
;====================================================================
;	gamobj END 
;====================================================================
;====================================================================
;;
;;
;;
;;
;;
;;
;*********************************************************************
;	----------------------------
;	* game parameter initalize *
;	----------------------------
;*********************************************************************
;
; clear game parameter 	
;
;    -------------------------------------------	
;     map initial yori mo mae de okonau koto !!
;    -------------------------------------------
;
;---------------------------------------------------------------------

yjparam_gamemode_table
	Mgamemode_liststart
	Mgamemode_list	kmode_initmission,yjparam_game
	Mgamemode_list	kmode_initbattle,yjparam_battle
	Mgamemode_list	kmode_title,yjparam_title
	Mgamemode_list	kmode_missionexplain,yjparam_explain
	Mgamemode_list	kmode_missiongameover,yjparam_gameover
	Mgamemode_list	kmode_missioncontinue,yjparam_continue
	Mgamemode_listend	yjparam_tabletotal

;---------------------------------------------------------------------

clear_YJgameparam_l
	Mbank7e
	php
	ai16

	jsr	clear_triggermessage	; trigger all clear !!

	stz	pepper_message		; now messageNo clear !!
	stz	gameclear_flag		; gameclear OFF

	lda	#0			; raster parameter
	sta.l	raster_control		; control OFF
	ldx	#4
.loop	sta.l	raster_amp,x
	sta.l	raster_freq,x
	sta.l	raster_speed,x
	sta.l	raster_counter,x
	dex
	dex
	bpl	.loop

;-------------------------------------------------------------

	ldx	#yjparam_gamemode_table&WM
	ldy	#yjparam_tabletotal&WM
	jsr	Lgamemode_idxjmp

;-------------------------------------------------------------
	plp
	Mbankrtl

;--------------------------------------------------------------------
;
;********************************************************************
;	[continue]
;********************************************************************
;********************************************************************
;	[gameover]
;********************************************************************
yjparam_continue
yjparam_gameover
;;;;;	lda	#idx_reset_raster
;;;;;	sta.l	raster_control
	rts

;********************************************************************
;	[title]
;********************************************************************
yjparam_title
	rts

;********************************************************************
;	[explain]
;********************************************************************
yjparam_explain
	lda	#idx_explain_raster
	sta.l	raster_control
	rts

;********************************************************************
;	[battle]
;********************************************************************
yjparam_battle
	rts

;********************************************************************
;	[game]
;********************************************************************
yjparam_game
	lda.l	KGameMapPtr
	cmp	#(mapraster_end-mapraster_table)
	bcs	.exit
	tax
	lda.l	mapraster_table,x
	and	#0ffh
	sta.l	raster_control
.exit	rts
;---------------------------------------------------------------------
mapraster_table
	db	idx_no_raster	; (00) planet 0
	db	idx_no_raster	; (01) planet 1
	db	idx_no_raster   ; (02) planet 2
 	db	idx_no_raster 	; (03) planet 3
	db	idx_no_raster   ; (04) planet 4
	db	idx_sea_raster  ; (05) planet 5
	db	idx_no_raster   ; (06) planet 6
mapraster_end equ	*

;********************************************************************
;	[LIBRARY]	game initialize
;********************************************************************

;----------------
; message init
;----------------
clear_gamemessage
	lda	#0
	sta.l	pepper_message

	rts

;====================================================================
;====================================================================
; END END END END END END END END END END END END END END END END END
;====================================================================
;====================================================================
































