alldispscore = 0
;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: gamover.asm				*
;* 	Description	: Gameover SEQ				*
;*	Date		: 1994.7.15				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  gameover
;---------------------------------------------------------------------

overstruct	equ	bgdemo_switch

;---------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;	Gameover Display Parameter
;*********************************************************************
;---------------------------------------------------------------------
;	gameover score
;---------------------------------------------------------------------
overscore_startX	equ	08h
overscore_startY	equ	80h
overscore_height	equ	0fh
;---------------------------------------------------------------------
;	partner continue select
;---------------------------------------------------------------------
partnercontinue_obj	equ	3025h+80h
	ifne	janglish
partnercontinue_pX	equ	30h
	elseif
partnercontinue_pX	equ	50h
	endc

partnercontinue_pY	equ	90h
partnerfaceX		equ	partnercontinue_pX-28h
partnerfaceY		equ	92h
partnercontinue_size	equ	0eh
;---------------------------------------------------------------------
;	game retry/title select
;---------------------------------------------------------------------
retryselect_pX	equ	60h
retryselect_pY	equ	90h
retryselect_size	equ	10h
;---------------------------------------------------------------------

scoredisp_demotime	equ	8

;===================================================================






********************************************************************
;	dmmy
;********************************************************************
gameover_l
gameover_process_l
	rtl

;********************************************************************
;	gameover initialize
;********************************************************************
gameover_init_l
	Mbankprog
	php
	ai16

	Mset	overstruct,idx_gameover_demowait
	MsetL	gameover_scorepointer,0

	stz	gameover_flag		; trigger wait flag
	stz	gameover_dispflag	; display control flag

	plp
	Mbankrtl

;********************************************************************
;	gameover main
;********************************************************************
gameover_obj_l
	Mbankprog
	php			; >
	ai16
	sty	sprite_register	;  >>

	jsr	gameover_program

	ldy	sprite_register	;  <<
	plp			; <
	Mbankrtl	

;--------------------------------------------------------------------
              ;
;
;
;
;
;
;
;
;********************************************************************
;	---------------------
;	 gameover chart table
;	---------------------
;********************************************************************

gameover_program

	ldx	#overstruct
	stx	dcregister
	jsr	dc_select
	Mindexliststart	
	Mindexlist	gameover_exit
	Mindexlist	gameover_demowait
	Mindexlist	gameover_partnercontinue
	Mindexlist	gameover_retrycheck

;********************************************************************
;	exit
;********************************************************************
gameover_exit
	rts

;********************************************************************
;	-------------------
;	 gameover demowait
;	-------------------
;********************************************************************

gameover_demowait
	jsr	dc_program
	dwflag	demowait_wait
	dwflag	demowait_scoredispdemo
	dwflag	demowait_scoredisp
	dwstop	demowait_SEQselect

;--------------------------------------------------------------------
demowait_wait
	tyx

	ifne	alldispscore
	dec	_dcflag,x	; ALLWAYS NEXT
	endc

	lda	gameover_flag
	beq	.exit
	dec	_dcflag,x

	a8
	kbgm	continue
	a16

.exit	rts

;--------------------------------------------------------------------
demowait_scoredispdemo
	tyx

	Mbitset	gameover_dispflag,ON_gameover_score

	lda	_dccounter,x
	sta.l	gameover_scorepointer
	cmp	#scoredisp_demotime*4
	bcs	.next

	bra	.exit
;;;;	lda	trig0		; IF KEY SPEED UP
;;;;	and	#button_ok
;;;;	beq	.exit


.next	dec	_dcflag,x	; next process

.exit	rts

;--------------------------------------------------------------------
demowait_scoredisp

	tyx
	lda	#100
	sta.l	gameover_scorepointer

	lda	trig0
	and	#button_ok
	beq	.exit

	dec	_dcflag,x

	ksound	kettei

.exit	rts

;--------------------------------------------------------------------
demowait_SEQselect

	ifeq	1
	km_bitcheckmistotalflag	destcorneria
	bne	.corneria_over
	endc

	lda	player_friend
	bmi	.player_over

;--------------------------------------------------------------------
.continue
	Mbitclr	gameover_dispflag,ON_gameover_score
	Mset	overstruct,idx_gameover_partnercontinue
	rts

;--------------------------------------------------------------------
.player_over
.corneria_over

	Mset	overstruct,idx_gameover_retrycheck
	rts

;--------------------------------------------------------------------
;
;
;********************************************************************
;	------------------------
;	 partner continue check
;	------------------------
;********************************************************************
_continue_status	equ	_dcwork+0
;--------------------------------------------------------------------
Mcursor_moveset	macro	[ramaddr,max]
	ldx	dcregister
	ldy	{ramaddr},x
	lda	#{max}
	jsr	Moveupdown
	sty	{ramaddr},x

;;;;	tya
;;;;	asl	a
;;;;	tax
;;;;	ldy	{romaddr}&WM,x
;;;;	lda	#{object}
;;;;	jsr	OBJ_set

	endm

;--------------------------------------------------------------------
gameover_partnercontinue

	jsr	dc_program
	dwnext	pcont_init
	dwstop	pcont_main

;--------------------------------------------------------------------
pcont_init
	tyx
	stz	_continue_status,x
	Mbitset	gameover_dispflag,ON_gameover_partner
	rts

;--------------------------------------------------------------------
pcont_main

	Mcursor_moveset	_continue_status,2
	
	lda	trig0
	and	#button_ok
	beq	.exit
	
	ksound	kettei

	ldx	dcregister
	lda	_continue_status,x
	bne	.no

;--------------------------------------------------------------------
.yes

	lda	#-1			; friend wo clear suru.
	sta	player_friend

	km_clrmismapflag	all		 	;[missionmap flag]
	km_setmistotalflag	partner1		;[missiontotal flag]
	km_clrmistotalflag	playerdown
	km_clrmistotalflag	initialmap
    
	km_bitcheckmistotalflag	finalbossbattle		;[missiontotal flag]
	bne	.finalboss
.normal
	km_settmpgamemode	selectmissionmap	;[game mode]
	bra	.common
.finalboss
	km_settmpgamemode	initmission		;[game mode]
;* player type *
	a8
	km_setvar	p1_pilotNo,p2_pilotNo
	a16
;* player HP *
	jsl	playerstatus_init_l
;* flags *
	km_clrmistotalflag	partner1
.common
	km_setgamesyori		rts			;[game syori]
	bra	.exit

;--------------------------------------------------------------------
.no
	Mset	overstruct,idx_gameover_retrycheck
	km_clrmismapflag	all		 	;[missionmap flag]

;--------------------------------------------------------------------
.exit
	rts

;********************************************************************
;	------------------------
;	 retry / title
;	------------------------
;********************************************************************
retry_obj		equ	3025h+80h
retry_pX		equ	40h
retry_pY		equ	90h
;===================================================================

gameover_retrycheck

	jsr	dc_program
	dwnext	gameretry_init
	dwstop	gameretry_main

;********************************************************************
;	initialize
;********************************************************************
_retry_status	equ	_dcwork+0
;--------------------------------------------------------------------

gameretry_init
	tyx
	stz	_retry_status,x

	Mbitclr	gameover_dispflag,ON_gameover_score
	Mbitclr	gameover_dispflag,ON_gameover_partner
	Mbitset gameover_dispflag,ON_gameover_retry

	rts

;********************************************************************
;	main
;********************************************************************

gameretry_main

;-------------------------------------------
; BITMAP PROGRAM SET
;-------------------------------------------

	Mcursor_moveset	_retry_status,2

;-------------------------------------------
; SEQ check
;-------------------------------------------

	ldx	dcregister
	lda	trig0
	and	#button_ok
	beq	.exit

	ksound	kettei

	lda	_retry_status,x
	bne	.title

;-------------------------------------------
; RETRY GAME
;-------------------------------------------
.retry
	km_clrmistotalflag	all		;[missiontotal flag]	
	km_setmistotalflag	retry		;[missiontotal flag]
;;;;	km_setmistotalflag	random		;[missiontotal flag]
	km_settmpgamemode	selectmissionplayer
	km_setgamesyori		rts		;[game syori]
	bra	.exit

;-------------------------------------------
; TITLE RETURN
;-------------------------------------------
.title
	km_clrmistotalflag	all
	km_settmpgamemode	end
	km_setgamesyori		rts		;[game syori]

;-------------------------------------------
.exit	
	rts


;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;=======================================================================
;=======================================================================
;=======================================================================
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;*********************************************************************
;	---------------------
; 	 BITMAP DRAW PROGRAM 
;	---------------------
;*********************************************************************

bitmapdemo_gameover

	lda	player_friend
	sta.l	m_partnernumber

	ldx	#gameover_dispdata&WM	; ROM data
	ldy	#gameover_dispflag	; RAM address
	jsr	bitBjsrprogram

	rts

;--------------------------------------------------------------------
gameover_dispdata
	MbitBjsrdata	ON_gameover_partner,disp_gameover_partner
	MbitBjsrdata	ON_gameover_score,disp_gameover_score
	MbitBjsrdata	ON_gameover_retry,disp_gameover_retry
	MbitBjsrdataend

;--------------------------------------------------------------------



;*********************************************************************
;	display gameover partner
;*********************************************************************
disp_gameover_partner

	a8
	poll_mario
	a16

	ldx	#bitmapmes_partnerselect&WM
	jsr	Draw_bitmapmessage

	a8
	unpoll_mario
	a16

	rts

;*********************************************************************
;	display gameover score
;*********************************************************************
disp_gameover_score

	a8
	poll_mario
	a16

	jsr	display_overmessage

	a8
	unpoll_mario
	a16

	rts

;*********************************************************************
;	display gameover score
;*********************************************************************
disp_gameover_retry

	a8
	poll_mario
	a16

	ldx	#bitmapmes_retryselect&WM
	jsr	Draw_bitmapmessage

	a8
	unpoll_mario
	a16

	rts

;*********************************************************************
;	----------------
;	 clear program
;	---------------
;*********************************************************************
;
; overpointer = 0 		ERACE
; 	   1,2,3
;	   4		ALL 
;
;---------------------------------------------------------------------

display_overmessage

;------------------------------------------------------------------
					;---------------------
	jsr	score_messageINIT	; message initialize |
					;---------------------
;------------------------------------------------------------------

	lda.l	gameover_scorepointer
;;	cmp	#scoredisp_demotime*2
;;	bcc	.scoreCLS
	cmp	#scoredisp_demotime*1
	bcc	.score1
	cmp	#scoredisp_demotime*2
	bcc	.score2
	cmp	#scoredisp_demotime*3
	bcc	.score3

;---------------------------------------------------------------------
.score4
	ldx	#score_gameover4&WM
	jsr	Draw_bitmapmessage
.score3
	ldx	#score_gameover3&WM
	jsr	Draw_bitmapmessage
.score2
	ldx	#score_gameover2&WM
	jsr	Draw_bitmapmessage
.score1
	ldx	#score_gameover1&WM
	jsr	Draw_bitmapmessage
.scoreCLS
	rts

;*********************************************************************
;	DATAS
;*********************************************************************


;---------------------------------------------------------------------
;	RETRY SELECT
;-------------------------------------------------------------------

bitmapmes_retryselect

	Mscore_messageINIT

	Mscore_start65816
		lda	_retry_status+overstruct
		ora	#retryselect_size*256
		jsr	mult_u8u8
		clc
		adc	#retryselect_pY
		sta.l	m_y1
		lda	#retryselect_pX-14
		sta.l	m_x1
	Mscore_end65816

	Mscore_setcolor		REDfrash
	Mscore_dispmessageonly	174

	Mscore_setB_m_xy	retryselect_pX,retryselect_pY+00h
	Mscore_setcursorcolor2	_retry_status+overstruct,0
	Mscore_dispmessageonly	159
	Mscore_setB_m_xy	retryselect_pX,retryselect_pY+retryselect_size
	Mscore_setcursorcolor2	_retry_status+overstruct,1
	Mscore_dispmessageonly	160
	Mscore_exit

;---------------------------------------------------------------------
;	PARTNER SELECT
;-------------------------------------------------------------------

bitmapmes_partnerselect

	Mscore_partnerface

	Mscore_messageINIT

	Mscore_start65816
		lda	_continue_status+overstruct
		ora	#partnercontinue_size*256
		jsr	mult_u8u8
		clc
		adc	#partnercontinue_pY+10h
		sta.l	m_y1
		lda	#partnercontinue_pX+30h-14
		sta.l	m_x1
	Mscore_end65816

	Mscore_setcolor		REDfrash
	Mscore_dispmessageonly	174

	Mscore_setB_m_xy	partnercontinue_pX,partnercontinue_pY
	Mscore_dispmessageNo	156,WHITEcolor
	Mscore_setB_m_xy	partnercontinue_pX+30h,partnercontinue_pY+10h
	Mscore_setcursorcolor2	_continue_status+overstruct,0
	Mscore_dispmessageonly	157
	Mscore_setB_m_xy	partnercontinue_pX+30h,partnercontinue_pY+10h+partnercontinue_size
	Mscore_setcursorcolor2	_continue_status+overstruct,1
	Mscore_dispmessageonly	158

	Mscore_exit

;---------------------------------------------------------------------
;	GAMEOVER SCORE DISPLAY MESSAGE
;---------------------------------------------------------------------

score_gameover1

	Mscore_setB_m_xy	overscore_startX,overscore_startY
	Mscore_dispmessage	destroy,WHITEcolor
	Mscore_addB_m_x1	70h
	Mscore_setB_m_y1	overscore_startY

	Mscore_start65816
		lda.l	kx_initenemytotal
		sec 
		sbc.l	kx_clrenemytotal
		sta.l	gameover_score
	Mscore_end65816

	Mscore_dispdecimal	gameover_score,BLUEfrash
	Mscore_addB_m_x1	8
	Mscore_dispmessage	outof,WHITEcolor
	Mscore_addB_m_x1	38h
	Mscore_setB_m_y1	overscore_startY
	Mscore_dispdecimal	kx_initenemytotal,BLUEfrash
	Mscore_exit

;---------------------------------------------------------------------
score_gameover2

	Mscore_setB_m_xy	overscore_startX,overscore_startY+overscore_height*1
	Mscore_dispmessage	mes,WHITEcolor
	Mscore_exit

;---------------------------------------------------------------------

score_gameover3
	Mscore_setB_m_xy	overscore_startX,overscore_startY+overscore_height*2
	Mscore_dispmessage	cdamage,WHITEcolor

	Mscore_setB_m_xy	overscore_startX+0a0h,overscore_startY+overscore_height*2
	Mscore_dispdecimal	kx_CorneriaDamage,REDfrash

	Mscore_dispmessageNO	153,WHITEcolor

	Mscore_exit

;---------------------------------------------------------------------

score_gameover4
	Mscore_setB_m_xy	overscore_startX,overscore_startY+overscore_height*3
	Mscore_dispmessage	score,WHITEcolor

	Mscore_setB_m_xy	overscore_startX+0a0h,overscore_startY+overscore_height*3
	Mscore_dispdecimal	kw_totalscore1,BLUEfrash

	Mscore_exit


;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;=======================================================================
;=======================================================================
;=========== library's =================================================
;=========== library's =================================================
;=======================================================================
;=======================================================================
;;;
;;;
;;;
;***********************************************************************
;	Move Cursor
;***********************************************************************
;
; A register = MAX parameter
; Y register = data
;
; temp-work use
;-----------------------------------------------------------------------
temp1	equ	Xwork6	; library work
temp2	equ	Xwork7	; library work
;-----------------------------------------------------------------------

Moveupdown	dec	a
	sta	temp1
	lda	trig0
	bit	#button_up+button_down
	beq	.exit
	bit	#button_up
	beq	.down
;------------------------------------------------
	dey
	bmi	.exit
	ksound	cursor	; cursor move !!!
	bra	.exit
;------------------------------------------------
.down	cpy	temp1
	bcs	.skip
	iny
	ksound	cursor	; cursor move !!!
	bra	.exit
;------------------------------------------------
.skip	ldy	temp1
.exit	rts
;------------------------------------------------
;
;
;
;
;
;***********************************************************************
;	Move Cursor
;***********************************************************************
; 8bit multiply
; < input  > A register low byte * A register high byte
; < output > A register lowhigh
;-------------------------------------------------------------------
mult_u8u8	sta	4202h
	pha		; wait 4 cycle
	pla		; wait 4 cycle
	nop		; wait 2 cycle
	lda	4216h
	rts


;======================================================================
;======================================================================
;; end end end end end end end end end end end end end end end end end
;======================================================================
;======================================================================


