;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: hell.asm				*
;* 	Description	: BG screen demo program		*
;*			; heaven <-> hell switch demo		*
;*			; boss entry demo			*
;*	Date		: 1994.7.25				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  hell
;---------------------------------------------------------------------
;
;---------------------------------------------------------------------
this_bank	=	*&$ff0000
;---------------------------------------------------------------------
;
;
;
;
;*********************************************************************
;
;*********************************************************************


Msoundfadeout macro
	php
	a8i16
	kbgm	FadeOut
	longi
	longa	
	plp
	endm	

Msoundheaven macro
	php
	a8i16
	kbgm	heaven
	longi
	longa	
	plp
	endm	

Msoundhell	macro
	php
	a8i16
	kbgm	hell
	longi
	longa	
	plp
	endm	


;*********************************************************************
;*********************************************************************
; heaven <-> hell dc work 
;*********************************************************************


;---------------------------------------------------------------------



	longa
	longi
;=====================================================================
;=====================================================================
;===========	HELL <-> HEAVEN DEMO ====================================
;===========	HELL <-> HEAVEN DEMO ====================================
;=====================================================================
;=====================================================================
;*********************************************************************
; 	heaven <-> hell switch demo initial
;*********************************************************************

init_hell_l	
	Mbank7e


	lda	#0
	sta.l	raster_Vswitch



	ldx	#bgdemo_switch&xx
	stx	dcregister
	stz	_dcinput,x

	stz	hellswitch
	


	Mbankrtl

;*********************************************************************
; 	heaven <-> hell switch demo main
;*********************************************************************

hell_l	
	jsr	debug_display	; ROM debug display
	jsr	test_trigger	; ROM debug trigger
	
	Mbank7e

	ldx	#bgdemo_switch&xx
	stx	dcregister
	jsr	helldemo_entry

	Mbankrtl

;*********************************************************************
; 	heaven <-> hell switch demo IRQ(NMI)
;*********************************************************************

irq_hell_l	
	a8
	lda	#81h
	sta.l	Screen_step
	phb
	lda	#bank7eRAM>>16
	pha
	plb
	a16
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
	jsr	draw_left
	jsr	draw_right
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
	plb
	rtl

;=======================================================================
;
;
;
;
;
;*********************************************************************
; 	IRQ(NMI) program
;*********************************************************************

draw_left
	ldx	dcregister
	lda	dcwdoor1
	jsr	drawvram
	ldx	dcregister
	lda	dcwdoor1
	inc	a
	and	#1fh
	sta	dcwdoor1
	rts

;---------------------------------------------------------------------

draw_right
	ldx	dcregister
	lda	dcwdoor2
	jsr	drawvram
	ldx	dcregister
	lda	dcwdoor2
	dec	a
	and	#1fh
	sta	dcwdoor2
	rts

;---------------------------------------------------------------------
;
; X = draw pointer
;
;--------------------------------------------

drawvram
	tay
	clc
	adc	#5c00h		; BG2 address
	sta.l	Screen_address	; ---- VRAM-address
;--------------------------------------------
	tya
	asl	a
	adc	dcwdraw
	tax			; (X) = ROM address
;--------------------------------------------
	clc
	ldy	#32		; total screen char
.loop	lda.w	0,x
	sta.l	Screen_write
	txa
	clc
	adc	#64
	tax
	dey
	bne	.loop
	rts

;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
; 	heaven <-> hell switch demo
;*********************************************************************

helldemo_entry
	jsr	check_helldemo

	jsr	dc_select
	dwcode	demo_nothing	; (0)
	dwcode	map1_bossdemo	; (1)
	dwcode	map2_bossdemo	; (2)
	dwcode	map3_bossdemo	; (3)
	dwcode	map4_bossdemo	; (4)
	dwcode	map5_bossdemo	; (5)
	dwcode	map6_bossdemo	; (6)
	dwcode	hell_open	; (7)
	dwcode	hell_close	; (8)


;*********************************************************************
; 	check hell <<->> heaven change demo
;*********************************************************************

check_helldemo

	lda	KgameMapPtr
	and	#00ffh
	cmp	#3		; hell map only
	bne	.exit

	ldx	#bgdemo_switch&xx

	lda	KenemyNumber
	and	#00ffh
	cmp	#hellchange_count	; = 5
	beq	.hellmode
	cmp	#hellchange_count+1	; = 6
	beq	.heavenmode
	rts

;---------------------------------------------------------------------

.heavenmode	
	lda	hellswitch
	beq	.exit
	lda	#8		; hell -> heaven
	sta	_dcinput,x
	stz	hellswitch
	bra	.exit

;---------------------------------------------------------------------

.hellmode	
	lda	hellswitch
	bne	.exit
	lda	#7		; heaven -> hell
	sta	_dcinput,x
	sta	hellswitch
;---------------------------------------------------------------------

.exit	rts	



;*********************************************************************
;		*************************************************
; demo_nothing	*************************************************
;		*************************************************
;*********************************************************************

demo_nothing
	rts

;*********************************************************************
;		*************************************************
; map1 bossdemo	*************************************************
;		*************************************************
;*********************************************************************

map6_bossdemo
map5_bossdemo
map4_bossdemo
map3_bossdemo
map2_bossdemo
map1_bossdemo

	lda	KgameMapPtr
	and	#0ffh
	beq	.entry
	tyx
	stz	_dcinput,x
	rts

;-----------------------------------------------
.entry	jsr	dc_program
	dwnext	init_boss1
	dwloop	16*2-1,change_color0
	dwnext	start_vzoom
	dwloop	16*2-1,change_color1
	dwwait	30		; <===== debug wait
	dwnext	exit_boss1
	dwend
;---------------------------------------------------------------------


;*********************************************************************
;	boss zoom SEQ
;*********************************************************************

init_boss1	
	jmp	dc_reset

;---------------------------------------------------------------------

exit_boss1	lda	#voffsetflag_p1off	; ON Voffset
	trb	voffsetflag
	rts

;---------------------------------------------------------------------

change_color0

	lda.w	_dccounter,y
	asl	a
	asl	a
	asl	a
	and	#00e0h
	clc				; color buffer pointer
	adc	democolor_pointer	; heap data pointer
	tax
	ldy	#kx_palette&xx		; color buffer address
;---------------------------------------------
	lda	#16
	sta	Xwork0
.loop	lda.w	heap+400h,x		
	sta.w	4*32,y
	inx
	inx
	iny
	iny
	dec	Xwork0
	bne	.loop
;---------------------------------------------
	lda	#16
	sta	Xwork0
	ldx	democolor_pointer
	ldy	#kx_palette&xx		; color buffer address
.loop2	lda.w	heap+200h,x		
	sta.w	5*32,y
	inx
	inx
	iny
	iny
	dec	Xwork0
	bne	.loop2
;---------------------------------------------

	rts

;---------------------------------------------------------------------

start_Vzoom

	lda	#voffsetflag_p1off	; <= timming 
	tsb	voffsetflag

	lda	#1
	sta.l	raster_Vswitch
	lda	#(16*2-1)*64
	sta.l	raster_Vadd
	lda	#0e0h
	sta.l	raster_Vcenter

	rts


;---------------------------------------------------------------------

change_color1

	jsr	map1bosscolor

	lda.w	_dctimer,y
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	sta.l	raster_Vadd


	lda.w	_dccounter,y
	cmp	#17
	bcs	.skip1
	sec	
	lda	#17 
.skip1	sbc	#16
	asl	a

	asl	a
	asl	a
	asl	a
	asl	a
	and	#01e0h
	clc				; color buffer pointer
	adc	democolor_pointer	; heap data pointer
	tax
	ldy	#kx_palette&xx		; color buffer address
;---------------------------------------------
	lda	#16
	sta	Xwork0
.loop	lda.w	heap,x		
	sta.w	4*32,y
	lda.w	heap+200h,x
	sta.w	5*32,y
	inx
	inx
	iny
	iny
	dec	Xwork0
	bne	.loop
;---------------------------------------------

	rts

;---------------------------------------------------------------------

map1bosscolor
	phy

	a8
	lda	#gamepal_night
	km_setgamepal
	a16
	setdepth	night
	ply
	rts

;---------------------------------------------------------------------







;*********************************************************************
;		*************************************************
; heaven -> hell	*************************************************
;		*************************************************
;*********************************************************************

hell_open	
	lda	#0		; debug
	sta.l	kx_palette+1eh	; debug
;---------------------------------------------------------------------
	jsr	dc_program
	dwnext	open_rasterreset
	dwloop	10,xhell_start
	dwnext	xhell_start2
	dwloop	29,xhell_start
	dwnext	xhell_stop2
	dwloop	39,xhell_stop
;;;;;;	dwwait	127
	dwstop	xhell_exit
;---------------------------------------------------------------------


;*********************************************************************
;		*************************************************
; hell -> heaven	*************************************************
;		*************************************************
;*********************************************************************





;*********************************************************************
;*********************************************************************

hell_close	jsr	dc_program
	dwnext	close_rasterreset
	dwloop	10,xheaven_start
	dwnext	xheaven_start2
	dwloop	29,xheaven_start
	dwnext	xheaven_stop2
	dwloop	39,xheaven_stop
;;;;;	dwwait	127
	dwstop	xheaven_exit

;*********************************************************************
;	hell -> heaven
;*********************************************************************

startwait	jmp	dc_reset

;--------------------------------------------------------------------- 

open_rasterreset	
close_rasterreset
	jsr	dc_reset
	lda	#0  
	sta.l	raster_amp
	sta.l	raster_freq
	sta.l	raster_speed
	rts

;---------------------------------------------------------------------

xhell_start2
xheaven_start2
	Msoundfadeout
xheaven_start
	lda	heaven_bgpointer
	bra	common_start
xhell_start	
	lda	hell_bgpointer	
common_start	jsr	setcenter	; scroll H center 
	jsr	inc_calc
	rts

;---------------------------------------------------------------------
xheaven_stop2
	Msoundheaven
xheaven_stop
	jsr	dec_calc
	lda	#200
	sta	yj_drawswitch
	rts

xhell_stop2
	Msoundhell
xhell_stop	
	jsr	dec_calc
	lda	#200
	sta	yj_drawswitch
	rts

;---------------------------------------------------------------------

xhell_exit
xheaven_exit	tyx
	stz	_dcinput,x
	rts

;---------------------------------------------------------------------
;
;	lda	#7
;	bra	skipexit
;	lda	#8
;skipexit	tyx
;	sta	_dcinput,x
;	rts
;
;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;---------------------------------------------------------------------
;	center calculation
;---------------------------------------------------------------------

setcenter	tyx
	clc
	adc	#heap&xx
	sta	dcwdraw
	lda.l	player1hscroll
	clc	
	adc	#70h		; bitmap display  center
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	and	#1fh
	sta	dcwdoor1
	sta	dcwdoor2
	rts

;---------------------------------------------------------------------
;	inc calculation
;---------------------------------------------------------------------

inc_calc
	tyx

	lda	dcwfreq
	clc
	adc	dcwfreqadd
	sta	dcwfreq
	xba
	and	#00ffh
	sta.l	raster_freq
	sta.l	raster_amp

	lda	dcwfreqadd
	clc
	adc	#0030h
	sta	dcwfreqadd

	rts	

;---------------------------------------------------------------------
;	dec calculation
;---------------------------------------------------------------------

dec_calc
	tyx

	lda	dcwfreqadd
	sec
	sbc	#0030h
	sta	dcwfreqadd

	lda	dcwfreq
	sec
	sbc	dcwfreqadd
	sta	dcwfreq

	xba
	and	#00ffh
	sta.l	raster_freq
	sta.l	raster_amp

	rts	


;=======================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;***********************************************************************
;;	Game Demo Control System
;***********************************************************************

;---------------------------------------------------------------------

Minc_dccounter	macro
	inc	_dccounter,x
	bne	.\@p1
	dec	_dccounter,x
.\@p1	
	endm

;---------------------------------------------------------------------

dc_select	ldx	dcregister
	lda	_dcinput,x	; input trigger
	beq	.exit
	bmi	.entry
	sta	_dcselect,x	; work initialize
	ora	#8000h		; set flag

	sta	_dcinput,x
	stz	_dcprocess,x	
	stz	_dccounter,x	; timer reset
	stz	_dctimer,x

.entry	sec
	pla
	adc	_dcselect,x
	adc	_dcselect,x
	txy
	tax
	jmp	(0,x)
.exit	pla			
	rts

;---------------------------------------------------------------------

dc_process	pla			
	tyx			; Y = dcregister
	sec
	adc	_dcprocess,x
	adc	_dcprocess,x
	tax
	jmp	(0,x)		; Y = dcregister

;---------------------------------------------------------------------

dc_wait	ldx	dcregister
	ldy	_dctimer,x
	beq	dc_next
	dec	_dctimer,x
	Minc_dccounter
	rts

;---------------------------------------------------------------------

dc_next	ldx	dcregister
	sta	_dctimer,x	; set next timer
	stz	_dccounter,x	; reset next counter
	inc	_dcprocess,x
	rts

;---------------------------------------------------------------------

dc_reset	ldx	dcregister
	stz	_dccounter,x
	stz	_dctimer,x

	lda	#0		; HELL PROGRAM ONLY clear
	sta.l	dcwfreq
	sta.l	dcwfreqadd
	sta.l	dcwdoor1
	sta.l	dcwdoor2
	sta.l	dcwdraw

 	rts

;---------------------------------------------------------------------

dc_init	stx	dcregister	; branking initialize
	bra	dc_initset	
dc_fullreset	
	ldx	dcregister	; endof dc_process
	lda	#0
dc_initset
	sta	_dcinput,x
	stz	_dcselect,x
	stz	_dcprocess,x
	rts

;---------------------------------------------------------------------
; dwwait
;
;
;---------------------------------------------------------------------

dc_program	tyx
	stz	_dcflag,x	; flag reset
	pla
	sec
	adc	_dcprocess,x	; *3 code/address
	adc	_dcprocess,x
	adc	_dcprocess,x
	tax
	lda.l	this_bank+0,x
	and	#00ffh
	beq	.end
	pha			; >>
	lda.l	this_bank+3,x	; 	Y = next timer
	and	#007fh
	pha			;   >>
	jsr	(1,x)		;	 
	ply			;   <<
	pla			; <<
	bit	#80h
	bne	.code

;-------------------------------------

.wait	tya			; next timer
	jmp	dc_wait		; timer wait

;-------------------------------------

.code	and	#0fh
	asl	a
	tax
	jmp	(.process,x)

.process	dwcode	.next		; 80 --> next process
	dwcode	.stop		; 81 --> stop process
	dwcode	.flag		; 82 --> flag process

;-------------------------------------

.end	jmp	dc_fullreset	; --> end  process

;-------------------------------------

.next	tya
	jmp	dc_next	

;-------------------------------------

.stop	ldx	dcregister
	Minc_dccounter
	rts			; --> stop loop

;-------------------------------------

.flag	ldx	dcregister
	Minc_dccounter
	lda	_dcflag,x
	beq	.exit
	tya
	jmp	dc_next

;-------------------------------------

.exit	rts

;---------------------------------------------------------------





;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;=========	DEBUG DISPLAY =============================================
;=========	DEBUG DISPLAY =============================================
;=========	DEBUG DISPLAY =============================================
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------


	include	yjdebug.asm


;====================================================================
;====================================================================
;END END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================


