;*********************************************************************
;*								*
;*		Kawaguchi using Work RAM area			*
;*								*
;*********************************************************************
	alc	kawaguchi,36

;=====================================================================
;*			DEBUG WORK				*
;*7ffff0~7fffff:BUG check WORK					*
;=====================================================================
kbugwork	equ	$7ffff0
kbugbreak	equ	$7ffffe
	alc	checkirq,1
	alc	checkirq1,1
	alc	checkirq2,1
	alc	checkirq3,1
	alc	checkirq4,1
	alc	checkirq5,1

;=====================================================================
;*		GAME Sequence Work				*
;=====================================================================
;--- game sequence ----
	alc	Kw_GameMode,2		;GAME zentai no SEQUENCE Pointer
	alc	kw_TmpGameMode,2	;Game SEQUENCE KARI no RAM
	alc	kw_setbgsaddr,2		;BG    mode address
	alc	kw_setsndaddr,2		;SOUND mode address

;--- game syori ----
	alc	kw_GameSyori,2		;Game Syori no SEQUENCE Pointer
	alc	kw_TmpGameSyori,2	;
	km_labelstart
	km_label	kgamef_rts	;0... rts
	km_label	kgamef_main	;1... main
	km_label	kgamef_pause	;2... pause
	
	ifeq	1
	km_label	kgamef_explain	;1... explain
	km_label	kgamef_gameover	;4... gameover
	km_label	kgamef_training	;5... training
	km_label	kgamef_title	;6... title
	km_label	kgamef_mismap	;7... mission map
	km_label	kgamef_typesel	;8... type select
	km_label	kgamef_swapbg	;9... training bg swapping
	km_label	kgamef_restart	;10... restart
	km_label	kgamef_clear	;11... stage clear
	km_label	kgamef_retmap	;12... return map
	km_label	kgamef_gmovdemo	;13... mission gameover demo
	endc

;--- demo number ---
	alc	kw_DemoNumber,2		;Game Demo Number
	km_gmlabelstart	kdemo,0
	km_gmlabel	nothing,4		;00
	km_gmlabel	titledemo,4		;02
	km_gmlabel	startenemydemo,4	;04
	km_gmlabel	entermshipdemo,4	;06
	km_gmlabel	startarwingdemo,4	;08
	km_gmlabel	gameoverdemo,4		;10
	km_gmlabel	gamecleardemo,4		;12
	km_gmlabel	endingdemo,4		;14
;=====================================================================
;*			GAME Flag Work				*
;=====================================================================
;---- Total Flag ----
	alc	kw_TotalFlag,2
ktof_all	equ	-1
	defflaglist	ktof	;ktof_{flag}
	defflag	battle		;0/1 ... mission/battle

;---- Mission Total Flag ----
	alc	kw_MisTotalFlag,2
kmtof_all	equ	-1
	defflaglist	kmtof	;ktof_{flag}
	defflag	retry		;0/1 ... reset random planet  / retry map
	defflag	partner1	;0/1 ... nothing / partner continue
	defflag	playerdown	;0/1 ... nothing / player down
	defflag	destcorneraia	;0/1 ... nothing / destruction corneria

	defflag	mission		;0/1 ... map game / mission game
	defflag	finalbossbattle	;0/1 ... nothing / final boss appear

;---- GAME Flag ----
	alc	kw_GameFlag,2
kgf_all	equ	-1
	defflaglist	kgf	;kgf_{pointer}

	defflag	battle		;0/1 ... mission/battle
	defflag	freeze		;0/1 ... freeze strategies for demo.
	defflag	kawairq		;0/1 ... normal irq / kawaguchi irq
	defflag	pause		;0/1 ... enable / disable

	defflag	keydisable	;0/1 ... key enable / key disable
	defflag	areaout		;0/1 ... area out nashi / area out ari
	defflag	test		;0/1 ... normal mode /test mode
	defflag	debug		;0/1 ... syori meter OFF/ON

	defflag	score		;0/1 ... score calc
	defflag	fade1		;0/1 ... no fade / fade in
	defflag	plreset		;0/1 ... no reset / player states reset (for kawagoe)

;;;	defflag	syorigae	;0/1 ... Game Sequence ga kawranai/kawaru
;;;;	defflag	gaming		;0/1 ... no game / main game
;;;;	defflag	gameframe	;0/1 ... gameframe1/gameframe2
;;;;	defflag	player		;0/1 ... 1player/2player (For mission)

;--- Game Mission Map Flag ---
	alc	kw_MisPlayerFlag,2
kmiplf_all	equ	-1
	defflaglist	kmiplf		;kmiplf_{pointer}
	defflag		config

;---- Game Mission Map Syori ----
	alc	kw_MisMapSyori,2
	km_gmlabelstart	mmsy,0

	km_gmlabel	normal
	km_gmlabel	explainfinish
	km_gmlabel	missionstart
	km_gmlabel	missionallclear
	km_gmlabel	missiongameover
	km_gmlabel	finalboss
	km_gmlabel	beem

;--- Game Mission Map Flag ---
	alc	kw_MisMapFlag,2
kmimpf_all	equ	-1
	defflaglist	kmimpf		;kmimpf_{pointer}

	defflag		initial		;0/1 ... initial sarete inai / initial sarete iru
	defflag		explain1	;0/1 ... nothoing / do explain
	defflag		expcancel	;0/1 ... normal / explain totyuu cancel
	defflag		missionresult	;0/1 ... fail/success (intro.asm)

	defflag		enemy		;0/1 ... planet / step up,sos,gard
	defflag		replaystart	;0/1 ... nothing / replay start trigger
	defflag		battleplayer	;0/1 ... nothing / Player battle tyuu
	defflag		playernocoll	;0/1 ... nothing / Player No Collision

	defflag		attackcorneria	;0/1 ... nothing / attack corneria
	defflag		asteroid	;0/1 ... nothing / asteroid
	defflag		finalboss	;0/1 ... nothing / final boss appear

;;;	defflag		explodecorneria	;0/1 ... nothing / explode corneria
;;;;	defflag		encountplayer	;0/1 ... nothing / encount player
;;;;	defflag		arriveplanet	;0/1 ... nothing / arrive planet
;;;;	defflag		missionstart	;0/1 ... finish / start (clear)
;;;;	defflag		missionallclear	;0/1 ... planet all clear
;;;;	defflag		missiongameover	;0/1 ... mission game over

;--- 
	alc	kw_MisMapFreezeFlag,2
kfz_all	equ	-1
	defflaglist	kfz
	defflag		timefreeze	;0/1 ... continue / pause
	defflag		syorifreeze	;0/1 ... nothing / syori freeze
	defflag		enemyfreeze	;0/1 ... nothing / enemy stratage stop
	defflag		playerfreeze	;0/1 ... nothing / player stratage stop

	defflag		pausefreeze	;0/1 ... nothing / pause cancell
	defflag		demofreeze	;0/1 ... nothing / demo freeze
	defflag		cursorfreeze	;0/1 ... nothing / cursor freeze
	defflag		bossfreeze	;0/1 ... nothing / boss freeze
;--- Game Mission Map States Flag ---
;Game Sequence ga kawattara Flag wo All Clear suru
	alc	kw_MisMapStateFlag,2
kmimpstf_all	equ	-1
	defflaglist	kmimpstf

	defflag		replay		;0/1 ... nothing / time count up demo (mission finish)
	defflag		complete	;0/1 ... nothing / time count up demo complete
	defflag		hourpast	;0/1 ... 1 hour past
	defflag		finishtrans	;0/1 ... tranfer finish bitmap data

	defflag		speedup		;0/1 ... normal /speed up
	defflag		message		;0/1 ... message display OFF/ON
	defflag		gmframesyori	;0/1 ... syori shinai / do game syori
	defflag		noirqsyori	;0/1 ... irq syori OK /noirq

	defflag		bg1scrtrans	;0/1 ... nothing / screen transfer
	defflag		finalbosstrig	;0/1 ... nothing / final boss appear
	defflag		irqfinish	;0/1 ... finish irq syori / irq wait

;;;	defflag		expdemostart	;0/1 ... wait / explain demo start trigger
;;;	defflag		missionstart	;0/1 ... nothing / start (clear cursor,dest mark)
;;;	defflag		stepupdemo	;0/1 ... no demo / step up demo
;--- Game Mission Flag ---
	alc	kw_MissionFlag,2
kmif_all	equ	-1
	defflaglist	kmif	;kmif_{pointer}
	defflag	ringout		;0/1 ... IN/OUT
	defflag	explain		;0/1 ... nothing/do game explain
	defflag	parallel	;0/1 ... not moving / parallel moving (map enemy strat moving)
	defflag	spriteswap	;0/1 ... normal sprite / pause map sprite
	defflag	enemymove	;0/1 ... Game tyuu wa 2 Game Flame ni 1 kai Parallel suru
	defflag	godemofinish	;0/1 ... Game Over Demo Finish Switch
	defflag	bossappear	;0/1 ... BOSS Appear Switch(Sprite Delete)
	defflag	finalboss	;0/1 ... Fianl Boss Flag

	alc	kw_MissionSyori,2
	km_gmlabelstart	msy,0	;(intro.asm)
	km_gmlabel	normal
	km_gmlabel	returnmap
	km_gmlabel	playerdown
	km_gmlabel	gameover
	km_gmlabel	stageclear
	km_gmlabel	gameclear

;	defflag	stageclear	;0/1 ... Stage Clear Switch
;	defflag	gameoverstart	;0/1 ... Game Over Demo Start  Switch 
;	defflag	playerdown	;0/1 ... Player Down Switch
;	defflag	gameexit	;0/1 ... Game totyuu EXIT
;	defflag	bossdown	;0/1 ... BOSS Down Switch
;	defflag	timeup		;0/1 ... Time Up Switch
;;;	defflag	planet		;0/1 ... shadow / map
;;;	defflag	pause		;0/1 ... OFF/ON

;--- Mission Map Player Demo Sequence ---
	alc	kw_MMPlayerSeq,2
	km_gmlabelstart	plseq,0
	km_gmlabel	nothing,2		;00 ... nothing
	km_gmlabel	enterplanet,2		;02 ... 
	km_gmlabel	escapebattle,2		;04 ...
	km_gmlabel	planetclear,2		;06 ...
	km_gmlabel	enemyclear,2		;08 ...
	km_gmlabel	fianlbossbattle,2	;10 ...

;--- Final Boss Sequence ---
	alc	kw_FinalBossSeq,2
	km_gmlabelstart	fbseq,0
	km_gmlabel	nothing,2		;00 ... nothing
	km_gmlabel	sosdesttrig,2		;02 ... sos enemy destruction trigger ON
	km_gmlabel	sosdestwait,2		;04
	km_gmlabel	wait1,2			;06
	km_gmlabel	bossinittrig,2		;08
	km_gmlabel	bossappeartrig,2	;0a ... final boss appear  trigger ON
	km_gmlabel	bossappeardemo,2	;0c ... final boss appear  demo
	km_gmlabel	playerstart,2		;0xe ... arwing start
	km_gmlabel	battlestart,2		;10 ... final boss battle start

;--- Game Battle Flag ---
	alc	kw_BattleFlag,2
kbtf_all	equ	-1
	defflaglist	kbtf	;kbtf_{pointer}
	defflag	timeup		;0/1 ... do game/time up
	defflag	gameover	;0/1 ... Game do /Game Over
	defflag	p1dead		;0/1 ... alive/dead
	defflag	p2dead		;0/1 ... alive/dead
	defflag	p1pause		;0/1 ... OFF/ON
	defflag	p2pause		;0/1 ... OFF/ON
	defflag	p1ringout	;0/1 ... IN/OUT
	defflag	p2ringout	;0/1 ... IN/OUT
kbtf_p12pauseflag	equ	kbtf_p1pause!kbtf_p2pause

;--- Game Over Flag ---
	alc	kw_GameOverFlag,2
kgof_all	equ	-1
	defflaglist	kgof	;kgof_{pointer}
	defflag	player		;0/1 ... player 1/player 2
	defflag	init
	defflag	fade		;0/1 ... no fade / fade on

;---------------------------------------------------------------------
;*			GAME SCREEN Flags			*
;---------------------------------------------------------------------
	alc	kw_screenflag,2		;screen mode switch
kscf_all	equ	-1
	defflaglist	kscf	; current screen mode
	defflag	hvscroll	;0/1 ... no scroll / scroll
	defflag	bgcolpal	;0/1 ... no change / bg colpal change
	defflag	objcolpal	;0/1 ... no change / sprite colpal change 
	defflag	oamtensou	;0/1 ... buf1 trans(buf2 write) / buf2 trans (buf1 write)

	defflag	sprwbuf		;0/1 ... single buffer / double buffer
	defflag	screenadd	;0/1 ... no screen add  / screen add
	defflag	halfadd		;0/1 ... normal add / halfadd
	defflag	swapbg		;0/1 ... type select / training

	defflag	hvscrollwbuf	;0/1 ... buf1 trans(buf2 write) / buf2 trans (buf1 write)
	defflag	windowwbuf	;0/1 ... buf1 trans(buf2 write) / buf2 trans (buf1 write)
	defflag	wipeopen	;0/1 ... finish wipe / wipe open tyuu
	defflag	wipeclose	;0/1 ... finish wipe / wipe close tyuu

	defflag	normalwipe	;0/1 ... 1p,2p wipe / normal wipe
	defflag	tutumode	;0/1 ... room mode / tutu mode
;---------------------------------------------------------------------------
	alc	kw_spritemode,2
	alc	kw_spritetmpmode,2
	km_spriteptrlist	ksprf		; current screen mode
	km_spriteptr	nosprite
	km_spriteptr	title
	km_spriteptr	mismap
	km_spriteptr	explain
	km_spriteptr	mission
	km_spriteptr	battle
	km_spriteptr 	selectbattlefield
	km_spriteptr	selectbattleplayer
	km_spriteptr	typesel
	km_spriteptr	selectmissionplayer
	km_spriteptr	missionpause
	km_spriteptr	battlepause
	km_spriteptr	missiongameover
	km_spriteptr	missioncontinue

;---------------------------------------------------------------------------
	alc	kw_screenmode,1
	km_screenptrlist	kscmf		; current screen mode
	km_screenptr	noscreen
	km_screenptr	title
	km_screenptr	mission
	km_screenptr	battle
	km_screenptr	explain
	km_screenptr	mismap
	km_screenptr	missiongameover
	km_screenptr	missioncontinue

;=====================================================================
;*								*
;*			GAME  Work				*
;*								*
;=====================================================================
;--- Game Difficulty ---
	alc	Kdifficulty,2		;easy/normal/hard
	km_gmlabelstart	dif,0
	km_gmlabel	easy
	km_gmlabel	normal
	km_gmlabel	hard

;--- GAME Stage ---
	alc	kw_GameStage,1
	km_labelstart	0
	km_label	kgmstf_missionstage1	;0
	km_label	kgmstf_missionstage2	;1
	km_label	kgmstf_missionstage3	;2
	km_label	kgmstf_missionstage4	;3
	km_label	kgmstf_missionstage5	;4

	km_labelstart	$80
	km_label	kgmstf_battlestage1	;0
	km_label	kgmstf_battlestage2	;1
	km_label	kgmstf_battlestage3	;2
	km_label	kgmstf_battlestage4	;3

;--- Game Skill ---
	alc	currentlevel,2
	km_gmlabelstart	step,0
	km_gmlabel	0
	km_gmlabel	1
	km_gmlabel	2
	km_gmlabel	3
	km_gmlabel	4
	km_gmlabel	5
	km_gmlabel	6
	km_gmlabel	7
step_Neutral	equ	15

;--- Game Round ---
	alc	Kw_GameRound,1
	xalc	kx_GameRoundTm,1 ;Round(1,2,3) Display (for battle)

;---------------------------------------------------------------------
;*								*
;*			Player Work				*
;*								*
;---------------------------------------------------------------------
;***** Player Info ******
;* dochino player ka handan suru (sprites & BG no set notoki)
	alc	kplayer,1		;0/1 ... 1player / 2player

;* player zanki *
	alc	kw_PlayerRest1,1	;player1 zanki
	alc	kw_PlayerRest2,1	;player2 zanki

;	alc	kw_continue1,1		;player 1 contiune
;	alc	kw_continue2,1		;player 2 contiune

;* player type & arwing type *
	alc	karpltype1,1
	alc	karpltype2,1
;kpltyf_fox		equ	%00000001
;kpltyf_falco	equ	%00000010
;kpltyf_peppy	equ	%00000100
;kpltyf_slippy	equ	%00001000
;kpltyf_gal1		equ	%00010000
;kpltyf_gal2		equ	%00100000

;(talcs.inc)
;	alc	p1_pilotNo,1
;	alc	p2_pilotNo,1
;ep_fox		equ	0
;ep_falco		equ	1
;ep_peppy		equ	2
;ep_slippy		equ	3
;ep_gal1		equ	4
;ep_gal2		equ	5

;* Player Sound Pointer *
	alc	kw_plsndptr,2
	km_gmlabelstart	plsnd,0
	km_gmlabel	fox
	km_gmlabel	falco
	km_gmlabel	peppy
	km_gmlabel	slippy
	km_gmlabel	gal1
	km_gmlabel	gal2
	km_gmlabellen	plsndlen

;* player1,2 total score *
;* basic score *
	alc	kw_basicscore1,3
	alc	kw_basicscore2,3
;* extra bonus *
	alc	kw_extrabonus1,3
	alc	kw_extrabonus2,3
;* time bonus *
	alc	kw_timebonus1,2
	alc	kw_timebonus2,2
;* stage score *
	alc	kw_stagescore1,2
	alc	kw_stagescore2,2
;* total score *
	alc	kw_totalscore1,3
	alc	kw_totalscore2,3
;* weapon *
;	xalc	kx_weapontype1,1		;weapon no syurui
;	xalc	kx_weapontype2,1		;weapon no syurui
;	xalc	kx_weaponnum1,1			;weapon no kazu
;	xalc	kx_weaponnum2,1			;weapon no kazu
;* HP *
;	xalc	kx_HP1,1			;Hit Point
;	xalc	kx_HP2,1			;Hit Point
;---------------------------------------------------------------------
;*			Game MAPS				*
;---------------------------------------------------------------------
	alc	KGameMapPtr,2	;(0,1,2,3,...)
	km_gmlabelstart	stg,0
	km_gmlabel	stg1
	km_gmlabel	stg2
	km_gmlabel	stg3
	km_gmlabel	stg4
	km_gmlabel	stg5
	km_gmlabel	stg6
	km_gmlabel	sos1
	km_gmlabel	sos2
	km_gmlabel	sos3
	km_gmlabel	ext1
	km_gmlabel	ext2
	km_gmlabel	ext3
	km_gmlabel	ext4
	km_gmlabel	gmovdemo
	km_gmlabel	test

	km_gmlabelstart	stg,0
	km_gmlabel	bat1
	km_gmlabel	bat2
	km_gmlabel	bat3
	km_gmlabel	bat4
	km_gmlabel	bat5

	alc	KGameMap,1	;(1,2,3,...)
	alc	kw_PlanetCol,1	;planet palette pointer
	alc	kw_planetptr,2	;planet sofet ware sprite pointer
;* ps... colour flashing no pointer nimo natteiru *

;*** Sound Map Pointer ***
	alc	KSoundMapPtr,1

;*** Radar Map Pointer ****
	alc	KRDMapPtr,2
	xalc	KRDMapBuffer,64*5+2
;* Yamada san ga set suru koteibutu(building nado) no MAP Pointer
;radr map no data wa (X,Y,ChrNo) no 5 byte de kousei sareteiru.
;  radarmaptbl
;	dw	DataTotal	(All RAdar Map Data)
;	db	DataCounter	(Building Number)*5
;	db	Total Ennemy Numbrer

;	dw	X zahyou		;0
;	dw	Z zahyou		;1
;	db	Enemy Character Number	;3
;		.
;		.
;		.

;*********************************************************************
;*								*
;*			GAME TEMPORARY WORK			*
;*								*
;*********************************************************************
;=====================================================================
;*		TEMPORARY ZALC WORK [22 byte]		[rank0]	*
;=====================================================================
;* zalc ram *
kz_x1	equ	x1	;2 byte
kz_y1	equ	y1	;2 byte
kz_z1	equ	z1	;2 byte
kz_x2	equ	x2	;2 byte
kz_y2	equ	y2	;2 byte
kz_z2	equ	z2	;2 byte
kz_x3	equ	x3	;2 byte
kz_y3	equ	y3	;2 byte
kz_tpa	equ	tpa	;2 byte
kz_tpx	equ	tpx	;2 byte
kz_tpy	equ	tpy	;2 byte
kz_textpt	equ	textpt	;4 byte
kz_tempaddrl	equ   tempaddrl ;3 byte
	zalc	address,3
kz_address	equ	address	;3 byte

kz_wkdividend_L	equ	kz_textpt
kz_wkdividend_H	equ	kz_textpt+2
kz_wkdivisor		equ	kz_tempaddrl

;* Mario RAM Zwork *
;km_x1	equ	m_x1	;2 byte
;km_y1	equ	m_y1	;2 byte
;km_z1	equ	m_z1	;2 byte
;km_bigx	equ	m_bigx	;2 byte
;km_bigy	equ	m_bigy	;2 byte
;km_bigz	equ	m_bigz	;2 byte

;=====================================================================
;*		TEMPORARY WORK RAM [32 byte]	[rank0]		*
;=====================================================================
	alc	kwork,32
kworkstart	equ	kwork+0
kworkend	equ	kwork+31
;-----------------------------------------------------
;*	commom work (WORK0 ~ WORK15)		*
;-----------------------------------------------------
	km_worklabelstart	kwork
	km_worklabel	B,kwork0
	km_worklabel	B,kwork1
	km_worklabel	B,kwork2
	km_worklabel	B,kwork3
	km_worklabel	B,kwork4
	km_worklabel	B,kwork5
	km_worklabel	B,kwork6
	km_worklabel	B,kwork7
;---------------------------------------------
	km_worklabel	W,kflag		;2 byte
	km_worklabel	W,kcounter	;2 byte
	km_worklabel	W,kpointer	;2 byte
	km_worklabel	W,koffset	;2 byte
	km_worklabel	W,ksource	;2 byte
	km_worklabel	W,kdest	 	;2 byte
	km_worklabel	W,kx1		;2 byte
	km_worklabel	W,ky1		;2 byte
	km_worklabel	W,kz1		;2 byte
;---------------------------------------------
	km_worklabellen	kworklen	; length
	km_workvalcheck  32

;=====================================================================
;*		Special Work	[32 byte]	[RANK1]		*
;=====================================================================
	alc	kw_swork,32

kw_sworkstart	equ	kw_swork+0
kw_sworkend		equ	kw_swork+31
;=====================================================================
;*			TEMPORARY RAM		[RANK1]		*
;=====================================================================
;* kono work ha sub routine wo matagatte tukau kotoga dekiru.
;* shikashi kscreen.asm to sprites.asm noyouni mattaku chigau syorini
;* heiyoushite tukau kotoga dekinai 
;* mata data keep ha sono flame nai nomidesu 
	xalc	kxwork,48

kxworkstart	equ	kxwork+0
kxworkend	equ	kxwork+47
;=====================================================================
;*			TEMPORARY RAM	(48 Byte)	[RANK2]	*
;=====================================================================
;kono work RAM ha flame wo matagattemo data wo keep shimasu.
;map select,player select nadoni tukaimasu
	xalc	kxswork,48

kxsworkstart	equ	kxswork+0
kxsworkend	equ	kxswork+47
;---------------------------------------------------------------------
;*			TITLE					*
;---------------------------------------------------------------------
	km_worklabelstart	kw_swork
	km_worklabel	W,tiw_sprmode
	km_worklabel	W,tiw_gamemode

;---------------------------------------------------------------------
;*								*
;*			MISSIONMAP Select			*
;*								*
;---------------------------------------------------------------------
;--------------------------------------------------
;*  Koko kara shita wa Game Over shitemo 
;*  RAM Clear shinai
;--------------------------------------------------
	alc	kw_RandomPtr,2		;Random Pointer
	alc	kw_RndPlanetPtr,2	;Random Planet Pointer
	alc	kw_RndPlanetPtrBak,2	;Random Planet Contiune Pointer

	xalc	pl_rnd_offset,2		;Eguchi's Planet Random Table Pointer
	xalc	sos_rnd_offset,2	;Eguchi's SOS Random Table Pointer
	xalc	step_rnd_offset,2	;Eguchi's Step Up Random Table Pointer
	xalc	miss_rnd_offset,2	;Eguchi's Missile Random Table Pointer

;( mismap.asm)
	xalc	kx_RndStagePtr,2
	xalc	kx_RndStageBuffer,32	;Mission Planet Random Stage Buffer
	xalc	kx_RndPlanetStage,1	;
	xalc	kx_RndPlanetX,1		;
	xalc	kx_RndPlanetY,1		;
	xalc	kx_RndPlanetR,1		;
	xalc	kx_RndPlanetCol,2	;
	xalc	kx_RndPlanetSpr,2	;

;(HEAP RAM pointer)
;;;	xalc	kx_BGcolltbladdr,2	;BG collision Table
;(intro.asm)
	xalc	kx_missionplanetkazu,2	;Mission no Planet no kazu
	xalc	kx_drawplanetkazu,2	;Draw Planet no kazu

;;(Demo Sequence)
	xalc	kx_demoflag,2
demof_all	equ	-1
	km_gmflagstart	demof
	km_gmflag	demo		;0/1 ... normal / demo tyuu
	km_gmflag	sosappear	;0/1 ... sos wo 1 ko demo set shitara flag on

	xalc	kx_demonumber,2
	km_gmlabelstart	demo
	km_gmlabel	normal		;0
	km_gmlabel	scrollopentrig	;1	;(yajima san ga ON suru)
	km_gmlabel	scrollopen	;2
	km_gmlabel	scrollclosetrig	;3	;(yajima san ga ON suru)
	km_gmlabel	scrollclose	;4
	km_gmlabel	enemyappeartrig	;5
	km_gmlabel	enemyappear	;6
	km_gmlabel	explainstart	;7
	km_gmlabel	explainfinish	;8	;(yajima san ga ON suru)
;--------------------------------------------------
;*  Koko kara shita wa Game Over shitara 
;*  All RAM Clear shitemo Yoi
	xalc	MISSIONXRAM,0
;--------------------------------------------------
;* Sound Special Work *
	alc	kw_mmsoundflag,2
	alc	kw_mmBGM,2
	alc	kw_mmBGMPtr,2

	km_gmflagstart	mmsndf
mmsndf_all	equ	-1
	km_gmflag	sosappear
	km_gmflag	stupappear
	km_gmflag	corneriaexplode
	km_gmflag	destruction
	km_gmflag	stupin

;* Planet tensou no tameno WORK *
	xalc	kx_showmapsize,2	;(irq.asm)

;---- Covert Hex Value to Decima -----
	xalc	kx_DecimalBuffer,7	;6 keta bunn

;--- Clear Target no kazu ---
	alc	KEnemyNumber,1		;teki no kazu (sprites)
	alc	KCrystalNumber,1	;Crystal no kazu

;* Enemy Work *
	xalc	kx_DemoEnLoopCnt,2	; 2 byte :Enmy Syori Loop

;--- Fade ---
	alc	kw_FadeWaitTm,2

;--- BOSS  Mode ---
	alc	kw_BossPtr,2
	xalc	kx_BossMeterPtr,1
	alc	kw_BossMeterDMAsw,1
	xalc	kx_bosshp,1

;---- Bonus Time -----
	xalc	kx_bonustm,2

;----------------------------------------------------------------------
;***** cursor *****
	xalc	kx_cursortemp,0
	km_worklabelstart	kx_cursortemp
	km_worklabel	W,mmx_cursorflag	; 2 byte
	km_worklabel	B,mmx_curposx		; 1 byte
	km_worklabel	B,mmx_curposy		; 1 byte
	km_worklabel	W,mmx_curwaittm		; 1 byte
	km_worklabel	B,mmx_bigcurposX	; 1 byte
	km_worklabel	B,mmx_bigcurposY	; 1 byte
	km_worklabel	B,mmx_wipeposX		; 1 byte
	km_worklabel	B,mmx_wipeposY		; 1 byte
	km_worklabellen	cursorworklen		; length
	km_workvalcheck  32
	xalc	kx_cursor,cursorworklen

;* mmx_cursorflag (2 byte) *
	km_flagstart
curf_all	equ	-1
	km_flag	curf_wkcancel	;0/1 ... waku kakomi cancel (planet enemy)
	km_flag	curf_keypush	;0/1 ... no key push / key push
	km_flag	curf_destdisp	;0/1 ... mokutekiti no display OFF/ON 
	km_flag	curf_pushA	;0/1 ... moshi kettei button wo PUSH shitara
	km_flag	curf_hitplanet	;0/1 ... moshi A push shitatoki Planet ni Hit shiteitara
	km_flag	curf_hitenemy	;0/1 ... moshi cursor ga enemy ni HIT shitatoki !!
	km_flag	curf_corneria	;0/1 ... enemy planet / corneria planet
	km_flag	curf_goplanet	;0/1 ... mokutekinashi / dest ga planet
	km_flag	curf_pausecheck	;0/1 ... pause syori jmp (OFF/ON)
	km_flag	curf_readyspup	;0/1 ... ready speed up OFF/ON
	km_flag	curf_gospup	;0/1 ... go speed up OFF/ON
	km_flag	curf_samearwing	;0/1 ... same arwing postion
;---------------------------------------------------------------------
;****** player ******
	xalc	kx_arwingtemp,0
	km_worklabelstart	kx_arwingtemp
	km_worklabel	W,mmx_arwingposx	; 2 byte :(hi=integer,low=decimal)
	km_worklabel	W,mmx_arwingposy	; 2 byte :(hi=integer,low=decimal)
	km_worklabel	W,mmx_arwingsp		; 2 byte
	km_worklabel	W,mmx_arwingspx		; 2 byte
	km_worklabel	W,mmx_arwingspy		; 2 byte
	km_worklabel	W,mmx_arwingcgxptr1	; 2 byte :arwing cgx data poinnter (ue 2chr)
	km_worklabel	W,mmx_arwingcgxptr2	; 2 byte :arwing cgx data poinnter (shita 2chr)

	km_worklabel	B,mmx_arwingdx		; 1 byte
	km_worklabel	B,mmx_arwingdy		; 1 byte
	km_worklabel	B,mmx_arwingdxdy	; 1 byte
	km_worklabel	W,mmx_arwinganmptr	; 2 byte :kuru kruru pattern (16) pointer
	km_worklabel	B,mmx_arwinganmtm	; 1 byte
	km_worklabel	W,mmx_arwingflag	; 2 byte
	km_worklabel	W,mmx_arwingdestptr	; 2 byte
	km_worklabel	B,mmx_arwingdestposX	; 1 byte
	km_worklabel	B,mmx_arwingdestposY	; 1 byte
	km_worklabellen	mmx_arwinglen		; length
	km_workvalcheck  32
	xalc	kx_arwing,mmx_arwinglen
;---------------------------------------------------------------------
;* mother ship *
	xalc	kx_mothershiptemp,0
	km_worklabelstart	kx_mothershiptemp
	km_worklabel	B,kx_mshipx		; 1 byte :CX zahyou
	km_worklabel	B,kx_mshipy		; 1 byte :CY zahyou
	km_worklabel	B,kx_mshiprecovertm	; 1 byte :Mother Recover Timer
	km_workvalcheck  16
	km_worklabellen	mothershiplen		; length
	xalc	kx_mothership,mothershiplen
;---------------------------------------------------------------------
;***** Message Work RAM *****
	xalc	kx_messagetmplist,0
	km_worklabelstart	kx_messagetmplist
	km_worklabel	w,mmx_mapcursor
	km_worklabel	w,mmx_planetname
	km_worklabel	w,mmx_planetstep
	km_worklabel	w,mmx_message_sos
	km_worklabel	w,mmx_message_guard
	km_worklabel	w,mmx_message_stepup
	km_worklabel	w,mmx_planet_stepup
	km_worklabel	w,mmx_sosappear
	km_worklabel	w,mmx_mapcursorX
	km_worklabel	w,mmx_mapcursorY
	km_worklabel	w,mmx_playerNo
	km_worklabel	w,mmx_mapstates
	km_worklabellen	messagelistlen	; length
	xalc	kx_messagelist,messagelistlen

	km_gmflagstart	mesosfl
	km_gmflag	defence1
	km_gmflag	defence2
	km_gmflag	attackcorneria
	km_gmflag	missileattack
;---------------------------------------------------------------------

	xalc	kx_ReplayList,0
	km_worklabel	w,kx_TotalTime		;GAME Total Timer
	km_worklabel	w,kx_enemytotal		;ima deteiru Enemy Total Number
	km_worklabel	w,kx_initenemytotal	;Saisyo no Step Up suu
	km_worklabel	w,kx_clrenemytotal	;Clear no tame no Enemy Total Number 
	km_worklabel	w,kx_stepupstock	;Step Up no zaico
	km_worklabellen	replaylistlen		;length
	xalc	kx_replaytmplist,replaylistlen
	xalc	kx_replaybaklist,replaylistlen
	xalc	kx_replaycurlist,replaylistlen

repbakptr	equ	replaylistlen
repcurptr	equ	replaylistlen*2

;;	xalc	kx_neutralplanetkazu,1	;Neutral Planet no kazu
;;	xalc	kx_stepuptotal,1	;ima gamen ni deteiru Step Up enemy no kazu

;********** Game Timer ************
mapgftm	equ	8
missgftm	equ	16
	xalc	kx_TotalSubTime,2	;1 second timer
	alc	kw_Gametimer,2		;Game ni kakatta time
	xalc	kx_GameTmSub,2		;1 second timer

;---------------------------------------------------------------------
;***** Planet Work RAM *****
;;;	xalc	kx_clearplanetkazu,1	;Planet wo Clear shita kazu

	xalc	kx_currentplanetptr,2	;genzai play shiteiru planet no pointer
	xalc	kx_tmpplanetptr,2	;karikettei shiteiru planet no pointer
	xalc	kx_currentplanetnum,2	;genzai play shiteiru planet no skill
	xalc	kx_NearPlanetNum,2	;0 .. chikakuni planet nashi ,not 0 ...planet list pointer
	xalc	kx_NearPlanetPtr,2	;0 .. chikakuni planet nashi ,not 0 ...planet list pointer
	xalc	kx_corneriaptr,2	;Mother Planet no Pointer
	xalc	kx_planetfreeptr,2	;Planet List Free Pointer
	xalc	kx_planetlistptr,2	;Planet List Pointer
	xalc	kx_CorneriaHP,2		;Corneria HitPoint (100 >>>   0)
	xalc	kx_CorneriaDamage,2	;Corneria Damage   (0   >>> 100)
	xalc	kx_MeteorPtr,2		;MeteorPointer (0 = No Meteor)

planetkazumax	equ	15

	xalc	kx_planettmplist,0
	km_worklabelstart	0
	km_worklabel	w,mmx_planetnext	; 2 byte
	km_worklabel	w,mmx_planetprev	; 2 byte

;--- for bitmap planet draw work Start ----
	km_worksizestart
	km_worklabel	w,mmx_bitmapcx		; 2 byte
	km_worklabel	w,mmx_bitmapcy		; 2 byte
	km_worklabel	w,mmx_planetR		; 2 byte
	km_worklabel	w,mmx_planetsprite	; 2 byte
	km_worklabel	w,mmx_planetrotx	; 2 byte
	km_worklabel	w,mmx_planetroty	; 2 byte
	km_worklabel	w,mmx_planetrotz	; 2 byte
	km_worklabel	w,mmx_shadowrotx	; 2 byte
	km_worklabel	w,mmx_shadowroty	; 2 byte
	km_worklabel	w,mmx_shadowrotz	; 2 byte
	km_worksize	planetdrawsize		; length

;--- for bitmap planet draw work End ----

;--- Planet Infomation ---
	km_worklabel	w,mmx_stage		; 2 byte :stage number
	km_worklabel	w,mmx_planetskill	; 2 byte :step number
	km_worklabel	w,mmx_stagecnt		; 2 byte :planet clear count
	km_worklabel	b,mmx_planetcx		; 1 byte :center X (0~$ff)
	km_worklabel	b,mmx_planetcy		; 1 byte :center Y (0~$ff)

	km_worklabel	w,mmx_scrcx		; 1 byte :screen center x (0~$1f)
	km_worklabel	w,mmx_scrcy		; 1 byte :screen center y (0~$1f)
	km_worklabel	w,mmx_planetcol		; 2 byte :colour palette No
	km_worklabel	w,mmx_charabaseptr	; 2 byte :character base number pointer

	km_worksizestart
	km_worklabel	w,mmx_planetflag	; 2 byte :main flag
	km_worklabel	w,mmx_dokuroanm		; 2 byte :

;--- sos enemy ----
	km_worklabel	w,mmx_psos		; 2 byte :sequence number
	km_worklabel	w,mmx_psos_bak		; 2 byte :sequence number
	km_worklabel	w,mmx_sosenlistptr	; 2 byte :enemy list pointer
	km_worklabel	w,mmx_soswaittm		; 2 byte :wait timer
	km_worklabel	W,mmx_soschartptr	; 2 byte :enemy chart pointer
	km_worklabel	W,mmx_sosattacktm	; 2 byte :Corneria Attack Timer (nan FRAM oki ni kougeki suruka )
	km_worklabel	W,mmx_sosattackpo	; 2 byte :attack point

;--- step up enemy ---
	km_worklabel	w,mmx_pstepup		; 2 byte
	km_worklabel	w,mmx_pstepup_bak	; 2 byte
	km_worklabel	w,mmx_stupenlistptr	; 2 byte :enemy list pointer
	km_worklabel	w,mmx_stupwaittm	; 2 byte

;--- gurd enemy ---
	km_worklabel	w,mmx_pguard		; 2 byte
	km_worklabel	w,mmx_pguard_bak	; 2 byte
	km_worklabel	w,mmx_guardenlistptr	; 2 byte :enemy list pointer
	km_worklabel	w,mmx_guardwaittm	; 2 byte

	km_worksize	planetreplaysize	; length

;;;;	km_workgroup	planetreplaysize,mmx_RepPlanetflag
;;;;	km_workgroup	planetreplaysize,mmx_CurPlanetflag

	km_worklabellen	planetlistlen		; length
	km_workvalcheck  200

	xalc	kx_planetlist,planetkazumax*planetlistlen
;(mmx_pstepup)

;(mmx_planetflag)
	defflaglist	mmpnf
	defflag	neutral		;enemy senryou / neutral planet
	defflag	complete	;planet mission ALL complete
	defflag	corneria	;corneria (mother planet) flag
	defflag	stepupappear	;step up enemy not appear/appear
	defflag	sosappear	;sos enemy not appear/appear
	defflag	guardappear	;guard enemy not appear/appear
	defflag	freeze		;if player attack enemy planet then can't appear enemy !!
	defflag	missilebase	;missile base 
;(mmx_pstepup)
	km_gmlabelstart	stup
	km_gmlabel	nothing
	km_gmlabel	inittime
	km_gmlabel	wait
	km_gmlabel	born
	km_gmlabel	appeardemo
	km_gmlabel	move
	km_gmlabel	attackplanet
	km_gmlabel	enterdemo
	km_gmlabel	enterdemo2
	km_gmlabel	enterplanet
	km_gmlabel	dokuro
	km_gmlabel	battleplayer

;(mmx_psos)
	km_gmlabelstart	sos
	km_gmlabel	nothing
	km_gmlabel	inittime
	km_gmlabel	wait
	km_gmlabel	born
	km_gmlabel	appeardemo
	km_gmlabel	move
	km_gmlabel	battleplayer
	km_gmlabel	attackcorneria
	km_gmlabel	explodedemo
	km_gmlabel	disappear

;(mmx_pguard)
	km_gmlabelstart	guard
	km_gmlabel	nothing
	km_gmlabel	init	
	km_gmlabel	wait
	km_gmlabel	born
	km_gmlabel	appeardemo
	km_gmlabel	ready
	km_gmlabel	fire
	km_gmlabel	disappear

;---------------------------------------------------------------------
;********* enemy list *********
;* enemy chart *
	xalc	kx_enemychartptr,2
;* enemy list *
	xalc	kx_SOSEnemyptr,2	;Current SOS Enemy Pointer
	xalc	kx_FinalBossPtr,2	;Final BOSS Pointer

;	xalc	kx_stepupdemowait,2	;Step Up Demo ga hajimaru madeno Wait
;	xalc	kx_stepupsourptr,2	;Step Up Source Planet Pointer
;	xalc	kx_stepupappeartm,2	;Step Up Appear Timer
;(kx_stepupdemoptr)
;	km_gmlabelstart	stupdm
;	km_gmlabel	nothing
;	km_gmlabel	initial
;	km_gmlabel	open
;	km_gmlabel	demo1
;	km_gmlabel	close
;	km_gmlabel	demoend


mm_enemymax	equ	8
_enemynum	equ	20
	xalc	kx_enarrivetmptr,2
	xalc	kx_curenlistptr,2
	xalc	kx_curenfreeptr,2
	xalc	kx_repenlistptr,2
	xalc	kx_repenfreeptr,2
	xalc	kx_enlistptr,2
	xalc	kx_enfreeptr,2

	km_worklabelstart	0		;kx_enemylisttemp
	km_worklabel	W,mmx_ennext		; 2 byte
	km_worklabel	W,mmx_enprev		; 2 byte

	km_worklabel	B,mmx_enposx_l		; 1 byte
	km_worklabel	W,mmx_enposx		; 2 byte (hi=integer,low=decimal)
	km_worklabel	B,mmx_enposy_l		; 1 byte
	km_worklabel	W,mmx_enposy		; 2 byte (hi=integer,low=decimal)
;;;	km_worklabel	W,mmx_ensprposx		; 2 byte sprite postion X
;;;	km_worklabel	W,mmx_ensprposy		; 2 byte sprite postion Y
	km_worklabel	W,mmx_enangY		; 2 byte (0~$ffff)
	km_worklabel	W,mmx_envel		; 2 byte (hi=integer,low=decimal)
	km_worklabel	B,mmx_envelx_l		; 1 byte (decimal)
	km_worklabel	W,mmx_envelx		; 2 byte (hi=integer,low=decimal)
	km_worklabel	B,mmx_envely_l		; 1 byte (decimal)
	km_worklabel	W,mmx_envely		; 2 byte (hi=integer,low=decimal)
	km_worklabel	W,mmx_enflags		; 2 byte :enemy flags
	km_worklabel	W,mmx_enstratptr	; 2 byte :stratage (move) pointer
	km_worklabel	W,mmx_enstratptr_bak	; 2 byte :stratage (move) pointer push
	km_worklabel	W,mmx_ensourplanetptr	; 2 byte :Neutral no Planet no Pointer
	km_worklabel	W,mmx_endestplanetptr	; 2 byte :Neutral no Planet no Pointer
	km_worklabel	W,mmx_enstage		; 1 byte :stage (sos1,sos2,sos3)
	km_worklabel	W,mmx_enskill		; 1 byte :enemy step
	km_worklabel	W,mmx_entype		; 1 byte :zaco(0,1)/missile(2,3)/ship(4,5)
	km_worklabel	W,mmx_enplanetNo	; 1 byte :enemy ga mukatteiru Planet no Number
	km_worklabel	W,mmx_endestx		; 1 byte :enemy ga mukatteiru Planet no X zahyou
	km_worklabel	W,mmx_endesty		; 1 byte :enemy ga mukatteiru Planet no Y zahyou
	km_worklabel	W,mmx_encoll		; 1 byte :collision
;;;;	km_worklabel	W,mmx_enchrbase		; 2 byte :enemy character Base No
	km_worklabel	W,mmx_enchranm		; 2 byte :animation character No & (H,V)Flip

	km_worklabel	W,mmx_enanmpatt		; 2 byte :animation pattern sequence No (yajima's)
	km_worklabel	W,mmx_enanmtm		; 2 byte :animation sequence timer (yajima's)
	km_worklabel	W,mmx_work1		; 2 byte
	km_worklabel	W,mmx_work2		; 2 byte

	km_worklabel	W,mmx_enanmptr		; 2 byte

;;;;	km_worklabel	W,mmx_enarrivetm	; 2 byte :arrive time (to corneria)
	km_worklabel	W,mmx_eninvtm		; 1 byte :muteki jikan
	km_worklabel	W,mmx_ensenkyowaittm	; 2 byte :step up wait time
	km_worklabellen	mmx_enemylen		; length
	km_workvalcheck  60

	xalc	kx_enemylist,mmx_enemylen*_enemynum

;	xalc	kx_Curenemylist,mmx_enemylen*_enemynum
;	xalc	kx_REPenemylist,mmx_enemylen*_enemynum

;* enmey flags (mmx_enflags)*
	km_gmflagstart	enfl

	km_gmflag	encountplayer	;0/1 ... nothing / encount player
	km_gmflag	arrive		;0/1 ... not arrive / arrive
	km_gmflag	stepup		;0/1 ... sos / stepup enemy
	km_gmflag	defence1	;0/1 ... defence line 1

	km_gmflag	defence2	;0/1 ... defence line 2
	km_gmflag	asteroid	;0/1 ... asteroid nohit/hit
	km_gmflag	demo		;0/1 ... normal / demo tyuu
	km_gmflag	nocollision	;0/1 ... atari ari /muteki(no collision)

	km_gmflag	attackcorneria	;0/1 ... not attack / attack corneria
	km_gmflag	StupEnterAnm	;0/1 ... nothing / enter planet animation start trigger (stepup)
	km_gmflag	SearchAreaIn	;0/1 ... nothing / player search area IN
	km_gmflag	searchenemy	;0/1 ... normal / player search enemy

enfl_all	equ	-1

;* enemy stratage (mmx_enstratptr) *
	km_gmlabelstart	enstrat
	km_gmlabel	nothing
	km_gmlabel	stepupappear
	km_gmlabel	sosappear
	km_gmlabel	searchplanet
	km_gmlabel	aroundplanet
	km_gmlabel	battleplayer
	km_gmlabel	searchplayer
	km_gmlabel	searchrandom
	km_gmlabel	enterplanet

;* enemy type (mmx_entype :1 byte) *
	km_gmlabelstart	entyp
	km_gmlabel	zaco1
	km_gmlabel	zaco2
	km_gmlabel	missile1
	km_gmlabel	missile2
	km_gmlabel	battleship1
	km_gmlabel	battleship2
	km_gmlabel	stepup1
	km_gmlabel	stepup2
	km_gmlabel	guard

;---------------------------------------------------------------------
;*			Common WORK				*
;---------------------------------------------------------------------
;(kw_swork :32 byte)
	km_worklabelstart	kw_swork
;* Bit Map Planet *
	km_worklabel	W,mmw_wbuffercounter	; 2 byte
	km_worklabel	W,mmw_dmabaseptr	; 2 byte
	km_worklabel	W,mmw_dmabase_moto	; 2 byte
	km_worklabel	W,mmw_dmabase_sakistep	; 2 byte
	km_worklabel	W,mmw_vrambase		; 2 byte
	km_worklabel	W,mmw_vramadr		; 2 byte
	km_worklabel	W,mmw_mrambase		; 2 byte
	km_worklabel	W,mmw_planetroty	; 2 byte
;;;	km_worklabel	W,mmw_speedup		; 2 byte :speed up work
	km_worklabel	W,mmw_bitmapptr		; 2 byte :planet no screen data (base character Number) Pointer
	km_workvalcheck  32
;(kxwork :48 byte)
	km_worklabelstart	kxwork
;* Cursor Work *
	km_worklabel	B,mmx_curaccelx		; 1 byte
	km_worklabel	B,mmx_curspeedx		; 1 byte
	km_worklabel	B,mmx_curaccely		; 1 byte
	km_worklabel	B,mmx_curspeedy		; 1 byte
	km_worklabel	B,mmx_curaccel		; 1 byte
	km_worklabel	B,mmx_curspeed		; 1 byte
;;;;	km_worklabel	B,mmx_curtimer		; 1 byte
	km_worklabel	B,mmx_curchar		; 1 byte
	km_worklabel	B,mmx_curanmtm		; 1 byte
	km_worklabel	B,mmx_curanmptr		; 1 byte
;;;	km_worklabel	W,mmx_curanmpat		; 2 byte
;;;	km_worklabel	W,mmx_curanmpat2	; 2 byte
	km_worklabel	B,mmx_destmarktm	; 1 byte
	km_worklabel	W,mmx_destmarkptr	; 2 byte
;;;	km_worklabel	B,mmx_planetposcx	; 1 byte
;;;	km_worklabel	B,mmx_planetposcy	; 1 byte
	km_worklabel	B,mmx_ballsettm		; 1 byte
	km_worklabel	W,mmx_pausescroll	; 2 byte
	km_worklabel	W,mmx_scrollwaittm	; 2 byte
	km_worklabel	W,mmx_enemydestptr	; 2 byte :Step Up Destination Planet Pointer
	km_worklabel	W,mmx_spx_dec		; 2 byte :Temp Speed (X) :decimal
	km_worklabel	B,mmx_spx_int		; 1 byte :Temp Speed (X) :integer
	km_worklabel	W,mmx_spy_dec		; 2 byte :Temp Speed (Y) :decimal
	km_worklabel	B,mmx_spy_int		; 1 byte :Temp Speed (Y) :integer
	km_worklabel	B,mmx_jetanmptr		; 1 byte :Arwing Boost Animatio Pointer
	km_worklabel	B,mmx_meteoranmptr	; 1 byte :Meteor Animation Pointer
	km_worklabel	w,mmx_DrawPlanetCnt	; 2 byte :Draw Planet Counter
	km_worklabel	w,mmx_stupXposhosei	; 2 byte
	km_worklabel	w,mmx_stepupsetcnt	; 2 byte :Step Up First Setting Counter (easy,normal,hard)
	km_worklabel	w,mmx_stepupsetptr	; 2 byte :Step Up First Setting Pointer (easy,normal,hard)
	km_workvalcheck  48

;(mmx_pausescroll)
scrl_normal		equ	0
scrl_openscrollwait	equ	1
scrl_openscroll	equ	2
scrl_pausekeywait	equ	3
scrl_pause		equ	4
scrl_closescrollwait	equ	5
scrl_closescroll	equ	6
scrl_closefinish	equ	7

;	km_worklabel	B,mmw_ok		; 1 byte
;	km_worklabel	W,mmw_planetdataptr	; 2 byte
;	km_worklabel	W,mmw_planetanmptr	; 2 byte
;	km_worklabel	W,mmw_planetvheight	; 2 byte
;	km_worklabel	W,mmx_planetangx	; 2 byte
;	km_worklabel	W,mmx_planetangy	; 2 byte
;	km_worklabel	W,mmx_planetangz	; 2 byte
;	km_worklabel	B,mmx_stationtm		; 1 byte
;	km_worklabel	B,mmx_stationanmptr	; 1 byte



;(kxswork:48 byte)
;** Mission Map Select parameters **
	km_worklabelstart	kxswork
;* Mission Total Timer Work *
	km_worklabel	W,mmx_TMSendAnmPtr	; 2 byte :Add Timer Yajirushi
	km_worklabel	W,mmx_DokuroMark	; 2 byte :Dokuro Mark Anim Timer
	km_worklabel	W,mmx_SOSMark		; 2 byte :SOS Mark Anim Timer
	km_worklabel	W,mmx_2frameTm		; 2 byte :2 frame Timer
	km_worklabel	W,mmx_4frameTm		; 2 byte :4 frame Timer
	km_worklabel	W,mmx_8frameTm		; 2 byte :8 frame Timer

	km_worklabel	W,mmx_RndPlanetCnt	; 2 byte :Random Planet Set Order Number

;* Heap Pointer *
	km_worklabel	W,mmx_objcgxaddr	;OBJ CGX BUFFER Top Addr (ARWING)
	km_worklabel	W,mmx_rampogaddr	;RAM PROGAM Top Addr
	km_worklabel	W,mmx_sprsizeaddr	;Sprite Size Table Top Addr
	km_worklabel	W,mmx_sprstationaddr	;Station Anm Data Top Addr
	km_worklabel	W,mmx_sprarwingaddr	;Arwing  Anm Data Top Addr
	km_worklabel	W,mmx_sprballaddr	; 2 byte :Ball Top Addr
	km_worklabel	W,mmx_enemychartaddr	; 2 byte :

;	km_worklabel	W,mmx_SCRtensou		; 2 byte
;	km_worklabel	W,mmx_SCRtensou2	; 2 byte
;	km_worklabel	W,mmx_SCRtensou4	; 2 byte
;	km_worklabel	W,mmx_SCRtensou6	; 2 byte
;	km_worklabel	W,mmx_SCRtensou8	; 2 byte
;	km_worklabel	W,mmx_SCRtensou10	; 2 byte
;	km_worklabel	W,mmx_SCRtensou12	; 2 byte
;	km_worklabel	W,mmx_SCRtensou14	; 2 byte
;;;;	km_worklabel	W,mmx_collisaddr	;Collison List Top Addr
;;;	km_worklabel	W,mmx_sprgessoaddr	;Gesso Anm Data Top Addr
;;;	km_worklabel	W,mmx_sprghost1addr	;Ghost1 Anm Data Top Addr
;;;	km_worklabel	W,mmx_sprghost2addr	;Ghost2 Anm Data Top Addr
;;;	km_worklabel	W,mmx_sprghost3addr	;Ghost3 Anm Data Top Addr
	km_workvalcheck  48

;* ball (form arwing to planet) *
	km_worklabelstart	heap
	km_worklabel	B,mmx_ballsx		; 1 byte
	km_worklabel	B,mmx_ballsy		; 1 byte
	km_worklabel	B,mmx_ballex		; 1 byte
	km_worklabel	B,mmx_balley		; 1 byte
	km_worklabel	B,mmx_ballsp		; 1 byte
	km_worklabel	B,mmx_ballspx		; 1 byte
	km_worklabel	B,mmx_ballspy		; 1 byte
	km_worklabel	B,mmx_balldx		; 1 byte
	km_worklabel	B,mmx_balldy		; 1 byte
	km_worklabel	B,mmx_balldxdy		; 1 byte
	km_worklabel	B,mmx_ballflags		; 1 byte
	km_worklabel	B,mmx_ballcntx		; 1 byte
	km_worklabel	B,mmx_ballcnty		; 1 byte
	km_worklabellen	mmx_balllen		; length

;* Mission Map Clear RAM END Address *
	xalc	MISSIONXRAMEND,0
	km_datalen	MISSIONXRAM

;* 7f ram (obj animation buffer) *
objchart	equ	cockpitcgx_buf
mmxx_screenbuffer	equ	(cockpitcgx_buf+$2000)	;$800h
;BG1 wa 05 chr/line
;BG2 wa 23 chr/line
mm_scrdatabg1start	equ	5*32*2+$800
mm_scrbufbg1start	equ	5*32*2
mm_scrbg1len		equ	23*32*2
mm_bitmapbg1start	equ	mm_scrdatabg1start
mm_scrbg1souraddr	equ	mmxx_screenbuffer+mm_scrbufbg1start
mm_vmbg1start	equ	mm_scrdatabg1start/2
mm_vmscrbg1addr	equ	mm_bg1_scr+mm_vmbg1start
mm_vmscrbufbg1len	equ	mm_scrbg1len

mm_scrdatabg2start	equ	0
mm_scrbufbg2start	equ	0
mm_scrbg2len		equ	5*32*2
mm_bitmapbg2start	equ	mm_scrdatabg2start
mm_scrbg2souraddr	equ	mmxx_screenbuffer+mm_scrbufbg2start
mm_vmbg2start	equ	mm_scrdatabg2start/2
mm_vmscrbg2addr	equ	mm_bg2_scr+mm_vmbg2start
mm_vmscrbufbg2len	equ	mm_scrbg2len

BGcheckBuffer	equ	(cockpitcgx_buf+$2800)
;---------------------------------------------------------------------
;*			Battle Field Select			*
;---------------------------------------------------------------------
;**** battle field select ****
rarwingmvx	equ	kxwork+0	;1 byte	:idou ryo (x)
rarwingmvy	equ	kxwork+1	;1 byte	:idou ryo (y)
rarwingx	equ	kxwork+2	;1 byte :base zahyou (x)
rarwingy	equ	kxwork+3	;1 byte :base zahyou (y)
rarwinghosx	equ	kxwork+4	;1 byte :zahyou hosei (x)
rarwinghosy	equ	kxwork+5	;1 byte :zahyou hosei (y)

rarwingmvptr	equ	kxwork+6	;1 byte :idou pattern pointer
rarwingmvtm	equ	kxwork+7	;1 byte :idou timer
boostanmfl	equ	kxwork+8	;1 byte :boost animation pointer

rarwingptr	equ	kxwork+10	;1 byte :idou pattern pointer
rarwingtm	equ	kxwork+11	;1 byte :idou pattern pointer

rarwingbase1	equ	kxwork+12	;2 byte :arwing base character 1
rarwingbase2	equ	kxwork+14	;2 byte :arwing base character 2
rarwinganmfl	equ	kxwork+16	;1 byte :hi (timer),low(anime pointer)

;---------------------------------------------------------------------
;** Battle field select temporary parameter
rarwingx1	equ	kxswork+0	;1 byte
rarwingy1	equ	kxswork+1	;1 byte
rarwingptr1	equ	kxswork+2	;1 byte
rarwingmvtm1	equ	kxswork+3	;1 byte

rarwingx2	equ	kxswork+4	;1 byte
rarwingy2	equ	kxswork+5	;1 byte
rarwingptr2	equ	kxswork+6	;1 byte
rarwingmvtm2	equ	kxswork+7	;1 byte

bfs_cursortm	equ	kxswork+8	;1 byte

bfs_OKflag	equ	kxswork+9	;1 byte
bfs_okanmtm	equ	kxswork+10	;1 byte
bfs_okanmptr	equ	kxswork+11	;1 byte


;---------------------------------------------------------------------
;*			Battle  Player Select			*
;*			Mission Player Select			*
;---------------------------------------------------------------------
;(kw_swork :32 byte)
	km_worklabelstart	kw_swork
	km_worklabel	W,mpw_misplayerflag	; 2 byte
	km_worklabel	W,mpw_keyflag		; 2 byte

mpkf_pushAB		equ	%01000000
mpkf_pushXY		equ	%10000000	
;**** battle player select *****
	km_worklabelstart	kxwork

 km_worklabel B,bps_ksproffx		;1 byte :zahyou no kari set X
 km_worklabel B,bps_ksproffy		;1 byte :zahyou no kari set Y
 km_worklabel B,bps_ksprchr		;1 byte :character no kari set

;* cursor *
 km_worklabel B,bps_OKflag		;1 byte	;OK flag
; [bfs_OKflag]
;fbfs_OKptrmax	equ	%00000111	;field select pointer check val
;fbfs_OKInitptr	equ	%00000000	;spr init
;fbfs_OKanmptr	equ	%00000001	;spr Ok anime display
;fbfs_OKflashptr	equ	%00000010	;spr OK flash
;fbfs_OKcancelptr	equ	%00000011	;spr OK disp cancell
;fbfs_ok		equ	%00001000	;field select OK? flag
;fbfs_selEND		equ	%00010000	;field select ALL OK flag
;fbfs_cancel		equ	%00100000	;field select Cancel flag
;fbfs_buttondisable	equ	%01000000	;button read disable flag
;fbfs_keydisable	equ	%10000000	;key read disable flag

;* Pilot *
 km_worklabel B,bps_pilotmovptr	;1 byte :pilot 
 km_worklabel B,bps_pilotoffx 	;1 byte ;pilot offset X postion
 km_worklabel B,bps_pilotoffy 	;1 byte ;pilot offset Y postion

;* arwing *
 km_worklabel B,bps_arwingoffx 	;1 byte ;arwing offset X postion
 km_worklabel B,bps_arwingoffy 	;1 byte ;arwing offset Y postion
 km_worklabel B,bps_arwingvelxptr	;1 byte :
 km_worklabel B,bps_arwingvelyptr	;1 byte :
 km_worklabel B,bps_arwingvelX	;1 byte :arwing Velocity X
 km_worklabel B,bps_arwingvelY	;1 byte :arwing Velocity X

;* boost *
 km_worklabel B,bps_boostptr		;1 byte :boost animation pointer,timer
 km_worklabel B,bps_boostoffx	;1 byte :boost X zahyo
 km_worklabel B,bps_boostoffy	;1 byte :boost Y zahyo

;* CHECK *
 km_workvalcheck  48
;-------------------------------------------
	km_worklabelstart	kxswork
 km_worklabel B,bps_cursortm		;1 byte	;cursor anm timer
 km_worklabel B,bps_keyptrbk		;1 byte :pl1 cursor back pointer

;==== player 1 ====
;* cursor *
 km_worklabel B,bps_keyptr1		;1 byte	;pl1 cursor pointer
 km_worklabel B,bps_OKflag1		;1 byte ;pl1 OK flag
;* Pilot *
 km_worklabel B,bps_pilot1movptr	;1 byte :pilot move ptr  (pl1)
 km_worklabel B,bps_pilot1offx	;1 byte :pilot postion X (pl1)
 km_worklabel B,bps_pilot1offy	;1 byte :pilot postion Y (pl1)

;* arwing *
 km_worklabel B,bps_arwing1offx	;1 byte ;arwing offset X postion
 km_worklabel B,bps_arwing1offy	;1 byte ;arwing offset Y postion
 km_worklabel B,bps_arwing1velxptr	;1 byte :
 km_worklabel B,bps_arwing1velyptr	;1 byte :
 km_worklabel B,bps_arwing1velX	;1 byte :arwing Velocity X
 km_worklabel B,bps_arwing1velY	;1 byte :arwing Velocity Y

;* boost *
 km_worklabel B,bps_boost1ptr	;1 byte :boost animation pointer,timer
 km_worklabel B,bps_boost1offx	;1 byte :boost X zahyo
 km_worklabel B,bps_boost1offy	;1 byte :boost Y zahyo

;==== player 2 ====
;* cursor *
 km_worklabel B,bps_keyptr2		;1 byte	;pl2 cursor pointer
 km_worklabel B,bps_OKflag2		;1 byte ;pl2 OK flag
;* Pilot *
 km_worklabel B,bps_pilot2offx	;1 byte :pilot postion X (pl2)
 km_worklabel B,bps_pilot2offy	;1 byte :pilot postion Y (pl2)
 km_worklabel B,bps_pilot2movptr	;1 byte :pilot move ptr  (pl2)
;* arwing *
 km_worklabel B,bps_arwing2offx 	;1 byte ;arwing offset X postion
 km_worklabel B,bps_arwing2offy 	;1 byte ;arwing offset Y postion
 km_worklabel B,bps_arwing2velxptr	;1 byte :
 km_worklabel B,bps_arwing2velyptr	;1 byte :
 km_worklabel B,bps_arwing2velX	;1 byte :arwing Velocity X
 km_worklabel B,bps_arwing2velY	;1 byte :arwing Velocity Y
;* boost *
 km_worklabel B,bps_boost2ptr	;1 byte :boost animation pointer,timer
 km_worklabel B,bps_boost2offx	;1 byte :boost X zahyo
 km_worklabel B,bps_boost2offy	;1 byte :boost Y zahyo

	km_workvalcheck  48

;---------------------------------------------------------------------
;*			Type Select (Training)			*
;---------------------------------------------------------------------
	xalc	tsx_keytateflag,1		;1 byte

	km_worklabelstart	kxwork
	km_worklabel	B,tsx_keyyokoptr	;1 byte
	km_worklabel	B,tsx_keytateptr	;1 byte

	km_worklabel	B,tsx_wakubaseX		;1 byte
	km_worklabel	B,tsx_wakubaseY		;1 byte
	km_worklabel	B,tsx_wakuposX		;1 byte
	km_worklabel	B,tsx_wakuposY		;1 byte

	km_worklabel	B,tsx_aiconposX		;1 byte
	km_worklabel	B,tsx_aiconposY		;1 byte

;---------------------------------------------------------------------
;*			MainGame				*
;---------------------------------------------------------------------
	xalc	kx_radarscale,2
	xalc	kx_radarmax,2
	xalc	kx_radarmin,2

	km_worklabelstart	kw_swork
	km_worklabel	W,mew_ketteiflag	; 2 byte
	km_worklabel	W,kspriteflag		; 2 byte
	km_workvalcheck  32

	km_gmflagstart	sf
sf_all	equ	-1
	km_gmflag	corneriaflash


;scaling :(kx_radarscale)
;-4 ... 1 dot =   32
;-2 ... 1 dot =   64
;-1 ... 1 dot =  128
; 0 ... 1 dot =  256
;+1 ... 1 dot =  512
;+2 ... 1 dot = 1024 :!!!! Can't Use !!!!! Too Big !
;+4 ... 1 dot = 2048 :!!!! Can't Use !!!!! Too Big !
;************* Main GAME Sprites *************
	km_worklabelstart	kxwork
	km_worklabel	W,p1x		;2 byte	;player 1 x postion
	km_worklabel	W,p1y		;2 byte	;player 1 y postion
	km_worklabel	W,p1z		;2 byte	;player 1 z postion
	km_worklabel	W,p2x		;2 byte	;player 2 x postion
	km_worklabel	W,p2y		;2 byte	;player 2 y postion
	km_worklabel	W,p2z		;2 byte	;player 2 z postion

;**** Sprites Cockpit temporary parameter (sprites.asm)
	km_worklabel	W,kpx		;2 byte :Player World X
	km_worklabel	W,kpy		;2 byte :Player World Y
	km_worklabel	W,kpz		;2 byte :Player World Z
	km_worklabel	W,kroty		;1 byte :player angle Y
	km_worklabel	B,ksproffx	;1 byte :sprite (radar,screen) offset x
	km_worklabel	B,ksproffy	;1 byte :sprite (radar,screen) offset y
	km_worklabel	B,ktargetx	;1 byte :sprite syoujyun offset x
	km_worklabel	B,ktargety	;1 byte :sprite syoujyun offset y
	km_worklabel	B,kareaminX	;2 byte :
	km_worklabel	B,kareamaxX	;2 byte :
	km_worklabel	B,kareaminZ	;2 byte :
	km_worklabel	B,kareamaxZ	;2 byte :
; BG Cockpit temporary parameter (kscreen.asm)
	km_worklabel	B,kwindowoffx	;1 byte :Mario CGX offset
	km_worklabel	W,kclipsx	;2 byte :Circle Window Clip SX
	km_worklabel	W,kclipex	;2 byte :Circle Window Clip EX
	km_worklabel	W,kclipsy	;2 byte :Circle Window Clip SY

	km_workvalcheck  48

;**** GAME Main Sprites ****
	km_worklabelstart	kxswork
;* (windows.asm) *
;	km_worklabel	B,kx_wm_w12swl		; 1byte
;	km_worklabel	B,kx_wm_w34swl		; 1byte
;	km_worklabel	B,kx_wm_wobjsel		; 1byte
;	km_worklabel	B,kx_wm_wbglog		; 1byte
;	km_worklabel	B,kx_wm_ts		; 1byte
;	km_worklabel	B,kx_wm_cgswsel		; 1byte
;	km_worklabel	B,kx_wm_cgadsub		; 1byte
;	km_worklabel	B,kx_wm_coldata		; 1byte
;	km_worklabel	B,kx_wm_coldata_r	; 1byte
;	km_worklabel	B,kx_wm_coldata_g	; 1byte
;	km_worklabel	B,kx_wm_coldata_b	; 1byte
;	km_worklabel	B,kx_wm_chparams	; 1byte
;	km_worklabel	W,kx_wm_hdam		; 2byte
;	km_worklabel	B,kx_wm_hdam_bank	; 1byte
;	km_worklabel	B,kx_wm_val		; 1byte
;	km_worklabel	B,kx_wm_flags		; 1byte


	km_worklabel	B,kmapptr	;1 byte
	km_worklabel	W,kmapoffx	;2 byte
	km_worklabel	W,kmapoffz	;2 byte
	km_worklabel	B,kp1mapptr	;1 byte
	km_worklabel	W,kp1mapoffx	;2 byte
	km_worklabel	W,kp1mapoffz	;2 byte
	km_worklabel	B,kp2mapptr	;1 byte
	km_worklabel	W,kp2mapoffx	;2 byte
	km_worklabel	W,kp2mapoffz	;2 byte
	km_worklabel	W,kx_CorneriaDispTm	;2 byte
	km_workvalcheck  48
;----------------------------------------------------------------------------
	IFEQ	1
; soft ware sprite temporary parameter
kswsoffcx	equ	kxwork+0	;2 byte :Soft Ware Sprite Pos CX
kswsoffcy	equ	kxwork+2	;2 byte :Soft Ware Sprite Pos CY
ksprname	equ	kxwork+4	;2 byte :Soft Ware Sprite Name
kswspointer	equ	kxwork+6	;2 byte :Soft Ware Sprite (x,y) Pointer
	ENDC
;----------------------------------------------------------------------
;*			Training				*
;----------------------------------------------------------------------
	km_worklabelstart	kw_swork
	km_worklabel	W,trw_swapbg2	; 2 byte

;---------------------------------------------------------------------
;*			Config Mode				*
;---------------------------------------------------------------------
;** CONFIG MODE **
conf_flag	equ	kxswork+0	;1 byte
conf_bgm	equ	kxswork+1	;1 byte
conf_se	equ	kxswork+2	;1 byte
conf_port1	equ	kxswork+3	;1 byte
conf_port2	equ	kxswork+4	;1 byte

	defflaglist	conf
	defflag		exit

;=====================================================
;*		PAD WORK	[18 byte]	*
;=====================================================
	alc	keywork,18
keyworkstart	equ	keywork+0
keyworkend	equ	keywork+17
;-----------------------------------------------------
;********** Temporary Key Check ***********
	km_worklabelstart	keywork
	km_worklabel	B,key_yokoptr1		;1 byte
	km_worklabel	B,key_tateptr1		;1 byte
	km_worklabel	B,key_yokotm1		;1 byte
	km_worklabel	B,key_tatetm1		;1 byte
	km_worklabel	B,key_yokomaxptr1	;1 byte
	km_worklabel	B,key_tatemaxptr1	;1 byte

	km_worklabel	B,keyptr	;1 byte
	km_worklabel	B,keyptrbk	;1 byte
	km_worklabel	B,keymaxptr	;1 byte
	km_worklabel	B,keyflag	;1 byte
	km_worklabel	W,keystates	;2 byte ;temp current key states
	km_worklabel	B,autotrig	;1 byte	;temp key states + trigger flag
	km_worklabel	B,autokeytm	;1 byte	;temp trigger key wait timer
	km_worklabel	B,autotrig0	;1 byte	;cont1 key states + trigger flag
	km_worklabel	B,autokeytm1	;1 byte	;cont1 trigger key wait timer
	km_worklabel	B,autotrig1	;1 byte	;cont2 key states + trigger flag
	km_worklabel	B,autokeytm2	;1 byte	;cont2 trigger key wait timer
	km_workvalcheck  18
;------------------------------------------------------------------------------------
;***** Mission Map ******
	km_worklabelstart	keywork
	km_worklabel	W,mmw_keydown
	km_worklabel	W,mmw_trigger
	km_workvalcheck  18
;------------------------------------------------------------------------------------
;* key flags *
	defflaglist	key		; current screen mode
	defflag		push
	defflag		disable
;=====================================================
;*	Macro Temporary Work	[8 byte]	*
;=====================================================
;kono work ha macro nai dakeshika tukau kotogadekinai.
	alc	kmwork,8	;Macro Work
kmbyte1	equ	kmwork+0	;1
kmbyte2	equ	kmwork+1	;1
kmword	equ	kmwork+2	;2

;=====================================================
;*	IRQ TEMPORARY WORK RAM	[8 byte]	*
;=====================================================
;kono work ha IRQ naideshika tukaukotoga dekinai.
	alc	iwork,8		;IRQ WORK RAM
;-----------------------------------------------------
isyou	equ	iwork+0
iamari	equ	iwork+2
;-----------------------------------------------------
kw_imoto	equ	iwork+0		; 2 byte
kw_isaki	equ	iwork+2		; 2 byte

;=====================================================
;*	Calculate parameter	[8 byte]	*
;=====================================================
	alc	kcalc,8
;---- division ----
ksyou	equ	kcalc+0		;2 byte
kamari	equ	kcalc+2		;2 byte
;---- mult -----
kseki	equ	kcalc+0		;2 byte
;--- normalse ---
kvecx	equ	kcalc+0		;2 byte
kvecy	equ	kcalc+2		;2 byte
kvecz	equ	kcalc+4		;2 byte
;---
kangle	equ	kcalc+0

;*********************************************************************
;*			7E Bank RAM	[XALC]			*
;*								*
;*********************************************************************
;=====================================================
;*	Sprites Parameters & Buffer 		*
;=====================================================
	alc	sprpointer,2 	;2 byte ;sprites data pointer
	xalc	sprrdpri,2	;2 byte :sprites priority syusei
	xalc	kx_sproff,2	;2 byte :sprites character offset

;---------- Sprites Data Buffer -------------
	xalc	sprites,((128*4)+(128/4))*2
sprbuf2offs	equ	(128*4)+(128/4)
spritebuf1	equ	sprites
spritebuf2	equ	sprites+sprbuf2offs
sprites_sub	equ	spritebuf1+128*4
sprites_sub2	equ	spritebuf2+128*4

;=====================================================================
;=====================================================================
;*			SPECIAL	RAM				*
;=====================================================================
;=====================================================================
;=====================================================
;*		CPU & PPU register		*
;=====================================================
;--- irq h,v timer ---
	alc	kw_vtimel,2
	alc	kw_vtimestart,2
	alc	kw_vtimeend,2
;--- col add ---
	xalc	kx_coladdflag,1
;--- through main ---
	alc	kw_tm,1
	alc	kw_tmptm,1
	alc	kw_tmbackup,1
;--- screen base ----
	alc	kw_bg2sc,2
	alc	kw_bg3sc,1
;---- cgx base ----
	alc	kw_bg12nba,1
;--- screenfade ----
	alc	kw_screenfade,1		;b7 (screen fade flag)
	xalc	kx_screenfadetm,1
;--- mozaiku ----
	xalc	kx_mozaikutimer,1
	alc	kw_mozaikuflag,1	;b7 (mozaiku:on/off),b0~b3( bg select)
	alc	kw_mozaikunumber,1	;b4~b7 (mozaiku size)

;=====================================================
;*		DMA parameters			*
;=====================================================
	alc	kw_dmacnt,1	;dma counter
	alc	kw_dmatm,1	;dma timer

	alc	kw_dmasaddr,2	;source address
	alc	kw_dmasbnk,1	;source bank

	alc	kw_dmadaddr,2	;dest address
	alc	kw_dmadbnk,1	;dest address

	alc	kw_dmalength,2	;data lenght

;*********************************************************************
;*								*
;*			HDMA Parameter				*
;*								*
;*********************************************************************
;=====================================================================
;*			Window RAM				*
;=====================================================================
;***** window flag ******
	alc	kw_windowflag,2
kwinf_all	equ	-1
	defflaglist	kwinf		;kmimpf_{pointer}
	defflag		circle		;0/1 ... 

	xalc	KwindowTm,1
	alc	kw_blackfadestep,1
;***** find window prio ****
	alc	kw_findwindpri,2
;***** Window tables *****
	alc	kw_windowmode,2
	alc	kw_wipetimer,2
;=== window structure buffer ===
	alc	kw_windowstructP1_buf1,wm_sizeof
	alc	kw_windowstructP2_buf1,wm_sizeof
	alc	kw_windowstructP1_buf2,wm_sizeof
	alc	kw_windowstructP2_buf2,wm_sizeof
;=== BOM window buffer ===
;--- cilcel window ----
;	xalc	kx_circlewindowmode,2
;	xalc	kx_circleCX,2	;2 byte :Circle Window X zahyo
;	xalc	kx_circleCY,2	;2 byte :Circle Window Y zahyo
;	xalc	kx_circleTR,2	;2 byte :Circle Window Radius
;	xalc	kx_circleR,1	;1 byte :Circle Window Radius
;	xalc	kx_circlestep,1	;1 byte :circle Radius Step
;	xalc	kx_circlefade,1	;1 byte :circle Radius Step
;	xalc	kx_circlecolR,1	;1 byte :cilcle window colour Red
;	xalc	kx_circlecolG,1	;1 byte :cilcle window colour Green
;	xalc	kx_circlecolB,1	;1 byte :cilcle window colour Blue

	km_gmlabelstart	winm,0
	km_gmlabel	nothing,2
	km_gmlabel	open,2
	km_gmlabel	cilcle,2
	km_gmlabel	close,2
	km_gmlabel	off,2

	xalc	xhdma_circhofstmp,0
	km_labelstart	xhdma_circhofstmp
	km_label	xhdma_circhofsp1_buf1,bitmapvheight*8*2
	km_label	xhdma_circhofsp2_buf1,bitmapvheight*8*2
	km_label	xhdma_circhofsp1_buf2,bitmapvheight*8*2
	km_label	xhdma_circhofsp2_buf2,bitmapvheight*8*2
	km_labellen	circbuflen
	xalc	xhdma_circhofs,circbuflen

;=== Hit Flash Window Buffer ===
	xalc	xhdma_htflhofstmp,0
	km_labelstart	xhdma_htflhofstmp
	km_label	xhdma_htflhofsp1_buf1,2
	km_label	xhdma_htflhofsp2_buf1,2
	km_label	xhdma_htflhofsp1_buf2,2
	km_label	xhdma_htflhofsp2_buf2,2
	km_labellen	htflbuflen
	xalc	xhdma_htflhofs,htflbuflen

;=== Pause Window Buffer ===
	xalc	xhdma_pausehofstmp,0
	km_labelstart	xhdma_pausehofstmp
	km_label	xhdma_pausehofsp1_buf1,2
	km_label	xhdma_pausehofsp2_buf1,2
	km_label	xhdma_pausehofsp1_buf2,2
	km_label	xhdma_pausehofsp2_buf2,2
	km_labellen	pausebuflen
	xalc	xhdma_pausehofs,pausebuflen

;=== Area Out Window Buffer ===
	xalc	xhdma_outhofstmp,0

	km_label	xhdma_outhofsp1_buf1,2
	km_label	xhdma_outhofsp2_buf1,2
	km_label	xhdma_outhofsp1_buf2,2
	km_label	xhdma_outhofsp2_buf2,2
	km_labellen	outbuflen
	xalc		xhdma_outhofs,outbuflen

;* H-DMA Table Window On ,Off data RAM***
	xalc	hdmawindowon,4
	xalc	hdmawindowoff,4
;=====================================================================
;*			H-V Scroll RAM				*
;=====================================================================
;***** (HVScroll) H-DMA Table Address *****
	alc	kw_HVscrollflag,1
khvsf_all	equ	-1
	km_flagstart
	km_flag		khvsf_typesel	;1
;;;;	km_flag		khvsf_explain	;2	;'94/10/31 delete
	km_flag		khvsf_raster	;2

	km_size		kscrollmax

	alc	kw_rastermode,1
	km_labelstart
	km_label	krsf_noraster	;0
	km_label	krsf_marine	;1
	km_label	krsf_corona	;2

;* For mission & battle player select *
;--- scroll ---
	alc	kw_bg1hofs,2
	alc	kw_bg2hofs,2
	alc	kw_bg3hofs,2
	alc	kw_bg3vofs,2
	xalc	kx_bg3hofstm,1	;timer

	xalc	kx_hscrollp1,2
	xalc	kx_vscrollp1,2
	xalc	kx_hscrollp2,2
	xalc	kx_vscrollp2,2

;* kawaguchi test :raster scroll data set pointer *
	xxalc	xxpointer,2
	xxalc	khscrollptr,2	
	xxalc	kvscrollptr,2	
	xxalc	kseascrollptr,2
	xxalc	kseascroll,2

;*** H scroll ***
	alc	kw_hdma_hscraddr1,2
	alc	kw_hdma_hscrflag1,1
	alc	kw_hdma_hscraddr2,2
	alc	kw_hdma_hscrflag2,1
	defflaglist	khsf
	defflag		repeat		;1 ... repeat data

	xxalc	xh_hscrolltbl1,2
	xxalc	xh_vscrolltbl1,2
	xxalc	xh_hscrolltbl2,2
	xxalc	xh_vscrolltbl2,2
	xxalc	xh_yajiHtbl1_buf1,(bitmapvheight)*8*2
	xxalc	xh_yajiHtbl2_buf1,(bitmapvheight)*8*2
	xxalc	xh_yajiHtbl1_buf2,(bitmapvheight)*8*2
	xxalc	xh_yajiHtbl2_buf2,(bitmapvheight)*8*2

;*** V scroll ***
	alc	kw_hdma_vscraddr1,2
	alc	kw_hdma_vscrflag1,1
	alc	kw_hdma_vscraddr2,2
	alc	kw_hdma_vscrflag2,1
	defflaglist	kvsf
	defflag		repeat
	defflag		switch		;0/1 ... raster on

	xxalc	xh_yajiVtbl1_buf1,(bitmapvheight)*8*2
	xxalc	xh_yajiVtbl2_buf1,(bitmapvheight)*8*2
	xxalc	xh_yajiVtbl1_buf2,(bitmapvheight)*8*2
	xxalc	xh_yajiVtbl2_buf2,(bitmapvheight)*8*2
	xxalc	seavscroll_buf,19

;=====================================================
;*		CGX,Screen Transfer work	*
;=====================================================
	xalc	KCGSCTranssw,1 
	xalc	KCGSCTransTimer,1
	xalc	KCGSCTransPtr,1
	xalc	KCGXSCRTransVRAMAddr,2
	xalc	KCGXSCRTransVRAMBank,1
	xalc	KCGXSCRTransCPUAddr,2
	xalc	KCGXSCRTransCPUBank,1
	xalc	KCGXSCRTransVal,2

;=====================================================
;*		Path Data tmp work		*
;=====================================================
	xalc	kbyte1,1
	xalc	kbyte2,1
	xalc	kword1,2

;=====================================================
;*		Player Parameters		* 
;=====================================================
	xalc	KRadarFlag,1
;	P1radonFl	equ	1<<0
;	P1radmodeFl	equ	1<<1
;	P1radScChFl	equ	1<<2

;	P2radonFl	equ	1<<4
;	P2radmodeFl	equ	1<<5
;	P2radScChFl	equ	1<<6

;=====================================================
;*		Soft Ware Timer,Counter		*
;=====================================================
	xalc	ColFlPnt,2

	xalc	P1RingOutTm,1
	xalc	P2RingOutTm,1

	xalc	PushStartTm,1
;-----------------------------------------------------
;1 flame timer
	xalc	Bdectimer,7
	km_worklabelstart	Bdectimer
	km_worklabel	B,KDecTimer
	km_worklabel	B,SecondTimer
	km_worklabel	B,FlashTimer	
	km_worklabel	B,ColWinTimer
	km_worklabel	B,P1SecTm
	km_worklabel	B,P2SecTm
	km_worklabel	B,demoTimer
	km_worklabelend
	km_workvalcheck	7
;-----------------------------------------------------
	xalc	Binctimer,1
Binctmend	equ	Binctimer+1
;-----------------------------------------------------
	xalc	Wdectimer,2
Wdectmend	equ	Wdectimer+2
;-----------------------------------------------------
	xalc	Winctimer,2
Winctmend	equ	Winctimer+2
;-----------------------------------------------------
	xalc	kx_2GframeTm,2
	xalc	kx_4GframeTm,2
	xalc	kx_8GframeTm,2
;-----------------------------------------------------
;* 94/4/15
;kono timer no seide ushirtono work wo kowashite ita

;=====================================================
;*	Color Change Parameter			*
;=====================================================
	xalc	kx_check,2	;test no tameno work :atode kesu !!
	xalc	kx_palette,512	;CG buffer
	xalc	kx_palette1,384	;colour palette tenkai RAM
	xalc	kx_palette2,256	;colour palette tenkai RAM
;------------------------------------------------------------------------
;* BG background *
	xalc	coltimer_0,1
	xalc	colptr_0,1	;1 byte :color table pointer (step 32)
	xalc	coladr_0,3	;3 byte :color table address

	xalc	ColChPara,4
CoronaColPtr	equ	ColChPara+0	;1byte	;Corona Color kakikae
	xxalc	ColChBuffer,8*2
Colpalette3	equ	ColChBuffer+0
;------------------------------------------------------------------------
	xalc	colptr_1,2
	xalc	coladr_1,3

	xalc	RadarColChBuf,4*2
Blcolbuf_0	equ	RadarColChBuf+$0c*2	;2 byte
Recolbuf_0	equ	RadarColChBuf+$0d*2	;2 byte
Yecolbuf_0	equ	RadarColChBuf+$0e*2	;2 byte
Grcolbuf_0	equ	RadarColChBuf+$0f*2	;2 byte

	ifeq	1
Blcolbuf_1	equ	RadarColChBuf+$1c*2	;2 byte
Recolbuf_1	equ	RadarColChBuf+$1d*2	;2 byte
Yecolbuf_1	equ	RadarColChBuf+$1e*2	;2 byte
Grcolbuf_1	equ	RadarColChBuf+$1f*2	;2 byte
Blcolbuf_2	equ	RadarColChBuf+$2c*2	;2 byte
Recolbuf_2	equ	RadarColChBuf+$2d*2	;2 byte
Yecolbuf_2	equ	RadarColChBuf+$2e*2	;2 byte
Grcolbuf_2	equ	RadarColChBuf+$2f*2	;2 byte
	endc
;=====================================================
;*	Bit Map Character Transfer Buffer	*
;=====================================================
; (Source Address,Destinition Address)

	xalc	BmChrBuf,32
GmTmChrBuf	equ	BmChrBuf+0	;3*2*5
;-----------------------------------------------------
;=====================================================
;*		Sound Parameter			*
;=====================================================
;sound
	alc	kw_soundflag,1
ksf_all	equ	-1

	defflaglist	ksf	;ksf_{flag}
	defflag	allstop		;0/1 ... sound all stop (port 0,1,2,3)
	defflag	addrchange	;tensou address syuusei 0(shinai)/1(suru)

;* Sound Data tensou saki henkou address *
	alc	kw_sndhenkouaddr,2

;* apu port 0 *
	alc	bgmcnt,1
	alc	bgm_music,1
	alc	bgm_back,1
	alc	bgm_place,2
	alc	bgm_placeback,2
;* apu port 1 *
	alc	sdport1,1
;* apu port 2 *
	alc	sdport2,1	;sound port 2
	alc	sdchkno2,1	;check sound No
	alc	sdchkptr2,2	;check alien pointer

	alc	sdport2tmp,1	;tmp sound port 2
	alc	sdchkno2tmp,1	;tmp check sound No
	alc	sdchkptr2tmp,2	;tmp check alien pointer

	alc	sdbakport2,1	;back sound port 2
	alc	sdbakno2,1	;back sound No
	alc	sdbakptr2,2	;back alien pointer

	alc	sddist2,2	;distance check work
;* apu port 3 *
	alc	sdport3,32
	alc	sdspt3,2
	alc	sdgpt3,2
	alc	sdpck3,1

	alc	pausesnd,1
	alc	circleaff,1
	alc	firstdnld,1
	alc	monoral,1


	ifeq	1
	alc	ktpx,2
	alc	ktpy,2
	alc	ktpz,2
	alc	playersndflag,1
	alc	lastplayx,2
	alc	lsnd,1
	alc	csnd,1
	alc	rsnd,1
	alc	msnd,1
	alc	fsnd,1
	alc	snd_ptr,2
	alc	lastblock,2
	endc

;*********************************************************************
;*								*
;*								*
;*********************************************************************

	alc	flashbg,1
	alc	fadetored,1
	alc	dogyirq,1
	alc	flashtunnelon,1
	alc	c_type,1
	alc	noirqbit3,1
	alc	pallen,2

;----- bg request flags
	alc	bgflags,1
bgf_restart	equ	1
bgf_foxy	equ	2
bgf_bg	equ	4
bgf_info	equ	8
bgf_text	equ	16

	alc	restartcol,1		;on level 3-3, 1=use sea, 2=use gnd

;----- end sequence vars
	alc	palfrom,2
	alc	palto,2
	alc	viewyoff,2
	alc	democnt,2
	alc	demoptr,2
	alc	bg3vofsbak,2
	alc	bg3hofsbak,2
	alc	bg2vofsbak,2
	alc	bg2hofsbak,2
	alc	bg1vofsbak,2
	alc	bg1hofsbak,2
	alc	bg3vofsreq,2
	alc	bg3hofsreq,2
	alc	bg2vofsreq,2
	alc	bg2hofsreq,2
	alc	bg1vofsreq,2
	alc	bg1hofsreq,2

;end sequence
	xalc	lrtw,4
	alc	noxrot,1

sprar_up	equ	1
sprar_down	equ	2
sprar_left	equ	4
sprar_right	equ	8
	alc	arrows,1
	alc	specflash,1
	alc	wintabptr,2
	alc	sprframe,2
	alc	onecredspr,1
	alc	doneacircle,1

	alc	nosetport3,1
	alc	doawipe,1
	alc	doingwipe,1


le_fadetowhite	equ	4
le_fadedown	equ	5
le_endofgame	equ	6
le_startgame	equ	7
le_endofcreds	equ	8
le_endtotalscore equ	9
le_gameover	equ	10
le_bhole1	equ	11
le_bhole2	equ	12
le_bhole3	equ	13
le_special	equ	14
le_enterbhole	equ	15
le_enterspec	equ	16

	alc	levelfinished,2

	alc	kcvposx,2
	alc	kcvposy,2
	alc	kcvposz,2

	alc	contsmart,1
	alc	nmitemp2,2
	alc	bg2vofsoverride,1
	xalc	hadabumhole,2
	xalc	contexit,2
	alc	prttraining,1
	alc	defaulttrain,1
	alc	numendok,1
	alc	port1bolox,1

rotate_hof	equ	0
tunnel1_hof	equ	2
tunnel2_hof	equ	4
water_hof	equ	6
tunnel3_hof	equ	8
nograd_hof	equ	10
bhole_hof	equ	12
bholescale_hof	equ	14
	alc	hposjmp,2
	xalc	bholescaleval,2



