;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         SCREEN.ASM                                          ;
; AUTHOR:       Yasuhiro Kawaguchi                                  ;
; DESCRIPTION:  Screen Initialisation Code                          ;
; DATE CREATED: 12-5-93                                             ;
;                                                                   ;
;-------------------------------------------------------------------;

	INCPUB	kscreen
;*********************************************************************
;*		KSCREEN.ASM Routines				*
;*********************************************************************
;set_kscreen_l,Kscr_onescreen,Kscr_twoscreen
;SetCockpitCharacter,BoostMeter,DAMAGE,SCORE
;SetCockpitColor,Change_colpalette
;SetCockpitWindow
;*********************************************************************
;*		CockPit Parameters & Vars			*
;*								*
;*********************************************************************
;*********************************************************************
;*			Macro Definishion			*
;*********************************************************************
;---------------------------------------------------------------------
;*		MISSION Parameters				*
;---------------------------------------------------------------------
SetPlHeapPtr	macro	[player,obj1]
MYNARG	=	NARG
	CHK_NARG	2

	shorta
	longi
	km_plheapptr	{player},{obj1}

	lda	#{player}
	lsr	a	
	sta	kplayer

	endm


;*********************************************************************
;*								*
;*			PROGRAM START				*
;*								*
;*********************************************************************
;=====================================================================
;*			JMP Routine				*
;=====================================================================
set_kscreen_l
	km_PushAllReg
	a8i16
	db7e

;* No Screen Check *
	test_screenmode	noscreen
	bne	.noscreen
	jmp	.SetScreen
.noscreen
	km_PullAllReg
	rtl

;-------------------------------------------------------------
;*		Screen Select	[one screen,two screen]	*
;-------------------------------------------------------------
.SetScreen
	km_ldxscreenmode
	jmp	(KScrJmpTab,x)

KScrJmpTab
	dw	Kscr_title&WM
	dw	Kscr_mission&WM
	dw	Kscr_battle&WM
	dw	kscr_missionexplain&WM
	dw	kscr_missionmap&WM

;=====================================================================
;* 			MISSION MODE				*
;* Init Mode a8i16							*
;* Data Bank 7e							*
;* X reg :player work pointer					*
;=====================================================================
kscr_title
kscr_missionmap

	shorta
	longi

;* All Register Pull *
	km_PullAllReg
	rtl

;=====================================================================
;* 			MISSION EXPLAIN				*
;* Init Mode a8i16							*
;* Data Bank 7e							*
;=====================================================================
planet_motox		equ	($1b-2)*8+4
planet_motoy		equ	(6-2)*8
planet_sakix		equ	(4-2)*8+4
planet_sakiy		equ	($e-2)*8

planet_radius	equ	$10
;---------------------------------------------------------------------
kscr_missionexplain
	km_PullAllReg
	rtl

kexp_makingplanet_l
	shorta
	longi
	phb
	db7e
;* Mario Access Enable *
	a8
	poll_mario
	a16

	lda KGameMapPtr
	km_loba
	asl	a
	tax
	lda.l	missionmaptbl3,x
	km_beq	.end
	sta.l	msprite
;* planet making (tensou saki)*
	lda	#planet_motox
	sta.l	m_xc
	lda	#planet_motoy
	sta.l	m_yc
	lda	#planet_radius
	sta.l	m_radius
	lda	#(15*32768)/16
	sta.l	m_scale
	sta.l	mspr_pal

	lda.l	kxswork+32
	clc
	adc	#$0020
	sta.l	kxswork+32
	sta.l	m_roty

	lda	#$0
	sta.l	m_rotx
	sta.l	m_rotz
	call_mario	MMakePlanet2

;* shadow making (tensou moto) *
	lda	#planet_sakix
	sta.l	m_xc
	lda	#planet_sakiy
	sta.l	m_yc
	lda	#shadow_spr
	sta.l	msprite

	lda	#$2000
	sta.l	m_rotx
	lda	#$4000
	sta.l	m_rotz

	call_mario	MMakePlanet2

;* merge planet *
	lda	#(4-2-2)
	sta.l	m_x1
	lda	#($e-2-2)
	sta.l	m_y1
	lda	#($1b-2-2)
	sta.l	m_bigx
	lda	#(6-2-2)
	sta.l	m_bigy
	call_mario	MMergePlanet
.end
	a8
	unpoll_mario
;;;	km_PullAllReg
	plb
	rtl


missionmaptbl3
	dw	planet1_spr	;stg1
	dw	planet2_spr	;stg2
	dw	planet3_spr	;stg3
	dw	planet4_spr	;stg4
	dw	0		;stg5
	dw	planet6_spr	;stg6
	dw	0		;ext1
	dw	0		;ext2
	dw	0		;ext3
	dw	0		;ext4
	dw	0		;sos1
	dw	0		;sos2
	dw	0		;sos3
	dw	0		;


;=====================================================================
;* 			MISSION MODE				*
;* Init Mode a8i16							*
;* Data Bank 7e							*
;* X reg :player work pointer					*
;=====================================================================
Kscr_mission
	shorta
	longi

	SetPlHeapPtr	1,x
	jsr	Change_colpalette	;[colour]
;* All Register Pull *
	km_PullAllReg
	rtl

;=====================================================================
;* 			2 Player Battle				*
;* Init Mode a8i16							*
;* Data Bank 7e							*
;* X reg :player work pointer					*
;=====================================================================
Kscr_battle
	shorta
	longi
;* player 1 *
	SetPlHeapPtr	1,x
	jsr	SetCockpitCharacter	;[BG kakikae]

;* player 2 *
	SetPlHeapPtr	2,x
	jsr	SetCockpitCharacter	;[BG kakikae]

	jsr	SetCockpitColor		;[colour]
	jsr	Change_colpalette	;[colour]

;* All Register Pull *
	km_PullAllReg
	rtl
;*********************************************************************
;=====================================================================
;*			SOB ROUTINE				*
;*								*
;=====================================================================
;*********************************************************************
;=====================================================================
;*								*
;*			BG (CGX,SCR) KAKIKAE			*
;*								*
;=====================================================================
SetCockpitCharacter
;---------------------------------------------------------------------
;*			Radar Screen Change			*
;* Data Bank 7E							*
;* Xreg :player work pointer						*
;---------------------------------------------------------------------
RadarScreen
	ifeq	1
	shorta
	longi
;--------- Check Radar Mode Change ---------
	testjoypad	select
	beq		.nextcheck1

	eorflag.l	KRadarFlag,#P1radmodeFl
	setflag.l	KRadarFlag,#P1radScChFl
.nextcheck1
	testjoypad2	select
	beq		.SetRADSCR
	eorflag.l	KRadarFlag,#P2radmodeFl
	setflag.l	KRadarFlag,#P2radScChFl
.SetRADSCR
	KRDSCR_P1	1
	KRDSCR_p2	2
	a8
	endc
;---------------------------------------------------------------------
;*			BOOST Meter Display			*
;* Data Bank 7e							*
;* X reg :player work pointer					*
;* Attention :tensoumoto tensouski no set ni tyuui			*
;*	:tensousaki wo saki ni set (x register)			* 
;---------------------------------------------------------------------
BoostMeter
	shorta
	longi
	phx
	lda	exal_boost,x
	bmi	.BoostOn		;If 	 Boost On
	jmp	.BoostEnd		;elseif  Boost Off
;------------------------------------------------------------------
.BoostOn
	and	#%00111111
	cmp	#40
	bpl	.check1
	jmp	.ChangMeter	;if HP < 40 then HP meter set
.check1	beq	.FullHP		;if HP = 40 then HP meter Full display
 	jmp	.BoostEnd	;if HP > 40 then not character change
;------------------------------------------------------------------
.FullHP
	ifeq	1
	KcopyBitmapFixChr	8,$6f,32
	KcopyBitmapFixChr	8,$70,32
	KcopyBitmapFixChr	8,$71,32
	KcopyBitmapFixChr	8,$72,32
	KcopyBitmapFixChr	8,$73,32
	endc
 	jmp	.BoostEnd
;------------------------------------------------------------------
.ChangMeter
	km_jmpflag_a	%00000111,.BoostPatern1to7  ;If 8 no baisuu de nakereba
	km_bitcheckflag	exal_boost,BoostSign,x
	bne	.BoostPatern8			;If Meter Inc
;------------------------------------------------------------------
.BoostPatern0
;Boost Character Patern 0
;Boost Dec Meter = (40,32,24,16,8)
	a16
	lda	exal_boost,x
	and	#$3f
	km_divu8
	clc
	adc	#BmBoost
	tay			;tensou saki

	lda	#0
	clc
	adc	#RomBoost
	tax			;tensou moto
	jmp	.SetBoost
;------------------------------------------------------------------
.BoostPatern8
;Boost Character Patern 8
;Boost Inc Meter = (8,16,24,32,40)
	a16

	lda	exal_boost,x
	and	#$3f
	beq	.BoostMeterZero
	km_divu8
	dec	a
	clc
	adc	#BmBoost	;tensou saki
	tay

	lda	#8
	clc
	adc	#RomBoost
	tax			;tensou moto
	jmp	.SetBoost
;------------------------------------------------------------------
.BoostMeterZero
;Boost Character Patern 0
;Boost Meter =0
	ldx	#RomBoost
	ldy	#BmBoost
	jmp	.SetBoost
;------------------------------------------------------------------
.BoostPatern1to7
;Boost Character Patern from 1 to 8
;Case Boost Meter Inc & Dec
	a16

	lda	exal_boost,x
	and	#$3f
	km_divu8
	clc
	adc	#BmBoost
	tay			;tensou saki

	lda	exal_boost,x
	and	#7
	clc
	adc	#RomBoost
	tax			;tensou moto
;------------------------------------------------------------------
.SetBoost
	KcopyBitMapChr_xy	32
;------------------------------------------------------------------
.BoostEnd
	plx
	a8
;---------------------------------------------------------------------
;*			DAMAGE Meter				*
;* Data Bank 7E							*
;* X reg : player work pointer					* 
;* KHP   : Max 10 :b7 (flag),b3-b6 (integer HP),b0-b2 (decimal HP)	*
;---------------------------------------------------------------------
DAMAGE
	shorta
	longi

;==== Check hit damage ====
	km_jmpnotflag	KHP,kdmgflag,.NoDamage,X
;==== HP Meter Copy =====
.SetHP
	phx
	phy

	lda	#0
	xba

	lda	khp,x
	pha
	and	#%00000111
	tax
	lda.l	HPtable,x
	tax			;ROM pointer

	pla
	and	#kdmgflag^(-1)
	km_shiftRUA3
	clc
	adc	#BmDMGMT
	tay			;Mario RAM Character Pointer

	KcopyBitMapChr_xy	32

	ply
	plx
	km_clrflag		KHP,kdmgflag,x
.NoDamage
	a8
;---------------------------------------------------------------------
;*		GAME Score Meter 				*
;* Data Bank 7E							*
;* X reg : player work pointer					* 
;---------------------------------------------------------------------
SCORE
	phx
	phy

	ai16
	lda	kscore,x
	bne	.Score1
	jmp	.SCOREend
.Score1
	km_cpudivu16uf8_xy	10	;Init:Acc
				;Exit:x:syou,y:amari
	tya
	kcopyBitMapChr_a	ROMscore,BmSCORE+4,32
	cpx	#0		;shouno check
	bne	.Score10	;if syou = 0 then spr display end
	jmp	.SCOREend
.Score10
	txa
	km_cpudivu16uf8_xy	10	;Init:Acc ,Exit:x:syou,y:amari
	tya
	kcopyBitMapChr_a	ROMscore,BmSCORE+3,32
	cpx	#0
	bne	.Score100	;if syou = 0 then spr display end
	jmp	.SCOREend
.Score100
	txa
	km_cpudivu16uf8_xy	10	;Init:Acc ,Exit:x:syou,y:amari
	tya
	kcopyBitMapChr_a	ROMscore,BmSCORE+2,32
	cpx	#0
	bne	.Score1000	;if syou = 0 then spr display end
	jmp	.SCOREend
.Score1000
	txa
	km_cpudivu16uf8_xy	10	;Init:Acc 
				;Exit:x:syou,y:amari
	tya
	kcopyBitMapChr_a	ROMscore,BmSCORE+1,32
	cpx	#0		;syou no check
	bne	.Score10000	;if syou = 0 then spr display end
	jmp	.SCOREend
.Score10000
	txa
	km_cpudivu16uf8_xy	10	;Init:Acc 
				;Exit:x:syou,y:amari
	tya
	kcopyBitMapChr_a	ROMscore,BmSCORE+0,32
.SCOREend
	a8
	ply
	plx
	rts
;=====================================================================
;*			Color Flashing				*
;* Color Kakikae							*
;* Data Bank 7e							*
;* Xreg :player work pointer						*
;=====================================================================
SetCockpitColor
	shorta
	phx
	i8
	lda	FlashTimer
	bne	.ColorFlashEND

	lda	#1
	sta	FlashTimer	;flashing timer reset

	lda	ColFlPnt
	inc	a
	inc	a
	cmp	#8
	bne	.skip
	lda	#0
.skip
	sta	ColFlPnt
	tax			;Color Pointer change

	a16
	lda.l	GreenFlTable,x
	sta	Grcolbuf_0

	lda.l	BlueFlTable,x
	sta	Blcolbuf_0

	lda.l	RedFlTable,x
	sta	Recolbuf_0

	lda.l	YellowFlTable,x
	sta	Yecolbuf_0
	a8
.ColorFlashEND
	i16
	plx
	rts
;---------------------------------------------------------------------
BlueFlTable
;	dw	$7ff1,$7f60,$7e80,$7f60
	dw	$7fe7,$7f40,$7ea0,$7f40
RedFlTable
;	dw	$47ff,$033f,$027f,$033f
	dw	$1dbf,$14ff,$0437,$14ff
YellowFlTable
;	dw	$56bf,$299f,$18d9,$299f
	dw	$03ff,$037b,$02f7,$037b
GreenFlTable
	dw	$17e5,$1b86,$0f23,$1b86

;=====================================================================
;*			Palette Change				*
;* mem8 idx16							*
;* data bank = 7e							*
;*colptr_0	:color table pointer (step 32)				*
;*coladr_0	:color table address					*
;*kx_palette :colour data main buffer 512 byte			*
;*kx_palette2:BG palette 4 no tameno colour table buffer		* 
;=====================================================================
pal4adr	equ	4*16*2
pallength	equ	16*2
;-------------------------------------------------
Change_colpalette
	shorta
	longi

	km_bitcheckscreenflag	bgcolpal	;[SCREEN FLAG]
	km_beq	.setradarflash
;--------------------------------------------------
;* colour timer set *
;* 3 GAME Flame ni 1 kai colour change *
	dec	coltimer_0
	bne	.NoColChange

	km_addstaval	colptr_0,32	;Pointer +32 (1 palette)
	km_setval	coltimer_0,3	;Timer reset

;* msiion map no baai *
	km_cmpcheckgamemode	selectmissionmap
	bne	.NoColChange
	km_setval	coltimer_0,10	;Timer reset
.NoColChange
;--------------------------------------------------
;* tensou *
;BG colour palette 4 ni colour data (haikei) wo tensou
	km_lldx	colptr_0
	ldy	#pal4adr
	km_blocktransXY	kx_palette2,kx_palette,pallength

	IFEQ	1
	a16
	lda	colptr_0
	and	#$ff
	clc
	adc	#kx_palette2&WM
	sta	coladr_0	;address
	a8
	lda	#kx_palette2>>16
	sta	coladr_0+2	;bank
	ENDC
;=====================================================================
;*			Radar Flash (Sprites)			*
;=====================================================================
.setradarflash
	IFEQ	1
	a16
;* pointer idou *
	km_addtimer	colptr_1,16*2*3,16*2*3*4
	lda	colptr_1
	clc
	adc	#kx_palette1&WM		;rdfl_pac&WM
	sta	coladr_1
	a8
	lda	#kx_palette1>>16	;rdfl_pac>>16
	sta	coladr_1+2

	ENDC
;--------------------------------------------------
.end
	rts


;**************************************************************************
;**************************************************************************
;**************************************************************************
;=============================================================
;*			Pause Window		[PAUSE]	* 
;=============================================================
	ifeq	1
PauseWindow
	shorta
	longi

	phx
	phy
	ldy	#0	;HDMA Table Pointer

	ifeq	0
;======== Player 1 Window Flash =======
	jmpnotgameflag	p12pauseflag,.PauseWindowEnd
;------- Player 1 HDMA Data Copy ------
.PauseWindowP1

	KHDMATbl	y,#(P1WinYSta-1),#NoWinXSta,#NoWinXEnd,pausehofs
	KHDMATbl	y,#(P1WinYEnd)-(P1WinYSta),#P1HtFlXSta,#P1HtFlXEnd,pausehofs
.PauseWindowP2
	KHDMATbl	y,#LineNumber8,#NoWinXSta,#NoWinXEnd,pausehofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2WinXSta,#P2WinXEnd,pausehofs
.FlashEnd
	KHDMAtblEND	y,pausehofs	;Set HDMA dummy data
	endc

	ifeq	1
;======== Player 1 Window Flash =======
	jmpgameflag	p1pauseflag,.PauseWindowP1
	jmpnotgameflag	p2pauseflag,.PauseWindowEnd

.PauseWindowP2Only
	KHDMATbl	y,#(P2WinYSta-1),#NoWinXSta,#NoWinXEnd,pausehofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2HtFlXSta,#P2HtFlXEnd,pausehofs
	jmp	.FlashEnd
;------- Player 1 HDMA Data Copy ------
.PauseWindowP1

	KHDMATbl	y,#(P1WinYSta-1),#NoWinXSta,#NoWinXEnd,pausehofs
	KHDMATbl	y,#(P1WinYEnd)-(P1WinYSta),#P1HtFlXSta,#P1HtFlXEnd,pausehofs

	jmpnotgameflag	p2pauseflag,.FlashEnd
.PauseWindowP2
	KHDMATbl	y,#LineNumber8,#NoWinXSta,#NoWinXEnd,pausehofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2WinXSta,#P2WinXEnd,pausehofs
.FlashEnd
	KHDMAtblEND	y,pausehofs	;Set HDMA dummy data
	endc

;============ Window Register Para Set ===============
	alloc_window	pausewindow,1	; x = hitfalsh

	lda	#%00000011
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#%00010000
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#%11000011
	sta	wm_cgadsub,x	;2131h	;1/2 bg1 bg2

	lda	#$23
	sta	wm_coldata_r,x	;2132h	;Red

	lda	#$43
	sta	wm_coldata_g,x	;2132h	;Green

	lda	#$83
	sta	wm_coldata_b,x	;2132h	;Blue

	ldy	#xhdma_pausehofs&WM
	sty	wm_hdma,x	;4302h,4303h	:hdma table address
	lda	#xhdma_pausehofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address
;-------------------------------------------------------------------------
.PauseWindowEnd
	ply
	plx
	a8
	rts
	endc


	ifeq	1
RingOutWindow
	shorta
	longi

	ldy	#0	;HDMA Table Pointer
;======== Player 1 Window Flash =======
	km_plheapptr	1,x
	jmpflag		KRingOutTimer,#KROutFlag,.Pl1Flash,x
	km_plheapptr	2,x
	jmpnotflag	KRingOutTimer,#KROutFlag,.RingOutWindowOff,x
.Pl2FlashOnly
	KHDMATbl	y,#(P2WinYSta-1),#NoWinXSta,#NoWinXEnd,outhofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2HtFlXSta,#P2HtFlXEnd,outhofs
	jmp	.FlashEnd
;------- Player 1 HDMA Data Copy ------
.Pl1Flash
	KHDMATbl	y,#(P1WinYSta-1),#NoWinXSta,#NoWinXEnd,outhofs
	KHDMATbl	y,#(P1WinYEnd)-(P1WinYSta),#P1HtFlXSta,#P1HtFlXEnd,outhofs

	km_plheapptr	2,x
	jmpnotflag	KRingOutTimer,#KROutFlag,.FlashEnd,x
.P2Flash
	KHDMATbl	y,#LineNumber8,#NoWinXSta,#NoWinXEnd,outhofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2WinXSta,#P2WinXEnd,outhofs
.FlashEnd
	KHDMAtblEND	y,outhofs	;Set HDMA dummy data

;============ Window Register Para Set ===============
	alloc_window	outofbounds,1	; x = outofbounds
	km_plheapptr	1,y		; y = player work pointer

	lda	#%00000011
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#%00010000
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#%10000011
	sta	wm_cgadsub,x	;2131h	;col sub (bg1,bg2)

	ifeq	0
	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#%11100000
	sta	wm_coldata,x	;2132h	;Red Blue Green
	endc

	ifeq	1
	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$20
	sta	wm_coldata_r,x	;2132h	;Red

	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$40
	sta	wm_coldata_g,x	;2132h	;Green

	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$80
	sta	wm_coldata_b,x	;2132h	;Blue
	endc

	ldy	#xhdma_outhofs&WM
	sty	wm_hdma,x	;4302h,4303h	:hdma table address
	lda	#xhdma_outhofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address

	jmp	.RingOutWindowEnd

.RingOutWindowOff
	dealloc_window	outofbounds,1	;if Ring Out Window End

.RingOutWindowEnd

;---------------------------------------------------------------------
;*			Hit Flash Window			* 
;* Init,Exit Memory Mode :mem8,idx16					*
;* Data Bank 7e							*
;* Yreg : HDMA table pointer 					*
;---------------------------------------------------------------------
HitFlashWindow
	shorta
	longi

	ldy	#0	;HDMA Table Pointer
;======== Player 1 Window Flash =======
	km_plheapptr	1,x
	s_jmp_alvarNOTzero	B,x,exal_nohit,.Pl1Flash
	km_plheapptr	2,x
	s_jmp_alvarzero		B,x,exal_nohit,.HitFlashWindowOff
.Pl2FlashOnly
	KHDMATbl	y,#(P2WinYSta-1),#NoWinXSta,#NoWinXEnd,htflhofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2HtFlXSta,#P2HtFlXEnd,htflhofs
;;;;;	KHDMAtblEND	y,htflhofs
	jmp	.FlashEnd
;------- Player 1 HDMA Data Copy ------
.Pl1Flash
	KHDMATbl	y,#(P1WinYSta-1),#NoWinXSta,#NoWinXEnd,htflhofs
	KHDMATbl	y,#(P1WinYEnd)-(P1WinYSta),#P1HtFlXSta,#P1HtFlXEnd,htflhofs

	km_plheapptr	2,x
	s_jmp_alvarzero	B,x,exal_nohit,.FlashEnd
.P2Flash
	KHDMATbl	y,#LineNumber8,#NoWinXSta,#NoWinXEnd,htflhofs
	KHDMATbl	y,#(P2WinYEnd)-(P2WinYSta),#P2WinXSta,#P2WinXEnd,htflhofs
.FlashEnd
	KHDMAtblEND	y,htflhofs	;Set HDMA dummy data
;============ Window Register Para Set ===============
	alloc_window	hitflash,1	; x = hitfalsh


	lda	#00000011b
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#00010000b
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#00000011b
	sta	wm_cgadsub,x	;2131h	;bg1 bg2

	lda	#$03f
	sta	wm_coldata_r,x	;2132h	;Red

	lda	#$40
	sta	wm_coldata_g,x	;2132h	;Green

	lda	#$84
	sta	wm_coldata_b,x	;2132h	;Blue

	ldy	#xhdma_htflhofs&WM
	sty	wm_hdma,x	;4302h,4303h	:hdma table address
	lda	#xhdma_htflhofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address

	jmp	.HitFlashWindowEnd
.HitFlashWindowOff
	dealloc_window	hitflash,1	;if Hit Flash End
.HitFlashWindowEnd
;---------------------------------------------------------------------
;*			Circle Window				* 
;---------------------------------------------------------------------
CircleWindow
	ldy	#0
;=============== Player1 Circle Window Enable check ==============
	km_plheapptr	1,x
	jmpflag	KBOMSHOT,#kBomShotFlag,.Pl1CirWindow,x
	km_plheapptr	2,x
	jmpnotflag	KBOMSHOT,#kBomShotFlag,.SetWindowEND,x
	KHDMATbl	y,#(P2WinYSta-1),#NoWinXSta,#NoWinXEnd,circhofs
	jmp		.SetP2Window
.Pl1CirWindow
;------- Cilcle calculate --------
	a16
	lda	KBOMSHOT,x
	and	#$7f
	asl	a
	tax

	lda	#$68
	sta.l	m_bigx		;center X
	lda	#$40
	sta.l	m_bigy		;center Y

	lda.l	CircleData,x
	sta.l	m_rotx		;Radius

	call_mario	mcalc_circle	;Circle (L,R) data calc
;------- HDMA Data Copy ------
	a8
	KHDMATbl	y,#(P1WinXSta-1),#NoWinXSta,#NoWinXEnd,circhofs
	KHDMACilcleTbl	#(P1WinYEnd-P1WinYSta),#P1WinXSta,#P1WinXEnd,#P1WinYSta,#P1WinYEnd

	km_plheapptr	2,x
	jmpnotflag	KBOMSHOT,#kBomShotFlag,.SetWinLastDt,x

	KHDMATbl	y,#LineNumber8,#NoWinXSta,#NoWinXEnd,circhofs
;======= player2 window =======
.SetP2Window
	a16
	ldx	#viewblk2
	lda	al_ptr,x
	tax
	lda	al_sword2,x
	tax
	lda	KBOMSHOT,x
	and	#$7f
	asl	a
	tax

	lda	#$98
	sta.l	m_bigx	;center X
	lda	#$a8
	sta.l	m_bigy	;center Y

	lda.l	CircleData,x
	sta.l	m_rotx	;Radius

	call_mario	mcalc_circle
;------- HDMA Data Copy ------
	a8
	KHDMACilcleTbl	#(P2WinYEnd)-(P2WinYSta),#P2WinXSta,#P2WinXEnd,#P2WinYSta,#P2WinYEnd
.SetWinLastDt
	KHDMAtblEND	y,circhofs	;Set hdma (dummy & End code) data
;============ Window Register Para Set ===============
	alloc_window	circle,1	; x = window

	lda	#00000011b
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#00010000b
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#00000011b
	sta	wm_cgadsub,x	;2131h	;bg1 bg2

	lda	#$3f
	sta	wm_coldata_r,x	;2132h	;Red

	lda	#$45
	sta	wm_coldata_g,x	;2132h	;Green

	lda	#$9f
	sta	wm_coldata_b,x	;2132h	;Blue

	ldy	#xhdma_circhofs&WM
	sty	wm_hdma,x	;4302h,4303h	:hdma table address
	lda	#xhdma_circhofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address
	jmp	.SetWindowEND
.CircleWindowEnd
	dealloc_window	circle,1
;---------------------------------------------------------------------------
.SetWindowEND
	a8i16
	rts
	endc

;*********************************************************************
;*		Radar Screen Charcter Copy SubRoutine		*
;*********************************************************************
KcopyRdScChr_sub
	longa
	longi

	lda	#32-1
	db	$54
	db	bitmapbase>>16
	db	bg11_cgx>>16
	rts

;***************************************************************************

	incfile kscrdata.asm

;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************
;***************************************************************************


;*********************************************************************
;*								*
;*		SCREEN Transfer Method				*
;*********************************************************************
	ifeq	1
;---------------------------------------------------------------------
;*			GAME Timer Display			*
;---------------------------------------------------------------------
	ifeq	1
	shorta
	longi

;======== BG change Check =======
	lda.l	SecondTimer
	beq	.NoFlash	;if 1 second past
	cmp	#second/2
	beq	.SetFlash	;if half second past
	jmp	.TimerSetEnd
;======== Timer Flashing ========
.SetFlash
	KcopyBitMapFixChr	RSmcolFl,BmTmsemcol,32
	jmp	.TimerSetEnd
.NoFlash
	lda	#second
	sta.l	SecondTimer	;1sec counter reset
	KcopyBitMapFixChr	RSmcolNoFl,BmTmsemcol,32
;======= Time Change ============
.TimeSet
;-------- Calclate Game Time ---------------
	ai16
	lda.l	GameTimer
	dec	a
	bpl	.not_minus

	lda	#0
.not_minus
	sta.l	GameTimer

;-------- Convert 60 Min&60 sec --------
	kdivu16u8	xy,#60
	stx	kwork+0		;syou
	tya			;amari
	kdivu16u8	work,#10
				;ksyou	;10 sec
				;kamari	:01 sec
;1 seconds
	lda	kamari
	kcopyBitMapChr	RTmtop,Bmtm01sec,32

	lda	kamari
	cmp	#9
	beq	.Set10sec	;If 10 sec set
	jmp	.TimerSetEnd
;10 seconds
.Set10sec
	lda	ksyou
	kcopyBitMapChr	RTmtop,Bmtm10sec,32

	lda	ksyou
	cmp	#5
	beq	.Set01min	;If 01 min set
	jmp	.TimerSetEnd
.Set01min

	lda	kwork+0
	kdivu16u8	work,#10
				;ksyou	;10 min
				;kamari	:01 min
;1 minutes
	lda	kamari
	kcopyBitMapChr	RTmtop,Bmtm01min,32

	lda	kamari
	cmp	#9
	beq	.Set10min
	jmp	.TimerSetEnd
.Set10min
;10 minutes
	lda	ksyou
	kcopyBitMapChr	RTmtop,Bmtm10min,32

.TimerSetEnd
	a8
	endc
;---------------------------------------------------------------------
;*			GAME Timer Display			*
;---------------------------------------------------------------------
;************************* Screen Change Version ***********************
	ifeq	1
;------- Player 1 x,y,rot y ---------
	lda.l	SecondTimer
	beq	.SetTimer	;if 1 second past
	cmp	#second/2
	bne	.skip		;if not half second past

;======== Timer Flashing ========
	a16
	calcbgchar	timerchar,$2b,0,1,0
	lda	#timerchar
	sta.l	GtmScrChBuf+04
.skip
	jmp	.TimerSetEnd
.SetTimer
	shorta
	lda	#second
	sta.l	SecondTimer	;counter reset
;-------- timer flashing ---------
	a16
	calcbgchar	timerchar,$2c,0,1,0
	lda	#timerchar
	sta.l	GtmScrChBuf+04
;-------- Time Set ---------------
	lda.l	GameTimer
	dec	a
	bpl	.not_minus
	
	lda	#0
.not_minus
	sta.l	GameTimer

;---------- Display Time to screen buffer set -----------

	kdivu16u8	xy,#60

	sty	kwork+0		;amari

	txa			;syou
	kdivu16u8	xy,#10
;10 minutes

	txa
	asl	a
	tax
	lda.l	timertable,x
	sta.l	GtmScrChBuf+0

;1 minutes
	tya
	asl	a
	tax

	lda.l	timertable,x
	sta.l	GtmScrChBuf+2

	lda	kwork+0
	kdivu16u8	xy,#10
;10 seconds
	txa
	asl	a
	tax
	lda.l	timertable,x
	sta.l	GtmScrChBuf+6
;1 seconds

	tya
	asl	a
	tax
	lda.l	timertable,x
	sta.l	GtmScrChBuf+8
.TimerSetEnd
	endc
;---------------------------------------------------------------------
;*			BOOST Meter Display			*
;---------------------------------------------------------------------
;======================= Screen Transfer =============================
	ifeq	1
;======= Player1 ========
	ldx	#40*10
	lda	player1_boost
	bpl	.skip
	and	#%00111111
	kmultu8uf7	x,#10	;boost chara pointer
.skip
	a16
	lda.l	boosttable,x
	sta.l	Bo1ScrChBuf+0
	lda.l	boosttable+2,x
	sta.l	Bo1ScrChBuf+2
	lda.l	boosttable+4,x
	sta.l	Bo1ScrChBuf+4
	lda.l	boosttable+6,x
	sta.l	Bo1ScrChBuf+6
	lda.l	boosttable+8,x
	sta.l	Bo1ScrChBuf+8
	a8
;======= Player2 ========
.player2
	shorta
	LDX	#40*10
	lda	player2_boost
	bpl	.SKIP2
	and	#%00111111
	kmultu8uf7	x,#10	;boost chara pointer
.SKIP2
	a16
	lda.l	boosttable,x
	sta.l	Bo2ScrChBuf+0
	lda.l	boosttable+2,x
	sta.l	Bo2ScrChBuf+2
	lda.l	boosttable+4,x
	sta.l	Bo2ScrChBuf+4
	lda.l	boosttable+6,x
	sta.l	Bo2ScrChBuf+6
	lda.l	boosttable+8,x
	sta.l	Bo2ScrChBuf+8
	a8
	endc
;---------------------------------------------------------------------
;*		Radar CGX Data Copy 				*
;---------------------------------------------------------------------
KRDSCR_P1	macro	[pl]

	jmpnotflag.l	KRadarFlag,#P{pl}radScChFl,.P{pl}end
	jmpflag.l	KRadarFlag,#P{pl}radmodeFl,.P{pl}relative
	phb
	a16
;------ Player absolute radar ---------
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$0
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$1
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$2
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$3

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$4
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$5
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$6
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$7

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$8
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$9
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$a
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$b

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$c
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$d
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$e
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$f

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$10
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$11
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$12
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$13

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$14
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$15
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$16
	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$17

	kcopyRdScChr	$9,BmBase_cgx+BmP1Rd_cgx+$18
	plb
	a8
	jmp	.p{pl}clsflag
.p{pl}relative
	phb
	a16
;------- relative radar -------
	kcopyRdScChr	$09,BmBase_cgx+BmP1Rd_cgx+$0
	kcopyRdScChr	$50,BmBase_cgx+BmP1Rd_cgx+$1
	kcopyRdScChr	$51,BmBase_cgx+BmP1Rd_cgx+$2
	kcopyRdScChr	$52,BmBase_cgx+BmP1Rd_cgx+$3
	kcopyRdScChr	$0a,BmBase_cgx+BmP1Rd_cgx+$4

	kcopyRdScChr	$53,BmBase_cgx+BmP1Rd_cgx+$5
	kcopyRdScChr	$54,BmBase_cgx+BmP1Rd_cgx+$6
	kcopyRdScChr	$4e,BmBase_cgx+BmP1Rd_cgx+$7
	kcopyRdScChr	$55,BmBase_cgx+BmP1Rd_cgx+$8
	kcopyRdScChr	$56,BmBase_cgx+BmP1Rd_cgx+$9

	kcopyRdScChr	$57,BmBase_cgx+BmP1Rd_cgx+$a
	kcopyRdScChr	$4e,BmBase_cgx+BmP1Rd_cgx+$b
	kcopyRdScChr	$58,BmBase_cgx+BmP1Rd_cgx+$c
	kcopyRdScChr	$59,BmBase_cgx+BmP1Rd_cgx+$d
	kcopyRdScChr	$5a,BmBase_cgx+BmP1Rd_cgx+$e

	kcopyRdScChr	$5b,BmBase_cgx+BmP1Rd_cgx+$f
	kcopyRdScChr	$4e,BmBase_cgx+BmP1Rd_cgx+$10
	kcopyRdScChr	$4e,BmBase_cgx+BmP1Rd_cgx+$11
	kcopyRdScChr	$4e,BmBase_cgx+BmP1Rd_cgx+$12
	kcopyRdScChr	$5c,BmBase_cgx+BmP1Rd_cgx+$13

	kcopyRdScChr	$0b,BmBase_cgx+BmP1Rd_cgx+$14
	kcopyRdScChr	$5d,BmBase_cgx+BmP1Rd_cgx+$15
	kcopyRdScChr	$5e,BmBase_cgx+BmP1Rd_cgx+$16
	kcopyRdScChr	$5f,BmBase_cgx+BmP1Rd_cgx+$17
	kcopyRdScChr	$0c,BmBase_cgx+BmP1Rd_cgx+$18
	plb
	a8
.p{pl}clsflag
	clsflag.l	KRadarFlag,#P{pl}radScChFl
.p{pl}end
	endm
;**********************************************************************
KRDSCR_P2	macro	[pl]
	shorta
	longi

	jmpnotflag.l	KRadarFlag,#P{pl}radScChFl,.P{pl}end
	jmpflag.l	KRadarFlag,#P{pl}radmodeFl,.P{pl}relative
	phb
	ai16
;------ Player absolute radar ---------
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$0
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$1
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$2
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$3
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$4
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$5
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$6
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$7
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$8
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$9
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$a
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$b
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$c
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$d
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$e
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$f
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$10
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$11
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$12
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$13
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$14
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$15
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$16
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$17
	kcopyRdScChr	$19,BmBase_cgx+BmP2Rd_cgx+$18
	plb
	a8
	jmp	.p{pl}clsflag
.p{pl}relative
	phb
	ai16
;------- relative radar -------
	kcopyRdScChr	$09,BmBase_cgx+BmP2Rd_cgx+$0
	kcopyRdScChr	$50,BmBase_cgx+BmP2Rd_cgx+$1
	kcopyRdScChr	$51,BmBase_cgx+BmP2Rd_cgx+$2
	kcopyRdScChr	$52,BmBase_cgx+BmP2Rd_cgx+$3
	kcopyRdScChr	$0a,BmBase_cgx+BmP2Rd_cgx+$4

	kcopyRdScChr	$53,BmBase_cgx+BmP2Rd_cgx+$5
	kcopyRdScChr	$54,BmBase_cgx+BmP2Rd_cgx+$6
	kcopyRdScChr	$4e,BmBase_cgx+BmP2Rd_cgx+$7
	kcopyRdScChr	$55,BmBase_cgx+BmP2Rd_cgx+$8
	kcopyRdScChr	$56,BmBase_cgx+BmP2Rd_cgx+$9

	kcopyRdScChr	$57,BmBase_ase_cgx+BmP2Rd_cgx+$a
	kcopyRdScChr	$4e,BmBase_cgx+BmP2Rd_cgx+$b
	kcopyRdScChr	$58,BmBase_cgx+BmP2Rd_cgx+$c
	kcopyRdScChr	$59,BmBase_cgx+BmP2Rd_cgx+$d
	kcopyRdScChr	$5a,BmBase_cgx+BmP2Rd_cgx+$e

	kcopyRdScChr	$5b,BmBase_cgx+BmP2Rd_cgx+$f
	kcopyRdScChr	$4e,BmBase_cgx+BmP2Rd_cgx+$10
	kcopyRdScChr	$4e,BmBase_cgx+BmP2Rd_cgx+$11
	kcopyRdScChr	$4e,BmBase_cgx+BmP2Rd_cgx+$12
	kcopyRdScChr	$5c,BmBase_cgx+BmP2Rd_cgx+$13

	kcopyRdScChr	$0b,BmBase_cgx+BmP2Rd_cgx+$14
	kcopyRdScChr	$5d,BmBase_cgx+BmP2Rd_cgx+$15
	kcopyRdScChr	$5e,BmBase_cgx+BmP2Rd_cgx+$16
	kcopyRdScChr	$5f,BmBase_cgx+BmP2Rd_cgx+$17
	kcopyRdScChr	$0c,BmBase_cgx+BmP2Rd_cgx+$18
	plb
	a8
.p{pl}clsflag
	shorta
	clsflag.l	KRadarFlag,#P{pl}radScChFl
.p{pl}end
	endm
;*********************************************************************
KBOOST	macro	[pl]
	a8
	lda.l	player{pl}_boost
	bmi	.BoostP{pl}		;If Boost On
	jmp	.BoostP{pl}End
.BoostP{pl}
	jmpflag_a	#07,.normalp{pl}	;If not last 3bit = 0
	checkflag.l	player{pl}_boost,#BoostSign
	bne		.incp{pl}
.decp{pl}
	a16
	ldx	#0
	lda.l	player{pl}_boost
	and	#$3f
	shiftRUA8
	tay
	KcopyBitMapChrXY	RBotop,BmBoostP{pl},32
	jmp	.BoostP{pl}End
.incp{pl}
	a16
	ldx	#8
	lda.l	player{pl}_boost
	and	#$3f
	beq	.zerop{pl}
	shiftRUA8
	dec	a
	tay
	KcopyBitMapChrXY	RBotop,BmBoostP{pl},32
	jmp	.BoostP{pl}End
.zerop{pl}
	KcopyBitmapFixChr	RBotop,BmBoostP{pl},32
	jmp	.BoostP{pl}End
.normalp{pl}
	a16
	lda.l	player{pl}_boost
	and	#$3f
	shiftRUA8
	tay

	lda.l	player{pl}_boost
	and	#7
	tax
	KcopyBitMapChrXY	RBotop,BmBoostP{pl},32
.BoostP{pl}End
	ENDM
;*********************************************************************
KDAMAGE	macro	[pl]
;==== Check hit damage ====
	phb
	db7e

	km_plheapptr	{pl},x
	jmpnotflag	KHITFLASH,#kdmgflag,.P{pl}dmgEnd,X

;==== Meter Copy (10 chr)=====
	clsflag		KHITFLASH,#kdmgflag,x
	db0			;Data Bank Reg = 0
	s_set_objtobeplayer{pl}	x	;player 1 work pnt

	lda	#0
	xba			;B reg <-- 0

	lda	al_hp,x		;player HP
	shiftRUA4
	kmultu8uf7	x,#11	;x:Rom Pointer
	ldy	#0		;y:Mario pointer
.loop{pl}
	shorta
	longi
	lda	#0
	xba			;B reg <-- 0
	lda.l	HPTable,x
	bne	.skip{pl}
	jmp	.P{pl}dmgEnd
.skip{pl}
	phx
	tax

	phy
	KcopyBitMapChrXY	0,BmDMGMTP{pl},32
	ply
	plx
	
	inx
	iny
	jmp	.loop{pl}
.P{pl}dmgEnd
	plb
	a8
	endm

	endc

	
