;*********************************************************************
;*								*
;*	------------------------				*
;*		SAMPLE1 					*
;*	------------------------				*
;*								*
;*	File 		: main.asm				*
;* 	Description	; main SEQ				*
;*	Date		: 1994.8.1				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  lib
;---------------------------------------------------------------------



;*********************************************************************
;	library program
;*********************************************************************




;*********************************************************************
;		*************************************************
; select long jump	*************************************************
;		*************************************************
;*********************************************************************
;
; Y = longjump address
; A = longjump bank
;
;---------------------------------------------------------------------
indexjsl
	a8
	pha	; jump bank
	a16
	dey
	phy	; jump address
	rtl


;*********************************************************************
;		*************************************************
; clear RAM (DMA)	*************************************************
;		*************************************************
;*********************************************************************
;	jsl	Clear_RAM
;	dw	0000H 	( 2 byte clear patern )
;	dl	7F0000H ( RAM start address )
;	dw	4000H	( RAM clear count )
;---------------------------------------------------------------------
Clear_RAM
	plx
	a8
	lda.w	1,x		; Low ( Clear parameter )
	sta.l	211BH
	lda.w	2,x		; High
	sta.l	211BH
	lda	#1
	sta.l	211CH
	sta.l	211CH
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	a16
	lda	#3481H		; DMA parameter
	sta.l	DMA_0+0
	lda.w	3,x		; DMA Abus address
	sta.l	DMA_0+2
	lda.w	6,x		; DMA byte count
	sta.l	DMA_0+5
	a8
	lda.w	5,x		; DMA Abus bank
	sta.l	DMA_0+4
	lda	#00000001B	; DMA channel 0 start
	sta.l	DMA_burst
	a16
	clc
	txa
	adc	#7
	pha
	rtl

;*********************************************************************
;		*************************************************
; clear VRAM (DMA)	*************************************************
;		*************************************************
;*********************************************************************
;	jsl.l	Clear_VRAM
;	dw	0000H ( 2 byte clear patern )
;	dw	0000H ( VRAM start address )
;	dw	4000H ( VRAM clear count )
;--------------------------------------------------------------------
Clear_VRAM	plx
	inx
	ldy.w	4,x		;W	X=(low_data)pointer
	jsr	low_clear
	inx			;W 	X=(high_data)pointer 
	jsr	high_clear
	Madx	4
	phx
	rtl
;----------------------------------------------------------------------
low_clear	lda.w	2,x			; write VRAM address
low_clear_entry	
	stz	Screen_step 		; low inc
	sta	Screen_address+0
	lda	#1808H			; 2118H / 1 byte
	bra	VRAM_clear		;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
high_clear	lda	#80H			; hi inc
	sta	Screen_step
	lda.w	1,x			; write VRAM address
	sta	Screen_address+0
	lda	#1908H			; 2119H / 1 byte
	bra	VRAM_clear		;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
VRAM_clear	sta	DMA_0+0
	stx	DMA_0+2		; ROM address
	sty	DMA_0+5		; byte	count
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	a8
	phb				;> data bank read
	pla				;
	sta	DMA_0+4		; ROM bank
	lda	#00000001B		; DMA start
	sta	DMA_burst
	a16
	rts


;=====================================================================
;	debug library
;=====================================================================
;*********************************************************************
;		*************************************************
; blink program	*************************************************
;		*************************************************
;*********************************************************************

blink_l	a8i16
	sei
	phk
	plb

	MwaitNMI
	Mset	2100h,0fh
	Mset	212ch,00h

blink_loop	Msetppucolor	0,3,0,0
	MwaitNMItime	60
	Msetppucolor	0,0,3,0
	MwaitNMItime	60
	Msetppucolor	0,0,0,3
	MwaitNMItime	60
	jmp	blink_loop

;----------------------------------------------------------------------
blinkB_l	a8i16
	sei
	phk
	plb

	MwaitNMI
	Mset	2100h,0fh
	Mset	212ch,00h

blinkB_loop	
	Msetppucolor	0,3,0,0
	MwaitNMItime	60
	Msetppucolor	0,0,0,0
	MwaitNMItime	60
	jmp	blinkB_loop

;----------------------------------------------------------------------
blinkG_l	a8i16
	sei
	phk
	plb

	MwaitNMI
	Mset	2100h,0fh
	Mset	212ch,00h

blinkG_loop	
	Msetppucolor	0,0,10,0
	MwaitNMItime	60
	Msetppucolor	0,0,0,0
	MwaitNMItime	60
	jmp	blinkG_loop

;----------------------------------------------------------------------
blinkR_l	a8i16
	sei
	phk
	plb

	MwaitNMI
	Mset	2100h,0fh
	Mset	212ch,00h

blinkR_loop	
	Msetppucolor	0,0,0,10
	MwaitNMItime	60
	Msetppucolor	0,0,0,0
	MwaitNMItime	60
	jmp	blinkR_loop

;=====================================================================

;=====================================================================
;=====================================================================
; END END END END END END END END END END END END END END END END END 
;=====================================================================
;=====================================================================

