/***********************************************************************/
/**                                                                   **/
/**         SMTP MAIL SENDER (C) 1994, Takoyaki Software Ltd.         **/
/**                                                                   **/
/**                            v1.1                                   **/
/**                                                                   **/
/**                  Written by Dylan Cuthbert                        **/
/**                                                                   **/
/**    The executable and source may be distributed freely as long    **/
/**    as it remains unchanged in content.  If you wish to make a     **/
/**    change for the distribution then mail me at one of the         **/
/**    following addresses:                                           **/
/**                                                                   **/
/**    Dylan@takoyaki.demon.co.uk                                     **/
/**    Dyl@cix.compulink.co.uk                                        **/
/**    Dyl@twics.co.jp                                                **/
/**    Dyl@bix.com                                                    **/
/**                                                                   **/
/***********************************************************************/
/**                                                                   **/
/** Environment variables:                                            **/
/**                                                                   **/
/**   MAILIN   Incoming mail directory... %s expands to the           **/
/**            recipient's name and therefore mail to fred and        **/
/**            MAILIN=C:\USERS\%s\IN would result in the message      **/
/**            being put in C:\USERS\FRED\IN                          **/
/**   MAILOUT  Outgoing mail directory                                **/
/**                                                                   **/
/***********************************************************************/
/**                                                                   **/
/** Installation:                                                     **/
/**                                                                   **/
/**   Create a DVP for this .EXE and then add it into DVX/SETUP/      **/
/** STARTUP/LOCAL.                                                    **/
/**                                                                   **/
/***********************************************************************/
/**                                                                   **/
/** Command line parameters:                                          **/
/**                                                                   **/
/** When running as an SMTP client:                                   **/
/**                                                                   **/
/** MAILSEND <minutes between scans> <mail relay ip address>          **/
/** if minutes=-1 MAILSEND will exit immediately after one scan       **/
/**                                                                   **/
/** When run to store an outgoing message                             **/
/**                                                                   **/
/** MAILSEND -s  (message is expected to be on stdin - you must be    **/
/** running the SMTP client version of MAILSEND in order for the      **/
/** mail message to actually be sent or it will just sit on your      **/
/** hard disk forever.                                                **/
/**                                                                   **/
/***********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <dos.h>
#include <time.h>
#include <sys/dirent.h>
#include <stdarg.h>
#include <unistd.h>

#include "sckstdio.h"


/** Various variables for use by the SMTP protocol **/

#define SMTP_PORT 25

#define REPLY_READY 220
#define REPLY_CLOSING 221
#define REPLY_OK 250
#define REPLY_SENDDATA 354

char hostname[80];

/** SMTP Mail relay ip address **/

char *alternativehost=NULL;

int timeloop = 15*60;		/* every 15 mins approx. */

void SendMail(char *dir);

int mlength;

char dir[256];

int uniquefileid=0;


/*********************************************************************/
/** Opens a unique filename, of course at the moment this gives a   **/
/** limit of 1000 messages else this routine goes into              **/
/** an infinite loop, sorry, what do you expect for a fiver a month?**/

FILE *fopenuniquename(char *fn)
	{
	FILE *fp;
	char *e = strrchr(fn,'.')+1;

	while(1)
		{
		sprintf(e,"%d",uniquefileid);
		if (++uniquefileid>999) uniquefileid = 0;
		if (access(fn,F_OK)) if (fp = fopen(fn,"w")) break;
		}

	return fp;
	}

/*******************************************************************/
/** Put a character into the memory file                          **/

void mputc(char **mem,char c)
	{
	int len = (*mem)?strlen(*mem):0;
	if (len+2>mlength)
		{
		*mem = realloc(*mem,mlength*2);
		mlength *= 2;
		}

	(*mem)[len+1] = '\0';
	(*mem)[len] = c;

	}

/*******************************************************************/
/** put a string into the memory file                             **/

void mputs(char **mem,char *s)
	{
	int len;

	len = (*mem)?strlen(*mem):0;

	while(len+strlen(s)+1>mlength)
		{
		*mem = realloc(*mem,mlength*2);
		mlength *= 2;
		}

	strcpy((*mem)+len,s);

	}

/*******************************************************************/
/** printf into the memory file                                   **/

void mprintf(char **mem, char *s, ...)
	{
	va_list ap;
	char buf[1024];

	va_start(ap,s);
	vsprintf(buf,s,ap);

	va_end(ap);

	mputs(mem,buf);
	}

/*******************************************************************/
/** Open a memory file                                            **/

char *mopen()
	{
	char *mem;

	mem = malloc(1);
	mem[0] = '\0';

	mlength = 1;

	return mem;
	}

/*******************************************************************/
/** Close a memory file                                           **/

char *mclose(char **mem)
	{
	if (*mem) free(*mem);
	*mem = NULL;
	}

/**/
/* Sleep for a specified time period in seconds                  */

void dvx_sleep(int sleeptime)
	{
	time_t t0,t1;
	int n;

	time(&t0);

	do {
		for (n=0;n<10;n++)
			apiPause();
		time(&t1);
		} while (difftime(t1,t0)<sleeptime);
	}



/**/
/* Check for any new outgoing messages                           */

#define FILENAMELENGTH 100
#define MAXFILESONEPASS 100

char *CheckNewSmtpFiles(char *dir)
	{
	struct ffblk b;
	int done;
	char *e = strrchr(dir,'.')+1;
	char *n;
	char list[MAXFILESONEPASS*FILENAMELENGTH];
	int found=0,x;

	printf("---\n");

	strcpy(e,"*");

	done = findfirst(dir,&b,0);

	while (!done)
		{
		if (!(b.ff_attrib&FA_DIREC))
			{
			if (strrchr(b.ff_name,'.'))
				{
				strcpy(e,strrchr(b.ff_name,'.')+1);
				if (!access(dir,W_OK))
					{
					printf("found: %s\n",dir);
					strcpy(&(list[found*FILENAMELENGTH]),dir);
					if (++found>=MAXFILESONEPASS) break;
					}
				strcpy(e,"*");
				}
			}
		done = findnext(&b);
		}

	for (x=0;x<found;x++)
		{
/* double check to see if the file is writable (ie. no1 else is writing) */
		if (!access(&list[x*FILENAMELENGTH],W_OK))
			SendMail(&list[x*FILENAMELENGTH]);
		}

	return NULL;
	}

/**/
/* Delete a name from a comma-separated list of recipient names  */

char *DeleteName(char *s,char *w)
	{
	char *p;

	if (p = strchr(w,','))
		{
		memcpy(w,p+1,strlen(p+1)+1);
		}
	else
		{
		w[0] = '\0';
		if (s != w) w[-1] = '\0';
		}


	return w;
	}

/**/
/* Open the socket and make sure the destination exists          */

int OpenSocket(char *host)
	{
	int s,portnum=4000;
	struct sockaddr_in own_addr,dest_addr;
	struct hostent *he;

	sethostent();

/* Check if host exists */

	if (!(he = gethostbyname(host)))
		{
		endhostent();
/*		printf("Unable to resolve host %s.\n",host);*/
		return -1;
		}

	endhostent();

	dest_addr.sin_family = he->h_addrtype;
	dest_addr.sin_port = htons(SMTP_PORT);
	memcpy(&dest_addr.sin_addr,he->h_addr_list[0],he->h_length);

/* Create a local socket */

	s = socket(AF_INET,SOCK_STREAM,0);

	sethostent();

	he = gethostbyname(hostname);

	endhostent();

	do {
		own_addr.sin_family = he->h_addrtype;
		own_addr.sin_port = htons(portnum++);
		memcpy(&own_addr.sin_addr,he->h_addr_list[0],he->h_length);
		} while (bind(s,(struct sockaddr *)&own_addr,sizeof(own_addr))==-1);

/*	printf("Socket bound to local port %d.\n",portnum-1);*/

	if (connect(s,(struct sockaddr *)&dest_addr,sizeof(dest_addr)) == -1)
		{
/*		printf("Failed to connect.\n");*/
		return -1;
		}

	return s;
	}

/**/
/* Close the socket                                              */

void CloseSocket(int s)
	{
	so_close(s);
	}

/**/
/* Get a reply from the destination SMTP server as an integer code */

int GetReply(FILE *sin, FILE *sout)
	{
	char buf[1024];
	int r;
	struct timeval t;
	int s = sin->_file;
	int readbit,writebit,excludebit;

	SOCKfflush(sout);

	writebit = 0;
	readbit = 1<<s;
	excludebit = 0;

	t.tv_sec = 60;
	t.tv_usec = 0;
	
	if (sin->_cnt<=0)
		if (select(s+1,(struct fd_set *)&readbit,(struct fd_set *)&writebit,(struct fd_set *)&excludebit,&t)<=0) return 0;

	if (!SOCKfgets(buf,sizeof(buf),sin)) return 0;

	r = strtol(buf,NULL,10);

#ifdef DEBUG
	printf("Received: %d\n",r);
#endif

	return r;
	}

/**/
/* Write the mail to the opened socket                           */

int WriteMail(char *whoto,char *whofrom,char *subject,char *date,char *data)
	{
	int s;
	FILE *sin,*sout;
	int exitplease=0;
	int r;
	char *d;

	if ((s = OpenSocket(alternativehost))==-1) return 0;

	sin = SOCKfdopen(s,"r");
	sout = SOCKfdopen(s,"w");

	if (!sin || !sout) return 0;

	while (!exitplease)
		{
		if ((r = GetReply(sin,sout))!= REPLY_READY) break;

/* Hello! */

		SOCKfprintf(sout,"HELO %s\r\n",hostname);
		if ((r = GetReply(sin,sout))!= REPLY_OK) break;

/* Send sender's name and address */

		SOCKfprintf(sout,"MAIL FROM:<%s>\r\n",whofrom);
		if ((r = GetReply(sin,sout))!= REPLY_OK) break;

/* Send recipient's name and address */

		SOCKfprintf(sout,"RCPT TO:<%s>\r\n",whoto);
		if ((r = GetReply(sin,sout))!= REPLY_OK) break;

/* Initiate send of main data chunk */

		SOCKfprintf(sout,"DATA\r\n");
		if ((r = GetReply(sin,sout))!= REPLY_SENDDATA) break;

/* Now send main data chunk */

		SOCKfprintf(sout,"X-Mailer: DV/X Mailsend v1.1 (Takoyaki Software Ltd)\n");
		SOCKfprintf(sout,"Content-Type: text/plain; charset=US-ASCII\n");
		SOCKfprintf(sout,"Content-Transfer-Encoding: 7bit\n");

		SOCKfprintf(sout,"From: %s\n",whofrom);
		SOCKfprintf(sout,"To: %s\n",whoto);
		SOCKfprintf(sout,"Date: %s\n",date);
		SOCKfprintf(sout,"Subject: %s\n",subject);

		d = data;
		while (*d) SOCKputc(*d++,sout);

		if ((r = GetReply(sin,sout))!= REPLY_OK) break;

/* quit transmission channel */

		SOCKfprintf(sout,"QUIT\r\n");
		exitplease = 1;
		if ((r = GetReply(sin,sout))!= REPLY_CLOSING) break;

		}

	SOCKfclose(sin);
	SOCKfclose(sout);

	CloseSocket(s);
	return exitplease;
	}

/**/
/* Get a line from a file                                        */

char *fgetline(char *s,int size,FILE *fp)
	{
	int n;

	if (!fgets(s,size,fp)) return NULL;

	for (n=strlen(s)-1;n>=0;n--)
		if (s[n]=='\r' || s[n]=='\n') s[n] = '\0';
		else break;

	return s;
	}

/**/
/* Get a line from a string                                      */

char *mgetline(char *s,int size,char *fp)
	{
	int n;
	char *o=s;

	*s = '\0';

	while (*fp != '\0' && *fp != '\n')
		{
		*s++ = *fp++;
		}

	if (*fp == '\n') fp++;

	*s = '\0';

	if (*o == '\0') return NULL;

	for (n=strlen(s)-1;n>=0;n--)
		if (s[n]=='\r' || s[n]=='\n') s[n] = '\0';
		else break;

	return fp;
	}


/**/
/* This scans a message for Header information                   */

void ScanXHdr(char *mem,char **whoto,char **whofrom,char **subject,char **date,int del)
	{
	char *olds,*s = mem;
	int delline;
	char linebuf[1024];
	int bufsize = sizeof(linebuf)-1;
	

	while (1)
		{
		delline = 0;
		olds = s;
		if (!(s = mgetline(linebuf,bufsize,s))) break;
		if (strlen(linebuf)==0) break;

		if (strnicmp("To: ",linebuf,4)==0)
			{
			*whoto = strdup(linebuf+4);
			delline = 1;
			}
		if (strnicmp("From: ",linebuf,6)==0)
			{
			*whofrom = strdup(linebuf+6);
			delline = 1;
			}
		if (strnicmp("Subject: ",linebuf,9)==0)
			{
			*subject = strdup(linebuf+9);
			delline = 1;
			}
		if (strnicmp("Date: ",linebuf,6)==0)
			{
			*date = strdup(linebuf+6);
			delline = 1;
			}
		if (strnicmp("X-Mailer: ",linebuf,10)==0)
			{
			delline = 1;
			}
		if (strnicmp("Content-Type: ",linebuf,14)==0)
			{
			delline = 1;
			}
		if (strnicmp("Content-Transfer-Encoding: ",linebuf,27)==0)
			{
			delline = 1;
			}

		if (delline && del)
			{
			memcpy(olds,s,strlen(s)+1);
			s = olds;
			}
		}
	}

/**/
/* send a mail file                                              */

void SendMail(char *dir)
	{
	FILE *fp;
	char linebuf[1024];
	int bufsize = sizeof(linebuf)-1;
	int delete=0,n;
	char *whoto=NULL,*wt;
	char *whofrom=NULL;
	char *mem=NULL,*s,*olds;
	char *subject=NULL;
	char *date=NULL;
	int unsent = 0;
	int count;
	char whobuf[1024];
	time_t secs_now;
	struct tm *time_now;

	fflush(stdout);

	if (!(fp=fopen(dir,"r"))) return;
	while(1)
		{
		delete=1;

/* Read the file into memory */

		mem = malloc(1);
		*mem = '\0';

		while (fgetline(linebuf,bufsize,fp) && !feof(fp))
			{
			mem = realloc(mem,strlen(mem)+strlen(linebuf)+1+2);
			strcat(mem,linebuf);
			strcat(mem,"\n");
			if (strcmp(linebuf,".")==0) break;
			}

/* Scan through the data for To: from: and subject: fields */
/* At the same time strip out some other fields            */

		ScanXHdr(mem,&whoto,&whofrom,&subject,&date,1);

/* If no to: or from: specified then impossible to send */

		if (!(whoto && whofrom)) break;

		strcpy(whobuf,whoto);

/* No subject so make a dummy one */

		if (!subject) subject = strdup("** No subject specified **");

/* If no date then add today's time and date */

		if (!date)
			{
			tzset();
			time(&secs_now);
			time_now = localtime(&secs_now);
			date = malloc(128);
			strftime(date,128,"%A, %d %B %Y, %I:%M:%S%p",time_now);
			}

/* Append the host name to the sender's name if required */

		if (!strchr(whofrom,'@'))
			{
			whofrom = realloc(whofrom,strlen(whofrom)+strlen(hostname)+1+1);
			strcat(whofrom,"@");
			strcat(whofrom,hostname);
			}


		wt = whoto;
		while (strchr(wt,','))
			{
			*strchr(wt,',') = '\0';

/* If successful then delete name from list */
			if (WriteMail(wt,whofrom,subject,date,mem))
				{
				wt[strlen(wt)] = ',';
				wt = DeleteName(whoto,wt);
				}
			else
				{
				wt[strlen(wt)] = ',';
				wt = strchr(wt,',')+1;
				unsent++;
				}
			}

		if (!WriteMail(wt,whofrom,subject,date,mem)) unsent++;
		else
			{
			wt = DeleteName(whoto,wt);
			if (strlen(whoto)==0)
				{
				delete = 1;
				unsent = 0;
				}
			}

		if (fgetline(linebuf,bufsize,fp))
			{
			if (strnicmp(linebuf,"Count: ",6)==0)
				{
				count = strtol(linebuf+6,NULL,10);
				}
			else count=0;
			}
		else count=0;
		break;
		}

	fclose(fp);

/* retry for 48 hours */

	if (unsent && count<(48*60)/(timeloop/60))
		delete = 0;
/* we must rewrite the message file */

	if (delete) strncpy(strstr(dir,"outmail"),"old",3);
	if (fp = fopen(dir,"w"))
		{
		fprintf(fp,"To: %s\n",(delete)?whobuf:whoto);
		fprintf(fp,"From: %s\n",whofrom);
		fprintf(fp,"Subject: %s\n",subject);
		fprintf(fp,"%s",mem);
		fprintf(fp,"Count: %d\n",++count);
		fclose(fp);
		}

	if (delete) strncpy(strstr(dir,"oldmail"),"out",3);

	if (whoto) free(whoto);
	if (whofrom) free(whofrom);
	if (mem) free(mem);
	if (subject) free(subject);
	if (date) free(date);

/*	printf("Finished - %s\n",(delete)?"Deleted":"Not Deleted"); */
	sprintf(linebuf,"del %s",dir);
	if (delete) system(linebuf);
/*remove(dir);*/
	}

/**/
/* Batch mail into outgoing directory                            */

void BatchMail(FILE *in)
	{
	char *m;
	char linebuf[1024];
	int bufsize=sizeof(linebuf);
	FILE *fp;

	m = mopen();

	while (!feof(in))
		{
		if (!fgetline(linebuf,bufsize,in)) break;
		mprintf(&m,"%s\n",linebuf);
		if (strcmp(linebuf,".")==0) break;
		}

/* Now to open a uniquely named file in the outgoing mail directory */

	if (fp = fopenuniquename(dir))
		{
		fwrite(m,strlen(m),1,fp);
		fclose(fp);
		printf("Mail batched ok.\n");
		}
	else printf("Error writing mail to %s.\n",dir);

	mclose(&m);
	}

/**/
void CmdLineArgs()
	{
	printf(
		"\nSMTP usage:\n"
		"MAILSEND <minutes> <mail-relay ip address>\n"
		"Where <minutes> is the time to wait between checks. (dflt = 15) \n"
		"Where <mail-relay ip address> is an the address where all\n"
		"mail will actually be sent to (normally a mail relay host).\n"

		"\nMessage batch usage:\n"
		"MAILSEND /s\n"
		"The message should be sent on stdin, and terminated with a\n"
		"single period '.' on an empty line.\n"
		"Valid To: and From: fields must be specified or the message\n"
		"will be unable to be sent.\n"

		"\nThe environment variables MAILIN and MAILOUT must point to\n"
		"your incoming/outgoing mail directories.\n"
		);

	exit(0);
	}
/**/
/* main()                                                        */

main(int argc,char *argv[])
	{
	char *outgoing,*incoming;

	printf("DV/X SMTP Mailer v1.1 (C) 1994 Takoyaki Software Ltd.\n");
	printf("Written by Dylan Cuthbert. (dylan@takoyaki.demon.co.uk)\n");

	if (!(outgoing = getenv("MAILOUT")) || !(incoming = getenv("MAILIN")))
		{
		printf("Error: The environment variables MAILIN and MAILOUT aren't defined.\n");
		exit(30);
		}

	strcpy(dir,outgoing);
	if (dir[strlen(dir)-1] == '\\' || dir[strlen(dir)-1] == '/')
		dir[strlen(dir)-1] = '\0';

	strcpy(dir+strlen(dir),"\\outmail.xxx");

	if (argc>3) CmdLineArgs();

	if (argc>=2)
		{
		if (strcmp(argv[1],"/?")==0 || strcmp(argv[1],"-?")==0)
			{
			CmdLineArgs();
			exit(0);
			}

		if (stricmp(argv[1],"/s")==0 || stricmp(argv[1],"-s")==0)
			{
			printf("\nBatching mail, '.' to finish.\n");
			printf("(Make sure you specify To:, From: and Subject: fields.\n");
			BatchMail(stdin);
			exit(0);
			}

		if ((timeloop = strtol(argv[1],NULL,0)*60)==0)
			{
			printf("Invalid value for timer specified.\n");
			exit(0);
			}

		if (argc==3) alternativehost = strdup(argv[2]);
		}

	if (!alternativehost)
		{
		printf("Error: You must specify a mail relay host.\n");
		exit(10);
		}

	if (timeloop!=-1) printf("Looping every %d minutes.\n",timeloop/60);

	if (alternativehost) printf("Routing mail via %s.\n",alternativehost);

	if (!so_init())
		{
		printf("Socket interface isn't available.\n");
		exit(30);
		}

	gethostname(hostname,sizeof(hostname)-1);

	while (1)
		{
		CheckNewSmtpFiles(dir);
		if (timeloop==-1) break;
		dvx_sleep(timeloop);
		}
	so_exit();
	}

