;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: mapanime.asm				*
;* 	Description	: mission map				*
;*			; object animation program		*
;*	Date		: 1994.10.13				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
stepup_char		equ	160h
;
;---------------------------------------------------------------------
;
;
;
;
;--------------------------------------------------------------------
	include	yajima.inc
;--------------------------------------------------------------------
;
;********************************************************************
;	<<<<< README >>>>>>
;********************************************************************
;;;
;;;
;;; kawaguchi used --------------------------------------------------
;;;
;;;	mapanime_set		map-main (objanimation)
;;;	set_kawaobj		sprite program
;;;
;;; kawaguchi called ------------------------------------------------
;;;
;;;	mappause_objset		mappause no toki ni call 
;;;	corneria_HPmeter	disp HPmeter
;;;	yajirushi_animation	map-explain yajirushi anime
;;;				disp yajirushi
;;;	corneria_crash		map-crash objectset
;;;
;;; mapanime library ------------------------------------------------
;;;
;;;	set_blockobj		obj blockset
;;;
;;;
;********************************************************************
;	7f super buffer
;********************************************************************

chartram		equ	objchart&0ff0000h
chartstart		equ	objchart&WM

;********************************************************************
;	WORK LABEL
;********************************************************************
;-----------------------------------------------
; zero page RAM
;-----------------------------------------------

obj_temp		equ	Xwork0
obj_counter		equ	Xwork1
obj_ROMpointer	equ	Xwork2
obj_blockpointer	equ	Xwork3
obj_animecount	equ	Xwork4
obj_subdata		equ	Xwork5
obj_attrdata		equ	Xwork6
obj_charcheck	equ	Xwork7


;********************************************************************
;	LOCAL macros
;********************************************************************
;-----------------------------------------------
;	pausemap RAM pointer
;-----------------------------------------------
Mpausemap_rampointer	macro	[RAMaddr]
	lda	#({RAMaddr})>>8
	sta	Xaddr+1
	lda.l	{RAMaddr}
	sta	Xaddr+0
	endm

;-----------------------------------------------
; 	OAM SUB set loop
;-----------------------------------------------
mapanime_oamsub	macro
	lda	oam_pointer	; calc SUB address
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	tax
	a8
.\@p1	lda	obj_subdata
	sta.l	sprites+200h,x	; Set OAM-SUB
	iny
	inx
	dec	obj_temp	
	bpl	.\@p1
	a16
	endm

;-----------------------------------------------
; 	OAM MAIN countset
;-----------------------------------------------
mapanime_oamcount	macro
	lda.l	chartram+0,x	; <Y> position
	and	#00ffh
	sta	obj_counter
	inx
	endm

;-----------------------------------------------
; 	meter OBJ address
;-----------------------------------------------
Mcmeter_obj	macro
	lda.l	RAMcmeter+0
	tax
	endm

;--------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;####################################################################
;####################################################################
;	
;------------ PROGRAM ENTRY (MAIN)-----------------------------------
;
;####################################################################
;####################################################################
;
;
;
;********************************************************************
;	----------------
;	 map pause main 
;	----------------
;********************************************************************

;-------------------------------------------------------------
mappause_objset
	sty	oam_pointer	;   >>
	phx			; >>
	php			;>
	ai16
;-------------------------------------------------------------
	km_bitcheckmismapflag explain1	;;;; explain check
	bne	.explain
	km_bitcheckmismapflag finalboss	;;;; boss check
	bne	.boss
;-------------------------------------------------------------
; mode gamemap pause
;-------------------------------------------------------------
.game	km_jsr	mapmain_pause		
	bra	.exit
;-------------------------------------------------------------
; mode explain pause ( openning enemy demo )
;-------------------------------------------------------------
.explain	km_jsr	mapexplain_pause
	bra	.exit
;-------------------------------------------------------------
; mode finalboss pause ( finalboss enemy demo )
;-------------------------------------------------------------
.boss	km_jsr	mapboss_pause
;-------------------------------------------------------------
.exit	plp			;<
	plx			; <<
	ldy	oam_pointer	;   <<
	rts

;-------------------------------------------------------------


;********************************************************************
;	program pause-map mode
;********************************************************************

mapexplain_pause
mapmain_pause
	km_jsr	anime_stepup	; stepup animation 
	km_jsr	mpstepup_disp	; OBJ stepup 
	km_jsr	bossship_disp	; OBJ boss ship
	km_jsr	mpcmeter_disp	; HP meter
	km_jsr	faceopen_disp	; face open/close
	rts

;********************************************************************
;	boss mode mapanimation
;********************************************************************

mapboss_pause

	km_jsr	go_bossship	; stepup animation 
	km_jsr	faceopen_disp	; face open/close
	rts

;***********************************************************************
;	------------------------
;	 CORNERIA METER PROGRAM
;	------------------------
;***********************************************************************
;;
;; X = display position
;; Y = sprite pointer	= oam pointer
;; A = HP data	    	= MIN (0) MAX (40)
;;
;--------------------------------------------------------------------
RAMcmeter	equ	objchart+1000h
;--------------------------------------------------------------------
cmeter_max	equ	40	; charcter 8*5
cmeter_param	equ	104	; = (40*256)/100
cmeter_full	equ	1fh	; full charcter number
;--------------------------------------------------------------------
cmeter_number_offsetY	equ	20h
cmeter_number_offsetX	equ	0ah
cmeter_gage_offsetY		equ	18h
cmeter_gage_offsetX		equ	1ch

;--------------------------------------------------------------------

corneria_HPmeter			; << DBR >> 7EH

	php			;>
	ai16
	phx			; >>
	sty	oam_pointer	;   >>

	lda	trig0
	ora	gameframe_trigger
	sta	gameframe_trigger

	km_jsr	speedmessage

	km_jsr	disp_HPmeter	; corneria HP meter

	ldy	oam_pointer	;   <<
	plx			; <<
	plp			;<
	rts

;====================================================================
;
;
;
;
;
;********************************************************************
;	speed-message
;********************************************************************
; 
; EASY MODE 	(B) - key
;	(speedup) - key
;
;--------------------------------------------------------------------

speedmessage
	km_bitcheckmismapstflag	speedup
	beq	.ramclear

	lda	mapmessage_Bpushcount
	inc	a
	sta	mapmessage_Bpushcount
	cmp	#60
	bcc	.exit

	lda	#maptime_speedup
	tsb	mapmessage_easykeycheck
	bra	.exit

.ramclear	stz	mapmessage_Bpushcount
.exit	rts

;--------------------------------------------------------------------
;
;
;
;
;
;
;
;********************************************************************
;	--------------------------
; 	 Demo YAJIRUSHI animation
;	--------------------------
;********************************************************************
;
; kawaguchi no program kara call sareru !!!
;
; mode = ai16 
; DBR  = 7eh
;
; Y .... object pointer
;
;--------------------------------------------------------------------

yajirushi_animation

	php
	phx
	sty	oam_pointer
	ai16

;-----------------------------------------
	km_jsr	test_animation	; debug program
;-----------------------------------------

	lda	mapexp_objNo	; Set Animation Number 
	beq	.exit
	sta	oam_animeNo

	lda	mapexp_objcount	; Set Animation Timer
	inc	a
	sta	mapexp_objcount
	and	#000fh
	sta	oam_tcount

	lda	mapexp_objpos	; Set Animation X/Y Position
	km_jsr	set_objentry

.exit	

;-----------------------------------------
	km_jsr	face_animation	; face open/close animation
;-----------------------------------------
	km_jsr	message_nextobj
;-----------------------------------------
	km_jsr	set_enemyplanet_yajirushi
;-----------------------------------------

	ldy	oam_pointer
	plx
	plp
	rts


;***********************************************************************
;	all planet yajirushi set program
;***********************************************************************

set_enemyplanet_yajirushi

	lda	yajirushi_flag
	beq	.exit

	Manime	yajirushi_anime,10h
	sta	oam_tcount		; anime time count

;---------------------------------------------------
	ldx	kx_planetlistptr
	beq	.exit
.loop	
	lda.w	mmx_planetflag,x
	bit	#mmpnf_corneria
	bne	.next
	bit	#mmpnf_neutral		; 1 = neutoral planet
	bne	.next

	phx				; <<
	km_jsr	set_enemy_yajirushi
	plx				; >>

;---------------------------------------------------
.next	lda.w	mmx_planetnext,x
	tax
	bne	.loop

;---------------------------------------------------
.exit	rts


;---------------------------------------------------
; display yajirushi
;---------------------------------------------------

set_enemy_yajirushi

	ldy	#cd_objanime_yajirushi_up
	a8
	lda.w	mmx_planetcy,x		 ; sprite position
	cmp	#60h
	bcc	.skip
	ldy	#cd_objanime_yajirushi_dw
.skip	xba
	lda.w	mmx_planetcx,x		 ; sprite position
	a16
	sty	oam_animeNo

	km_jsr	set_objentry		; Aregister position

	rts

;***********************************************************************
;	------------------------
;	 CORNERIA CRASH PROGRAM
;	------------------------
;***********************************************************************
;
; kawaguchi no program kara call sareru !!!
;
; mode = ai16 
; DBR  = 7eh
;
; Y .... object pointer
;
;--------------------------------------------------------------------

corneria_crash
	php			;>
	phx			; >>
	sty	oam_pointer	;   >>

	ai16

;-------------------------------------------------
; crash animation start
;-------------------------------------------------
	lda	crash_test
	inc	a
	cmp	#crashanime_max
	bcc	.skip
	lda	#0
.skip	sta	crash_test

;-------------------------------------------------
; crash object program
;-------------------------------------------------

	km_bitcheckmismapflag	attackcorneria
	beq	.skip1
	km_jsr	crash_entry

.skip1	km_jsr	planet_crash	; planet crash program

	ldy	oam_pointer	;   <<
	plx			; <<
	plp			;<
	rts

;********************************************************************
;	----------------------
;	 Map Animation Program
;	-----------------------
;********************************************************************
;
; kawaguchi no program kara call sareru !!!
;
; mode = ai16 
; DBR  = 7eh
;
; X .... map enemylist pointer
; Y .... object pointer
;
;--------------------------------------------------------------------
mapanime_set
	php			; >
	phx			;   >>
	sty	oam_pointer	;     ----->
	
	km_jsr	Set_objparameter	;
	km_jsr	Set_blockobj		;

	ldy	oam_pointer	;    <-----
	plx			;  <<
	plp			; <
	rts

;********************************************************************
;	-------------------------
;	 library mapanime objset
;	-------------------------
;********************************************************************
;
; << INPUT >>
;	oam_centerX	; (low) OBJ center posX
;	oam_centerY	; (low) OBJ center posY
;	oam_animeNo	; object animation number
;	oam_tcount	; time chart object
;
; mode 	= a?i16
; DBR	= 7eh
;
; << EXECUTE >>
;	draw OAM buffer
;
;
;--------------------------------------------------------------------
set_kawaobj
	php			;>>
	phx			;  >>
	sty	oam_pointer	;    >>
	a8
	stz	oam_centerX+1	; high clear
	stz	oam_centerY+1	; high clear
	stz	oam_animeNo+1	; high clear
	stz	oam_tcount+1	; high clear
	a16
	km_jsr	Set_blockobj
	ldy	oam_pointer	;    <<
	plx			;  <<		
	plp			;<<		
	rts

;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;####################################################################
;####################################################################
;	
;------------ PROGRAM ENTRY (SUB) -----------------------------------
;
;####################################################################
;####################################################################
;
;
;
;
;
;********************************************************************
;	gogo!! bossship!! 
;********************************************************************
;
;
;
;
;--------------------------------------------------------------------

go_bossship

	ldx	#stepup_work

	lda	_stepup_anime,x
	bpl	.skip
	lda	#0
.skip	sta	oam_tcount

	lda	_stepup_posX,x
	sta	oam_centerX
	lda	_stepup_posY,x
	sta	oam_centerY

	phx			;>>
	phy			;  >>
	km_jsr	Go_boss
	ply			; <<
	plx			;<<

	lda	_stepup_anime,x	; timer INC
	inc	a
	bne	.skip1
	pha
	ksound	en_sos_hassha
	pla
	bra	.set

.skip1	bmi	.set
	cmp	#100h
	bcc	.set
	lda	#0ffh		; STOP
.set	sta	_stepup_anime,x

	rts


;********************************************************************
;	stepup open animation 'DEMO'
;********************************************************************

Go_boss

;--------------------------------------------------------------------
; display boss !!!!!
	Mset	oam_animeNo,cd_objanime_bossopen
	km_jsr	Set_blockobj

;--------------------------------------------------------------------

	lda	oam_tcount
	cmp	#92-17-10
	bcc	.skip
	sbc	#92-17-10
	asl	a
	asl	a
	Mnegative
	pha			; >>
	clc
	adc	oam_centerX
	sta	oam_centerX
	pla			; <<
	clc
	adc	oam_centerY
	sta	oam_centerY

.skip
	Mset	obj_charcheck,10*2
	Mset	oam_animeNo,cd_objanime_stepupopen
	km_jsr	Set_blockobj

	rts

;********************************************************************
;	bossship display
;********************************************************************

anime_boss
bossship_disp
	Mset	oam_animeNo,cd_objanime_bship
	lda	yj_framecounter
	inc	yj_framecounter
	and	#1fh
	sta	oam_tcount
	lda	#0a0c0h		; bossship position
	km_jsr	set_objentry
	rts


;********************************************************************
;	faceopen display
;********************************************************************

faceopen_disp

	ldx	#cd_objanime_faceclose	; close anime

	lda	mmx_pausescroll
	cmp	#scrl_closescrollwait
	bne	.open

;==== CLOSE ANIMATION ====

	lda	faceshutter_count
	cmp	#1
	bne	.common

	km_bitcheckmismapflag explain1	;;;; explain check
	bne	.setclose_sound
	km_bitcheckmismapflag finalboss	;;;; boss check
	beq	.common

.setclose_sound
	ksound	tsushin_end

	bra	.common

;==== OPEN ANIMATION =====

.open
	ldx	#cd_objanime_faceopen	; open anime
	lda	faceshutter_count
	cmp	#1
	bne	.common

	km_bitcheckmismapflag explain1	;;;; explain check
	bne	.setopen_sound
	km_bitcheckmismapflag finalboss	;;;; boss check
	beq	.common

.setopen_sound
	ksound	androf_voice_1


;==== OPEN ANIMATION =====

.common
	lda	faceshutter_count
	inc	a
	cmp	#50h
	bcs	.skip
	sta	faceshutter_count
.skip

	stx	oam_animeNo	
	lda	faceshutter_count
	sta	oam_tcount

	lda	#mappause_andorossobj
	km_jsr	set_objentry

	km_bitcheckmismapflag explain1
	bne	.exit
	km_bitcheckmismapflag finalboss
	bne	.exit

	lda	#mappause_playerobj
	km_jsr	set_objentry

	lda	player_friend		; if friend down then exit
	bmi	.exit
	lda	#mappause_partnerobj
	km_jsr	set_objentry

.exit	rts

;********************************************************************
;	boss ship OBJ set
;********************************************************************
;
; << INPUT >>
;	Aregister = position
;	oam_animeNo	; object animation number
;	oam_tcount	; time chart object
;
; << EXECUTE >>
;	draw OAM buffer
;
;--------------------------------------------------------------------
set_objentry
	stz	oam_centerX	; position-X
	stz	oam_centerY	; position-Y
	a8
	sta	oam_centerX	; <- position X
	xba
	sta	oam_centerY	; <- position Y
	a16

	km_jsr	Set_blockobj

	rts

;--------------------------------------------------------------------
;;
;;
;;
;;
;;
;;
;;
;;
;********************************************************************
;	message next object
;********************************************************************

message_nextobj


	lda	mapexp_nextobj
	bmi	.exit
	beq	.exit
	a8
	lda	mapexp_nextobj
	inc	mapexp_nextobj
	and	#0fh
	a16
	sta	oam_tcount
	lda	#cd_objanime_nextmark	;
	sta	oam_animeNo

	lda	faceobj_position	; << message position >>
	clc
	adc	#1090h
	km_jsr	set_objentry


.exit	rts

;--------------------------------------------------------------------
;;
;;
;;
;;
;;
;;
;;
;********************************************************************
;			****************************************
;			****************************************
; enmeyplanet animation	****************************************
;			****************************************
;			****************************************
;********************************************************************

enemyplanet	php
	phx
	sty	oam_pointer

	ai16
	km_jsr	call_enemyplanet

	ldy	oam_pointer
	plx
	plp
	rts

call_enemyplanet

	lda	enemyplanet_animecount
	inc	a
	and	#001fh
	sta	enemyplanet_animecount

	ldx	kx_planetlistptr	; X= planet pointer
	beq	.exit

.loop	
	lda.w	mmx_planetcx,x		; << Set Position >>
	and	#00ffh
	sta	oam_centerX		; Xposition
	lda.w	mmx_planetcy,x
	and	#00ffh
	sta	oam_centerY		; Yposition

	lda.w	mmx_dokuroanm,x
	beq	.next
	bmi	.over
	inc	a
	cmp	#34
	bcc	.skip
	lda	#7fffh
	bra	.over
.skip	sta.w	mmx_dokuroanm,x
	sta	oam_tcount

	phx
	Mset	oam_animeNo,cd_objanime_enemyplanetstart
	km_jsr	Set_blockobj
	plx

.next	lda.w	mmx_planetnext,x
	tax
	bne	.loop


.exit	rts


;-------------------------------------------
;; normal loop
;-------------------------------------------

.over	inc	a
	and	#801fh
	sta.w	mmx_dokuroanm,x
	and	#001fh
	sta	oam_tcount

	phx
	Mset	oam_animeNo,cd_objanime_enemyplanet
	km_jsr	Set_1sprite
	plx

	bra	.next


;********************************************************************
;			****************************************
;			****************************************
; Face open/close animation	****************************************
;			****************************************
;			****************************************
;********************************************************************


face_animation

;-------------------------------------------------
	lda	openface_count
	beq	.exit
	sta	oam_tcount
	inc	a
	cmp	#40h
	bcc	.set
	lda	#40h
.set	sta	openface_count
;-------------------------------------------------
	lda	#cd_objanime_faceopen2	; << open anime >>
	sta	oam_animeNo
	lda	faceobj_position	; << message position >>
	km_jsr	set_objentry
;-------------------------------------------------

.exit

;-------------------------------------------------
	lda	closeface_count
	beq	.exit2
	sta	oam_tcount
	inc	a
	cmp	#40h
	bcc	.set2
	lda	#40h
.set2	sta	closeface_count
;-------------------------------------------------
	lda	#cd_objanime_faceclose2	; << close anime >>
	sta	oam_animeNo
	lda	faceobj_position	; << message position >>
	km_jsr	set_objentry
;-------------------------------------------------
.exit2

	rts



;********************************************************************
;	test parameter
;********************************************************************
; <in> 	IX ... enemy index
;--------------------------------------------------------------------
; final boss animation
;--------------------------------------------------------------------
Set_bossanime
	phx				; >> enemy pointer
	km_jsr	Set_objparametermain
	km_jsr	Set_blockobj		;
	plx				; << enemy pointer
	lda	#cd_objanime_stepup
	bra	Set_objparametermain

;--------------------------------------------------------------------
; normal program
;--------------------------------------------------------------------
Set_objparameter

	lda.w	mmx_enanmpatt,x
;;;;;;;;;	lda	#cd_objanime_bossappear
	cmp	#cd_objanime_bossappear	; special object pattern
	beq	Set_bossanime

Set_objparametermain
	sta	oam_animeNo	; animation No

	lda.w	mmx_entype,x	; character select
	asl	a
	and	#00ffh
	sta	obj_charcheck

	lda.w	mmx_enposx+1,x
	and	#00ffh
	sta	oam_centerX	; position X

	lda.w	mmx_enposy+1,x
	and	#00ffh
	sta	oam_centerY	; position Y

	lda.w	mmx_enanmtm,x	
	and	#0ffh
	sta	oam_tcount	; animation Timer


	rts

;=======================================================================
;
;
;
;
;
;
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;
;
;
;
;
;***********************************************************************
;	STEPUP KOUGEKI PROGRAM
;***********************************************************************
crashanime_max equ	8*7
;-----------------------------------------------------------------------
planet_crash

	lda	crash_test		; 
	pha				; >> 

	ldx	kx_planetlistptr	; X= planet pointer
	beq	.exit

.loop
	lda.w	mmx_pstepup,x
	cmp	#stup_attackplanet
	bne	.next

	lda.w	mmx_planetcx,x
	sta	oam_centerX			; px
	lda.w	mmx_planetcy,x
	sta	oam_centerY			; py

	Mmov	oam_tcount,crash_test		; set animecount
	Mset	oam_animeNo,cd_objanime_crash	; set char

	phx			; >>
	km_jsr	Set_blockobj
	plx			; <<

;-------------------------------------------------
	lda	crash_test	; animation random
	clc
	adc	#10
	cmp	#crashanime_max
	bcc	.skip		; sec
	sbc	#crashanime_max
.skip	sta	crash_test
;-------------------------------------------------
	
.next	lda.w	mmx_planetnext,x
	tax
	bne	.loop

;-------------------------------------------------
.exit	
	pla
	sta	crash_test

	rts

;***********************************************************************
;	ENEMY KOUGEKI PROGRAM
;***********************************************************************

crash_entry

	ldx	kx_corneriaptr			; <---- corneria pointer
	lda.w	mmx_planetcx,x
	sta	oam_centerX			; set px
	lda.w	mmx_planetcy,x
	sta	oam_centerY			; set py
	Mmov	oam_tcount,crash_test		; set animecount
	Mset	oam_animeNo,cd_objanime_crash	; set char

	km_jsr	Set_blockobj

	rts

;-------------------------------------------------



;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================








;***********************************************************************
;	display corneria HP meter
;***********************************************************************
disp_HPmeter

	lda	HPmeter_flag
	beq	.skip
	bmi	.entry
	dec	a
	sta	HPmeter_flag
	and	#010000b
	bne	.entry

.skip	km_bitcheckmismapflag	attackcorneria
	beq	.exit
.entry				; X = positionX
				; Y = positionY
	km_jsr	pos_cmetergage
	km_jsr	cmeter_entry
	km_jsr	pos_cmeternumber
	lda	HPcorneria	; A = corneria HP
				; X = position Y,X
	km_jsr	cmeter_printd
	lda	#055h		; %
	km_jsr	cmter_objset	


.exit	rts


;***********************************************************************
;	calc position
;***********************************************************************
pos_cmetergage
	ldx	kx_corneriaptr	; <---- corneria pointer
	lda	#0
	a8
	sec
	lda.w	mmx_planetcy,x
	sbc	#cmeter_gage_offsetY
	tay
	sec
	lda.w	mmx_planetcx,x
	sec
	sbc	#cmeter_gage_offsetX
	tax
	a16
	rts
;-----------------------------------------------------------------------
pos_cmeternumber
	ldx	kx_corneriaptr	; <---- corneria pointer
	a8
	lda.w	mmx_planetcy,x	; corneria position Y
	sec
	sbc	#cmeter_number_offsetY
	xba
	sec
	lda.w	mmx_planetcx,x	; corneria position X
	sec
	sbc	#cmeter_number_offsetX
	a16
	tax			; X = position
	rts

;***********************************************************************
;	cmeter set position
;***********************************************************************

;-----------------------------------------------	
cmeter_printd

	Mdiv_u16u8	10
	pha			; >>
	lda.l	rdmpylr		; = 4216h
	sta	Xwork0		; 0000****
	pla			; <<
	Mdiv_u16u8	10
	lda.l	rdmpylr		; = 4216h
	asl	a
	asl	a
	asl	a
	asl	a		; ****0000
	ora	Xwork0		; 0000****

cmeter_printh
;-----------------------------------------------	
	pha			; set character pointer
	lda	#RAMcmeter>>8
	sta	Xaddr+1
	lda.l	RAMcmeter+6
	sta	Xaddr+0
	pla
;-----------------------------------------------
	pha			;>>
	lsr	a		;W
	lsr	a		;W
	lsr	a		;W
	lsr	a		;W
	km_jsr	cmeter_digit
	pla			;<<
cmeter_digit	
	and	#000fh
	tay
	lda	[Xaddr],y
	and	#00ffh	
cmter_objset	
	ldy	oam_pointer	; >>
	ora	#2000h
	sta	sprites+2,y	;
	txa			; position
	sta	sprites+0,y	;
	clc
	adc	#0008h
	iny
	iny
	iny
	iny
	sty	oam_pointer	; <<
	tax			; position
	rts
;-----------------------------------------------

;***********************************************************************
;	cmeter set position
;***********************************************************************

mpcmeter_disp
	km_bitcheckmismapflag explain1
	beq	.entry
	rts
.entry
	ldx	#mappause_HPmeterposX
	ldy	#mappause_HPmeterposY
cmeter_entry 
	stx	oam_centerX	; <<< INPUT position X >>>
	sty	oam_centerY	; <<< INPUT position Y >>>

;-----------------------------------------------

	lda	#100		; 100...0
	sec
	sbc	kx_corneriaHP	; ( kawaguchi work )
	cmp	#100
	bcc	.skip
	lda	#99
.skip	sta	HPcorneria

;-----------------------------------------------
	Mcmeter_obj
	ldy	oam_pointer	; sprite pointer
	phy			; >>
	mapanime_oamcount
	km_jsr	mapanime_oammain
	sty	oam_pointer	;
	ply			; <<

;-----------------------------------------------
	a8
	lda	HPcorneria
	sta.l	wrmpya		; = 4202h
	lda	#cmeter_param
	sta.l	wrmpyb		; = 4203h
	nop
	nop
	nop
	nop
	lda.l	rdmpyhr		; = 4217h
	beq	.exit
	cmp	#cmeter_max
	bcc	.next
	lda	#cmeter_max
.next	sec
	sbc	#8
	beq	.last
	bmi	.last
;-----------------------------------------------
	pha			; >>
	lda	#cmeter_full
	sta	sprites+2,y
	pla			; <<
	iny
	iny
	iny
	iny	
	bra	.next
;-----------------------------------------------
.last	clc
	adc	#8		; '0'1'2'3'4'5'6'7'
	a16
	clc
	and	#00ffh
	adc.l	RAMcmeter+2	; table index
	tax
	a8
	lda.l	chartRAM,x
	sta	sprites+2,y
;-----------------------------------------------
.exit	a16
	rts

;--------------------------------------------------------------------
;;
;;
;;
;;
;;
;;

























;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;********************************************************************
;			****************************************
;			****************************************
; MapOBJ Animation Library	****************************************
;			****************************************
;			****************************************
;********************************************************************

;********************************************************************
;	blockobj animation program
;********************************************************************
;
; << INPUT >>
;	oam_centerX	; OBJ center posX
;	oam_centerY	; OBJ center posY
;	oam_animeNo	; object animation number
;	oam_tcount	; time chart object
;
; << EXECUTE >>
;	draw OAM buffer
;
;--------------------------------------------------------------------


Set_1sprite

	km_jsr	Set_animeobj

	ldy	oam_pointer
	km_MMSetSpriteSizeDouble

	ldx	obj_ROMpointer	; ROM pointer

	a8
	lda.l	chartram+2,x
	clc
	adc	oam_centerY
	xba
	lda.l	chartram+1,x
	clc
	adc	oam_centerX
	a16

	sta	sprites+0,y
	lda.l	chartram+3,x
	sta	sprites+2,y

	iny
	iny
	iny
	iny
	sty	oam_pointer
	rts


;********************************************************************
;	blockobj animation program
;********************************************************************
;
; << INPUT >>
;	oam_centerX	; OBJ center posX
;	oam_centerY	; OBJ center posY
;	oam_animeNo	; object animation number
;	oam_tcount	; time chart object
;
; << EXECUTE >>
;	draw OAM buffer
;
;--------------------------------------------------------------------

Set_blockobj
	km_jsr	Set_animeobj	; <-- animation program
	lda	oam_animeNo	; <-- animation number
	beq	.exit
	km_jsr	oam_skip
	km_jsr	set_oam
	km_jsr	oam_skip
.exit	rts

;********************************************************************
;	animation object program
;********************************************************************

Set_animeobj
;---------------------------------------------
; chart pointer set
;---------------------------------------------

	lda.l	objchart	; OBJ block address
	sta	obj_blockpointer

;---------------------------------------------
; chart calclation
;---------------------------------------------

	lda	oam_animeNo	; <--- animation number
	beq	.end

	asl	a
	tax
	lda.l	objchart,x
	tax			; SEQ address

	a8
	stz	obj_animecount

.calcloop	clc
	lda.l	chartram+0,x
	bmi	.over
	adc	obj_animecount
	sta	obj_animecount
	cmp	oam_tcount
	bcs	.exit
	inx
	inx
	bra	.calcloop

.over	dex
	dex
;---------------------------------------------

.exit	a16
	lda.l	chartram+1,x	; character No
	and	#00ffh
	asl	a
	adc	obj_blockpointer
	tax

	lda.l	chartram,x
	sta	obj_ROMpointer	; ROMpointer


.end	rts


;********************************************************************
;	OAM
;********************************************************************
;;
;; X = OAMset ROMpointer
;; Y = OAM data address
;;
;;
;====================================================================

set_oam
	ldx	obj_ROMpointer	; ROM pointer

	lda	#0aah		; <==
	sta	obj_subdata
	lda.l	chartram+0,x	; <== Counter Data Read
	bit	#0080h
	beq	.entry
	stz	obj_subdata

.entry	and	#007fh		; <== counter AND
	beq	.exit		; 0 no toki ha set shinai !!

	sta	obj_counter
	inx
	dec	a
	lsr	a
	lsr	a
	sta	obj_temp

	phx			; >>
	mapanime_oamsub		;	( sub set )
	plx			; <<

	ldy	oam_pointer
	km_jsr	mapanime_oammain  ;	( main set )

;--------------------------------------------------------------------

	sty	oam_pointer

.exit	rts			;	( exit )


;***********************************************************************
;	OAM main set program
;***********************************************************************

mapanime_oammain	

oammain_loop

	lda.l	chartram+1,x	; <Y> position
	Msex
	clc
	adc	oam_centerY
	bpl	.skip
	cmp	#0ffe0h
	bcs	.skip
	lda	#0e0e0h
.skip	xba

	a8
	lda.l	chartram+0,x	; <X> position
	bpl	.entry
	bit	#001111000b	; 80...87 special codes
	beq	special_objset

.entry	clc
	adc	oam_centerX
	a16
	sta	sprites+0,y

	lda.l	chartram+2,x	; set character
	sta	sprites+2,y

	inx			; INC DATA pointer
	inx
	inx
	inx

next_object
	iny			; INC OAM  pointer
	iny
	iny
	iny

	dec	obj_counter
	bne	oammain_loop

	rts


;***********************************************************************
;	special object
;***********************************************************************
;
; << input >> a8
;	 X = ROM pointer
;	 Y = OAM RAM poitner
;
; special codes ----------------------------------
;
;	80h  .... kurukuru normal
;	81h  .... kurukuru frash
;	82h  ....
;	83h  ....
;	84h  ....
;	85h  ....
;	86h  ....
;	87h  ....
;
;-----------------------------------------------------------------------
special_objset
	stx	obj_temp
	a16
	and	#07h
	beq	setobj_kurukuru_normal	;;;; 80h mormal
	dec	a
	beq	setobj_kurukuru_frash	;;;; 81h frash
	bra	setobj_kurukuru_frash
;-----------------------------------------------------------------------
; code 80h
;-----------------------------------------------------------------------
setobj_kurukuru_normal
	km_jsr	set_16obj_posxy		; set position
	ldx	obj_charcheck
	lda.l	kurukuru_normal,x	; kurukuru data
	bra	setobj_kurukuru	
;-----------------------------------------------------------------------
; code 81h
;-----------------------------------------------------------------------
setobj_kurukuru_frash
	km_jsr	set_16obj_posxy
	ldx	obj_charcheck
	lda.l	kurukuru_frash,x	; kurukuru data
;-----------------------------------------------------------------------
setobj_kurukuru
	bne	.set
	lda	#0e0e0h		; off sprite
	sta	sprites+0,y
.set	clc
	ldx	obj_temp
	adc.l	chartram+1,x
	sta	sprites+2,y	; set character
	inx			; pointer INC
	inx
	inx
	bra	next_object

;-----------------------------------------------------------------------
set_16obj_posxy

	a8
	lda	oam_centerY
	sec
	sbc	#8
	xba
	lda	oam_centerX
	sec
	sbc	#8
	a16
	sta	sprites+0,y
	rts

;***********************************************************************
;	OAM Skip program
;***********************************************************************

oam_skip
;-------------------------------------------
	lda	oam_pointer
;- - - - - - - - - - - - - - - - - - - - - -
	ldy	#0e0e0h
.loop	bit	#01111b
	beq	.skip
	tax
	tya
	sta	sprites,x
	txa
	inc	a
	inc	a
	inc	a
	inc	a
	bra	.loop
;- - - - - - - - - - - - - - - - - - - - - -
.skip	sta	oam_pointer
	rts



;********************************************************************
;			****************************************
;			****************************************
; Openning Enemy Animation	****************************************
;			****************************************
;			****************************************
;********************************************************************


;********************************************************************
;	stepup object set
;********************************************************************

mpstepup_disp

	km_bitcheckmismapflag explain1
	beq	.nodemo

	lda	demostepup_count
	sta	yajima_temp
	ldx	kx_clrenemytotal
	bra	.entry

.nodemo
	stz	yajima_temp
	ldx	kx_stepupstock
	cpx	#31
	bcc	.entry
	ldx	#0		; if stepupstock >= 30
.entry
	txa
	beq	.exit

	Mpausemap_rampointer	RAMcmeter+8


	ldy	#0
.setloop

;-------------------------------------------

	lda	#1
	sta	kz_x1		; << patern No set >>

	lda	[Xaddr],y
	iny
	sta	kz_tpx		; << x-position >>
	lda	[Xaddr],y
	iny
	sta	kz_tpy		; << y-position >>

	lda	#stepup_char
	sta	kz_x2		; << character start >>

	dec	yajima_temp
	bpl	.next

	phx			;>>
	phy			;  >>
	ldy	oam_pointer
	km_jsr	kurukuru_enemy
	sty	oam_pointer
	ply			;  <<
	plx			;<<
;-------------------------------------------
.next
	dex
	bne	.setloop

;-------------------------------------------
.exit	
	rts




;********************************************************************
;	map pause main 
;********************************************************************

anime_stepup

	km_bitcheckmismapflag explain1
	beq	.nodemo


	ldx	#stepup_work
	ldy	#stepup_worktotal

.loop	lda	_stepup_flag,x
	beq	.next
	lda	_stepup_anime,x
	bpl	.skip
	lda	#0
.skip	sta	oam_tcount
	lda	_stepup_posX,x
	sta	oam_centerX
	lda	_stepup_posY,x
	sta	oam_centerY

	phx			;>>
	phy			;  >>
	km_jsr	Go_stepup
	ply			; <<
	plx			;<<

	lda	_stepup_anime,x	; timer INC
	inc	a
	bne	.skip1
	pha
	ksound	en_sos_hassha
	pla
	bra	.set

.skip1	bmi	.set
	cmp	#100h
	bcc	.set
	lda	#0ffh		; STOP
.set	sta	_stepup_anime,x


.next	Madx	stepup_workcount
	dey
	bne	.loop

.nodemo
	rts


;********************************************************************
;	stepup open animation 'DEMO'
;********************************************************************

Go_stepup
	lda	oam_tcount
	cmp	#92-17-10
	bcc	.skip
	sbc	#92-17-10
	asl	a
	asl	a
	Mnegative
	pha			; >>
	clc
	adc	oam_centerX
	sta	oam_centerX
	pla			; <<
	clc
	adc	oam_centerY
	sta	oam_centerY

.skip
	Mset	obj_charcheck,6*2
	Mset	oam_animeNo,cd_objanime_stepupopen

	km_jsr	Set_blockobj
	rts

;********************************************************************
;			****************************************
;			****************************************
; MapOBJ Enemy Animation	****************************************
;			****************************************
;			****************************************
;********************************************************************

;
;
;
;
;********************************************************************
;	-------------------------
;	 debug animation program
;	-------------------------
;********************************************************************

test_animation

	ifne	0
;-------------------------------------------------------
	lda	debug_work
	inc	a
	and	#00ffh
	sta	debug_work

	stz	obj_charcheck

	km_jsr	Set_blockobj

	Mset	oam_centerX,60h
	Mset	oam_centerY,60h
	Mset	oam_animeNo,cd_objanime_stepup	; stepup arrived !!
	Mmov	oam_tcount,debug_work

	km_jsr	Set_blockobj

;-------------------------------------------------------
	endc

	rts

;=======================================================================
;====================================================================
;====================================================================
; END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================
