;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         MISMAP.ASM                                          ;
; AUTHOR:       Yasuhiro Kawaguchi                                  ;
; DESCRIPTION:  Mission Map Select Main Routine                     ;
; DATE CREATED: 10-3-93                                             ;
;                                                                   ;
;-------------------------------------------------------------------;
	INCPUB	rammismap

;*********************************************************************
;*								*
;*		Select Mission Map 	[MISSION]		*
;*								*
;*********************************************************************
SelectMissionMap_l
	a8i16
;* Syori Over Check *
	stz	checkirq3
;* Initial *
	jsr	Init_MissionMapParams
;* IRQ enable *
	km_IRQenable	mismapirq,226	;[IRQ enable]
;=========================== Main Loop =================================
.LOOP
	shorta
	longi
;;;;	km_SyoriOverCheckStart

;* Game no Syori Frame Initial *
	a16
	km_clrmismapstflag	finishtrans	;[planet trans enable]
	km_setmismapstflag	gmframesyori	;[1 game fram (8frame) ni 1kai syori]
	km_setmismapstflag	noirqsyori	;[irq syori skip]
	a8
	stz	checkirq

	km_cmpcheckmismapsyori	missiongameover
	km_beq	.GameOver
;-------------------------------------------------------------
;* 		GAME FRAME Routine  [ROM Access Enable]	*
;* memo :kokoni program wo okuto Game Frame ni natte shimau	*
;-------------------------------------------------------------
	shorta
	jsr	mm_GameFrameROMRoutine

;;;	km_SyoriOverCheckEnd
;-------------------------------------------------------------
;*		Draw Planet	[RAM Parallel]		* 
;-------------------------------------------------------------
	jsr	mm_setmarioparms
	jsl	mm_startmario_l

;* Draw Map Swap *
	swapdrawmap
	km_setvar	checkirq2,checkirq
;-------------------------------------------------------------
;*		Wait Bitmap Data Transfer Finish	*
;-------------------------------------------------------------
;* wait irq *
	a16
.waittrans
	km_bitcheckmismapstflag	finishtrans
	beq	.waittrans

;-------------------------------------------------------------
;*		Jump Sequence				*
;-------------------------------------------------------------
;-------------------------------------------------------------
;94/11/10 :kono flag set wa hazusanaikoto !!!!
; nazenara WIPE Close surutokini IRQ ga kiteshimauto (wipe_l ,find_window_pri_l)
;no syori ga dabute shimau kara !!!
	km_setmismapstflag	noirqsyori	;[irq syori skip]
;-------------------------------------------------------------
	km_lldaslx	kw_mismapsyori
	a8
	jmp	(.mapsyori,x)
.mapsyori
	dw	.loop&WM		;[main]
	dw	.DemoEnd&WM		;[explain demo finish]
	dw	.Missionstart&WM	;[mission start]
	dw	.Allclear&WM		;[mission all clear]
	dw	.Gameover&WM		;[mission game over]
	dw	.FinalBoss&WM		;[final boss battle]
	dw	.Beem&WM		;[beem]

;=============================================================
;*		Planet BEEM				*
;=============================================================
.Beem
	a16
..LOOP1
	DEC	KWORK+28
	BEQ	..BeemEnd
	jsl	wipe_l
	jsl	find_window_pri_l	; [window pri]
..irq_wait
	km_bitcheckmismapstflag	irqfinish
	bne	..irq_wait
	km_setmismapstflag	irqfinish
	bra	..LOOP1
..BeemEnd
	km_setmismapsyori	normal
	a8
	brl	.LOOP
;=============================================================
;*		Mission Explain Demo Finish		*
;=============================================================
.DemoEnd
	shorta
	km_settmpgamemode	demo
	km_setdemonumber	entermshipdemo	;selectmissionplayer	;[game mode]
	km_setval.l	kx_demonumber,demo_normal
	a16
	km_clrflag16.l	kx_demoflag,demof_all
	km_clrmistotalflag	explain1	;[DEMO END]
	a8
	brl	.screenoff
;=============================================================
;*		Mission All Clear			*
;=============================================================
.AllClear
	shorta
	km_clrmismapflag	all
;* wipe close *
	km_initwipeclose	mispl
	brl	.screenoff

;=============================================================
;*		Mission Game Over			*
;=============================================================
.GameOver
	shorta
	km_settmpgamemode	demo
	km_setdemonumber	gameoverdemo	;[game mode]
	km_setmistotalflag	destcorneria

;* wipe close *
	km_initwipeclose	mispl
	brl	.screenoff
;=============================================================
;*		Final Boss Battle			*
;=============================================================
.FinalBoss
	shorta
;* wipe close *
	km_settmpgamemode	initmission	;[game mode]
	km_setmismapflag	enemy		;[mismap flag]	:radar check no tame planet mode ni shiteoku !!]
	km_setmissionflag	finalboss	;[missionflag]
	km_setmistotalflag	finalbossbattle	;[missiontotal flag]
	brl	..SKIP_Common
;=============================================================
;*		Mission Game Start			*
;=============================================================
.MissionStart
	shorta
	km_settmpgamemode	missionexplain	;[game mode]
..SKIP_Common
	km_setmismapflag	replaystart
	km_clrflag16.l	mmx_arwingflag,mmf_all
;* keep replay params *
;;;	jsr	keep_replayparams
;* Kettei Sound *
	ksound	map_battle_start
;-----------------------------------------------------------------------
;* wipe close *
.startwipeclose
	km_setsoundport1	stop
	km_initwipeclose	mismap
.wipeloop
	km_decwipetimer
	beq	.screenoff
	cpx	#16
	bpl	.wipeset
.wipefade
	km_fadestepdown

.wipeset
	jsl	wipe_l
	jsl	find_window_pri_l

	km_fadedowncheck
	bne	.wipeloop
;-----------------------------------------------------------------------
;* Screen Off *
.screenoff
	km_screenoff	;( SCREEN,IRQ,HDMA OFF )
	km_clrwipeclose
;* BGM stop *
	km_soundallstop
;* heap ram all free *
	jsl	initmem_l
;* flag *
	a16
	km_setmismapsyori	normal
	km_setnextgamemode		;[game mode]
	km_clrmismapstflag	all 	;[MissionMapState FLAG]
	km_clrmismapfzflag	all 	;[MissionMapFreeze FLAG]
	km_clrscreenflag	all	;[screen flag]
	km_clrsndflag		allstop ;[sound flag]
	a8
	rtl

;*********************************************************************
;*								*
;* 		GAME FRAME Routine  [ROM Access Enable]		*
;*								*
;* Data bank 7e							*
;*********************************************************************
mm_GameFrameROMRoutine
	shorta
	longi
	phb
	db7e
;******* Debug mode *******
;* force soft ware reset *
	km_Debug_reset
;-------------------------------------------------------------
;*		Key Enable Check			*
;-------------------------------------------------------------
	ldx	kw_wipetimer
	beq	.DoGameFrameSyori
	dex	a
	stx	kw_wipetimer
	bne	.end
.Enable
	km_clrgameflag		keydisable
	km_clrscreenflag	wipeopen
;-------------------------------------------------------------
;*		Mission Map Syori Jump			*
;-------------------------------------------------------------
.DoGameFrameSyori
	shorta
	jsr	mm_finalbosschart
	jsr	mm_checkplayerdemo
	jsr	mm_gametotaltm

;-------------------------------------------------------------
;*			END				*
;-------------------------------------------------------------
.end
	plb
	rts
;*********************************************************************
;*								*
;*			Check Player Demo			*
;* Data bank 7e							*
;* Ret :a8i16							*
;*********************************************************************
mm_checkplayerdemo
	shorta
	longi
	ai16
	ldx	kw_MMPlayerSeq
	jsr	(.PlayerDemoTbl,x)
	a8
	rts
.PlayerDemoTbl
	dw	pldemo_nothing&WM
	dw	pldemo_enterplanet&WM
	dw	pldemo_escapebattle&WM
	dw	pldemo_planetclear&WM
	dw	pldemo_enemyclear&WM
	dw	pldemo_fianlbossbattle&WM
;---------------------------------------------------------------------
pldemo_nothing
pldemo_enterplanet
pldemo_escapebattle
pldemo_planetclear
pldemo_enemyclear
	longa
	rts
;---------------------------------------------------------------------
pldemo_fianlbossbattle
	longa
	rts

;*********************************************************************
;*								*
;*		Final Boss Appear Demo Chart			*
;* Data bank 7e							*
;* Ret :a8i16							*
;*********************************************************************
mm_finalbosschart
	shorta
	longi
	ai16
	ldx	kw_FinalBossSeq
	jsr	(.FianlBossTbl,x)
	a8
	rts
.FianlBossTbl
	dw	fbdemo_nothing&WM
	dw	fbdemo_sosdesttrig&WM
	dw	fbdemo_sosdestwait&WM
	dw	fbdemo_wait1&WM
	dw	fbdemo_bossinittrig&WM
	dw	fbdemo_bossappeartrig&WM
	dw	fbdemo_bossappeardemo&WM
	dw	fbdemo_playerstart&WM
	dw	fbdemo_battlestart&WM
;---------------------------------------------------------------------
;* nothing to do *
fbdemo_nothing
	longa
	rts
;---------------------------------------------------------------------
;* sos destruction trigger *
fbdemo_sosdesttrig
	longa
;*memo : SOS Enemy no jibaku Mode wo Set !! *
	ldx	kx_planetlistptr
.loop1
	km_bitcheckflag16.w	mmx_planetflag,mmpnf_sosappear,x
	beq	.skip1
	jsl	self_destruction_l
.skip1
	lda.w	mmx_planetnext,x
	tax
	bne	.loop1
	km_setval	kw_FinalBossSeq,fbseq_sosdestwait
	rts
;---------------------------------------------------------------------
;* sos enemy destruction wait *
fbdemo_sosdestwait
	longa
	lda	kx_enemytotal
	bne	.skip
	km_setval	kwork+28,8
	km_setval	kw_FinalBossSeq,fbseq_wait1
.skip
	rts
;---------------------------------------------------------------------
fbdemo_wait1
	longa
	dec	kwork+28
	bne	.skip
	km_setval	kw_FinalBossSeq,fbseq_bossinittrig
.skip
	rts
;---------------------------------------------------------------------
;* final boss start trig *
fbdemo_bossinittrig
	longa
	km_setmismapflag	finalboss
	km_setval	kw_FinalBossSeq,fbseq_nothing
	rts
;---------------------------------------------------------------------
fbdemo_bossappeartrig
	longa
	km_setval	kw_FinalBossSeq,fbseq_bossappeardemo

	ifeq	0
	jsl	mm_getenemylistptr_l
	sty	kx_FinalBossPtr
;* flag *
	km_setflag16.w	mmx_enflags,(enfl_stepup!enfl_demo!enfl_nocollision),y
	km_setflag16	kw_mmsoundflag,mmsndf_stupappear

;* source postion *
	lda	#$8000
	sta.w	mmx_enposx,y
	lda	#$8000
	sta.w	mmx_enposy,y

	lda	#0
	sta.w	mmx_envel,y	;velocity

;* Character No *
	lda	#0
	sta.w	mmx_enanmptr,y
;* Sprite Animation *
	lda	#cd_objanime_bossappear
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
	lda	#10
	sta.w	mmx_entype,y
	endc
	km_setval	kwork+28,16

	rts
;---------------------------------------------------------------------
fbdemo_bossappeardemo
	longa
	dec	kwork+28
	bne	.skip

	IFEQ	1
	ldy	kx_FinalBossPtr
	a8
	lda.w	mmx_enposx+1,y
	sta	mmx_arwingdestposx
	lda.w	mmx_enposy+1,y
	sta	mmx_arwingdestposy

	a16
	km_clrflag16	mmx_arwingflag,(mmf_arvx!mmf_arvy!mmf_boost)
	km_setflag16	mmx_arwingflag,(mmf_initmove!mmf_go)
	km_setflag16	mmx_cursorflag,(curf_destdisp!curf_pushA!curf_readyspup)
	ENDC

	km_setval	kwork+28,10
	km_setflag16	mmx_arwingflag,(mmf_initmove!mmf_go)
	km_stxval	mmx_arwingsp,32*8
	km_setval	kw_FinalBossSeq,fbseq_playerstart


	ldy	kx_FinalBossPtr
;* Sprite Animation *
	lda	#cd_objanime_bship
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
.skip
	rts
;---------------------------------------------------------------------
fbdemo_playerstart
	longa
	dec	kwork+28
	bne	.skip
	km_setvar	mmx_wipeposX,mmx_arwingdestposX
	km_setvar	mmx_wipeposY,mmx_arwingdestposY

	km_setval	kw_FinalBossSeq,fbseq_battlestart
.skip
	ldy	kx_FinalBossPtr
	lda.w	mmx_enanmtm,y
	and	#$1f
	sta.w	mmx_enanmtm,y

	rts
;---------------------------------------------------------------------
fbdemo_battlestart
	longa
	km_setval	KGameMapPtr,stg_ext2
	km_setval	currentlevel,0
	km_setval	kw_MisMapSyori,mmsy_finalboss
	rts

;*********************************************************************
;*								*
;*		Mission Complete Check				*
;* Data bank 7e							*
;* Ret :a8i16							*
;*********************************************************************
mm_playerdown_l
	php
	jsr	mm_checkmiscomplete
	plp
	rtl
;---------------------------------------------------------------------
mm_checkmiscomplete
	phb
	a16
	db7e
;-------------------------------------------------------------
;*		Mission Complete Check			*
;-------------------------------------------------------------
	km_bitcheckmismapflag	replaystart
	bne	.initial	;(Time Count Up Demo Start)
	brl	.end

;	km_bitcheckmismapstflag	replay
;	km_bne	.end		;(Time Up Count Demo Tyuu)
;	km_bitcheckmismapstflag	complete
;	bne	.complete	;(Time Up Count Demo Not End)
;	brl	.end
;-------------------------------------------------------------
.initial
	LONGA
;* arwing & cursor  move cancel *
	km_clrflag16	mmx_cursorflag,(curf_destdisp!curf_goplanet!curf_readyspup)
	km_clrmismapflag	replaystart

;	km_setmismapstflag	replay
;	jsr	return_replayparams
;	brl	.end
;-------------------------------------------------
.complete
	km_clrmismapstflag	complete
	km_clrmismapflag	battleplayer
	km_clrmismapflag	playernocoll

	km_bitcheckmismapflag	enemy
	bne	.extrasos
;---------------------------------------------------------------------
;*** Mission ga Planet no baai !! ***
.planet
	LONGA
	ldx	kx_currentplanetptr
	km_clrflag16.w	mmx_planetflag,mmpnf_freeze,x

	km_bitcheckmismapflag	missionresult
	km_beq	.end
;* Stack Number Clear *
	phy
	lda.w	mmx_plstackptr,x
	tay
	lda	#0
	sta.w	kx_stackbuffer,y
	sta.w	eenemyNumber_0,y
	ply
;* Step Up Initial *
	LONGA
	km_setstepupmode	inittime,x
	km_setflag16.w	mmx_planetflag,mmpnf_neutral,x
	km_setval.w	mmx_dokuroanm,0,x	;dokuro animation off

;* moshi battle shiteita planet no sos ga born wait jyoutai dattara !! * 
	lda.w	mmx_psos,x
	beq	.skip1
	cmp	#sos_born
	bpl	.skip1
	km_clrflag16.w	mmx_planetflag,mmpnf_sosappear,x
	km_setsosmode	inittime,x
.skip1
	A8
	lda	#step_Neutral
	sta.w	mmx_planetskill,x	;neutral
	dec	kx_clrenemytotal	;Enemy Clear Toal Dec
	bne	.skip2
	km_setmismapstflag	finalbosstrig
	km_setval	kw_FinalBossSeq,fbseq_sosdesttrig
	km_setflag16	kw_MisMapFreezeFlag,(kfz_timefreeze!kfz_cursorfreeze!kfz_bossfreeze)
.skip2
	brl	.end
;---------------------------------------------------------------------
;**** MIssion ga Enemy no baai !!! ****
.extrasos
	LONGA
	ldy	kx_SOSEnemyptr		;enemy pointer
	km_bitcheckmismapflag	missionresult
	km_beq	.player_failed

;* stepup or sos check *
	km_bitcheckflag.w	mmx_enflags,enfl_stepup,y
	beq	.sos
;----------------------------------------------------------------------
;*** Mission ga Step UP no baai !! ***
.stepup
;* Xreg = DESTINATION planet pointer
	longa
	lda.w	mmx_endestplanetptr,y
	tax
	km_setstepupmode	inittime,x
	dec	kx_clrenemytotal	;Enemy Clear Toal Dec
	bne	.skip5
	km_setmismapstflag	finalbosstrig
	km_setval	kw_FinalBossSeq,fbseq_sosdesttrig
	km_setflag16	kw_MisMapFreezeFlag,(kfz_timefreeze!kfz_cursorfreeze!kfz_bossfreeze)
.skip5
	bra	.skip
;----------------------------------------------------------------------
;*** Mission ga SOS no baai !! ***
.sos
;* Xreg = SOURCE planet pointer
	longa
	lda.w	mmx_ensourplanetptr,y
	tax
	km_setsosmode	inittime,x
	km_clrflag16.w	mmx_planetflag,mmpnf_sosappear,x
;----------------------------------------------------------------------
.skip
;* kono test wa debug mode notame *
	lda	kx_enemytotal
	km_beq	mim_blink
;* Free SOS Alien *
	jsl	mm_freeenemylistptr_l	;(enemy flag mo clear)

;* Planet/SOS Flag Clear *
	km_clrmismapflag	enemy
	km_clrmismapstflag	complete
	brl	.end
;----------------------------------------------------------------------
.player_failed
	longa
	longi
	km_clrflag16.w	mmx_enflags,(enfl_encountplayer!enfl_nocollision),y

	km_setval	kz_x1,$10
	km_setval	kz_y1,$10

;	km_bitcheckmismapflag	enemygone
;	beq	.player_exit

.player_exit
	a8
	lda	mmx_arwingposx+1
	bpl	.less80H_X
	pha
	km_negstavar	kz_x1
	pla
.less80H_X
	clc
	adc	kz_x1
	sta	mmx_arwingposx+1

	lda	mmx_arwingposy+1
	bpl	.less80H_Y
	pha
	km_negstavar	kz_y1
	pla
.less80H_Y
	clc
	adc	kz_y1
	sta	mmx_arwingposy+1
	bra	.end
;-------------------------------------------------
	ifeq	1
.enemy_gone
	a8
	lda.w	mmx_enposx+1,y
	bpl	.less80H_enX
	pha
	km_negstavar	kz_x1
	pla
.less80H_enX
	clc
	adc	kz_x1
	sta.w	mmx_enposx+1,y

	lda.w	mmx_enposy+1,y
	cmp	#$50
	bcc	.nochangeY
	sec
	sbc	kz_y1
	sta.w	mmx_enposy+1,y
.nochangeY
	a16
	jsl	calc_enangvelxy_l
	a8
	endc
;------------------------------------------------
.end
	a8
	plb
	rts

;=====================================================================
;*								*
;*			Total Game Timer			*
;* Data Bank :7e							*
;=====================================================================
mm_gametotaltm
	a16
	longi
	km_bitcheckmismapfzflag	timefreeze
	bne	.end
	km_bitcheckmismapstflag	replay
	bne	.mm_gametmadd
	km_setval	kx_DemoEnLoopCnt,1
;**** Sub Timer Count Up ****
	lda	#1
	jsl	kspeedupA_l
	clc
	adc	kx_TotalSubTime
	sta	kx_TotalSubTime

;* Main Timer Check *
	lda	kx_TotalSubTime
	cmp	#mapgftm
	bmi	.notTimeChange
	sec
	sbc	#mapgftm
	sta	kx_TotalSubTime
	km_setmismapstflag	hourpast	;1 hour past flag
	km_addstaval	kx_TOTALTIME,1		;Total Time Count Up
.notTimeChange
	bra	.end
;---------------------------------------------------------------------
;* 		Game ni kakatta Time wo ADD 			*
;---------------------------------------------------------------------
.mm_gametmadd
	LONGA
	IFEQ	1
;* Game Sequence Loop *
;;;	km_setval	mmx_DemoEnLoopCnt,16

	inc	kx_TotalTime
	dec	kw_Gametimer
	beq	.demoend
	inc	kx_TotalTime
	dec	kw_Gametimer
	beq	.demoend

	km_setmismapstflag	hourpast
	lda	#9
	ksound_a		;Time Count Up
	bra	.end
.demoend
	jsr	return_currentparams
	km_setmismapstflag	complete
	km_clrmismapstflag	replay

	ENDC
;---------------------------------------------------------------------
.end
	a8
	rts

;=====================================================================
;*								*
;*		Initial Mission Map Params			*
;*								*
;=====================================================================
Init_MissionMapParams
;!!!! kono Routine wa itiban saisyo ni oku !!!!
	ifne	kdemosw
	km_setmismapflag	explain
	endc

;* Planet Enemy List Initial *
	jsl	Initial_MMList_l
;* Copy RAM Program & Data to HEAP RAM *
	jsr	mm_heapcopy

;* flags *
	a8
 	km_setspritemode	mismap	   ;[SPRITE MODE]
	km_setscreenmode	mismap	   ;[SCREEN MODE]
	a16
	km_clrmissionflag	parallel   ;[MISSION FLAG]
	km_clrscreenflag	sprwbuf	   ;[SCREEN FLAG]
	km_setscreenflag	bgcolpal   ;[SCREEN MODE]
	km_setscreenflag	normalwipe ;[SCREEN FLAG]
	km_setscreenflag	screenadd  ;[SCREEN MODE]
	km_clrmismapstflag	all	   ;[MISSIONMAPSTATE FLAG]
	km_setmismapstflag	noirqsyori ;[MISSIONMAPSTATE FLAG]

;* Key Read State Clear *
	km_clrgmjoypad
	km_clrgmkeydown

;* moshi mission explain wo surunara !! *
	km_bitcheckmistotalflag	explain1
	beq	.skip
	km_setmismapfzflag	timefreeze
	km_setflag16.l	kx_demoflag,(demof_demo!demof_sosappear)
.skip

;* Mario Chip Set Up *
	a8
	lda	#height_160!colours_16
	sta	mario_draw_mode		;V hight = 160,colour = 16
	sta	mio_mode
	a16
	lda	#mm_bitmaphight*8
	sta.l	m_screenheight		;Screen Hight
	a8

;* Set VRAM double buffering *
	km_stxval	vmap1,mm_bg1_bitmap1	;VRAM bitmap base1 addr ($0c00)
	km_stxval	vmap2,mm_bg1_bitmap2	;VRAM bitmap base2 addr ($2c00)
	km_stxval	drawmap,bitmap1		;Mario Write Buffer	($4000)
	km_stxval	showmap,bitmap1_dbl	;Mario Transfer Buffer	($a000)

;* Parameter initial *
	phb
	db7e
	km_setvar	mmx_playerNo,p1_pilotNo	;[For Message]

;;;	km_setval	mmw_speedup,1		;normal speed
	km_setval	coltimer_0,10		;bg color flash timer
	km_setval	key_tatemaxptr1,6
	km_setval	mmw_wbuffercounter,(2*mm_planetnumber)	;double buffer swap counter
	km_setval	mmx_destmarktm,8

;;;;	km_setval	kx_TotalSubTime,mapgftm
;;;;	km_setval	mmx_stationtm,20
;;;;	km_setval	mmw_planetdataptr,0	;planet data pointer ;(cx,cy,R,swsprite)

	km_stxval	kx_showmapsize,0
	km_stxval	mmw_vramadr,(($100*$20)+mm_bg1_cgx_2)/2	;VRAM(BG1) write start adderss

;;;;	km_stxval	mmx_curanmpat,$0102	;cur sor anim pattern
;;;;	km_stxval	mmx_curanmpat2,$0100

;	km_stxval	mmx_planetangx,$1000	;planet angle X
;	km_stxval	mmx_planetangz,$1000	;planet angle Z
;	km_stxval	mmw_planetanmptr,$800	;Radius
	plb

;* SOUND BGM SET *
	km_setsndmode
	km_ldxsoundtblptr
	KSoundBGMTrans
	lda	kw_mmBGM
	KBGM_a
;* Screen Set *
	jsr	Init_MMScreen		;[SCREEN INITIAL]
	jsl	init_sprites_l		;[SPRITES]
	jsr	Init_MarioDrawRAM	;[Mario RAM Clear] :Init_MMscreen no atoni oku !!!

;* Check Complete *
;kanarazu flag set no ushiro oku !!
;kanarazu yjmapinit_l no mae oku !!
	jsr	mm_checkmiscomplete
;* message initial *
	jsl	yjmapinit_l	;[yajima]

;* wipe init & open *
	jsl	wipeinit_l	;[yajima]
;;;	km_initwipeopen	mismap

	km_stxval	kw_wipetimer,5	;[wipe timer = 0 ni narumade keydiable]
	km_setgameflag	keydisable
	km_setscreenflag	wipeopen
;* Set H-DMA Params *
	jsl	init_mmhvscroll_l
	jsr	init_hdmaparams
	jsr	init_windows

;* kuru kuru arwing CGX pointer Initial *
	phb
	db7e
	jsr	mm_calcplayercgxptr
	plb
	rts
;=====================================================================
;*			Keep Replay Params			*
;=====================================================================
keep_replayparams
	shorta
	longi
	ifeq	1
	phb
	db7e
;* Save Params *
	km_blocktrans	kx_replaytmplist,kx_replaybaklist,replaylistlen

;* Planet *
	a16
	ldx	kx_planetlistptr
.loop_planet
	ldy	#planetreplaysize/2
.loop_states
	lda.w	mmx_planetflag,x
	sta.w	mmx_Repplanetflag,x
	inx
	inx
	dey
	bne	.loop_states

	lda.w	mmx_planetnext,x
	beq	.finish_planet
	tax
	bra	.loop_planet
.finish_planet

;* Enemy List *
	km_setvar	kx_repenlistptr,kx_enlistptr
	km_setvar	kx_repenfreeptr,kx_enfreeptr
	km_blocktrans	kx_enemylist,kx_repenemylist,mmx_enemylen*_enemynum

	a8
	plb
	endc
	rts

;=====================================================================
;*			Set Replay Params			*
;=====================================================================
return_replayparams
	ifeq	1
	php
	a16
	longi
;********* Current Buffer Keep ************
;* Total Time & Total Enemy number *
	km_blocktrans	kx_replaytmplist,kx_replaycurlist,replaylistlen

;* Planet Buffer Keep *
	LONGA
	ldx	kx_planetlistptr
.loop_planet
	ldy	#planetreplaysize/2
	phx
.loop_states
;* Planet List*
	lda.w	mmx_planetflag,x
	sta.w	mmx_Curplanetflag,x
	inx
	inx
	dey
	bne	.loop_states

	plx
	lda.w	mmx_planetnext,x
	beq	.finish_planet
	tax
	bra	.loop_planet
.finish_planet
;* Enemy List *
	LONGA
	km_stxvar	kx_CURenlistptr,kx_enlistptr
	km_stxvar	kx_CURenfreeptr,kx_enfreeptr
	km_blocktrans	kx_enemylist,kx_CURenemylist,mmx_enemylen*_enemynum
;----------------------------------------------------------------------------
;* Replay Initial *
	km_blocktrans	kx_replaybaklist,kx_replaytmplist,replaylistlen

;* Replay Return *
	LONGA
	ldx	kx_planetlistptr
.loop_planet2
	ldy	#planetreplaysize/2
	phx
.loop_states2
	lda.w	mmx_Repplanetflag,x
	sta.w	mmx_planetflag,x
	inx
	inx
	dey
	bne	.loop_states2

	plx
	lda.w	mmx_planetnext,x
	beq	.finish_planet2
	tax
	bra	.loop_planet2
.finish_planet2
;* Enmey List Replay *
	LONGA
	km_stxvar	kx_enlistptr,kx_REPenlistptr
	km_stxvar	kx_enfreeptr,kx_REPenfreeptr
	km_blocktrans	kx_repenemylist,kx_enemylist,mmx_enemylen*_enemynum
	plp
	endc
	rts

;=====================================================================
;*
;=====================================================================
return_currentparams
	LONGA
	LONGI
	ifeq	1
;* Return Currnet Params *
	km_blocktrans	kx_replaycurlist,kx_replaytmplist,replaylistlen

;* Planet *
	ldx	kx_planetlistptr
.loop_planet
	ldy	#planetreplaysize/2
.loop_states
	lda.w	mmx_Curplanetflag,x
	sta.w	mmx_planetflag,x
	inx
	inx
	dey
	bne	.loop_states

	lda.w	mmx_planetnext,x
	beq	.finish_planet
	tax
	bra	.loop_planet
.finish_planet

;* Return Current Enemy List *
	km_stxvar	kx_enlistptr,kx_CURenlistptr
	km_stxvar	kx_enfreeptr,kx_CURenfreeptr
	km_blocktrans	kx_CURenemylist,kx_enemylist,mmx_enemylen*_enemynum
	endc
	RTS


;=====================================================================
;*								*
;*			Initial Mario Params			*
;*								*
;=====================================================================
mm_setmarioparms
	shorta
	longi
;---------------------------------------------
;* 	Mario Program Initial		*
;---------------------------------------------
;--- Draw Map Set ----
	lda	drawmap+1
	lsr	a
	lsr	a
	sta.l	mscrbase
	a16
	lda	drawmap
	sta.l	m_drawmap

;* Base Address Set *
	longa
	lda	#bitmapbase&WM	;$700000
	clc
	adc	drawmap
	sta.l	m_x1		;top address

	km_setval.l	m_x2,mm_wbuflength	;16chr(yoko)*20chr(tate)*32
	km_setval.l	m_scale,(15*32768)/16
	sta.l	mspr_pal

;---------------------------------------------
;* Planet Data Copy ( Mario Data Copy)	*
;---------------------------------------------
	longa
	phb
	db7e
;--- For Message ---
	km_stxvar	mmx_mapstates,mmx_cursorflag
;--- Draw List size ---
	km_setval.l	m_planetlen,m_planetdrawlen	;planetdrawsize
;* shadow list *

;* planet List *
	ldx	#0
	ldy	kx_planetlistptr
	stz	mmx_DrawPlanetCnt
.LOOP
	cpy	kx_MeteorPtr
	beq	.Skip
	lda.w	mmx_bitmapcx,y
	sta.l	mmm_planetcx,x
	lda.w	mmx_bitmapcy,y
	sta.l	mmm_planetcy,x
	lda.w	mmx_planetR,y
	sta.l	mmm_planetR,x
	lda.w	mmx_planetsprite,y
	sta.l	mmm_planetsprite,x

	inc	mmx_DrawPlanetCnt		;planet no kazu
	txa
	clc
	adc	#m_planetdrawlen	;planetdrawsize
	tax
.Skip
	lda.w	mmx_planetnext,y
	tay				;NEXT Planet List Pointer
	bne	.LOOP

;--- planet no kazu ---
	lda	mmx_DrawPlanetCnt
	sta.l	m_planetcnt
	plb

;--- planet angle y ----
	km_addstaval	mmw_planetroty,$100
	sta.l	m_planetroty

;----- Message List Copy to Mario RAM ------
	jsl	yjmapmain_l

;	lda.l	m_mapBG3scrollX
;;	sta	kw_bg3hofs

	lda.l	m_mapBG1scrollY
	sta.l	kx_vscrollp1
;;;	sta	kw_bg3vofs

	km_blocktrans	kx_messagelist,m_mapcursor,messagelistlen
	a8
	rts


	IFEQ	1
;---------------------------------------------------------
;******* Debug mode *******
;* force soft ware reset *
	km_Debug_reset
;* prev check *
	km_acmpjoypad	prev
	bne	.noprev
	km_settmpgamemode	selectmissionplayer	;[GAME MODE]
	ksound	cancel
	bra	.bgmfade
.noprev
	ENDC
;---------------------------------------------------------------------
;*			Now Not Using				*
;---------------------------------------------------------------------
;-------------------------------------------------------------
;*		Planet Making (CGX kakikae Ver)		*
;-------------------------------------------------------------
	IFEQ	1
	lda.l	KCGSCTransTimer
	beq	.changeADDR
	dec	a
	sta.l	KCGSCTransTimer
	bra	.skip
.changeADDR
	lda	#20
	sta.l	KCGSCTransTimer

	a16
	lda.l	KCGXSCRTransCPUAddr
	clc
	adc	#$800
	cmp	#$2000
	bne	.setadr
	lda	#0
.setadr
	sta.l	KCGXSCRTransCPUAddr
.skip
	a8
	ENDC


;=====================================================================
;*			COPY to HEAP RAM			*
;* data bank :7e							*
;=====================================================================
mm_heapcopy
	shorta
	longi
	phb
	db7e
;**** Initialises free memory list ****
	jsl	initmem_l

;*************************
;*    RAM PROGRAM COPY   *
;*************************
	a16
	lda	#heap_proglen
	jsl	alloc_l
	sta	mmx_rampogaddr
;* program copy *
	tay
	ldx	#0	
	a8
.nxt
	lda.l	heap_runmariostart_l,x
	sta.w	heap,y
	inx
	iny
	cpx	#heap_proglen
	bne	.nxt

;*******************************
;* Collision (Size) List Copy *
;*******************************
	IFEQ	1
	a16
	lda	#$400
	jsl	alloc_l
	sta	kx_BGcolltbladdr
	ENDC
;*******************************
;* Sprite Sub (Size) List Copy *
;*******************************
	a16
	lda	#mm_SpriteSizeLen
	jsl	alloc_l
	sta	mmx_sprsizeaddr

;* sprite size list copy *
	tay
	ldx	#0
	a8
.nxt_size
	lda.l	SpriteSizeFlag,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_SpriteSizeLen
	bne	.nxt_size
;*******************************************************
;*    OBJ CGX RAM KEEP (HEAP)  kurukuru Arwing no CGX  *
;*******************************************************
objcgxbuffer_len	equ	$1000

	a16
	lda	#objcgxbuffer_len&WM
	jsl	alloc_l
	sta	mmx_objcgxaddr

;* arwing cgx (OBJ CGX) wo heap RAM ni copy *
	decram	e7_ccr,0

	a8
	ldx	mmx_objcgxaddr
	km_dmaromXram	0,($700000+dec_base),heap,cgxbuffer_len

;*************************************************************
;* OAM Pattern Data (Arwing kuru kuru pattern Data) Copy 	*
;*************************************************************
	a16
	lda	#mm_sprarwinglen
	jsl	alloc_l
	sta	mmx_sprarwingaddr

;* sprite (arwing) no pattern datacopy *
	tay
	ldx	#0
	a8
.nxt_arwing
	lda.l	mm_sprarwing,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_sprarwinglen
	bne	.nxt_arwing

;******************************
;* OAM Data (Station) Copy *
;******************************
	IFEQ	1
	a16
	lda	#mm_sprstationlen
	jsl	alloc_l
	sta	mmx_sprstationaddr

;* sprite (station) copy *
	tay
	ldx	#0
	a8
.nxt_station
	lda.l	mm_sprstation,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_sprstationlen
	bne	.nxt_station
	ENDC
;*********************************************
;* Enemy Chart Data Copy 	*
;*********************************************
	IFEQ	1
	a16
	lda	#mm_enemychartlen
	jsl	alloc_l
	sta	mmx_enemychartddr

;* enemy chart data copy *
	tay
	ldx	#0
	a8
.nxt_chart
	lda.l	mm_enemychart,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_enemychartlen
	bne	.nxt_chart
	ENDC

;*********************************************
;* OAM Data (Gesso ANM pattern) Copy 	*
;*********************************************
	IFEQ	1
	a16
	lda	#mm_sprgessolen
	jsl	alloc_l
	sta	mmx_sprgessoaddr

;* sprite (gesso) copy *
	tay
	ldx	#0
	a8
.nxt_gesso
	lda.l	mm_sprgesso,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_sprgessolen
	bne	.nxt_gesso

	ENDC

;******************************
;* Sprite Data (ball) Copy    *
;******************************
	a16
	lda	#(mmx_balllen*3)
	jsl	alloc_l
	sta	mmx_sprballaddr
	a8
;*************************
;* Collision List Copy   *
;*************************
	IFEQ	1
	a16
	lda	#mm_col_listlen
	jsl	alloc_l
	sta	mmx_collisaddr
;* collision list copy *
	tay

	ldx	#0	
	a8
.nxt_col
	lda.l	mm_col_list,x
	sta.w	heap,y
	inx
	iny
	cpx	#mm_col_listlen
	bne	.nxt_col
	ENDC
;-------------------------------------
	plb
	rts

;*****************************************************************************
;*									*
;*									*
;*		Initial Mission Map Params				*
;*									*
;* data bank :7e								*
;*****************************************************************************
Initial_MMList_l
	shorta
	longi
	php
	phb
	db7e
	a16
;* moshi atarashiku Game wo hajimeruno nara Parameter wo Initial suru *
	km_bitcheckmistotalflag	initialmap
	km_bne	.end
	km_setmistotalflag	initialmap

;* partner continue enable check *
	km_bitcheckmistotalflag	partner1
	beq	.mainplayer
;---------------------------------------------------------------------
;*			Partner Continue			*			
;---------------------------------------------------------------------
.partnercontinue

;* Corneria HP *
;;;;	km_setval	kx_CorneriaHP,corneriaHP

;* player type *
	a8
	km_setvar	p1_pilotNo,p2_pilotNo
	a16
;* player HP *
	jsl	playerstatus_init_l
;* arwing initial postion *
	a8
	km_setvar	mmx_arwingposx+1,kx_mshipx
	km_setvar	mmx_arwingposy+1,kx_mshipy
;* Player Sound *
	KSoundPlayerTrans
	km_setval	kw_mmBGM,kbgm_stg1
	a16
;* flags *
	km_clrmistotalflag	partner1
	brl	.end
;---------------------------------------------------------------------
;*		Initial Mission Map Game			*
;---------------------------------------------------------------------
.mainplayer
	longa
	km_clrmismapflag	all
	km_clrmismapfzflag	all
	km_clrmissionflag	all
	km_setmismapsyori	normal
	km_setval		kw_FinalBossSeq,fbseq_nothing
	km_setval		kw_totalscore1,0
	km_stxval		kw_totalscore1+1,0

;* planet no kazu *
	ldx	kdifficulty
	km_loblda.l	mm_planetkazutbl,x
	sta.l	kx_drawplanetkazu
	dec	a
	sta.l	kx_missionplanetkazu

;======================================
;*   MISSION MAP Work RAM All Clear	 *
;======================================
	km_dmaWRAMClear	0,MISSIONXRAM,MISSIONXRAMLen

;=====================================
;*   Enemy Stack Buffer Clear	*
;=====================================
	ldy	#15
	lda	#0
.loop_stackclear
	sta.w	kx_stackbuffer,y
	sta.w	eenemyNumber_0,y
	dey
	bpl	.loop_stackclear

;=====================================
;*   	Set Random 		*
;=====================================
;* moshi demo wo skip shita baai mouichido Planet List wo Set suru !!*
;	km_bitcheckmismapflag	expcancel
;	beq	.notexplain_cancel
;	km_clrmismapflag	expcancel
;	km_stxvar	kw_RndPlanetPtr,kw_RndPlanetPtrBak
;	bra	.Skip0
;.notexplain_cancel
;
;* Atarashii RANDOM Planet Pointer wo SET suru nara (continue ka douka Check *
;	km_bitcheckmistotalflag	retry
;	beq	.Notcontinue
;	km_clrmistotalflag		retry
;	km_stxvar	kw_RndPlanetPtr,kw_RndPlanetPtrBak
;	bra	.SKIP0
;.Notcontinue
;* Random Planet Pointer Set *
;	a16
;	jsl	KGetRandomPtr_l
;	sta	kw_RndPlanetPtr
;	sta	kw_RndPlanetPtrBak
;.SKIP0
;----------------------------------------------
	a16
	km_bitcheckmistotalflag	random
	beq	.NotRandom
	km_clrmistotalflag	random

	jsl	KGetRandomPtr_l
	sta	kw_RndPlanetPtr

;* stack pointer & buffer clear *
	a8
	stz	kx_stackbaseptr
	ldx	#kstacklen
.loop
	stz	kx_stackbaseptr,x
	dex
	bpl	.loop
	a16
.NotRandom
;* sos enemy stage random *
	lda	kw_RndPlanetPtr
	and	#127
	sta	sos_rnd_offset
;* missile ranom *
	lda	kw_RndPlanetPtr
	and	#15
	sta	miss_rnd_offset
;* planet stage random *
	and	#127
	sta	pl_rnd_offset
;* stepup  enemy stage random *
	jsl	KGetRandomPtr_l
	and	#31
	sta	step_rnd_offset
	a8
;======================================
;*   MISSION MAP Params Set		 *
;======================================
;* Corneria HP *
	km_setval	kx_CorneriaHP,corneriaHP
;* player HP *
	jsl	playerstatus_init_l
;* Game Total Time *
	km_stxval	kx_TOTALTIME,0		;mission game total time

;* Step UP Enemy Stock & Clear Count *
	km_hib0
	ldx	kdifficulty
	lda.l	clrtotalkazutbl,x
	tax
	stx	kx_clrenemytotal
	stx	kx_stepupstock
	stx	kx_stepupuchidome
	stx	kx_initenemytotal
;* arwing states *
	km_stxval	mmx_arwingsp,arwingspeed

;* Planet Free List Format *
	jsr	FormatPlanetList

;* Enemy Free List Format *
	jsr	FormatEnemyList

;* Corneria Planet Set *
	km_stxval	mmw_bitmapptr,0

	jsr	SetCorneria
;* Random Planet Set *
	jsr	SetRandomPlanet

;* mother ship states*
	a8
	ldx	mmz_rndposptr
	km_hib0
	lda.l	randomtbl,x
	asl	a
	tax
	lda.l	planetpostbl+0,x
	km_multa8
	sta	kx_mshipx		;Planet Center X
	lda.l	planetpostbl+1,x
	km_multa8
	sta	kx_mshipy		;Planet Center Y

;* Set Enemy List *
	jsr	SetRandomEnemy

;* arwing initial postion *
	km_setvar	mmx_arwingposx+1,kx_mshipx
	km_setvar	mmx_arwingposy+1,kx_mshipy

;* cursor states *
	km_setvar	mmx_curposx,kx_mshipx
	km_setvar	mmx_curposy,kx_mshipy

;* BGM *
	km_setval	kw_mmBGMPtr,0
	km_setval	kw_mmBGM,kbgm_stg1
.end
	plb
	plp
	rtl
clrtotalkazutbl
	db	clrtotal_easy
	db	clrtotal_normal
	db	clrtotal_hard

;=====================================================================
;*		Planet no kazu Table				*
;=====================================================================
mm_planetkazutbl
	db	planetkazu_easy		;easy
	db	planetkazu_normal	;normal
	db	planetkazu_hard		;hard
;=====================================================================
;*		Format	Planet List				*
;* Data Bank 7e							*
;=====================================================================
FormatPlanetList
	shorta
	longi
	a16
	stz	kx_planetlistptr
	stz	kx_corneriaptr
	fmtfreelst.w	kx_planetfreeptr,kx_planetlist&WM,planetkazumax,planetlistlen
	a8
	rts
;=====================================================================
;*		Format	Enemy List				*
;* Data Bank 7e							*
;=====================================================================
FormatEnemyList
	shorta
	longi
	a16
	stz	kx_enemychartptr
	stz	kx_enemytotal

	stz	kx_enlistptr
	fmtfreelst.w	kx_enfreeptr,kx_enemylist&WM,_enemynum,mmx_enemylen

;	stz	kx_repenlistptr
;	fmtfreelst.w	kx_repenfreeptr,kx_repenemylist&WM,_enemynum,mmx_enemylen
	a8
	rts

;=====================================================================
;*								*
;*		Set Corneria Params				*
;* data bank :7e							*
;* Yreg :Corneria List Pointer					*
;=====================================================================
mmz_rndposptr	=	kz_y1	;2 byte
mmz_rndstgptr	=	kz_z1	;2 byte
mmz_planetcnt	=	kz_tpx	;2 byte
mmz_planetskill	=	kz_tpy	;1 byte
mmz_rndstgbaseptr	=	kz_x2	;2 byte
mmz_tmpwork		=	kz_y2	;2 bute
mmz_difficultyptr	=	kz_z2	;2 byte
;--------------------------------------------------
SetCorneria
	SHORTA
	LONGI
	km_lldaslx	Kdifficulty
	lda.l	CorneriaPosTbl+0,x
	sta	kx_RndPlanetX		;Planet Center X
	lda.l	CorneriaPosTbl+1,x
	sta	kx_RndPlanetY		;Planet Center Y
	a16
	lda	#$c
	sta	kx_RndPlanetR		;Planet Center R
	lda	#bg_colpal7
	sta	kx_RndPlanetCol		;Colour No
	lda	#corneria_spr
	sta	kx_RndPlanetSpr		;Maping Sprite
	a8
	km_setval	kx_RndPlanetStage,planet_corneria	;<<< 6
	jsr	SetPlanetList
	km_setflag16.w	mmx_planetflag,mmpnf_corneria,y
	sty	kx_corneriaptr
	rts

CorneriaPosTbl
	db	corneriaEX,corneriaEY	;easy  (mother planet)
	db	corneriaNX,corneriaNY	;normal(mother planet)
	db	corneriaHX,corneriaHY	;hard  (mother planet)

;=====================================================================
;*								*
;*		Set Random Planet Params			*
;* data bank :7e							*
;=====================================================================
mmz_rndposptr	=	kz_y1	;2 byte
mmz_rndstgptr	=	kz_z1	;2 byte
mmz_planetcnt	=	kz_tpx	;2 byte
mmz_planetskill	=	kz_tpy	;1 byte
mmz_rndstgbaseptr	=	kz_x2	;2 byte
mmz_tmpwork		=	kz_y2	;2 bute
mmz_difficultyptr	=	kz_z2	;2 byte
;--------------------------------------------------
SetRandomPlanet
	shorta
	longi
;------------------------------------------
;* Initial Battle Planet no kazu*
	a16
	ldx	kdifficulty
	km_loblda.l	IntBatPlanetTbl,x
	sta	mmx_stepupsetcnt
	asl	a
	sta	kz_x1

;* table data wo set surutame no base pointer *
	ldx	#stup_easytmbase
	lda	kdifficulty
	beq	.skip	;easy
	ldx	#stup_normaltmbase
	dec	a
	beq	.skip	;normal
	ldx	#stup_hardtmbase
.skip
	txa
	clc
	adc	kz_x1
	sta	mmx_stepupsetptr
;------------------------------------------
;* planet no kazu *
	longa
	lda	kx_missionplanetkazu
	sta	mmz_planetcnt
;------------------------------------------
;**** Planet Draw List Set *****
	longa
	longi

	ldx	kdifficulty
	dex
	beq	.random		;if normal
.fix	;(easy,hard)
	lda	#0
	bra	.set_pointer
.random	;(normal)
	lda	kw_RndPlanetPtr
	and	#7
.set_pointer
	sta	mmz_rndposptr	;Random Postion Pointer
	sta	mmz_rndstgptr	;Random Stage Pointer

	km_lldm4x	kdifficulty	;Read Difficulty
	sta  	mmz_difficultyptr
	lda.l	randomtbl+0,x
	sta	mmz_tmpwork		;stage tabel base pointer

	lda	kx_missionplanetkazu
	inc	a
	ldx	mmz_rndposptr
	a8
	km_cpumultu8u8	x
	a16
	clc
	adc	mmz_tmpwork
	sta	mmz_rndposptr

	ldx  	mmz_difficultyptr
	lda.l	randomtbl+2,x
	sta	mmz_tmpwork		;stage tabel base pointer
	lda	kx_missionplanetkazu
	ldx	mmz_rndstgptr
	a8
	km_cpumultu8u8	x
	a16
	clc
	adc	mmz_tmpwork
	sta	mmz_rndstgptr

;* Initial Meteor Pointer *
	stz	kx_MeteorPtr
;* Initial Random Planet Order Number *
	km_stxval	mmx_RndPlanetCnt,0

.LOOP
	longa
;* Random Postion Set
	ldx	mmz_rndposptr
	lda.l	randomtbl,x
	km_loba
	asl	a
	tax
	a8
	lda.l	planetpostbl+0,x
	sta	kx_RndPlanetX		;Planet Center X
	lda.l	planetpostbl+1,x
	sta	kx_RndPlanetY		;Planet Center Y

	ldx	mmz_rndstgptr
	lda.l	randomtbl,x
	sta	kx_RndPlanetStage	;Planet Stage
	km_cpumultu8uf8	x,planetstgtblsize
	a16
	lda.l	planetstgtbl+0,x
	sta	kx_RndPlanetR		;Planet Center R
	lda.l	planetstgtbl+2,x
	sta	kx_RndPlanetSpr		;Maping Sprite
	lda.l	planetstgtbl+4,x
	sta	kx_RndPlanetCol		;Colour No
	a8

	jsr	SetPlanetList

	a16
	inc	mmz_rndposptr
	inc	mmz_rndstgptr
	inc	mmx_RndPlanetCnt
	dec	mmz_planetcnt
	km_BNE	.LOOP
.end
	a8
	rts

IntBatPlanetTbl
	db	battleplanet_easy
	db	battleplanet_normal
	db	battleplanet_hard
;---------------------------------------------------------------------
;*								*
;*			Planet List Initial			*
;* data bank :7e							*
;* Yreg :planet List Pointer						*
;---------------------------------------------------------------------
SetPlanetList
	shorta
	longi
;---------------------------------------
;* get Planet list memory *
	ldx	#0
	l_add.w	kx_planetlistptr,kx_planetfreeptr,mim_blink
	txy
;---------------------------------------
;;* initial states *
;	lda	#0
;	sta.w	mmx_stagecnt,y
;---------------------------------------
;* Planet Character Base No (For Planet Screen Data Pointer)*
	ldx	mmw_bitmapptr
	txa
	sta.w	mmx_charabaseptr,y
;---------------------------------------
;* Planet Bitmap Base (X,Y) *
	a16
	lda.l	planetdata,x
	km_loba
	sta.w	mmx_bitmapcx,y
	lda.l	planetdata+1,x
	km_loba
	sta.w	mmx_bitmapcy,y
	a8
;---------------------------------------
;* Get screen data base address *
	lda	kx_RndPlanetStage
	sta.w	mmx_stage,y		;Planet Stage No
	cmp	#planet_stage5		;(gamelist.inc)
	bne	.NotMeteor
	sty	kx_MeteorPtr		;Meteor List Pointer Set
.NotMeteor
;* Planet Draw List *
	lda	kx_RndPlanetX		;Planet Center X
	sta.w	mmx_scrcx,y
	km_multa8
	sta.w	mmx_planetcx,y
	lda	kx_RndPlanetY		;Planet Center Y
	sta.w	mmx_scrcy,y
	km_multa8
	sta.w	mmx_planetcy,y
	a16
	lda	kx_RndPlanetR		;Planet Center R
	sta.w	mmx_planetR,y
	lda	kx_RndPlanetSpr		;Maping Sprite
	sta.w	mmx_planetsprite,y
	lda	kx_RndPlanetCol		;Colour No
	sta.w	mmx_planetcol,y
;-------------------------------------------------------------------------
.end
	a8
	inx
	inx
	stx	mmw_bitmapptr	Next Bitmap Pointer (0,2,4,6,...)
	rts

;---------------------------------------------------------------------
;*								*
;*		Appear Enemy & Battle Planet Initial		*
;* data bank :7e							*
;* Yreg :planet List Pointer						*
;---------------------------------------------------------------------
SetRandomEnemy
	a16
	longi

	ldx	#0
	ldy	kx_planetlistptr
.LOOP
;------------------------------------------------------------------------

	km_bitcheckmistotalflag	explain1
	beq	.normal
;------------------------------------------------------------------------
.explain
	IFEQ	0
;* step up states *
	km_setstepupmode	nothing,y
;* planet skill *
	a8
	km_setval.w	mmx_planetskill,step_Neutral,y
	a16
;* planet flag *
	km_setflag16.w	mmx_planetflag,mmpnf_neutral,y
;* sos states *
	km_setsosmode	inittime,y
	ENDC
	brl	.nextenemy
;-------------------------------------------------------------------------
.normal	;(Retry or Explain Cancell version)
	a8
	lda	mmx_stepupsetcnt
	beq	.NeutralPlanet
	dec	a
	sta	mmx_stepupsetcnt
;-------------------------------------------------------------------------
.BattlePlanet
;* Set Planet Skill *
	a16
	phx
	tyx
	jsl	ksetplanetskill_l
	plx

;* planet Animation Pointer *
	lda	#$8000
	sta.w	mmx_dokuroanm,y
;* step up states *
	dec	kx_stepupstock		;(1994/12/25 :kokowa dec OK! )
	dec	kx_stepupuchidome	;(1994/12/27)
	km_setstepupmode	dokuro,y
	km_setsosmode	wait,y
	km_setflag16.w	mmx_planetflag,mmpnf_sosappear,y

;;;;;;	ldx	mmw_bitmapptr
	lda.l	.SOSappeartbl,x
	sta.w	mmx_soswaittm,y

;* guard enemy trigger *
	km_setflag16.w	mmx_planetflag,mmpnf_guardappear,y
	km_setval.w	mmx_pguard,guard_init,y
	bra	.nextenemy
;-------------------------------------------------------------------------
.NeutralPlanet
	shorta
;* planet skill *
	km_setval.w	mmx_planetskill,step_Neutral,y
;* planet flag *
	a16
	km_setflag16.w	mmx_planetflag,mmpnf_neutral,y
.Zaico_Nashi
	lda	kx_stepupuchidome
	bne	.Zaico_Ari
	km_setstepupmode	nothing,y
	km_setsosmode		nothing,y
	bra	.Zaico_Skip
;* step up states *
.Zaico_Ari
	km_setstepupmode	wait,y
	phx		;>>> Push X (bitmap pointer)
	ldx	mmx_stepupsetptr
	lda.l	StepupAppTmTbl,x		;wait time
	sta.w	mmx_stupwaittm,y
	inc	mmx_stepupsetptr
	inc	mmx_stepupsetptr
	plx		;>>> Pull X (bitmap pointer)
;* zaico wo herasu !! (1994/12/27 henkou!!) *
	dec	kx_stepupuchidome
;* sos states *
	km_setsosmode	inittime,y
.Zaico_Skip
;-------------------------------------------------------------------------
.nextenemy
	inx
	inx

	lda.w	mmx_planetnext,y
	tay
	cpy	kx_corneriaptr	;check suru planet = corneria 
	beq	.end
	brl	.LOOP
;-------------------------------------------------------------------------
.end
	a8
	rts

;=====================================================
;*		Appear Table			*
;=====================================================
.SOSappeartbl
	dw	sos_intstg1tm	;1
	dw	sos_intstg2tm	;2
	dw	sos_intstg3tm	;3
	dw	sos_intstg4tm	;4
	dw	sos_intstg5tm	;5
	dw	sos_intstg6tm	;6

	IFEQ	1
;* planet skill base *
	jsl	KGetRandomPtr_l
	clc
	adc	kw_RndPlanetPtr
	sta	mmz_planetskill

;* planet skill *
	phx
	phy
	ldx	kdifficulty
	lda.l	planetskilloff,x
	km_loba
	tax
	lda	mmz_planetskill
	jsl	kdivu16u8_sub_l

; easy   : 0~3
; normal : 0~7
; hard   : 0~12
	a8
	tya
	ply
	sta.w	mmx_planetskill,y
	plx
	a16
	ENDC

;*********************************************************************
;*								*
;*		Initial Mission Map Select			*
;*								*
;*********************************************************************
Init_MMScreen
	shorta
	longi
	phb
	db0
	screen_off
	
	jsr	Initial_MissionMap_PPUreg
;--------------------------------------------------------------------
	jsr	VRAMClear

	jsr	Set_MMBG1CGX
	jsr	Set_MMBG1SCR

	jsr	Set_MMBG2CGX
	jsr	Set_MMBG2SCR

	jsr	Set_MMBG3CGX
	jsr	Set_MMBG3SCR

	jsr	Set_MMCOL

	plb
	rts

;=====================================================================
;*			Initial PPU Register			*
;=====================================================================
Initial_MissionMap_PPUreg
	shorta

	lda	#%00001001
	sta	bgmode		;BG mode1,bg3 pri

	lda	#(mm_bg1_scr>>8)&$fc!scrsizeyoko2 ;BG1 SCR screen yoko 2
	sta	bg1sc

	lda	#(mm_bg2_scr>>8)&$fc!scrsizeyoko2
	sta	bg2sc			;BG2 SCR screen 2
	sta	kw_bg2sc

	lda	#(mm_bg3_scr>>8)&$fc!scrsizeyoko2
	sta	bg3sc			;BG3 SCR ,screen 2

; set mario chip to point to the screen
	lda	vmap2+1
	and	#$0f0
	sta	kz_x1
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	ora	kz_x1
;;;	and	#$0f0
;;;	ora	#(mm_bg1_cgx_1>>12)&$0f
	sta	bg12nba			;BG1 (0000) ,BG2 (0000)
	sta	kw_bg12nba

	lda	#(mm_bg3_cgx>>12)&$0f	;BG3 (32*k/2)
	sta	bg34nba

	lda	#(mm_obj_cgx>>13)
	sta	objsel			;OBJ

	lda	#%00010111
	sta	tm	 		;BG1,BG2,BG3,OBJ display
	sta	kw_tm
	sta	kw_tmbackup
	lda	#%00000000
	sta	ts
	rts
;=====================================================================
;*			Initial BG1 Character Data		*
;=====================================================================
Set_MMBG1CGX
	decvramnotrans	0,mm_bg1_cgx_1,b7_ccr,($c0*32)
	decvramnotrans	0,mm_bg1_cgx_2,b7_ccr,($c0*32)
	rts
;=====================================================================
;*			Initial BG1 Screen Data			*
;=====================================================================
Set_MMBG1SCR
	decvramnotrans	0,mm_bg1_scr,b7_pcr,$800*2

;* Screen kakikae Buffer *
	a16
	ldx	#mm_bitmapbg1start
	ldy	#mm_scrbufbg1start
	km_setval	kz_x1,mm_scrbg1len/2
	jsr	kcopysceen_sub
	a8
	rts
;=====================================================================
;*			Initial BG2 Character Data		*
;=====================================================================
Set_MMBG2CGX
	rts
;=====================================================================
;*			Initial BG2 Screen Data			*
;=====================================================================
Set_MMBG2SCR
;	lda	kdifficulty
;	bne	.normal_hard
.easy
	decvramnotrans	0,mm_bg2_scr,b8_pcr,$800*2

;	bra	.skip
;.normal_hard
;	decvramnotrans	0,mm_bg2_scr,b11_pcr,$800*2
;.skip
	jsr	trans_planetscr


;----------------------------------------------------------------------
;* BG Check Buffer *
	phb
	db7f
	ldx	#0
	ldy	#0
.nxt_scr
;400h byte copy
	lda.l	bitmapdecbase,x
	sta.w	BGcheckBuffer,y
	inx
	inx
	iny
	cpx	#$800
	bne	.nxt_scr
	plb
;----------------------------------------------------------------------
;* Screen kakikae Buffer *
	a16
	ldx	#mm_bitmapbg2start
	ldy	#mm_scrbufbg2start
	km_setval	kz_x1,mm_scrbg2len/2
	jsr	kcopysceen_sub
	a8
	rts

;---------------------------------------------------------------------
;*		Screen Kakiake Buffer ni copy			*
;---------------------------------------------------------------------
kcopysceen_sub
	longa
	longi

	phb

	a8
	lda	#$7f
	pha
	plb
	a16
.loop
	lda.l	bitmapdecbase,x
	sta	mmxx_screenbuffer,y
	inx
	inx
	iny
	iny
	dec	kz_x1
	bne	.loop

	plb
	rts

;=====================================================================
;*			Initial BG3 Character Data		*
;=====================================================================
Set_MMBG3CGX
	decvramnotrans	0,mm_bg3_cgx,b9_ccr,($100*16)
	rts
;=====================================================================
;*			Initial BG3 Screen Data			*
;=====================================================================
Set_MMBG3SCR
	decvramnotrans	0,mm_bg3_scr,b10_pcr,$800*2
	rts
;=====================================================================
;*			Initial Color Data			*
;=====================================================================
Set_MMCOL

	decrunch_palettes
	dmacgram	0,0,b7_pac,$200
	dmaramram	0,kx_palette2,(b8_pac),256

	rts



;*********************************************************************
;*								*
;*		Planet Screen Data Transfer			*
;*								*
;*********************************************************************
;---------------------------------------------------------------------
kcx	= kz_X1	 ;planet CX zahyou
kcy	= kz_Y1	 ;planet CY zahyou
kwidthcnt	= kz_z1
kplanettype	= kz_X2	 ;planet colour type
kplanetNo	= kz_Y2	 ;Planet no jyunban
kscrbase	= kz_x3
kscraddr	= kz_y3
kchrbase	= kz_textpt
kchrorder	= kz_tpx
;---------------------------------------------------------------------
trans_planetscr
	php
	a16
	longi

	phb
	db7e
	ldy	kx_planetlistptr
.loop
	lda.w	mmx_scrcx,y
	km_loba
	sta	kcx
	lda.w	mmx_scrcy,y
	km_loba
	sta	kcy
	lda.w	mmx_planetcol,y
	sta	kplanettype

;* character Base Pointer *
	km_loblda.w	mmx_charabaseptr,y
	sta	kplanetNo
;-------------------------------------------------------------------------
	jsr	trans_planetscr_sub
;-------------------------------------------------------------------------
	lda.w	mmx_planetnext,y
	tay
	bne	.loop

	plb
	plp
	rts
;=====================================================================
;*								*
;*		Planet Screen Data Transfer	[SubRoutine]	*
;*								*
;=====================================================================
trans_planetscr_sub
	longa
	longi
	phx
	phy
	php
	phb
	db0
;* Screen Base Address Calc *
	km_substaval	kcx,2
	km_substaval	kcy,2
	a8
	km_setval	vmainc,%10000000
	a16
	km_convVRAMSCRaddr_32	kcx,kcy,mm_bg2_scr
	sta	kscrbase

;* charcter Base No Calc *
	km_lldx	kplanetNo
	lda.l	mm_planetbaseNOTbl,x
	ora	kplanettype
	sta	kchrbase

;* Screen Data Set *
	km_setval	kwidthcnt,4
.loop1
	ldy	#4
	ldx	kchrbase
	km_setvar	kscraddr,kscrbase
.loop2
	sta	vmaddl
	stx	vmdatal

	km_addstaval	kscraddr,$20
	inx
	dey
	bne	.loop2

	dec	kwidthcnt
	beq	.end

	inc	kscrbase
	km_addstaval	kchrbase,mm_bitmaphight
	bra	.loop1
.end
	plb
	plp
	ply
	plx
	rts

;*********************************************************************
;*								*
;*		Initial Mario Draw RAM				*
;*********************************************************************
Init_MarioDrawRAM
	shorta
	longi
	phb
	db0

;--- MARIO RAM Clear ----
	a16
	km_setval.l	m_x1,(bitmapbase+bitmap1)&WM
	km_setval.l	m_x2,mm_wbuflength	;data size :16chr(yoko)*20chr(tate)
	a8
	call_mario	MRAMClear

	a16
	km_setval.l	m_x1,(bitmapbase+bitmap1_dbl)&WM
	km_setval.l	m_x2,mm_wbuflength	;data size :16chr(yoko)*20chr(tate)
	a8
	call_mario	MRAMClear
	plb
	rts
;*****************************************************************************
;*									*
;*			MISSION MAP BG H,V Scroll			*
;*									*
;*****************************************************************************
;=============================================================================
;*			Initial H-DMA params				*
;=============================================================================
init_hdmaparams
	shorta
	longi
;=========================== BG1 H,V scroll ==================================
; set up the bg1hscroll hdma channel
	lda	#%01000011
	sta	ch2params	;(indirect mode)
	lda	#bg1hofs&BM
	sta	ch2addrb
	ldx	#xhdma_bg1hvscroll_mismap&WM
	stx	ch2addra1tl
	lda	#xhdma_bg1hvscroll_mismap>>16
	sta	ch2atbank
	sta	ch2databank
; set up the bg2hscroll hdma channel
	lda	#%01000010
	sta	ch3params	;(indirect mode)
	lda	#bg2hofs&BM
	sta	ch3addrb
	ldx	#xhdma_bg2hscroll_mismap&WM
	stx	ch3addra1tl
	lda	#xhdma_bg2hscroll_mismap>>16
	sta	ch3atbank
	sta	ch3databank
	km_orastaval	hdmaen_gc,%00001100
	RTS

;=============================================================================
;*			Initial H,V scroll params			*
;=============================================================================
init_mmhvscroll_l
	shorta
	longi

	a16
	lda	#0
	sta.l	kx_hscrollp1
	sta.l	kx_hscrollp2
	sta.l	kx_vscrollp1
	sta.l	kx_vscrollp2

	sta.l	xh_hscrolltbl1
	sta.l	xh_hscrolltbl2
	sta.l	xh_vscrolltbl1
	sta.l	xh_vscrolltbl2
	sta	kw_bg3hofs
	sta	kw_bg3vofs
	a8
	sta	bg1hofs
	sta	bg1hofs
	sta	bg1vofs
	sta	bg1vofs
	sta	bg2hofs
	sta	bg2hofs
	sta	bg2vofs
	sta	bg2vofs
	sta	bg3hofs
	sta	bg3hofs
	sta	bg3vofs
	sta	bg3vofs
	rtl
;*****************************************************************************
;*									*
;*									*
;*			DataTables			[ROM DATA]	*
;*									*
;*									*
;*****************************************************************************
;---------------------------------------------------------------------
;*								*
;*		Mario RAM Set Postion (X,Y)			*
;*								*
;* Mario RAM ni Set surutameno Planet Center Postion (CX,CY) Data	*
;* kono (CX,CY) kara Mario RAM no Address wo Calc suru		*
;---------------------------------------------------------------------
planetdata
	db	$10,$10
planetdataSZ
	km_datasize	planetdata

	db	$10,$30
	db	$10,$50
	db	$30,$10
	db	$30,$30
	db	$30,$50
	db	$50,$10

;=====================================================================
;*		Planet Base Character No Table			*
;=====================================================================
;* BG Screen Data no Top Character Number 
;* No 192~ Start ,Max 12ko no Planet ga kakeru
mm_planetbaseNOTbl
	dw	mm_planetbaseNO+(mm_bitmaphight*0)+0	;0
	dw	mm_planetbaseNO+(mm_bitmaphight*0)+4	;1
	dw	mm_planetbaseNO+(mm_bitmaphight*0)+8	;2
	dw	mm_planetbaseNO+(mm_bitmaphight*4)+0	;3
	dw	mm_planetbaseNO+(mm_bitmaphight*4)+4	;4
	dw	mm_planetbaseNO+(mm_bitmaphight*4)+8	;5
	dw	mm_planetbaseNO+(mm_bitmaphight*8)+0	;6
	dw	mm_planetbaseNO+(mm_bitmaphight*8)+4	;7
	dw	mm_planetbaseNO+(mm_bitmaphight*8)+8	;8
	dw	mm_planetbaseNO+(mm_bitmaphight*12)+0	;9
	dw	mm_planetbaseNO+(mm_bitmaphight*12)+4	;10
	dw	mm_planetbaseNO+(mm_bitmaphight*12)+8	;11

;---------------------------------------------------------------------
;*								*
;*								*
;*		Random Planet Pos & Stage Data Table		*
;*								*
;---------------------------------------------------------------------
;* Random Table Base Address *
randomtbl
;easy
	dw	rndpos_easy-randomtbl
	dw	rndstg_easy-randomtbl
;normal
	dw	rndpos_normal-randomtbl
	dw	rndstg_normal-randomtbl
;difficult
	dw	rndpos_hard-randomtbl
	dw	rndstg_hard-randomtbl
;---------------------------------------------------------------------
;*		Random Planet Postion Pointer Table	[EASY]	*
;---------------------------------------------------------------------
rndpos_easy
	db	0,1,3,4,6		;0
;	db	2,1,5,0,4		;0
	db	4,3,5,2,1		;1
	db	0,1,5,4,3		;2
	db	4,1,5,2,0		;3
	db	0,1,5,4,3		;4
	db	2,3,5,1,0		;5
	db	1,3,5,0,2		;6
	db	3,4,5,1,2		;7
;---------------------------------------------------------------------
;*		Random Planet Stage Table		[EASY]	*
;---------------------------------------------------------------------
rndstg_easy
	db	0,1,3,4	;0

;	db	0,1,3,4	;0
	db	0,3,4,1	;1
	db	1,4,3,0	;2
	db	1,0,4,3	;3
	db	3,1,0,4	;4
	db	3,4,0,1	;5
	db	4,0,3,1	;6
	db	4,0,1,3	;7
;---------------------------------------------------------------------
;*		Random Planet Postion Pointer Table 	[NORMAL]*
;---------------------------------------------------------------------
rndpos_normal
	db	0,1,2,3,6	;0
	db	5,4,3,2,6	;1
	db	0,2,4,1,6	;2
	db	3,4,5,2,6	;3
	db	1,5,2,4,6	;4
	db	2,1,0,5,6	;5
	db	4,2,1,5,6	;6
	db	5,0,2,4,6	;7

	ifeq	1
	db	0,1,2,3,4	;0
	db	0,2,4,1,3	;1
	db	4,3,0,5,1	;2
	db	1,3,0,5,2	;3
	db	2,4,3,1,0	;4
	db	3,5,0,2,1	;5
	db	4,1,5,2,3	;6
	db	5,2,1,0,4	;7
	endc
;---------------------------------------------------------------------
;*		Random Planet Stage Table		[NORMAL]*
;---------------------------------------------------------------------
rndstg_normal
	db	0,1,2,3	;0
	db	5,4,3,2	;1
	db	0,2,4,1	;2
	db	3,4,5,2	;3
	db	1,5,2,4	;4
	db	2,1,0,5	;5
	db	4,2,1,5	;6
	db	5,0,2,4	;7


	ifeq	1
	db	0,1,2,3	;0
	db	1,2,0,5	;1
	db	2,0,4,1	;2
	db	5,0,3,4	;3
	db	4,2,1,3	;4
	db	0,2,3,5	;5
	db	2,5,4,0	;6
	db	2,0,3,1	;7
	endc
;---------------------------------------------------------------------
;*		Random Planet Postion Pointer Table 	[HARD]	*
;---------------------------------------------------------------------
rndpos_hard
	db	0,1,2,3,4,5,6	;0

;	db	0,1,2,3,4,5,6	;0
	db	1,2,3,7,6,4,0	;1
	db	7,3,2,6,4,0,1	;2
	db	2,3,0,4,7,1,5	;3
	db	5,3,1,0,7,2,4	;4
	db	4,5,6,1,3,0,2	;5
	db	1,5,4,3,2,0,7	;6
	db	4,2,7,5,6,1,3	;7

;---------------------------------------------------------------------
;*		Random Planet Stage Table		[HARD]	*
;---------------------------------------------------------------------
rndstg_hard
	db	0,1,2,3,4,5	;0

;	db	0,1,2,3,4,5	;0
	db	5,4,3,2,1,0	;1
	db	0,2,4,1,3,5	;2
	db	0,5,2,4,1,3	;3
	db	3,2,1,5,4,0	;4
	db	2,4,0,5,1,3	;5
	db	5,4,2,0,3,1	;6
	db	3,4,0,2,1,5	;7

;=====================================================================
;*		Planet Postion Tables 				*
;=====================================================================
planetpostbl
	db	9,8		;0
planetpostblSZ
	db	4,19		;1
	db	26,8		;2
	db	28,16		;3
	db	18,11		;4
	db	25,24		;5
	db	10,25		;6
	db	$04,$19		;7
	km_datasize	planetpostbl

	ifeq	1
planetpostbl
	db	$1c,$08		;0
planetpostblSZ
	db	$11,$08		;1
	db	$1c,$0e		;2
	db	$17,$19		;3

	db	$09,$08		;4
	db	$04,$0f		;5
	db	$0f,$18		;6
	db	$04,$19		;7
	km_datasize	planetpostbl
	endc
;=====================================================================
;*		Planet Stage Tables 				*
;* Data :Radius,Mapping Pointer,Colour				*
;=====================================================================
planetstgtbl
	dw	$c,planet1_spr,bg_colpal3	;stg1:b
planetstgtblSZ
	dw	$c,planet2_spr,bg_colpal4	;stg2:b
	dw	$a,planet3_spr,bg_colpal5	;stg3:c
	dw	$a,planet4_spr,bg_colpal6	;stg4:d
	dw	$0,shadow_spr,bg_colpal0	;stg5:3
	dw	$8,planet6_spr,bg_colpal7	;stg6:e
	km_datasize	planetstgtbl

;--------------------------------
;*  Arwing Angle Pattern Data   *
;--------------------------------
mm_sprarwing
;obj No
	db	$20,$e,$c,$a
	db	$8,$6,$4,$2
	db	$0,$2,$4,$6
	db	$8,$a,$c,$e

	db	$42,$40,$2e,$2c
	db	$2a,$28,$26,$24
	db	$22,$24,$26,$28
	db	$2a,$2c,$2e,$40

	db	$64,$62,$60,$4e
	db	$4c,$4a,$48,$46
	db	$44,$46,$48,$4a
	db	$4c,$4e,$60,$62

mm_sprarwingEND
	km_datalen	mm_sprarwing



mim_blink
	a8
	kbug2
	blink	3

;*****************************************************************************
;*****************************************************************************
;*			Not Using Area					*
;*****************************************************************************
;*****************************************************************************
	IFEQ	1
;* Planet Perfect Clear Count *
	ldy	kx_currentplanetptr
	lda.w	mmx_completecnt,y
	dec	a
	sta.w	mmx_completecnt,y
	bne	.set_neutral
.planet_perfectclear
	km_setflag16.w	mmx_planetflag,mmpnf_complete,y
	lda	#step_Clear
	sta.w	mmx_planetskill,y
	lda	kx_clearplanetkazu
	inc	a
	sta	kx_clearplanetkazu
	cmp	kx_missionplanetkazu
	bne	.notclear
	km_setmismapflag	missionallclear
.notclear	
	brl	.end
	ENDC

