;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: mmessage.mc				*
;* 	Description	: map-screen bitmap message		*
;*	Date		: 1994.10.7				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;--------------------------------------------------------------
	include	mmessage.inc	; macro's
;--------------------------------------------------------------
;
;
;**************************************************************
;	test_work
;**************************************************************

m_firerotate	equ	m_yjtest+0
m_firehankei	equ	m_yjtest+2
m_fire_pX	equ	m_yjtest+4
m_fire_pY	equ	m_yjtest+6

;**************************************************************
;	LABELS
;**************************************************************

mapmessage_waittime	equ	10

;**************************************************************
;	LABELS
;**************************************************************
androf_messageY	equ	8*12

;---------------------------------------------------------------
; mapmessage parameter's
;---------------------------------------------------------------
mapmessage_wakuXcorner	equ	2
mapmessage_wakuXsize		equ	125
mapmessage_width		equ	127
mapmessage_initlength	equ	100 	; 100 moji !!
mapmessage_messagecolor	equ	0eh
mapmessage_Ycenter		equ	7dh
mapmessage_messageX		equ	mapmessage_wakuXcorner+4
;--------------------------------------------------------------





;**************************************************************
; 	Display Butmap Message
;**************************************************************
;**************************************************************
;	modecheck
;**************************************************************


mmapmessage_l
mmapmessage_entry

;--------------------------------------------------------------
	Mindexjmp	m_mappause_index
	Mjmplist	mode_mapmain		;(0)
	Mjmplist	mode_pauseopen_wait	;(1)
	Mjmplist	mode_pauseopen_scroll	;(2)
	Mjmplist	mode_pausemain_wait	;(3)
	Mjmplist	mode_pausemain		;(4)
	Mjmplist	mode_pauseclose_wait	;(5)
	Mjmplist	mode_pauseclose_scroll	;(6)
	Mjmplist	mode_pauseclose_fin	;(7)

;--------------------------------------------------------------


;**************************************************************
;	MAP message program
;**************************************************************

mode_mapmain

;------------------------------------------------
; message number check
;------------------------------------------------


	Mlda	m_mapmessageNo
	moves	r0,r0
	beq	.exit
	bmi	.exit
	nop

;------------------------------------------------
; display message
;------------------------------------------------

	Mjsr	DrawMapMessage	   ; r1 = messageNo * 2

	lm	r0,[m_messageend]  ; END ?
	moves	r0,r0
	beq	.exit_call
	nop

	Mstop

;------------------------------------------------
; messreset timer & 
;------------------------------------------------
.exit_call	Msta	m_mapmessageNo,0ffffh
	Mstop

;------------------------------------------------
; reset timer & 
;------------------------------------------------
.exit
	Mstz	m_mapmessageNo		; number
	Mstz	m_mapmessage_counter

	Mstop










;**************************************************************
;	Draw Message&Face(pepper)
;**************************************************************
;;
;; < input  > r1 = messageNo * 2
;;
;; < output > DISPLAY face
;;		 message
;;
;--------------------------------------------------------------


DrawMapMessage

	Msave_r11			; >>

;--------------------------------------------------------------
; line long calc !!
;--------------------------------------------------------------

	Mlda	m_mapmessageNo
	to	r1			; message number
	add	r0
	ibt	r2,#0			; index offset
	Mindex_message	messagetable

	iwt	r0,#normalfont
	sms	[m_font],r0
	iwt	r0,#mapmessage_width
	sms	[m_visualwidth],r0

	Mjsl	mStringHeight_l

	lms	r0,[m_y1]
	sm	[m_gamemessageheight],r0	
				; Y size
	lsr	a
	not
	inc	r0
	iwt	r3,#mapmessage_Ycenter
	add	r3
	sms	[m_y1],r0	

	iwt	r4,#mapmessage_wakuXcorner	
	iwt	r5,#mapmessage_wakuXsize

;--------------------------------------------------------------
; Line & Waku !!
;--------------------------------------------------------------

	Mjsr	mdrawbox

;--------------------------------------------------------------
; Message display
;--------------------------------------------------------------


	ibt	r0,#mapmessage_messageX
	sms	[m_x1],r0
	ibt	r0,#mapmessage_initlength
	sms	[m_z1],r0

	Mjsl	mprintWWstringN_l

;--------------------------------------------------------------
; Draw Face
;--------------------------------------------------------------

	Mlda	m_mapmessage_faceflag
	moves	r0,r0
	bne	.faceskip
	nop

	Mjsr	SetMouthdata	; mouth moving
	ibt	r1,#face_pepper
	MDrawFace_call	96,8	; positionX,Y

.faceskip
	Minc	m_mapmessage_counter

	Mendset_mapmessage	; limit time check !!


	Mload_r11

;--------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;**************************************************************
;		******************************************
; MODE  mappause	******************************************
;		******************************************
;**************************************************************

mode_pauseopen_scroll	;
mode_pauseclose_wait		;
mode_pauseclose_scroll	;
mode_pauseclose_fin

	Mstz	m_mapmessage_counter
	Msta	m_mapBG1scrollY,0	; scroll 0

mode_pauseopen_wait		;
	Mstop

;------------------------------------------------------
; pause main-mode
;------------------------------------------------------

mode_pausemain_wait		;
mode_pausemain		;(3)

;------------------------------------------------------
; draw face
;------------------------------------------------------

	Mlda	m_mapmessage_mode
	moves	r0,r0
	bne	.skip
	nop


	Mlda	m_playernumber		; face character
	to	r1
	adc	#face_fox
	ibt	r2,#0
	Mdrawface_call	96,8

	Mdrawface_entry	0,96,face_pepper,0

.skip

	Mjsr	SetMouthdata		; mouth moving
	ibt	r1,#face_androf
	Mdrawface_call	4*8,96

;------------------------------------------------------
; draw message
;------------------------------------------------------

	ibt	r1,#1*2
	ibt	r2,#0
	Mindex_message	sos_table
	Mparam_message	100,000eh,256,64+6,androf_messageY+7
	Mjsl	mprintWWstringN_l

;------------------------------------------------------
;; draw box
;------------------------------------------------------


	Msetcolor 0eh
	MlineX	64,androf_messageY,64-4
	MlineX	64,androf_messageY+8*3-1,64-4
	MlineY	64,androf_messageY,8*3
	MlineY	127-4,androf_messageY,8*3

;------------------------------------------------------

	Minc_max7fff	m_mapmessage_counter

;------------------------------------------------------

	rpix
	stop
	nop

;------------------------------------------------------
;	message datas
;------------------------------------------------------
sos_table
	dwcode	sos_work

sos_work
	db	1,1
	db	"GOGOGO!",0

	db	093h,0aeh,081h,08dh,20h,21h,21h,0 ;soreiike
	db	081h,097h,0a3h,083h,21h,0	;iitemaee















;=============================================================
;=============================================================
;=============================================================
;	LIBRARY PROGRAM					;
;	LIBRARY PROGRAM					;
;=============================================================
;=============================================================
;=============================================================
;=============================================================
;=============================================================
;=============================================================
;=============================================================
;**************************************************************
;	mouth ON/OFF 
;**************************************************************
; << input >> r1 player number
; 	 r2 mouth 
; 	 r3 xposition
;	 r4 yposition
;---------------------------------------------------------------

DrawFace
	sm	[m_facerts],r11		; return address
	sm	[m_x1],r3		; draw position X
	sm	[m_y1],r4		; draw position Y

	Maslreg	r1

	MsetROMaddr	face_anime
	with	r14
	add	r1			; face number
	with	r14
	add	r2			; animation offset
	getb	
	sm	[m_spra],r0		; character Number

	Mjsl	mDisplayFace_l

	lm	r15,[m_facerts]
	nop

;**************************************************************
;	mouth ON/OFF 
;**************************************************************
;--------------------------------------------------------------
; << input >>
;
; << ouput >> r2
;		0 ... mouth stop
;		1 ... mouth move
;--------------------------------------------------------------


SetMouthdata
	MsetROMaddr	mouth_data

	Mlda	m_mapmessage_counter
	iwt	r2,#8*4
	cmp	r2
	bcc	.skip1
	nop

	sub	r0		; r0 = 0

.skip1	with	r14
	add	r0	

	to	r2
	getb

	jmp	r11
	nop

;--------------------------------------------------------------


;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;**************************************************************
;	bitmap player-face message data
;**************************************************************

face_pepper	equ	0
face_androf	equ	1
face_fox	equ	2
face_falco	equ	3
face_peppy	equ	4
face_slippy	equ	5
face_pony	equ	6
face_girl	equ	7

;**************************************************************
;	bitmap player-face message data
;**************************************************************

face_anime	db	pepper1_spr,pepper2_spr	
	db	andross1_spr,andross2_spr
	db	fox1_spr,fox2_spr
	db	falco1_spr,falco2_spr
	db	peppy1_spr,peppy2_spr
	db	slippy1_spr,slippy2_spr
	db	pony1_spr,pony2_spr
	db	girl1_spr,girl2_spr
;--------------------------------------------------------------

;**************************************************************
;	mouth animation data
;**************************************************************
mouth_data	db	0,1,0,1,0,1,0,1
	db	0,0,0,1,0,1,0,0
	db	0,0,1,0,1,0,1,0
	db	0,0,1,0,1,0,1,0
;--------------------------------------------------------------
faceY	equ	148
faceX	equ	8*2
;
;
;
;
;
;
;
;
;********************************************************************
;		************************************************
; title test face 	************************************************
;		************************************************
;********************************************************************

testface

	Mdrawface_entry	faceX+8*4*0,100,face_pepper,0
	Mdrawface_entry	faceX+8*4*5,100,face_androf,0

	Mdrawface_entry	faceX+8*4*0,faceY,face_fox,0
	Mdrawface_entry	faceX+8*4*1,faceY,face_falco,0
	Mdrawface_entry	faceX+8*4*2,faceY,face_peppy,0
	Mdrawface_entry	faceX+8*4*3,faceY,face_slippy,0
	Mdrawface_entry	faceX+8*4*4,faceY,face_pony,0
	Mdrawface_entry	faceX+8*4*5,faceY,face_girl,0


	ifeq	1

	Msetcolor 1	
	Mboxfill 14*1,0,14,14
	Msetcolor 2
	Mboxfill 14*2,0,14,14
	Msetcolor 3	
	Mboxfill 14*3,0,14,14
	Msetcolor 4	
	Mboxfill 14*4,0,14,14
	Msetcolor 5	
	Mboxfill 14*5,0,14,14
	Msetcolor 6	
	Mboxfill 14*6,0,14,14
	Msetcolor 7	
	Mboxfill 14*7,0,14,14
	Msetcolor 8	
	Mboxfill 14*8,0,14,14
	Msetcolor 9	
	Mboxfill 14*9,0,14,14
	Msetcolor 10	
	Mboxfill 14*10,0,14,14
	Msetcolor 11	
	Mboxfill 14*11,0,14,14
	Msetcolor 12	
	Mboxfill 14*14,0,14,14
	Msetcolor 13	
	Mboxfill 14*13,0,14,14
	Msetcolor 14	
	Mboxfill 14*14,0,14,14
	Msetcolor 15	
	Mboxfill 14*15,0,14,14

	endc


	Mstop






;********************************************************************
;		************************************************
; gamemessage BOX	************************************************
;		************************************************
;********************************************************************

gamemessage_cornerX		equ	4ch-8
gamemessage_sizeX		equ	110


mprintboxmessage

;--------------------------------------------------------------------
; set Xposition 
;--------------------------------------------------------------------
	iwt	r4,#gamemessage_cornerX
	iwt	r5,#gamemessage_sizeX

;--------------------------------------------------------------------
; set color
;--------------------------------------------------------------------
	Mlda	m_gamemessagetype
	lob
	sub	#sound_down
	beq	.skip
	nop
	Msta	m_mapmessage_color,mapmessage_blackcolor
.skip
;--------------------------------------------------------------------
; set box
;--------------------------------------------------------------------
	Mjsr	mdrawbox

;--------------------------------------------------------------------
; set message
;--------------------------------------------------------------------

	ibt	r0,#100			; 
	sms	[m_z1],r0
	sm	[m_gyoulimit],r0	; Add Yajima !!
	Mjsl	mprintWWstringN_l

;--------------------------------------------------------------------
; exit
;--------------------------------------------------------------------

	Mstop






;********************************************************************
;		************************************************
; BOXmessage draw	************************************************
;		************************************************
;********************************************************************
;
;
; r0
; r1 plot
; r2 plot
; r3 Y lineloop counter
; r4   X-start point
; r5   X-size
;
;
;
; r7   waku color
; r8   Y-start point
; r9   Y-size
; r10  Y-end
; r11
; r12  loop
; r13  loop
; r14  ROM pointer
;
;--------------------------------------------------------------------
;
; gamemessagetype = 0 black
;	     = 1 red 
;
;
;
;--------------------------------------------------------------------

gamemessage_startoffsetY	equ	4
gamemessage_endoffsetY	equ	2

;--------------------------------------------------------------------
frash_table	db	1,2,3,4,3,2
;--------------------------------------------------------------------
; box color & waku color & moji color
;--------------------------------------------------------------------
mcolor_table	db	09h,0eh,0eh	; color_black
	db	05h,0eh,0eh	; color_blue
	db	01h,00h,0eh	; color_red
	db	01h,00h,0eh	; color_special

;;;;;	db	00h,0eh,09h	; color_special
;--------------------------------------------------------------------
;
;
;
;
;
;====================================================================

mdrawbox


;--------------------------------------------------------------------
; set frash color

	MsetROMaddr		frash_table
	Mcounter_limitinc	m_gamemessagecolor,6
	with	r14
	add	r0
	to	r3		; r3 = frash color
	getb

;--------------------------------------------------------------------

	MsetROMaddr		mcolor_table

	lm	r0,[m_mapmessage_color]
	mult	#3
	with	r14
	add	r0

;---------------------------------------------------------
				; r2 = BOX color
	getb
	inc	r14
	moves	r2,r0
	bne	.skip1
	nop
	move	r2,r3		; SET BOX FRASH

;---------------------------------------------------------
.skip1	getb
	inc	r14
	moves	r7,r0		; r7 = WAKU color
	bne	.skip2
	nop
	move	r7,r3		; SET WAKU FRASH !!!

;---------------------------------------------------------
.skip2				; r0 = MOJI color
	getb	
	sm	[m_textcolour],r0


;--------------------------------------------------------------------
; BOX FILL
;--------------------------------------------------------------------
;;	ibt	r0,#010b
	sub	r0
	cmode

	from	r2		; r2 = BOX color
	colour

;-------------------------------------
; calc Y ... (start)
;-------------------------------------
	lm	r8,[m_y1]	; (Ystart)
	with	r8
	sub	#gamemessage_startoffsetY
;-------------------------------------
; calc Y ... (size)
;-------------------------------------
	lm	r9,[m_gamemessageheight]	; Y=size
;-------------------------------------
; calc Y ... (end)
;-------------------------------------
	from	r8		; start
	add	r9		; size
	to	r10
	add	#gamemessage_startoffsetY+gamemessage_endoffsetY-1
;-------------------------------------
	with	r9
	add	#gamemessage_startoffsetY+gamemessage_endoffsetY
;-------------------------------------
	move	r2,r8
	move	r3,r9
;-------------------------------------
; draw box loop
;-------------------------------------

	mcache	
.loop	move	r12,r5
	move	r1,r4
	move	r13,r15
	loop
	plot
	dec	r3
	bne	.loop
	inc	r2

;--------------------------------------------------------------------
; LINE FILL
;--------------------------------------------------------------------

;;	sub	r0
;;	cmode

	from	r7
	colour

;-------------------------------------
; set line X1
;-------------------------------------
	move	r1,r4	; X start !!
	move	r2,r8	; Y start !!
	move	r12,r5  ; X size
	MlineXloop

;-------------------------------------
; set line X2
;-------------------------------------
	move	r1,r4	; Xstart !!
	move	r2,r10	; Yend
	move	r12,r5	; Xsize
	MlineXloop

;-------------------------------------
; set line Y1
;-------------------------------------
	move	r1,r4	; Xstart
	move	r2,r8	; Y start
	move	r12,r9	; Y size
	MlineYloop

;-------------------------------------
; set line Y2
;-------------------------------------
	to	r1
	from	r4	; Xstart+Xsize
	add	r5
	move	r2,r8	; Ystart
	move	r12,r9	; Ysize
	MlineYloop

;-------------------------------------
; set kado
;-------------------------------------

	Mset_kado	; Mset kado

;-------------------------------------
; exit
;-------------------------------------

	jmp	r11
	nop

;----------------------------------------------------------------






;********************************************************************
;	-----------------------
;	* BITMAP-DEMO-PROGRAM *
;	-----------------------
;********************************************************************



;********************************************************************
;;	color bar noize
;********************************************************************
;;--------------------------------------------
;; macro [addr,xstart,xloop,ystart,yloop]
;;--------------------------------------------
;;
;;
;;============================================

noize_test


;---------------------
; random counter INC
;---------------------
	lm	r0,[m_testcount]
	dec	r0
	sbk
	move	r8,r0		; r8 = random parameter

;---------------------
; random parameter
;---------------------

	Mjsr	Lrandom_parameter

;---------------------
; make video noize
;---------------------

	lm	r0,[m_videonoize_counter]
	moves	r0,r0
	beq	.skip
	add	r0
	ibt	r2,#038h
	with	r2
	add	r0

	iwt	r3,#2
	Mjsr	Lvideo_noize

.skip
;---------------------
; set counter
;---------------------

	lm	r0,[m_barnoize_counter]
	moves	r10,r0
	beq	.exit
	nop
	bmi	.manynoize
	nop

	mcache
;---------------------------------

.loop
	Mjsr	Lrandom_prog
	from	r8
	lob
	lsr
	inc	r0
	move	r12,r0		; X Counter


	Mjsr	Lrandom_prog
	from	r8
	lob
	lsr
	inc	r0
	move	r1,r0		; X position

	iwt	r3,#0d8h
	from	r1	; Xstart
	add	r12	; Xsize
	cmp	r3
	bcc	.drawentry
	nop

	from	r3	; max-start = size
	to	r12
	sub	r1

.drawentry
	Mjsr	Lrandom_prog
	from	r8
	lob
	lsr
	ibt	r3,#3ch
	add	r3
	inc	r0
	move	r2,r0		; Y position
	


	move	r13,r15		; RANDOM PLOT
	Mjsr	Lrandom_prog	
	from	r8
	and	#0fh
	colour
	loop
	plot

	dec	r10
	bne	.loop
	nop

.exit
	Mstop

;--------------------------------------------------------------------

.manynoize
	ibt	r2,#038h
	iwt	r3,#087h

	Mjsr	Lvideo_noize

	Mstop

;--------------------------------------------------------------------

;
;
;
;
;
;********************************************************************
;	-----------------------
;	* BITMAP-DEMO-LIBRARY *
;	-----------------------
;********************************************************************
;;
;;
;;
;;
;********************************************************************
; 	TV noize
;********************************************************************

Lvideo_noize
	move	r10,r11
	mcache
.loop
	ibt	r1,#0
	iwt	r12,#0deh
	move	r13,r15		; RANDOM PLOT
	Mjsr	Lrandom_prog	
	from	r8
	and	#01h
	add	#8		; 8/9
	colour
	loop
	plot
	dec	r3
	bne	.loop
	inc	r2

	jmp	r10
	nop


;********************************************************************
; 	make random
;********************************************************************
;
;	r0  ...	work
;
;	r4  ...	use parameter
;	r5  ...	use parameter
;	r6  ...	use parameter
;	r7  ...	use parameter
;	r8  ...	RANDOM
;	r9  ...	use parameter
;
;	r11 ... return address
;
;--------------------------------------------------------------------
;<< exsample >>
;
;	lm	r8,[random]		; load random
;	Mjsr	Lrandom_parameter
;	Mjsr	Lrandom_prog
;	sm	[random].r8		; save random
;
;--------------------------------------------------------------------

Lrandom_prog	

	from	r8
	cmp	r9
	bne	.entry
	nop
	with	r8
	sub	r8

.entry	move	r0,r8
	and	r4
	swap
	xor	r8
	swap
	moves	r8,r0

	swap
	and	r4
	add	r0
	xor	r8
	lsr
	bcc	.skip
	nop
	xor	r5
	xor	r6
	bra	.exit
	nop
;-------------------------------------------------------
.skip	xor	r5
	cmp	r7
	bne	.exit
	nop
	sub	r0
.exit	move	r8,r0
	
	jmp	r11
	nop

;-----------------------------------------------------------------

Lrandom_parameter

	iwt	r9,#0560ah	;
	iwt	r7,#0aa55h
	iwt	r6,#08180h
	iwt	r5,#0ff80h
	iwt	r4,#000ffh
	jmp	r11
	nop

;--------------------------------------------------------------------



;==============================================================
;==============================================================
; END END END END END END END END END END END END END END END
;==============================================================
;==============================================================


