;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: pausemap.asm				*
;* 	Description	: game pause process			*
;*	Date		: 1994.10.1				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;---------------------------------------------------------------------
	INCPUB  pausemap
;---------------------------------------------------------------------
;
;
;
;
;*********************************************************************
;	<< README >>
;*********************************************************************
;
; gamepause map display
;
; init_pausemap_l
; main_pausemap_l
;
;*********************************************************************
;	pause obj display labels
;*********************************************************************

XXoffset		equ	0bh	; pausemap offset Y
pauseobj_cX		equ	40h
pauseobj_cY		equ	20h
pauseobj_cYX		equ	pauseobj_cX+pauseobj_cY*256

;*********************************************************************
;	pause obj ZeroPage Memory
;*********************************************************************

pauseobj_pos		equ	Xwork0
Xposwork		equ	Xwork0+0
Yposwork		equ	Xwork0+1

pauseobj_attr	equ	Xwork1
pauseobj_char	equ	Xwork2
pauseobj_counter	equ	Xwork3
pauseobj_add		equ	Xwork4
pauseobj_temp	equ	Xwork5
pause_objpointer	equ	Xwork6
pauseobj_size	equ	Xwork7
pauseobj_flip	equ	Xwork8

;====================================================================
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
;		*************************************************
; PAUSEMAP		*************************************************
;		*************************************************	
;*********************************************************************

init_pausemap_l
	php
	ai16

	plp
	rtl

;---------------------------------------------------------------------

main_pausemap_l
	Mbank7e
	php
	sty	pause_objpointer 

	MBRK
	ai16

	ifne	AFpauselook
	Mkeycheck	cont0,button_X	
	bne	.exit
	endc

	km_bitcheckmissionflag finalboss
	bne	.exit


	inc	yj_framecounter

	jsr	disp_waku	; WAKU OBJECT
	jsr	disp_player	; player ARWING
	jsr	disp_burn	; planet burn animation
	jsr	disp_enemy	; SOS enemy
	jsr	disp_planet	; planet OBJ 
	jsr	disp_waku2	; WAKU OBJECT

.exit	ldy	pause_objpointer 

	MBRK
	plp
	Mbankrtl

;====================================================================
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
;	pause obj attribute & character
;*********************************************************************

poam	macro
	dw	\1+40h
	endm

;--------------------------------------------------------------------

poamV	macro
	dw	\1+40h+8000h
	endm

;--------------------------------------------------------------------

poamH	macro
	dw	\1+40h+4000h
	endm

;--------------------------------------------------------------------

poamHV	macro
	dw	\1+40h+0c000h
	endm

;*********************************************************************
;	pause obj set macros
;*********************************************************************

Mpauseobj_exit	macro
	db	idx_pauseobj_exit
	endm

;--------------------------------------------------------------------

Mpauseobj_pos	macro	[posH,posV]
	db	idx_pauseobj_posset
	db	{posH},{posV}
	endm

;--------------------------------------------------------------------
Mpauseobj_posadd	macro	[posH,posV]
	db	idx_pauseobj_posadd
	db	{posH},{posV}
	endm

;--------------------------------------------------------------------

Mpauseobj_programjmp	macro	[prog]
	db	idx_pauseobj_programjmp
	dw	{prog}&WM
	endm

;--------------------------------------------------------------------

Mpauseobj_attr	macro	[hv,pri,attr]
	db	idx_pauseobj_attrset
	db	oamdata_{pri}+oamdata_{attr}+oamdata_{hv}flip
	endm

;--------------------------------------------------------------------

Mpauseobj_Hsameloop	macro	[count,char]
	db	idx_pauseobj_Hsameloop
	db	{count}
	db	{char}
	endm

;--------------------------------------------------------------------

Mpauseobj_Vsameloop	macro	[count,char]
	db	idx_pauseobj_Vsameloop
	db	{count}
	db	{char}
	endm

;--------------------------------------------------------------------

Mpauseobj_nomalset	macro	[count]
	db	idx_pauseobj_nomalset
	db	{count}
	endm

;--------------------------------------------------------------------

Mpauseobj_Hdiffloop	macro	[count]
	db	idx_pauseobj_Hdiffloop
	db	{count}
	endm

;--------------------------------------------------------------------

Mpauseobj_Vdiffloop	macro	[count]
	db	idx_pauseobj_Vdiffloop
	db	{count}
	endm

;--------------------------------------------------------------------

Mpauseobj_sizebig	macro
	db	idx_pauseobj_sizebig
	endm

;--------------------------------------------------------------------

Mpauseobj_sizesmall	macro
	db	idx_pauseobj_sizesmall
	endm

;--------------------------------------------------------------------
;
;
;
;
;
;=====================================================================
;=====================================================================
;=========== DATAS ===================================================
;=========== DATAS ===================================================
;=====================================================================
;=====================================================================

;*********************************************************************
;	stop pause object
;*********************************************************************

;--------------------------------------------------------------------
pauseobj_process
	Mindexliststart
	Mindexlist	pauseobj_exit		; (0)
	Mindexlist	pauseobj_posset		; (1)
	Mindexlist	pauseobj_attrset	; (2)
	Mindexlist	pauseobj_Hsameloop	; (3)
	Mindexlist	pauseobj_Vsameloop	; (4)
	Mindexlist	pauseobj_nomalset	; (5)
	Mindexlist	pauseobj_Hdiffloop	; (6)
	Mindexlist	pauseobj_Vdiffloop	; (7)
	Mindexlist	pauseobj_sizebig	; (8)
	Mindexlist	pauseobj_sizesmall	; (9)
	Mindexlist	pauseobj_programjmp	; (10)
	Mindexlist	pauseobj_posadd		; (11)
;--------------------------------------------------------------------

;*********************************************************************
;	pause obj enemy character
;*********************************************************************

pause_enemydata
	dw	30f4h	; 0 - sos(1)
	dw	30f4h	; 1 - sos(2)
	dw	30f5h	; 2 - missile(1)
	dw	30f5h	; 3 - missile(2)
	dw	30e9h	; 4 - ship(1)
	dw	30e9h	; 5 - ship(2)
	dw	30eah	; 6 - stepup(1)  
	dw	30eah	; 7 - stepup(2)
	dw	30f4h	; 8 - guard(1)
	dw	30f4h	; 9 - guard(2)

;*********************************************************************
;	pause obj planet character number
;*********************************************************************

stage_planet	
	MoamCA	n,pri3,attr1,0eeh ;(0)  venom      (MIDOEI)
	MoamCA	n,pri3,attr0,0eeh ;(1)	taitania   (CYAIRO)
	MoamCA	n,pri3,attr3,0eeh ;(2)	macbeth	   (AKA)
	MoamCA	n,pri3,attr2,0ech ;(3)  eladard    (MURASAKI)
	MoamCA	n,pri3,attr2,0ech ;(4)  meteor	   (GURE-)
	MoamCA	n,pri3,attr2,0eeh ;(5)  fortona    (AO)
	MoamCA	n,pri3,attr2,0ech ;(6)	

corneria_planet
	MoamCA	n,pri3,attr2,0eeh ;(ff) corneria   (AO)




;*********************************************************************
;	pause obj planet character number
;*********************************************************************

yarare
	MoamCA	n,pri3,attr0,0e4h ; (p0)
	MoamCA	n,pri3,attr3,0e4h ; (p1)
	dw	0		  ; (p2)

;*********************************************************************
;	pause obj planet burn data
;*********************************************************************

pause_burndata
	dw	30e0h
	dw	30f0h
	dw	30f1h
	dw	0
	dw	30e0h
	dw	30f0h
	dw	30f1h
	dw	0

;*********************************************************************
;	waku obj data common
;*********************************************************************
;*********************************************************************
;	waku obj data common
;*********************************************************************

yarare_select
	lda	yj_framecounter
	and	#00110b
	sta	pauseobj_temp
	txa
	clc
	adc	pauseobj_temp
	tax
				; X = ROM index
	lda.l	this_bank+2,x	; index select
	tay			; y = nextpointer
	rts

;=====================================================================	
	
yarare_data
	Mpauseobj_sizesmall
	Mpauseobj_programjmp	yarare_select
	dw	yarare_1&WM,yarare_2&WM,yarare_3&WM,yarare_4&WM

yarare_1	Mpauseobj_Hdiffloop	2
	poam	30a4h	;(0)
	poam	30a5h	;(1)
	Mpauseobj_exit


yarare_2	Mpauseobj_posadd	00h,08h
	Mpauseobj_Hdiffloop	2
	poam	30a5h+0c000h
	poam	30a4h+0c000h
	Mpauseobj_exit


yarare_3	Mpauseobj_posadd	08h,00h
	Mpauseobj_Vdiffloop	2
	poam	30a4h+4000h
	poam	30a5h+8000h
	Mpauseobj_exit


yarare_4	Mpauseobj_Vdiffloop	2
	poam	30a5h+4000h
	poam	30a4h+8000h
	Mpauseobj_exit


;===================================================
; easy	
;===================================================

waku_data1
	Mpauseobj_sizesmall
	Mpauseobj_nomalset	7

	dw	4008h+pauseobj_cYX,30e1h+4000h
	dw	4010h+pauseobj_cYX,30e1h
	dw	4018h+pauseobj_cYX,30e2h
	dw	4818h+pauseobj_cYX,30f2h
	dw	4820h+pauseobj_cYX,30e3h
	dw	5020h+pauseobj_cYX,30f3h
	dw	5820h+pauseobj_cYX,30f3h+8000h
	Mpauseobj_exit

;===================================================
; nomal hard
;===================================================

waku_data2
	Mpauseobj_sizesmall
	Mpauseobj_nomalset	20-8

	dw	2040h+pauseobj_cYX-0300h+2800h,30e1h
	dw	2048h+pauseobj_cYX-0300h+2800h,30e2h
	dw	2848h+pauseobj_cYX-0300h+2800h,30f2h
	dw	2850h+pauseobj_cYX-0300h+2800h,30e3h
	dw	3050h+pauseobj_cYX-0300h+2800h,30f3h
	dw	3850h+pauseobj_cYX-0300h+2800h,30f3h+8000h
;;	dw	4050h+pauseobj_cYX-0300h+2800h,30e3h+8000h
;;	dw	4048h+pauseobj_cYX-0300h+2800h,30f2h+8000h
;;	dw	4848h+pauseobj_cYX-0300h+2800h,30e2h+8000h
;;	dw	4840h+pauseobj_cYX-0300h+2800h,30e1h+8000h

;;	dw	4838h+pauseobj_cYX-0300h+2800h,30e1h+0c000h
;;	dw	4830h+pauseobj_cYX-0300h+2800h,30e2h+0c000h
;;	dw	4030h+pauseobj_cYX-0300h+2800h,30f2h+0c000h
;;	dw	4028h+pauseobj_cYX-0300h+2800h,30e3h+0c000h
	dw	3828h+pauseobj_cYX-0300h+2800h,30f3h+0c000h
	dw	3028h+pauseobj_cYX-0300h+2800h,30f3h+4000h
	dw	2828h+pauseobj_cYX-0300h+2800h,30e3h+4000h
	dw	2830h+pauseobj_cYX-0300h+2800h,30f2h+4000h
	dw	2030h+pauseobj_cYX-0300h+2800h,30e2h+4000h
	dw	2038h+pauseobj_cYX-0300h+2800h,30e1h+4000h

	Mpauseobj_exit

;=====================================================================



waku_data

;; waku X1 -----------------------------------------------------------
	Mpauseobj_sizebig
	Mpauseobj_pos		pauseobj_cX,pauseobj_cY
	Mpauseobj_attr		n,pri3,attr0
	Mpauseobj_Hsameloop	1,0e6h
	Mpauseobj_Hsameloop	6,0e7h
	Mpauseobj_attr		h,pri3,attr0
	Mpauseobj_Hsameloop	1,0e6h
;; waku X2 -----------------------------------------------------------
	Mpauseobj_pos		pauseobj_cX,pauseobj_cY+58h
	Mpauseobj_attr		v,pri3,attr0
	Mpauseobj_Hsameloop	1,0e6h
	Mpauseobj_Hsameloop	6,0e7h
	Mpauseobj_attr		hv,pri3,attr0
	Mpauseobj_Hsameloop	1,0e6h

;; waku Y1,Y2 -----------------------------------------------------------

	Mpauseobj_sizesmall
	Mpauseobj_pos		pauseobj_cX,pauseobj_cY+10h
	Mpauseobj_attr		n,pri3,attr0
	Mpauseobj_Vsameloop	10,0f6h
	Mpauseobj_pos		pauseobj_cX+78h,pauseobj_cY+10h
	Mpauseobj_attr		n,pri3,attr0
	Mpauseobj_Vsameloop	10,0f6h

;------------------------------------------------------
	Mpauseobj_pos		pauseobj_cX+4,pauseobj_cY+070h
	Mpauseobj_Hdiffloop	15
	poam	306bh	;(0)
	poam	3020h	;(1)
	poam	3011h	;(2)
	poam	3018h	;(3)
	poam	306bh	;(4)
	poam	307ah	;(5)
	dw	0	;(6)
	poam	3011h	;(7)
	poam	3015h	;(8)
	dw	0	;(9)
	poam	307bh	;(10)
	poam	3012h	;(11)
	poam	306ah	;(12)
	dw	0	;(13)
	poam	303ch	;(14)
;------------------------------------------------------
	Mpauseobj_pos		pauseobj_cX+4,pauseobj_cY+078h
	Mpauseobj_Hdiffloop	15
	poam	306ch	;(0)
	poamV	3020h	;(1)
	poam	3021h	;(2)
	poamV	3015h	;(3)
	poam	306ch	;(4)
	poamV	3018h	;(5)
	dw	0	;(6)
	poam	3021h	;(7)
	poamV	3015h	;(8)
	dw	0	;(9)
	poamV	3018h	;(10)
	poam	3022h	;(11)
	poamV	3025h	;(12)
	dw	0	;(13)
	poam	303dh	;(14)
;------------------------------------------------------
	Mpauseobj_pos		pauseobj_cX+3ch,pauseobj_cY+084h
	Mpauseobj_Hdiffloop	3
	poam	347dh
	poam	3420h
	poam	3410h
	Mpauseobj_pos		pauseobj_cX+3ch,pauseobj_cY+08ch
	Mpauseobj_Hdiffloop	3
	poam	3421h
	poamV	3420h
	poamHV	3410h
	Mpauseobj_pos		pauseobj_cX+3ch,pauseobj_cY+094h
	Mpauseobj_Hdiffloop	2
	poam	347ah
	poam	3415h
	Mpauseobj_pos		pauseobj_cX+3ch,pauseobj_cY+09ch
	Mpauseobj_Hdiffloop	2
	poamV	3418h
	poamV	3415h

	Mpauseobj_exit




;=====================================================================
;=====================================================================
;=========== PROGRAMS ================================================
;=========== PROGRAMS ================================================
;=====================================================================
;=====================================================================
;*********************************************************************
;	program macros
;*********************************************************************

Mpmap_getpos	macro	[Xaddr,Xoffset,Yaddr,Yoffset]
	a8
	lda.w	{Yaddr},x
	lsr	a
	clc
	adc	#pauseobj_cY-({Yoffset})
	xba
	lda.w	{Xaddr},x
	lsr	a
	clc
	adc	#pauseobj_cX-({Xoffset})
	a16
	endm

;---------------------------------------------------------------------






;*********************************************************************
;	waku set (1)
;*********************************************************************
disp_waku

	ldx	#waku_data&xx
	jmp	pauseobj_entry

;*********************************************************************
;	waku set (2)
;*********************************************************************
disp_waku2

;;;;;;	ldx	#waku_data1&xx
;;;;;;	lda	Kdifficulty
;;;;;;	beq	.entry

	ldx	#waku_data2&xx	;; mode only
.entry	jmp	pauseobj_entry


;*********************************************************************
;	planet set
;*********************************************************************

disp_planet

;------------------------------------------------
; yarare animation
;------------------------------------------------

	Manimation_count pause_yarareanime,3*8

;------------------------------------------------
; planet display main loop
;------------------------------------------------
	ldx	kx_planetlistptr	; X= planet pointer
	beq	.exit
	ldy	pause_objpointer	; Y= object pointer
.loop

;------------------------------------------------
; position CALC
;------------------------------------------------

	Mpmap_getpos	mmx_planetcx,8,mmx_planetcy,8+XXoffset

;------------------------------------------------
; planet OBJECT display
;------------------------------------------------

	sta	sprites+0,y		; Set Position

;-----=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
	km_SetSpriteSizeDouble	  	; Set SUB
;-----=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

	phx				; >>

	cpx	kx_corneriaptr
	bne	.entry
	lda.l	corneria_planet
	bra	.setdata
.entry	lda.w	mmx_stage,x
	and	#07h
	asl	a
	tax
	lda.l	stage_planet,x
.setdata	sta	sprites+2,y		; Set Character

	plx				; <<

	iny
	iny
	iny	
	iny

	lda.w	mmx_planetnext,x
	tax
	bne	.loop

	sty	pause_objpointer
.exit
	rts



;*********************************************************************
;	enemy set
;*********************************************************************

disp_enemy

	inc	pause_enemyanime

	ldx	kx_enlistptr
	beq	.exit

	ldy	pause_objpointer
.loop

	Mpmap_getpos	mmx_enposx+1,4,mmx_enposy+1,4+XXoffset
	sta	sprites+0,y
	phx			; >>

	stz	pauseobj_flip	; flip off
	lda.w	mmx_enangY,x
	bpl	.skip
	lda	#4000h		; enemy flip
	sta	pauseobj_flip
.skip	
	lda.w	mmx_entype,x	; character select
	and	#00ffh
	asl	a
	tax

	lda.l	pause_enemydata,x
	ora	pauseobj_flip	; H-flip SOS object
	sta	sprites+2,y
	plx			; <<

	iny	
	iny
	iny	
	iny

	lda.w	mmx_ennext,x
	tax
	bne	.loop

	sty	pause_objpointer

.exit
	rts


;*********************************************************************
;	player set
;*********************************************************************


disp_player
	ldy	pause_objpointer
	sty	sprite_register
	ldx	#0
	Mpmap_getpos	mmx_arwingposx+1,0,mmx_arwingposy+1,XXoffset

	phb
	phk
	plb
	pha

	lda.l	pause_playeranime
	inc	a
	cmp	#0ch*3
	bcc	.skip
	lda	#0
.skip	sta.l	pause_playeranime
	Mdiv_u16u8	3
	asl	a
	tax
	ldy	.objchar&WM,x
	pla
	jsr	common_oamset
	plb
	ldy	sprite_register
	sty	pause_objpointer

	rts


.objchar	
	dw	obj_w0_2_0&WM
	dw	obj_w0_2_1&WM
	dw	obj_w0_2_2&WM
	dw	obj_w0_2_3&WM
	dw	obj_w0_2_4&WM
	dw	obj_w0_2_5&WM
	dw	obj_w0_2_6&WM
	dw	obj_w0_2_7&WM
	dw	obj_w0_2_8&WM
	dw	obj_w0_2_9&WM
	dw	obj_w0_2_10&WM
	dw	obj_w0_2_11&WM







;***********************************************************************
;	CORNERIA CRASH PROGRAM
;***********************************************************************

attack_check
	stz	pauseobj_temp		; clear flag
	phx			;>>
	ldx	kx_enlistptr
	beq	.exit

.loop	lda.w	mmx_enflags,x
	and	#enfl_attackcorneria
	ora	pauseobj_temp
	sta	pauseobj_temp

	lda.w	mmx_ennext,x
	tax
	bne	.loop

.exit	plx			; <<
	lda	pauseobj_temp		; set flag
	rts

;*********************************************************************
;	planet burn
;*********************************************************************

Mburnobj	macro
	lda	Xposwork
	adc	#\1	
	sta	Xposwork
	lda.l	pause_burndata,x
	beq	.\@p1
	sta	sprites+2,y
	lda	Xposwork
	sta	sprites+0,y	; position
	iny	
	iny
	iny
	iny
.\@p1
	inx
	inx
	endm

;--------------------------------------------------------------------

disp_burn
	inc	pause_planetanime

	ldx	kx_planetlistptr
	bne	.entry
	rts
;-----------------------------------------------

.entry
	ldy	pause_objpointer

.loop

;-----------------------------------------------
; CALC position
;-----------------------------------------------

	Mpmap_getpos	mmx_planetcx,8,mmx_planetcy,8+XXoffset
	sta	Xposwork

;------------------------------------------------
; yarare OBJECT display
;------------------------------------------------

	lda.w	mmx_planetflag,x
	bit	#mmpnf_neutral+mmpnf_complete+mmpnf_corneria
	bne	.skip21

	phx			 ; >>
	sty	pause_objpointer
	ldx	#yarare_data&WM
	jsr	pauseobj_entry
	ldy	pause_objpointer
	plx			 ; <<

.skip21

;-----------------------------------------------
; burn objct check
;-----------------------------------------------
	lda.w	mmx_planetflag,x
	bit	#mmpnf_corneria
	beq	.skip10
;-----------------------------------------------
	jsr	attack_check		; corneria attack ??
	beq	.skip10

;-----------------------------------------------
; burn objct 3 character set
;-----------------------------------------------
	phx			; >>
	lda	pause_planetanime
	and	#000011000b
	lsr	a
	lsr	a
	tax
	clc
	Mburnobj	00200h
	Mburnobj	00707h
	Mburnobj	0f802h
	plx

;-----------------------------------------------
; next
;-----------------------------------------------

.skip10
	lda.w	mmx_planetnext,x
	tax
	beq	.exit
	jmp	.loop

;-----------------------------------------------
; exit
;-----------------------------------------------
.exit
	sty	pause_objpointer

	rts

;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
























;=====================================================================
;=====================================================================
;=========== LIBRARY =================================================
;=========== LIBRARY =================================================
;=====================================================================
;=====================================================================
;*********************************************************************
;	objset library
;*********************************************************************

;--------------------------------------------------------------------

pauseobj_sizebig
	lda	#0ffffh
	sta	pauseobj_size
	rts

pauseobj_sizesmall
	stz	pauseobj_size
	rts

;--------------------------------------------------------------------

pauseobj_programjmp
	tyx
	jmp	(0,x)

;--------------------------------------------------------------------

pauseobj_exit	
	pla
	rts

;--------------------------------------------------------------------

pauseobj_posset
	tyx
	lda.l	this_bank,x
	sta	pauseobj_pos
	inx
	inx
	txy
	rts

;--------------------------------------------------------------------
pauseobj_posadd
	tyx
	lda.l	this_bank,x
	clc
	adc	pauseobj_pos
	sta	pauseobj_pos
	inx
	inx
	txy
	rts

;--------------------------------------------------------------------

pauseobj_attrset
	tyx
	lda.l	this_bank,x
	xba
	and	#0ff00h
	sta	pauseobj_attr
	inx
	txy
	rts

;--------------------------------------------------------------------

pauseobj_Vsameloop
	lda	#0800h
	bra	pauseobj_sameloop
pauseobj_Hsameloop
	lda	#0008h
pauseobj_sameloop
	bit	pauseobj_size
	beq	.set
	asl	a
.set	sta	pauseobj_add

		
	tyx
	phy			; >>

	lda.l	this_bank+1,x	; Character No
	and	#00ffh
	ora	pauseobj_attr	; Attribute
	sta	pauseobj_char

	lda.l	this_bank+0,x	; Counter
	and	#00ffh
	tax


	ldy	pause_objpointer	;   --->

.loop
	lda	pauseobj_pos
	sta	sprites+0,y	; position
	clc
	adc	pauseobj_add
	sta	pauseobj_pos

	lda	pauseobj_char
	sta	sprites+2,y	; character

	jsr	pauseobj_subset	; y = objpointer

	iny
	iny
	iny
	iny

	dex
	bne	.loop

	sty	pause_objpointer	;   <---

	ply			; <<
	iny
	iny
	rts

;--------------------------------------------------------------------

pauseobj_nomalset

	tyx
	lda.l	this_bank+0,x
	and	#00ffh
	sta	pauseobj_counter
	inx

	ldy	pause_objpointer

.loop	lda.l	this_bank+0,x
	sta	sprites+0,y	; position
	lda.l	this_bank+2,x
	sta	sprites+2,y	; character
	inx
	inx
	inx
	inx
	iny
	iny
	iny
	iny
	dec	pauseobj_counter
	bne	.loop	

	sty	pause_objpointer
	txy
	rts

;--------------------------------------------------------------------


pauseobj_Vdiffloop
	lda	#0800h
	bra	pauseobj_diffloop
pauseobj_Hdiffloop
	lda	#0008h
pauseobj_diffloop
	sta	pauseobj_add
		
	tyx

	lda.l	this_bank+0,x	; Counter
	and	#00ffh
	sta	pauseobj_counter
	inx

	ldy	pause_objpointer	;   --->
	clc
.loop
	lda	pauseobj_pos
	sta	sprites+0,y	; position
	adc	pauseobj_add
	sta	pauseobj_pos

	lda.l	this_bank,x
	beq	.next
	sta	sprites+2,y	; character

	iny	
	iny
	iny
	iny

.next	inx
	inx
	dec	pauseobj_counter
	bne	.loop

	sty	pause_objpointer	;   <---

	txy
	rts

;*********************************************************************
;	size calc
;*********************************************************************

pauseobj_subset

	lda	pauseobj_size
	beq	.exit

	phx		; >>
	phy		;   >>

	tya
	cmp	#220h
	bcs	.entry2

;----------------------------------------------
.entry1					; DOUBLEBUFFER (1)
	lsr	a
	tax
	lsr	a
	lsr	a
	lsr	a
	tay				; oam sub pointer
	txa
	and	#0110b
	tax

	lda	sprites+200h,y
	ora.l	objsub_size,x
	sta	sprites+200h,y

	ply		;   <<
	plx		; <<

.exit	rts

;----------------------------------------------
.entry2	sbc	#220h	; SEC		; DOUBLEBUFFER (2)
	lsr	a
	tax
	lsr	a
	lsr	a
	lsr	a
	tay				; oam sub pointer
	txa
	and	#0110b
	tax

	lda	sprites+420h,y
	ora.l	objsub_size,x
	sta	sprites+420h,y

	ply		;   <<
	plx		; <<

	rts

;---------------------------------------------------------------------

objsub_size	dw	000000010b
	dw	000001000b
	dw	000100000b
	dw	010000000b


;*********************************************************************
;	pause obj set mainloop
;*********************************************************************

pauseobj_entry

.loop	lda.l	this_bank,x		; X=ROM pointer
	and	#00ffh
	asl	a
	inx
	txy				; Y=ROM pointer
	tax
	jsr	(pauseobj_process,x)
	tyx				; Y=ROM pointer
	bra	.loop

;--------------------------------------------------------------------
;--------------------------------------------------------------------








;=====================================================================
;=====================================================================
; END END END END END END END END END END END END END END END END END
;=====================================================================
;=====================================================================
