AF_namedispOFF = 0	; 1 ... plane name GA nagarete deru
		;       nowo yameru !!!
;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: pselect2.asm				*
;* 	Description	: Battle player select			*
;*	Date		: 1994.11.11				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  pselect
;---------------------------------------------------------------------
;
;*******************************************************************
;	battle player select
;*******************************************************************

bpsel_p1		equ	gameobjstruct+0
bpsel_p2		equ	gameobjstruct+10

;---------------------------------------------------------------------

_bpselprocess	equ	0
_bpselcounter	equ	2
_bpselnumber		equ	4
_bpselplayerNo	equ	6
_bpselflag		equ	8


config_keytype	equ	01h	; keytype flag
on_gogo		equ	02h	; gogo display
leftkey_exit		equ	04h
rightkey_exit	equ	08h
bpsel_cursorsound	equ	10h
		
;---------------------------------------------------------------------
p1_player		equ	bpsel_p1+_bpselplayerNo
p2_player		equ	bpsel_p2+_bpselplayerNo
;---------------------------------------------------------------------


;*******************************************************************
;	battle player select macro
;*******************************************************************
Mbpsel_gogo_set	macro
	lda	_bpselflag,x
	ora	#on_gogo
	sta	_bpselflag,x
	endm

;-------------------------------------------------------------------
Mbpsel_gogo_clear	macro
	lda	_bpselflag,x
	and	#on_gogo^0ffffh
	sta	_bpselflag,x
	endm

;-------------------------------------------------------------------
Mbpsel_leftkeyexit	macro
	lda	_bpselflag,x
	ora	#leftkey_exit
	sta	_bpselflag,x
	endm

;-------------------------------------------------------------------
Mbpsel_rightkeyexit	macro
	lda	_bpselflag,x
	ora	#rightkey_exit
	sta	_bpselflag,x
	endm

;-------------------------------------------------------------------
Mbpsel_keyclear	macro
	lda	_bpselflag,x
	and	#(leftkey_exit+rightkey_exit)^0ffffh
	sta	_bpselflag,x
	endm

;-------------------------------------------------------------------
Mbpsel_cursorsoundON	macro
	lda	_bpselflag,x
	ora	#bpsel_cursorsound
	sta	_bpselflag,x
	endm
;-------------------------------------------------------------------
Mbpsel_cursorsoundOFF macro
	ldx	register
	lda	_bpselflag,x
	bit	#bpsel_cursorsound
	beq	.s\@

	lda	_bpselplayerNo,x
	cmp	#6
	beq	.soundskip\@

	ksound	cursor

.soundskip\@
	lda	_bpselflag,x
	and	#bpsel_cursorsound^-1
	sta	_bpselflag,x
.s\@
	endm
;-------------------------------------------------------------------
	



;*******************************************************************
;	player select 2p
;*******************************************************************

pselmain_2p


	jsr	.sos


	lda	bpsel_p1+_bpselplayerNo
	cmp	#6
	bcs	.skip1
	sta	player_owner
.skip1
	lda	bpsel_p2+_bpselplayerNo
	cmp	#6
	bcs	.skip2
	sta	player_friend
.skip2	rts

;===========================================================

.sos 	

	ldx	#pselstruct
	stx	dcregister	; input register
	jsr	dc_select
	Mindexliststart
	Mindexlist	pselbatt_exit	; 0
	Mindexlist	pselbatt_start	; 1
	Mindexlist	pselbatt_close	; 2

;*******************************************************************
;
;*******************************************************************
;	pselect.asm
;	screenaddress
;	workd address
;	work screen address
;	pselect.asm
;	pselec_start address
;	pselect_battleaddress
;	pselect.asm
;	edit .cshrc
;	wipe battle address
;	pselbatt_close
;	closeaddress
;
;*******************************************************************
;	close demo
;*******************************************************************
pselect_close
	jsr	pselect_exitobj
	bra	pselclose_common
pselbatt_close
	jsr	bpsel_exitobj

pselclose_common
	jsr	dc_program

	dwnext	bpselclose_0
	dwloop	50,bpselclose_startwait
	dwnext	bpselclose_1
	dwloop	tmpsel_okwait,bpselclose_2

	dwnext	bpselclose_3
	dwloop	16,bpselclose_4

	dwnext	bpselclose_5
	dwloop	30,bpselclose_6
	dwnext	bpselclose_7
	dwstop	bpselclose_8
	

;-------------------------------------------------------------------
bpselclose_0

bpselclose_startwait
bpselclose_2
	jsr	Disp_BATTLEkeytypeobj
bpselclose_4
	jsr	Main_OBJ
	rts
;-------------------------------------------------------------------
bpselclose_1
	jsr	Disp_BATTLEkeytypeobj

	Mobjchange 0,ys_foxOKpose,face_oamset_p1X
	Mobjchange 2,ys_foxOKpose,face_oamset_p2X
;-------------------------------------------
	Mobjindex	0		; player(1)
	ldy	player_owner
	lda	pseldataOK&xx,y
	and	#00ffh
	sta	_anime_trigger,x
;-------------------------------------------
	Mobjindex	2		; player(2)
	ldy	player_friend
	lda	pseldataOK&xx,y
	and	#00ffh
	sta	_anime_trigger,x
;-------------------------------------------
	jsr	Main_OBJ
	rts
;-------------------------------------------------------------------

bpselclose_3
	ldy	#amiclear&xx	; ami P1 clear
	jsr	psel_bgdraw
	ldy	#amiclear&xx	; ami P2 clear
	jsr	psel_bgdrawP2
	ldy	#name_clear&xx	; name clear
	jsr	psel_bgdraw
	ldy	#name_clear&xx	; name clear
	jsr	psel_bgdrawP2

	jsr	Init_objlist
	Mobjinit 0,ys_faceclose,oamsetnew,30h,37h
	Mobjinit 1,ys_planeclose,oamsetnew,0c0h,37h
	Mobjinit 2,ys_faceclose,oamsetnew,30h,37h+80h
	Mobjinit 3,ys_planeclose,oamsetnew,0c0h,37h+80h

	jsr	Main_OBJ
	rts
;--------------------------------------------------------------------
bpselclose_5



	jsr	Init_objlist
	Mobjmoveinit 0,ys_planefire,movefire1,0100h+8*5,37h,p1_initspeed,0
	Mobjmoveinit 1,ys_foxplane,movefire1,0100h,37h,p1_initspeed,0


	Mobjindex	1	
	ldy	player_owner
	lda	pseldata2&xx,y
	and	#00ffh
	sta	_anime_trigger,x

	Mobjindex	0
	ldy	player_owner
	lda	pfoffset&xx,y
	and	#00ffh
	clc
	adc	_axisX,x
	sta	_axisX,x
	lda	#0000h		; plane fire
	sta	_charadd,x

;--------------------------------------------------------------------
bpselclose_8
bpselclose_6
	jsr	psel_scrollset
	jsr	Main_OBJ
	rts

;-------------------------------------------------------------------
bpselclose_7
	Mobjmoveinit 2,ys_planefire,movefire2,0100h+8*5,37h+80h,p2_initspeed,0
	Mobjmoveinit 3,ys_foxplane,movefire2,0100h,37h+80h,p2_initspeed,0

	Mobjindex	3	
	ldy	player_friend
	lda	pseldata2&xx,y
	and	#00ffh
	sta	_anime_trigger,x

	Mobjindex	2
	ldy	player_friend
	lda	pfoffset&xx,y
	and	#00ffh
	clc
	adc	_axisX,x
	sta	_axisX,x
	stz	_charadd,x
	
	bra	bpselclose_6

;-------------------------------------------------------------------
;-------------------------------------------------------------------
;-------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;*******************************************************************
;	player select exit
;*******************************************************************
pselbatt_exit
	rts

;*******************************************************************
;	player select OPENNING DEMO
;*******************************************************************

Inc_bpsel
	ldx	register
	lda	_bpselplayerNo,x
	inc	a
	cmp	#6
	bcc	.exit
	ldy	#idx_bpsel_configentry	
	sty	_bpselprocess,x
.exit	sta	_bpselplayerNo,x
	rts

Dec_bpsel
	ldx	register
	lda	_bpselplayerNo,x
	dec	a
	bpl	.exit
	ldy	#idx_bpsel_configentry	
	sty	_bpselprocess,x
	lda	#6
.exit	sta	_bpselplayerNo,x
	rts


;-------------------------------------------------------------------
pselbatt_start
	jsr	dc_program
	dwstart
	dwwait	25
	dwnext	pselbatt_open0
	dwloop	13,pselbatt_open1
	dwnext	pselbatt_open2
	dwnext	pselbatt_open3
	dwloop	4,pselbatt_open4
	dwnext	pselbatt_open5	 
	dwstop	pselbatt_open6	 

;-------------------------------------------------------------------
pselbatt_open0

	jsr	bpsel_initial


	jsr	Init_objlist
	Mobjinit 0,ys_faceopen,oamsetnew,30h,37h
	Mobjinit 1,ys_planeopen,oamsetnew,0c0h,030h
	Mobjinit 2,ys_faceopen,oamsetnew,30h,37h+80h
	Mobjinit 3,ys_planeopen,oamsetnew,0c0h,030h+80h
	Mobjinit 4,ys_pselstart,oamsetpselstartp1,058h,0e0h
	Mobjinit 5,ys_pselstart,oamsetpselstartp2,058h,0e0h
	rts

;-------------------------------------------------------------------
pselbatt_open1
	jmp	pselsetobj

;-------------------------------------------------------------------
pselbatt_open2

	Mset	wipestruct,idx_wipeconfig
	Mset	objdraw,idx_drawBGscreen1
	ldy	#amiset&WM			; ami set !!
	jsr	psel_bgdraw			; AMI SET
	ldy	#amiset&WM
	jsr	psel_bgdrawP2
	jmp	pselsetobj

;-------------------------------------------------------------------
pselbatt_open3
	Mobjchange 0,ys_foxSTpose,face_oamset_p1
	Mobjchange 1,ys_foxplane,plane_oamset_p1
	Mobjchange 2,ys_foxSTpose,face_oamset_p2
	Mobjchange 3,ys_foxplane,plane_oamset_p2
	jmp	pselsetobj

;-------------------------------------------------------------------
pselbatt_open5
pselbatt_open4
	jmp	pselsetobj
;-------------------------------------------------------------------
pselbatt_open6


	ldy	#0		; index
	ldx	#bpsel_p1
	jsr	pselbatt_select
;-------------------------------------------------------------------

	lda	p1_player
	cmp	#6
	beq	.p2entry
	cmp	p2_player
	bne	.p2entry

	lda	trig0
	and	#button_left
	bne	.left
	jsr	Inc_bpsel
	bra	.p2entry
.left	
	jsr	Dec_bpsel

;-------------------------------------------------------------------
.p2entry	jsr	Xcursor_set
	Mbpsel_cursorsoundOFF



	ldy	#2		; index
	ldx	#bpsel_p2
	jsr	pselbatt_select

;-------------------------------------------------------------------

	lda	p2_player
	cmp	#6
	beq	.pxentry
	cmp	p1_player
	bne	.pxentry

	lda	trig1
	and	#button_left
	bne	.2left
	jsr	Inc_bpsel
	bra	.pxentry
.2left
	jsr	Dec_bpsel

;-------------------------------------------------------------------
.pxentry
	jsr	Xcursor_set
	Mbpsel_cursorsoundOFF

;-------------------------------------------------------------------
.exit
	jsr	Disp_BATTLEkeytypeobj

	jmp	pselsetobj	; OAM set !!





;;
;;
;;
;*******************************************************************
;	----------------------
;	 2Pmode player select
;	----------------------
;*******************************************************************
Mbpsel_setnumberY	macro
	ldx	register
	ldy	_bpselnumber,x
	endm

;--------------------------------------------------------------------
Mbpsel_setprocess	macro	[process]
	lda	#idx_{process}
	sta	_bpselprocess,x
	endm

;--------------------------------------------------------------------
Mbpsel_keycheck	macro	[key]
	lda.w	trig0,y
	and	#button_{key}
	endm

;--------------------------------------------------------------------
Mbpsel_keycheck2	macro	[key,key2]
	lda.w	trig0,y
	and	#button_{key}+button_{key2}
	endm

;*******************************************************************
;	exit obj cursor set 
;*******************************************************************

bpsel_exitobj
	ldy	#0		; index
	ldx	#bpsel_p1
	jsr	.entry
	ldy	#2		; index
	ldx	#bpsel_p2
.entry
	sty	bpsel_index		; DataJUMP pointer
	stx	register		; WorkRAM pointer
	jsr	Xcursor_set
	rts

;*******************************************************************
;	2pmode select main
;*******************************************************************
pselbatt_select
	sty	bpsel_index		; DataJUMP pointer
	stx	register		; WorkRAM pointer
	lda	_bpselprocess,x
	asl	a
	txy
	tax
	jmp	(.process,x)
;-------------------------------------
.process
	Mindexliststart
	Mindexlist	bpsel_select
	Mindexlist	bpsel_configentry
	Mindexlist	bpsel_configopen
	Mindexlist	bpsel_configselect
	Mindexlist	bpsel_configclose
	Mindexlist	bpsel_okwait
	Mindexlist	bpsel_okend

;--------------------------------------------------------------------
;	config open demo entry
;--------------------------------------------------------------------
bpsel_configentry
	ldx	register
	stz	_bpselcounter,x
	Mbpsel_setprocess	bpsel_configopen
	rts
	
;--------------------------------------------------------------------
;	config open demo
;--------------------------------------------------------------------
bpsel_configopen

	tyx
	lda	_bpselcounter,x
	beq	.entry
	inc	_bpselcounter,x
	cmp	#30
	bcc	.exit

	Mbpsel_setprocess	bpsel_configselect

.exit	
	jsr	disp_finger

	rts

;----------------------------------------------------
.entry
	MsetBL	kw_tm,17h

	inc	_bpselcounter,x
	jsr	clear_name_gogo

	ksound	openwindow

	rts

;====================================================


;--------------------------------------------------------------------
;	config select
;--------------------------------------------------------------------
bpsel_configselect

	jsr	select_finger
	jsr	disp_finger

	Mbpsel_setnumberY

	lda.w	trig0,y
	and	#button_left+button_right
	beq	.exit

	ldx	register		; WorkRAM pointer
	and	#button_left
	beq	.skip1
	lda	#5
	sta	_bpselplayerNo,x
	bra	.skip2
.skip1
	lda	#0
	sta	_bpselplayerNo,x
.skip2

	Mbpsel_setprocess	bpsel_configclose
	ksound	closewindow

.exit	rts

;--------------------------------------------------------------------
;	config closedemo
;--------------------------------------------------------------------
bpsel_configclose
	tyx
	dec	_bpselcounter,x
	bne	.exit

;--------------------------------------------
; endof onfig close
;--------------------------------------------

	ifeq	1

	ldy	#0
 	lda	_bpselflag,x
	and	#leftkey_exit
	beq	.entry
	ldy	#5
.entry	tya
	sta	_bpselplayerNo,x
	Mbpsel_keyclear

	endc

;--------------------------------------------
	Mbpsel_setprocess	bpsel_select
	stz	_bpselcounter,x

.exit	
	jsr	disp_finger
	rts

;--------------------------------------------------------------------
;	ok wait
;--------------------------------------------------------------------
bpsel_okwait
	jsr	cursor_okset

	ldx	register
	jsr	set_name_gogo

	Mbpsel_setnumberY
	Mbpsel_keycheck cancel
	beq	.skip
	ksound	cancel
	Mbpsel_setprocess	bpsel_select
	stz	_bpselcounter,x
.skip
	Mbpsel_keycheck	ok
	beq	.exit
	lda	#idx_bpsel_okwait
	cmp	_bpselprocess+bpsel_p1
	bne	.exit
	cmp	_bpselprocess+bpsel_p2
	bne	.exit

	Mbpsel_setprocess	bpsel_okend

.exit	rts


;--------------------------------------------------------------------
;	okend
;--------------------------------------------------------------------

bpsel_okend
	jsr	cursor_okset


	Mbpsel_setnumberY
	Mbpsel_keycheck	ok
	beq	.exit

	MsetBL	kw_tm,13h
	inc	mpw_misplayerflag	; exit
	ksound	good_luck

.exit	rts


;--------------------------------------------------------------------
;	now ! select
;--------------------------------------------------------------------
bpsel_select
	jsr	Xcursor_move		; cursor move
	jsr	draw_playername		; player name

	Mbpsel_setnumberY

	ldx	register
	lda	_bpselplayerNo,x
	cmp	#6
	bcs	.exit

	Mbpsel_keycheck	ok
	beq	.exit
	Mbpsel_setprocess	bpsel_okwait
	ksound	kettei

.exit	rts
	
;--------------------------------------------------------------------
;	config finger select(UP/DOWN)
;--------------------------------------------------------------------

select_finger
	ldx	register
	ldy	bpsel_index
	lda.w	trig0,y
	and	#button_up+button_down
	beq	.exit
	and	#button_up
	bne	.up

;------------------------------------------------------
.down	a8
	cpx	#bpsel_p1
	bne	.p2dw
	lda	#player_controltype_1B
	bra	.p1dw
.p2dw	lda	#player_controltype_2B
.p1dw	bit	player_controltype
	bne	.exit
	ora	player_controltype
	sta	player_controltype
	bra	.sound

;------------------------------------------------------
.up	a8
	cpx	#bpsel_p1
	bne	.p2up
	lda	#player_controltype_1B
	bra	.p1up
.p2up	lda	#player_controltype_2B
.p1up	bit	player_controltype
	beq	.exit
	eor	#0ffh
	and	player_controltype
	sta	player_controltype

;------------------------------------------------------
.sound	a16
	ksound	cursor		; set sound

;------------------------------------------------------
.exit	a16
	rts

;--------------------------------------------------------------------
;	disp finger 
;--------------------------------------------------------------------

disp_finger
	ldx	register
;-------------------------------------------------
	cpx	#bpsel_p1
	bne	.p2
	lda	#player_controltype_1B
	bra	.p1
.p2	lda	#player_controltype_2B
.p1	and	player_controltype
	bne	.down
;-------------------------------------------------
.up	jsr	finger_animecalc
	lda	finger_up&xx,y
	tay
	jmp	call_bgdraw
;-------------------------------------------------
.down	jsr	finger_animecalc
	lda	finger_dw&xx,y
	tay
	jmp	call_bgdraw
;-------------------------------------------------
finger_animecalc	
	lda	bpsel_fingeranime
	and	#0011000b
	lsr	a
	lsr	a
	tay
	rts
;-------------------------------------------------
;
;
;
;
;
;
;
;--------------------------------------------------------------------
;	
;
;
;*******************************************************************
;	draw player name
;*******************************************************************
draw_playername

	ldx	register
	lda	_bpselcounter,x

	ifne	AF_namedispOFF
	clc
	adc	#39
	endc

	cmp	#40
	bcs	.gogo
	inc	_bpselcounter,x
	sec
	sbc	#20
	bmi	.exit
	lsr	a
	pha
	lda	_bpselplayerNo,x
	asl	a
	tax
	ldy	name_select&WM,x
	pla
	jsr	call_bgdrawN
.skip
	rts

.exit	jmp	clear_name_gogo

.gogo	Mbpsel_gogo_set
	rts

;-------------------------------------------------------------------
call_bgdraw
	ldx	bpsel_index
	jmp	(.process,x)
.process	dwcode	psel_bgdraw	; (player1) bgdraw
	dwcode	psel_bgdrawP2	; (player2) bgdraw
;-------------------------------------------------------------------
call_bgdrawN
	ldx	bpsel_index
	jmp	(.process,x)
.process	dwcode	psel_bgdrawN	; (player1) bgdraw
	dwcode	psel_bgdrawN2	; (player2) bgdraw
;-------------------------------------------------------------------
;	name clear & gogo clear
;-------------------------------------------------------------------
clear_name_gogo
	Mbpsel_gogo_clear
	ldy	#name_clear&WM
	jmp	call_bgdraw
;-------------------------------------------------------------------
;	set name   & gogo set
;-------------------------------------------------------------------
set_name_gogo
	Mbpsel_gogo_set
	lda	_bpselplayerNo,x
	asl	a
	tax
	ldy	name_select&WM,x
	jmp	call_bgdraw
;-------------------------------------------------------------------


;*******************************************************************
;	player okcursor
;*******************************************************************
cursor_okset

	Mbpsel_setnumberY

	lda	#00b8h			; position

set_pselfrashcursor
	ora	bpsel_cursorV&WM,y	; position
	pha
	lda.l	attrcount		; attribute
	and	#0110b
	xba
	tax
	ldy	#ok_data&xx
	pla
	jmp	yj_setsprite


;*******************************************************************
;	player select cursor move
;*******************************************************************
;
;	move cursor
;
;-------------------------------------------------------------------

Xcursor_move

	Mbpsel_setnumberY
	
	lda.w	trig0+1,y
	ldy	_bpselplayerNo,x
	phx				; >>

	jsr	keymove
					; Carry = sound flag
	plx				; <<
	sty	_bpselplayerNo,x

	bcc	.exit

	Mbpsel_cursorsoundON

	cpy	#6
	bne	.skip

	Mbpsel_setprocess	bpsel_configentry
.skip

.exit	rts

;-------------------------------------------------------------------
;
; A = Vposition
; Y = 0,1,2,3,4,5,6	player offset
;
;-------------------------------------------------------------------
Xcursor_set
	ldx	register
	ldy	_bpselplayerNo,x

	lda	_bpselnumber,x
	tax

set_1pnormalcursor
	lda.l	bpsel_cursorV,x
	sta	Xwork0			; V-position
	lda	bpsel_cursorchar&WM,x
	tax
	lda	p_pos&xx,y
	and	#00ffh
	ora	Xwork0
	txy
	ldx	#0
	jmp	yj_setsprite

;-------------------------------------------------------------------
bpsel_indexdata
	dw	bpsel_p2,bpsel_p1
bpsel_cursorV
	dw	6400h,8200h
;-------------------------------------------------------------------
bpsel_cursorchar
	dwcode	p1_data
	dwcode	p2_data
;-------------------------------------------------------------------













	
















;*******************************************************************
;	bpsel 
;*******************************************************************

bpsel_initial
	ldx	#bpsel_p1
	stz	_bpselprocess,x
	stz	_bpselcounter,x
	stz	_bpselnumber,x
	stz	_bpselplayerNo,x
	stz	_bpselflag,x

	ldx	#bpsel_p2
	stz	_bpselprocess,x
	stz	_bpselcounter,x
	stz	_bpselflag,x

	lda	#1
	sta	_bpselplayerNo,x
	lda	#2
	sta	_bpselnumber,x

	rts

;*******************************************************************
;	cursor set program
;*******************************************************************

;*******************************************************************
;	cursor move program
;*******************************************************************
; 
; < input >	Y = parameter address 
;	A = key data (8bit)
;
;	max min 
;
; < output > C = sec ... keymove
;	    clc	... keywait
;
;-------------------------------------------------------------------
psel_kmax	equ	7
psel_kmin	equ	0
;-------------------------------------------------------------------
keymove
	ai8
	and	#(button_left/256)+(button_right/256)
	beq	.exit
	and	#(button_right/256)
	beq	.left
	iny
	cpy	#psel_kmax
	bcc	.set
	ldy	#psel_kmin
	bra	.set

.left	dey
	bpl	.set
	ldy	#psel_kmax-1

.set	ai16
	phy			; >>
	ldx	register
	stz	_bpselcounter,x	; counter reset !!
	ply			; <<
	sec
	rts



.exit	ai16cC
	rts

;*******************************************************************
;	common programs
;*******************************************************************
;-------------------------------------------------------------------
;	oamset
;-------------------------------------------------------------------
pselsetobj
	jsr	Main_OBJ
	rts

;-------------------------------------------------------------------
;
;-------------------------------------------------------------------
;;
;;
;;
;;
;;
;;
;;
;*******************************************************************
;	SPRITE PROGRAM
;*******************************************************************
plane_oamset_p2
	ldy	bpsel_p2+_bpselplayerNo
	bra	plane_oamset_common
plane_oamset_p1
	ldy	bpsel_p1+_bpselplayerNo
plane_oamset_common
	cpy	#6
	bcs	.exit
	ldx	register
	lda	pseldata2&xx,y
	and	#00ffh
	sta	_anime_trigger,x
.exit	jmp	Newoamset

;====================================================================
face_oamset_p1X
	ldx	register
	lda	#140h		; face player(1)
	sta	_charadd,x	; character addition
	jmp	Newoamset

;--------------------------------------------------------------------
face_oamset_p2X
	ldx	register
	lda	#180h		; face player(2)
	sta	_charadd,x	; character addition
	jmp	Newoamset

;====================================================================
face_oamset_p2
	lda	p2_player
	ldx	#180h
	ldy	#idx_drawP2face
	bra	face_oamset_common
;-----------------------------------------------------------
face_oamset_p1	
	lda	p1_player
	ldx	#140h	
	ldy	#idx_drawP1face
;-----------------------------------------------------------
face_oamset_common
	sta	Xwork0
	stx	Xwork1
	sty	Xwork2

	ldx	register
	ldy	Xwork0
	cpy	#6			; <= config mode select
	bcc	.entry
;-----------------------------------------------------------
	lda	#ys_keyconfig
	sta	_anime_trigger,x
	bra	.oamset 
;-----------------------------------------------------------
.entry	
.skip2	lda	objdraw			; ( DRAW timming ?)
	and	#03h
	cmp	Xwork2
	bne	.faceset		; ( NO! => skip )

	lda	facenomalpose_select&xx,y
	and	#00ffh
	ora	#8000h
	cmp	_anime_trigger,x
	beq	.faceset
	and	#7fffh
	sta	_anime_trigger,x

;-----------------------------------------------------------
.faceset	lda	Xwork1			; face player(1)
	sta	_charadd,x		; character addition
	jmp	Newoamset
;-----------------------------------------------------------
.oamset	stz	_charadd,x
.oamset2	jmp	Newoamset
;-----------------------------------------------------------




;********************************************************************
;	control typeselect library
;********************************************************************

;-----------------------------------------------------------

Disp_BATTLEkeytypeobj
	km_bitchecktotalflag	battle
	beq	Disp_MISSIONkeytypeobj

	ldx	#0c070h			; position
	lda	#player_controltype_2B
	jsr	Disp_keytypeobj
Disp_MISSIONkeytypeobj
	ldx	#04070h			; position
	lda	#player_controltype_1B
Disp_keytypeobj
 	ldy	#obj_typeA&WM		; typeobj address
	bit	player_controltype
	beq	.typeA	
	ldy	#obj_typeB&WM
.typeA
	txa
	jmp	common_oamset






;********************************************************************
;
;********************************************************************

;-------------------------------------------------------------------
oamsetpselstartp1
	ldx	register
	ldy	#0028h		; set pselstart 
	lda	bpsel_p1+_bpselflag
	and	#on_gogo
	beq	oamsetpselstart_clear	
	bne	oamsetpselstart_set	
oamsetpselstartp2
	ldx	register
	ldy	#00a8h		; set pselstart 
	lda	bpsel_p2+_bpselflag
	and	#on_gogo
	bne	oamsetpselstart_set	
;-------------------------------------------------------------------
oamsetpselstart_clear		; clear sprite
	ldy	#00e0h
oamsetpselstart_set			; set sprite
	tya
	sta	_axisY,x
	jmp	Newoamset

;-------------------------------------------------------------------
;;
;;
;;
;===================================================================
;===================================================================
; END END END END END END END END END END END END END END END END 
;===================================================================
;===================================================================

