;*****************************************************************************
;*									*
;*			MISSION MAP RAM PROGRAM				*
;*									*
;*****************************************************************************
	INCPUB	ramtitle

;=====================================================================
;*		Label Definition				*
;=====================================================================
mm_sx	equ	kz_x1		;2 byte
mm_sy	equ	kz_x2		;2 byte
mm_ex	equ	kz_y1		;2 byte
mm_ey	equ	kz_y2		;2 byte

mm_mx	equ	kz_x3		;2 byte
mm_my	equ	kz_y3		;2 byte

mm_dx	equ	kz_z1		;2 byte
mm_dy	equ	kz_z2		;2 byte
mm_dxdy	equ	kz_tempaddrl	;2 byte

mm_sp	equ	kz_tpa		;2 byte
mm_spx	equ	kz_tpx		;2 byte
mm_spy	equ	kz_tpy		;2 byte

mm_flag	equ	kz_textpt	;2 byte
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;* enemy list *
	km_worklabelstart	0		;kx_enemylisttemp
	km_worklabel	W,mmx_ennext		; 2 byte
	km_worklabel	W,mmx_enprev		; 2 byte

	km_worklabel	W,mmx_enposx		; 2 byte
	km_worklabel	W,mmx_enposy		; 2 byte
	km_worklabel	W,mmx_enangY		; 2 byte
	km_worklabel	W,mmx_envel		; 2 byte
	km_worklabel	W,mmx_envelx		; 2 byte
	km_worklabel	W,mmx_envely		; 2 byte
	km_worklabel	W,mmx_enflags		; 2 byte
	km_worklabel	W,mmx_enstratptr	; 2 byte
	km_worklabel	W,mmx_enwaittm		; 2 byte
	km_worklabel	W,mmx_enanmpatt		; 2 byte

	km_worklabel	B,mmx_endestNo		; 1 byte
	km_worklabel	B,mmx_endestx		; 1 byte
	km_worklabel	B,mmx_endesty		; 1 byte
	km_worklabel	B,mmx_encoll		; 1 byte :collision
	km_worklabel	B,mmx_enchrbase		; 1 byte
	km_worklabel	B,mmx_enchranm		; 1 byte
	km_worklabel	B,mmx_enanmptr		; 1 byte
	km_worklabel	B,mmx_enanmmaxptr	; 1 byte
	km_worklabel	B,mmx_enanmtm		; 1 byte
	km_worklabel	B,mmx_enlevel		; 1 byte

	km_worklabellen	mmx_enemylen		; length
	km_workvalcheck  48

;* enmey flags *
	km_gmflagstart	enfl
	km_gmflag	encount		;0/1 ... encount
	km_gmflag	extra		;0/1 ... sos/extra
	km_gmflag	arrive		;0/1 ... arrive
enfl_all	equ	-1
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;=====================================================================
;*			Flag Definition				*
;=====================================================================
;--------------------------------------------------------------------
;* mmx_arwingflag *
	km_flagstart
mmf_all	equ	-1

	km_flag	mmf_init	;0/1 ... initial
	km_flag	mmf_go		;0/1 ... stop / arwing go
	km_flag	mmf_arvx	;0/1 ... arrive X zahyou
	km_flag	mmf_arvy	;0/1 ... arrive Y zahyou
	km_flag	mmf_finish	;0/1 ... arwing arrive
;---------------------------------------------------------------------
;* mmw_cursorflag *
	km_flagstart
curf_all	equ	-1
	km_flag	curf_hit	;0/1 ... no hit / hit
	km_flag	curf_hitobj	;0/1 ... planet / enemy
	km_flag	curf_wkcancel	;0/1 ... waku kakomi cancel (planet enemy)
	km_flag	curf_keypush	;0/1 ... no key push / key push
;---------------------------------------------------------------------
;=====================================================================
;*								*
;*		Macro Definition				*
;=====================================================================
km_ramcpudivu16uf8	macro	[output,divisor]
;init	:a16i16
;	Acc(16 bit) / #divisor (8 bit)
;exit	:a16i16
;	syou(work),amari(work)
;	syou (x),amari(y)

MYNARG	=	NARG
	CHK_NARG	2

_cc_{output} =	2
_cc_xy	=	0
_cc_work	=	1

	km_memchecka16i16

	IFEQ	_cc_{output}-_cc_xy
	ldx	#{divisor}
	km_jsr	ramdivu16u8_sub
	ELSEIF

		IFEQ	_cc_{output}-_cc_work
		phx
		phy
		ldx	#{divisor}
		km_jsr	ramdivu16u8_sub
		stx	ksyou
		sty   	kamari

		ply
		plx
		ELSEIF

		printf	"Error:(xy,work) needed\n"
		error+
		ENDC
	ENDC
	endm

;--------------------------------------------------------------------
km_MMSetSpriteSizeDouble	macro
;Init	Yregister... sprites pointer
	savemode
	phx
	phy

	km_jsr	mm_SetSprSize_double_sub

	returnmode
	ply
	plx
	endm
;--------------------------------------------------------------------
;--------------------------------------------------------------------
;*********************************************************************
;*								*
;*								*
;*			On RAM PROGRAM 		[Main Routine]	*
;* Data Bank 7e							*
;*								*
;*********************************************************************
heap_runmariostart_l
	shorta
	longi
	php
	phb

;* ROM Nasty ON *
	storenasty
	nastyon
;
* Mario Program Start *
	lda	#MMakePlanet>>16
	sta.l	mcodebank
	a16
	lda	#MMakePlanet&WM
	sta.l	mr15	; GO!
	a8
;======================================================================
;*			 RAM Program Start 			*
;* data bank 7e							*
;======================================================================
	km_SyoriOverCheckStart
;---------------------------------------------
;*		Data Bank 7e		*
;---------------------------------------------
	db7e
;---------------------------------------------
;*	Itumo ugoku routine	  	*
;---------------------------------------------
;* Mission Complete Check *
	km_jsr	mm_checkmiscomplete
	bcs	.skiproutine
;* cursor *
	km_jsr	mm_movecursor		;[move cursor]
	km_jsr	mm_curcollcheck		;[collision check]

;* player *
	km_jsr	mm_calcplayerangle	;[player agle]
	km_jsr	mm_calcplayercgxptr	;[player cgx ptr]

;---------------------------------------------
;*	Time Stop notokiwa ugokanai	*
;---------------------------------------------
	km_bitcheckmismapflag	timestop
	bne	.skiproutine
;* player *
	km_jsr	mm_moveplayer		;[player move]

;* game timer *
	km_jsr	mm_gametotaltm		;[game timer]

;* enemy *
	km_jsr	mm_extraenemyappear
	km_jsr	mm_extraenemymove

	km_jsr	mm_sosenemyappear
	km_jsr	mm_sosenemymove

;*** sonota ****
;* ball *
;;;	km_jsr	moveball		;[ball move]
;* station *
	km_jsr	mm_rotstation

;---------------------------------------------
;*	Dsiplay Routine			*
;---------------------------------------------
.skiproutine
;* Set screen (screen kakikae) *
	km_jsr	mm_dispgametotaltm

;* Set Colour *
	km_jsr	mm_changecolpal

;* Set Sprites *
	km_jsr	mm_dosprites

	km_SyoriOverCheckEnd
;---------------------------------------------
;*	 planet making wait 		*
;---------------------------------------------
	km_waitmario
;---------------------------------------------
;*	     End			*
;---------------------------------------------
.end
	restorenasty
	plb
	plp
	rtl

;*********************************************************************
;*								*
;*		On RAM PROGRAM (Sub Routine)			*
;*								*
;*********************************************************************
;=====================================================================
;*		 Complete Check 				*
;=====================================================================
mm_checkmiscomplete
	shorta
	longi
;* List Free *
	km_bitcheckmismapflag	missioncomp
	beq	.end


	km_bitcheckmismapflag	extrasos
	bne	.extrasos
.planet

	km_clrmismapflag	missioncomp
	bra	.end

.extrasos

	km_clrmismapflag	missioncomp
	km_clrmismapflag	extrasos

;* Enemy List Free *
;-------------------------------------------------
;* kono test wa debug mode notame *
	lda	mmx_enemytotal
	beq	.end
;-------------------------------------------------
	ldx	kx_SOSEnemyptr		;enemy pointer
	km_jsr	mm_enemyramfree
	dec	mmx_enemytotal
.end
	clc
	rts

;=====================================================================
;*			Set Cursor Postion			*
;* db 7e								*
;=====================================================================
mm_movecursor
	shorta
	longi
;* arwing go *
	km_testjoypad	OK
	km_beq	.NoPushOK
	km_clrmismapflag	timestop
	km_setflag	mmx_arwingflag,mmf_init
.NoPushOK

;* arwing stop *
	km_testjoypad	B
	beq	.nopushB

	km_clrflag	mmx_arwingflag,mmf_go
.NoPushB

;* map stop *
	km_testjoypad	X
	beq	.nopushX

	km_setmismapflag	timestop
	km_clrflag	mmx_arwingflag,mmf_go
.NoPushX

;----------------------
;* BIG cursor animation check *
	km_addgesmaxtomin	mmx_curanmtm,1,4,0
	bne	.nochange_curanm
	km_addgesmaxtomin	mmx_curanmptr,1,4,0
.nochange_curanm

;* normal cursor Animation *
	dec	mmx_curtimer
	bne	.NotChangeChr
	km_setval	mmx_curtimer,8
	km_eorflag	mmx_curchar,2
.NotChangeChr

;----------------------
;* moshi arwing no idoutyuu dattara cursor wa ugokanai *
	km_bitcheckflag	mmx_arwingflag,mmf_go
	km_bne	.end
;---------------------------------------------------------------------
;* key push check *
.check_tenkey
	km_readkeydown_h
	bit	#(pad_up!pad_down!pad_left!pad_right)>>8
	bne	.push_tenkey
;----------------------
.nopush_tenkey
	km_clrflag	mmw_cursorflag,(curf_keypush)
	km_stxval	mmx_curaccel,0
	km_stxval	mmx_curaccelx,0
	km_stxval	mmx_curaccely,0
	brl	.end
;----------------------
.push_tenkey
;* cursor speed *
	a16
	km_addgtumax	mmx_curaccel,$80,$400
	a8
;* cursor ga PLANET ni HIT shiteite sono cursor no idou check *
	km_bitcheckflags	mmw_cursorflag,(curf_keypush!curf_hit)
	km_beq	.end

	km_setflag	mmw_cursorflag,curf_keypush ;REPEAT FLAG ON

	km_bitcheckflag	mmw_cursorflag,curf_hit
	km_bne	.specialmove
;******** cursor Move **********
.checkmove
	km_readkeydown_h
	bit	#padl_up
	bne	.up
	bit	#padl_down
	bne	.down
	a16
	km_setval	mmx_curaccely,0
	a8
	bra	.check_lr
;-----------------------------------
.up
	km_negstavar	mmx_curspeedy,mmx_curspeed
	bra	.check_lr
;-----------------------------------
.down
	km_setvar	mmx_curspeedy,mmx_curspeed
;-----------------------------------
.check_lr
	km_readkeydown_h
	bit	#padl_left
	bne	.left
	bit	#padl_right
	bne	.right
	a16
	km_setval	mmx_curaccelx,0
	a8
	bra	.set_postion
;-----------------------------------
.left
	km_negstavar	mmx_curspeedx,mmx_curspeed
	bra	.set_postion
;-----------------------------------
.right
	km_setvar	mmx_curspeedx,mmx_curspeed
;*************** cursor zahyou set **************
.set_postion
	km_jsr	mm_setcurpos_sub
	BRA	.end
;---------------------------------------------------------------------
;*		Planet wo kakomu cursor no cancell		*
;---------------------------------------------------------------------
.specialmove
	SHORTA
	LONGI

	km_readkeydown_h
	bit	#padl_up
	bne	.sp_up
	bit	#padl_down
	bne	.sp_down
	bra	.check_lrsp
;-----------------------------------
.sp_up
	km_setval	mmx_curspeedy,-32-1
	bra	.check_lrsp
;-----------------------------------
.sp_down
	km_setval	mmx_curspeedy,16+1
;-----------------------------------
.check_lrsp
	km_readkeydown_h
	bit	#padl_left
	bne	.sp_left
	bit	#padl_right
	bne	.sp_right
	bra	.set_postion2
;-----------------------------------
.sp_left
	km_setval	mmx_curspeedx,-32-1
	bra	.set_postion2
;-----------------------------------
.sp_right
	km_setval	mmx_curspeedx,16+1
;-----------------------------------
.set_postion2
	km_jsr	mm_setcurpos_sub

	km_setflag	mmw_cursorflag,curf_wkcancel

	km_stxval	mmx_curaccel,0
	km_stxval	mmx_curaccelx,0
	km_stxval	mmx_curaccely,0
.end
	rts
;-------------------------------------------------------------------------
;*
;-------------------------------------------------------------------------
mm_setcurpos_sub
	shorta
	longi
;* cursor X zahyou *
	lda	mmx_curposx
	clc
	adc	mmx_curspeedx
	cmp	#16		;Left edge
	bcc	.nosetx
	cmp	#$100-24	;Right edge
	bcs	.nosetx
	sta	mmx_curposx
.nosetx
;* cursor Y zahyou *
	lda	mmx_curposy
	clc
	adc	mmx_curspeedy
	cmp	#$30		;Top edge
	bcc	.nosety
	cmp	#$d0		;Bottom edge
	bcs	.nosety
	sta	mmx_curposy
.nosety
	rts
;=====================================================================
;*			Cursor Hit Check			*
;* data bank :7e							*
;=====================================================================
mm_curcollcheck
	shorta
	longi
;;* moshi mou hit shite itara  *
;;	km_bitcheckflag	mmw_cursorflag,curf_hit
;;	km_bne	.end

	ldx	mmh_collisaddr
	ldy	#mm_col_listlen/4
.CollisionCheck
	a16
	lda.w	heap+0,x
	km_loba
	sta	kz_x2
	lda.w	heap+1,x
	km_loba
	sta	kz_y2
	lda	#16
	sta	kz_z2

	lda	mmx_curposx
	km_loba
	sta	kz_x1
	lda	mmx_curposy
	km_loba
	sta	kz_y1
	km_memchecka16
	km_jsr	mm_collcheck_sub
	bcc	.NextCheck
;--------------------------------------
.Hit
	a8
	lda.w	heap+0,x
	sta	mmx_curposx
	sta	mmx_destposx	;wipe postion CX
	lda.w	heap+1,x
	sta	mmx_curposy
	sta	mmx_destposy	;wipe postion CY
	lda.w	heap+3,x
	sta	KGameMapPtr
	km_clrflag	mmw_cursorflag,curf_hitobj
	km_setflag	mmw_cursorflag,curf_hit
	bra	.End
;--------------------------------------
.NextCheck
	a16
	txa
	clc
	adc	#4
	tax
	a8
	dey
	km_bne	.CollisionCheck

	km_clrflag	mmw_cursorflag,curf_hit
.End
	RTS

;=====================================================================
;*		Calculate Arwing Angle	(16 pattern)		*
;* data bank :7e							*
;=====================================================================
mm_calcplayerangle
	shorta
	longi
;* arwing move check *
	km_bitcheckflag	mmx_arwingflag,mmf_go
	km_bne	.end

;* cursor hit check *
	km_bitcheckflag	mmw_cursorflag,curf_hit
	bne	.go_planet

;* key push check *
	km_bitcheckflag	mmw_cursorflag,curf_keypush
	bne	.go_planet

;* 360 kuru kuru turn *
	ifeq	1
	km_subltsmintomax	mmx_arwinganmtm,1,0,8
	cmp	#8
	bne	.end
	km_addgeumaxtomin	mmx_arwinganmptr,1,$10,0
	bra	.end
	endc
;--------------------------------------------------------------------
	ifeq	1
	km_testjoypad	TLeft
	beq	.skip1
	km_addgeumaxtomin	mmx_arwinganmptr,1,$10,0
.skip1

	km_testjoypad	TRight
	beq	.skip2
	km_subltsmintomax	mmx_arwinganmptr,1,0,$0f
.skip2
	bra	.end
	endc
;--------------------------------------------------------------------
.go_planet
	a16
	km_lobstavar	x1,mmx_arwingposx+1
	km_lobstavar	y1,mmx_arwingposy+1

	km_lobstavar	x2,mmx_curposx
	km_lobstavar	y2,mmx_curposy
	longa
	km_jsr	calobjangle

; 0 to 359 degrees is $0000 to $ffff
;----------------------------
; 4 sya 5 nyuu
	bit	#$0080
	beq	.nostepup
	inc	a
.nostepup
;----------------------------
	xba
	a8
	km_divu16
	sta	mmx_arwinganmptr	;angle pointer (16 pattern) 0,1,2,3,...15
.end
	rts

;=====================================================================
;*		Calculate Arwing CGX Pointer			*
;* data bank :7e							*
;=====================================================================
mm_calcplayercgxptr	

;* kuru kuru Arwing Chara CGXAddress Calc *
	a16
	longi
	lda	p1_pilotNo
	lsr	a
	and	#3
	tay

	lda	mmx_arwinganmptr
	km_loba
	cpy	#0
	beq	.setaddr1
	clc
	adc	#16	;GGarwing
	dey
	beq	.setaddr1
	clc
	adc	#16	;SParwing
.setaddr1
;* ue 2chra tensou *
	clc
	adc	mmh_sprarwingaddr
	tax
	lda.w	heap,x
	and	#$ff
	km_multa32
	clc
	adc	mmh_objcgxaddr
	sta	mmw_arwingcgxptr1
;* shita 2 chr tensou *
	clc
	adc	#$200
	sta	mmw_arwingcgxptr2
	a8
	rts

;----------------------------------------------------------------------------
;* Calculate Object Angle *
;* db = $7e
;* a16 i16
;* In   :source = (x1,y1),dest = (x2,y2)
;* Exit :Acc = Angle (16 bit) :0 to 359 degrees is $0000 to $ffff
;----------------------------------------------------------------------------
calobjangle
	php
	a16
	longi
;* zahyou set *
	km_substavar	x1,x2
	km_substavar	y1,y2

;* area check  (amari kyori ga chikasugiru to angle ga motomerarenai!!)*
;* dakra kyori ga chikasugiru tokino angle wa motomenai *
	IFEQ	1
	lda	x1
	bpl	.plasX1
	nega
.plasX1
	cmp	#16
	bpl	.calc_angle

	lda	y1
	bpl	.plasY1
	nega
.plasY1
	cmp	#16
	bmi	.chikasugi
	ENDC
;---------------------------------
;* angle wo motome ru *
.calc_angle
	km_jsl	arctan16_l
;---------------------------------
.chikasugi
	plp
	rts

;=====================================================================
;*			Set Player Postion			*
;* data bank :7e							*
;=====================================================================
mm_moveplayer
	shorta
	longi

	php
	km_bitcheck	mmx_arwingflag,mmf_init
	bne	.initial
	km_bitcheck	mmx_arwingflag,mmf_go
	bne	.playermove
	brl	.end
;---------------------------------------------------------------------
.initial
	shorta
	km_clrflag	mmx_arwingflag,mmf_init
	km_setflag	mmx_arwingflag,mmf_go

	a16
	km_lobstavar	mm_sx,mmx_arwingposx+1
	km_lobstavar	mm_sy,mmx_arwingposy+1
	km_stavar	mm_sp,mmx_arwingsp
	km_lobstavar	mm_ex,mmx_curposX
	km_lobstavar	mm_ey,mmx_curposY

	km_jsr	mm_calcdxdy
	
	longa
	km_stavar	mmx_arwingspx,mm_spx
	km_stavar	mmx_arwingspy,mm_spy
	a8
	km_stavar	mmx_arwingdx,mm_dx
	km_stavar	mmx_arwingdy,mm_dy
	km_stavar	mmx_arwingdxdy,mm_dxdy
;---------------------------------------------------------------------
.playermove
	a16
	km_stavar	mm_sx,mmx_arwingposx
	km_stavar	mm_sy,mmx_arwingposy
	km_lobstavar	mm_ex,mmx_curposX
	km_lobstavar	mm_ey,mmx_curposY

	km_stavar	mm_sp,mmx_arwingsp
	km_stavar	mm_spx,mmx_arwingspx
	km_stavar	mm_spy,mmx_arwingspy

	km_lobstavar	mm_dx,mmx_arwingdx
	km_lobstavar	mm_dy,mmx_arwingdy
	km_lobstavar	mm_dxdy,mmx_arwingdxdy
	km_stavar	mm_flag,mmx_arwingflag

;------------------------------------------
	km_jsr	mm_speedupmode
;------------------------------------------

	km_jsr	mm_2pointmove
	km_bitcheck	mm_flag,4
	bne	.finish

	km_stavar	mmx_arwingposx,mm_sx
	km_stavar	mmx_arwingposy,mm_sy
	km_stavar	mmx_arwingflag,mm_flag
	a8
	km_stavar	mmx_arwingdxdy,mm_dxdy
	bra	.end
.finish
	a8
	km_clrflag	mmx_arwingflag,mmf_all
	km_bitcheck	mmw_cursorflag,curf_hit
	km_beq	.end
	km_setmismapflag	missionstart
;---------------------------------------------------------------------
.end
	plp
	rts
;=====================================================================
;*			Speed UP CHECK				*
;=====================================================================
mm_speedupmode
	longa
	km_testkeydown	A
	beq	.noApush

	lda	mm_spx
	km_multa8
	sta	mm_spx

	lda	mm_spy
	km_multa8
	sta	mm_spy

	ifeq	1
	km_setval	mm_sp,$0100
	lda	mm_spx
	bmi	.minusspx
.plasspx
	lda	#$0100
	bra	.staspx
.minusspx
	lda	#-$100
.staspx
	sta	mm_spx

	lda	mm_spy
	bmi	.minusspy
.plasspy
	lda	#$100
	bra	.staspy
.minusspy
	lda	#-$100
.staspy
	sta	mm_spy

	endc
.noApush
	rts
;=====================================================================
;*		2 tenkan no idou				*
;* data bank :7e							*
;=====================================================================
;=====================================================================
;*		Calculation (DY/DX)				*
;=====================================================================
mm_calcdxdy
	php

	a16
;* calc DX *
	km_subvar	mm_ex,mm_sx
	sta	mm_dx
	bpl	.incx
.decx
	km_negstavar	mm_spx,mm_sp	;speed x
	bra	.skip_dx
.incx
	km_setvar	mm_spx,mm_sp	;speed x
.skip_dx
;--------------------------------------------------------
;* calc DY *
	km_subvar	mm_ey,mm_sy
	sta	mm_dy
	bpl	.incy
.decy
	km_negstavar	mm_spy,mm_sp	;speed y
	bra	.skip_dy
.incy
	km_setvar	mm_spy,mm_sp	;speed y
.skip_dy
;--------------------------------------------------------
	km_absstavar	mm_dx		;mm_dx
	km_absstavar	mm_dy		;mm_dy
	stz	mm_dxdy
	plp
	rts
;=====================================================================
;*		2 tenkan no idou				*
;* out:clc/sei ... continue / end					* 
;=====================================================================
mm_2pointmove
	php
	a16
	lda	mm_dx
	sec
	sbc	mm_dy
	bmi	.addy
;-----------------------------------------
;dx > dy
.addx
	km_addstavar	mm_sx,mm_spx
;;;	km_substavarltsmin	mm_cntx,mm_sp,0
	lda	mm_dxdy
	clc
	adc	mm_dy
	cmp	mm_dx
	bmi	.noaddy
	pha
	km_addstavar	mm_sy,mm_spy
;;;	km_substavarltsmin	mm_cnty,mm_sp,0
	pla
	sec
	sbc	mm_dx
.noaddy
	sta	mm_dxdy
	bra	.endcheck
;-----------------------------------------
;dy > dx
.addy
	km_addstavar	mm_sy,mm_spy
;;;	km_substavarltsmin	mm_cnty,mm_sp,0
	lda	mm_dxdy
	clc
	adc	mm_dx
	cmp	mm_dy
	bmi	.noaddx

	pha
	km_addstavar	mm_sx,mm_spx
;;;	km_substavarltsmin	mm_cntx,mm_sp,0
	pla
	sec
	sbc	mm_dy
.noaddx
	sta	mm_dxdy
;-----------------------------------------
.endcheck
	a8
	lda	mm_sx+1
	cmp	mm_ex
	bne	.nohitx
	km_setflag	mm_flag,mmf_arvx
.nohitx
	lda	mm_sy+1
	cmp	mm_ey
	bne	.nohity
	km_setflag	mm_flag,mmf_arvy
.nohity
	km_bitcheckflags	mm_flag,mmf_arvy!mmf_arvx
	bne	.exit
.finish_move
	km_setflag	mm_flag,mmf_finish
	plp
	rts
.exit
	plp
	rts

;=====================================================================
;*								*
;*			Total Game Timer			*
;* Data Bank :7e							*
;=====================================================================
mm_gametotaltm
	a16
	longi

	km_testkeydown	A
	beq	.normal

	dec	mmw_MISSIONSUBTIMER
	dec	mmw_MISSIONSUBTIMER
	dec	mmw_MISSIONSUBTIMER
	dec	mmw_MISSIONSUBTIMER
	dec	mmw_MISSIONSUBTIMER
.normal
	dec	mmw_MISSIONSUBTIMER
	bpl	.notTimeChange

	km_setmismapflag	hourpast	;1 hour past flag
	km_setval	mmw_MISSIONSUBTIMER,60
	km_addstaval	kw_MISSIONTIMER,1
	cmp	#999
	bmi	.notTimeChange
	km_setval	kw_MISSIONTIMER,999
	km_setmissionflag	gameover
.notTimeChange
	a8
	rts

;=====================================================================
;*		Extra Enemy Appear Routine			*
;* Data Bank :7e							*
;=====================================================================
mm_extraenemyappear
mm_extraenemymove
	shorta
	longi

	rts

;=====================================================================
;*		SOS Enemy Appear Routine			*
;* Data Bank :7e							*
;* Yreg :Enemy List Pointer						*
;=====================================================================
mm_enemymax	equ	8

;---------------------------------------------------------------------
mm_sosenemyappear
	a16
	longi
;* total no kazu check *
	lda	mmx_enemytotal
	cmp	#mm_enemymax
	km_bpl	.end

;* time check *
	km_bitcheckmismapflag	hourpast
	km_beq	.end
	km_clrmismapflag	hourpast
	lda	kw_MISSIONTIMER
	km_acmpa	#15
	bne	.end
.appearenemy
	km_jsr	mm_initsoslist
.end
	rts



mm_initsoslist_l
	jsr	mm_initsoslist
	rtl
;*********************************************************************
;*		SOS Enemy List Initial Set			*
;* moshi SOS enemy ga APPEAR shitara					*
;*********************************************************************
mm_initsoslist
	php
	ai16

;* get enemy list memory *
	ldx	#0
	l_add.w	kx_enlistptr,kx_enfreeptr,mm_blink
	txy
	inc	mmx_enemytotal
;----------------------------------------------------------
	ldx	kx_enemychartptr
;*** (x,y) zahyou ***
;* source *
	lda.l	mm_enemychart+0,x
	sta.w	mmx_enposx,y
	km_hibswapsta	kz_x1	;postion X

	lda.l	mm_enemychart+2,x
	sta.w	mmx_enposy,y
	km_hibswapsta	kz_y1	;postion Y
;* dest *
	a8
	lda.l	mm_enemychart+10,x
	sta.w	mmx_endestNo,y
	km_jsr	mm_enemydest

;* velocity *
	a16
	lda.l	mm_enemychart+4,x
	sta.w	mmx_envel,y	;velocity
	km_jsr	calc_envelxy

;* stratage pointer *
	lda	#0
	sta.w	mmx_enstratptr,y

;* collision *
	lda	#12
	sta.w	mmx_encoll,y		;collision

;* flags *
	km_clrflag.w	mmx_enflags,enfl_extra,y

;* enemy level *
	lda.l	mm_enemychart+12,x
	sta.w	mmx_enlevel,y

;* Character No *
	PHX
	a8
	lda	#0
	sta.w	mmx_enanmptr,y

	lda.l	mm_enemychart+6,x
	sta.w	mmx_enchrbase,y		;character Base No

	a16
	lda.l	mm_enemychart+8,x
	sta.w	mmx_enanmpatt,y		;animtion pattern pointer
	tax

	a8
	lda.l	mm_sprenpattdata+0,x
	sta.w	mmx_enanmmaxptr,y	;anime pattern max pointer

	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;sprite anim chr No 

	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y		;Animation change Timer
	PLX

;* Next Chart Pointer *
	a16
	lda	kx_enemychartptr
	clc
	adc	#(mm_enemychartEND-mm_enemychart)&WM
	cmp	#(mm_enemychartFinish-mm_enemychart)&WM
	bne	.skip1
	lda	#0
.skip1
	sta	kx_enemychartptr

	plp
	rts

;=====================================================================
;*		Enemy List Free					*
;=====================================================================
mm_enemyramfree
	a16
	longi
	l_rem.w	kx_enlistptr,kx_enfreeptr
	a8
	rts

;=====================================================================
;*			Enemy Move				*
;=====================================================================
mm_sosenemymove
	a16
	longi
	ldy	kx_enlistptr
	km_beq	.end
;----------------------------------------------------------------------
.loop
;* character Anmation *
	a8
	lda.w	mmx_enanmtm,y
	dec	a
	sta.w	mmx_enanmtm,y
	bne	.nochangeanm

	lda.w	mmx_enanmptr,y
	inc	a
	inc	a
	cmp.w	mmx_enanmmaxptr,y
	bne	.notmax
	lda	#0
.notmax
	sta.w	mmx_enanmptr,y
	a16
	and	#$ff
	clc
	adc.w	mmx_enanmpatt,y
	tax

	a8
	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;anime pattern max pointer
	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y
.nochangeanm
;----------------------------------------------------------------------
;* enemy no planet stay check *
	a16
	lda.w	mmx_enwaittm,y
	beq	.nowait
	dec	a
	sta.w	mmx_enwaittm,y
	brl	.nextenemycheck
.nowait
;----------------------------------------------------------------------
;* velocity calc *
	a8
	lda.w	mmx_endestNo,y
	km_jsr	mm_enemydest
;* enemy velocity calc *
	km_jsr	calc_envelxy
;----------------------------------------------------------------------
;* enemy postion check *
	a16
	lda.w	mmx_envelx,y
	sta	mm_spx
	lda.w	mmx_envely,y
	sta	mm_spy

	km_jsr	mm_speedupmode

	lda	mm_spx
	clc
	adc.w	mmx_enposx,y
	sta.w	mmx_enposx,y

	lda	mm_spy
	clc
	adc.w	mmx_enposy,y
	sta.w	mmx_enposy,y
	sta.w	mmx_enposy,y
;----------------------------------------------------------------------
	a8
	lda.w	mmx_enposx+1,y
	cmp.w	mmx_endestx,y	
	bne	.notarrive
	lda.w	mmx_enposy+1,y
	cmp.w	mmx_endesty,y	
	bne	.notarrive

	a16
	km_setval.w	mmx_enwaittm,60*10,y
	a8

	lda.w	mmx_endestNo,y
	inc	a
	cmp	#8
	bne	.skip1
	lda	#1
.skip1
	sta.w	mmx_endestNo,y
.notarrive
;----------------------------------------------------------------------
;* enemy collision check *
;* player postion *
	a16
	lda.w	mmx_arwingposx+1
	km_loba
	sta	kz_x1
	lda.w	mmx_arwingposy+1
	km_loba
	sta	kz_y1
;* enemy postion *
	lda.w	mmx_enposx,y
	km_hibswapa
	sta	kz_x2
	lda.w	mmx_enposy,y
	km_hibswapa
	sta	kz_y2
	lda.w	mmx_encoll,y
	km_loba
	sta	kz_z2
;----------------------------------------------------------------------
	km_memchecka16
	km_jsr	mm_collcheck_sub
	bcc	.nextenemycheck

.ENCOUNTENEMY
	sty	kx_SOSEnemyptr	;enemy pointer keep
	km_setflag.w		mmx_enflags,enfl_encount,y
	km_setmismapflag	missionstart
	km_setmismapflag	extrasos

	a8
	lda	kz_x2
	sta	mmx_destposx	;wipe postion CX
	lda	kz_y2
	sta	mmx_destposy	;wipe postion CY
	lda.w	mmx_enlevel,y
	sta	kgamemapptr	;sos1/sos2/sos3
	a16
	bra	.end
;----------------------------------------------------------------------
.nextenemycheck
	a16
	lda.w	mmx_ennext,y
	beq	.end
	tay
	brl	.loop
;----------------------------------------------------------------------
.end
	a8
	rts

;==========================================================================
;*
;* Init	:Acc :
;*	:Yreg :Enemy Pointer
;==========================================================================
mm_enemydest
	php
	shorta
	bne	.planet
	lda.w	mmx_arwingposx+1
	sta.w	mmx_endestx,y
	lda.w	mmx_arwingposy+1
	sta.w	mmx_endesty,y
	bra	.end
.planet
	phx
	a16
	km_loba
	asl	a
	tax
	a8
	lda.l	mm_destpostbl,x
	sta.w	mmx_endestx,y
	lda.l	mm_destpostbl+1,x
	sta.w	mmx_endesty,y
	plx
.end
	plp
	rts

;=====================================================================
;*		Calculation Enmy Velocity			*
;* Yreg :Enemy List Pointer						*
;=====================================================================
calc_envelxy
	php
;* calc angle *
	a16
	km_hibswaplda.w	mmx_enposx,y
	sta	kz_x1
	km_hibswaplda.w	mmx_enposy,y
	sta	kz_y1
	km_loblda.w	mmx_endestx,y
	sta	kz_x2
	km_loblda.w	mmx_endesty,y
	sta	kz_y2

	km_jsr	calobjangle
	sta.w	mmx_enangY,y

;* calc velx,vely *
	A8
	lda.w	mmx_envel,y
	sta	kz_y1
	stz	kz_x1
	lda.w	mmx_enangY+1,y
	km_jsl	rotate_8yx_l
	A16
	lda	kz_x2
	sta.w	mmx_envelx,y
	lda	kz_y2
	sta.w	mmx_envely,y
	plp
	rts



;=====================================================================
;*								*
;* (x1,y1),(x2,y2), z2 = collision					*
;=====================================================================
mm_collcheck_sub
	longa
	longi
;* X collision check *
	lda	kz_x2
	clc
	adc	kz_z2
	cmp	kz_x1
	bcc	.nohit
	lda	kz_x2
	sec
	sbc	kz_z2
	cmp	kz_x1
	bcs	.nohit
;* Y collision check *
	lda	kz_y2
	clc
	adc	kz_z2
	cmp	kz_y1
	bcc	.nohit
	lda	kz_y2
	sec
	sbc	kz_z2
	cmp	kz_y1
	bcs	.nohit
.hit
	sec
	rts
.nohit
	clc
	rts


;=====================================================================
;*		Enemy Sprite Set				*
;=====================================================================
mm_Setsprenemy
	a16
	longi
	ldx	kx_enlistptr	;no enemy
	beq	.noenemy
.loop
;---------------------------------
	a8
	lda.w	mmx_enposx+1,x
	km_setspriteC4X
	lda.w	mmx_enposy+1,x
	km_setspritec4Y
	a16

;* x flip check *
	stz	kz_x1
	lda.w	mmx_envelx,x
	bmi	.skip1
	lda	#obj_xflip
	sta	kz_x1
.skip1
;* character set *
	km_MMSetSpriteSizeDouble
	lda.w	mmx_enchranm,x
	km_loba
	clc
	adc	kz_x1
	km_setspriteChrA	0,colpal0,pri3,noflip,mm_obj_offset
;---------------------------------
;* next enmy set *
	lda.w	mmx_ennext,x
	beq	.noenemy
	tax
	bra	.loop
.noenemy
	a8
	rts

;=====================================================================
;*		Move Ball ( From Arwing To Planet )		*
;=====================================================================
moveball
	shorta
	longi
	php

;* ball set timer *
	km_submin	mmx_ballsettm,1,0

;* ball set check *
	ldx	mmh_sprballaddr
.LOOP
	shorta
	lda.w	mmx_ballflags,x		;ball buffer ari ?
	km_bne	.moveball

	lda	mmx_ballsettm		;ball set enable ?
	km_bne	.end
;---------------------------------------------------------------------
.initial
	shorta
;* flag on *
	km_setflag.w	mmx_ballflags,1,x	;ball set flag ON
	km_setval	mmx_ballsettm,8		;timer Set
	km_setval	mmx_ballsp,8,x		;ball speed

	a16
	km_lobstavar	mm_sx,mmx_arwingposx
	km_lobstavar	mm_sy,mmx_arwingposy
	km_lobstavar	mm_ex,mmx_curposX
	km_lobstavar	mm_ey,mmx_curposY

	lda	mmx_ballsp,x
	and	#$ff
	sta	mm_sp

	km_jsr	mm_calcdxdy

	a8
	lda	mm_sx
	sta	mmx_ballsx,x
	lda	mm_sy
	sta	mmx_ballsy,x
	lda	mm_ex
	sta	mmx_ballex,x
	lda	mm_ey
	sta	mmx_balley,x
	lda	mm_spx
	sta	mmx_ballspx,x
	lda	mm_spy
	sta	mmx_ballspy,x
	lda	mm_dx
	sta	mmx_balldx,x
	sta	mmx_ballcntx,x
	lda	mm_dy
	sta	mmx_balldy,x
	sta	mmx_ballcnty,x
	lda	mm_dxdy
	sta	mmx_balldxdy,x
;---------------------------------------------------------------------
.moveball
	a16
	km_loblda	mmx_ballsx,x
	sta	mm_sx
	km_loblda	mmx_ballsy,x
	sta	mm_sy
	km_loblda	mmx_ballex,x
	sta	mm_ex
	km_loblda	mmx_balley,x
	sta	mm_ey
	km_loblda	mmx_ballsp,x
	sta	mm_sp
	km_sexvar	mmx_ballspx,x
	sta	mm_spx
	km_sexvar	mmx_ballspy,x
	sta	mm_spy
	km_loblda	mmx_balldx,x
	sta	mm_dx
	km_loblda	mmx_balldy,x
	sta	mm_dy
	km_loblda	mmx_balldxdy,x
	sta	mm_dxdy
	km_loblda	mmx_balldxdy,x
	sta	mm_dxdy
	km_loblda	mmx_ballcntx,x
;;	sta	mm_cntx
	km_loblda	mmx_ballcnty,x
;;;	sta	mm_cnty
	a8
	km_jsr	mm_2pointmove
	bcc	.skip
	km_clrflag.w	mmx_ballflags,1,x
.skip
	lda	mm_sx
	sta	mmx_ballsx,x
	lda	mm_sy
	sta	mmx_ballsy,x
	lda	mm_dxdy
	sta	mmx_balldxdy,x
;;;	lda	mm_cntx
	sta	mmx_ballcntx,x
;;	lda	mm_cnty
	sta	mmx_ballcnty,x
.end
	a16
	txa
	clc
	adc	#mmx_balllen
	tax
	sec
	sbc	mmh_sprballaddr
	a8
	cmp	#mmx_balllen*3
	km_bne	.LOOP
	plp
	rts
;=====================================================================
;*			Rotation Station			*
;=====================================================================
mm_rotstation
	shorta
	longi

	dec	mmx_stationtm
	bne	.notchange
	km_setval	mmx_stationtm,8
	km_addmaxtomin	mmx_stationanmptr,8,8*8,0
.notchange
	rts


;*********************************************************************
;*								*
;*		BG CGX & SCREEN SET				*
;*								*
;*********************************************************************
;---------------------------------------------------------------------
;*			Game Total Timer 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispgametotaltm
	a16
	lda	kw_MISSIONTIMER
	km_ramcpudivu16uf8	xy,100
				;Xreg (syou)	;100 no kurai
				;Yreg (amari)	:10&1 no kurai
	tya
	km_ramcpudivu16uf8	work,10
				;ksyou	;10 no kurai
				;kamari	:01 no kurai
;* Set Screen *
	a8
	ldy	#0
	txa				;100 second
	km_jsr	..setscrbuf_sub
	lda	ksyou			;10 second
	km_jsr	..setscrbuf_sub
	lda	kamari			;1 second
	km_jsr	..setscrbuf_sub

	rts
;---------------------------------------------
;* 	Sub Routine 			*
;* Init :
;  Acc :set suru Time Number			*
;* (CGX :b7.cgx)				*
;---------------------------------------------
	shorta
	longi
..setscrbuf_sub
	asl	a	;4 chara mode notame
	cmp	#$10	;suji ga 8 ijyou dattara syuusei suru
	bmi	..set
	clc
	adc	#$10
..set
	sta	mmx_SCRtensou+0,y	;hidari ue chara
	inc	a
	sta	mmx_SCRtensou+1,y	;migi ue chara
	clc
	adc	#$0f
	sta	mmx_SCRtensou+6,y	;hidari shita chara
	inc	a
	sta	mmx_SCRtensou+7,y	;migi ue chara

	iny	;next buffer pointer (ue buffer,shita buffer)
	iny
	rts
;---------------------------------------------------------------------
;*		DIVISION [unsign 16bit/unsign 8bit]		*
;* Init :Acc (warareru kazu), Xreg (waru kazu)			*
;* Exit :Xreg (syou) ,Yreg(amari)					*
;* a16,i16								*
;---------------------------------------------------------------------
ramdivu16u8_sub
	longa
	longi
	sta.l	wrdivl	;warareru kazu
	txa
	a8
	sta.l	wrdivb	;waru kazu
	a16
;* 16 cycle wait *
	nop	;2
	nop	;4
	nop	;6
	nop	;8
	nop	;10
	nop	;12
	nop	;14
	nop	;16

	lda.l	rddivlr		;syou
	tax
	lda.l	rdmpylr		;amari
	tay
	rts
;=====================================================================
;*			Palette Change				*
;* mem8 idx16							*
;*colptr_0	:color table pointer (step 32)				*
;*coladr_0	:color table address					*
;=====================================================================
mm_changecolpal
	shorta
	longi

	km_bitcheckscreenflag	bgcolpal	;[SCREEN FLAG]
	km_beq	.end
;--------------------------------------------------
;* colour timer set *
;* 3 GAME Flame ni 1 kai colour change *
	dec	coltimer_0
	bne	.NoColChange
	km_addstaval	colptr_0,32	;Pointer +32 add
	km_setval	coltimer_0,10	;Timer reset
.NoColChange
;--------------------------------------------------
	a16
	lda	colptr_0
	and	#$ff
	clc
	adc	#kx_palette2&WM
	sta	coladr_0	;address
.set_bank
	a8
	lda	#kx_palette2>>16
	sta	coladr_0+2	;bank
;--------------------------------------------------
.end
	rts

;*********************************************************************
;*								*
;*			Set Sprites				*
;* data bank :7e							*
;*********************************************************************
mm_dosprites
	shorta
	longi
	ldy	sprpointer
;* cursor *
	km_bitcheck	mmw_cursorflag,curf_hit
	bne	.hit
.nohit
	km_setspriteC4X	mmx_curposx
	km_setspriteC4Y	mmx_curposy

	km_mmsetspritesizedouble
	lda	mmx_curchar
	km_SetSpriteChrA	$48,colpal0,pri3,noflip,mm_obj_offset
	brl	.skipcursor
.hit
	km_lldx	mmx_curanmptr
	lda	mmx_curanmpat,x
	sta	kz_z1

	lda	mmx_curposX
	sec
	sbc	kz_z1
	sta	kz_x1

	lda	mmx_curposX
	clc
	adc	kz_z1
	sta	kz_x2

	lda	mmx_curposY
	sec
	sbc	kz_z1
	sta	kz_y1

	lda	mmx_curposY
	clc
	adc	kz_z1
	sta	kz_y2


	km_SetSpriteXY_ImOff	kz_x1,kz_y1,-17,-17
	km_SetSpriteChrVal	$8,colpal0,pri3,noflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x2,kz_y1,9,-17
	km_SetSpriteChrVal	$8,colpal0,pri3,xflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x1,kz_y2,-17,9
	km_SetSpriteChrVal	$8,colpal0,pri3,yflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x2,kz_y2,9,9
	km_SetSpriteChrVal	$8,colpal0,pri3,xyflip,mm_obj_offset

;* planet name *
	lda	KGameMapPtr
	cmp	#6
	km_bpl	.skipcursor
	ldx	#5		;planet name = 5 moji
	km_cpumultu8u8	x
	clc
	adc	#$E0
	sta	x1		;get name pointer

	km_SetSpriteXY_ImOff	mmx_curposX,mmx_curposY,-20,19
	km_SetSpriteChrVar	x1,0,colpal1,pri3,noflip,mm_obj_offset
	inc	x1
	km_SetSpriteXY_ImOff	mmx_curposX,mmx_curposY,-12,19
	km_SetSpriteChrVar	x1,0,colpal1,pri3,noflip,mm_obj_offset
	inc	x1
	km_SetSpriteXY_ImOff	mmx_curposX,mmx_curposY,-4,19
	km_SetSpriteChrVar	x1,0,colpal1,pri3,noflip,mm_obj_offset
	inc	x1
	km_SetSpriteXY_ImOff	mmx_curposX,mmx_curposY,4,19
	km_SetSpriteChrVar	x1,0,colpal1,pri3,noflip,mm_obj_offset
	inc	x1
	km_SetSpriteXY_ImOff	mmx_curposX,mmx_curposY,12,19
	km_SetSpriteChrVar	x1,0,colpal1,pri3,noflip,mm_obj_offset
.skipcursor
;---------------------------------------------------------------------
;* arwing *

	a8
	lda	mmx_arwingposx+1
	sec
	sbc	#$08
	sta	kz_x1

	lda	mmx_arwingposy+1
	sec
	sbc	#$08
	sta	kz_y1
;character Number & Att
	shortA
	km_mmsetspritesizedouble
;* X flip check *
;mmx_arwinganmptr = kuru kru pattern (16) pointer :0 ~ 15
	ldx	#0
	lda	mmx_arwinganmptr
	bit	#8		;pattern 8 ~ 15 check
	bne	.noflip1
	inx
.noflip1
	lda	p1_pilotNo
	and	#1
	asl	a		;0/1 ... Blue / Red Arwing 
;Xreg =0/1 ... noflip / flip
	dex
	bne	.noflip2
	clc
	adc	#obj_xflip_h
.noflip2
	clc
	adc	#obj_pri3_h
	sta	kwork


	km_SetSpriteX	kz_x1
	km_SetSpriteY	kz_y1
	lda	kwork
	km_SetSpriteAtt		0,mm_obj_offset
;---------------------------------------------------------------------
;* ball *
	ifeq	1
	a8
	ldx	mmh_sprballaddr
.LOOP_BALL
	lda.w	mmx_ballsx,x
	km_SetSpriteX

	lda.w	mmx_ballsy,x
	km_SetSpriteY

	km_SetSpriteChrVal	9,colpal0,pri3,noflip,mm_obj_offset

	a16
	txa
	clc
	adc	#mmx_balllen
	tax
	sec
	sbc	mmh_sprballaddr
	a8
	cmp	#mmx_balllen*3
	km_bne	.LOOP_BALL
	endc
;---------------------------------------------------------------------
;* station *
	a16
	lda	mmx_stationanmptr
	and	#$ff
	clc
	adc	mmh_sprstationaddr
	tax

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$0e*8,$9*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$10*8,$9*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$0e*8,$b*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$10*8,$b*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx
	a8

;* mother ship *
	km_mmsetspritesizedouble
	SetSprXYChr_Im	(mothercx-8),(mothercY-8),motherchr,colpal0,pri3,noflip,mm_obj_offset

;---------------------------------------------------------------------
;* enemy *
	km_jsr	mm_Setsprenemy
;---------------------------------------------------------------------
	sty	sprpointer
	rts


;=====================================================================
;*		Set Spites Size		[double buffer]		*
;=====================================================================
mm_SetSprSize_double_sub
	ai16
	tya
	cmp	#(128*4)+(128/4)
	bmi	.buf1		;if < (128*4+128/4) THEN write buffer 1
.buf2
	sec
	sbc	#(128*4)+(128/4)
	km_shiftRUA2		;oam (*0,*4,*8,*c)---->(*0,*1,*2,*3)
	pha
	and	#$0003
	tax			;loop counter

	pla
	km_shiftRUA2	;oam (*0,*16,*32,*48)---->(*0,*1,*2,*3)
	clc
	adc	#(128*4)+(128/4)
	tay			;set sprite sub pointer
	bra	.SET
.buf1
	km_shiftRUA2	;oam (*0,*4,*8,*c)---->(*0,*1,*2,*3)
	pha
	and	#3
	tax
	pla
	km_shiftRUA2	;oam (*0,*16,*32,*48)---->(*0,*1,*2,*3)
	tay		;sprites sub pointer (0,1,2,3,..,31)
.SET
	a16
	txa
	clc
	adc	mmh_sprsizeaddr
	tax
	a8
	lda.w	heap,x
	ora	sprites_sub,y
	sta	sprites_sub,y
	rts
;---------------------------------------------------------------------
;*** PORGRAM END ****
heap_runmarioEnd_l
;---------------------------------------------------------------------
heap_proglen	equ	heap_runmarioEnd_l-heap_runmariostart_l


;*****************************************************************************
;*									*
;*			Data Tables			[ROM DATA]	*
;*									*
;*****************************************************************************
;=====================================================================
;*		Planet Infomation Data 				*
;=====================================================================
;****** Planet Info Data *******
planetdata
;(CX,CY,R,msprite pointer,shadow rotx,shadow rotz)
	dw	$10,$10,$0c,planet1_spr,$2000,$c000	;9800
planetdataend
	dw	$10,$10,$0c,planet2_spr,$2000,$4000
	dw	$10,$10,$0a,planet3_spr,-$1800,$c000	;$d800
	dw	$10,$10,$0c,planet4_spr,-$1800,$c000
	dw	$10,$10,$0f,planet5_spr,-$1800,$4000

	km_datalen	planetdata
;---------------------------------------------------------------------
;*		Collision List					*
;---------------------------------------------------------------------
mm_col_list
;(CX,CY,R,planet No)
	db	mm_planet1x,mm_planet1y,16,0	;planet 1
	db	mm_planet2x,mm_planet2y,16,1	;planet 2
	db	mm_planet3x,mm_planet3y,16,2	;planet 3
	db	mm_planet4x,mm_planet4y,16,3	;planet 4
	db	mm_planet5x,mm_planet5y,16,4	;planet 5
	db	mm_planet6x,mm_planet6y,16,5	;planet 6
mm_col_listend
	km_datalen	mm_col_list

;=====================================================================
;*								*
;*		Sprites Data Tables				*
;*								*
;=====================================================================
mm_sprstation
;* station 0 *
	SprChrDataB	$a0,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$a0,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$c0,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$c0,colpal3,pri3,xflip,mm_obj_cgx
;* station 1 *
	SprChrDataB	$a2,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$a4,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$c2,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$c4,colpal3,pri3,noflip,mm_obj_cgx
;* station 2 *
	SprChrDataB	$a6,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$a8,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$c6,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$c8,colpal3,pri3,noflip,mm_obj_cgx
;* station 3 *
	SprChrDataB	$aa,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$ac,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$ca,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$cc,colpal3,pri3,noflip,mm_obj_cgx
;* station 4 *
	SprChrDataB	$ae,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$ae,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$ce,colpal3,pri3,noflip,mm_obj_cgx
	SprChrDataB	$ce,colpal3,pri3,xflip,mm_obj_cgx
;* station 5 *
	SprChrDataB	$ac,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$aa,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$cc,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$ca,colpal3,pri3,xflip,mm_obj_cgx
;* station 6 *
	SprChrDataB	$a8,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$a6,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$c8,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$c6,colpal3,pri3,xflip,mm_obj_cgx
;* station 7 *
	SprChrDataB	$a4,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$a2,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$c4,colpal3,pri3,xflip,mm_obj_cgx
	SprChrDataB	$c2,colpal3,pri3,xflip,mm_obj_cgx

mm_sprstationEND
	km_datalen	mm_sprstation
;--------------------------------
;*  Arwing Angle Pattern Data   *
;--------------------------------
mm_sprarwing
;obj No
	db	$20,$e,$c,$a
	db	$8,$6,$4,$2
	db	$0,$2,$4,$6
	db	$8,$a,$c,$e

	db	$42,$40,$2e,$2c
	db	$2a,$28,$26,$24
	db	$22,$24,$26,$28
	db	$2a,$2c,$2e,$40

	db	$64,$62,$60,$4e
	db	$4c,$4a,$48,$46
	db	$44,$46,$48,$4a
	db	$4c,$4e,$60,$62

mm_sprarwingEND
	km_datalen	mm_sprarwing


;****************************************************************************
;****************************************************************************
;
;			Not Using Area
;****************************************************************************
;****************************************************************************
;*** Arwing Move Calc ***
	IFEQ	1
;* calc DX *
	a16
	lda	mmx_arwingposx
	and	#$ff
	sta	kz_x1

	lda	mmx_destposX
	and	#$ff
	sec
	sbc	kz_x1
	sta	mmx_arwingdx
	bmi	.decx
.incx
	km_setval	mmx_arwingmovx,1
	bra	.skip_dx
.decx
	km_setval	mmx_arwingmovx,-1
.skip_dx

;* calc DY *
	lda	mmx_arwingposy
	and	#$ff
	sta	kz_x1

	lda	mmx_destposY
	and	#$ff
	sec
	sbc	kz_x1
	sta	mmx_arwingdy
	eor	mmx_arwingdx
	bmi	.minusdydx
.plasdydx
	lda	mmx_arwingmovx
	bmi	.minusmovy
.plasmovy
	km_setval	mmx_arwingmovy,1
	bra	.skip2
.minusmovy
	km_setval	mmx_arwingmovy,-1

	bra	.skip2
.minusdydx
	lda	mmx_arwingmovx
	bmi	.plasmovy
	bra	.minusmovy
.skip2
	km_absstavar	mmx_arwingdx
	km_absstavar	mmx_arwingdy
	stz	mmx_arwingH
;---------------------------------------------------
.playermove
	lda	mmx_arwingdx
	sec
	sbc	mmx_arwingdy
	bmi	.addy
;-----------------------------------------
;dx > dy
.addx
	km_addstavar	mmx_arwingposx,mmx_arwingmovX
	lda	mmx_arwingH
	clc
	adc	mmx_arwingdy
	cmp	mmx_arwingdx
	bmi	.noaddy

	pha
	km_addstavar	mmx_arwingposy,mmx_arwingmovy
	pla

	sec
	sbc	mmx_arwingdx
.noaddy
	sta	mmx_arwingH
	bra	.endcheck
;-----------------------------------------
;dy > dx
.addy
	km_addstavar	mmx_arwingposy,mmx_arwingmovY
	lda	mmx_arwingH
	clc
	adc	mmx_arwingdx
	cmp	mmx_arwingdy
	bmi	.noaddx

	pha
	km_addstavar	mmx_arwingposx,mmx_arwingmovx
	pla

	sec
	sbc	mmx_arwingdy
.noaddx
	sta	mmx_arwingH
;-----------------------------------------
.endcheck
	a8
	lda	mmx_arwingposx
	cmp	mmx_destposX
	bne	.end
	lda	mmx_arwingposy
	cmp	mmx_destposY
	bne	.end
	km_setflag	mmw_ok,7
;-----------------------------------------
	ENDC

;---------------------------------------------------------
;* kawaguchi ga tukutta enmy List free area get program  *
;---------------------------------------------------------
	ifeq	1
	ldx	kw_enlistptr
	bne	.lastcheck
;* fast enemy *
	ldx	#kx_enemylist&WM
	stx	kw_enlistptr
	brl	.setparams

;* enemy list last pointer search *
.lastcheck
	lda.w	mmx_ennext,x
	beq	.foundlast
	tax
	bra	.lastcheck
.foundlast
	txy
	inc	a
	sta.w	mmx_ennext,x

;* blank list search *
	ldx	kw_enlistptr
.checkblank
	lda.w	mmx_ennext,x
	beq	.foundblank
	txa
	clc
	adc	#mmx_len
	tax
	bra	.checkblank
.foundblank
	txa
	sta.w	mmx_ennext,y
	endc

;----------------------------------------------
;* kawaguchi ga tukutta enmy free program *
;----------------------------------------------
	ifeq	1
	ldy	kw_enlistptr
	ldx	kx_SOSEnemyptr
	cpy	kx_SOSEnemyptr
	beq	.loop

	lda.w	mmx_ennext,y
	bne	.check1
	stz	kw_enlistptr
	bra	.end
.check1
	lda.w	mmx_ennext,x
	sta	kw_enlistptr
	bra	.end
;----------------------------------------------
.loop
	lda.w	mmx_ennext,y
	cmp	kx_SOSEnemyptr
	beq	.found
	tay
	bra	.loop
.found
	lda.w	mmx_ennext,x
	sta.w	mmx_ennext,y
;----------------------------------------------
	endc




mm_blink
	kbug1
	blink
