;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         SOUND.ASM                              	       ;
; AUTHOR:       YASUHIRO KAWAGUCHI                                  ;
; DESCRIPTION:  Code for sound                        	       ;
; DATE CREATED: 28-7-93                                             ;
;                                                                   ;
;-------------------------------------------------------------------;

	INCPUB	sound

;TransferSoundProg_l,TransferSoundBGM_l,TransferSoundPlayer_l
;*********************************************************************
;*			Initial Sound 				*
;*	Sound Transfer						*
;*Acc  :Sound Data Bank						*
;*Yreg :Sound Data Address						*
;*********************************************************************
;=====================================================================
;*		Sound Program Transfer				*
;*Data Bank 0							*
;*Input:Acc	:sound data bank					*
;*     ;Yreg	:sound data address					*
;=====================================================================
TransferSoundProg_l
	shorta
	longi
	phb
	pha
	phx
	phy
	php

	km_db0				;Acc Keep
	jsl	sbootapu_l		;sound transfer

	plp
	ply
	plx
	pla
	plb
	rtl
;=====================================================================
;*								*
;*	Transfer Sound BGM Data & Ring BGM			*
;*Data Bank0								*
;*Input:								*
;*	:Xreg :sound table pointer				*
;=====================================================================
TransferSoundBGM_l
	shorta
	longi

	km_PushAllReg
	db0		;Data Bank 0

	a16
;* port2 initial (16 bit mode) *
	stz	sdchkptr2	;check alien pointer
	stz	sdchkptr2tmp	;tmp check alien pointer
	stz	sdbakptr2	;back alien pointer

;* port3 initial (16 bit mode) *
	stz	sdgpt3	;(sdgpt3 ... SOUND DATA wo SET surutameno POINTER)
	stz	sdspt3	;(sdspt3 ... SOUND DATA wo buffer ni touroku suru tameno POINTER)

;* port2 (8 bit mode) *
	a8
	stz	sdport2		;sound port 2
	stz	sdport2tmp	;tmp sound port 2
	stz	sdbakport2	;back sound port 2

	stz	sdchkno2	;check sound No
	stz	sdchkno2tmp	;tmp check sound No
	sta	sdbakno2	;back sound No
;* port 3 (8 bit mode) *
	stz	sdpck3	;(sdpck3 ... before sound)

;***************** Game Mode Sound Transfer *********************
;* Sound Flag (MISSION/BATTLE) *
	shorta
	km_bitcheckgameflag	battle
	bne	.snd_bat
.snd_mis
	Ksound	mission_mode
	bra	.snd_skip
.snd_bat
	Ksound	battle_mode
.snd_skip

;* BGM No Set *
	a8
	ldx	kw_setsndaddr
	lda.l	SoundTransTbl+0,x
	km_beq	.NoTransBGM	;No Sound Data Transfer

	lda.l	SoundTransTbl+1,x	;sound flag (port0)
	pha
	and	#$f
	KBGM_a				;BGM set
	pla

;* Place Flag Set *
	km_shiftrua4			;(space,room,ground,sea)
	clc
	adc	#ksf_baseplace		;place flag set	:port3
	a16
	km_loba
	sta	bgm_place
	ksound_a

;* Normal Stage Sound Transfer *
	lda.l	SoundTransTbl+0,x
	km_loba
	tay		;sound data transfer counter
	a8
.soundtrans
	phy
	a16	
	lda.l	SoundTransTbl+2,x
	tay				;address
	a8
	lda.l	SoundTransTbl+4,x	;bank
	jsl	Initial_sound_l
	ply
	inx
	inx
	inx
	dey
	bne	.soundtrans
;* Special Sound Transfer *
	a16
	km_lldaslx	ksoundmapptr	;Sound Data Soutai Address Get
	lda.l	SoundSpecialAddrTbl,x
	tax		;Sound Data Table Pointer 
	km_loblda.l	SoundSpecialTransTbl+0,x
	beq	.NoTransBGM
	tay		;counter
.soundtrans2
	phy
	a16
	lda.l	SoundSpecialTransTbl+1,x
	tay					;address
	a8
	lda.l	SoundSpecialTransTbl+3,x	;bank
	jsl	Initial_sound_l
	ply
	inx
	inx
	inx
	dey
	bne	.soundtrans2
;----------------------------------------------------
.NoTransBGM
	km_PullAllReg

	rtl

;=====================================================================
;*								*
;*		Player Sound SE Transfer			*
;* Data Bank 0							*
;=====================================================================
TransferSoundPlayer_l
	shorta
	longi
	km_PUSHAllReg
	db0
;-------------------------------------------------------------------------
;*** Pilot Type Check ****
;* player1 *
	lda	p1_pilotNo
	sta	kw_plsndptr
	jsr	TransPlSnd_sub
;* player2 *
	ldx	#partchar_start
	stx	kw_sndhenkouaddr
	lda	p2_pilotNo
	sta	kw_plsndptr

	km_setsndflag	addrchange
	jsr	TransPlSnd_sub
	km_clrsndflag	addrchange
;------------------------------------------------------------------------
;*** Arwing Type Check ****
	km_bitcheck_arwingtype	1,GG
	bne	.mis_GG
	km_bitcheck_arwingtype	1,SP
	bne	.mis_SP
.mis_FF
	KSoundTrans	FFset1
	bra	.skip
.mis_SP
	KSoundTrans	SPset1
	bra	.skip
.mis_GG
	KSoundTrans	GGset1
;----------------------------------------------
;* battle mode ka check suru ? *
.skip
	km_bitcheckgameflag	battle
	km_beq	.end

	km_bitcheck_arwingtype	2,GG
	bne	.bat_GG
	km_bitcheck_arwingtype	2,SP
	bne	.bat_SP
.bat_FF
	KSoundTrans	FFset2
	bra	.end
.bat_SP
	KSoundTrans	SPset2
	bra	.end
.bat_GG
	KSoundTrans	GGset2
.end
	km_PULLAllReg
	rtl
;---------------------------------------------------------------------
;*		Transfer PLayer Sound Sub routine		*
;* Input :kw_plsndptr (0~12)						*
;---------------------------------------------------------------------
TransPlSnd_sub
	a16
	km_multvar3	kw_plsndptr,x
	lda.l	plsndtbl,x
	tay
	a8
	lda.l	plsndtbl+2,x
	jsl	Initial_sound_l	;transfer sound data to APU 

	rts
plsndtbl
	dl	foxvox
	dl	falvox
	dl	pepvox
	dl	slpvox
	dl	ga1vox
	dl	ga2vox

;=====================================================================
;*		 Sound Data Transfer				*
;* INPUT	: Data Bank 0						*
;*	: Acc,Yreg:(sound address)				*
;* OUTPUT	:							*
;*	:X reg ha sonomama kaesu				*
;=====================================================================
Initial_sound_l

	shorta
	longi
	phb
	pha
	phx
	phy
	php
;---------------------------------------------------------------------
	pha
		lda	#kbgm_soundtrans
		sta	apu_port0	;tensou start :port 0 <--- $0F
	pla

	jsl	sbootapu_l	;sound transfer

;--------------------------------
;* sound rady check *
	KSoundTransWait
;--------------------------------
;---------------------------------------------------------------------
	plp
	ply
	plx
	pla
	plb
	rtl

;=====================================================================
;*			STEREO MONORAL 				*
;=====================================================================
Stereo_l
	shorta
	longi
	bne	.monoral
.stereo
	ksound	stereo
;;;	KBGM	stereo
	bra	.end
.monoral
	ksound	monoral
;;;	KBGM	monoral
.end
	rtl
;=====================================================================
;*		Set BGM (port 0) Data				*
;=====================================================================
	ifeq	1
SetBGM_l
	shorta
	longi
	phx
	phy
;----------------------------------------------------
;----------------------------------------------------
.NoTransBGM
	ply
	plx
	rtl
	endc

	ifeq	1
;*** Game Mode [Mission /Battle] ****
	km_ldxgamemode
	lda.l	bgmmodetable,x
	sta	bgm_music	;geme mode (mission / battle) b7 (0/1)

;*** Sound,Game Stage [Ground/Sea/Space] ***
	i8
	lda.l	kgamemap
	tax
	lda.l	bgmsoundtable,x
	ora	bgm_music
	sta	bgm_music	;sound No set
	i16

	lda	bgm_music
	and	#%00110000
	cmp	#%00110000
	bne	.NoSoundTrans

	ksoundtrans	sound1
	endc

;=====================================================================
;*		Sound boot loader				*
;* INPUT :								*
;* Data Bank 0							*
;* Yreg :sound initial addres					*
;* Acc  :sound initial bank						*
;=====================================================================
;-----------------------------------------------------------------------
;Sound_program(sound_address)
;		DW	04000H			;count
;		DW	08000H			;address
;		DB	0A9H,000H,.......	;data
;		 |
;		DW	04000H			;count
;		DW	0C000H			;address
;		DB	000H,........		;data
;		 |
;		DW	00000H			;end
;-----------------------------------------------------------------------
		SHORTA
		LONGI
SbootAPU_l
;SOUND Data Address = (bank)(00)(00),y
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		STA	address+2	;B	:bank
		ldx	#0	
		stx	address+0	;base address <--- 0
;Yreg :Active address
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDX	#$BBAA		;W
boot_initial		CPX	apu_port0	;W
		BNE	boot_initial
		LDA	#0CCH		;B
		BRA	boot_entry1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_repeat		JSR	get_data
		XBA
		LDA	#0		;B
		BRA	boot_entry2
boot_loop		XBA			;	:2 cycle=36+7n
		JSR	get_data	;B	
		XBA			;	:2 cycle
boot_wait1		CMP	apu_port0	;B	:4 maximam responce=17
		BNE	boot_wait1	;	:2/3 cycle
		INC	A		;B	:2 cycle
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_entry2
		A16			;2
		STA	apu_port0	;W	;5 cycle
		A8			;2
		DEX			;W	;2 cycle
		BNE	boot_loop		;3/2 cycle
boot_wait2		CMP	apu_port0	;W
		BNE	boot_wait2
boot_zero		ADC	#3		;B
		BEQ	boot_zero
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_entry1	PHA				;>
		JSR	get_data
		XBA
		JSR	get_data
		XBA
		TAX			;W-->W :counter
;**** kairyou (94/2/23)****
		km_bitchecksndflag	addrchange
		bne	.addrhenkou
		JSR	get_data	;dummy address (l) get
		STA	apu_port2	;	:address (l)
		JSR	get_data	;dummy address (h) get
		STA	apu_port3	;W	:address (h)
		bra	.skip
.addrhenkou
		JSR	get_data	;get dummy address data
		JSR	get_data	;get dummy address data

		lda	kw_sndhenkouaddr
		STA	apu_port2	;	:address (l)
		lda	kw_sndhenkouaddr+1
		STA	apu_port3	;W	:address (h)
.skip
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		CPX	#1		;W
		LDA	#0		;B
		ROL	A		;B
		STA	apu_port1	;B (1)or(0)
		ADC	#07FH		;B CLC
	PLA				;<
		STA	apu_port0	;B
boot_wait3		CMP	apu_port0	;B
		BNE	boot_wait3
		BVS	boot_repeat	

	RTL
;-----------------------------------------------------------------------
	SHORTA
	LONGI
get_data		LDA	[address],Y	;W	; data count
		INY			;W
		BNE	get_exit
		INC	address+2	;B (bank)

		LDY	#$8000		;W
get_exit	RTS

;-----------------------------------------------------------------------
;***  END FILE ***
;-----------------------------------------------------------------------

	incfile	sndtbl.asm
	
