;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         WINDOWS.ASM                                         ;
; AUTHOR:       Yasuhiro Kawaguchi                                  ;
; DESCRIPTION:  Window hdmatabs set                                 ;
; DATE CREATED: 23-6-94                                             ;
;                                                                   ;
;-------------------------------------------------------------------;
; colour windows
	
	incpub	windows

;initblack_l,setblack_l,setwindowtabs_l
;Check_KGwindow_l
;=====================================================================
;*								*
;*			MACRO Definition			*
;*								*
;=====================================================================
;---------------------------------------------------------------------
;*		MISSION Parameters				*
;---------------------------------------------------------------------
SetMissWinStates	macro	[player,obj1]
MYNARG	=	NARG
	CHK_NARG	2

	shorta
	longi
;* player heap pointer & player flag*
	km_plheapptr	{player},{obj1}

	lda	#{player}
	lsr	a	
	sta	kplayer

;* Bom Circle Center (X,Y) *
	a16
	lda	#$80
	sta	kcircleCX
	lda	#$80
	sta	kcircleCY
	a8
	endm
;---------------------------------------------------------------------
;*		Cockpit Parameters				*
;---------------------------------------------------------------------
SetBattWinStates	macro	[player,obj1]
MYNARG	=	NARG
	CHK_NARG	2
tmp_p1	=	0
tmp_p2	=	1

	shorta
	longi
;* player heap pointer & player flag*
	km_plheapptr	{player},{obj1}

	lda	#{player}
	lsr	a	
	sta	kplayer

;* Bom Circle Center (X,Y) *
	ifeq	tmp_p{player}
;--- player 1 ---
	a16
	lda	#$68
	sta	kcircleCX
	lda	#$40
	sta	kcircleCY
	a8
	elseif
;--- player 2 ---
	a16
	lda	#$98
	sta	kcircleCX
	lda	#$a8
	sta	kcircleCY
	a8
	endc
	endm

;*********************************************************************
;*								*
;*			WINDOWS					*
;* Data Bank 7e							*
;* X reg :player pointer						*
;*								*
;*********************************************************************
setwindowtabs_l
	km_PushAllReg
	a8i16
	db7e

	km_bitcheckgameflag	battle
	bne	.twoscreen
;---------------------------------------------------------------------
.onescreen
	SetMissWinStates	1,x
	jsr	SetCockpitWindow
	bra	.end
;---------------------------------------------------------------------
.twoscreen
	SetBattWinStates	1,x
	jsr	SetCockpitWindow

	SetBattWinStates	2,x
	jsr	SetCockpitWindow
;---------------------------------------------------------------------
.end
	km_PullAllReg
	rtl

;=====================================================================
;*		Set h-dma tabs (window) 			*
;* Data Bank 7e							*
;* X reg :player pointer						*
;=====================================================================
SetCockpitWindow
	shorta
	longi

;* set double buffer pointer *
	a16
	km_setval	kz_x1,0		;repeat
	km_setval	kz_x2,0		;no repeat

	km_bitcheckscreenflag	windowwbuf
	beq	.buffer1
.buffer2
	km_setval	kz_x1,htflbuflen/2	;repeat
	km_setval	kz_x2,circbuflen/2	;no repeat
.buffer1
	a8
;* h-dma table data bank *
	km_setval	kz_tempaddrl+2,$7e

;* Ring Out Window *
	jsr	RingOutWindow
;* Hit Flash Window *
	jsr	HitFlashWindow
;* Bom Circle Window *
	jsr	CircleWindow
	rts

;---------------------------------------------------------------------
;*			Ring Out Window				*
;* Data Bank 7e							*
;* Xreg : window work pointer					*
;* Yreg : HDMA table pointer ,player pointer				*
;* KHDMATbl	macro [reg,val,left,right,table name]			*
;---------------------------------------------------------------------
RingOutWindow
	php
	shorta
	longi
	phx
	km_jmpnotflag	KRingOutTimer,KROutFlag,RingOutWindowOff,x
	stx	kpointer		;kpointer <--- Player Work

	a16
	lda	#xhdma_outhofs&WM
	clc
	adc	kz_x1
	sta	kz_tempaddrl
;---------------------------------------------------------------------------
	test_screenmode	onescreen
	bne	.onescreenmode
	jmp	.twoscreenmode
.onescreenmode
;* window table address set *
	alloc_window	outofbounds,1	; x = outofbounds

	lda	kz_tempaddrl
	sta	wm_hdma,x		;HDMA Table Set

	alloc_window	outofbounds,2	; x = outofbounds
	lda	kz_tempaddrl
	inc	a
	inc	a
	sta	wm_hdma,x		;HDMA Table Set

	ldy	#0			;HDMA Table Pointer
	km_sethdmatabs_reptwin	mission,MissHtflSta,MissHtflEnd
	alloc_window	outofbounds,1	; x = outofbounds
	bra	.SetRegister
.twoscreenmode
	lda	kplayer
	and	#1
	bne	.player2

	alloc_window	outofbounds,1	; x = outofbounds
	lda	kz_tempaddrl
	sta	wm_hdma,x		;HDMA Table Set

	ldy	#0			;HDMA Table Init Pointer
	km_sethdmatabs_reptwin	battle,P1HtFlXSta,P1HtFlXEnd
	bra	.skip
.player2
	alloc_window	outofbounds,2	; x = outofbounds
	lda	kz_tempaddrl
	INC	A
	INC	A
	sta	wm_hdma,x		;HDMA Table Set
	ldy	#2			;HDMA Table Init Pointer
	km_sethdmatabs_reptwin	battle,P2HtFlXSta,P2HtFlXEnd
.skip
;============ Window Register Para Set ===============
.SetRegister
	a8
	ldy	kpointer	;Yreg <--- Plyer Work Pointer

	lda	#0
	sta	wm_w12sel,x	;2123h
	sta	wm_w34sel,x	;2124h

	lda	#$00000011
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#%00010000
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#%10000011
	sta	wm_cgadsub,x	;2131h	;col sub (bg1,bg2)

	ifeq	0
	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#%11100000
	sta	wm_coldata,x	;2132h	;Red Blue Green
	endc

	ifeq	1
	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$20
	sta	wm_coldata_r,x	;2132h	;Red

	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$40
	sta	wm_coldata_g,x	;2132h	;Green

	lda.w	kringouttimer,y
	eor	#$ff
	and	#$0f
	ora	#$80
	sta	wm_coldata_b,x	;2132h	;Blue
	endc

	lda	wm_flags,x
	ora	#wf_datarepeat
	sta	wm_flags,x		;repeat flag on

	lda	#xhdma_outhofs>>16
	sta	wm_hdma+2,x	;4304h	:hdma table address

	lda	#$20
	sta	wm_wobjsel,x	;2125h :window mask
	lda	#$0c
	sta	wm_wobjlog,x	;212bh :windoe logic
	lda	#$41
	sta	wm_chparams,x	;4350h :channel parameter set

	jmp	RingOutWindowEnd

RingOutWindowOff
	shorta
	test_screenmode	onescreen
	beq	.battle		;If Cockpit Display

.mission	dealloc_window	outofbounds,1	;if Hit Flash Window End
	dealloc_window	outofbounds,2	;if Hit Flash Window End
	bra	RingOutWindowEnd

.battle	lda	kplayer
	bne	.player2
	dealloc_window	outofbounds,1	;if Ring Out Window End
	bra	RingOutWindowEnd
.player2
	dealloc_window	outofbounds,2	;if Ring Out Window End
RingOutWindowEnd
	plx
	plp
	rts
;---------------------------------------------------------------------
;*			Hit Flash Window			* 
;* Init,Exit Memory Mode :mem8,idx16					*
;* Data Bank 7e							*
;* Xreg : window work pointer					*
;* Yreg : HDMA table pointer 					*
;---------------------------------------------------------------------
HitFlashWindow
	shorta
	longi

	phx
;	s_jmp_alvarzero		B,x,exal_nohit,HitFlashWindowOff
;	s_jmp_alvarAND		B,x,exal_nohit,#exal_nohit_scrsplash,.Parameter

	s_jmpnot_alvarAND	B,x,exal_nohit,#exal_nohit_scrflash,HitFlashWindowOff
	stx	kpointer	;kpointer <--- Player Work
.Parameter
	a16
	lda	#xhdma_htflhofs&WM
	clc
	adc	kz_x1
	sta	kz_tempaddrl
;---------------------------------------------------------------------------
	test_screenmode	onescreen
	bne	.onescreenmode		;If battle mode
	jmp	.twoscreenmode
.onescreenmode
	alloc_window	hitflash,1	; x = hitflash
	lda	kz_tempaddrl
	sta	wm_hdma,x		;HDMA Table Set

	alloc_window	hitflash,2	; x = hitflash
	lda	kz_tempaddrl
	inc	a
	inc	a
	sta	wm_hdma,x		;HDMA Table Set

	ldy	#0			;HDMA Table Pointer
	km_sethdmatabs_reptwin	mission,MissHtflSta,MissHtflEnd
	alloc_window	hitflash,1	; x = hitflash
	bra	.SetRegister
;---------------------------------------------------------------------------
.twoscreenmode
	lda	kplayer
	and	#1
	bne	.player2
	alloc_window	hitflash,1	; x = hitflash

	lda	kz_tempaddrl
	sta	wm_hdma,x		;HDMA Table Set
	ldy	#0			;HDMA Table Init Pointer
	km_sethdmatabs_reptwin	battle,P1HtFlXSta,P1HtFlXEnd
	bra	.skip

.player2
	alloc_window	hitflash,2	; x = hitflash
	lda	kz_tempaddrl
	INC	A
	INC	A
	sta	wm_hdma,x		;HDMA Table Set
	ldy	#2			;HDMA Table Init Pointer
	km_sethdmatabs_reptwin	battle,P2HtFlXSta,P2HtFlXEnd
.skip
;============ Window Register Para Set ===============
.SetRegister
	a8
	ldy	kpointer		;kpointer <--- Player Work

	lda	#0
	sta	wm_w12sel,x	;2123h
	sta	wm_w34sel,x	;2124h

	lda	#00000011b
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#00010000b
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#00000011b
	sta	wm_cgadsub,x	;2131h	;bg1 bg2

;;	lda	#$03f
	lda.w	exal_addcol_r,y
	sta	wm_coldata_r,x	;2132h	;Red

;;	lda	#$40
	lda.w	exal_addcol_g,y
	sta	wm_coldata_g,x	;2132h	;Green

;;	lda	#$84
	lda.w	exal_addcol_b,y
	sta	wm_coldata_b,x	;2132h	;Blue

	km_SetRepeatFlag	x		;HDMA Data Repeat Flag on

	lda	#xhdma_htflhofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address

	lda	#$20
	sta	wm_wobjsel,x	;2125h :window mask
	lda	#$0c
	sta	wm_wobjlog,x	;212bh :windoe logic
	lda	#$41
	sta	wm_chparams,x	;4350h :channel parameter set
	jmp	HitFlashWindowEnd

HitFlashWindowOff
	test_screenmode	onescreen
	beq	.battle		;If Cockpit Display

.mission	dealloc_window	hitflash,1	;if Hit Flash Window End
	dealloc_window	hitflash,2	;if Hit Flash Window End
	bra	HitFlashWindowEnd

.battle	lda	kplayer
	bne	.player2
	dealloc_window	hitflash,1	;if Hit Flash Window End
	bra	HitFlashWindowEnd
.player2
	dealloc_window	hitflash,2	;if Hit Flash Window End
HitFlashWindowEnd
	plx

	rts

;---------------------------------------------------------------------
;*			Circle Window				* 
;* Data Bank 7e							*
;* X reg :player work pointer,circle radius	pointer			*	 
;---------------------------------------------------------------------
CircleWindow
	shorta
	longi
	phx
	phy

	km_jmpnotflag	KBOMSHOT,kBomShotFlag,CircleWindowOFF,x

;------- Cilcle calculate (H-DMA tabs data) --------
	a16
	lda	KBOMSHOT,x
	and	#$7f
	asl	a
	tax

	a8
	POLL_MARIO
	a16
	lda	kcircleCX
	sta.l	m_bigx		;center X
	lda	kcircleCY
	sta.l	m_bigy		;center Y
	lda.l	CircleData+2,x
	sta.l	m_rotx		;Radius
	call_mario	mcalc_circle	;Circle (L,R) data calc
;**** Set H-DMA Table Data ****
	lda	#xhdma_circhofs&WM
	clc
	adc	kz_x2
	sta	kz_tempaddrl
;---------------------------------------------------------------------------
	test_screenmode	onescreen
	bne	.onescreenmode		;If battle mode
	jmp	.twoscreenmode
.onescreenmode
	alloc_window	circle,1	; x = circle
	lda	kz_tempaddrl
	sta	wm_hdma,x		;HDMA Table Set

	alloc_window	circle,2	; x = circle
	lda	kz_tempaddrl
	clc
	adc	#circbuflen/4
	sta	wm_hdma,x		;HDMA Table Set

	ldy	#0			;HDMA Table Pointer
	km_sethdmatabs_circwin	MissWinLine*2,MissWinXSta,MissWinXEnd,MissWinYSta
	alloc_window	circle,1	; x = circle
	jmp	.SetRegister
;---------------------------------------------------------------------
.twoscreenmode
	longa
	longi
	lda	kplayer
	and	#$ff
	beq	.player1
	jmp	.player2
.player1
	alloc_window	circle,1	; x = cilcle window
	lda	kz_tempaddrl
	sta	wm_hdma,x

	ldy	#0
	km_sethdmatabs_circwin	P1WinLine,P1WinXSta,P1WinXEnd,P1WinYSta
	bra	.SetRegister
.player2
	alloc_window	circle,2	; x = cilcle window
	lda	kz_tempaddrl
	clc
	adc	#circbuflen/4
	sta	wm_hdma,x		;HDMA Table Set

	ldy	#circbuflen/4
	km_sethdmatabs_circwin	P2WinLine,P2WinXSta,P2WinXEnd,P2WinYSta
;============ Window Register Para Set ===============
.SetRegister
	a8
	UNPOLL_MARIO

	lda	#0
	sta	wm_w12sel,x	;2123h
	sta	wm_w34sel,x	;2124h

	lda	#00000011b
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#00010000b
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#00000011b
	sta	wm_cgadsub,x	;2131h	;bg1 bg2

	lda	#$3f
	sta	wm_coldata_r,x	;2132h	;Red

	lda	#$45
	sta	wm_coldata_g,x	;2132h	;Green

	lda	#$9f
	sta	wm_coldata_b,x	;2132h	;Blue

	lda	#xhdma_circhofs>>16
	sta	wm_hdma+2,x	;4304h		:hdma table address

	lda	#$20
	sta	wm_wobjsel,x	;2125h :window mask
	lda	#$0c
	sta	wm_wobjlog,x	;212bh :windoe logic
	lda	#$41
	sta	wm_chparams,x	;4350h :channel parameter set
	jmp	CircleWindowEND

CircleWindowOFF
	test_screenmode	onescreen
	beq	.battle			;If Cockpit Display

.mission	dealloc_window	circle,1	;if Hit Flash Window End
	dealloc_window	circle,2	;if Hit Flash Window End
	bra	CircleWindowEnd

.battle	lda	kplayer
	bne	.p2
	dealloc_window	circle,1
	bra	CircleWindowEND
.p2
	dealloc_window	circle,2
;---------------------------------------------------------------------------
CircleWindowEND
	ply
	plx
	rts

;=============================================================
;*		HDMA CILCLE SUBROUTINE			*
;* Data Bank :7e						*
;* X reg:Circle Data Pointer					*
;* Y reg:HDMA Table Pointer					*
;=============================================================
HDMACircle_sub	
	shorta
	longi
.loop
	lda.l	m_circlebuf,x
	sec
	sbc.l	m_circlebuf2,x		;(right side) -(left side) >=0
	bcs	.clip
;---------------------------------------
;(right side) < (left side) Case 
	lda.l	m_circlebuf2,x
	sta.l	[kz_tempaddrl],y	;left side data
	iny
	lda.l	m_circlebuf,x
	sta.l	[kz_tempaddrl],y	;right side data
	iny
	bra	.notclip
;---------------------------------------
;(Left Side)
.clip
	lda.l	m_circlebuf2,x
	cmp	kclipsx
	bcs	.notclipSX	;if SX clip not need (left side >= sx)

	lda	kclipsx
.notclipSX
	sta.l	[kz_tempaddrl],y
	iny
;---------------------------------------
;(Right Side)
	lda.l	m_circlebuf,x
	cmp	kclipex
	bcc	.notclipex	;(Right side < ex)
	lda	kclipex
.notclipex
	sta.l	[kz_tempaddrl],y
	iny
;---------------------------------------
.notclip
	inx
	inx
	dec	kcounter
	bne	.loop		;if Data Set End ===> jmp End
	rts

;=============================================================
;*			Pause Window		[PAUSE]	*
;* Data :Bank 7e						*
;* Yreg :hdma table pointer					*
;=============================================================
PauseWindow_l
	shorta
	longi
	km_pushallreg
	db7e
	test_screenmode	onescreen
	bne	.onescreenmode		;If battle mode
	jmp	.twoscreenmode
;-------------------------------------------------------------------------
.onescreenmode
	km_jmpnotmissionflag	pause,.pausewindowoff
	jsr	.setbufferadr
	ldy	#0	;HDMA Table Pointer
	km_sethdmatabs_reptwin	mission,MissHtflSta,MissHtflEnd
	alloc_window	pausewindow,1	; x = hitflash
	jsr	PauseWindowSub
	brl	.PauseWindowEnd
;-------------------------------------------------------------------------
.twoscreenmode
	km_jmpnotbattleflag	p12pauseflag,.pausewindowoff
	jsr	.setbufferadr

	ldy	#0	;HDMA Table Pointer
	km_sethdmatabs_reptwin	battle,P1HtFlXSta,P1HtFlXEnd
	km_sethdmatabs_reptwin	battle,P2HtFlXSta,P2HtFlXEnd

	alloc_window	pausewindow,1	; x = pause window
	jsr	PauseWindowSub
	alloc_window	pausewindow,2	; x = pause window
	jsr	PauseWindowSub
	bra	.PauseWindowEnd
;----------- Window Off ------------
.pausewindowoff
	dealloc_window	pausewindow,1	;Window Off
	dealloc_window	pausewindow,2	;Window Off
.PauseWindowEnd
	km_pullallreg
	rtl
;---------------------------------------------------------------------
;*		Pause hdma tabs buffer address set		*
;---------------------------------------------------------------------
.setbufferadr
	shorta
	longi

	php
	km_setval	kz_x1,0
	km_bitcheckscreenflag	windowwbuf
	beq	.buffer1
.buffer2
	km_setval	kz_x1,4
.buffer1
	a16
	lda	kz_x1
	and	#$ff
	clc
	adc	#xhdma_pausehofs&WM
	sta	kz_tempaddrl
	a8
	lda	#(xhdma_pausehofs>>16)
	sta	kz_tempaddrl+2

	alloc_window	pausewindow,1	; x = hitflash
	ldy	kz_tempaddrl
	sty	wm_hdma,x		;HDMA Table Set

	alloc_window	pausewindow,2	; x = hitflash
	ldy	kz_tempaddrl
	iny
	iny
	sty	wm_hdma,x		;HDMA Table Set

	plp	
	rts
;=============================================================
;*		Window Parametr Set		[Pause]	*
;* Xreg :Window reg parameter pointer			*
;* Yreg :HDMA Table pointer					*
;=============================================================
PauseWindowSub
	shorta
	longi
;============ Window Register Para Set ===============
	lda	#0
	sta	wm_w12sel,x	;2123h
	sta	wm_w34sel,x	;2124h

	lda	#%00000011
	sta	wm_ts,x		;212fh :bg1,bg2

	lda	#%00010000
	sta	wm_cgswsel,x	;2130h	;col fix data (area in)

	lda	#%11000011
	sta	wm_cgadsub,x	;2131h	;1/2 bg1 bg2

	lda	#$23
	sta	wm_coldata_r,x	;2132h	;Red

	lda	#$43
	sta	wm_coldata_g,x	;2132h	;Green

	lda	#$83
	sta	wm_coldata_b,x	;2132h	;Blue

	lda	wm_flags,x
	ora	#wf_datarepeat
	sta	wm_flags,x	;window repeat flag on

	lda	#$20
	sta	wm_wobjsel,x	;2125h :window mask
	lda	#$0c
	sta	wm_wobjlog,x	;212bh :windoe logic
	lda	#$41
	sta	wm_chparams,x	;4350h :channel parameter set

	lda	#xhdma_pausehofs>>16
	sta	wm_hdma+2,x	;4354h		:hdma table address

	rts

;*********************************************************************
;*								*
;*		PLayer BOM Shot & Hit Flash			*
;*********************************************************************
;-------------------------------------------------------------
;*		BOM Shoot Check				*
;* Data Bank 7e						*
;-------------------------------------------------------------
Check_KGwindow_l
	php
	phx
	phy

	a8i16
	ldx	playpt1
	ldy	al_sword2,x
	km_testjoypad	A
	beq	.nopushA_pl1
	lda	KBOMSHOT,y
	bmi	.nopushA_pl1
	ora	#kBomShotflag
	clc
	adc.l	CircleData
	sta	KBOMSHOT,y
.nopushA_pl1
	jsr	Check_BomShotSub

	ldx	playpt2
	ldy	al_sword2,x

	km_bitcheckgameflag	battle
	beq	.skip
.player2
	km_testjoypad2	A
	beq	.nopushA_pl2
	lda	KBOMSHOT,y
	bmi	.nopushA_pl2
	ora	#kBomShotflag
	clc
	adc.l	CircleData
	sta	KBOMSHOT,y
.nopushA_pl2
	jsr	Check_BomShotSub
.skip
;-------------------------------------------------------------
;*	Wepon damage check
;-------------------------------------------------------------
	ifeq	1
;----- Damage window check --
	jmpnotflag	KHITFLASH,#kdmgwinflag,.NoFlag,y
;----- Window timer set -----
	lda	KHITFLASH,y
	and	#~kdmgallflag
	dec	a
	bmi	.DMGwinEnd
	ora	#kdmgwinflag
	sta	KHITFLASH,y
	bra	.Noflag
.DMGwinEnd
	lda	#0
	sta	KHITFLASH,y	;Timer Dec
.NoFlag
;----- Hit check -----
;	s_jmpNOT_alsflag x,collide,.exit

	s_jmp_ifhitby	x,ENEMYWEAP,.hit
	s_jmp_ifhitby	x,FRIEND,.hit
	jmp	.exit

;----- hit damage ----
.hit
	lda	#DmgIntTm
	ora	#kdmgallflag
	sta	KHITFLASH,y

	kplsound	damage_l
	endc
;-------------------------------------------------------------
.exit
	ply
	plx
	plp
	rtl

;-------------------------------------------------------------
;*		BOM Shot Radius Set			*
;-------------------------------------------------------------
Check_BomShotSub
	shorta
	longi
	km_jmpnotflag	KBOMSHOT,kBomShotflag,.NoBom,y
	lda	KBOMSHOT,y
	and	#~kBomShotflag
	and	#~$80
	dec	a
	bpl	.Timerset
	beq	.Timerset

	lda	#0
	sta	KBOMSHOT,y
	bra	.NoBom
.Timerset
	ora	#kBomShotflag
	sta	KBOMSHOT,y
.NoBom
	rts

;*********************************************************************
;*								*
;*		Fade routine    (Black,White,Red)		*
;*								*
;*********************************************************************
initblack_l
	php
	a8i16
	lda	#2
	sta	stayblack		;black wait time
	km_qfadestepup
	km_fademin

	IFEQ	1
	lda	#10
	sta	stayblack		;black wait time
	alloc_window	blackfade,1
	lda	#31	;max = 31 made
	sta	wm_val,x	;fade init
	stz	wm_ts,x
	alloc_window	blackfade,2
	lda	#31	;max = 31 made
	sta	wm_val,x	;fade init
	stz	wm_ts,x
	jsl	setblack_l
	a8
	stz	fade
;94/6/1 :kawaguchi
;fade in step value
	km_setval	kw_blackfadestep,4
	ENDC

	plp
	rtl



;--------------------------------------------------------
;black wait
;----------
setblack_l
	php
	a8i16
	lda	stayblack
	inc	a
	beq	.clrit
	dec	stayblack
.clrit
	plp
	rtl
;--------------------------------------------
	ifeq	1
	php
	a8i16
	lda	stayblack
	inc	a
	beq	.clrit

	alloc_window	blackfade,1
	txy
	alloc_window	blackfade,2

	lda	#0
	sta	wm_ts,x
	sta.w	wm_ts,y

	lda	#2
	sta	wm_cgswsel,x
	sta.w	wm_cgswsel,y

	lda	#%10100111
	sta	wm_cgadsub,x
	sta.w	wm_cgadsub,y

	lda	wm_val,x
	ora	#%11100000
	sta	wm_coldata,x
	sta.w	wm_coldata,y


	lda	stayblack
	bne	.blackit

	lda	wm_val,x
	beq	.decit
;-------------------------------------------------------
;94/6/1 ni henkou :kawaguchi
	sec
	sbc	kw_blackfadestep	;fade step
	bpl	.setval
	lda	#0
.setval
;-------------------------------------------------------
	sta	wm_val,x
	sta.w	wm_val,y
	bra	.end
.blackit
	lda	#0
	sta	wm_ts,x
	sta.w	wm_ts,y
	lda	#%11100111
	sta	wm_cgadsub,x
	sta.w	wm_cgadsub,y
	lda	#255
	sta	wm_coldata,x
	sta.w	wm_coldata,y

.decit
	dec	stayblack
.end	plp
	rtl
.clrit	dealloc_window	blackfade,1
	dealloc_window	blackfade,2
	jmp	.end

	endc
;--------------------------------------------------------
fadewhite_l
	jsr	fadewhite
	rtl
fadewhite
	php
	a8i16
	phx
	alloc_window	whitefade,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00000111
	sta	wm_cgadsub,x
	lda	#%11100000
	ora	wm_val,x
	sta	wm_coldata,x
	lda	wm_val,x
	cmp	#31
	beq	.nc
	inc	a
	sta	wm_val,x
.nc	plx
	plp
	rts


;--------------------------------------------------------
flashturq_l
	php
	a8i16
	phx
	alloc_window	hitflash,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00100111
	sta	wm_cgadsub,x
	stz	wm_coldata_r,x
	lda	#%11111
	sta	wm_coldata_g,x
	sta	wm_coldata_b,x

	stz	wm_coldata,x
	plx
	plp
	rtl
         
;--------------------------------------------------------
flashturq2_l
	php
	a8i16
	phx
	alloc_window	hitflash,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00100111
	sta	wm_cgadsub,x
	stz	wm_coldata_r,x
	lda	#%111
	sta	wm_coldata_g,x
	sta	wm_coldata_b,x
	stz	wm_coldata,x
	plx
	plp
	rtl
	
	
;--------------------------------------------------------
flashred_l
	php
	a8i16
	phx
	alloc_window	hitflash,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00100111
	sta	wm_cgadsub,x
	stz	wm_coldata,x
	lda	#31
	sta	wm_coldata_r,x
	stz	wm_coldata_g,x
	stz	wm_coldata_b,x
	plx
	plp
	rtl

;--------------------------------------------------------
dyingred_l
	php
	a8i16
	phx
	alloc_window	dyingred,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00100111
	sta	wm_cgadsub,x
	stz	wm_coldata,x
	lda	#10
	sta	wm_coldata_r,x
	stz	wm_coldata_g,x
	stz	wm_coldata_b,x
	plx
	plp
	rtl

;--------------------------------------------------------
dyingredoff_l
	php
	a8i16
	phx
	dealloc_window	dyingred,1
	plx
	plp
	rtl



;--------------------------------------------------------
initfadewhite2norm_l
	php
	a8i16
	phx
	alloc_window	whitefade,1
	lda	#31
	sta	wm_val,x
	plx
	plp
	jsr	fadewhite2norm
	rtl

fadewhite2norm_l
	jsr	fadewhite2norm
	rtl
fadewhite2norm	
	php
	a8i16
	phx
	alloc_window	whitefade,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00000111
	sta	wm_cgadsub,x
	lda	#%11100000
	ora	wm_val,x
	sta	wm_coldata,x
	lda	wm_val,x
	beq	.nc
	dec	a
	sta	wm_val,x
	plx
	plp
	rts
.nc	dealloc_window	whitefade,1
	plx
	plp
	rts

;--------------------------------------------------------

bossflash_l
	php
	a8i16
	phx
	alloc_window	dyingred,1
	stz	wm_ts,x
	lda	#2
	sta	wm_cgswsel,x
	lda	#%00100111
	sta	wm_cgadsub,x
	stz	wm_coldata_r,x
	lda	#%11111
	sta	wm_coldata_g,x
	sta	wm_coldata_b,x

	stz	wm_coldata,x
	plx
	plp
	rtl

;--------------------------------------------------------



