;===================================================================
;===================================================================
;===================================================================
;*******************************************************************
;*		***********************************************
;*  WIPE (8)		***********************************************
;*		***********************************************
;* (leftright door )	***********************************************
;*		***********************************************
;*	224line	***********************************************
;*******************************************************************
;===================================================================
;===================================================================
;===================================================================
;
;
;
;
;
;*******************************************************************
;	[ program switch ]
;*******************************************************************

ON_doublewindow = 0	; window 1/2 test

;*******************************************************************
;	[ battle wipe labels ]
;*******************************************************************

wipebatt_starttimming equ	300h

wipebatt_angle 	equ	3
wipebatt_line	equ	192/4
wipebatt_1pup	equ	0
wipebatt_1pdw	equ	wipebatt_line*1*4
wipebatt_2pup	equ	wipebatt_line*2*4
wipebatt_2pdw 	equ	wipebatt_line*3*4

wipebatt_closedata	equ	0feffh
wipebatt_opendata	equ	0ff00h

doublewindow_Xoffset1 equ	8
doublewindow_Xoffset2 equ	16

;-------------------------------------------------------------------
;*******************************************************************
;	[ wipe work memory ]
;*******************************************************************

Xwipedata	equ	Xwork0		; Xwipedata address
Xwipecounter	equ	Xwork1

;-------------------------------------------------------------------
;
;
;
;
;*******************************************************************
;	-----------------
;	 battle wipeopen
;	-----------------
;*******************************************************************
;
;
;
;-------------------------------------------------------------------
wipebatt_open
	jsr	dc_program
	dwnext	clear_fullclose
	dwnext	battle_wipeon
	dwflag	battle_wipeloop
	dwnext	offswitch
	dwwait	2
	dwstop	endofwipe

;-------------------------------------------------------------------
battle_wipeon
 	jsr	set_param

	ifne	ON_doublewindow
	db	0ffh,0ffh,00fh	; window switch
	db	0ffh,0fh	; window logic
	elseif
	db	033h,033h,003h	; window switch
	db	000h,00h	; window logic
	endc

	db	0000b		; 212dh
	db	000h,000h,000h

	stz	wipe_addadd+0
	stz	wipe_addadd+2

	rts

;-------------------------------------------------------------------

battle_wipeloop

;-------------------------------------------------------------
; swap 
	jsr	swap_buffer	; buffer [SWAP]

;-------------------------------------------------------------
; data set
	ldx	dcregister
	lda	_dccounter,x
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	Mnegative
	clc
	adc	#wipebatt_starttimming
	bpl	.skip
	dec	_dcflag,x	; end of wipe
.skip	sta	Xwipedata

;-------------------------------------------------------------
; param set ( window1 )
	ldy	Xaddr		; buffer start address
	ldx	#wipebatt_line	; wipe loopcounter
	jsr	set_wipe1

;-------------------------------------------------------------
; param copy
	ldy	Xaddr		; buffer start address
	tya
	clc
	adc	#wipebatt_line*4-4
	tax			
	lda	#wipebatt_line
	jsr	wipecopy_battle

;-------------------------------------------------------------
; exit

	rts

;*******************************************************************
;	wipeset loop
;*******************************************************************
;
;
;
;
;===================================================================
set_wipe1

;;;	clc
;;;	lda	#-100h
;;;	adc	wipe_addadd+0
;;;	sta	wipe_addadd+0
;;;	lda	#0ffffh
;;;	adc	wipe_addadd+2
;;;	sta	wipe_addadd+2

;----------------------------------------------

	stz	wipe_longdata+0
	lda	Xwipedata
	sta	wipe_longdata+2

	stz	wipe_longadd+0
	lda	#-3
	sta	wipe_longadd+2

;----------------------------------------------


.loop
;-------------------------------------
	lda	wipe_longdata+2
	bmi	.fullopen
	cmp	#000ffh
	bcs	.fullclose
	ora	#0ff00h		; NORMAL
	bra	.set
.fullclose	lda	#wipebatt_closedata
	bra	.set
.fullopen	lda	#wipebatt_opendata
.set	sta.w	0,y
;-------------------------------------
	ifne	ON_doublewindow
	clc
	lda	wipe_longdata+2	; [wipedata]
	adc	#doublewindow_Xoffset1
	Mwipeclip		;
	a8			;
	sta.w	2,y		; left
	a16cC			;
;-------------------------------------
	lda	wipe_longdata+2	; [wipedata]
	adc	#doublewindow_Xoffset2
	Mwipeclip
	a8			;
	sta.w	3,y		; right
	a16			;
	endc
;-------------------------------------
	iny
	iny
	iny
	iny

	clc
	lda	wipe_longadd+0
	adc	wipe_longdata+0
	sta	wipe_longdata+0
	lda	wipe_longadd+2
	adc	wipe_longdata+2
	sta	wipe_longdata+2

	clc
	lda	wipe_addadd+0
	adc	wipe_longadd+0
	sta	wipe_longadd+0
	lda	wipe_addadd+2
	adc	wipe_longadd+2
	sta	wipe_longadd+2

	dex			; X = wipeloop counter
	bne	.loop
;----------------------------------------------

	rts

;===================================================================
;
;
;
;
;
;*******************************************************************
;	battle wipecopy
;*******************************************************************
;
; A = Total Count
; Y = Down Counter
; X = Up   Counter
; 
;-------------------------------------------------------------------

wipecopy_battle

;-------------------------------------------------
	sta	Xwipecounter		; Set counter
.loop
;-------------------------------------------------
	lda.w	wipebatt_1pup,y
	sta.w	wipebatt_1pdw,x
	cmp	#wipebatt_closedata
	beq	.skip
	xba
	and	#0ff00h
	eor	#0ff00h
.skip	sta.w	wipebatt_2pup,y
	sta.w	wipebatt_2pdw,x
;-------------------------------------------------
	ifne	ON_doublewindow
	lda.w	wipebatt_1pup+2,y
	sta.w	wipebatt_1pdw+2,x
	xba
	eor	#0ffffh
	sta.w	wipebatt_2pup+2,y
	sta.w	wipebatt_2pdw+2,x
	endc
;-------------------------------------------------
	iny
	iny
	iny
	iny
	dex
	dex
	dex
	dex
            	dec	Xwipecounter
	bne	.loop

	rts


;*******************************************************************
;	------------------
;	 battle wipeclose
;	------------------
;*******************************************************************
wipebatt_close
	rts


;===================================================================
;===================================================================
;===================================================================
;===================================================================

