;===================================================================
;===================================================================
;===================================================================
;*******************************************************************
;*		***********************************************
;*  WIPE (12)	***********************************************
;*		***********************************************
;*  (rolling door)	***********************************************
;*		***********************************************
;*		***********************************************
;*******************************************************************



;*******************************************************************
; <<<<<< rolling open >>>>>>
;*******************************************************************
wipe12_open	
	rts

;*******************************************************************
; <<<<< rolling close >>>>>>
;*******************************************************************

wipe12_close	jsr	dc_program
	dwnext	clear_fullopen
	dwnext	init_wipe12
	dwloop	24,main_wipe12X
	dwwait	60
	dwnext	fullclose
	dwnext	fullclose
	dwwait	20
	dwnext	offswitch
	dwwait	2
	dwstop	endofwipe

;-------------------------------------------------------------------
init_wipe12	
	lda	#12
	sta	rotate_data

	jsr	set_param
	db	0ffh,0ffh,00fh	; window switch
	db	00h,00h		; window logic
	db	00h		; 212dh
	db	00h,00h,0e0h	; 2130,31,32
	rts

;-------------------------------------------------------------------
fullclose
	jsr	swap_bufferFULL

	ldy	#0		 ; pointer
	ldx	#Fwipe_full	 ; counter
	lda	#00001h		 ; set data
	jmp	wipe_bufferset12

;-------------------------------------------------------------------

main_wipe12X
	jsr	swap_bufferFULL

	ldx	dcregister
	lda	_dccounter,x
	eor	#0ffffh
	inc	a
	clc
	adc	#27+4
	asl	a
	asl	a

	sta	zoom_data

	lda.l	mmx_wipeposY		; 'MAP' NO HOSI 'Y' POSITION
	and	#00ffh
	sta	Vcenter
	lda.l	mmx_wipeposX		; 'MAP' NO HOSI 'X' POSITION
	and	#00ffh
	sta	Hcenter

	bra	common_call

;-------------------------------------------------------------------
main_wipe12
	jsr	swap_bufferFULL
;- - - - - - - - - - - - - - - - - - - - - - - - -
; parameter
;- - - - - - - - - - - - - - - - - - - - - - - - -
	ldx	dcregister
	lda	_dccounter,x
	asl	a
	asl	a
	sta	zoom_data
	lda	#112
	sta	Vcenter
	lda	#128
	sta	Hcenter
common_call
;- - - - - - - - - - - - - - - - - - - - - - - - -
; program
;- - - - - - - - - - - - - - - - - - - - - - - - -
	jsr	calc_entry

	rts


;-------------------------------------------------------------------
MAXCOUNT	   equ	36	 ; kaiten kakudo 36 bunkatsu
;-------------------------------------------------------------------
calc_entry

;--------------------------------------------------------
	stz	wipe_switch
	lda	rotate_data
	sta	rotate_IDX
	asl	a
	tax
	jsr	(Xprocess,x)    ; angle 0 - 360
;--------------------------------------------------------
	lda	#2
	sta	wipe_switch
	lda	rotate_data
	clc
	adc	#MAXCOUNT/2
	cmp	#MAXCOUNT
	bcc	.skip100	   ; sec
	sbc	#MAXCOUNT
.skip100
	sta	rotate_IDX
	asl	a
	tax
	jsr	(Xprocess,x)
;--------------------------------------------------------
.next
 	lda	rotate_data
	inc	a
	cmp	#MAXCOUNT
	bcc	.exit
	sbc	#MAXCOUNT
.exit   	sta	rotate_data
;--------------------------------------------------------
	rts

;=========================================================
dwx	macro
	dw	 \1&0ffffh
	dw	 \2&0ffffh
	dw	 \3&0ffffh
	dw	 \4&0ffffh
	dw	 \5&0ffffh
	dw	 \6&0ffffh
	dw	 \7&0ffffh
	dw	 \8&0ffffh
	dw	 \9&0ffffh
	endm
;--------------------------------------------------------
Xprocess
	dwx	calc1,calc1,calc1,calc1,calc1,calc1,calc1,calc1,calc1
	dwx	calc1,calc1,calc1,calc1,calc1,calc1,calc1,calc1,calc1
	dwx	calc2,calc3,calc3,calc3,calc3,calc3,calc3,calc3,calc3
	dwx	calc3,calc3,calc3,calc3,calc3,calc3,calc3,calc3,calc3
;=========================================================
;*********************************************************************
;	  angle ( 90 or 270 ) line calc
;*********************************************************************
dataopen   equ  0ff00h
dataclose  equ  00001h
;- - - - - - - - - - - - - - - - -
calc2
;- - - - - - - - - - - - - - - - -
	lda	#0	 ; window pointer reset
	clc
	adc	wipe_switch
	tay
	ldx	#224    ; max line
;- - - - - - - - - - - - - - - - -
	lda	Vcenter
	sec
	sbc	zoom_data
	bpl	nomal_open
;- - - - - - - - - - - - - - - - -
special_open
;-----------------------------
	ldx	Vcenter
	lda	#dataopen
	jsr	set_call
;-----------------------------
	ldx	zoom_data
	lda	#dataopen
	jsr	set_call
;-----------------------------
	lda	#224
	sec
	sbc	Vcenter
	sec
	sbc	zoom_data
	bmi	.skip2
	tax
	lda	#dataclose
	jsr	set_call
.skip2  rts
;-----------------------------
;- - - - - - - - - - - - - - - - -
nomal_open
;-----------------------------
	tax
	lda	#dataclose
	jsr	set_call
;-----------------------------
	lda	zoom_data
	asl	a
	tax
	lda	#dataopen
	jsr	set_call
;-----------------------------
	ldx	#0224
	lda	#dataclose
	jsr	set_call
;-----------------------------
	rts

;---------------------------------------------------------------------
;	  set call
;---------------------------------------------------------------------

;- - - - - - - - - - - - - - - - - -
set_call
	cpx	#0
	beq	.exit
.loop   sta	(Xaddr),y
	iny
	iny
	iny
	iny
	cpy	#224*4		; < line limit >>
	bcs	.exit
	dex				 ; < counter >>
	bne	.loop
	rts

.exit   pla	; <
	rts
;- - - - - - - - - - - - - - - - - -


;---------------------------------------------------------------------
;	  Set Window Data
;---------------------------------------------------------------------
full_close
	lda	#0001h
	bra	loop100
full_open
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
	lda	#0ff00h
loop100
	sta	(Xaddr),y			
	iny
	iny
	iny
	iny
	dex
	bne	loop100
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
	rts






;*********************************************************************
;*********************************************************************









;*********************************************************************
Set_Parameter
;================================
	bmi	.clear
	bit	#0ff00h
	bne	.over
	a8
	sta	[Xaddr],y
	a16
	rts
;================================
.clear
	a8
	lda	#0
	sta	[Xaddr],y
	a16
	rts
;================================
.over
	a8
	lda	#0ffh
	sta	[Xaddr],y
	a16
	rts
;=====================================================================

;********************************************************************
;	  zoom line calc
;********************************************************************
angle_list
	dw	 0
	dw	 22
	dw	 45
	dw	 68
	dw	 93
	dw	 119
	dw	 147
	dw	 179
	dw	 214
	dw	 255
	dw	 305
	dw	 365
	dw	 443
	dw	 548
	dw	 703
	dw	 955
	dw	 1451
	dw	 2926
;--------------------------------------------------------------------
calc1
;- - - - - - - - - - - - - - - - - - - - - - - -
; DATABANK = PROGRAM BANK
;- - - - - - - - - - - - - - - - - - - - - - - -
	phb
	phk
	plb
;- - - - - - - - - - - - - - - - - - - - - - - -
	lda.l	rotate_IDX
	asl	a
	tax
	ldy	asin_table&0ffffh,x
	lda.l	zoom_data	  ; (000 - 127 )
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	jsl	ML_s16s16_l
	sta	Ndata		 ; Y=0 / answer X
;- - - - - - - - - - - - - - - - - - - - - - - -
	clc
	adc.l	Hcenter
	sta	work1		 ; X line right
	lda.l	Hcenter
	sec
	sbc	Ndata
	sta	work2		 ; X line left
;- - - - - - - - - - - - - - - - - - - - - - - -

;- - - - - - - - - - - - - - - - - - - - - - - -
	lda.l	rotate_IDX
	asl	a
	tax
	lda	angle_list,x
	sta	add_add
	lda	#0
	sta.l	add_total+0
	sta.l	add_total+2
;- - - - - - - - - - - - - - - - - - - - - - - -

	lda.l	Vcenter ; 111*4+1
	dec	a
	asl	a
	asl	a
	inc	a

	clc
	adc.l	wipe_switch
	tay
;- - - - - - - - - - - - - - - - - - - - - - - -	   
	lda.l	Vcenter
	sta	line_counter
;- - - - - - - - - - - - - - - - - - - - - - - -	   
.loop
	lda.l	add_total+1
	clc
	adc	work1
	jsr	Set_Parameter   ; set right 
	dey
	lda.l	add_total+1
	clc
	adc	work2
	jsr	Set_Parameter   ; set left
	dey
	dey
	dey

	lda.l	add_total+0
	clc
	adc	add_add
	sta.l	add_total+0
	lda	#0
	adc.l	add_total+2
	sta.l	add_total+2

	dec	line_counter
	bne	.loop

;- - - - - - - - - - - - - - - - - - - - - - - -

	lda.l	Vcenter
	asl	a
	asl	a

	clc
	adc.l	wipe_switch
	tay

	lda	#224
	sec
	sbc.l	Vcenter
	sta	line_counter

	lda	#0
	sta.l	add_total+0
	sta.l	add_total+2
;- - - - - - - - - - - - - - - - - - - - - - - -


.loop2  
	lda	work2
	sec
	sbc.l	add_total+1
	jsr	Set_Parameter   ; set left 
	iny
	lda	work1
	sec
	sbc.l	add_total+1
	jsr	Set_Parameter   ; set right
	iny
	iny
	iny

	lda.l	add_total+0
	clc
	adc	add_add
	sta.l	add_total+0
	lda	#0
	adc.l	add_total+2
	sta.l	add_total+2

	dec	line_counter
	bne	.loop2


	plb
	rts

;- - - - - - - - - - - - - - - - - - - - - - - -
asin_table
	dw	 400h,403h,40fh,424h
	dw	 441h,469h,49eh,4e2h
	dw	 538h,5a8h,639h,6f9h
	dw	 800h,976h,0bb1h,0f74h
	dw	 1708h,2de5h


;********************************************************************
;	  zoom line calc
;********************************************************************
calc3
;- - - - - - - - - - - - - - - - - - - - - - - -
	phb
	phk
	plb
;- - - - - - - - - - - - - - - - - - - - - - - -
	lda	#MAXCOUNT	  ; = max counter
	sec
	sbc.l	rotate_IDX
	asl	a
	tax
	ldy	asin_table&0ffffh,x
	lda.l	zoom_data	  ; (000 - 127 )
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	jsl	ML_s16s16_l
	sta	Ndata		 ; Y=0 / answer X
;- - - - - - - - - - - - - - - - - - - - - - - -
	clc
	adc.l	Hcenter
	sta	work1		 ; X line right
	lda.l	Hcenter
	sec
	sbc	Ndata
	sta	work2		 ; X line left
;- - - - - - - - - - - - - - - - - - - - - - - -
	lda	#MAXCOUNT	  ; = max counter
	sec
	sbc.l	rotate_IDX
	asl	a
	tax
	lda	angle_list,x
	sta	add_add
	lda	#0
	sta.l	add_total+0
	sta.l	add_total+2
;- - - - - - - - - - - - - - - - - - - - - - - -

	lda.l	Vcenter ; 111*4+1
	dec	a
	asl	a
	asl	a
	inc	a

	clc
	adc.l	wipe_switch
	tay
;- - - - - - - - - - - - - - - - - - - - - - - -
	lda.l	Vcenter
	sta	line_counter
;- - - - - - - - - - - - - - - - - - - - - - - -
.loop   
	lda	work1
	sec
	sbc.l	add_total+1
	jsr	Set_Parameter   ; set right 
	dey
	lda	work2
	sec
	sbc.l	add_total+1
	jsr	Set_Parameter   ; set left
	dey
	dey
	dey

	lda.l	add_total+0
	clc
	adc	add_add
	sta.l	add_total+0
	lda	#0
	adc.l	add_total+2
	sta.l	add_total+2

	dec	line_counter
	bne	.loop
;- - - - - - - - - - - - - - - - - - - - - - - -
	lda.l	Vcenter
	asl	a	  
	asl	a
	clc
	adc.l	wipe_switch
	tay

	lda	#224
	sec
	sbc.l	Vcenter
	sta	line_counter

	lda	#0
	sta.l	add_total+0
	sta.l	add_total+2
;- - - - - - - - - - - - - - - - - - - - - - - -
.loop2  
	lda	work2
	clc
	adc.l	add_total+1
	jsr	Set_Parameter   ; set left 
	iny
	lda	work1
	clc
	adc.l	add_total+1
	jsr	Set_Parameter   ; set right
	iny
	iny
	iny

	lda.l	add_total+0
	clc
	adc	add_add
	sta.l	add_total+0
	lda	#0
	adc.l	add_total+2
	sta.l	add_total+2

	dec	line_counter
	bne	.loop2

	plb
	rts




;=====================================================================
;
;
;
;



;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;	  Library Program
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;*********************************************************************
; 
; MULTIPLY signed 16bit * signed 16bit
;
; Usage: sBA*sYY=sBAYY ;mW:xW
;
;	jsl	ML_s16s16_l
;
;*********************************************************************
ML_s16s16_l
	PHB
	PHK
	PLB
	PHX					    ; >>
	JSR	Xml_s16s16
	PLX					    ; <
	PLB
	RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
Xml_s16s16	TYX			  	    	;W
	BPL	Multiply_s16u16
	TAY				;W
	BPL	s16s16_skip
	EOR	#0ffffh			;W
	INC	A			;W
	TAY				;W
	TXA				;W
	EOR	#0ffffh			;W
	INC	A			;W
	BRA	Multiply_s16u16
s16s16_skip	TXA				;W
	BRA	Multiply_s16u16	    	;mW:xW
;-----------------------------------------------------------------------
						;sBA*uYY=sBAYY
Multiply_s16u16 
	CMP	#8000h			;W
	BCC	Multiply_u16u16	
	EOR	#0ffffh			;W
	INC	A			;W
	JSR	Multiply_u16u16
	EOR	#0ffffh			;W
	TAX				;W
	TYA				;W
	EOR	#0ffffh			;W
	TAY				;W
	INY				;W
	BNE	s16u16_skip		;W
	INX				;W
s16u16_skip	TXA				;W
	RTS
;-----------------------------------------------------------------------
Multiply_u16u16 
	STY	multiplier		;W
	SEP	#00110000B
	STA	XMultiplicand		;B
	STY	XMultiplier		;B
	REP	#00100001B
	XBA
	TAX				;B
	LDY	multiplier+1		;B
	LDA	XProduct		;W
	STY	XMultiplier		;B
	STA	product			;W
	XBA
	AND	#00ffh			;W
	ADC	XProduct		;W
	LDY	multiplier+0		;B
	STX	XMultiplicand		;B
	STY	XMultiplier		;B
	NOP
	LDY	multiplier+1		;B
	ADC	XProduct		;W
	STY	XMultiplier		;B
	STA	product+1		;W
	AND	#0ff00h			;W
	ADC	#0			;W
	XBA
	REP	#00010001B
	LDY	product			;W
	ADC	XProduct		;W
	RTS				;mW:xW
;=====================================================================

