AFdebugmode_mapmessageON	= 0	; DEBUGMODE MAPMESSAGE
;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: yjmap.asm				*
;* 	Description	: mission map screen 			*
;*	Date		: 1994.10.12				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;
;
;
;*********************************************************************
;	-------
;	 flags
;	-------
;*********************************************************************

;----------------------------------------------------------------------
;	RAM alias
;----------------------------------------------------------------------
corneria_meter 	equ	objchart+1000h

;----------------------------------------------------------------------
;	flags
;----------------------------------------------------------------------
TGmessage_speedup	equ	08000h
LVmessage_speedup	equ	04000h
ALLmessage_speedup	equ	TGmessage_speedup+LVmessage_speedup
mapmessage_planetinit equ	0ffffh

;----------------------------------------------------------------------
;	flags
;----------------------------------------------------------------------

OFF_nextobj		equ	-1
ON_nextobj		equ	0

OFF_HPmeter		equ	0
ON_HPmeter		equ	-1

OFF_enemyyaji	equ	0
ON_enemyyaji		equ	1

ON_demomessage	equ	-1
OFF_demomessage	equ	0

OFF_mapmessage	equ	0

;*********************************************************************
;	----------------
;	 Map Parameters
;	----------------
;*********************************************************************

;---------------------------------------------------------------------
; 	times
;---------------------------------------------------------------------

TIME_demomessage	equ	127	; demomessage MAX time
TIME_mapmessage	equ	33	; mapmessage display time
TIME_HPfrash		equ	32*3	; mapreturn HPmeter frash

;---------------------------------------------------------------------
; 	mapmessage face&scroll POSITION
;---------------------------------------------------------------------

faceobjposH_easy	equ	00058h	; 
faceobjposH_hard	equ	00040h

faceobjposV_down	equ	0bb00h	; screen OBJ position
faceobjposV_up	equ	04b00h
faceobjposV_center	equ	08300h

message_scrollpos_center	equ	38h
message_scrollpos_up	equ	70h	; scroll V position
message_scrollpos_down equ	0

message_change_updown equ	90h	; up/down change OBJ position

;---------------------------------------------------------------------
; 	VRAM 
;---------------------------------------------------------------------
mapdraw_startNo	equ	000c0h	 ;draw start char+attr

;---------------------------------------------------------------------
; 	MAP	face draw screen
;---------------------------------------------------------------------
facedraw_vram	equ	mm_bg1_scr+1c9h+0e0h	; easy map
facedraw_vram2	equ	mm_bg1_scr+1c6h+0e0h	; normal/hard map
facedraw_charNo	equ	20*12+1+mapdraw_startNo
facedraw_Vadd	equ	1
facedraw_Hadd	equ	20
facedraw_Vloop	equ	6
facedraw_Hloop	equ	4

;---------------------------------------------------------------------
; 	MAP	3gyou message VRAM address
;---------------------------------------------------------------------
dx_vram		equ	mm_bg1_scr+28dh		; easy map
dx_vram2		equ	mm_bg1_scr+28ah		; normal/hard map
dx_charNo		equ	12+mapdraw_startNo
dx_Vadd		equ	1
dx_Hadd		equ	20
dx_Vloop		equ	7
dx_Hloop		equ	16

;---------------------------------------------------------------------
; 	MAP-PAUSE face draw screen
;---------------------------------------------------------------------
; andoross face   |
;------------------
p1_vram		equ	0e4h*2
mappause_andorossobj	equ	04be0h
p1_charNo		equ	facedraw_charNo
;---------------------------------------------------------------------
; player face     |
;------------------
p2_vram		equ	0e8h*2
mappause_playerobj	equ	04b30h
p2_charNo		equ	12+mapdraw_startNo
;---------------------------------------------------------------------
; partner face    |
;------------------
p3_vram		equ	0fah*2
mappause_partnerobj	equ	04b50h
p3_charNo		equ	12+mapdraw_startNo+20*4	
;---------------------------------------------------------------------
; andross message |
;------------------
p4_vram		equ	0f2h*2
p4_charNo		equ	12+mapdraw_startNo+20*8
;---------------------------------------------------------------------
; mappause HPmeter |
;-------------------
mappause_HPmeterposX equ	038h-20
mappause_HPmeterposY equ	0cfh-8-8*4

;---------------------------------------------------------------------



;*********************************************************************
;	-----------------------------
;	 MISSION MAP INITIAL PROGRAM
;	-----------------------------
;*********************************************************************
yjmapinit_l	
	Mbank7e
	php
	ai16

	MsetL	m_mapBG1scrollY,0

	jsr	init_mapmessage_mode	; set   mode(demo/main)

	jsr	init_stepupdemo		; init  mapanime stepup
	jsr	init_mapmessageVRAM	; set   VRAM
	jsr	copy_romdata		; copy  ROMdata

	jsr	init_mapmessage		; init  messageparameter
	jsr	clear_messageparam	; clear message
	jsr	clear_triggermessage	; clear trigger bit

	plp
	Mbankrtl


;*********************************************************************
;	--------------------------
;	 MISSION MAP MAIN PROGRAM
;	--------------------------
;*********************************************************************
yjmapmain_l

	Mbank7e
	php	; >>
	ai16

;-------------------------------------------------------
;	START PARAMETER SET
;-------------------------------------------------------

	ifne	AFdebugmode_mapmessageON
	jsr	debugmode_mapmessage
	endc

	jsr	set_yjmap_parameter

;-------------------------------------------------------
;	MODE CHECK
;-------------------------------------------------------

	lda.l	m_mapmessage_mode	; demo mode ?
	bne	.skip
	lda	mapexp_demoflag		; demo message ?
	bne	.skip

;-------------------------------------------------------
;	MAPGAME MESSAGE MODE
;-------------------------------------------------------

	jsr	check_mapmessage
	bra	.skip2

;-------------------------------------------------------
;	DEMO MESSAGE MODE
;-------------------------------------------------------

.skip	
;;;;;;;;;	jsr	set_faceobj_center
	
;-------------------------------------------------------
;	MESSAGE PROGRAM
;-------------------------------------------------------
.skip2
	jsr	expdemo_main	

;-------------------------------------------------------
;	PAUSE SEQ
;-------------------------------------------------------

	lda	mmx_pausescroll
	asl	a
	tax
	jsr	(.process,x)

	stz	gameframe_trigger

	plp
	Mbankrtl

;=====================================================================

.process	dwcode	.no_program		;(0)
	dwcode	mmapopen_wait		;(1)
	dwcode	mmapopen_scroll		;(2)
	dwcode	mmappause_wait		;(3)
	dwcode	mmappause		;(4)
	dwcode	mmapclose_wait		;(5)
	dwcode	mmapclose_scroll	;(6)
	dwcode	mmapclose_fin		;(7)

;-----------------------------------------------------
.no_program		;(0)
	rts

;-----------------------------------------------------
mmapopen_wait	;(1)
	stz	faceshutter_count
	rts

;-----------------------------------------------------
mmapopen_scroll	;(2)
	bra	mmappause_common

;-----------------------------------------------------
mmappause_wait	;(3)


mmappause		;(4)

	lda.l	m_mapmessage_mode
	bne	.skip
	stz	mapexp_pointer		; if pause then pointer reset

.skip	jsr	clear_messageparam	; message clear

;-----------------------------------------------------
mmapclose_wait	;(5)
mmapclose_scroll	;(6)
mmapclose_fin	;(7)
mmappause_common
	MsetL	m_mapBG1scrollY,0
	MsetL	m_mapmessageNo,0
	MsetL	m_mapmessage_faceflag,0

	rts

;-----------------------------------------------------

;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;=====================================================================
;
;
;
;
;
;
;
;
;
;
;
;####################################################################
;####################################################################
;	
;------------ INITALIZE (SUB) ---------------------------------------
;
;####################################################################
;####################################################################
;*********************************************************************
;	initialize mapmessage mode
;*********************************************************************

init_mapmessage_mode

	ldx	#-1				; demo mode
	km_bitcheckmistotalflag	explain1
	bne	.setmode
	km_bitcheckmismapstflag	finalbosstrig
	bne	.setmode
	ldx	#0				; normal mode
.setmode	txa
	sta.l	m_mapmessage_mode

	rts

;*********************************************************************
;	map message initialize
;*********************************************************************

init_mapmessage

	stz	mapexp_planettimer	; RESET planet timer
	stz	mapexp_planetlist	; RESET planet list
	stz	gameframe_trigger	; RESET trigger

	stz	mapexp_nextobj		; RESET nextobj
	lda	#0
	sta.l	m_mapmessage_faceflag	; RESET faceflag
	sta.l	m_mapBG1scrollY		; RESET scroll
	sta.l	m_mapmessage_counter	; RESET counter
	lda	#mapmessage_blackcolor	; RESET color
	sta.l	m_mapmessage_color	;
	stz	HPmeter_flag		; RESET HPmeter
	stz	mapexp_objNo	   	; RESET Yajirushi OBJ

	lda	faceobj_initpos		; INIT  faceobj position
	ora	#faceobjposV_down
	sta	faceobj_position

	MsetL	m_messagetimer,TIME_mapmessage

;-----------------------------------------------------------------------

	lda	Kdifficulty		; if easymode skip
	bne	.normalmap

;--------------------------------------------------
.easymap
	km_bitcheckmistotalflag	retry
	bne	.normalmap

	lda	mapexp_pointer
	cmp	#mapexp_easystart&WM
	beq	.modecheck

	Mset	mapexp_pointer,mapexp_easyreturn&WM
	bra	.modecheck

;--------------------------------------------------
.normalmap

	stz	mapexp_pointer
	Mset	HPmeter_flag,TIME_HPfrash
	lda	#maptime_speedup
	tsb	mapmessage_easykeycheck
	bra	.modecheck

;--------------------------------------------------
.modecheck

	lda.l	m_mapmessage_mode	; demomode ?
	beq	.exit

	stz	HPmeter_flag
	MsetL	m_messagetimer,TIME_demomessage
	Mset	mapexp_pointer,mapexp_openning&WM

	km_bitcheckmismapflag	finalboss
	beq	.exit

	Mset	mapexp_pointer,mapexp_boss&WM

;-----------------------------------------------------------------------
.exit

	rts

;*********************************************************************
; 	clear trigger message
;*********************************************************************

clear_triggermessage
	stz	mmx_message_sos		; trigger message OFF
	stz	mmx_message_guard
	stz	mmx_message_stepup
	stz	mmx_planet_stepup
	stz	mmx_sosappear
	rts


;*********************************************************************
; 	<<<<< Map Screen Message Initialize >>>>>
;*********************************************************************

clear_messageparam

	stz	mapmessage_messagestatus ; <<< clear flag >>>
	stz	openface_count		 ; <<< face initial >>>
	stz	closeface_count

	stz	pepper_message		 ; <<< trigger initial >>>
	MsetL	m_mapmessageNo,0	 ; <<< message clear >>>>

	rts

;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;*********************************************************************
;	stepup SYUTSUGEKI demo
;*********************************************************************

init_stepupdemo

;----------------------------------------------------
; clear buffer
;----------------------------------------------------
	ldy	#stepup_worktotal
	ldx	#stepup_work

.loop	stz	_stepup_flag,x
	stz	_stepup_posx,x
	stz	_stepup_posy,x
	stz	_stepup_anime,x

	Madx	stepup_workcount
	dey
	bne	.loop

;----------------------------------------------------
; initialize buffer
;----------------------------------------------------
;----------------------------------------------------
;;; explain mode
;----------------------------------------------------

	ldy	#0
	ldx	Kdifficulty

;----------------------------------------------------
;;; boss mode
;----------------------------------------------------

	km_bitcheckmismapstflag finalbosstrig	;;;; boss check
	beq	.explain

	ldy	#7*4	; boss mode
	ldx	#3	; boss mode

.explain
;----------------------------------------------------
	phy			; >>

	ai8
	lda.l	diffselect+0,x
	ai16
	and	#00ffh
	sta	demostepup_count	
	sta	Xwork0

	plx			; <<
	ldy	#stepup_work	; RAM address

.loop2	
	lda	#0ffffh
	sta.w	_stepup_flag,y

	lda.l	init_stepupdata+0,x
	and	#00ffh
	sta.w	_stepup_posX,y
	lda.l	init_stepupdata+1,x
	and	#00ffh
	sta.w	_stepup_posY,y

	lda.l	init_stepupdata+2,x
	sta.w	_stepup_anime,y

	inx
	inx
	inx
	inx
	Mady	stepup_workcount
	dec	Xwork0
	bne	.loop2

	rts

;----------------------------------------------------

diffselect	db	battleplanet_easy	; EASY
	db	battleplanet_normal	; NORMAL
	db	battleplanet_hard	; HARD
	db	1			; BOSS

;----------------------------------------------------

init_stepupdata

	db	098h,78h	; stepup(0)
	dw	-60
	db	0a8h,78h	; stepup(1)
	dw	-60-28h*1
	db	0b8h,78h	; stepup(2)
	dw	-60-28h*2
	db	0c8h,78h	; stepup(3)
	dw	-60-28h*3
	db	0d8h,78h	; stepup(4)
	dw	-60-28h*4
	db	0e8h,78h	; stepup(5)
	dw	-60-28h*5
	db	098h,88h	; stepup(6)
	dw	-60-28h*6

	db	0c0h,0a0h	; ( BOSS OBJECT )
	dw	-60

;---------------------------------------------------------------------
;
;
;
;
;*********************************************************************
; 	message & face VRAM initialize
;*********************************************************************
Msetbox	macro	[vram,char,Hloop,Vloop,Hadd,Vadd]
	jsr	Msetboxcall
	dw	{vram}
	dw	{char}
	dw	{Hloop}
	dw	{Vloop}
	dw	{Hadd}
	dw	{Vadd}
	endm

;---------------------------------------------------------------------
MsetboxRAM	macro	[vram,char,Hloop,Vloop,Hadd,Vadd]
	jsr	MsetboxcallRAM
	dw	{vram}
	dw	{char}
	dw	{Hloop}
	dw	{Vloop}
	dw	{Hadd}
	dw	{Vadd}
	endm

;=====================================================================



init_mapmessageVRAM

	Mbankprog

;---------------------------------
; map screen
;---------------------------------
;;;;;;	Msetbox	dx_vram,dx_charNO,dx_Hloop,dx_Vloop,dx_Hadd,dx_Vadd
;;;;;;	Msetbox	facedraw_vram,facedraw_charNO,facedraw_Hloop,facedraw_Vloop,facedraw_Hadd,facedraw_Vadd
;;;;;;	lda	#faceobjposH_easy
;;;;;;	bra	.skip2

	Msetbox	dx_vram2,dx_charNO,dx_Hloop,dx_Vloop,dx_Hadd,dx_Vadd
	Msetbox	facedraw_vram2,facedraw_charNO,facedraw_Hloop,facedraw_Vloop,facedraw_Hadd,facedraw_Vadd
	lda	#faceobjposH_hard
.skip2	sta.l	faceobj_initpos

;---------------------------------
; map-pause clear
;---------------------------------

	lda.l	m_mapmessage_mode	; demo mode ?
	beq	.next

	ldx	#(6*20h)*2
	ldy	#400h-(6*20h)

	lda	#200fh
.loop	sta.l	mmxx_screenbuffer,x
	inx
	inx
	dey
	bne	.loop

.next
;---------------------------------
; map-pause screen
;---------------------------------
	MsetboxRAM	p1_vram,p1_charNO,4,5,20,1	; pause screen
	MsetboxRAM	p2_vram,p2_charNO,4,5,20,1
	MsetboxRAM	p3_vram,p3_charNO,4,5,20,1
	MsetboxRAM	p4_vram,p4_charNO,8,3,20,1

	Mbankrts

;*********************************************************************
; 	copy ROM objdata => RAM(7f)
;*********************************************************************

copy_romdata
	Mmvn	ROMobjchart,objchart,1000h
	Mmvn	ROMcorneria_meter,corneria_meter,100h
	rts

;-----------	library's -----------------------------------------------
;
;*********************************************************************
;	BOX FILL PROGRAM
;*********************************************************************
setbox_vramaddr	equ	Xwork0
setbox_charNo	equ	Xwork1
setbox_Vloop		equ	Xwork2
setbox_Hadd		equ	Xwork3
setbox_Vadd		equ	Xwork4
setbox_counter	equ	Xwork5
;----------------------------------------------------------------------
mapBGscreen_pri	equ	2000h
;----------------------------------------------------------------------
Msetbox_Hadd	macro
	lda	setbox_charNo
	clc
	adc	setbox_Hadd
	sta	setbox_charNo
	endm

;----------------------------------------------------------------------
setbox_parameters
	lda.w	1,x		 ; message draw
	sta	setbox_vramaddr	 ; start address
	lda.w	3,x
	sta	setbox_charNo	 ;
	ldy.w	5,x		; Y = Hloop
	lda.w	7,x
	sta	setbox_Vloop
	lda.w	9,x
	sta	setbox_Hadd
	lda.w	11,x
	sta	setbox_Vadd
	txa
	clc
	adc	#12		; parameter count
	rts

;*********************************************************************
;	set boxcall
;*********************************************************************

;---------------------------------------------------------------------
; VRAM(screen VRAM draw )
;---------------------------------------------------------------------
Msetboxcall
	plx			; <<
	jsr	setbox_parameters
	pha			; >>

	lda	#81h		 ;
	sta	Screen_step	 ;

.skip2	ldx	setbox_Vloop
	lda	setbox_vramaddr	; draw address
	sta	Screen_address

	lda	setbox_charNo	; characterNo
	clc
.skip1	ora	#mapBGscreen_pri
	sta	Screen_write
	adc	setbox_Vadd
	dex
	bne	.skip1

	Msetbox_Hadd

	inc	setbox_vramaddr	; draw address
	dey
	bne	.skip2

	rts

;---------------------------------------------------------------------
; RAM(screen buffer draw )
;---------------------------------------------------------------------

MsetboxcallRAM
	plx			; <<
	jsr	setbox_parameters
	pha			; >>

.skip2	lda	setbox_Vloop
	sta	setbox_counter
	ldx	setbox_vramaddr	; draw address

	lda	setbox_charNo	; characterNo
.skip1	clc
	ora	#2000h		; BGscreen priority UP
	sta.l	mmxx_screenbuffer,x
	adc	setbox_Vadd
	pha
	txa
	clc
	adc	#40h
	tax
	pla
	dec	setbox_counter
	bne	.skip1

	Msetbox_Hadd

	inc	setbox_vramaddr	; draw address
	inc	setbox_vramaddr	; draw address
	dey
	bne	.skip2

	rts

;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;
;
;
;
;
;
;
;
;
;
;####################################################################
;####################################################################
;	
;------------ MAINPROGRAM (SUB) -------------------------------------
;
;####################################################################
;####################################################################

;*********************************************************************
; 	debug mode map explain
;*********************************************************************

debugmode_mapmessage

	lda	cont1
	and	#button_L+button_R
	cmp	#button_L+button_R
	bne	.skip

	lda	#mapexp_debugdisplay&WM
	sta	mapexp_pointer
.skip
	rts


;*********************************************************************
;	set parameter
;*********************************************************************
;
; sfx RAM ---> mario RAM
;
;----------------------------------------------------------------------

set_yjmap_parameter

	lda	p1_pilotNO
	and	#0ffh
	sta.l	m_playernumber		; copy pilot number
	lda	player_friend		; friend partner
	sta.l	m_partnernumber		; copy partner number

	lda	mmx_pausescroll		; nomal-mode message
	and	#00ffh
	sta.l	m_mappause_index	; copy marioRAM

	rts






















;*********************************************************************
;	HPmeter display check
;*********************************************************************

dispcheck_HPmeter
	lda	mmx_mapcursor		; cursor checkON ?
	beq	.skip
	lda	mmx_cursorflag		; corneria ?
	bit	#curf_corneria
	beq	.skip
	Mset	HPmeter_flag,0ffffh
	bra	.skip2

.skip	lda	HPmeter_flag
	bpl	.skip2	
	stz	HPmeter_flag

.skip2
	rts

;*********************************************************************
;	Bpush check
;*********************************************************************

Bpushcheck

	Mbitflagcheck	mapmessage_easykeycheck,maptime_speedup
	bne	.exit

	lda	mapexp_pointer
	bne	.exit
	inc	mapmessage_Bpushtimer
	lda	mapmessage_Bpushtimer
	and	#01fh
	bne	.exit

	Mset	mapexp_pointer,mapexp_mapspeedup&WM

.exit	rts

;*********************************************************************
;	mapmessage entry
;*********************************************************************

check_mapmessage

	jsl	MessageTrigger_l	; tigger message check
	jsr	dispcheck_HPmeter	; HPmeter check
	jsr	Bpushcheck
	
; SPEEDUP ------------------------------------------------------------
	km_bitcheckmismapstflag	speedup
	beq	.normal

	lda	mapexp_pointer
	bne	.speedup

.initialize	jsr	clear_messageparam
	jsr	clear_triggermessage
	rts

.speedup	Mset	mapmessage_messagestatus,ALLmessage_speedup
	rts

;---------------------------------------------------------------------
.normal
	lda	pepper_message
	beq	Set_Levelmessage
	bra	Set_Triggermessage


;*********************************************************************
;	TRIGGER MESSAGE CHECK
;*********************************************************************
;
; IF message-used THEN LVmessage speedup
; 	     ELSE TGmessage start
;
;---------------------------------------------------------------------

Set_Triggermessage

	lda	mapexp_pointer
	bne	.exit

	MsetL	m_gyoulimit,100
	MsetL	m_mapmessage_counter,0
	Mset	mapexp_pointer,mapexp_triggermessage&WM

	MmovL	m_mapmessageNo,pepper_message
	MmovL	m_mapmessage_color,mapmessage_setcolor

	lda	mmx_curposy
	ldx	mapmessage_setcolor
	cpx	#mapmessage_redcolor
	bcc	.skip
	lda	#0e0h
.skip	jsr	set_faceobjpos		; set position


;----------------------------------------------------------------------
.exit
	Mset	mapmessage_messagestatus,LVmessage_speedup
	rts

;*********************************************************************
;	LEVEL MESSAGE CHECK
;*********************************************************************
;
; IF message-used THEN LVmessage speedup
; 	     ELSE TGmessage start
;
;---------------------------------------------------------------------



Set_levelmessage

	lda	mmx_mapcursor	; cursor hit ?
	beq	.cursor_out
	lda	mmx_cursorflag	; corneria ?
	bit	#curf_corneria
	beq	.entry		; no 

.cursor_out

	Mset	mapmessage_messagestatus,LVmessage_speedup
	Mset	LVmessage_planetname,mapmessage_planetinit

	rts

;---------------------------------------------------------------------
.entry
	lda	mmx_planetname		; same planet ?
	cmp	LVmessage_planetname
	beq	.exit

	lda	mapexp_pointer
	bne	.wait

	lda	mmx_bigcurposy
	jsr	set_faceobjpos		 ; set position
	jsr	set_LVmessageNumber
	jsr	set_LVmessageColor

	stz	mapmessage_messagestatus
	MsetL	m_mapmessage_counter,0
	Mset	mapexp_pointer,mapexp_levelmessage&WM

	rts

;-------------------------------------
.wait
	Mset	mapmessage_messagestatus,LVmessage_speedup
	rts

;-------------------------------------
.exit	rts

;---------------------------------------------------------------------




;*********************************************************************
;	set LVmessage number
;*********************************************************************

set_LVmessageNumber

	lda	mmx_planetname		; name copy !!!!!
	sta	LVmessage_planetname
	Masl4
	adc	mmx_planetstep		; planetNo*16 + planet step
	tax
	lda.l	mapmessage_table,x	; message enntry
	and	#0ffh
	sta.l	m_mapmessageNo		; Set Message number

;-----------------------------------------
; wakusei ga senryou saresou na toki !!
;-----------------------------------------
	ifeq	1

	lda	mmx_planetstatus
	and	# ?
	beq	.exit
	MsetL	m_mapmessageNo,154
.exit
	endc
;-----------------------------------------

	rts

;*********************************************************************
;	set LVmessage color
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------

set_LVmessageColor

	lda	#mapmessage_blackcolor
	ldx	mmx_planetstep
	cpx	#000fh			;;; planet_safetime
	bne	.set
	lda	#mapmessage_bluecolor
.set	sta.l	m_mapmessage_color
	rts


;*********************************************************************
;	faceobj position check
;*********************************************************************
;
; << INPUT >>  --- register cursor position
;
;
; << workRAM >>
;
; faceobj_position  YX(16bit)	up/down
; faceobj_initpos   *X
;
; m_mapBG1scrollY   BGscroll		up/down
;
;---------------------------------------------------------------------
set_faceobjpos

	ldx	#message_scrollpos_down
	ldy	#faceobjposV_down
	and	#00ffh
	cmp	#message_change_updown
	bcc	.skip
	ldy	#faceobjposV_up
	ldx	#message_scrollpos_up
.skip	txa				; X...scroll position
	sta.l	m_mapBG1scrollY
	tya				; Y...sprite position
set_faceobjcommon
	ora	faceobj_initpos
	sta	faceobj_position
	rts

;=====================================================================

set_faceobj_center
	lda	#message_scrollpos_center
	sta.l	m_mapBG1scrollY
	lda	#faceobjposV_center
	bra	set_faceobjcommon

;==============================================================
;==============================================================
; END END END END END END END END END END END END END END END
;==============================================================
;==============================================================

















































