;**
;**  A macro that will insert the current scrap's first line into the current
;**  command line prompt.  If no scrap exists then the macro will beep.  This
;**  macro is a 'well-behaved' replacement macro and will call previously
;**  installed replacements if it does not wish to handle the keystroke.
;**
;**  Written for Brief v2.1 by Harold Handelsman, 1 June 1988.
;**
;**  11/10/88 - some irrelevant lines thrown out;
;**				 changed it so that it really INSERTs (well, appends)
;**				 the scrap to the current cmd_line, rather than replacing it
;**				 (its previous behavior).
;**				 TWO GRIPES:
;**				  1) Ctrl chars are NOT considered "bad keys".  This is stupid.
;**				 	  Find me the guy whose commands often contain ctrl chars.
;**				 	  A better solution, which wd please the few people who _do_
;**				 	  regularly put ctrl-chars in their responses to prompts, 
;**				 	  would be to make get_parm recognize Alt-q and treat it as
;**				 	  an escape (I don't mean "<Esc>").
;**				 	  Reason for wanting ctrl chars to be bad: I'd like to be
;**				 	  able to use typing shortcuts such as ^h for Backspace,
;**				 	  and (my own perversion) ^a for '\' (well, think about
;**				 	  the number of times per day that you type '\', and about
;**				 	  how easy it is, on sane kbds anyway, to hit ^a, & then
;**				 	  perhaps you won't think it all that perverse).
;**				 2)  There doesn't seem to be any way to determine the position
;**				 	  of the cursor within the response when a bad key is hit.
;**				 	  Am I wrong ?  In any case, being able to determine this wd
;**				 	  make  for better replacement for _bad_key.
;**
;*****************************************************************************
;**				 
;** REVISION: Brian O'Neill			Tuesday, 11/15/1988
;**
;** Previous version implemented the following bad key function:
;**
;** 	Ins     append scrap to command response
;**
;**
;**
;** This version adds the following bad key behavior(s):
;**
;** 	F2      copy command response to scrap
;** 	Alt-F2  append command response to scrap
;** 	F10     clear command response
;** 	Alt-f   append current filename to command response
;** 	Alt-t   open line in current buffer and insert command response
;** 	Alt-d   backspace
;** 					(Also, Alt-x !  Neither is really satisfactory.
;** 					Can't use Alt-h (help), & don't really wanna use Alt-x.
;** 					I'd prefer to use Ctrl-h, but this is impossible because
;** 					ctrl chars are not "bad keys". <grumble>)
;** 	Alt-a   '\'
;** 					(A personal perversion.  I usually redefine backslash
;**					to be Ctrl-a, but, as noted above, this can't be done
;**					in a _bad_key replacement.)
;**
;*****************************************************************************

(extern	open_line)


#define	NONINCMARK	4

;***************************************************
;**																*
;** Change these defines to suit your preferences:	*
;**																*
;***************************************************
#define	BACKSLASH_KEY		"<Alt-a>"
#define	BACKSPACE_KEY1		"<Alt-d>"
#define	BACKSPACE_KEY2		"<Alt-x>"
#define	FILENAME_KEY		"<Alt-f>"
#define	COPYSCRAP_KEY		"<F2>"
#define	TRANSFER_KEY		"<Alt-t>"
#define	APPENDSCRAP_KEY	"<Alt-F2>"
#define	INSERTSCRAP_KEY	"<Ins>"
#define	CLEAR_KEY			"<F10>"

(replacement _bad_key

   ;**
   ;** _bad_key replacement macro, called when get_parm receives an illegal
   ;** keystroke.  This routine examines the offending keycode for
   ;** meaningfulness, pops the keycode off the stack, acts appropriately.
   ;**   If the keycode has no meaning to this procedure then the keycode
   ;** is pushed back and the next replacement level is called.
   ;**

   (      
      (int		kchar 
					startbuf 
					scrapbuf
					appendkey
		)
      (string cmd_resp		;** BTO addition
				  par_string
		)
 
      (= kchar (read_char))
      (= cmd_resp (inq_cmd_line))
      (= par_string (inq_command))


		(= appendkey (key_to_int APPENDSCRAP_KEY))	;** save this for later

		;**

		(switch kchar
			(key_to_int BACKSLASH_KEY)
				(
					(push_back (key_to_int "<Right>"))	;** suppress highlight
					(return (+ cmd_resp "\\") )
				)

			(key_to_int BACKSPACE_KEY1)
				NULL
			(key_to_int BACKSPACE_KEY2)
				(
					(push_back (key_to_int "<Backspace>"))
					(return cmd_resp)
				)

			(key_to_int FILENAME_KEY)
				(
					(string fn)
					(inq_names fn)
					(push_back (key_to_int "<Right>"))	;** suppress highlight
					(return (+ cmd_resp fn))
				)

			(key_to_int INSERTSCRAP_KEY)
				(
   				;**
   				;** Check if something is in scrap.
   				;**

   				(= startbuf (inq_buffer))

   				(if (= scrapbuf (inq_scrap))
      				(
         				(set_buffer scrapbuf)
         				(top_of_buffer)

         				;**
         				;** Get the first line of the scrap.
         				;**

         				(= par_string (read))

         				;**
         				;** Delete any newline character
         				;**  at end of 1st line of scrap.
         				;**

         				(if (== (substr par_string
													(= kchar (strlen par_string))
													1
										)
										"\n"
								 )
            				(= par_string (substr par_string 1 (-- kchar)))
         				)

         				(set_buffer startbuf)
							(push_back (key_to_int "<Right>") )	;** suppress highlight
         				(return (+ cmd_resp par_string) )
      				)
   				;else
      				(
         				(beep)
							(return cmd_resp)
      				)

   				) ;** endif

				) ;** end case INSERTSCRAP_KEY

		
			appendkey
				NULL
			(key_to_int COPYSCRAP_KEY	 )
				(
					(int	oldbufid newbufid)

					(= oldbufid (inq_buffer))

					;** no starting file, not a system buffer
					(= newbufid (create_buffer "temp" NULL 0))
					(set_buffer newbufid)

					;** transfer cmd_resp to scrap
					(insert cmd_resp)
					(top_of_buffer)
					(drop_anchor NONINCMARK)
					(end_of_buffer)
					(cut (== kchar appendkey))

					(set_buffer oldbufid)
					(delete_buffer newbufid)
					(push_back (key_to_int "<Right>"))	;** suppress highlight
					(return cmd_resp)
				)

			(key_to_int TRANSFER_KEY)
				(
					(open_line)
					(insert cmd_resp)
					(push_back (key_to_int "<Right>"))	;** suppress highlight
					(return cmd_resp)

				)

			(key_to_int CLEAR_KEY)
				(
					(push_back (key_to_int "<Del>"))	;** delete highlit cmd_resp
					(return cmd_resp)

				)

			NULL
         	(
            	(push_back kchar)
            	(return (_bad_key))
         	)

		) ;** end switch
	)
)

;************************************************************************

