void keyboard ()
{
	/*
	**		The following autoload defines the default BRIEF prompt
	**	handling macro.  This macro provides a history facility as
	**	well as file name completion for a number of prompts.
	**
	**		Note that the macros defined in prompt.cb are the base
	**	level _prompt_begin, _prompt_end and _bad_key macros; they
	**	do not call down to their replacements, as no one is below
	**	them.
	*/

	autoload ("prompt", "_completion_commands",					/*vc*/
		"_complete_edit_file", "_prompt_begin", "_prompt_end",		/*vc*/
		"_bad_key", "_history_buf", "mouse_prompt");							/*vc*/


	autoload ("search",	"next_word", "_next_word",
								"previous_word", "_previous_word",
								".c_next_word", ".c_previous_word",
								".h_next_word", ".h_previous_word",
								".inc_next_word", ".inc_previous_word",
								".m_next_word", ".m_previous_word",
								".cb_next_word", ".cb_previous_word",
								".asm_next_word", ".asm_previous_word",
								"search_fwd", "search_back",
								"translate", "translate_back",
								"toggle_re", "block_search",
								"search_again", "translate_again",
    							"i_search", "_marksrch" );
	autoload ( "search",		"end_word", "_end_word",
								"begin_word", "_begin_word",
								".c_end_word", ".c_begin_word",
								".h_end_word", ".h_begin_word",
								".inc_end_word", ".inc_begin_word",
								".m_end_word", ".m_begin_word",
								".cb_end_word", ".cb_begin_word",
								".asm_end_word", ".asm_begin_word");
	autoload ("windows",	"change_window", "create_edge",
								"to_top", "to_bottom", "center_line",
								"screen_up", "screen_down", "left_side",
								"right_side", "zoom_window");

	/*
	**		Normally, <Shift-Up> is the same as <Keypad-8>.  When the
	**	101key driver is loaded, <Shift-Up> refers to the dedicated
	**	cursor pad, and the BIOS doesn't transmit <Shift-Up>.  We use
	**	this fact to determine if 101key support is installed.
	*/


	autoload ("buffers",	"buf_list", "edit_file", "edit_next_buffer",
								"edit_prev_buffer", "delete_curr_buffer",
								"_bad_key", "mouse_buf_list", "_buf_position" );

	/*
	**		These assignments are for the bookmark key definitions.	<Alt-j> is
	**	built-in.
	*/




	autoload ("compile", "compile_it", "cc", "cm", "warnings_only", "bgd_compilation");


	autoload ("errorfix",	"next_error", "_next_error",
									"_previous_error", "_error_info",
									"mouse_errorfix");









	autoload ("help",	"help", "_context_help", "_help_add_button",
							"_user_kbd", "display_help", "process_help_menu",
							"mouse_help_menu", "mouse_help");

	register_macro (2, "_context_help"); 		//	"Assigned" to Alt-h
															//	when prompting.










	autoload ("repeat", "repeat");
	autoload ("key", "key");
	autoload ("routines", "routines");


	autoload ("autosave", "autosave");

	autoload ("indent",	".c_smart_first", ".c_template_first",
								"_regular_first", "r_indent", "slide_in",
								".cb_smart_first", ".cb_template_first",
								"slide_out", ".c_abbrev", "brace_expand",
								"just_brace", "just_cbrace", "just_space",
								".c_open_brace", ".c_close_brace");

	autoload ("wp", "_wp_on", "_wp_off", "center", "reform", "margin");

	autoload ("dialog",	"_process_menu", "_process_dialog_box", "_dialog_level",
								"_dialog_mode", "_dialog_esc", "_dialog_grey_minus",
								"_dialog_dir");

	autoload ("column", "_col_copy", "_col_cut", "_col_delete", "_col_paste");

	autoload ("ada", ".ada_smart_first", ".ada_template_first");

	autoload ("basic",".bas_smart_first", ".bas_template_first");

	autoload ("cobol", ".cob_smart_first",	".cob_template_first");

	autoload ("fortran",	".for_smart_first", ".for_template_first");

	autoload ("modula2",	".mod_smart_first", ".def_smart_first", ".mod_template_first",
					".def_template_first");

	autoload ("pascal", ".pas_smart_first", ".pas_template_first");

	autoload ("popup", "popup_menu", "process_popup_menu");






 	assign_to_key ("<Ctrl-Right Arrow>", "next_word");
	assign_to_key ("<Ctrl-Left Arrow>", "previous_word");
	assign_to_key ("<Shift-F5>", "search_again");
	assign_to_key ("<Ctrl-F6>", "toggle_re");
	assign_to_key ("<Shift-F6>", "translate_again");
	assign_to_key ("<Alt-F6>", "translate_back");
	if (key_to_int ("<Shift-Up>") == 0)
		{
		assign_to_key ("<Alt-Up>", "change_window 0");
		assign_to_key ("<Alt-Right>", "change_window 1");
		assign_to_key ("<Alt-Down>", "change_window 2");
		assign_to_key ("<Alt-Left>", "change_window 3");
		assign_to_key ("<Alt-Home>", "left_side");
		assign_to_key ("<Alt-End>", "right_side");
		assign_to_key ("<Center>", "center_line");
		}
	else
		{
		assign_to_key ("<Shift-Keypad Up>", "change_window 0");
		assign_to_key ("<Shift-Keypad Right>", "change_window 1");
		assign_to_key ("<Shift-Keypad Down>", "change_window 2");
		assign_to_key ("<Shift-Keypad Left>", "change_window 3");
		assign_to_key ("<Shift-Keypad Home>", "left_side");
		assign_to_key ("<Shift-Keypad End>", "right_side");
		}
	assign_to_key ("<Ctrl-t>", "to_top");
	assign_to_key ("<Ctrl-b>", "to_bottom");
	assign_to_key ("<Ctrl-c>", "center_line");
	assign_to_key ("<Ctrl-e>", "screen_up");
	assign_to_key ("<Ctrl-d>", "screen_down");
	assign_to_key ("<Alt-F2>", "zoom_window");
	assign_to_key ("<Ctrl-z>", "zoom_window");
	assign_to_key ("<Alt-b>", "buf_list");
	assign_to_key ("<Alt-n>", "edit_next_buffer");
	assign_to_key ("<Alt-minus>", "edit_prev_buffer");
	assign_to_key ("<Ctrl-minus>", "delete_curr_buffer");


	assign_to_key ("<Alt-1>", "drop_bookmark 1");
	assign_to_key ("<Alt-2>", "drop_bookmark 2");
	assign_to_key ("<Alt-3>", "drop_bookmark 3");
	assign_to_key ("<Alt-4>", "drop_bookmark 4");
	assign_to_key ("<Alt-5>", "drop_bookmark 5");
	assign_to_key ("<Alt-6>", "drop_bookmark 6");
	assign_to_key ("<Alt-7>", "drop_bookmark 7");
	assign_to_key ("<Alt-8>", "drop_bookmark 8");
	assign_to_key ("<Alt-9>", "drop_bookmark 9");
	assign_to_key ("<Alt-0>", "drop_bookmark 10");

	assign_to_key ("<Alt-F10>", "compile_it");
	assign_to_key ("<Ctrl-n>", "next_error");
	assign_to_key ("<Ctrl-p>", "next_error 1");
	assign_to_key ("<Ctrl-Backspace>", "delete_previous_word");
	assign_to_key ("<Alt-Backspace>", "delete_next_word");
	assign_to_key ("<Ctrl-k>", "delete_to_bol");
	assign_to_key ("<Ctrl-x>", "write_and_exit");
	assign_to_key ("<Ctrl-w>", "set_backup");
	assign_to_key ("<Alt-f>", "display_file_name");
	assign_to_key ("<Alt-F7>", "load_keystroke_macro");
	assign_to_key ("<Ctrl-Enter>", "open_line");
	assign_to_key ("<Shift-Tab>", "back_tab");
	assign_to_key ("<Alt-q>", "quote");
	assign_to_key ("<Home>", "_home");
	assign_to_key ("<End>", "_end");

	assign_to_key ("<Alt-h>", "help");
	assign_to_key ("<Ctrl-r>", "repeat");
	assign_to_key ("<Shift-F10>", "key");
	assign_to_key ("<Ctrl-g>", "routines");

	assign_to_key ("<Alt-,>","comment_block");
	assign_to_key ("<Alt-.>","uncomment_block");
 

#include "vc_key.h"		// include Sourcer's Apprentice autoloads
		assign_to_key ("<Alt-s>", "search_fwd");
}






