;**
;**
;**  This macro will allow the cursor keys to be used to draw simple boxes
;**  using the extended character set double-line characters.
;**  To enter the drawing mode execute the macro 'linedraw'. The cursor
;**  control keys will then allow you to move the cursor to position the
;**  start of the line drawing.
;**  Hitting the Gray-Plus will turn on the actual line drawing and hitting
;**  the Gray-Minus will turn off the line, allowing the cursor to be moved
;**  freely again.
;**  To exit the line drawing macro hit the Esc key.
;**  To blank out a mistake use the shifted cursor control keys to overwrite
;**  the line.
;**
;**
;**  Written for Brief by Harold Handelsman, 26 October 1986
;**
;**  Modified by Per Soerensen, 5 December 1988
;**        Added macro read_it, and activated macro insert_it
;**
;**
(macro linedraw
;      
   (
      (int line_dir line_type)
      (global line_dir line_type)
      (= line_type 2)
      (= line_dir 0)

      (keyboard_push)
      (assign_to_key "%#72"   "up")                ; Up
      (assign_to_key "%#75"   "left")              ; Left
      (assign_to_key "%#77"   "right")             ; Right
      (assign_to_key "%#80"   "down")              ; Down
      (assign_to_key "#18488" "up_space")          ; Shift Up
      (assign_to_key "#19252" "left_space")        ; Shift Left
      (assign_to_key "#19766" "right_space")       ; Shift Right
      (assign_to_key "#20530" "down_space")        ; Shift Down
      (assign_to_key "#27"    "exit_line")         ; Esc
      (assign_to_key "#13"    "exit_line")         ; Enter
      (assign_to_key "%#83"   "delete_char")       ; Del
      (assign_to_key "#8"     "backspace")         ; Backspace
      (assign_to_key "#32"    "space_line")        ; Space
      (assign_to_key "#20011" "line_on")           ; Gray Plus
      (assign_to_key "#18989" "line_off")          ; Gray Minus

;**   The following two lines are commented out to allow for the 
;**   defining of scan codes for the IBM enhanced keyboard.

;**   (assign_to_key "#13613" "set_single_line")   ; Minus
;**   (assign_to_key "#61"    "set_double_line")   ; Equals

;**   The following two line are the new scan codes for 
;**   IBM enhanced keyboard

      (assign_to_key "#3117"  "set_single_line")   ; Minus
      (assign_to_key "#3389"  "set_double_line")   ; Equals

      (message "<Esc> to exit line drawing mode")
      (process)
      (message " ")
   )
)
;**
;**  Macro to move the line in the upward direction.
;**
(macro up_line
   (
      (save_position)
      (insert_char (+ (* line_dir 4) 1))
      (restore_position)
      (up)
      (= line_dir 1)
   )
)
;**
;**  Macro to move the line in the rightward direction.
;**
(macro right_line
   (
      (save_position)
      (insert_char (+ (* line_dir 4) 2))
      (restore_position)
      (right)
      (= line_dir 2)
   )
)
;**
;**  Macro to move the line in the downward direction.
;**
(macro down_line
   (
      (save_position)
      (insert_char (+ (* line_dir 4) 3))
      (restore_position)
      (down)
      (= line_dir 3)
   )
)
;**
;**  Macro to move the line in the leftward direction.
;**
(macro left_line
   (
      (save_position)
      (insert_char (+ (* line_dir 4) 4))
      (restore_position)
      (left)
      (= line_dir 4)
   )
)
;**
;**  Macro to erase a character in the upward direction.
;**
(macro up_space
   (
      (up)
      (save_position)
      (insert_char 0)
      (restore_position)
      (= line_dir 0)
   )
)
;**
;**  Macro to erase a character in the rightward direction.
;**
(macro right_space
   (
      (right)
      (save_position)
      (insert_char 0)
      (restore_position)
      (= line_dir 0)
   )
)
;**
;**  Macro to erase a character in the downward direction.
;**
(macro down_space
   (
      (down)
      (save_position)
      (insert_char 0)
      (restore_position)
      (= line_dir 0)
   )
)
;**
;**  Macro to erase a character in the leftward direction.
;**
(macro left_space
   (
      (left)
      (save_position)
      (insert_char 0)
      (restore_position)
      (= line_dir 0)
   )
)
;**
;**  Macro to insert a single space.
;**
(macro space_line
   (
      (insert_char 0)
      (= line_dir 0)
   )
)
;**
;**  Macro to exit the line drawing mode.
;**
(macro exit_line
   (
      (keyboard_pop)
      (exit)
   )
)
;**
;**  Macro to change the line drawing characters to single lines.
;**
(macro set_single_line
   (
      (= line_type 1)
      (line_on)
   )
)
;**
;**  Macro to change the line drawing characters to double lines.
;**
(macro set_double_line
   (
      (= line_type 2)
      (line_on)
   )
)
;**
;**  Macro to turn on line drawing.
;**
(macro line_on
   (
      (assign_to_key "%#72" "up_line")
      (assign_to_key "%#75" "left_line")
      (assign_to_key "%#77" "right_line")
      (assign_to_key "%#80" "down_line")
   )
)
;**
;**  Macro to turn off line drawing (and return to simple cursor moves).
;**
(macro line_off
   (
      (assign_to_key "%#72" "up")
      (assign_to_key "%#75" "left")
      (assign_to_key "%#77" "right")
      (assign_to_key "%#80" "down")
      (= line_dir 0)
   )
)
;**
;**  This is the line drawing state machine. This macro will generate a
;**  character based upon three items of info.
;**  1) The character under the cursor.
;**  2) The previous direction of the cursor movement.
;**  3) The current direction of the cursor movement.
;**  The last two items of information are encoded in the parameter as
;**  follows:
;**
;**    (previous_direction*4)+current_direction
;**
;**  A special case is the request for insertion of a blank in which case
;**  the parameter has a value of zero.
;**
(macro insert_char
   (
      (string sc)
      (int st)
      (get_parm 0 st)
      (= sc (read_it))
      (if (&& (== st 0) (!= sc "\n"))
         (
            (= sc " ")
            (if (!= (read 1) "\n")
               (delete_char)
            )
            (insert sc)
         )
      ;else
         (if (index "μ" sc)
            (
               (if (== sc "")
                  (= sc (substr "̺&ι&̺" st 1))
               ;else
                  (if (== sc "")
                     (= sc (substr "&&" st 1))
                  ;else
                     (if (== sc "")
                        (= sc (substr "˻˻˻ι" st 1))
                     ;else
                        (if (== sc "")
                           (= sc (substr "ʹιʹʹ" st 1))
                        ;else
                           (if (== sc "")
                              (= sc (substr "" st 1))
                           ;else
                              (if (== sc "")
                                 (= sc (substr "" st 1))
                              ;else
                                 (if (== sc "")
                                    (= sc (substr "" st 1))
                                 ;else
                                    (if (== sc "")
                                       (= sc (substr "" st 1))
                                    ;else
                                       (if (== sc "")
                                          (= sc (substr "" st 1))
                                       ;else
                                          (if (== sc "")
                                             (= sc (substr "ιιιι" st 1))
                                          ;else
                                             (if (== sc "")
                                                (= sc "")
                                             )
                                          )
                                       )
                                    )
                                 )
                              )
                           )
                        )
                     )
                  )
               )
               (if (!= sc "&")
                  (
                     (if (!= (read 1) "\n")
                        (delete_char)
                     )
                     (insert_it sc)
                  )
               )
            )
         ;else
            (if (== sc "\n")
               (
                  (= sc (substr "ͺͺ&ͻ&&Ⱥ&" st 1))
                  (if (!= sc "&")
                     (insert_it sc)
                  )
               )
            ;else
               (
                  (= sc (substr "ͺͺ&ͻ&&Ⱥ&" st 1))
                  (if (!= sc "&")
                     (
                        (if (!= (read 1) "\n")
                           (delete_char)
                        )
                        (insert_it sc)
                     )
                  )
               )
            )
         )
      )
   )
)
;**
;**  Macro to insert a line drawing character. Will translate from
;**  double lines to single lines if required by the current line mode.
;**
(macro insert_it
   (
      (string sc)

      (get_parm 0 sc)
      (if (== line_type 1)
         (
            (insert (substr "" (index "μ" sc) 1))
         )
      ;else
         (insert sc)
      )
   )
)
;**
;**  Macro to read character from screen. Will translate from single
;**  lines to double lines if required by the current line mode.
;**
(macro read_it
   (
      (string sc)

      (= sc (read 1))

      (if (== line_type 1)
         (if (!= 0 (index "" sc))
            (= sc (substr "μ" (index "" sc) 1))
         ;else
            (= sc " ")
         )
      )
      (return sc)
   )
)

