;---------------------------------------------------------;
; this file contains maps for the sprite map screen.      ;
;---------------------------------------------------------;

;---------------------------------------------------------
; Macros:


M_DEF_SPRITE	MACRO	[name,width,height,data]
m_spr_{name}	db	{width},{height}

	db	{data}

	ENDM

HFL	=	1<<14
VFL	=	1<<15

;---------------------------------------------------------

M_DEF_BASE	MACRO	[sprite,x,y]
	db	ms_addbase
	dw	m_spr_{sprite}
	dw	0
	db	{x},{y}
	ENDM

M_DEF_ENEMY	MACRO	[sprite,x,y,path]
	dw	m_spr_{sprite}
	dw	{path}
	db	{x},{y}
	ENDM

M_DEF_END	MACRO
	db	ms_end
	ENDM


;---------------------------------------------------------
; Sprite Definitions:

	M_DEF_SPRITE	cursor,2,2,<000,001,002,003>
	M_DEF_SPRITE	city1,4,3,<-1,$4,$5,$6,$7,$8,$a,$b,$c,$d,$e>
	M_DEF_SPRITE	city2,4,3,<$f,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1a>
	M_DEF_SPRITE	alien1,2,2,<$1b,$1b!HFL,$1c,$1c!HFL>
	M_DEF_SPRITE	alien2,2,2,<$1d,$1d!HFL,$1e,$1e!HFL>
	M_DEF_SPRITE	alien3,2,2,<$1f,$1f!HFL,$20,$20!HFL>
	M_DEF_SPRITE	alien4,2,2,<$21,$21!HFL,$22,$22!HFL>
	M_DEF_SPRITE	alien5,2,2,<$23,$23!HFL,$24,$24!HFL>
	M_DEF_SPRITE	alien6,2,2,<$25,$25!HFL,$26,$26!HFL>

;---------------------------------------------------------
; Map Definitions:

mapscreenbase	equ	*&(~WM)

map1
	M_DEF_BASE	city1,4,3
	M_DEF_END
