
wipeconf_XPOS	equ	0c0h

;===================================================================
;===================================================================
;===================================================================
;*******************************************************************
;*		***********************************************
;*  WIPE (8)		***********************************************
;*		***********************************************
;* (leftright door )	***********************************************
;*		***********************************************
;*	224line	***********************************************
;*******************************************************************
;===================================================================
;===================================================================
;===================================================================
;*******************************************************************
;	player-select battle mode
;*******************************************************************
wipeconf_close
wipeconf_open	
wipeconfig
	jsr	dc_program
	dwnext	config_init1
	dwnext	config_init2
	dwflag	config_loop

;*******************************************************************
;	wipeconfig
;*******************************************************************
config_init1
	jsr	w1initbuffer
	rts

;===================================================================
config_init2
	jsr	set_param
	db	00h,033h,00h
	db	00h,000h
	db	00h
	db	00h,00h,0e0h
	rts

;===================================================================

config_loop

	jsr	swap_bufferFULL		; window swap !!

	ldy	#16*4
	ldx	#bpsel_p1
	jsr	p1_go

	ldy	#(16+80h)*4
	ldx	#bpsel_p2
	jsr	p1_go	

	rts

;-------------------------------------------------------------------
p1_go	lda	_bpselprocess,x
	cmp	#idx_bpsel_configopen
	beq	.entry
	cmp	#idx_bpsel_configclose
	beq	.entry
	rts

;-------------------------------------------------------------------
.entry
	lda	_bpselcounter,x
	sec
	sbc	#6
	bpl	.skip
	lda	#0
.skip	cmp	#24
	bcs	.exit
	and	#00ffh
	sta	Xwork2

;-------------------------------------------------------------

	a8
	lda	Xwork2
	asl	a
	asl	a
	pha
	eor	#0ffh
	sec
	adc	#wipeconf_XPOS+1
	sta	wipe1_LR+0	; wipe left position
	pla
	clc
	adc	#wipeconf_XPOS
	cmp	#wipeconf_XPOS
	bcs	.skip2
	lda	#0ffh
.skip2	sta	wipe1_LR+1	; wipe right position
	a16
;-------------------------------------------------------------
	jsr	w1setbuffer

.exit	rts


;===================================================================
;;
;;
;;
;;
;;
;;
;;
;;
;*******************************************************************
;	set wipe buffer ( main process )
;*******************************************************************
;
; y = wipe index
;
;
;
; Xaddr  wipe buffer address
;
; Xwork0 left  addition
; Xwork1 right addition
; Xwork2 
;
;-------------------------------------------------------------------


;-------------------------------------------------------------------

w1setbuffer


;-----------------------------------------
	lda	Xwork2	; counter
	asl	a
	eor	#0ffffh ; << negative >>
	sec
	adc	#28h
	tax
	lda	#0001h
	jsr	.set
;-----------------------------------------
	lda	Xwork2	; counter
	asl	a
	asl	a
	tax
	lda	wipe1_LR
	jsr	.set
;-----------------------------------------
	lda	Xwork2
	asl	a
	eor	#0ffffh	; << negative >>
	sec
	adc	#28h
	tax
	lda	#0001h
	jsr	.set
;-----------------------------------------
	rts


;=====================================================
;;;; x == counter
;;;; y == index
;;;; a == data
;=====================================================
.set	cpx	#0		; loopcount check
	beq	.exit
	bmi	.exit
	cpy	#223*4		; max windowline !!
	bcs	.exit

.loop	sta	(Xaddr),y
	iny
	iny
	iny			; window2 
	iny
	cpy	#223*4		; max windowline !!
	bcs	.exit
	dex
	bne	.loop

.exit	rts

;*******************************************************************
;	initialize wipe buffer
;*******************************************************************
;
; a = clear data
; x = wipe index
;
;-------------------------------------------------------------------
w1initbuffer
	ldy	#224
	ldx	#wipe_bufferA1&0ffffh

	lda	#wipeconf_XPOS*256+wipeconf_XPOS+1
.loop
	sta.w	0,x		;  buffer A
	sta.w	Fwipe_full*4,x	;  buufer B

	inx
	inx
	inx
	inx
	dey
	bne	.loop

	rts


;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
;====================================================================
