		NOLIST
;
;-----------------------------------------------------------------------
WORK		EQU	00000H			; work area
WORK0		EQU	WORK
WORK1		EQU	WORK0+1
WORK2		EQU	WORK1+1
WORK3		EQU	WORK2+1
WORK4		EQU	WORK3+1
WORK5		EQU	WORK4+1
WORK6		EQU	WORK5+1
WORK7		EQU	WORK6+1
WORK8		EQU	WORK7+1
WORK9		EQU	WORK8+1
WORKA		EQU	WORK9+1
WORKB		EQU	WORKA+1
WORKC		EQU	WORKB+1
WORKD		EQU	WORKC+1
WORKE		EQU	WORKD+1
WORKF		EQU	WORKE+1
;-----------------------------------------------------------------------
WINDCT		EQU	00010H		; Window counter
;;;;;;		EQU	00011H		;
WINDWL		EQU	00012H		; Window left address
;;;;;;		EQU	00013H		;
WINDWR		EQU	00014H		; Window right address
;;;;;;		EQU	00015H		;
WINDWU		EQU	00016H		; Window up address
;;;;;;		EQU	00017H		;
WINDWD		EQU	00018H		; Window under address
;;;;;;		EQU	00019H		;
SL3FLG		EQU	0001AH		; Yes or no flag
;;;;;;		EQU	0001BH		;
MARKCT		EQU	0001CH		; Mario mark counter
YSPED0		EQU	0001DH		; Yspead
SCVPS0		EQU	0001EH		; calc
SCVPS1		EQU	0001FH		; calc
SCVPS2		EQU	00020H		; calc
SPDIDX		EQU	00021H		; spead index
FLSHCT		EQU	00022H		; Flash count
FLSIDX		EQU	00023H		; Flash data index
FLSEND		EQU	00024H		; Flash end flag
SNDFLG		EQU	00025H		; ?????????
OMCLFG		EQU	00026H		; Oam clear cancel flag
KYINFG		EQU	00027H		; Start key on flg
CLRTIM		EQU	00028H		; Coler flashing timer
INDEX		EQU	00029H		; INDEX
;-----------------------------------------------------------------------
SOUND0		EQU	00060H
SOUND1		EQU	00061H
SOUND2		EQU	00062H
SOUND3		EQU	00063H
SVSND0		EQU	00064H
SVSND1		EQU	00065H
SVSND2		EQU	00066H
SVSND3		EQU	00067H
;-----------------------------------------------------------------------
URADAT		EQU	00070H
WALDDT		EQU	00080H
CORSDT1		EQU	00090H
WARPDT		EQU	000A0H
;-----------------------------------------------------------------------
WALDNO		EQU	000B0H	;000BFH
;
CORSNO		EQU	000C0H	;000CFH
;-----------------------------------------------------------------------
GAMENO		EQU	000D0H
PLAYNO		EQU	000D1H
GMCLMD		EQU	000D2H
FLSCNT		EQU	000D3H
;
SCRVFG		EQU	000DEH			; screen vma flag
;-----------------------------------------------------------------------
SLMODE		EQU	000E0H			; select mode
GMMODE		EQU	SLMODE+1		; game mode
DEMOTIME	EQU	GMMODE+2		; demo timer
WIPE_ADR	EQU	DEMOTIME+2		; wipe DMA
DMTMPT		EQU	WIPE_ADR+2		; demo time data point
;
;-----------------------------------------------------------------------
VWORK		EQU	000E8H			; DMA used work
VWORK0		EQU	VWORK
VWORK1		EQU	VWORK0+1
VWORK2		EQU	VWORK1+1
VWORK3		EQU	VWORK2+1
VWORK4		EQU	VWORK3+1
VWORK5		EQU	VWORK4+1
VWORK6		EQU	VWORK5+1
VWORK7		EQU	VWORK6+1
;-----------------------------------------------------------------------
KEYA1		EQU	000F0H			; key repeat (A,B,sl,st,u,d,l,r)
KEYB1		EQU	000F1H			;
KEYA1L		EQU	000F2H			;	     (X,Y,L,R	       )
KEYB1L		EQU	000F3H			;
KEYA2		EQU	000F4H			;     triga
KEYB2		EQU	000F5H			;
KEYA2L		EQU	000F6H			;
KEYB2L		EQU	000F7H			;
KEYBF		EQU	000F8H			;     back_up
KEYBFL		EQU	000FAH			;
;
;
FCNT		EQU	000FDH			; frame count
FRCNT		EQU	FCNT			;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
STACK		EQU	00100H			; stack area
;
WD2100		EQU	STACK			; 2100H : Blanking
WD2101		EQU	WD2100+1		; 2101H : OBJ. size&address
WD2105		EQU	WD2101+1		; 2105H : BG. mode & char. size
WD2106		EQU	WD2105+1		; 2106H : Mozaiku
WD2107		EQU	WD2106+1		; 2107H : BG.1 screen address&size
WD2108		EQU	WD2107+1		; 2108H : BG.2
WD2109		EQU	WD2108+1		; 2109H : BG.3
;
WD210B		EQU	WD2109+1		; 210BH : BG.1 character address
;
WD210D		EQU	WD210B+1		; 210DH : BG.1 scroll count-H
SCCH1		EQU	WD210D			;
SCCH11		EQU	WD210D+1		;
WD210E		EQU	WD210D+2		; 210EH :      scroll count-V
SCCV1		EQU	WD210E			;
SCCV11		EQU	WD210E+1		;
WD210F		EQU	WD210E+2		; 210FH : BG.2 scroll count-H
SCCH2		EQU	WD210F			;
SCCH21		EQU	WD210F+1		;
WD2110		EQU	WD210F+2		; 2110H :      scroll count-V
SCCV2		EQU	WD2110			;
SCCV21		EQU	WD2110+1		;
WD2111		EQU	WD2110+2		; 2111H : BG.3 scroll count-H
SCCH3		EQU	WD2111			;
SCCH31		EQU	WD2111+1		;
WD2112		EQU	WD2111+2		; 2112H :      scroll count-V
SCCV3		EQU	WD2112			;
SCCV31		EQU	WD2112+1		;
OFFSCTL		EQU	SCCV3			; offset address-L
OFFSCTH		EQU	OFFSCTL+1		;		-H
;
WD2123		EQU	WD2112+2		; 2123H : Window mask BG.1,2
WD2124		EQU	WD2123+1		; 2124H :		 3,4
WD2125		EQU	WD2124+1		; 2125H :		 color,obj.
;
WD212A		EQU	WD2125+1		; 212AH : window mask logic BG.1,2,3,4
WD212B		EQU	WD212A+1		; 212BH :		    color,obj
;
WD212C		EQU	WD2125+1		; 212CH : Display main
DPMAIN		EQU	WD212C			;
WD212D		EQU	WD212C+1		; 212DH :	  sub
DPSUB		EQU	WD212D			;
;
WD212E		EQU	WD212D+1		; 212EH : window display main
WD212F		EQU	WD212E+1		; 212FH :		 sub
;
WD2130		EQU	WD212F+1		; 2130H : colr window on/off & CC add.
WD2131		EQU	WD2130+1		; 2131H : ADD,SUB enable
;
WD2132R		EQU	WD2131+1		; 2132H [RED] : Color constant data
WD2132G		EQU	WD2132R+1		;	[GREEN]
WD2132B		EQU	WD2132G+1		;	[BLUE]
;
WD420C		EQU	WD2132B+1		; 420CH : H-DMA on/off flag
;-----------------------------------------------------------------------
NMIIRQFG	EQU	WD420C+1		; NMI/IRQ mode
NMIFLG		EQU	NMIIRQFG+1		; NMI check flag
NMICFG		EQU	NMIFLG+1		;     check flag
IRQSWFG		EQU	NMICFG+1		; IRQ swich flag
IRQVCT		EQU	IRQSWFG+1		;     V-counter
irqvct		EQU	IRQVCT+1		;
;-----------------------------------------------------------------------
ROM_ADDR	EQU	0150H			; rom-check address
ROM_BANK	EQU	0152H			; rom-check bank
ROM_NMI		EQU	0154H			; rom-nmi flag
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;----------------------------------------------- aada used ram
LGIDX0		EQU	00200H		; luige index 0
LGIDX1		EQU	LGIDX0+1	;   "     "   1
PCIDX		EQU	LGIDX1+1	; peach index
KNIDX		EQU	PCIDX+1		; kinopio index
CSIDX0		EQU	KNIDX+1		; casarin index 0
CSIDX1		EQU	CSIDX0+1	;   "       "	1
CSIDX2		EQU	CSIDX1+1	;   "       "	2
KBIDX		EQU	CSIDX2+1	; kurbo index
BKIDX		EQU	KBIDX+1		; bakdan index
TGIDX		EQU	BKIDX+1		; togezow index
DDIDX		EQU	TGIDX+1		; ddriges index
MRIDX0		EQU	DDIDX+1		; mario index 0
MRIDX1		EQU	MRIDX0+1	;   "     "   1
KPIDX		EQU	MRIDX1+1	; kuppa index
FRCT12		EQU	KPIDX+1		; frem count 12
FRCT08		EQU	FRCT12+1	;   "    "   08
FRCT16		EQU	FRCT08+1	;   "    "   16
FRCT32		EQU	FRCT16+1	;   "    "   32
TLPSFG		EQU	FRCT32+1	; light on pass flag
TLMVFG		EQU	TLPSFG+1	; light on all move flag
SCHV10		EQU	TLMVFG+1	; vu-vu-n
SCHV11		EQU	SCHV10+1	; vu-vu-n
SCHCTR		EQU	SCHV11+1	; right part scroll count
SCHCTL		EQU	SCHCTR+1	; left part scroll count
SLMRFG		EQU	SCHCTL+1	; mario game select flag
SLCHFG		EQU	SLMRFG+1	; select character set flag
SLONFG		EQU	SLCHFG+1	; wind ON flag
SLONCT		EQU	SLONFG+1	; select ON count
SLONAD		EQU	SLONCT+1	; select address
SLBFCT		EQU	SLONAD+2	; select buffer ram count
SLOFFG		EQU	SLBFCT+2	; wind OFF flag
ERASDT		EQU	SLOFFG+1	; erase data read count
NEWFLG		EQU	ERASDT+1	; data erase flag
SONWAT		EQU	NEWFLG+1	; sound waite ram
GOGMFG		EQU	SONWAT+1	; game start flag
FRASH2		EQU	GOGMFG+1	; 2 ka-i frashing
YOSIDX		EQU	FRASH2+2	; yo-si index
SLCHAD		EQU	YOSIDX+1	; select character address (B,H,L)
;;;;		EQU	SLCHAD+3
;-----------------------------------------------
SLCTBF		EQU	00400H		; select buffer ram
;					;  (00400H -- 00600H)
;-----------------------------------------------------------------------
TITLBF		EQU	7F0000H		; titl BG data ram buffer
SLDTBF		EQU	7F1000H		; select BG data ram buffer
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
OAM		EQU	00800H			; OAM main
OAM2		EQU	OAM+100H		;	   + 100H
OAMSUB		EQU	OAM+200H		;     sub
OAMSB		EQU	OAMSUB+20H		;     work sub
OAMSB2		EQU	OAMSB+(100H/4)		;	       + 40H
;
DWORK0		EQU	OAMSB+(200H/4)		; work area
DWORK1		EQU	DWORK0+1		;
DWORK2		EQU	DWORK1+1		;
DWORK3		EQU	DWORK2+1		;
DWORK4		EQU	DWORK3+1		;
DWORK5		EQU	DWORK4+1		;
DWORK6		EQU	DWORK5+1		;
DWORK7		EQU	DWORK6+1		;
DWORK8		EQU	DWORK7+1		;
DWORK9		EQU	DWORK8+1		;
DWORKA		EQU	DWORK9+1		;
DWORKB		EQU	DWORKA+1		;
DWORKC		EQU	DWORKB+1		;
DWORKD		EQU	DWORKC+1		;
DWORKE		EQU	DWORKD+1		;
DWORKF		EQU	DWORKE+1		;
DWORK10		EQU	DWORKF+1		;
DWORK11		EQU	DWORK10+1		;
DWORK12		EQU	DWORK11+1		;
DWORK13		EQU	DWORK12+1		;
DWORK14		EQU	DWORK13+1		;
DWORK15		EQU	DWORK14+1		;
DWORK16		EQU	DWORK15+1		;
DWORK17		EQU	DWORK16+1		;
DWORK18		EQU	DWORK17+1		;
DWORK19		EQU	DWORK18+1		;
DWORK1A		EQU	DWORK19+1		;
DWORK1B		EQU	DWORK1A+1		;
DWORK1C		EQU	DWORK1B+1		;
DWORK1D		EQU	DWORK1C+1		;
DWORK1E		EQU	DWORK1D+1		;
DWORK1F		EQU	DWORK1E+1		;
;
;
CGDMAF		EQU	DWORK1F+1		; CG. DMA flag
ANMDMAF		EQU	CGDMAF+1		; animation DMA flag
;
CCNGFG		EQU	CGDMAF+10H		; CG. change flag (0:fade-out , 2:fade-in)
CCNGCT		EQU	CCNGFG+2		;	     counter
CCNGED		EQU	CCNGCT+2		;	     END counter
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
BG3SCR		EQU	01000H			; BG.3 screen buffer
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
SNDBUF3		EQU	7E8000H			; sound buffer
;
;-----------------------------------------------------------------------
SNDBUFF		EQU	7F0000H			; sound buffer
;
;-----------------------------------------------------------------------
GAME_NO		EQU	7FFF00H
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
VRAMD		EQU	7F8000H			; VRAMD
VRAMD2		EQU	VRAMD+2
;
;-----------------------------------------------------------------------
CGRAM		EQU	VRAMD+1000H		; CGRAM
;
CGWORK		EQU	CGRAM+200H		; CGWORK
;
;-----------------------------------------------------------------------
HDMADR		EQU	CGWORK+200H		; H-DMA
;
HDMABF		EQU	HDMADR+003H*0F0H	;
HDMABF1		EQU	HDMABF+200H		;
HDMABF2		EQU	HDMABF1+200H		;
HDMABF3		EQU	HDMABF2+200H		;
HDMABF4		EQU	HDMABF3+200H		;
HDMABF5		EQU	HDMABF4+200H		;
;
;-----------------------------------------------------------------------
;SDPORT0		EQU	HDMABF+(080H*02H)*2	; sound0 buffer
;
;-----------------------------------------------------------------------
CGCHDT		EQU	HDMABF5+200H		; CGCHDT
;
CGCHRM		EQU	CGCHDT+080H		; CGCHRM
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;;;not used;;;	EQU	700000H		;
;;;not used;;;	EQU	700001H		;
RMCHK1		EQU	700002H		; RAM CHECK1
;;;;;;		EQU	700003H		;
SVINDX		EQU	700004H		; SAVE RAM INDEX
;;;;;;		EQU	700005H		;
KEYMOD		EQU	700006H		; PLAY KEY MODE
DEBUG		EQU	700007H		;
WALDRM		EQU	700008H		; WOLD RAM
CORSRM		EQU	700009H		; CORS RAM
;free;		EQU	70000AH		;
;free;		EQU	70000BH		;
;free;		EQU	70000CH		;
;free;		EQU	70000DH		;
PLNOWK		EQU	70000EH		;
GMNOWK		EQU	70000FH		;
SAVERM		EQU	700010H		; SAVE RAM
;
SAVE_RAM	EQU	700010H				;
MR1PLA		EQU	SAVERM				; MARIO-1  PLAYER A
m1_world	EQU	MR1PLA				;
m1_plcnt	EQU	m1_world+3			;
;;;;;;;;;;;;;;;;;;m1_top	  EQU	  m1_plcnt+2			  ;
;;;;;;;;;;;;;;;;;;m1_ura	  EQU	  m1_top+6			  ;
m1_ura		EQU	m1_plcnt+2			;
m1_2play	EQU	m1_ura+1			;
m1_sum		EQU	m1_2play+1			;
;
MR2PLA		EQU	m1_sum+2			; MARIO-2  PLAYER A
m2_world	EQU	MR2PLA				;
m2_plcnt	EQU	m2_world+3			;
;;;;;;;;;;;;;;;;;;m2_top	  EQU	  m2_plcnt+1			  ;
;;;;;;;;;;;;;;;;;;m2_warp	  EQU	  m2_top+6			  ;
m2_warp		EQU	m2_plcnt+1			;
m2_new		EQU	m2_warp+1			;
m2_sum		EQU	m2_new+1			;
;
MRUPLA		EQU	m2_sum+2			; MARIO-U  PLAYER A
mu_world	EQU	MRUPLA				;
mu_plcnt	EQU	mu_world+2			;
mu_down		EQU	mu_plcnt+1			;
mu_sum		EQU	mu_down+4			;
;
MR3PLA		EQU	mu_sum+2			; MARIO-3  PLAYER A
m3_world	EQU	MR3PLA				;
m3_playct	EQU	m3_world+2			;
m3_enmy		EQU	m3_playct+2			;
m3_map		EQU	m3_enmy+(00EH*4)		;
m3_item		EQU	m3_map+080H			;
m3_takara	EQU	m3_item+046H			;
m3_2play	EQU	m3_takara+1			;
m3_sum		EQU	m3_2play+1			;
;
MR1PLB		EQU	m3_sum+2			; MARIO-1  PLAYER B
MR2PLB		EQU	MR1PLB+(MR2PLA-MR1PLA)		; MARIO-2  PLAYER B
MRUPLB		EQU	MR2PLB+(MRUPLA-MR2PLA)		; MARIO-U  PLAYER B
MR3PLB		EQU	MRUPLB+(MR3PLA-MRUPLA)		; MARIO-3  PLAYER B
;
MR1PLC		EQU	MR3PLB+(MR1PLB-MR3PLA)		; MARIO-1  PLAYER C
MR2PLC		EQU	MR1PLC+(MR2PLA-MR1PLA)		; MARIO-2  PLAYER C
MRUPLC		EQU	MR2PLC+(MRUPLA-MR2PLA)		; MARIO-U  PLAYER C
MR3PLC		EQU	MRUPLC+(MR3PLA-MRUPLA)		; MARIO-3  PLAYER C
;
MR1PLD		EQU	MR3PLC+(MR1PLB-MR3PLA)		; MARIO-1  PLAYER D
MR2PLD		EQU	MR1PLD+(MR2PLA-MR1PLA)		; MARIO-2  PLAYER D
MRUPLD		EQU	MR2PLD+(MRUPLA-MR2PLA)		; MARIO-U  PLAYER D
MR3PLD		EQU	MRUPLD+(MR3PLA-MRUPLA)		; MARIO-3  PLAYER D
;
URADAT2		EQU	MR3PLD+(MR1PLB-MR3PLA)		; END
;
;
MR4PLA		EQU	701000H				; MARIO-4 PLAYER A
MR4PLB		EQU	MR4PLA+08FH			; MARIO-4 PLAYER B
MR4PLC		EQU	MR4PLB+08FH			; MARIO-4 PLAYER C
MR4PLD		EQU	MR4PLC+08FH			; MARIO-4 PLAYER D
;
;
MR1_TOP		EQU	701FE0H				; mario-1 Top-score
MR2_TOP		EQU	701FE8H				; mario-2
;
;
ZANMAI_DEMO	EQU	701FF0H		; zanmai demo count
ZANMAI_FLG	EQU	701FF2H		; zanmai demo flag
;
P_KEYMD0	EQU	701FF4H		; 1player controlor mode
P_KEYMD1	EQU	701FF6H		; 2player
;
NOW_BSLFG	EQU	701FF8H			; ura-now BSLFG
NOW_CORSNO	EQU	701FF9H			; ura-now CORSNO
;
RMCHK2		EQU	701FFCH		; RAM CHECK2
;-----------------------------------------------------------------------
;;;;;;; MARIO 1 SAVE RAM	;;;;;;;;;;;;;;;;;;;;;
CORSNO_1	EQU	075FH		; world NO.
GOALCT_1	EQU	075CH		; goal NO.
CORSID_1	EQU	0760H		; course NO.
PLCNT_1		EQU	075AH		; 1 PLAYER COUNT
WPLCNT_1	EQU	0761H		; 2 PLAYER COUNT
PLAYSW_1	EQU	077AH		; PLAYER SWICH
TOPSCR_1	EQU	07C8H		; TOP SCORE
;;;;;;;;	EQU	07C9H
;;;;;;;;	EQU	07CAH
;;;;;;;;	EQU	07CBH
;;;;;;;;	EQU	07CCH
;;;;;;;;	EQU	07CDH
BSLFG_1		EQU	07FCH		; URA FLAG
;
WCRSNO_1	EQU	0766H		; world NO.(save)
WGOLCT_1	EQU	0763H		; goal NO.
WCRSID_1	EQU	0767H		; course NO.
WBSLFG_1	EQU	0781H		; ura-flag
;
MRLGFG_1	EQU	0753H		; mario/luigi flag
;
;-----------------------------------------------------------------------
;;;;;;; MARIO 2 SAVE RAM	;;;;;;;;;;;;;;;;;;;;;
CORSNO_2	EQU	075FH		; world NO.
GOALCT_2	EQU	075CH		; goal NO.
CORSID_2	EQU	0760H		; course NO.
PLCNT_2		EQU	075AH		; 1 PLAYER COUNT
TOPSCR_2	EQU	07C8H		; TOP SCORE
;;;;;;;;	EQU	07C9H
;;;;;;;;	EQU	07CAH
;;;;;;;;	EQU	07CBH
;;;;;;;;	EQU	07CCH
;;;;;;;;	EQU	07CDH
WARPCT_2	EQU	0F2BH		; WARP COUNT
;
;-----------------------------------------------------------------------
;;;;;;; MARIO USA SAVE RAM	;;;;;;;;;;;;;;;;;;;;;
STWRDNO_USA	EQU	04E8H		; WORLD NO
WORDNO_USA	EQU	0533H		; WORLD NO
COSUNO_USA	EQU	0534H		; CORS NO
PLCNT_USA	EQU	04EEH		; PLAYER COUNT
PLDOWN_USA	EQU	062DH		; PLAYER DIE COUNT (MARIO)
;;;;;;		EQU	062EH		; PLAYER DIE COUNT (PEACH)
;;;;;;		EQU	062FH		; PLAYER DIE COUNT (KINOPIO)
;;;;;;		EQU	0630H		; PLAYER DIE COUNT (LUIGI)
;-----------------------------------------------------------------------
;;;;;;; MARIO 3 SAVE RAM	;;;;;;;;;;;;;;;;;;;;;
MAPCOS_3	EQU	00727H		; map couce NO.
;
PLAYCT_3	EQU	00736H		; player ninzuu counter flag (02h)
;
MPEYPS_3	EQU	01EEDH		; MAP enemy Y-position	 (0Eh)
MPEXPL_3	EQU	01EFBH		; MAP enemy X-position L (0Eh)
MPEXPH_3	EQU	01F09H		; MAP enemy X-position H (0Eh)
MPENNO_3	EQU	01F17H		; MAP enemy no. flag	 (0Eh)
;
BITBUFF_3	EQU	01D00H		; map cose claer ram (40h*40h)
ITEMRM_3	EQU	01D80H		; Item RAM buffer (01Ch) mario
;;;;;;		EQU	01D9CH		; claer item ram  (003h)
;;;;;;		EQU	01D9FH		; to-ku-te-n ram  (003h)
;;;;;;		EQU	01DA2H		; coin count ram  (001h)
;;;;;;		EQU	01DA3H		; Item RAM buffer (01Ch)luigi
;;;;;;		EQU	01DBFH		; claer item ram  (003h)
;;;;;;		EQU	01DC2H		; to-ku-te-n ram  (003h)
;;;;;;		EQU	01DC5H		; coin count ram  (001h)
;
TSHIPF_3	EQU	7E3971H		; TAKARA_BUNE FLAG
;
PLINIT_3	EQU	00072BH		; 2PLAY MODE? (2=2PLAY)
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
SAVEBF		EQU	7FFB00H		; SAVE DATA LOAD BUFFER
;
SVCORS		EQU	7FFF02H		; SAVE COURS NO
NOTSALE		EQU	7FFF03H		; MARIO-3 BUBUN SAVE FLAG
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;
;		END
		LIST
