;
	include		mn_hp_smram.asm
;
	 ORG	  3C3B0H
		EXTEND
		IDX8
		MEM8
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1985. 8.12	    V.1.0  Super Mario
;				   File name : SMENMY
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMSUB0 ==
	 EXT	  KFINIT,KFMOVE,FENPCV,BKM0ST,BKFSET
;=========================================================== SMMAIN ==
	 EXT	  SCMOD,BGBV90,BGBV100
;........................................................... ( VRFLG No. )
;=========================================================== SMINIT ==
	 EXT	  FRTADC
;=========================================================== SMPLAY ==
	 EXT	  ENCLX0,ENGCAL,ENGCL2,ENGCLS,ENFCLS
	 EXT	  LFGCL0,LFGCL1,LFGCL2,ENGCL3,ENGC15
	 EXT	  GCALC,LFGCLH
;........................................................... ( Player flag )
	 EXT	  WKRT
;........................................................... ( Statsu )
	 EXT	  BWALK,BJUMP,BDROP,PWIRE
;........................................................... ( Mode No. )
	 EXT	  PLSB,PLBS,PLBX,PLSF,PLTPMD,PLCRMD
;=========================================================== SMCSET ==
	GLB	CFLGM120
;=========================================================== SMENMY ==
	 GLB	  ENEMY,ENGAWY,ENLDWY,FXFWRES,ENWKMV,ENPYMV,FIEN10
	 GLB	  ENCLER,YCLCLR,BITDT,BKMEND,ENSPCHK
;........................................................... ( Statsu )
	 GLB	  WALK,DOWN,JUMP,STOP,TIME,DROP,FIRE
;........................................................... ( Enmey learve point )
;........................................................... ( Enemy kind No. )
	 GLB	  SHTR,BKTR,RDTR,TUTR,FIEN,YPVS,FTM0,JPTR
	 GLB	  FTR2,FTR6,FTR7,WTR0,WTR1,ENDTR
	 GLB	  EXT0,EXT1,EXFF,ESHP,BKF0,BKM0,IKTR,FLWR
	 GLB	  JFS0,TMK0,ELP0
	 GLB	  BRG0,SST0,SST1,SST2,SST3,SST4
	 GLB	  LFT0,LFT1,LFT2,LFT3,LFT4,LFT5,LFT6,ELV0,ELV1
	 GLB	  GSHL,GFLG,BMUS,BWOD,SPRG
	 GLB	  FRW0,CFLG,NOT1,GIAL
	 GLB	  FTR0 ;<-- dammy
;
	 GLB	  FREND
	 GLB	  GRP0,GRP1,GRP2,GRP3,GRP4,GRP5,GRP6,GRP7
;
	GLB	ENCLER2
;=========================================================== SMEXST ==
	 EXT	  WDINIT,WDMOVE,MSINT1,MSMOVE
	 EXT	  HMINIT,BKPSSET,STBBK,SPRING
	 EXT	  BKSCUP,NOTRMV1,FWCMD
;=========================================================== SMCSET ==
	 EXT	  ENCSET,LFCSET,ELCSET,FICST4X,FICS99,FICS99X
	 EXT	  ENFRCK,ENPSCV
	 EXT	  GFCSET
;=========================================================== SMCROS ==
	 EXT	  CRDTST,ENCRDS,HEDC10,CRECMP,LFCRDS,CRENEN,ELCRDS
	 EXT	  CRENPL,CRLFPL,CRELPL,CRENBG,CREPMS
	 EXT	  PLONLF,PLONEL,SCRSET
;;;;;;;; EXT	  CRBKBG
;........................................................... ( Cross size No. )
	 EXT	  PBCMD,PSCMD,ENCMD,ELCMD,LFCMD,FICMD,LFCMD2
	 EXT	  ENCMD2,GUCMD,BKCMD,FICMD2,FECMD
;=========================================================== SMBGOT ==
;........................................................... ( BG block kind No. )
	 EXT	  SPRIG
;=========================================================== SMCOM ===
	 EXT	  JSRSUB,CAINC,PLSCR20
;=========================================================== SMFRDT ==
;........................................................... ( Castle frame loop )
	 EXT	  CSFLDT
;=====================================================================
;
;
;#####################################################################
;#	 Enemy	status value					     #
;#####################################################################
WALK	 EQU	  000H	    ; Walking
DOWN	 EQU	  001H	    ; Downing
JUMP	 EQU	  002H	    ; Jumping
FIRE	 EQU	  002H	    ; Fire
STOP	 EQU	  003H	    ; Stop
TIME	 EQU	  004H	    ; Timing
DROP	 EQU	  005H	    ; Bakudan dropping
;
;#####################################################################
;#	 Enemy No.						     #
;#####################################################################
SHTR	 EQU	  000H		       ; Enemy Normal green
RDTR	 EQU	  001H		       ;       Red
BKTR	 EQU	  002H		       ;       Brack
TUTR	 EQU	  003H		       ;       Turn low speed
;	 EQU	  004H		       ;    ?????????????????????????
FIEN	 EQU	  005H		       ; Fire enemy
YPVS	 EQU	  006H		       ; Walk Mush
IKTR	 EQU	  007H		       ;       Ika
FTM0	 EQU	  008H		       ;       Flying tama
FTR0	 EQU	  009H		       ; ??? <-- dammy ???
WTR0	 EQU	  00AH		       ;       in water-0
WTR1	 EQU	  00BH		       ;	       -1
JPTR	 EQU	  00CH		       ;  Jump from water
FLWR	 EQU	  00DH		       ;       flower
FTR2	 EQU	  00EH		       ;       Jumping
FTR6	 EQU	  00FH		       ;       UF & DW floot
FTR7	 EQU	  010H		       ;       LF & RT swing
ESHP	 EQU	  011H		       ;       ship
;
EXT0	 EQU	  012H		       ;       Fall chara-0 ( bakudan )
EXT1	 EQU	  013H		       ;		 -1 ( bakudan )
JFS0	 EQU	  014H		       ;       jump fish-0
;
ENDTR	 EQU	  015H
;
BKF0	 EQU	  ENDTR		       ; Big kame fire
FRW0	 EQU	  016H		       ; Fireworks
TMK0	 EQU	  017H		       ; timer check kame
EXFF	 EQU	  018H		       ; Countinue out chara stop
;
BRG0	 EQU	  019H		       ;??? <-- dammy ???
;	 EQU	  01AH		       ;???????????????????
SST0	 EQU	  01BH		       ; Short Spin Stick-0
SST1	 EQU	  01CH		       ;		 -1
SST2	 EQU	  01DH		       ;		 -2
SST3	 EQU	  01EH		       ;		 -3
SST4	 EQU	  01FH		       ; Long		 -4
;	 EQU	  020H		       ;???????????????????
;	 EQU	  021H		       ;???????????????????
;	 EQU	  022H		       ;???????????????????
ELP0	 EQU	  023H		       ; ??? <-- dammy ???
LFT0	 EQU	  024H		       ; Lift duble
LFT1	 EQU	  025H		       ;      single UP & DW
LFT2	 EQU	  026H		       ;      UP
LFT3	 EQU	  027H		       ;      DW
LFT4	 EQU	  028H		       ;      LF & RT swing
LFT5	 EQU	  029H		       ; On down lift
LFT6	 EQU	  02AH		       ; Remort controle lift
ELV0	 EQU	  02BH		       ; Elevator UP
ELV1	 EQU	  02CH		       ;	  DW
BKM0	 EQU	  02DH		       ; Big kame
;
BMUS	 EQU	  02EH		       ; Bonus mushroom in block
BWOD	 EQU	  02FH		       ;       wood
GFLG	 EQU	  030H		       ; Gorl flag
CFLG	 EQU	  031H		       ; Castle flag
SPRG	 EQU	  032H		       ; Spring
GSHL	 EQU	  033H		       ; Gun shell
NOT1	 EQU	  034H		       ; Nothing TR1
GIAL	 EQU	  035H		       ;  Girl
;
FREND	 EQU	  036H		       ; Frame/course end corde
;
GRP0	 EQU	  037H		       ; Group enemy-0
GRP1	 EQU	  038H		       ;	    -1
GRP2	 EQU	  039H		       ;	    -2
GRP3	 EQU	  03AH		       ;	    -3
GRP4	 EQU	  03BH		       ;	    -4
GRP5	 EQU	  03CH		       ;	    -5
GRP6	 EQU	  03DH		       ;	    -6
GRP7	 EQU	  03EH		       ;	    -7
GRPZ	 EQU	  03FH		       ;   end
;
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENEMY	    [ Enemy pros ]			     #
;#####################################################################
ENEMY	 EQU	  $
;
	 LDA	  <ENCMOD,X
	 PHA
	 ASL	  A
	 BCS	  ENPTCK    ;- IF  proteck enemy ?  ( YES ; ENPTCK )
;
	 PLA
	 BEQ	  ENMY80    ;- IF  empty area ?	    ( YES ; ENMY80 )
;
;			    < Enemy move >
	 JMP	  ENPROS	       ; Enemy move pros
;
ENMY80	 EQU	  $	    ; Enemy out !
	 LDA	  NWSTCT
	 AND	  #00000111B
	 CMP	  #00000111B
	 BEQ	  ENPC90	  ;- IF	 BG data read timing ?	( YES ; ENPC90 )
;
	 JMP	  ENOUT		       ; Enemy out
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENPTCK    [ Enemy proteck check ]		     #
;#####################################################################
ENPTCK	 EQU	  $
	 PLA
	 AND	  #00001111B
	 TAY
;
	 LDA	  ENCMOD,Y
	 BNE	  ENPC90	  ;- IF	 main enemy display ?  ( YES ; ENPC90 )
;
	 STA	  <ENCMOD,X		; Protect OFF
;
ENPC90	 EQU	  $
;
	 RTS
;
;*********************************************************************
;*	 Castle frame loop set			   (FRLPSET)	     *
;*	 [in]	  (y)	      <-- data pointer			     *
;*********************************************************************
CSWLDT	 EQU	  $	      ;world no. data
;		   0  1	 2  3  4  5  6	7
	 HEX	  03,03,06,06,06,06,06,06
;		   8  9	 A
	 HEX	  07,07,07
;
CSWLED	 EQU	  $
;
CSXHDT	 EQU	  $	      ;x-pos.(H) data
;		   0  1	 2  3  4  5  6	7
	 HEX	  05,09,04,05,06,08,09,0A
;		   8  9	 A
	 HEX	  07,0B,10
;
CSPYDT	 EQU	  $	      ;player y-pos. data
;		   0  1	 2  3  4  5  6	7
	 HEX	  40,B0,B0,80,40,40,80,40
;		   8  9	 A
	 HEX	  F0,F0,F0
;
;;;;;
;;;;;CSDCDT   EQU      $	   ;dec. count data
;;;;;;			0  1  2	 3  4  5  6  7
;;;;;	      HEX      04,04,00,00,04,00,00,04
;;;;;;			8  9  A
;;;;;	      HEX      04,04,04
;;;;;
;
;
FRLPSET	 EQU	  $
;;;;;	      LDA      CSDCDT,Y
;;;;;	      STA      WORK
;

	 LDA	  <PLXPS0
	 SEC
	 SBC	  #04H
	 STA	  <PLXPS0      ;PLXPS0 - 4
;
	 LDA	  FRPTP0
	 SEC
	 SBC	  #04H
	 STA	  FRPTP0      ;FRPTP0 - 4
;
	 LDA	  DSXP00
	 SEC
	 SBC	  #04H
	 STA	  DSXP00      ;DSXP00 - 4
;
	 LDA	  DSXP10
	 SEC
	 SBC	  #04H
	 STA	  DSXP10      ;DSXP10 - 4
;
	 LDA	  OBXHCT
	 SEC
	 SBC	  #04H
	 STA	  OBXHCT      ;OBXHCT - 4
;
	 LDA	  #00H
	 STA	  FCXHFG
	 STA	  OBXHFG
;
	 STA	  FXCHPT
	 STA	  FCXHCT      ;
;
	PHX
	TYX
	 LDA	  >CSFLDT,X
	 STA	  OBDTPT
	PLX
		STZ	!LPSDFG
	 RTS
;
;
;*********************************************************************
;*	 Enemy out				   (ENOUT)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ENOUT	 EQU	  $
;*********************************************************************
;*	 Fix chara. out & Read information data	   (FXCHOT)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
FXCHOT		EQU	$
		LDA	FRLPFG
		BNE	FXC0015		; frame loop ?
		JMP	FXC010		;	NO -> FXC010
FXC0015		EQU	$
		LDA	FRPTP1
		BNE	FXC010		; check ok ?
;					; yes
	 LDY	  #CSWLED-CSWLDT
FXC001	 EQU	  $
	 DEY
	 BMI	  FXC010      ;check end ?
;			      ;no
	 LDA	  CORSNO
	 CMP	  CSWLDT,Y
	 BNE	  FXC001      ;world no. = ?
;			      ;yes
	 LDA	  FRPTP0
	 CMP	  CSXHDT,Y
	 BNE	  FXC001      ;x-pos.(H) = ?
;			      ;yes
	 LDA	  PLYPS1
	 CMP	  CSPYDT,Y
	 BNE	  FXC004      ;player y-pos. ok ?
;			      ;yes
	 LDA	  <PLSTAT
	 CMP	  #BWALK
	 BNE	  FXC004      ;player walk ?
;			      ;yes
		LDA	!LPSDFG
		BNE	FXC003_1		; sound set ok ?
;						; yes
		LDA	#029H
		STA	!SOUND3
		LDA	CORSNO
		CMP	#06H
		BNE	FXC008		;course = 7 ?
;					;yes
		INC	FROKCT		;ok count + 1
		BRA	FXC003_1
FXC003		EQU	$
		LDA	!LPSDFG
		BNE	FXC003_1		; sound set ok ?
;						; yes
		LDA	#02AH
		STA	!SOUND3
		STA	!LPSDFG			; loop out!!
FXC003_1	EQU	$
		INC	FRLPCT      ;loop count + 1
		LDA	FRLPCT
		CMP	#03H
		BNE	FXC009      ;frame loop check ?
;			      ;yes
;;;;;;;;	 LDA	  FROKCT
;;;;;;;;	 CMP	  #03H
;;;;;;;;	 BEQ	  FXC008      ;check ok ?
;;;;;;;;;			      ;no
;;;;;;;;	 BNE	  FXC005
		LDA	FROKCT
		CMP	#03H
		BNE	FXC005		; check ok ? (seikai) ?
;					; yes
		BRA	 FXC008
;
;
FXC004		EQU	$
		LDA	CORSNO
		CMP	#06H
		BEQ	FXC003		;course = 7 ?
		LDA	!LPSDFG
		BNE	FXC005		; sound set ok ?
;					; yes
		LDA	#02AH
		STA	!SOUND3
		STA	!LPSDFG		; loop out!!
;
FXC005	 EQU	  $
	 JSR	  FRLPSET     ;frame loop set
	 JSR	  EBKM05      ;enemy clear
;
FXC008	 EQU	  $
	 LDA	  #00H
	 STA	  FRLPCT
	 STA	  FROKCT
;
FXC009	 EQU	  $
	 STZ	  FRLPFG
;;;	    LDA	     #00H
;;;	    STA	     FRLPFG
FXC010	 EQU	  $
	 LDA	  BGFALFG
	 BEQ	  FXC015      ;BG. enemy set ?
;			      ;yes
	 STA	  <ENMYNO,X
	 LDA	  #01H
	 STA	  <ENCMOD,X
	 STZ	  <ENSTAT,X
	 STZ	  BGFALFG     ;enemy set
;;;	    LDA	     #00H
;;;	    STA	     <ENSTAT,X
;;;	    STA	     BGFALFG	 ;enemy set
	 JMP	  FXC110
;
FXC015	 EQU	  $
	 LDY	  FXCHPT      ;(y) <-- data pointer
	 LDA	  [<FXCDA0],Y
	 CMP	  #0FFH
	 BNE	  FXC020      ;data end ?
;			      ;yes
	 JMP	  FXC100
;
FXC020	 EQU	  $
	 AND	  #0FH
	 CMP	  #0EH
	 BEQ	  FXC060      ;environment data ?
;			      ;no
	 CPX	  #08H
	 BCC	  FXC060      ;nomal enemy area ?
;			      ;no
;;;;;;	 CPX	  #06H
;;;;;;	 BEQ	  FXC040      ;coin area ?
;			      ;no
	 INY
	 LDA	  [<FXCDA0],Y
	 AND	  #3FH
	 CMP	  #BMUS
	 BEQ	  FXC060      ;mushroom ?
;			      ;no
FXC040	 EQU	  $
	 RTS
;
FXC060	 EQU	  $
	 LDA	  DSXP11
	 CLC
	 ADC	  #30H
	 AND	  #0F0H
	 STA	  <WORK+7
	 LDA	  DSXP10
	 ADC	  #00H
	 STA	  <WORK+6      ;(work+6,7) <-- right side limit addr.
;
	 LDY	  FXCHPT
	 INY
	 LDA	  [<FXCDA0],Y
	 ASL	  A
	 BCC	  FXC070      ;next x-pos.(H) ?
;			      ;yes
	 LDA	  FCXHFG
	 BNE	  FXC070      ;set ok ?
;			      ;yes
	 INC	  FCXHFG
	 INC	  FCXHCT      ;next x-pos.(H) set
FXC070	 EQU	  $
	 DEY
	 LDA	  [<FXCDA0],Y
	 AND	  #0FH
	 CMP	  #0FH
	 BNE	  FXC073      ;x-pos.(H) set ?
;			      ;yes
	 LDA	  FCXHFG
	 BNE	  FXC073      ;x-pos.(H) set ok ?
;			      ;yes
	 INY
	 LDA	  [<FXCDA0],Y
	 AND	  #3FH
	 STA	  FCXHCT      ;x-pos.(H) set
;
	 INC	  FXCHPT
	 INC	  FXCHPT
	 INC	  FCXHFG
;
	 JMP	  FXCHOT
;
FXC073	 EQU	  $
	 LDA	  FCXHCT
	 STA	  <ENXPS0,X
	 LDA	  [<FXCDA0],Y
	 AND	  #0F0H
	 STA	  ENXPS1,X    ;x-pos. set
;
	 CMP	  DSXP11
	 LDA	  <ENXPS0,X
	 SBC	  DSXP10
	 BCS	  FXC076      ;set end side over ?
;			      ;yes
	 LDA	  [<FXCDA0],Y
	 AND	  #0FH
	 CMP	  #0EH
	 BEQ	  RDTRPD      ;environment data ?
;			      ;no
	 JMP	  FXCPC0
;
FXC076	 EQU	  $
	 LDA	  <WORK+7
	 CMP	  ENXPS1,X
	 LDA	  <WORK+6
	 SBC	  <ENXPS0,X
	 BCC	  FXC100      ;set start side ok ?
;			      ;yes
	 LDA	  #01H
	 STA	  <ENYPS0,X
	 LDA	  [<FXCDA0],Y
;;;;;;	 AND	  #0FH
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 STA	  ENYPS1,X    ;y-pos. set
;
	 CMP	  #0E0H
	 BEQ	  RDTRPD      ;environment data ?
;			      ;no
	 INY
	 LDA	  [<FXCDA0],Y
	 AND	  #40H
	 BEQ	  FXC077      ;loop check ?
;			      ;yes
	 LDA	  ENLVFG
	 BEQ	  FXCPC1      ;set ok ?
;			      ;yes
FXC077	 EQU	  $
	 LDA	  [<FXCDA0],Y
	 AND	  #3FH
	 CMP	  #GRP0
	 BCC	  FXC080      ;group enemy ?
;			      ;yes
	 CMP	  #GRPZ
	 BCC	  FXC200      ;group enemy ?
;			      ;no
FXC080	 EQU	  $
	 CMP	  #YPVS
	 BNE	  FXC090      ;YPVS ?
;			      ;yes
	 LDY	  GMLOOP
	 BEQ	  FXC090      ;2loop > ?
;			      ;yes
	 LDA	  #BKTR
FXC090	 EQU	  $
	 STA	  <ENMYNO,X    ;enemy no. set
	CMP	#2DH
	BNE	FXC095
	STZ	KPCHCT
FXC095	EQU	$
;
	 LDA	  #01H
	 STA	  <ENCMOD,X		     ; Next mode move pros set
;
	 JSR	  FXC110		    ; Set chara flag initial
;
	 LDA	  <ENCMOD,X
	 BNE	  FXCPC1		    ;- IF  end initial enemy ?		     ( YES ; FXCPC1 )
;
	 RTS
;
FXC100	 EQU	  $		       ; Free set enemy initial !
	 LDA	  ENFALFG
	 BNE	  FXC105		    ;- IF  fall or jump enemy out flag ON ?  ( YES ; FXC105 )
;
	 LDA	  WDPONT
	 CMP	  #01H
	 BNE	  FXC120		    ;- IF  wood onece set ?		     ( NO ; FXC120 )
;
	 LDA	  #0	;#BWOD
;
FXC105	 EQU	  $
	CPX	#9H
	BEQ	FXC110
	 STA	  <ENMYNO,X		     ; <ENMYNO <-- Obstacle No.
;
FXC110	 EQU	  $
	 STZ	  <ENSTAT,X
;;;	    LDA	     #00H
;;;	    STA	     <ENSTAT,X
;
	 JSR	  FOPCIT		    ; Set chara flag initial set
;
FXC120	 EQU	  $
;
	 RTS
;
FXC200	 EQU	  $		       ; Group set enemy initial !
	 JMP	  GROPSET     ;group enemy set
;
;
;*********************************************************************
;*		     (X) -- Index				     *
;*	 JSR	  RDTRPD    [ Read turn point data ]		     *
;*		  TRNPT0 -- Next environment frame information data  *
;*		  NXFPT0 --	 frame No.			     *
;*		  NXPXPS --	 player (x)pos			     *
;*********************************************************************
RDTRPD	 EQU	  $
	 INY
	 INY
	 LDA	  [<FXCDA0],Y
;;;;;;	 AND	  #0E0H
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 CMP	  CORSNO
	 BNE	  RDTP40      ;world no. = ?
;			      ;yes
	 DEY
	 LDA	  [<FXCDA0],Y
	 STA	  TRNPT0	       ; Next frame environment information data set
;
	 INY
	 LDA	  [<FXCDA0],Y
	 AND	  #00011111B
	 STA	  NXFPT0	       ; Next frame No. ( position )
;
RDTP40	 EQU	  $
	 BRA	  FCPC20
;;;	    JMP	     FCPC20
;
;*********************************************************************
;*	 JSR	  FXCPC0    [ Fix pos chara data point clac No.0 ]   *
;*********************************************************************
FXCPC0	 EQU	  $
	 LDY	  FXCHPT
	 LDA	  [<FXCDA0],Y
	 AND	  #0FH
	 CMP	  #0EH
	 BNE	  FXCPC1      ;environment data ?
;			      ;yes
FCPC20	 EQU	  $
	 INC	  FXCHPT
;
;*********************************************************************
;*	 JSR	  FXCPC1    [ Fix pos chara data point clac No.1 ]   *
;*********************************************************************
FXCPC1	 EQU	  $
	 INC	  FXCHPT
	 INC	  FXCHPT
;
	 STZ	  FCXHFG	 ;x-pos.(H) check flag off
;;;	    LDA	     #00H
;;;	    STA	     FCXHFG	 ;x-pos.(H) check flag off
;
RDTP90	 EQU	  $
	 LDX	  <INDEX
;
	 RTS
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  FOPCIT    [ Fix position out chara flag set ]	     #
;#####################################################################
FOPCIT	 EQU	  $
	 LDA	  <ENMYNO,X
	 CMP	  #ENDTR
	 BCS	  FOCS30	  ;- IF	 tortoise enemy ?  ( NO ; FXENIT )
;
	 TAY
;
	 LDA	  ENYPS1,X	  ; Position revise
	 ADC	  #8
	 STA	  ENYPS1,X
;
;;;;;;	 INC	  ENDSCT	  : INC	 Enemy display count
;
	 LDA	  #1
	 STA	  ENFHFG,X	  ; Enemy frame hide flag ON
;
;;;;;	 LDA	  #0
;;;;;	 STA	  TMEL1,X	  : Stop timer clear
;
	 TYA
;
FOCS30	 EQU	  $
		ASL	A
		TAY
		LDA	FOCS30TBL,Y
		STA	<WORK+4
		LDA	FOCS30TBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	 JSRSUB
FOCS30TBL	EQU	$
	 WORD	  FXENST	  ; 0  Normal enemy green
	 WORD	  FXENST	  ; 1		    red
	 WORD	  FXENST	  ; 2		    brack
	 WORD	  FXTUES	  ; 3		    turn  low
	 WORD	  FOCS90	  ; 4	    ???????????????????????
	 WORD	  FXFEES	  ; 5  Fire enemy
	 WORD	  FXYPVS	  ; 6  Mush room enemy
	 WORD	  FXIKES	  ; 7  Ika
;
	 WORD	  FXFTMES	  ; 8  Flying tama
;
;;;;;;;; WORD	  FXFYES	  : 9  Flying enemy
	 WORD	  FOCS90	  ; 9  ???????????????????
;
	 WORD	  FXFYES	  ; A  In water	 enemy-0
	 WORD	  FXFYES	  ; B		      -1
	 WORD	  FXJPTR	  ; C  Jump from water
	 WORD	  FXFWRES	  ; D  Flower ( in chimney )
	 WORD	  FXJPES	  ; E  Jumping enemy
	 WORD	  FXUDES	  ; F  Floot UP & DW
	 WORD	  FXLRES	  ;10  Swing LF & RT
	 WORD	  FXSHPES	  ;11  Ship (cloud kame)
;
	 WORD	  FXFLIT	  ;12  Fall enemy-0
;
;;;;;;;; WORD	  FXFLIT	  :13		 -1
	 WORD	  FOCS90	  ;13  ???????????????????
;
	 WORD	  FXFLIT	  ;14  Jump fish enemy
	 WORD	  FXFLIT	  ;15  Big kame fire
	 WORD	  FXFLIT	  ;16  Fireworks
	 WORD	  FXFLIT	  ;17  Timer check kame
	 WORD	  FXFEND	  ;18  Countinue out chara stop
;
;;;;;;;; WORD	  BRDGES	  :19  Bridge
	 WORD	  FOCS90	  ;19  ???????????????????
;
	 WORD	  FOCS90	  ;1A  ???????????????????
	 WORD	  FXSSES	  ;1B  Short spin steck-0
	 WORD	  FXSSES	  ;1C		       -1
	 WORD	  FXSSES	  ;1D		       -2
	 WORD	  FXSSES	  ;1E		       -3
	 WORD	  FXLSSS	  ;1F  Long	       -4
	 WORD	  FOCS90	  ;20  ???????????????????
	 WORD	  FOCS90	  ;21  ???????????????????
	 WORD	  FOCS90	  ;22  ???????????????????
;
;;;;;;;; WORD	  FXELPES	  :23  Loop elevator
	 WORD	  FOCS90	  ;23  ???????????????????
;
	 WORD	  MVLFST	  ;24  Lift dubble
	 WORD	  MVLFIT	  ;25  Single UP & DW
	 WORD	  UPLFST	  ;26	      UP
	 WORD	  DWLFST	  ;27	      DW
	 WORD	  MVLFI2	  ;28  LF & RT swing
	 WORD	  MVLS40	  ;29  On to down
;
	 WORD	  MVLFI5	  ;2A  Controle
;
	 WORD	  UPELST	  ;2B  Elevator UP
	 WORD	  DWELST	  ;2C		DW
	 WORD	  FXBKMES	  ;2D  Big kame
;
	 WORD	  MSINT1	  ;2E  Bonus mush room
	 WORD	  WDINIT	  ;2F	     wood
	 WORD	  FOCS90	  ;30  Dammy ( gorl flag )
	 WORD	  FOCS90	  ;31  Dammy ( castle flag )
	 WORD	  FOCS90	  ;32  Spring initial
	 WORD	  FOCS90	  ;33  Gun shell
	 WORD	  FOCS90	  ;34  Nothing TR1
;
	 WORD	  GILINT	  ;35 girl
	 WORD	  FGEDIT	  ;36  Frame/game end initial
;
FOCS90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#	 JSR	  FXYPVS    [ Mushroom enemy	    set ]	     #
;#####################################################################
FXYPVS	 EQU	  $
	 JSR	  FXENST
	 JMP	  CMDSET
;;	 LDA	  #ENCMD2
;;	 STA	  ENCSMD,X
;;	 RTS
;
;#####################################################################
;#	 JSR	  FXJPTR    [ Jump from water enemy set ]	     #
;#####################################################################
FXJPTR	 EQU	  $
	LDA	#0D0H
	 STA	  ENYPS1,X
	 LDA	  #1
	 STA	  <ENYPS0,X
;
;	  LSR	   A   ;(1)
	 STA	  TMEL1,X
;
;	  LSR	   A   ;(0)
	 STZ	  <ENSTAT,X
;
	STA	FIREUS,X
	STZ	FIRECT,X
	LDA	#27H
	STA	!SOUND3
	 JMP	  CMDSET
;
;#####################################################################
;#	 JSR	  GILINT    [ Girl initial ]			     #
;#####################################################################
GILINT	 EQU	  $
	LDA	!CORSNO
	CMP	#7
	BNE	GIL100
	 LDA	  #070H
GIL200	EQU	$
	 STA	  ENYPS1,X
	 RTS
;
GIL100	EQU	$
	LDA	#0B8H
	BRA	GIL200
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXENST    [ Fix position enemy set ]		     #
;#####################################################################
FXENDT	 EQU	  $
	 HEX	  F8,F4
;
FXENST	 EQU	  $
	 LDY	  #1
	 LDA	  GMLOOP
	 BNE	  FXEN10
	 DEY
FXEN10	 EQU	  $
	 LDA	  FXENDT,Y
FXENS1	 EQU	  $
	 STA	  <ENXSD0,X	   ; Move speed set
	 JMP	  FXUD40
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXTUE2    [ Fix position turn hi speed enemy set ] #
;#####################################################################
;FXTUE2	  EQU	   $
;	  LDA	   #0F0H
;	  JMP	   FXTR10
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXTUES    [ Fix position low speed turn enemy set ]#
;#####################################################################
FXTUES	 EQU	  $
	 JSR	  FXENST
;
	 LDA	  #DOWN
	 STA	  <ENSTAT,X
	 RTS
;
;;;	 LDA	  #0F8H
;FXTR10	  EQU	   $
;;	 STA	  ENXSD0,X
;
;	 LDA	  #DOWN
;	 STA	  ENSTAT,X
;	 JMP	  FXUD40
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXFEES    [ Fix position Fire		 enemy set ] #
;#####################################################################
FETMDT	 EQU	  $
	 HEX	  80,50
;
FXFEES	 EQU	  $
	 STZ	  ENCRCT,X
	 STZ	  <ENXSD0,X
;;;	    LDA	     #0
;;;	    STA	     ENCRCT,X
;;;;;;;;    STA	     ENCBFG,X
;;;	    STA	     <ENXSD0,X
;
	 LDY	  ENLVFG
	 LDA	  FETMDT,Y
	 STA	  TMEL1,X
;
	 LDA	  #FECMD
	 JMP	  FXUD50
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXLRES    [ Fix position LF & RT swing enemy set ] #
;#####################################################################
FXLRES	 EQU	  $
	 LDA	  #0
	 JMP	  FXENS1
;
;;;;	 STA	  ENXSD0,X
;;;;	 JMP	  FXUD40
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXIKES    [ Fix position IKa		 enemy set ] #
;#####################################################################
FXIKES	 EQU	  $
	 STZ	  <ENXSD0,X
;;;	    LDA	     #0
;;;	    STA	     <ENXSD0,X
;
CMDSET	 EQU	  $
	 LDA	  #ENCMD2
	 BNE	  FXUD50
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXUDES    [ Fix position UP & DW floot enemy set ] #
;#####################################################################
FXUDES	 EQU	  $
	 LDY	  #30H
	 LDA	  ENYPS1,X
	 STA	  ENMAXY,X
	 BPL	  FXUD20
;
	 LDY	  #0E0H
;
FXUD20	 EQU	  $
	 TYA
;;;;;	 CLC
	 ADC	  ENYPS1,X
	 STA	  <ENCTPS,X	   ; UP & DW floot center pos set
;
;
FXUD40	 EQU	  $
	 LDA	  #ENCMD
FXUD50	 EQU	  $
	 STA	  ENCSMD,X	  ; OBJ cross size set
;
	 LDA	  #2
;;;;;	 STA	  ENCMKI,X	  : Chara muki set
	 STA	  <ENMMKI,X	   ; Move     "
;
;;;;;;	 JSR	  YCLCLR
;;;;
YCLCLR	 EQU	  $
	 LDA	  #0
	 STA	  <ENYCL0,X
	 STA	  ENYCL1,X	  ; G calc buffer init
;
	 RTS
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXFTMES   [ Fix position flying tama	set ]	     *
;*********************************************************************
FXFTMES	 EQU	  $
	 LDA	  #00000010B
	 STA	  <ENMMKI,X    ;Chara set muki set
;
	 LDA	  #GUCMD
	 STA	  ENCSMD,X	  ; ENCSMD <-- Cross mode
	 RTS
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXFYES    [ Fix position flying enemy set ]	     *
;*********************************************************************
FXFYES	 EQU	  $
;;;;;	      LDA      #00H	       < Flying enemy init set >
;;;;;	      STA      AGLBUF,X
;;;;;	      STA      ENSID0,X
;;;;;	      STA      ENSID1,X	   ;speed index set
;
;;;;;	      LDA      #10H
;;;;;	      STA      MUKI,X	   ;muki set
;
;;;;;	      LDA      #05H
;;;;;	      STA      ANGLE,X	   ;angle set
;;;;;	      LDA      #01H
;;;;;	      STA      AGLFLG,X	   ;angle flag set
;
	 JSR	  CMDSET
;
	 LDA	  RDM,X
	 AND	  #10H
	 STA	  <AGLBUF,X    ;up,down course init. set
;
	 LDA	  ENYPS1,X
	 STA	  AGLFLG,X    ;init. y-pos. address set
;
;;	 LDA	  #00000010B
;;	 STA	  ENMMKI,X    ;Chara set muki set
;
;;	 LDA	  #ENCMD2
;;	 STA	  ENCSMD,X    ;cross mode set
	 RTS
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXSHPES   [ Fix position ship set ]		     *
;*********************************************************************
FXSHPES	 EQU	  $
	 LDA	  ENFALFG
	 BNE	  FXSHP60     ;set ok ?
;			      ;yes
FXSHP20	 EQU	  $
	 LDA	  #00H
	 STA	  ESHNCT      ;ship nothing counter clear
	 JSR	  FXLRES      ;init. set
;
	 JMP	  FFES90
;
FXSHP60	 EQU	  $
	 JMP	  ENCLER      ;enemy clear
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  EFALINT1  [ Fix position fall enemy set - 1 ]	     *
;*********************************************************************
EFALXDT	 EQU	  $	      ;fall enemy x-speed data
;		   0  1	 2  3
	 HEX	  26,2C,32,38 ;[B] move
;		   4  5	 6  7
	 HEX	  20,22,24,26 ;[A] move
;		   8  9	 A  B
	 HEX	  13,14,15,16 ;stop
;
;
EFALINT1 EQU	  $
	 LDA	  EFCKTM
	 BNE	  EFLT130     ;timer = 0 ?
;			      ;yes
	 CPX	  #MSXPS0-ENXPS0
	 BCS	  EFLT130     ;(x) used ok ?
;			      ;yes
	 LDA	  #80H
	 STA	  EFCKTM      ;timer set
;
	 LDY	  #MSXPS0-ENXPS0-1
EFLT120	 EQU	  $
	 LDA	  ENMYNO,Y
	 CMP	  #ESHP
	 BEQ	  EFLT140     ;ship ?
;			      ;no
	 DEY
	 BPL	  EFLT120     ;check end ?
;			      ;yes
	 INC	  ESHNCT      ;nothing counter + 1
	 LDA	  ESHNCT
	 CMP	  #07H
	 BCC	  EFLT130     ;ship set ?
;			      ;yes
	 LDX	  #MSXPS0-ENXPS0-1
EFLT125	 EQU	  $
	 LDA	  <ENCMOD,X
	 BEQ	  EFLT127     ;used ok ?
;			      ;no
	 DEX
	 BPL	  EFLT125     ;check end ?
;			      ;yes
	 BMI	  EFLT128
;
EFLT127	 EQU	  $
	 STZ	  <ENSTAT,X    ;status clear
;;;	    LDA	     #00H
;;;	    STA	     <ENSTAT,X	  ;status clear
	 LDA	  #ESHP
	 STA	  <ENMYNO,X    ;ship set
	 JSR	  FXSHP20     ;init. set
	 LDA	  #20H
	 JSR	  BKFES30     ;address set
EFLT128	 EQU	  $
	 LDX	  <INDEX
EFLT130	 EQU	  $
	 RTS
;
EFLT140	 EQU	  $
	 LDA	  PLYPS1
	 CMP	  #2CH
	 BCC	  EFLT130     ;player y-pos. ok ?
;			      ;yes
	 LDA	  ENSTAT,Y
	 BNE	  EFLT130     ;ship ok ?
;			      ;yes
	 LDA	  ENXPS0,Y
	 STA	  <ENXPS0,X
	 LDA	  ENXPS1,Y
	 STA	  ENXPS1,X    ;x-pos. set
	 LDA	  #01H
	 STA	  <ENYPS0,X
	 LDA	  ENYPS1,Y
	 SEC
	 SBC	  #08H
	 STA	  ENYPS1,X    ;y-pos. set
;
	 LDA	  RDM,X
	 AND	  #03H
	 TAY
	 LDX	  #02H
EFLT160	 EQU	  $
	 LDA	  EFALXDT,Y
	 STA	  <WORK+1,X    ;x-speed data set
	 INY
	 INY
	 INY
	 INY
	 DEX
	 BPL	  EFLT160     ;set end ?
;			      ;yes
	 LDX	  <INDEX
	 JSR	  ESHMV500    ;x-speed check
	 LDY	  <PLXSD0
	 CPY	  #WKRT-10H
	 BCS	  EFLT1100    ;stop ?
;			      ;yes
	 TAY
	 LDA	  RDM+1,X
	 AND	  #03H
	 BEQ	  EFLT180     ;back ?
;			      ;yes
	 TYA
	 EOR	  #0FFH
;;;;;;;; CLC
;;;;;;;; ADC	  #01H
	 TAY
	 INY
EFLT180	 EQU	  $
	 TYA
EFLT1100 EQU	  $
	 JSR	  CMDSET      ; ENCSMD SET
;
	 LDY	  #02H
	 STA	  <ENXSD0,X    ;x-speed set
	 CMP	  #00H
	 BMI	  EFLT1110
	 DEY
EFLT1110 EQU	  $
	 STY	  <ENMMKI,X    ;enemy muki set
	 LDA	  #0FDH
	 STA	  <ENYCL0,X    ;y-speed set
	 LDA	  #01H
	 STA	  <ENCMOD,X    ;enemy mode set
	 LDA	  #DROP
	 STA	  <ENSTAT,X    ;enemy status set
;;	 LDA	  #ENCMD2
;;	 STA	  ENCSMD,X
EFLT1120 EQU	  $
	 RTS
;
;*********************************************************************
;*		     (X) -- Index				     *
;*	 JSR	  FXLSSS    [ Long spin-stick enemy initial set ]    *
;*********************************************************************
FXSSDT1	 EQU	  $	      ;angle speed data
	 HEX	  28,38,28,38,28
;
FXSSDT2	 EQU	  $	      ;course data
	 HEX	  00,00,10,10,00
;
FXLSSS	 EQU	  $
	 JSR	  ENSPCHK     ;enemy area space check
;
;*********************************************************************
;*		     (X) -- Index				     *
;*	 JSR	  FXSSES    [ Short spin-stick enemy initial set ]   *
;*********************************************************************
FXSSES	 EQU	  $
	 STZ	  <AGLBUF,X
;;;	    LDA	     #00H
;;;	    STA	     <AGLBUF,X
;
	 LDA	  <ENMYNO,X
	 SEC
	 SBC	  #SST0
	 TAY
	 LDA	  FXSSDT1,Y
	 STA	  AGLTBL,X    ;angle speed set
	 LDA	  FXSSDT2,Y
	 STA	  MUKI,X      ;course set
;
	 LDA	  ENYPS1,X
	 CLC
	 ADC	  #04H
	 STA	  ENYPS1,X
	 LDA	  ENXPS1,X
	 CLC
	 ADC	  #04H
	 STA	  ENXPS1,X
	 LDA	  <ENXPS0,X
	 ADC	  #00H
	 STA	  <ENXPS0,X    ;x,y-pos. replace
	 JMP	  FFES90
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXFSHES   [ Fix position fish enemy set ]	     *
;*********************************************************************
FFHADT	 EQU	  $	      ;fish init. address data
;		   0  1	 2  3
	 HEX	  80,30,40,80 ;stop
;		   4  5	 6  7
	 HEX	  30,50,50,70 ;[A] move
;		   8  9	 A  B
	 HEX	  20,40,80,A0 ;[B] move
;		   C  D	 E  F
	 HEX	  70,40,90,68 ;random
;
;
FFXSPDT	 EQU	  $	      ;fish x-speed data
;		   0  1	 2  3
	 HEX	  0E,05,06,0E ;stop
;		   4  5	 6  7
	 HEX	  1C,20,10,0C ;[A] move
;		   8  9	 A  B
	 HEX	  1E,22,18,14 ;[B] move
;
;
FFTMDT	 EQU	  $	      ;time data
	 HEX	  10,60,20,48
;
;
FXFSHES	 EQU	  $
	 LDA	  EFCKTM
	 BNE	  EFLT1120    ;timer = 0 ?
;			      ;yes
;;	 JSR	  YCLCLR
	 JSR	  CMDSET      ; ENCSMD SET
;
	 LDA	  RDM+1,X
	 AND	  #03H
	 TAY
	 LDA	  FFTMDT,Y
	 STA	  EFCKTM      ;timer set
;
	 LDY	  #03H
	 LDA	  ENLVFG
	 BEQ	  FFHES10     ;3biki ?
;			      ;no
	 INY
FFHES10	 EQU	  $
	 STY	  <WORK
;
	 CPX	  <WORK
	 BCC	  FFHES15
	 JMP	  EFLT1120    ;(x) used ok ?
;
FFHES15	 EQU	  $				;yes
	 LDA	  RDM,X
	 AND	  #03H
	 STA	  <WORK
	 STA	  <WORK+1
;
	 LDA	  #0FBH
	 STA	  <ENYCL0,X    ;y-speed init. set
;
	 LDA	  #00H
	 LDY	  <PLXSD0
	 BEQ	  FFHES20     ;stop ?
;			      ;no
	 LDA	  #04H
	 CPY	  #WKRT+1
	 BCC	  FFHES20     ;[A] move ?
;			      ;no
	 ASL	  A	      ;[B] move
FFHES20	 EQU	  $
	 PHA
	 CLC
	 ADC	  <WORK
	 STA	  <WORK
;
	 LDA	  RDM+1,X
	 AND	  #03H
	 BEQ	  FFHES40     ;random ?
;			      ;yes
	 LDA	  RDM+2,X
	 AND	  #0FH
	 STA	  <WORK
FFHES40	 EQU	  $
	 PLA
	 CLC
	 ADC	  <WORK+1
	 TAY
	 LDA	  FFXSPDT,Y
	 STA	  <ENXSD0,X    ;x-speed init. set
;
	 LDA	  #01H
	 STA	  <ENMMKI,X    ;character muki set
;
	 LDA	  <PLXSD0
	 BNE	  FFHES60     ;player move ?
;			      ;no
	 LDY	  <WORK
	 TYA
	 AND	  #02H
	 BEQ	  FFHES60     ;
;			      ;
	 LDA	  <ENXSD0,X
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <ENXSD0,X    ;x-speed reverse
;
	 INC	  <ENMMKI,X    ;character muki set
FFHES60	 EQU	  $
	 TYA
	 AND	  #02H
	 BEQ	  FFHES100    ;
;			      ;
	 LDA	  PLXPS1
	 CLC
	 ADC	  FFHADT,Y
	 STA	  ENXPS1,X
	 LDA	  <PLXPS0
	 ADC	  #00H
	 BRA	  FFHES120
;;;	    JMP	     FFHES120
;
FFHES100 EQU	  $
	 LDA	  PLXPS1
	 SEC
	 SBC	  FFHADT,Y
	 STA	  ENXPS1,X
	 LDA	  <PLXPS0
	 SBC	  #00H
FFHES120 EQU	  $
	 STA	  <ENXPS0,X    ;x-pos. set
;
	 LDA	  #01H
	 STA	  <ENCMOD,X
	 STA	  <ENYPS0,X
	 LDA	  #0F8H
	 STA	  ENYPS1,X    ;y-pos. set
;
;;	 LDA	  #ENCMD2
;;	 STA	  ENCSMD,X    ;cross mode set
FFHES140 EQU	  $
	 RTS
;
;;;;;;
;;;;;;*********************************************************************
;;;;;;*			  (X) -- INDEX					  *
;;;;;;*	      JSR      FXELPES	 [ Fix position loop elevator set ]	  *
;;;;;;*********************************************************************
;;;;;FXELPES  EQU      $
;;;;;	      LDA      #10H
;;;;;	      STA      MUKI,X
;;;;;	      LDA      #00H
;;;;;	      STA      AGLBUF,X
;;;;;	      LDA      #10H
;;;;;	      STA      ANGLE,X
;;;;;;
;;;;;	      JMP      LFCRST	       : Cross mode set
;;;;;;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXBKMES   [ Fix position big kame set ]	     *
;*********************************************************************
FXBKMES	 EQU	  $
	 JSR	  ENSPCHK     ;enemy area space check
;
	 STX	  BKMIDX      ;index push
	 STZ	  BKMFLG
	 STZ	  BKBCLFG     ;BG. clear counter clear
;;;	    LDA	     #00H
;;;	    STA	     BKMFLG
;;;	    STA	     BKBCLFG	 ;BG. clear counter clear
	 LDA	  ENXPS1,X
	 STA	  BKMXPS      ;init. x-pos. set
	 LDA	  #0DFH
	 STA	  BKMTMS      ;timer set
	 STA	  <ENMMKI,X    ;character muki set
	 LDA	  #20H
	 STA	  BKMCNT      ;counter set
	 STA	  ETMS01,X    ;timer set
	STA	ENOJBG,X	;OBJ>BG2
;
	 LDA	  #5
	 STA	  FIBSCT      ;Fire cross counter set
	 LSR	  A	      ; A <-- #2
	 STA	  BKMDOT      ;move dot counter set
;
	 RTS
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  ENSPCHK   [ Fix position enemy space area check ]  *
;*********************************************************************
ENSPCHK	 EQU	  $
	 LDY	  #0FFH
ENSPC20	 EQU	  $
	 INY
	 LDA	  ENCMOD,Y
	 BNE	  ENSPC20     ;used ok ?
;			      ;yes
	 STY	  SSWORK
	 TXA
	 ORA	  #80H
	 STA	  ENCMOD,Y    ;protect set
;
	 LDA	  <ENXPS0,X
	 STA	  ENXPS0,Y
	 LDA	  ENXPS1,X
	 STA	  ENXPS1,Y    ;x-pos. set
;
	 LDA	  #01H
	 STA	  <ENCMOD,X    ;mode set
;
	 STA	  ENYPS0,Y
	 LDA	  ENYPS1,X
	 STA	  ENYPS1,Y    ;y-pos. set
ENSPC90	 EQU	  $
	 RTS
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXBKFES   [ Fix position big kame fire set ]	     *
;*********************************************************************
BKFYPDT	 EQU	  $	      ;y-pos. data
	 HEX	  90,80,70,90
;
BKFYMDT	 EQU	  $	      ;y-pos. move dot data
	 HEX	  FF,01
;
;
FXBKFES	 EQU	  $
	 LDA	  EFCKTM
	 BNE	  ENSPC90     ;timer = 0 ?
;			      ;yes
	 STA	  BKFFG2,X  ;y-pos. move data clear
;
	LDA	#6H
	STA	KPCHID		;KP
	LDA	#18H
	STA	KPCHCT
	STX	KPCHIX
;
	 LDY	  BKMIDX      ;(y) <-- index
	 LDA	  ENMYNO,Y
	 CMP	  #BKM0
	 BEQ	  BKFE040     ;big kame ?
;			      ;no
	 JSR	  BKFTMSET    ;big kame fire timer set
	 CLC
	 ADC	  #20H
;
	 LDY	  ENLVFG
	 BEQ	  BKFES25     ;bit on ?
;			      ;yes
	 SEC
	 SBC	  #10H
BKFES25	 EQU	  $
	 STA	  EFCKTM      ;timer set
;
	 LDA	  RDM,X
	 AND	  #03H
	 STA	  BKFFG1,X  ;y-pos. data pointer set
	 TAY
	 LDA	  BKFYPDT,Y
BKFE030	 EQU	  $
	 STA	  ENYPS1,X    ;y-pos. set
;
	 LDA	  DSXP11
	 CLC
	 ADC	  #20H
	 STA	  ENXPS1,X
	 LDA	  DSXP10
	 ADC	  #00H
	 STA	  <ENXPS0,X    ;x-pos. set
	STZ	KPCHCT
	STZ	KPCHIX
	STZ	KPCHID
	LDA	#17H
	STA	!SOUND3
	 LDA	  #FICMD2
	 STA	  ENCSMD,X    ;OBJ cross size set
;
	 LDA	  #01H
	 STA	  <ENYPS0,X    ;y-pos. set
	 STA	  <ENCMOD,X
;
	 LSR	  A	      ; A <-- #0
	 STA	  ENXPS2,X
	 STA	  <ENSTAT,X
;
BKFE040	 EQU	  $
	STX	BKIXWK
	RTS
;
BKFES30	 EQU	  $
	 STA	  ENYPS1,X    ;y-pos. set
;
	 LDA	  DSXP11
	 CLC
	 ADC	  #20H
	 STA	  ENXPS1,X
	 LDA	  DSXP10
	 ADC	  #00H
	 STA	  <ENXPS0,X    ;x-pos. set
	 JMP	  BKFES60
;
BKFES40	 EQU	  $
	 LDA	  ENXPS1,Y
	 SEC
	 SBC	  #0EH
	 STA	  ENXPS1,X
	 LDA	  ENXPS0,Y
	 STA	  <ENXPS0,X    ;x-pos. set
;
	 LDA	  ENYPS1,Y
	 CLC
	 ADC	  #08H
	 STA	  ENYPS1,X
;
	 LDA	  RDM,X
	 AND	  #03H
	 STA	  BKFFG1,X  ;y-pos. data pointer set
	 TAY
	 LDA	  BKFYPDT,Y
	 LDY	  #00H
	 CMP	  ENYPS1,X
	 BCC	  BKFES50     ;up move ?
;			      ;no
	 INY
BKFES50	 EQU	  $
	 LDA	  BKFYMDT,Y
	 STA	  BKFFG2,X  ;y-pos. move data set
;
	 STZ	  ENFALFG     ;flag clear
;;;	    LDA	     #00H
;;;	    STA	     ENFALFG	 ;flag clear
;
BKFES60	 EQU	  $
	 LDA	  #FICMD2
	 STA	  ENCSMD,X    ;OBJ cross size set
;
	 LDA	  #01H
	 STA	  <ENYPS0,X    ;y-pos. set
	 STA	  <ENCMOD,X
;
	 LSR	  A	      ; A <-- #0
	 STA	  ENXPS2,X
	 STA	  <ENSTAT,X
BKFES100 EQU	  $
	 RTS
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FRWKES    [ Fix position firewordks set ]	     *
;*********************************************************************
FRWXDT1	 EQU	  $	      ;fireworks x-pos. data
;		   5  4	 3
	 HEX	  00,30,60
FRWXDT2	 EQU	  $
;		   2  1	 0
	 HEX	  60,00,20
;
FRWYDT1	 EQU	  $	      ;		 y-pos. data
;		   5  4	 3
	 HEX	  60,40,70
;
FRWYDT2	 EQU	  $
;		   2  1	 0
	 HEX	  40,60,30
;
;
FRWKES	 EQU	  $
	 LDA	  EFCKTM
	 BNE	  FRWKE120    ;timer = 0 ?
;			      ;yes
	 LDA	  #20H
	 STA	  EFCKTM      ;timer set
;
	 DEC	  FRWCNT      ;fireworks counter - 1
;
	 LDY	  #MSXPS0-ENXPS0+1
FRWKE20	 EQU	  $
	 DEY
	 LDA	  ENMYNO,Y
	 CMP	  #CFLG
	 BNE	  FRWKE20     ;castle flag ?
;			      ;yes
	 LDA	  ENXPS1,Y
	 SEC
	 SBC	  #30H
	 PHA		      ;x-pos.(L) push
	 LDA	  ENXPS0,Y
	 SBC	  #00H
	 STA	  <WORK
;
	 LDA	  FRWCNT
	 CLC
	 ADC	  ENSTAT,Y
	 TAY
;
	 PLA		      ;x-pos.(L) pull
	 CLC
	 ADC	  FRWXDT1,Y
	 STA	  ENXPS1,X
	 LDA	  <WORK
	 ADC	  #00H
	 STA	  <ENXPS0,X    ;x-pos. set
;
	 LDA	  FRWYDT1,Y
	 STA	  ENYPS1,X
	 LDA	  #01H
	 STA	  <ENYPS0,X    ;y-pos. set
	 STA	  <ENCMOD,X
;
	 LSR	  A
	 STA	  <FRWCPNT,X   ;character pointer set
	 LDA	  #08H
	 STA	  <FRWFCT,X    ;frame counter set
FRWKE120 EQU	  $
	 RTS
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  TPOSCHK   [ Fix position timer check kame set ]    *
;*********************************************************************
BITDT	 EQU	  $	      ;bit data
;		   0  1	 2  3  4  5  6	7
	 HEX	  01,02,04,08,10,20,40,80
;
PYPSDT	 EQU	  $	      ;y-pos. data
;		   0  1	 2  3  4  5  6	7
	 HEX	  40,30,90,50,20,60,A0,70
;
TPEMYDT	 EQU	  $	      ;enemy no. data
	 BYTE	  WTR0,WTR1
;
;
TPOSCHK	 EQU	  $
	 LDA	  EFCKTM
	 BNE	  TPOSC430    ;timer = 0 ?
;			      ;yes
	 LDA	  <ENVRFG
	 BNE	  TPOSC400    ;water ?
;			      ;yes
;
	 CPX	  #03H
	 BCS	  TPOSC430    ;(x) ok ?
;			      ;yes
;;;;;	      LDA      #04H
;;;;;	      LDY      CORSNO
;;;;;	      CPY      #03H
;;;;;	      BCS      TPOSC05	   ;world-4 > ?
;;;;;;				   ;no
;;;;;	      LDA      #03H
;;;;;TPOSC05  EQU      $
;;;;;	      STA      WORK
;;;;;	      CPX      WORK
;;;;;	      BCS      TPOSC430	   ;(x) ok ?
;;;;;;				   ;yes
;
	 LDY	  #00H
	 LDA	  RDM,X
	 CMP	  #0AAH
	 BCC	  TPOSC07     ;enemy change ?
;			      ;yes
	 INY
TPOSC07	 EQU	  $
	 LDA	  CORSNO
	 CMP	  #01
	 BEQ	  TPOSC10     ;1 course ?
;			      ;no
	 INY
TPOSC10	 EQU	  $
	 TYA
	 AND	  #01H
	 TAY
	 LDA	  TPEMYDT,Y
TPOSC15	 EQU	  $
	 STA	  <ENMYNO,X    ;enemy no. set
;
	 LDA	  PBITFLG
	 CMP	  #0FFH
	 BNE	  TPOSC20     ;flag limit ?
;			      ;yes
	 STZ	  PBITFLG     ;flag clear
;;;	    LDA	     #00H
;;;	    STA	     PBITFLG	 ;flag clear
TPOSC20	 EQU	  $
	 LDA	  RDM,X
	 AND	  #07H
TPOSC40	 EQU	  $
	 TAY
	 LDA	  BITDT,Y
	 BIT	  PBITFLG
	 BEQ	  TPOSC60     ;position ok ?
;			      ;no
	 INY
	 TYA
	 AND	  #07H
	 BRA	  TPOSC40
;;;	    JMP	     TPOSC40
;
TPOSC60	 EQU	  $
	 ORA	  PBITFLG
	 STA	  PBITFLG     ;bit set
;
	 LDA	  PYPSDT,Y    ;(a) <-- y-pos. data
TPOSC80	 EQU	  $
	 JSR	  BKFES30     ;x,y-pos. set
	 STA	  ENYPS2,X
;
	 LDA	  #20H
	 STA	  EFCKTM      ;timer set
;
	 JMP	  FOPCIT      ;init. set
;
;
TPOSC400 EQU	  $
	 LDY	  #0FFH
TPOSC420 EQU	  $
	 INY
	 CPY	  #MSXPS0-ENXPS0
	 BCS	  TPOSC440    ;check end ?
;			      ;no
	 LDA	  ENCMOD,Y
	 BEQ	  TPOSC420    ;used ?
;			      ;yes
	 LDA	  ENMYNO,Y
	 CMP	  #FTM0
	 BNE	  TPOSC420    ;flying kame on ?
;			      ;yes
TPOSC430 EQU	  $
	 RTS
;
TPOSC440 EQU	  $
;;	   LDA	    0FEH
;;	   ORA	    #08H
;;	   STA	    0FEH	;Sound set
	LDA	#09H
	STA	!SOUND3
;
	 LDA	  #FTM0
	 BNE	  TPOSC15
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  GROPSET   [ Fix position group enemy set ]	     *
;*********************************************************************
GROPSET	 EQU	  $
	 LDY	  #SHTR
	 SEC
	 SBC	  #GRP0
	 PHA
	 CMP	  #04H
	 BCS	  GRPS20
;			      ;
	 PHA
	 LDY	  #YPVS
	 LDA	  GMLOOP
	 BEQ	  GRPS10      ;2loop > ?
;			      ;yes
	 LDY	  #BKTR
GRPS10	 EQU	  $
	 PLA
GRPS20	 EQU	  $
	 STY	  <WORK+1      ;(work+1) <-- enemy no.
;
	 LDY	  #0B0H
	 AND	  #02H
	 BEQ	  GRPS40      ;
;			      ;
	 LDY	  #70H
GRPS40	 EQU	  $
	 STY	  <WORK	       ;(work) <-- y-pos.
;
	 LDA	  DSXP10
	 STA	  <WORK+2
	 LDA	  DSXP11
	 STA	  <WORK+3
;
	 LDY	  #02H
	 PLA
	 LSR	  A
	 BCC	  GRPS60      ;
;			      ;
	 INY
GRPS60	 EQU	  $
	 STY	  GRPCNT
;
GRPS100	 EQU	  $
	 LDX	  #0FFH
GRPS120	 EQU	  $
	 INX
	 CPX	  #MSXPS0-ENXPS0
	 BCS	  GRPS200     ;check end ?
;			      ;yes
	 LDA	  <ENCMOD,X
	 BNE	  GRPS120     ;used ok ?
;			      ;yes
	 LDA	  <WORK+1
	 STA	  <ENMYNO,X    ;enemy no. set
;
	 LDA	  <WORK+2
	 STA	  <ENXPS0,X
	 LDA	  <WORK+3
	 STA	  ENXPS1,X    ;x-pos. set
;
	 CLC
	 ADC	  #18H
	 STA	  <WORK+3
	 LDA	  <WORK+2
	 ADC	  #00H
	 STA	  <WORK+2      ;next x-pos. set
;
	 LDA	  <WORK
	 STA	  ENYPS1,X
	 LDA	  #01H
	 STA	  <ENYPS0,X    ;y-pos. set
;
	 STA	  <ENCMOD,X
;
	 JSR	  FOPCIT      ;init. set
;
	 DEC	  GRPCNT
	 BNE	  GRPS100     ;set end ?
;			      ;yes
GRPS200	 EQU	  $
	 JMP	  FXCPC1
;
;
;*********************************************************************
;*		     (X) -- INDEX				     *
;*	 JSR	  FXFWRES   [ Fix position flower enemy set ]	     *
;*********************************************************************
FXFWRES	 EQU	  $
	 LDA	  #01H
	 STA	  <FWRFLG1,X   ;up,down flag set
	 LSR	  A	      ; A <-- #0
	 STA	  <ENSTAT,X
	 STA	  <FWRFLG2,X   ;move flag clear
	 LDA	  ENYPS1,X
	 STA	  FWRFLG3,X   ;y-limit-1 set
	 SEC
	 SBC	  #18H
	 STA	  FWRFLG4,X   ;y-limit-2 set
;
	 LDA	  #ENCMD2
	LDA	#FWCMD
	 JMP	  FFESA0
;
;
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXFLIT    [ Fix position fall chara initial ]	     #
;#####################################################################
FXFLIT	 EQU	  $
	 LDA	  <ENMYNO,X
	 STA	  ENFALFG	  ; Fall enemy flag ON
	 SEC
	 SBC	  #EXT0
		ASL	A
		TAY
		LDA	FXFLITTBL,Y
		STA	<WORK+4
		LDA	FXFLITTBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
FXFLITTBL	EQU	$
	 WORD	  EFALINT1	  ; Fall enemy-0
;;;;;;;; WORD	  EFALINT2	  :	      -1
	 WORD	  FFLT90	  ; ????????????
	 WORD	  FXFSHES	  ; Jump fish enemy
	 WORD	  FXBKFES	  ; Big kame fire
	 WORD	  FRWKES	  ; Fireworks
	 WORD	  TPOSCHK	  ; Timer check kame
;
FFLT90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#	 JSR	  FXFEND    [ Fix pos fall & Jump chara end set ]    #
;#####################################################################
FXFEND	 EQU	  $
	 LDY	  #MSXPS0-ENXPS0
;
FXF030	 EQU	  $
	 LDA	  ENMYNO,Y
	 CMP	  #ESHP
	 BNE	  FXF040	  ;- IF	 enemy ship ?  ( NO ; FXF040 )
;
	 LDA	  #1
	 STA	  ENSTAT,Y	       ; Clear	ship enemy
;
FXF040	 EQU	  $
	 DEY
	 BPL	  FXF030
;
	 LDA	  #0
	 STA	  ENFALFG	  ; Fall & Jump chara end set
	 STA	  <ENCMOD,X	   ; Clera enemy mode
	 RTS
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  FXJPES    [ Fix position jumping enemy set ]	     #
;#####################################################################
FXJPES	 EQU	  $
	 LDA	  #00000010B
;;;	 STA	  ENCMKI,X	  : Chara muki set
	 STA	  <ENMMKI,X	   ; Move muki set
;
	 LDA	  #0F8H
	 STA	  <ENXSD0,X	   ; (x)speed set
;
FFES90	 EQU	  $
	 LDA	  #ENCMD	  ; Ar <-- Enemy cross mode
FFESA0	 EQU	  $
	 STA	  ENCSMD,X	  ; ENCSMD <-- Cross mode
;
	 RTS
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  MVLFIT    [ Move lift initial set ]		     #
;#####################################################################
;;MVLFIT   EQU	    $		  ???????????
;;;;	 LDA	  ENMYNO,X
;;;;	 CMP	  #LFT0
;;;;	 BNE	  MVSGLS    *- IF  normal lift ?  ( NO : MVSGLS )
;;;;	 JMP	  MVSGLS    *- IF  normal lift ?  ( NO : MVSGLS )
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  MVLFST    [ Move lift set ]			     #
;#####################################################################
MVLFST	 EQU	  $
	 DEC	  ENYPS1,X
	 DEC	  ENYPS1,X
	 LDY	  ENLVFG
	 BNE	  MVLS10	  ; "6" Chr's ?
;
	 LDY	  #2
	 JSR	  LEPRVS	  ; Lift pos revice
;
MVLS10	 EQU	  $
	 LDY	  #0FFH
	 LDA	  LFSTWK
	 STA	  <ENSTAT,X
	 BPL	  MVLS30	  ;- IF	 main lift ?  ( YES ; MVLS30 )
;
	 TXA
	 TAY
;
MVLS30	 EQU	  $
	 STY	  LFSTWK
;
	 LDA	  #0
	 STA	  <LFCTFG,X	   ; Clear lift cut flag
	 TAY
;
	 JSR	  LEPRVS	  ; Lift pos revice
;
MVLS40	 EQU	  $
	 LDA	  #0FFH
	 STA	  ONLFFG,X	  ; ON lift flag init
	 JMP	  MSGL80
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  MVLFI5    [ Remort controle	2   ]		     #
;#####################################################################
;;;	 LDA	  #10H
;;;	 JMP	  MVLFI3
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  MVLFI2    [ Move lift initial 2   ]		     #
;#####################################################################
MVLFI5	 EQU	  $
MVLFI2	 EQU	  $
	 LDA	  #0
MVLFI3	 EQU	  $
	 STA	  <ENXSD0,X
	 JMP	  MSGL80
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  MVSGLS    [ Fix position UP & DW floot enemy set ] #
;#####################################################################
MVLFIT	 EQU	  $
MVSGLS	 EQU	  $
	 LDY	  #40H
	 LDA	  ENYPS1,X
	 BPL	  MSGL20
;
	 EOR	  #0FFH
	 CLC
	 ADC	  #1
;
	 LDY	  #0C0H
;
MSGL20	 EQU	  $
	 STA	  ENMAXY,X
;
	 TYA
	 CLC
	 ADC	  ENYPS1,X
	 STA	  <ENCTPS,X	   ; UP & DW floot center pos set
;
MSGL80	 EQU	  $
	 JSR	  YCLCLR
;;;;;	 LDA	  #0
;;;;;	 STA	  ENYCL0,X
;;;;;;	 STA	  ENYCL1,X	  : G calc buffer init
;
LFCRST	 EQU	  $
	 LDA	  #LFCMD	  ; 4 chr's
	 LDY	  <ENVRFG
	 CPY	  #3
	 BEQ	  LFCR10
	 LDY	  ENLVFG	  ; dificulty ?
	 BNE	  LFCR10
;
	 LDA	  #LFCMD2	  ; Easy 6 chr's
LFCR10	 EQU	  $
	 STA	  ENCSMD,X	  ; Lift cross mode
;
	 RTS
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  UPLFST    [ UP lift	  set ]			     #
;#####################################################################
UPLFST	 EQU	  $
	 JSR	  UPELST
	 JMP	  DWLS10
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  DWLFST    [ Dw lift	  set ]			     #
;#####################################################################
DWLFST	 EQU	  $
	 JSR	  DWELST
;
DWLS10	 EQU	  $
	 JMP	  LFCRST
;;;;;	 LDA	  #LFCMD2
;;;;;;	 STA	  ENCSMD,X
;;;;;;	 RTS
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  UPELST    [ Up elevator set ]			     #
;#####################################################################
UPELST	 EQU	  $
	 LDA	  #010H
	 STA	  ENYSD1,X
;
	 LDA	  #0FFH
	 STA	  <ENYSD0,X
	 JMP	  UPES80
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  DWELST    [ Down elevator set ]		     #
;#####################################################################
DWELST	 EQU	  $
	 LDA	  #0F0H
	 STA	  ENYSD1,X
;
	 LDA	  #0
	 STA	  <ENYSD0,X
;
UPES80	 EQU	  $
	 LDY	  #1
	 JSR	  LEPRVS	  ; Elevator pos revice
;
	 LDA	  #ELCMD
	 STA	  ENCSMD,X	  ; ENCSMD <-- Elevator cross mode set
;
	 RTS
;
;#####################################################################
;#	 Lift & Elevator & Gorl flag (x)pos revice data		     #
;#####################################################################
LEPRVD	 EQU	  $	    ; Position revice data !
	 HEX	  08		  ; Lift
	 HEX	  0C		  ; Elevator ( 4 block )
	 HEX	  F8		  ;	     ( 6 block )
;
	 HEX	  00,00,FF
;
;#####################################################################
;#		     (Y) -- 0 : Lift				     #
;#			    1 : Elevator ( 4 block )		     #
;#			    2 : Elevator ( 6 block )		     #
;#	 JSR	  LEPRVS    [ Lift & Elevator pos revice sub ]	     #
;#####################################################################
LEPRVS	 EQU	  $
	 LDA	  ENXPS1,X
	 CLC
	 ADC	  LEPRVD,Y
	 STA	  ENXPS1,X
;
	 LDA	  <ENXPS0,X
	 ADC	  LEPRVD+3,Y
	 STA	  <ENXPS0,X
;
	 RTS
;
;#####################################################################
;#	 JSR	  FGEDIT    [ Frame/game end initial ]		     #
;#####################################################################
FGEDIT	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  ENPROS    [ Enmey process ]			     #
;#####################################################################
ENPROS	 EQU	  $
	 LDX	  <INDEX
	 LDA	  #0
	 LDY	  <ENMYNO,X
	 CPY	  #ENDTR
	 BCC	  ENPS40	  ;- IF	 tortoise ?	  ( YES ; ENPS40 )
;
	 TYA
	 SBC	  #ENDTR-SHTR-1
;
ENPS40		EQU	$
		ASL	A
		TAY
		LDA	ENPS40TBL,Y
		STA	<WORK+4
		LDA	ENPS40TBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
ENPS40TBL	EQU	$
	 WORD	  ENMPRS	  ;  0 - 12 Move tortoise
;
	 WORD	  BGTFPS	  ; 15 Big tortoice fire
	 WORD	  FRWKMV	  ; 16 Fireworks
	 WORD	  ENPS90	  ; 17 Dammy  ( timer check kame )
	 WORD	  ENPS90	  ; 18 Dammy  ( for countine out chara )
;
;;;;;;;; WORD	  BRIDGEMV	  : 19 bridge
	 WORD	  ENPS90	  ; 19 ???????????????????
;
	 WORD	  ENPS90	  ; 1A ???????????????????
	 WORD	  SSTPRS	  ; 1B Spin stick-0
	 WORD	  SSTPRS	  ; 1C		 -1
	 WORD	  SSTPRS	  ; 1D		 -2
	 WORD	  SSTPRS	  ; 1E		 -3
	 WORD	  SSTPRS	  ; 1F		 -4
	 WORD	  SSTPRS	  ; 20		 -5
	 WORD	  SSTPRS	  ; 21		 -6
	 WORD	  SSTPRS	  ; 22		 -7
;
;;;;;;;; WORD	  LFMPRS	  : 23 Loop elevator
	 WORD	  ENPS90	  ; 23 ???????????????????
;
	 WORD	  LFMPRS	  ; 24 Lift dubble
	 WORD	  LFMPRS	  ; 25	    single UP & DW
	 WORD	  LFMPRS	  ; 26		   UP
	 WORD	  LFMPRS	  ; 27		   DW
	 WORD	  LFMPRS	  ; 28	    LF & RT swing
	 WORD	  LFMPRS	  ; 29 On to lift
;
	 WORD	  LFMPRS	  ; 2A On to lift
;
	 WORD	  ELMPRS	  ; 2B Elevator UP
	 WORD	  ELMPRS	  ; 2C		DW
	 WORD	  ENBKMV	  ; 2D Big kame
;
	 WORD	  MSMOVE	  ; 2E Bonus mushroom in block
	 WORD	  WDMOVE	  ; 2F	     wood
;
	 WORD	  ENPS90	  ; 30 Gorl flag
	 WORD	  CFLAGMV	  ; 31 Castle flag
	 WORD	  SPRING	  ; 32 Spring
;
	 WORD	  ENPS90	  ; 33 Dammy ( gun shell )
	 WORD	  NOTRMV1	  ; 34 Nothing TR1
	 WORD	  GILDISP	  ; 35 Girl Display
;
ENPS90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  GILDISP   [ Girl Display pros ]		     #
;#####################################################################
GILDISP	 EQU	  $
	 JSR	  ENFRCK	  ;	  frame side check
	 JSR	  ENPSCV	  ;	  OBJ position calc
	 JMP	  ENCSET	  ;	  character set.
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#		     (A) -- Enemy No.				     #
;#	 JSR	  ENMPRS    [ Enemy move pros ]			     #
;#####################################################################
ENMPRS	 EQU	  $	    ;  Tortoise move pros !
	 LDA	  #20H
	 STA	  ENOJBG,X	  ; OBJ & BG priority flag OFF
;
	 JSR	  ENFRCK	  ;	  frame side check
	 JSR	  ENPSCV	  ;	  OBJ position calc
	 JSR	  ENCSET	  ;	  character set.
	 JSR	  ENCRDS	  ;	  cross check data set
	 JSR	  CRENBG	  ;	  vs BG.	 "
	 JSR	  CRENEN	  ;	  vs Enemy
	 JSR	  CRENPL	  ;	  vs player cross check
;
	 LDY	  GMSTTM	  ;************************************
	 BNE	  ENMOVV
;
	 JSR	  ENMOVE	  ; Enemy move calc
;
ENMOVV	 EQU	  $
;;	 JSR	  ENFRCK	  :	  frame side check
;;	 JSR	  ENPSCV	  :	  OBJ position calc
	 JMP	  ENGAWY	  ;	  end cheack.
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENMOVE    [ Enemy move calc ]			     #
;#####################################################################
ENMOVE		EQU	$
		LDA	<ENMYNO,X
		ASL	A
		TAY
		LDA	ENMOVETBL,Y
		STA	<WORK+4
		LDA	ENMOVETBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
ENMOVETBL	EQU	$
	 WORD	  ENWKMV	  ;  0	Enemy normal green
	 WORD	  ENWKMV	  ;  1		     Red
	 WORD	  ENWKMV	  ;  2		     brack
	 WORD	  ENWKMV	  ;  3		     turn low speed
	 WORD	  ENWKMV	  ;  4		     turn hi speed
	 WORD	  FIENMV	  ;  5	Fire  enemy
	 WORD	  ENWKMV	  ;  6	Mush room enemy
	 WORD	  ENIKMV	  ;  7	Ika
	 WORD	  ENFTM0	  ;  8	Flying tama
;
;;;;;;;; WORD	  ENFYMV0	  :  9	Fly green
	 WORD	  ENMV90	  ;  9	??????????????????
;
	 WORD	  ENFYMV0	  ;  A	Water enemy-0
	 WORD	  ENFYMV0	  ;  B		   -1
	 WORD	  JPTRMV	  ;  C	Jump from water enemy move
	 WORD	  ENFWRMV	  ;  D	In chimney flower
	 WORD	  ENPYMV	  ;  E	Jumping
	 WORD	  ENUDMV	  ;  F	UP & DE floot
	 WORD	  ENRLMV	  ; 10	LF & RT swing
	 WORD	  ENSHPMV	  ; 11		move ship
	 WORD	  ENWKMV	  ; 12	Fall-0 ( bakudan )
;
;;;;;;;; WORD	  ENMV90	  : 13	    -1 ( bakudan )
	 WORD	  ENMV90	  ; 13	??????????????????
;
	 WORD	  ENFSHMV	  ; 14	Jump fish
;
ENMV90	 EQU	  $
;
	 RTS
;
;####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  BGTFPS    [ Big tortoice fire pros ]		     #
;#####################################################################
BGTFPS	 EQU	  $
	 JSR	  BKMFMV	  ; Big kame fire move
	 JSR	  ENFRCK	  ;		  frame side check
	 JSR	  ENPSCV	  ;		  OBJ position calc
	 JSR	  ENCRDS	  ;		  cross check data set
	 JSR	  CRENPL	  ;		  vs player cross check
	 JMP	  ENLDWY	  ;		  end cheack.
;
;####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  SSTPRS    [ Spin stick move pros ]		     #
;#####################################################################
SSTPRS	 EQU	  $	    ; Spin stick pros !
	 JSR	  ENSSMV	  ; Enemy spin stick move
	 JMP	  ENLDWY	  ;		     end cheack.
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ELMPRS    [ Elevator move pros ]		     #
;#####################################################################
ELMPRS	 EQU	  $	    ; Elevator move pros !
	 JSR	  ENFRCK	  ; Elevator frame side check
	 JSR	  ENPSCV	  ;	     OBJ position calc
	 JSR	  ELCRDS	  ;	     cross check data set
	 JSR	  CRELPL	  ;	     vs player cross check
	 JSR	  ENPSCV	  ;	     OBJ position calc
	 JSR	  ELCSET	  ;	     chara set
	 JSR	  ELMOVE	  ;	     move pros.
	 JMP	  ENLDWY	  ;	     end check
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMPRS    [ Lift move pros ]			     #
;#####################################################################
LFMPRS	 EQU	  $	    ; Lift move pros !
	 JSR	  ENFRCK	  ; Lift frame side check
	 JSR	  ENPSCV	  ;	 OBJ position calc
	 JSR	  LFCRDS	  ;	 cross check data set
	 JSR	  CRLFPL	  ;	 vs player cross check
;
;-------- Move start ----
	 LDA	  GMSTTM	  ;************************************
	 BNE	  LFMP25
;
	 JSR	  LFMVMD
;
;-------- Move end --------
LFMP25	 EQU	  $
	 JSR	  ENPSCV	  ;	 OBJ position calc
	 JSR	  LFCSET	  ;	 chara set
	 JMP	  ENLDWY	  ;	 End check
;
;
LFMVMD	 EQU	  $
	 LDA	  <ENMYNO,X
	 SEC
;;;;;;;; SBC	  #ELP0
	 SBC	  #LFT0
		ASL	A
		TAY
		LDA	LFMVMDTBL,Y
		STA	<WORK+4
		LDA	LFMVMDTBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
LFMVMDTBL	EQU	$
;;;;;;;; WORD	  ENELPMV	       : Loop lift
	 WORD	  LFMOV0	       ; Double UP & DW lift
	 WORD	  LFMOV1	       ; Single UP & DW lift
	 WORD	  LFMOV2	       ;    "   UP
	 WORD	  LFMOV3	       ;    "   DW
	 WORD	  LFMOV4	       ; Swing
	 WORD	  LFMOV5	       ; On down lift
	 WORD	  LFMOV6	       ; On down lift
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENFAIL    [ Enemy fail ]			     #
;#####################################################################
ENFAIL	 EQU	  $
ENCLER	 EQU	  $
	 STZ	  TMEL1,X
ENCLER2	 EQU	  $
	CPX	#09H
	BNE	ENRTN
	LDA	#0F0H
	STA	OAM2+0E1H
	STA	OAM2+0E5H
	STA	OAM2+0E9H
	STA	OAM2+0EDH
	LDA	<BG2COS
	CMP	#22H
	BNE	ENRTN
	STZ	SKYFLG
ENRTN	EQU	$
	 STZ	  <ENCMOD,X
	 STZ	  <ENMYNO,X
	 STZ	  <ENSTAT,X
	 STZ	  SCFLAG,X
	 STZ	  ENCONT,X
	 STZ	  ETMS01,X
	 STZ	  ONLFFG,X
	 LDA	  #20H
	 STA	  ENOJBG,X
	 LDA	  #0
RTN	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  JPTRMV    [ Jump from water  move ]		     #
;#####################################################################
JPTRMV	 EQU	  $
	 LDA	  TMEL1,X
	 BNE	  JPTR10
;
	 JSR	  FXJPTR	  ; Position initial
;
	 LDA	  RND0,X
	 ORA	  #80H
	 STA	  ENYCL1,X
;
	 AND	  #0FH
	 ORA	  #6
	 STA	  TMEL1,X	  ; Next jump timer set
;
	 LDA	  #0F9H
	 STA	  <ENYCL0,X	   ; Next jump power set
;
JPTR10	 EQU	  $
	LDA	ENYSD0,X
	BMI	JPTR20
	LDA	ENYPS1,X
	CMP	#0C0H
	BCC	JPTR20
	LDA	FIREUS,X
	CMP	#02H
	BNE	JPTR20
	INC	FIREUS,X
	STZ	FIRECT,X
	LDA	#27H
	STA	!SOUND3
JPTR20	EQU	$
	INC	FIRECT,X
	JSL	>FENPCV
	 JMP	  ENGCL2	  ; Jump calclate
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  FIENMV    [ Karugary bros.   move ]		     #
;#####################################################################
HMCTDT	 EQU	  $
	 HEX	  30,1C
;
ENSPDT	 EQU	  $
;  Muki
	 HEX	  00,E8		  ; Right x speed add.	Walk,Down
	 HEX	  00,18		  ; Left	 "
;
ENSPDT1	 EQU	  $
	 HEX	  08,F8		  ; low
	 HEX	  0C,F4		  ; Hi
;
;---------------------------------------
FIENMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #00100000B
	 BEQ	  FIEN00
;
	 JMP	  ENMEND	  ; Fail down
;
FIEN00	 EQU	  $
;;	 LDA	  TMEL1,X
;;	 BEQ	  FIEN01
;
	 LDA	  FIENTM,X
	 BEQ	  FIEN01
;
	 DEC	  FIENTM,X
;
;;;;	 AND	  RND1,X
;;;;	 BNE	  FIEN90
;
;;;;	 LDA	  TMEM
;;;;	 BNE	  FIEN90
;
	 LDA	  ENFMSD
	 AND	  #00001100B
	 BNE	  FIEN90
;
	 LDA	  ENCRCT,X
	 BNE	  FIEN0A
;
;----- Tomafork slow ---------
	 LDY	  ENLVFG
	 LDA	  HMCTDT,Y
;
;;;;	 LDA	  #2CH
;;;;	 LDA	  #0AH
	 STA	  ENCRCT,X
;----------------------------
	 JSR	  HMINIT
;----------------------------
	 BCC	  FIEN0A
	 LDA	  <ENSTAT,X
	 ORA	  #00001000B
	 STA	  <ENSTAT,X
	 JMP	  FIEN90
;
FIEN0A	 EQU	  $
	 DEC	  ENCRCT,X
	 JMP	  FIEN90
;-------------------------------
FEJPDT	 EQU	  $
	 BYTE	  32,55
;
FIEN01	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #00000111B
	 CMP	  #DOWN
	 BEQ	  FIEN90
;
	 STZ	  <WORK
;;;	    LDA	     #0
;;;	    STA	     <WORK
;
	 LDY	  #0FAH
	 LDA	  ENYPS1,X
	 BMI	  FIEN10
;
	 LDY	  #0FDH
	 CMP	  #70H
	 INC	  <WORK
	 BCC	  FIEN10
;
	 DEC	  <WORK
;;;;;	 TAY
	 LDA	  RND0,X
	 AND	  #1
	 BNE	  FIEN05
	 LDY	  #0FAH
FIEN05	 EQU	  $
;;;;;	 TYA
FIEN10	 EQU	  $
	 STY	  <ENYCL0,X
;
	 LDA	  <ENSTAT,X
	 ORA	  #DOWN
	 STA	  <ENSTAT,X
;
	 LDA	  <WORK
	 AND	  RND1,X
	 TAY
;
	 LDA	  ENLVFG
	 BNE	  PP1
	 TAY
PP1	 EQU	  $
	 LDA	  FEJPDT,Y
;;;;	 LDA	  #30
	 STA	  ETMS01,X
;;;;	 STA	  FIENTM,X
;
	 LDA	  RND0,X
;;TEST	 ORA	  #3
;;;	 AND	  #00000111B
;;;	 STA	  TMEL1,X
	 ORA	  #0C0H
	 STA	  FIENTM,X
;
;
FIEN90	 EQU	  $
;;;	 LDA	  ENSTAT,X
;;;;	 AND	  #00001000B
;;;;;	 BNE	  FIEN99
;
	 LDY	  #0FCH
	 LDA	  <FMCNT
	 AND	  #01000000B
	 BNE	  FIEN95
	 LDY	  #4
FIEN95	 EQU	  $
	 STY	  <ENXSD0,X
;
	 LDY	  #1
	 JSR	  CRECMP
	 BMI	  FIEN96
	 INY
;
	 LDA	  TMEL1,X
	 BNE	  FIEN96
;
	 LDA	  #0F8H
	 STA	  <ENXSD0,X
;
FIEN96	 EQU	  $
	 STY	  <ENMMKI,X
;
;;;;	 JSR	  ENWKMV
;;;;	 RTS
FIEN99	 EQU	  $
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENWKMV    [ Enemy  walk move ]		     #
;#####################################################################
ENWKMV	 EQU	  $
	 LDY	  #0
	 LDA	  <ENSTAT,X
	 AND	  #01000000B
	 BNE	  ENM00
;
	 LDA	  <ENSTAT,X
	 ASL	  A
	 BCS	  ENM10
;
	 LDA	  <ENSTAT,X
	 AND	  #00100000B
	 BNE	  ENMEND
;
	 LDA	  <ENSTAT,X
	 AND	  #00000111B
	 BEQ	  ENM10
	 CMP	  #DROP
	 BEQ	  ENM00
;
	 CMP	  #STOP
	 BCS	  ENM80
;
ENM00	 EQU	  $
	 JSR	  ENGCAL	  ; y move
;
	 LDY	  #0
;
	 LDA	  <ENSTAT,X
	 CMP	  #JUMP
	 BEQ	  ENMA0
;
	 AND	  #01000000B
	 BEQ	  ENM10
	 LDA	  <ENMYNO,X
	 CMP	  #BMUS
	 BEQ	  ENM10
	 BNE	  ENM01
;
ENMA0	 EQU	  $
	 JMP	  ENCLX0
;
;
ENM01	 EQU	  $
	 LDY	  #1
ENM10	 EQU	  $
	 LDA	  <ENXSD0,X
	 PHA
	 BPL	  ENM20
	 INY
	 INY
;
ENM20	 EQU	  $
	 CLC
	 ADC	  ENSPDT,Y
	 STA	  <ENXSD0,X
;
	 JSR	  ENCLX0	  ; x move
;
	 PLA
	 STA	  <ENXSD0,X
	 RTS
;
ENM80	 EQU	  $
	 LDA	  TMEL1,X
	 BNE	  ENMR10
;
	 STA	  <ENSTAT,X
	 LDA	  <FMCNT
	 AND	  #1
	 TAY
;
	 INY
	 STY	  <ENMMKI,X
	 DEY
;
	 LDA	  GMLOOP
	 BEQ	  ENM88	    ; Dificult	?
;
	 INY		    ; Yes !
	 INY
ENM88	 EQU	  $
	 LDA	  ENSPDT1,Y
;
;;;;	 PHA
;
;;;;	 LDA	  ENMYNO,X
;;;;	 LSR	  A
;;;;	 BCC	  ENM90		  : Speed Hi ?
;
;;;;	 PLA			  : Yes !
;;;;	 ASL	  A
;;;;	 BYTE	  SKIP1
;
;ENM90	  EQU	   $
;;;;	 PLA
;ENM95	  EQU	   $
	 STA	  <ENXSD0,X
ENMRET	 EQU	  $
	 RTS
;
ENMEND	 EQU	  $
	 JSR	  ENGCAL
	 JMP	  ENCLX0
;
ENMR10	 EQU	  $
	 CMP	  #0EH
	 BNE	  ENMR20
;
	 LDA	  <ENMYNO,X
	 CMP	  #YPVS
	 BNE	  ENMR20
;
	 JSR	  ENCLER
ENMR20	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENPYMV    [ Enemy  jumping move ]		     #
;#####################################################################
ENPYMV	 EQU	  $
	 JSR	  ENGCL2
	 JMP	  ENCLX0
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENUDMV    [ Enemy slow up down move ]		     #
;#####################################################################
ENUDMV	 EQU	  $
	 LDA	  <ENYCL0,X
	 ORA	  ENYCL1,X
	 BNE	  ENUD05
;
	 STA	  ENYPS2,X
;
	 LDA	  ENYPS1,X
	 CMP	  ENMAXY,X
	 BCS	  ENUD05
;
	 LDA	  <FMCNT
	 AND	  #00000111B
	 BNE	  ENUD06
	 INC	  ENYPS1,X
ENUD06	 EQU	  $
	 RTS
;
ENUD05	 EQU	  $
	 LDA	  ENYPS1,X
	 CMP	  <ENCTPS,X
	 BCC	  ENUD10
;
	 JMP	  ENFCLS    ; Up.
;
;
ENUD10	 EQU	  $
	 JMP	  ENGCLS    ; Down.
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENRLMV    [ Enemy right left move ]		     #
;#####################################################################
ENRLMV	 EQU	  $
	 JSR	  ENRLCL
;
	 JSR	  RLMOVE
;
	 LDY	  #1
;
;---- Up down -------------
	 LDA	  <FMCNT
	 AND	  #00000011B
	 BNE	  ENLR95
;
	 LDA	  <FMCNT
	 AND	  #01000000B
	 BNE	  ENLR90
	 LDY	  #0FFH
ENLR90	 EQU	  $
	 STY	  <WORK
	 LDA	  ENYPS1,X
	 CLC
	 ADC	  <WORK
	 STA	  ENYPS1,X
ENLR95	 EQU	  $
	 RTS
;
;---------------------------------------
ENRLCL	 EQU	  $
	 LDA	  #13H
ENRLC2	 EQU	  $
	 STA	  <WORK+1	   ; Max Speed
;
	 LDA	  <FMCNT
	 AND	  #3
	 BNE	  ENRL00
;
	 LDY	  <ENXSD0,X
;
	 LDA	  <ENRLCT,X
	 LSR	  A
	 BCS	  ENRL10
;
;;;;;	 CPY	  #13H		  : Max speed
	 CPY	  <WORK+1	   ; Max speed
	 BEQ	  ENRL20
;
	 INC	  <ENXSD0,X
ENRL00	 EQU	  $
	 RTS
;
ENRL20	 EQU	  $
	 INC	  <ENRLCT,X
	 RTS
;
ENRL10	 EQU	  $
	 TYA
	 BEQ	  ENRL20
;
	 DEC	  <ENXSD0,X
	 RTS
;
;---------------------------
RLMOVE	 EQU	  $
	 LDA	  <ENXSD0,X
	 PHA
;
	 LDY	  #1
	 LDA	  <ENRLCT,X
	 AND	  #00000010B
	 BNE	  ENRLRT
;
	 LDA	  <ENXSD0,X
	 EOR	  #0FFH
	 CLC
	 ADC	  #1
	 STA	  <ENXSD0,X
	 LDY	  #2
;
ENRLRT	 EQU	  $
	 STY	  <ENMMKI,X
	 JSR	  ENCLX0
;
	 STA	  <WORK		   ; Move value
;
	 PLA
	 STA	  <ENXSD0,X
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENIKMV    [ Enemy Ika	       move ]		     #
;#####################################################################
ENSHDT	 EQU	  $
	 BIN	  00111111	  ; Easy
	 BIN	  00000011	  ; Dificulty
;
ENIKMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #00100000B
	 BNE	  ENIKFL	  ; Fail down
;
;------ Surch -----------------------
	 LDY	  ENLVFG
	 LDA	  RND0,X
	 AND	  ENSHDT,Y
	 BNE	  ENIK02
;
	 TXA
	 LSR	  A
	 BCC	  ENIK000
	 LDY	  <PLMMKI
	 BCS	  ENIK01
ENIK000	 EQU	  $
;
	 LDY	  #2
;;;	 LDA	  FMCNT
;;;	 AND	  #3
;;;	 BNE	  ENIK00
;;;	 DEY
;ENIK00	  EQU	   $
	 JSR	  CRECMP
	 BPL	  ENIK01
	 DEY
;;;	 TYA
;;;	 EOR	  #00000011B
;;;	 TAY
ENIK01	 EQU	  $
	 STY	  <ENMMKI,X
;
ENIK02	 EQU	  $
	 JSR	  ENIKCL
;
	 LDA	  ENYPS1,X
	 SEC
	 SBC	  ENYCL1,X
	 CMP	  #20H
	 BCC	  ENIK03	  ; Top water limit ?
;
	 STA	  ENYPS1,X	  ; No.
;
ENIK03	 EQU	  $
	 LDY	  <ENMMKI,X
	 DEY
	 BNE	  ENIK05
;
	 LDA	  ENXPS1,X
	 CLC
	 ADC	  <ENXSD0,X
	 STA	  ENXPS1,X
;
	 LDA	  <ENXPS0,X
	 ADC	  #0
	 STA	  <ENXPS0,X
	 RTS
;
ENIK05	 EQU	  $
	 LDA	  ENXPS1,X
	 SEC
	 SBC	  <ENXSD0,X
	 STA	  ENXPS1,X
;
	 LDA	  <ENXPS0,X
	 SBC	  #0
	 STA	  <ENXPS0,X
	 RTS
;
ENIKFL	 EQU	  $
	 JMP	  ENGCL3
;
;------------------------------------
ENIKCL	 EQU	  $
	 LDA	  <ENRLCT,X
	 AND	  #00000010B
	 BNE	  IKSTOP
;
	 LDA	  <FMCNT
	 AND	  #00000111B
	 PHA
;
	 LDA	  <ENRLCT,X
	 LSR	  A
	 BCS	  IKBLAK
;
	 PLA
	 BNE	  ENIK10
;
	 LDA	  ENYCL1,X
	 CLC
	 ADC	  #1
	 STA	  ENYCL1,X
;
	 STA	  <ENXSD0,X
;
	 CMP	  #2
	 BNE	  ENIK10
	 INC	  <ENRLCT,X
;
ENIK10	 EQU	  $
	 RTS
;
IKBLAK	 EQU	  $
	 PLA
	 BNE	  ENIK20
;
	 LDA	  ENYCL1,X
	 SEC
	 SBC	  #1
	 STA	  ENYCL1,X
;
	 STA	  <ENXSD0,X
	 BNE	  ENIK20
	 INC	  <ENRLCT,X
	 LDA	  #2
	 STA	  TMEL1,X
ENIK20	 EQU	  $
	 RTS
;
IKSTOP	 EQU	  $
	 LDA	  TMEL1,X
	 BEQ	  ENIK30
;
IKSUCH	 EQU	  $
	 LDA	  <FMCNT
	 LSR	  A
	 BCS	  ENIK40
;
	 INC	  ENYPS1,X
ENIK40	 EQU	  $
	 RTS
;
ENIK30	 EQU	  $
	 LDA	  ENYPS1,X
	 ADC	  #10H
	 CMP	  YPOS1
	 BCC	  IKSUCH
;
	 LDA	  #0
	 STA	  <ENRLCT,X
	 RTS
;
;
;*********************************************************************
;*	 Fly tama				   (ENFTM0)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ENFTM0	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #20H
	 BEQ	  EFTM20      ;out ?
;			      ;yes
	 JMP	  ENGCL2
;
EFTM20	 EQU	  $
	 LDA	  #0E8H
	 STA	  <ENXSD0,X
	 JMP	  ENCLX0      ;move
;
;
;*********************************************************************
;*	 Fly turtle				   (ENFYMV0)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
EFMV0DT1 EQU	  $	      ;x-speed data
;;;;;;;	 HEX	  40,40,80
	 HEX	  40,80
;
EFMV0DT2 EQU	  $	      ;y-speed data
EFMV0DT3 EQU	  $	      ;angle speed data
;;;;;;;; HEX	  10,04,04
	 HEX	  04,04
;
;
ENFYMV0	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #20H
	 BEQ	  EFMV010     ;out ?
;			      ;yes
	 JMP	  ENGCL3
;
EFMV010	 EQU	  $
	 STA	  <WORK+3
;
	 LDA	  <ENMYNO,X
	 SEC
;;;;;	      SBC      #FTR0
	 SBC	  #WTR0
	 TAY
	 LDA	  EFMV0DT1,Y
	 STA	  <WORK+2      ;(work+2) <-- x-pos. move data
;
;;-------------------------------------------------------------------
	 LDA	  ENXPS2,X
	 SEC
	 SBC	  <WORK+2
	 STA	  ENXPS2,X
	 LDA	  ENXPS1,X
	 SBC	  #00H
	 STA	  ENXPS1,X
	 LDA	  <ENXPS0,X
	 SBC	  #00H
	 STA	  <ENXPS0,X    ;x-pos. move
;
	 LDA	  #20H
	 STA	  <WORK+2
;
	 CPX	  #02H
	 BCC	  EFMV050     ;y-move ?
;			      ;yes
	 LDA	  <AGLBUF,X
	 CMP	  #10H
	 BCC	  EFMV020     ;y-pos. add. ?
;			      ;yes
	 LDA	  ENYPS2,X
	 CLC
	 ADC	  <WORK+2
	 STA	  ENYPS2,X
	 LDA	  ENYPS1,X
	 ADC	  <WORK+3
	 STA	  ENYPS1,X
	 LDA	  <ENYPS0,X
	 ADC	  #00H
	 BRA	  EFMV030
;;;	    JMP	     EFMV030
;
EFMV020	 EQU	  $
	 LDA	  ENYPS2,X
	 SEC
	 SBC	  <WORK+2
	 STA	  ENYPS2,X
	 LDA	  ENYPS1,X
	 SBC	  <WORK+3
	 STA	  ENYPS1,X
	 LDA	  <ENYPS0,X
	 SBC	  #00H
EFMV030	 EQU	  $
	 STA	  <ENYPS0,X
;
	 LDY	  #00H
	 LDA	  ENYPS1,X
	 SEC
	 SBC	  AGLFLG,X
	 BPL	  EFMV040     ;
;			      ;
	 LDY	  #10H
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
EFMV040	 EQU	  $
	 CMP	  #0FH
	 BCC	  EFMV050     ;y-pos. move course change ?
;			      ;yes
	 TYA
	 STA	  <AGLBUF,X
EFMV050	 EQU	  $
	 RTS
;;-------------------------------------------------------------------
;
;;;;;	      LDA      #00H
;;;;;	      STA      WORK+3	   ;x-speed set
;;;;;;
;;;;;	      LDA      EFMV0DT2,Y
;;;;;	      STA      YSPEED	   ;y-speed set
;;;;;;
;;;;;	      LDA      EFMV0DT3,Y
;;;;;	      STA      WORK+7	   ;(work+7) <-- angle speed
;;;;;;
;;;;;	      LDA      #03H
;;;;;	      STA      ANGLCT2	   ;
;;;;;;
;;;;;	      LDA      AGLFLG,X
;;;;;	      AND      #01H
;;;;;	      JSR      AGLMV20	   ;angle move
;;;;;	      AND      #0FH
;;;;;	      STA      ANGLE,X
;;;;;	      STA      WORK+7
;;;;;;
;;;;;	      LDY      AGLFLG,X
;;;;;	      CMP      #04H
;;;;;	      BNE      EFMV060	   ;check ?
;;;;;;				   ;yes
;;;;;	      CPY      #00H
;;;;;	      BNE      EFMV080	   ;limit ?
;;;;;;				   ;no
;;;;;EFMV060  EQU      $
;;;;;	      CMP      #0CH
;;;;;	      BNE      EFMV100	   ;check ?
;;;;;;				   ;yes
;;;;;	      CPY      #00H
;;;;;	      BNE      EFMV100	   ;limit ?
;;;;;;				   ;yes
;;;;;EFMV080  EQU      $
;;;;;	      LDA      AGLFLG,X
;;;;;	      EOR      #01H
;;;;;	      STA      AGLFLG,X
;;;;;EFMV100  EQU      $
;;;;;	      JMP      EFMVS20	   ;move
;
;
;*********************************************************************
;*	 Spin-stick move			   (ENSSMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
;
;	 Distance = SIN(ANGLE*(90/8))*R
;
DISTANDT EQU	  $	      ;distance data
;	 angle =   0  1	 2  3  4  5  6	7  8	   ( R )
	 HEX	  00,01,03,04,05,06,07,07,08	   ; 8H =  8
	 HEX	  00,03,06,09,0B,0D,0E,0F,10	   ;10H = 16
	 HEX	  00,04,09,0D,10,13,16,17,18	   ;18H = 24
	 HEX	  00,06,0C,12,16,1A,1D,1F,20	   ;20H = 32
	 HEX	  00,07,0F,16,1C,21,25,27,28	   ;28H = 40
	 HEX	  00,09,12,1B,21,27,2C,2F,30	   ;30H = 48
	 HEX	  00,0B,15,1F,27,2E,33,37,38	   ;38H = 56
	 HEX	  00,0C,18,24,2D,35,3B,3E,40	   ;40H = 64
	 HEX	  00,0E,1B,28,32,3B,42,46,48	   ;48H = 72
	 HEX	  00,0F,1F,2D,38,42,4A,4E,50	   ;50H = 80
	 HEX	  00,11,22,31,3E,49,51,56,58	   ;58H = 88
;
;
SSEVNT1	 EQU	  $	      ;short spin-stick event data  : 0 = (-)
;							    : 1 = (+)
	 BIN	  00000001
	 BIN	  00000011
	 BIN	  00000010
	 BIN	  00000000
;
SSPNTDT	 EQU	  $	      ;distance data point data
;		   0  1	 2  3  4  5
	 HEX	  00,09,12,1B,24,2D
;		   6  7	 8  9  A  B
	 HEX	  36,3F,48,51,5A,63
;
ESPYDT	 EQU	  $	      ;player cross check y-pos. data
	 HEX	  0C,18
;
;
ENSSMV	 EQU	  $
;;T;;	LDA	ENCLFG
;;T;;	BNE	ESMV100
	 JSR	  ENFRCK
	 LDA	  ENFMSD
	 AND	  #08H
	 BNE	  ESMV100     ;move ok ?
;			      ;yes
	 LDA	  GMSTTM
	 BNE	  ESMV020     ;move ok ?
;			      ;yes
	 LDA	  AGLTBL,X
	 JSR	  ANGLMV      ;angle move
	 AND	  #1FH
	 STA	  <ANGLE,X
ESMV020	 EQU	  $
	 LDA	  <ANGLE,X
	 LDY	  <ENMYNO,X
	 CPY	  #SST4
	 BCC	  ESMV035     ;long ?
;			      ;yes
	 CMP	  #08H
	 BEQ	  ESMV030     ;angle replace ?
;			      ;no
	 CMP	  #18H
	 BNE	  ESMV035     ;angle replace ?
;			      ;yes
ESMV030	 EQU	  $
	 CLC
	 ADC	  #01H
	 STA	  <ANGLE,X     ;angle replace
ESMV035	 EQU	  $
	 STA	  <WORKC
	 JSR	  ENPSCV      ;oam address set
	 JSR	  ESMV500     ;data set
	 LDY	  !OAMEN,X
	 LDA	  ENOBJY
	 STA	  OAM2+01,Y	  ;y-pos. set
	 STA	  <WORK+7
	 LDA	  ENOBJX
	 STA	  OAM2+00,Y	;x-pos. set
	 STA	  <WORK+6
;
	 LDA	  #01H
	 STA	  <WORK
	 JSR	  ESMV330     ;center character set
;
	 LDY	  #05H
	 LDA	  <ENMYNO,X
	 CMP	  #SST4
	 BCC	  ESMV040     ;long spin-stick ?
;			      ;yes
	 LDY	  #0BH
ESMV040	 EQU	  $
	 STY	  <WORKA       ;(WORKA) <-- counter
;
	 STZ	  <WORK
;;;	    LDA	     #00H
;;;	    STA	     <WORK
ESMV060	 EQU	  $
	 LDA	  <WORKC       ;(a) <-- angle
	 JSR	  ESMV500     ;data set
	 JSR	  ESMV200     ;move
	 LDA	  <WORK
	 CMP	  #04H
	 BNE	  ESMV080     ;oam pointer reset ?
;			      ;yes
	 LDY	  SSWORK
	 LDA	  !OAMEN,Y
	 STA	  <WORK+6      ;oam pointer reset
ESMV080	 EQU	  $
	 INC	  <WORK
	 LDA	  <WORK
	 CMP	  <WORKA
	 BCC	  ESMV060     ;end ?
;			      ;yes
ESMV100	 EQU	  $
	 RTS
;
;
ESMV200	 EQU	  $
	 LDA	  <WORK+3
	 STA	  <WORK+5
;
	 LDY	  <WORK+6
;
	 LDA	  <WORK+1
	 LSR	  <WORK+5
	 BCS	  ESMV220     ;address reverse ?
;			      ;yes
	 EOR	  #0FFH
	 ADC	  #01H
ESMV220	 EQU	  $
	 CLC
	 ADC	  ENOBJX
	 STA	  OAM2+00,Y	;x-pos. set
	 STA	  <WORK+6
;
	 CMP	  ENOBJX
	 BCS	  ESMV240     ;
;			      ;
	 LDA	  ENOBJX
	 SEC
	 SBC	  <WORK+6
	 JMP	  ESMV260
;
ESMV240	 EQU	  $
	 SEC
	 SBC	  ENOBJX
ESMV260	 EQU	  $
	 CMP	  #59H
	 BCC	  ESMV280     ;display ok ?
;			      ;yes
	 LDA	  #0F8H
	 BNE	  ESMV320
;
ESMV280	 EQU	  $
	 LDA	  ENOBJY
	 CMP	  #0F8H
	 BEQ	  ESMV320     ;y-pos. set ok ?
;			      ;yes
	 LDA	  <WORK+2
	 LSR	  <WORK+5
	 BCS	  ESMV300     ;address reverse ?
;			      ;yes
	 EOR	  #0FFH
	 ADC	  #01H
ESMV300	 EQU	  $
	 CLC
	 ADC	  ENOBJY
ESMV320	 EQU	  $
	 STA	  OAM2+1,Y	 ;y-pos. set
	 STA	  <WORK+7
	 CMP	  #0F0H
	 BCC	  ESMV325
	LDA	#01H
	STA	OAMSB+100H,Y
	BRA	ESMV330
ESMV325	 EQU	  $
	LDA	#0
	STA	OAMSB+100H,Y
;
ESMV330	 EQU	  $
	 JSR	  FICS99X      ;character set
	 TYA
	 PHA		      ;(y) push
ESMV335	 EQU	  $
	 LDA	  SPMTIM
	 ORA	  GMSTTM
	 BNE	  ESMV460     ;cross check ok ?
;			      ;yes
;;;;;;;	 LDA	  #00H
	 STA	  <WORK+5
;
	 LDY	  <PLYPS0
	 DEY
	 BNE	  ESMV460     ;player y-pos. ok ?
;			      ;yes
	 LDY	  PLYPS1
	 LDA	  PLSIZE
	 BNE	  ESMV338     ;player small ?
;			      ;no
	 LDA	  PLSDFG
	 BEQ	  ESMV340     ;sit down ?
;			      ;yes
ESMV338	 EQU	  $
	 INC	  <WORK+5
	 INC	  <WORK+5
	 TYA
	 CLC
	 ADC	  #18H
	 TAY
ESMV340	 EQU	  $
	 TYA
ESMV350	 EQU	  $
	 SEC
	 SBC	  <WORK+7
	 BPL	  ESMV360     ;
;			      ;
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
ESMV360	 EQU	  $
	 CMP	  #08H
	 BCS	  ESMV400     ;y-cross ?
;			      ;yes
	 LDA	  <WORK+6
	 CMP	  #0F0H
	 BCS	  ESMV400     ;cross check ok ?
;			      ;yes
;;;;	 LDA	  OAM+0D0H	;+3
	LDA	!PLOBJX
	 CLC
	 ADC	  #04H
	 STA	  <WORK+4
	 SEC
	 SBC	  <WORK+6
	 BPL	  ESMV380     ;
;			      ;
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
ESMV380	 EQU	  $
	 CMP	  #08H
	 BCC	  ESMV420     ;x-cross ?
;			      ;no
ESMV400	 EQU	  $
	 LDA	  <WORK+5
	 CMP	  #02H
	 BEQ	  ESMV460     ;check end ?
;			      ;no
	 LDY	  <WORK+5
	 LDA	  PLYPS1
	 CLC
	 ADC	  ESPYDT,Y
	 INC	  <WORK+5
	 JMP	  ESMV350
;
ESMV420	 EQU	  $
	 LDX	  #01H
	 LDA	  <WORK+4
	 CMP	  <WORK+6
	 BCS	  ESMV440     ;P x-pos. > E x-pos. ?
;			      ;no
	 INX
ESMV440	 EQU	  $
	TXA
	LDX	<INDEX
	 STA	  <ENMMKI
	 LDX	  #00H
	 LDA	  <WORK
	 PHA		      ;(work) push
;
	 JSR	  HEDC10      ;player out pros.
;
	 PLA
	 STA	  <WORK	       ;(work) pull
ESMV460	 EQU	  $
	 PLA		      ;(y) pull
	 CLC
	 ADC	  #04H
	 STA	  <WORK+6
	 LDX	  <INDEX
	 RTS
;
;
ESMV500	 EQU	  $
	 PHA
	 AND	  #0FH
	 CMP	  #09H
	 BCC	  ESMV520     ;limit ?
;			      ;yes
	 EOR	  #0FH
	 CLC
	 ADC	  #01H
ESMV520	 EQU	  $
	 STA	  <WORK+1
	 LDY	  <WORK
	 LDA	  SSPNTDT,Y
	 CLC
	 ADC	  <WORK+1
	 TAY
	 LDA	  DISTANDT,Y
	 STA	  <WORK+1      ;(work+1) <-- x-pos. distance set
;
	 PLA
	 PHA
	 CLC
	 ADC	  #08H
	 AND	  #0FH
	 CMP	  #09H
	 BCC	  ESMV540     ;limit ?
;			      ;yes
	 EOR	  #0FH
	 CLC
	 ADC	  #01H
ESMV540	 EQU	  $
	 STA	  <WORK+2
	 LDY	  <WORK
	 LDA	  SSPNTDT,Y
	 CLC
	 ADC	  <WORK+2
	 TAY
	 LDA	  DISTANDT,Y
	 STA	  <WORK+2      ;(work+2) <-- y-pos. distance set
;
	 PLA
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAY
	 LDA	  SSEVNT1,Y
	 STA	  <WORK+3      ;(work+3) <-- event set
	 RTS
;
;
;*********************************************************************
;*	 Fish enemy move			   (ENFSHMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
EFHADT	 EQU	  $	      ;check address data
;		   0  1	 2  3  4
	 HEX	  F8,A0,70,BD,00
;
EFATBDT	 EQU	  $	      ;attribute data
;		   0  1	 2  3  4
	 HEX	  00,00,00,20,20
;
;
ENFSHMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #20H
	 BEQ	  EFHMV20     ;out ?
;			      ;yes
	 LDA	  #20H
	 STA	  ENOJBG,X    ;attribute set
	 JMP	  ENGCL2
;
EFHMV20	 EQU	  $
	 JSR	  ENCLX0      ;x-pos. move
	 LDY	  #0DH
	 LDA	  #05H
	 JSR	  ENGC15      ;y-pos. move
;
;;;;;	      LDA      AGLTBL,X
;;;;;	      AND      #03H
;;;;;	      TAY
;;;;;	      LDA      FFYSPDT,Y
;;;;;	      STA      YSPEED	   ;y-speed set
;;;;;	      LDA      AGLTBL,X
;;;;;	      AND      #0F0H
;;;;;	      LSR      A
;;;;;	      LSR      A
;;;;;	      LSR      A
;;;;;	      LSR      A
;;;;;	      TAY
;;;;;	      LDA      FFXSPDT,Y
;;;;;	      STA      XSPEED	   ;x-speed set
;;;;;	      LDA      #05H
;;;;;	      STA      ANGLCT1
;;;;;	      LDA      #03H
;;;;;	      STA      ANGLCT2
;;;;;	      LDA      #0CH
;;;;;	      STA      WORK+7
;;;;;	      LDA      AGLFLG,X
;;;;;	      AND      #01H
;;;;;	      JSR      AGLMV20	   ;angle move
;;;;;	      AND      #0FH
;;;;;	      STA      ANGLE,X
;;;;;	      STA      WORK+5
;;;;;	      JSR      EFMVSUB	   ;move
;
	 LDA	  AGLFLG,X
;;;;;	 AND	  #0F0H
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAY
	 LDA	  ENYPS1,X
	 SEC
	 SBC	  EFHADT,Y
	 BPL	  EFHMV40     ;
;			      ;
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
EFHMV40	 EQU	  $
	 CMP	  #08H
	 BCS	  EFHMV60     ;attribute change ?
;			      ;yes
	 LDA	  AGLFLG,X
	 CLC
	 ADC	  #10H
;?? 03.12.11 ??		STA	 AGLFLG,X
;;;;;;	 AND	  #0F0H
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAY
EFHMV60	 EQU	  $
	 LDA	  EFATBDT,Y
	 STA	  ENOJBG,X    ;attribute set
;
EFHMV80	 EQU	  $
	 RTS
;
;*********************************************************************
;*	 Fly trutle ship move			   (ENSHPMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ESHSPDT	 EQU	  $	      ;x-speed data
;		   0  1	 2
	 HEX	  15,30,40
;
;
ENSHPMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #20H
	 BEQ	  ESHMV10     ;out ?
;			      ;yes
	 JMP	  ENGCAL
;
;
ESHMV10	 EQU	  $
	 LDA	  <ENSTAT,X
	 BEQ	  ESHMV20     ;return ?
;			      ;yes
	 STZ	  <ENRLCT,X
	 STZ	  ENFALFG     ;bomb code clear
;;;	    LDA	     #00H
;;;	    STA	     <ENRLCT,X
;;;	    STA	     ENFALFG	 ;bomb code clear
	 LDA	  #10H
	 BNE	  ESHMV60
;
ESHMV20	 EQU	  $
	 LDA	  #EXT0
	 STA	  ENFALFG     ;bomb code set
;
	 LDY	  #02H
ESHMV40	 EQU	  $
	 LDA	  ESHSPDT,Y
	 STA	  WORK+1,Y    ;x-speed data set
	 DEY
	 BPL	  ESHMV40     ;set end ?
;			      ;yes
	 JSR	  ESHMV500    ;x-speed check
ESHMV60	 EQU	  $
	 STA	  <ENXSD0,X    ;x-speed set
;
	 LDY	  #01H
	 LDA	  <ENRLCT,X
	 AND	  #00000001B
	 BNE	  ESHMV80     ;left move ?
;			      ;no
	 LDA	  <ENXSD0,X
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <ENXSD0,X
	 INY
ESHMV80	 EQU	  $
	 STY	  <ENMMKI,X    ;character muki set
	 JMP	  ENCLX0      ;move
;
;
;*********************************************************************
;*	 X-speed check				   (ESHMV500)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ESHMV500 EQU	  $
	 LDY	  #00H
	 JSR	  CRECMP
	 BPL	  ESHMV520    ;
;			      ;
	 INY
	 LDA	  <WORK
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <WORK
ESHMV520 EQU	  $
	 LDA	  <WORK
	 CMP	  #3CH
	 BCC	  ESHMV540    ;limit ?
;			      ;yes
	 LDA	  #3CH
	 STA	  <WORK
	 LDA	  <ENMYNO,X
	 CMP	  #ESHP
	 BNE	  ESHMV540    ;ship ?
;			      ;yes
	 TYA
	 CMP	  <ENRLCT,X
	 BEQ	  ESHMV540    ;course reverse ?
;			      ;yes
	 LDA	  <ENRLCT,X
	 BEQ	  ESHMV530    ;right move ?
;			      ;yes
	 DEC	  <ENXSD0,X
	 LDA	  <ENXSD0,X
	 BNE	  ESHMV620    ;return ok ?
;			      ;yes
ESHMV530 EQU	  $
	 TYA
	 STA	  <ENRLCT,X
ESHMV540 EQU	  $
	 LDA	  <WORK
	 AND	  #3CH
	 LSR	  A
	 LSR	  A
	 STA	  <WORK
;
	 LDY	  #00H
	 LDA	  <PLXSD0
	 BEQ	  ESHMV580    ;stop ?
;			      ;no
	 LDA	  SCRMVL
	 BEQ	  ESHMV580    ;move ?
;			      ;yes
	 INY
	 LDA	  <PLXSD0
	 CMP	  #WKRT+01H
	 BCC	  ESHMV560    ;speed-1 ?
;			      ;no
	 LDA	  SCRMVL
	 CMP	  #02H
	 BCC	  ESHMV560    ;move ?
;			      ;yes
	 INY		      ;speed-2
ESHMV560 EQU	  $
	 LDA	  <ENMYNO,X
	 CMP	  #EXT0
	 BNE	  ESHMV570    ;bomb ?
;			      ;yes
	 LDA	  <PLXSD0
	 BNE	  ESHMV580    ;player stop ?
;			      ;yes
ESHMV570 EQU	  $
	 LDA	  <ENRLCT,X
	 BNE	  ESHMV580    ;back ?
;			      ;yes
	 LDY	  #00H	      ;speed-0
ESHMV580 EQU	  $
	 LDA	  WORK+1,Y
	 LDY	  <WORK
ESHMV600 EQU	  $
	 SEC
	 SBC	  #01H
	 DEY
	 BPL	  ESHMV600    ;end ?
;			      ;yes
ESHMV620 EQU	  $
	 RTS
;
;;;;;;
;;;;;;*********************************************************************
;;;;;;*	      Loop elevator move			(ENELPMV)	  *
;;;;;;*	      [in]     (x)	   <-- index				  *
;;;;;;*********************************************************************
;;;;;ENELPMV  EQU      $
;;;;;	      LDA      GMSTTM
;;;;;	      BNE      ENELPM20	   ;move ok ?
;;;;;;				   ;yes
;;;;;	      LDA      #18H
;;;;;	      JSR      ANGLMV	   ;angle move
;;;;;	      AND      #1FH
;;;;;	      STA      ANGLE,X
;;;;;ENELPM20 EQU      $
;;;;;	      LDA      ANGLE,X
;;;;;	      STA      WORK+5
;;;;;;
;;;;;	      LDA      #20H
;;;;;	      STA      XSPEED	   ;x-speed set
;;;;;	      STA      YSPEED	   ;y-speed set
;;;;;	      LDA      #04H
;;;;;	      STA      ANGLCT1
;;;;;	      STA      ANGLCT2
;;;;;;
;;;;;	      LDA      ENXPS1,X
;;;;;	      PHA
;;;;;	      JSR      EFMVSUB	   ;move
;;;;;ENELPM40 EQU      $
;;;;;	      PLA
;;;;;	      SEC
;;;;;	      SBC      ENXPS1,X
;;;;;	      EOR      #0FFH
;;;;;	      CLC
;;;;;	      ADC      #01H
;;;;;	      STA      WORK
;;;;;	      JSR      LFM200	   ;player on x-replace
;;;;;;
;;;;;	      JMP      LFM120	   ;player on y-replace
;;;;;;
;
;*********************************************************************
;*	 Big kame ending			   (BKMEND)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
BKBCLDT	 EQU	  $	      ;BG. clear V-address data
;		   0  1	 2  3  4  5  6	7
	 HEX	  1A,58,98,96,94,92,90,8E
;		   8  9	 A  B  C  D  E
	 HEX	  8C,8A,88,86,84,82,80
;
;
BRINIT	EQU	$
	PHX
	LDX	BKBCLFG
	DEX
	DEX
	STX	BRNOCT
	AND	#10000000B	;HASHI BG ?
	BEQ	BMD020
	STZ	BRCNT,X
	LDA	#1
	STA	BRSTAT,X
	LDA	<WORK+4
	AND	#1FH
	ASL	A
	ASL	A
	ASL	A
	STA	<YWORK
	LDA	#0
	SEC
	SBC	<SCCH1
	CLC
	ADC	<YWORK
	STA	BRXPOS,X
	LDA	#3
	STA	BRWAIT,X
BMD020	EQU	$
	PLX
	RTS
;
;
BKMEND	 EQU	  $
	 LDX	  BKMIDX      ;(x) <-- index
	 LDA	  <ENMYNO,X
	 CMP	  #BKM0
	 BNE	  BKMED10     ;big kame ?
;			      ;yes
	 STX	  <INDEX
	 LDA	  <ENSTAT,X
	 BEQ	  BKMED40     ;out ?
;			      ;yes
	 AND	  #40H
	 BEQ	  BKMED10     ;out ?
;			      ;yes
	 LDA	  ENYPS1,X
	 CMP	  #0E0H
	 BCC	  BKMED20     ;end ?
;			      ;yes
BKMED10	 EQU	  $
;;;	    LDA	     #80H
;;;	    STA	     !SOUND2	    ;Sound set (BGM stop)
;
	LDA	CLRSND
	BNE	SNSKP2
;	 LDA	 <BG2COS
;	 CMP	 #21H
;	 BEQ	 SNSKIP
	LDA	#0BH
	STA	!SOUND2
	STA	CLRSND
;	 BRA	 SNSKP2
;SNSKIP	 EQU	 $
;	 LDA	 #0EH
;	 STA	 !SOUND2
;	STA	CLRSND
SNSKP2	EQU	$
;
	 INC	  GMMODE
	 JMP	  EBKM05      ;enemy clear
;
;
BKMED20	 EQU	  $
	 JSR	  ENGCL3
	 JMP	  EBKM100     ;character display
;
;
BKMED40	 EQU	  $
	 DEC	  BKMCNT
	 BNE	  BKMED60     ;foot change & BG. clear ?
;			      ;yes
	 LDA	  #04H
	 STA	  BKMCNT
	 LDA	  BKMFLG
	 EOR	  #01H
	 STA	  BKMFLG      ;foot change
;
	 LDA	  #02H
	 STA	  <WORK+5      ;(work+5) <-- H-address
	 LDY	  BKBCLFG
	 LDA	  BKBCLDT,Y
	 STA	  <WORK+4      ;(work+4) <-- L-address
	JSR	BRINIT
	 LDY	  VRAMD
	 INY
	 LDX	  #18H
	 JSR	  BGBV90      ;data set
	 LDX	  <INDEX
;
	 JSR	  BGBV100     ;count set
;
;;	   LDA	    #08H
;;	   STA	    0FEH	;Sound set
;
	 LDA	  #16H
	 STA	  !SOUND3	 ;Sound set
;
	LDA	BKBCLFG
	BNE	BKMED55
	LDA	#8
	STA	KPCHID
	LDA	#0FFH
	STA	KPCHCT
BKMED55 EQU	$
	 INC	  BKBCLFG
	 LDA	  BKBCLFG
	 CMP	  #0FH
	 BNE	  BKMED60     ;end ?
;			      ;yes
	 JSR	  YCLCLR
	 LDA	  #40H
	 STA	  <ENSTAT,X
;
;;	   LDA	    #80H
;;	   STA	    0FEH	;Sound set
BKMED60	 EQU	  $
	 JMP	  EBKM100     ;character display
;
;
;
;*********************************************************************
;*	 Big kame move				   (ENBKMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
BKJTDT	 EQU	  $	      ;jump wait data
BKMLDT	 EQU	  $	      ;big kame move limit data
	 HEX	  21,41,11,31
;
;
ENBKMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 AND	  #20H
	 BEQ	  EBKM20      ;out ?
;			      ;yes
	 LDA	  ENYPS1,X
	 CMP	  #0E0H
	 BCC	  BKMED20     ;end ?
;			      ;yes
EBKM05	 EQU	  $
	 LDX	  #MSXPS0-ENXPS0-1
EBKM10	 EQU	  $
	 JSR	  ENCLER
	 DEX
	 BPL	  EBKM10      ;enemy clear end ?
;			      ;yes
	 STA	  ENFALFG
	 LDX	  <INDEX
	 RTS
;
EBKM20	 EQU	  $
	 STZ	  ENFALFG     ;big kame fire clear
;;;	    LDA	     #00H
;;;	    STA	     ENFALFG	 ;big kame fire clear
;
	 LDA	  GMSTTM
	 BEQ	  EBKM25      ;move ok ?
;			      ;no
	 JMP	  EBKM65
;
EBKM25	 EQU	  $
	 LDA	  BKMFLG
	 BPL	  EBKM27      ;stop ?
;			      ;yes
	 JMP	  EBKM60
;
EBKM27	 EQU	  $
	 DEC	  BKMCNT
	 BNE	  EBKM30      ;foot change ?
;			      ;yes
	 LDA	  #20H
	 STA	  BKMCNT
	 LDA	  BKMFLG
	 EOR	  #01H
	 STA	  BKMFLG      ;foot change
EBKM30	 EQU	  $
	 LDA	  <FMCNT
	 AND	  #0FH
	 BNE	  EBKM33      ;muki check ?
;			      ;yes
	 LDA	  #02H
	 STA	  <ENMMKI,X    ;character muki set
EBKM33	 EQU	  $
	 LDA	  ETMS01,X
	 BEQ	  EBKM35      ;jumping ?
;			      ;no
	 JSR	  CRECMP
	 BPL	  EBKM35
;
	 LDA	  #01H
	 STA	  <ENMMKI,X    ;character muki set
	 LDA	  #02H
	 STA	  BKMDOT      ;+2 dot set
	 LDA	  #20H
	 STA	  ETMS01,X    ;timer set
	 STA	  BKMTMS      ;fire timer set
;
	 LDA	  ENXPS1,X
	 CMP	  #0B0H		; KUPPA X CHECK ;#0C8H
	 BCS	  EBKM60      ;limit ?
;			      ;no
EBKM35	 EQU	  $
	 LDA	  <FMCNT
	 AND	  #03H
	 BNE	  EBKM60      ;move ?
;			      ;yes
	 LDA	  ENXPS1,X
	 CMP	  BKMXPS
	 BNE	  EBKM37      ;move limit change ?
;			      ;yes
	 LDA	  RDM,X
	 AND	  #03H
	 TAY
	 LDA	  BKMLDT,Y
	 STA	  TPCFLG      ;move limit data set
EBKM37	 EQU	  $
	 LDA	  ENXPS1,X
	 CLC
	 ADC	  BKMDOT
	 STA	  ENXPS1,X    ;x-move
	 LDY	  <ENMMKI,X
	 CPY	  #01H
	 BEQ	  EBKM60      ;limit check ?
;			      ;yes
	 LDY	  #0FFH
	 SEC
	 SBC	  BKMXPS
	 BPL	  EBKM40      ;
;			      ;
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 LDY	  #01H
EBKM40	 EQU	  $
	 CMP	  TPCFLG
	 BCC	  EBKM60      ;limit ?
;			      ;yes
	 STY	  BKMDOT      ;move course change
EBKM60	 EQU	  $
	 LDA	  ETMS01,X
	 BNE	  EBKM70      ;jumping ?
;			      ;yes
	 JSR	  ENGCL3      ;jump
;
	 LDA	  CORSNO
	 CMP	  #05H
	 BCC	  EBKM63      ;tomafork set ?
;			      ;yes
	 LDA	  <FMCNT
	 AND	  #03H
	 BNE	  EBKM63      ;tomafork set ok ?
;			      ;yes
	 JSR	  HMINIT      ;tomafork set
EBKM63	 EQU	  $
	 LDA	  ENYPS1,X
	 CMP	  #80H
	 BCC	  EBKM80      ;end ?
;			      ;yes
	 LDA	  RDM,X
	 AND	  #03H
	 TAY
	 LDA	  BKJTDT,Y
	 STA	  ETMS01,X    ;timer set
EBKM65	 EQU	  $
	 JMP	  EBKM80
;
EBKM70	 EQU	  $
	 CMP	  #01H
	 BNE	  EBKM80      ;init. set
;
	 DEC	  ENYPS1,X
	 JSR	  YCLCLR
	 LDA	  #0FEH
	 STA	  <ENYCL0,X
EBKM80	 EQU	  $
	 LDA	  CORSNO
	 CMP	  #07H
	 BEQ	  EBKM85      ;8-course ?
;			      ;no
	 CMP	  #05H
	 BCS	  EBKM100     ;tomafork set ?
;			      ;no
EBKM85	 EQU	  $
	 LDA	  BKMTMS
	 BNE	  EBKM100     ;timer = 0 ?
;			      ;yes
	 LDA	  #20H
	 STA	  BKMTMS      ;timer set
	 LDA	  BKMFLG
	 EOR	  #80H
	 STA	  BKMFLG
	 BMI	  EBKM80      ;fire ?
;			      ;yes
	 JSR	  BKFTMSET    ;big kame fire timer set
	 LDY	  ENLVFG
	 BEQ	  EBKM90      ;bit on ?
;			      ;yes
	 SEC
	 SBC	  #10H
EBKM90	 EQU	  $
	 STA	  BKMTMS      ;timer set
	 LDA	  #BKF0
	 STA	  ENFALFG     ;big kame fire set
EBKM100	 EQU	  $
	 JSR	  EBKM200     ;character display
;
	 LDY	  #10H
	 LDA	  <ENMMKI,X
	 LSR	  A
	 BCC	  EBKM120     ;right ?
;			      ;yes
	 LDY	  #0F0H
EBKM120	 EQU	  $
	 TYA
	 CLC
	 ADC	  ENXPS1,X
	 LDY	  SSWORK
	 STA	  ENXPS1,Y    ;x-pos. reset
	 LDA	  ENYPS1,X
	 CLC
	 ADC	  #08H
	 STA	  ENYPS1,Y    ;y-pos. reset
;;T;;	CMP	#0C0H
;	BCC	EBKM130
EBKM125	 EQU	  $
;	 JSL	  >KFINIT
;;T;;	 JSL	  >KFMOVE
EBKM130	 EQU	  $
	 LDA	  <ENSTAT,X
	 STA	  ENSTAT,Y    ;status reset
	 LDA	  <ENMMKI,X
	 STA	  ENMMKI,Y    ;character muki set
	 LDA	  <INDEX
	 PHA		      ;(index) push
	 LDX	  SSWORK
	 STX	  <INDEX
	LDA	<BKSDFG
	BNE	EBKM135
	LDA	CORSNO
	CMP	#7
	BNE	EBKM133
	LDA	#5H
	BRA	EBKM134
EBKM133 EQU	$
	LDA	#04
EBKM134 EQU	$
	STA	!SOUND2
	STA	<BKSDFG
EBKM135 EQU	$
	 LDA	  #BKM0
	 STA	  <ENMYNO,X
	LDA	#20H
	STA	ENOJBG,X
;;;	    JSR	     EBKM200	 ;character display
	 PLA
	 STA	  <INDEX       ;(index) pull
	 TAX
;
	 LDA	  #00H
	 STA	  BKCHFG
EBKM140	 EQU	  $
	 RTS
;
;
EBKM200	 EQU	  $
	 INC	  BKCHFG
	 JSR	  GILDISP     ;character display
;
	 LDA	  <ENSTAT,X
	 BNE	  EBKM140     ;out ?
;			      ;no
	 LDA	  #BKCMD      ;Cross size
	 STA	  ENCSMD,X    ;ENCSMD <-- Cross mode
	 JSR	  ENCRDS      ;cross check data set
	LDA	!SYMODE
	CMP	#2
	BEQ	TAKE10
	 JMP	  CRENPL      ;vs player cross check
TAKE10	EQU	$
	RTS
;
;
;
BKFTMDT	 EQU	  $	      ;time data
;		   0  1	 2  3  4  5  6	7
	 HEX	  BF,40,BF,BF,BF,40,40,BF
;
;
BKFTMSET EQU	  $
	 LDY	  BKFTMPT
	 INC	  BKFTMPT
	 LDA	  BKFTMPT
	 AND	  #07H
	 STA	  BKFTMPT
	 LDA	  BKFTMDT,Y
BKFRTS	 EQU	  $
	 RTS
;
;*********************************************************************
;*	 Big kame fire move			   (BKMFMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
BKMFMV	 EQU	  $
	CPX	KPCHIX
	BNE	BKFM02
	LDA	KPCHCT
	BEQ	BKFM02
	LDA	KPCHID
	CMP	#6
	BEQ	BKFM200
BKFM02	EQU	$
	 LDA	  GMSTTM
	 BNE	  BKFM10      ;stop ?
;			      ;no
	 LDA	  #40H
	 LDY	  ENLVFG
	 BEQ	  BKFM05      ;bit on ?
;			      ;yes
	 LDA	  #60H
BKFM05	 EQU	  $
	 STA	  <WORK	       ;x-speed set
;
	 LDA	  ENXPS2,X
	 SEC
	 SBC	  <WORK
	 STA	  ENXPS2,X
	 LDA	  ENXPS1,X
	 SBC	  #01H
	 STA	  ENXPS1,X
	 LDA	  <ENXPS0,X
	 SBC	  #00H
	 STA	  <ENXPS0,X    ;x-move
;
	 LDY	  BKFFG1,X
	 LDA	  ENYPS1,X
	 CMP	  BKFYPDT,Y
	 BEQ	  BKFM10      ;y-pos. move ?
;			      ;yes
	 CLC
	 ADC	  BKFFG2,X
	 STA	  ENYPS1,X    ;y-pos. move
BKFM10	 EQU	  $
	 JSR	  ENPSCV      ;oam position check
;
	 LDA	  <ENSTAT,X
	 BNE	  BKFRTS      ;character set ok ?
;			      ;yes
	JSL	>BKFSET
BKFM100 EQU	$
BKFM200 EQU	$
	RTS
;
;*********************************************************************
;*	 Fireworks move				   (FRWKMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
FRWKMV	 EQU	  $
	 DEC	  <FRWFCT,X
	 BNE	  FRWKM60     ;character change ?
;			      ;yes
	 LDA	  #08H
	 STA	  <FRWFCT,X
	 INC	  <FRWCPNT,X
	 LDA	  <FRWCPNT,X
	 CMP	  #01H
	 BNE	  FRWKM55
	 LDA	  #29H
	 STA	  !SOUND0	 ;Sound set
	 BRA	  FRWKM60
FRWKM55	 EQU	  $
	 CMP	  #04H
	 BCS	  FRWKM100    ;end ?
;			      ;no
FRWKM60	 EQU	  $
	 JSR	  ENPSCV      ;oam address check
	 LDA	  ENOBJY
	 STA	  FIOBJY
	 LDA	  ENOBJX
	 STA	  FIOBJX      ;oam address set
;
	 LDY	  !OAMEN,X
	 LDA	  <FRWCPNT,X   ;(a) <-- character pointer
	 JSR	  FICST4X     ;character display
FRWKM80	 EQU	  $
	 RTS
;
FRWKM100 EQU	  $
	 STZ	  <ENCMOD,X
	 LDY	  !OAMEN,X
	LDA	#3
	STA	OAMSB2+00,Y
	STA	OAMSB2+04,Y
	STA	OAMSB2+08,Y
	STA	OAMSB2+12,Y
;
;
	 LDA	  #05H
	 STA	  WPOIN+4     ;(+500)
	 JMP	  CFLGM130    ;score up
;
;
;*********************************************************************
;*	 Castle flag move			   (CFLAGMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
;
CFLAGMV	 EQU	  $
	 STZ	  ENFALFG     ;fireworks clear
;;;	    LDA	     #00H
;;;	    STA	     ENFALFG	 ;fireworks clear
;
	 LDA	  CSINFG
	 CMP	  #05H
	 BCS	  CFLGM60     ;limit over ?
;			      ;no
	 JSR	  JSRSUB
	 WORD	  CFLGM60     ; 0 : dammy
	 WORD	  CFLGM000    ; 1 : init.
	 WORD	  CFLGM100    ; 2 : score up
	 WORD	  CFLGM200    ; 3 : castle flag up
	 WORD	  CFLGM400    ; 4 : wait
;
;
;*********************************************************************
;*	 Init.					   (CFLGM000)	     *
;*********************************************************************
CFLGM000 EQU	  $
	 LDY	  #05H
	 LDA	  PLYTM1
	 CMP	  #01H
	 BEQ	  CFLGM20     ;1patsu ?
;			      ;no
	 LDY	  #03H
	 CMP	  #03H
	 BEQ	  CFLGM20     ;3patsu ?
;			      ;no
	 LDY	  #00H
	 CMP	  #06H
	 BEQ	  CFLGM20     ;6patsu ?
;			      ;no
	 LDA	  #0FFH
CFLGM20	 EQU	  $
	 STA	  FRWCNT      ;fireworks count set
	 STY	  <ENSTAT,X
;
        LDA     2143H
        AND     #01111111B
        CMP     #4BH
        BEQ     CFLGM40
	LDA	#4BH
	STA	!SOUND3 ;<S!	;;T;;
;;;;;;;; LDA	  0FCH
;;;;;;;; ORA	  #20H
;;;;;;;; STA	  0FCH	      ;Sound set
;
CFLGM40	 EQU	  $
	 INC	  CSINFG
CFLGM60	 EQU	  $
	 RTS
CFLGM80 EQU	$
	LDA	#4CH
	STA	!SOUND3		;<S!	;;T;;
	STA	SVCKFG
	BRA	CFLGM40
;
;
;*********************************************************************
;*	 Score up				   (CFLGM100)	     *
;*********************************************************************
CFLGM100 EQU	  $
	 LDA	  TIMSCR+3
	 ORA	  TIMSCR+4
	 ORA	  TIMSCR+5
	 BEQ	  CFLGM80     ;end ?
;			      ;no
CFLGM120 EQU	  $
	 LDY	  #35
	 LDA	  #0FFH
	 STA	  WPOIN+5
	 JSR	  CAINC	      ;time dec.
;
	 LDA	  #05H
	 STA	  WPOIN+5     ;(+50)
CFLGM130 EQU	  $
	 LDY	  #11
	 LDA	  MRLGFG
	 BEQ	  CFLGM140    ;mario ?
;			      ;no
	 LDY	  #17
CFLGM140 EQU	  $
	 JSR	  CAINC	      ;player score up
;
	 LDA	  MRLGFG
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ORA	  #04H
	 JMP	  PLSCR20     ;score display
;
;
;*********************************************************************
;*	 Castle flag up				   (CFLGM200)	     *
;*********************************************************************
CFLGM200 EQU	  $
	LDA	#1
	STA	<OAMFG
	 LDA	  ENYPS1,X
	 CMP	  #72H
	 BCC	  CFLGM220    ;y-pos. up ?
;			      ;yes
	 DEC	  ENYPS1,X
	 BRA	  CFLGM240
;;;	    JMP	     CFLGM240
;
CFLGM220 EQU	  $
	 LDA	  FRWCNT
	 BEQ	  CFLGM300    ;end ?
;			      ;no
	 BMI	  CFLGM300    ;end ?
;			      ;no
	 LDA	  #FRW0
	 STA	  ENFALFG     ;fireworks set
;
CFLGM240 EQU	  $
	 JSR	  ENPSCV      ;oam address check
	 LDY	  !OAMEN,X
;
	 LDA	  ENOBJY
	 STA	  OAM2+1,Y	 ;y-pos. set
;
	LDA	<FMCNT
	AND	#00011000B
	LSR	A
	LSR	A
	CLC
	ADC	#4
	 STA	  OAM2+2,Y     ;character set
;
	 LDA	  #0BH
	 STA	  OAM2+3,Y     ;attribute set
;
	 LDA	  ENOBJX
	 STA	  OAM2+0,Y     ;x-pos. set
;
	LDA	#02
	STA	OAMSB2,Y
;
	 LDX	  <INDEX
	 RTS
;
CFLGM300 EQU	  $
	 JSR	  CFLGM240    ;castle flag display
;
	 LDA	  #06H
;;;;;;;; LDY	  FRWCNT
;;;;;;;; BPL	  CFLGM320    ;fierworks nothing ?
;;;;;;;;;		      ;yes
;;;;;;;; LDA	  #0AH
CFLGM320 EQU	  $
	 STA	  TMEL1,X     ;timer set
CFLGM340 EQU	  $
	 INC	  CSINFG
	 RTS
;
;*********************************************************************
;*	 Wait.					   (CFLGM400)	     *
;*********************************************************************
CFLGM400 EQU	  $
	 JSR	  CFLGM240    ;castle flag display
;
	 LDA	  TMEL1,X
	 BNE	  CFLGM445    ;timer = 0 ?
;			      ;yes
	 LDA	  7B1H
	 BEQ	  CFLGM340    ;sound end ?
;			      ;no
CFLGM445 EQU	$
CFLGM440 EQU	  $
	 RTS
;
;
;*********************************************************************
;*	 Flower enemy move			   (ENFWRMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ENFWRMV	 EQU	  $
	 LDA	  <ENSTAT,X
	 BNE	  EFWRM200    ;fail ?
;			      ;no.
	 LDA	  ETMS01,X
	 BNE	  EFWRM200    ;timer = 0 ?
;			      ;yes
	 LDA	  <FWRFLG2,X
	 BNE	  EFWRM100    ;start check ?
;			      ;yes
	 LDA	  <FWRFLG1,X
	 BMI	  EFWRM40     ;player check ?
;			      ;yes
	 JSR	  CRECMP
	 BPL	  EFWRM20     ;
;			      ;
	 LDA	  <WORK
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <WORK
EFWRM20	 EQU	  $
	 LDA	  <WORK
	 CMP	  #21H
	 BCC	  EFWRM200    ;start ok ?
;			      ;yes
EFWRM40	 EQU	  $
	 LDA	  <FWRFLG1,X
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <FWRFLG1,X   ;up,down flag set
	 INC	  <FWRFLG2,X   ;move flag on
EFWRM100 EQU	  $
	 LDA	  FWRFLG3,X
	 LDY	  <FWRFLG1,X
	 BPL	  EFWRM120    ;up move ?
;			      ;no
	 LDA	  FWRFLG4,X
EFWRM120 EQU	  $
	 STA	  <WORK	       ;(work) <-- y-pos. limit data
;
	 LDA	  <FMCNT
	 LSR	  A
	 BCC	  EFWRM200    ;move ?
;			      ;yes
	 LDA	  GMSTTM
	 BNE	  EFWRM200    ;move ok ?
;			      ;yes
	 LDA	  ENYPS1,X
	 CLC
	 ADC	  <FWRFLG1,X
	 STA	  ENYPS1,X    ;y-pos. move
	 CMP	  <WORK
	 BNE	  EFWRM200    ;limit ?
;			      ;yes
	 STZ	  <FWRFLG2,X   ;move flag off
;;;	    LDA	     #00H
;;;	    STA	     <FWRFLG2,X	  ;move flag off
	 LDA	  #40H
	 STA	  ETMS01,X    ;timer set
EFWRM200 EQU	  $
	 LDA	  #0H
	 STA	  ENOJBG,X    ;attribute set
	 RTS
;
;;;;;;
;;;;;;*********************************************************************
;;;;;;*	      Fly move sub				(EFMVSUB)	  *
;;;;;;*	      [in]     (x)	   <-- index				  *
;;;;;;*********************************************************************
;;;;;ANGLDT   EQU      $
;;;;;	      HEX      00,31,61,8E,B5,D4,EC,FB
;;;;;	      HEX      FF,FB,EC,D4,B5,8E,61,31
;;;;;;
;;;;;;
;;;;;EFMVSUB  EQU      $
;;;;;	      LDA      XSPEED
;;;;;	      STA      WORK
;;;;;	      LDA      WORK+5
;;;;;	      CLC
;;;;;	      ADC      MUKI,X
;;;;;	      AND      #1FH
;;;;;	      STA      WORK+7
;;;;;	      AND      #0FH
;;;;;	      TAY
;;;;;	      LDA      ANGLDT,Y
;;;;;	      LDY      ANGLCT1
;;;;;	      JSR      MUL88
;;;;;;
;;;;;	      LDA      WORK+7
;;;;;	      CMP      #10H
;;;;;	      BCS      EFMVS20
;;;;;;
;;;;;	      LDA      ENXPS2,X
;;;;;	      CLC
;;;;;	      ADC      WORK+2
;;;;;	      STA      ENXPS2,X
;;;;;	      LDA      ENXPS1,X
;;;;;	      ADC      WORK+3
;;;;;	      STA      ENXPS1,X
;;;;;	      LDA      ENXPS0,X
;;;;;	      ADC      #00H
;;;;;	      JMP      EFMVS40
;;;;;;
;;;;;EFMVS20  EQU      $
;;;;;	      LDA      ENXPS2,X
;;;;;	      SEC
;;;;;	      SBC      WORK+2
;;;;;	      STA      ENXPS2,X
;;;;;	      LDA      ENXPS1,X
;;;;;	      SBC      WORK+3
;;;;;	      STA      ENXPS1,X
;;;;;	      LDA      ENXPS0,X
;;;;;	      SBC      #00H
;;;;;EFMVS40  EQU      $
;;;;;	      STA      ENXPS0,X
;;;;;	      LDA      YSPEED
;;;;;	      STA      WORK
;;;;;	      LDA      WORK+7
;;;;;	      CLC
;;;;;	      ADC      #08H
;;;;;	      STA      WORK+7
;;;;;	      AND      #0FH
;;;;;	      TAY
;;;;;	      LDA      ANGLDT,Y
;;;;;	      LDY      ANGLCT2
;;;;;	      JSR      MUL88
;;;;;;
;;;;;	      LDA      WORK+7
;;;;;	      AND      #1FH
;;;;;	      CMP      #10H
;;;;;	      BCC      EFMVS60	   ;
;;;;;;				   ;
;;;;;	      LDA      ENYPS2,X
;;;;;	      CLC
;;;;;	      ADC      WORK+2
;;;;;	      STA      ENYPS2,X
;;;;;	      LDA      ENYPS1,X
;;;;;	      ADC      WORK+3
;;;;;	      STA      ENYPS1,X
;;;;;	      LDA      ENYPS0,X
;;;;;	      ADC      #00H
;;;;;	      STA      ENYPS0,X
;;;;;	      RTS
;;;;;;
;;;;;EFMVS60  EQU      $
;;;;;	      LDA      ENYPS2,X
;;;;;	      SEC
;;;;;	      SBC      WORK+2
;;;;;	      STA      ENYPS2,X
;;;;;	      LDA      ENYPS1,X
;;;;;	      SBC      WORK+3
;;;;;	      STA      ENYPS1,X
;;;;;	      LDA      ENYPS0,X
;;;;;	      SBC      #00H
;;;;;	      STA      ENYPS0,X
;;;;;	      RTS
;;;;;;
;
;*********************************************************************
;*	 Angle move compute			   (ANGLMV)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ANGLMV	 EQU	  $
	 STA	  <WORK+7      ;(work+7) <-- angle speed
;
	 LDA	  MUKI,X
AGLMV20	 EQU	  $
	 BNE	  AGLMV60     ;angle add. ?
;			      ;yes
AGLMV40	 EQU	  $
	 LDY	  #18H
	 LDA	  <AGLBUF,X
	 CLC
	 ADC	  <WORK+7
	 STA	  <AGLBUF,X
	 LDA	  <ANGLE,X
	 ADC	  #00H
	 RTS
;
AGLMV60	 EQU	  $
	 LDY	  #08H
	 LDA	  <AGLBUF,X
	 SEC
	 SBC	  <WORK+7
	 STA	  <AGLBUF,X
	 LDA	  <ANGLE,X
	 SBC	  #00H
	 RTS
;
;;;;;;
;;;;;;
;;;;;MUL88    EQU      $
;;;;;	      STA      WORK+1
;;;;;	      STY      WORK+6
;;;;;	      LDA      #0
;;;;;	      STA      2
;;;;;	      STA      3
;;;;;	      LDY      #8
;;;;;MUL10    EQU      $
;;;;;	      ASL      2
;;;;;	      ROL      3
;;;;;	      ASL      1
;;;;;	      BCC      MUL20
;;;;;;
;;;;;	      LDA      2
;;;;;	      CLC
;;;;;	      ADC      0
;;;;;	      STA      2
;;;;;	      BCC      MUL20
;;;;;	      INC      3
;;;;;MUL20    EQU      $
;;;;;	      DEY
;;;;;	      BNE      MUL10
;;;;;;
;;;;;	      LDY      6
;;;;;MUL30    EQU      $
;;;;;	      LSR      3
;;;;;	      ROR      2
;;;;;	      DEY
;;;;;	      BPL      MUL30
;;;;;	      RTS
;;;;;;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV0    [ Lift kind No.0 move process ]	     #
;#####################################################################
LFMOV0	 EQU	  $
	 LDA	  <ENYPS0,X
	 CMP	  #3		  ; Y pos clear ?
	 BNE	  LFM111
;
	 JMP	  ENCLER	  ; Clear
;
LFM111	 EQU	  $
	 LDA	  <ENSTAT,X
	 BPL	  LFM000	  ; Is this lift porected ?
	 RTS
;				  : No.
LFM000	 EQU	  $
	 TAY
;
	 LDA	  ONLFFG,X
	 STA	  <WORK
;
	 LDA	  <LFCTFG,X
	 BEQ	  LFM100
;
	 JMP	  LFDOWN
;
LFM100	 EQU	  $
	 LDA	  #2DH		  ; Up Max pos.
	 CMP	  ENYPS1,X
	 BCC	  LFM001	  ; Max ?
;
;	 LDA	  #01H		;
;	 STA	  YERFG		;
;	 LDA	  #2DH		;
	 CPY	  <WORK		   ; Yes !
	 BEQ	  LFM101
;
	 CLC
	 ADC	  #2
	 STA	  ENYPS1,X
	 JMP	  LFBLKE
LFM101	 EQU	  $
	 JMP	  LFMCUT
;
LFM001	 EQU	  $
	 CMP	  ENYPS1,Y
	 BCC	  LFM002
;
	 CPX	  <WORK
	 BEQ	  LFM101
;
	 CLC
	 ADC	  #2
	 STA	  ENYPS1,Y
	 JMP	  LFBLKE
;LFM202	  EQU	   $
;	  JMP	   LFMCUT
;
LFM002	 EQU	  $
;
	 LDA	  ENYPS1,X
	 PHA
;
	 LDA	  ONLFFG,X	  ; Is the player on the lift ?
	 BPL	  LFM010
;				  : No.
	 LDA	  ENYCL1,X
	 CLC
	 ADC	  #5
	 STA	  <WORK
;
	 LDA	  <ENYCL0,X	   ; FF,FA ~ ENYCLx ~ 00,05  ?
	 ADC	  #0
;;;;	 STA	  WORK+1
	 BMI	  LFDW
	 BNE	  LFUP
;
	 LDA	  <WORK
	 CMP	  #0BH
	 BCC	  LFSTOP	  ; Yes ! Lift stop (LFSTOP)
	 BCS	  LFUP
;
LFM010	 EQU	  $
	 CMP	  <INDEX	   ; On this lift ?
	 BEQ	  LFDW
;
LFUP	 EQU	  $		  ; No.	 (lift up)
	 JSR	  LFGCL1
	 JMP	  LFM020
;
LFSTOP	 EQU	  $
	 JSR	  LFBLKE
;
;;;;;;	 LDA	  #0
;;;;;;	 STA	  ENYCL0,X
;;;;;;	 STA	  ENYCL1,X
	 JMP	  LFM020
;
LFDW	 EQU	  $		  ; Yes. (Lift down)
	 JSR	  LFGCL0
LFM020	 EQU	  $
	 LDY	  <ENSTAT,X	   ; ** Yr==Index of the other lift **
	 PLA			  ; ** Before Ypos. pull **
	 SEC
	 SBC	  ENYPS1,X
	 CLC
	 ADC	  ENYPS1,Y	  ; Other lift Ypos + movedot
	 STA	  ENYPS1,Y
;
	 LDA	  ONLFFG,X
	 BMI	  LFMRET
	 TAX
	 JSR	  PLONLF	  ; Player position revise
LFMRET	 EQU	  $
;------- Lift Roup display ------ : No.
	 LDY	  <INDEX
;
;;;;	 LDA	  LFFHFG,X
;;;;	 BNE	  LFRETN	  : Out side ?
;				  : No.
	 LDA	  ENYCL0,Y	  ; Lift stop ?
	 ORA	  ENYCL1,Y
	 BNE	  LFRETN2	  ; Yes (RTS)
	 JMP	  LFRETN	  ; Yes (RTS)
LFRETN2	 EQU	  $
;
LFRETN3	 EQU	  $
;
	LDA	ENYCL0,Y		; Yes !
	PHA
	PHA
	PHA
	JSR	CALC
;
	LDA	<SCCH1
	LSR	A
	LSR	A
	LSR	A
	STA	<KWORK0
	LDA	<SCCH1+1
	AND	#01H
	ASL	A
	ASL	A
	ORA	#20H
	STA	<KWORK1
	LDA	<KWORK0
	CLC
	ADC	#1FH
	TAX
	AND	#1FH
	STA	<KWORK2
	TXA
	AND	#20H
	BEQ	NOTAS
	LDA	<KWORK1
	EOR	#04H
	STA	<KWORK3
NOTAS	EQU	$
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16 bit mode
;
	LDA	<WORK
	AND	#241FH
	CMP	<KWORK0
	BCS	NOHIM1
	CMP	<KWORK2
	BCC	NOHIM1
	JMP	NOHIM2
NOHIM1	EQU	$
;
	TYA
	AND	#00FFH
	TAY
	LDX	VRAMD
	LDA	<WORK			; BG. ( High,Low )
	AND	#1FFFH
	XBA
	STA	VRAMD+2,X
;
	LDA	#0300H
	STA	VRAMD+4,X
;
	LDA	ENYCL0,Y
	AND	#0080H
	BNE	CLC1
;
	LDA	VRAMD+2,X
	AND	#0F003H
	CMP	#0A000H
	BEQ	CAR0
	CMP	#0B000H
	BNE	HIMO1
CAR0	EQU	$
	LDA	#185CH
	BRA	CAR1
HIMO1	EQU	$
	LDA	#10A2H
;
CAR1	EQU	$
	STA	VRAMD+6,X
	LDA	#18A3H
	STA	VRAMD+8,X
	BRA	CLC2
;
CLC1	EQU	$
	LDA	#0024H
	STA	VRAMD+6,X
	STA	VRAMD+8,X
;
CLC2	EQU	$
	LDA	#0FFFFH
	STA	VRAMD+10,X		; End cord
;
	TXA
	CLC
	ADC	#0008H
	STA	VRAMD
;
NOHIM2	EQU	$
	MEM8
	IDX8
	SEP	#00110000B		; memory , index 8 bit mode
;
	LDA	ENSTAT,Y
	TAY
;
	PLA
	EOR	#0FFH
	JSR	CALC
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16 bit mode
;
	LDA	<WORK
	AND	#241FH
	CMP	<KWORK0
	BCS	NOHIM4
	CMP	<KWORK2
	BCC	NOHIM4
	JMP	NOHIM5
NOHIM4	EQU	$
;
	LDX	VRAMD
;
	LDA	<WORK
	AND	#1FFFH
	XBA
	STA	VRAMD+2,X
;
	LDA	#0300H
	STA	VRAMD+4,X
;
	PLA
	AND	#0080H
	BEQ	CLC3
;
	LDA	#10A2H
	STA	VRAMD+6,X
	LDA	VRAMD+2,X
	AND	#0F003H
	CMP	#0A000H
	BEQ	CAR2
	CMP	#0B000H
	BNE	HIMO2
CAR2	EQU	$
	LDA	#183FH
	BRA	CAR3
HIMO2	EQU	$
	LDA	#18A3H
;
CAR3	EQU	$
	STA	VRAMD+8,X
	BRA	CLC4
;
CLC3	EQU	$
	LDA	#0024H
	STA	VRAMD+6,X
	STA	VRAMD+8,X
;
CLC4	EQU	$
	LDA	#0FFFFH
	STA	VRAMD+10,X		; End cord
;
	TXA
	CLC
	ADC	#0008H
	STA	VRAMD			; Data su
	BRA	NOHIM6
;
NOHIM5	EQU	$
	PLA
NOHIM6	EQU	$
	MEM8
	IDX8
	SEP	#00110000B		; memory ,index 8 bit mode
;
LFRETN	EQU	$
	LDX	<INDEX
	RTS
;
;---- Obj address --> BG. address
CALC	 EQU	  $
	 PHA
;
	 LDA	  ENXPS1,Y
	 CLC
	 ADC	  #8
;
	 LDX	  ENLVFG
	 BNE	  LLLL		  ; Easy game ?
;
	 CLC			  ; Yes !
	 ADC	  #10H
LLLL	 EQU	  $
	 PHA
	 LDA	  ENXPS0,Y
	 ADC	  #0
	 STA	  <WORK+2
;
	 PLA
	 AND	  #11110000B
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 STA	  <WORK
;
	 LDX	  ENYPS1,Y
	 PLA
	 BPL	  CAL0
	 TXA
	 CLC
	 ADC	  #8
	 TAX
CAL0	 EQU	  $
	 TXA
;
	 ASL	  A
	 ROL	  A
	 PHA
	 ROL	  A
;
	 AND	  #00000011B
	 ORA	  #20H
	 STA	  <WORK+1
;
	 LDA	  <WORK+2
	 AND	  #00000001B
	 ASL	  A
	 ASL	  A
	 ORA	  <WORK+1
	 STA	  <WORK+1	   ; BG (H)
;
	 PLA
	 AND	  #11100000B
	 CLC
	 ADC	  <WORK
	 STA	  <WORK		   ; BG (L)
;
	 LDA	  ENYPS1,Y
	 CMP	  #0E8H		  ; Color elea ?
	 BCC	  CLRTS
;				  : Yes !
	 LDA	  <WORK		   ; Color elea protect
	 AND	  #10111111B
	 STA	  <WORK
CLRTS	 EQU	  $
	 RTS
;
LFMCUT	 EQU	  $
	 TYX
	 JSR	  ENFRCK
	 LDA	  #6		  ; 1000 pts
	 JSR	  SCRSET
;
	 LDA	  PLOBJX
	 STA	  SCOBJX,X
	 LDA	  PLYPS1
	 STA	  SCOBJY,X	  ; Player hed display
;
	 LDA	  #1
	 STA	  <LFCTFG,X	   ; Roup cut on
;
LFBLKE	 EQU	  $
;;;;;;	 LDA	  #0
;;;;;;	 STA	  ENYCL0,X
;;;;;;	 STA	  ENYCL1,X
	 JSR	  YCLCLR
	 STA	  ENYCL0,Y
	 STA	  ENYCL1,Y	  ; Speed Clear
	 RTS
;
LFDOWN	 EQU	  $
;;;;	 STX	  WORK+5
;
;;;;;	      TYA
;;;;;	      PHA
		PHY
	 JSR	  LFGCL2
;;;;;	      PLA
;;;;;	      TAX
		PLX
		LDA	<ENSTAT,X
		BPL	LFDWON20
;
	 JSR	  LFGCL2
LFDWON20	EQU	$
	 LDX	  <INDEX
;
	 LDA	  ONLFFG,X
	 BMI	  LFDRET
	 TAX
	 JSR	  PLONLF	  ; Player position revise
LFDRET	 EQU	  $
	 LDX	  <INDEX
	 RTS
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV1    [ Lift kind No.1 move process ]	     #
;#####################################################################
LFMOV1	 EQU	  $
	 LDA	  <ENYCL0,X
	 ORA	  ENYCL1,X
	 BNE	  LFM105
;
	 STA	  ENYPS2,X
;
	 LDA	  ENYPS1,X
	 CMP	  ENMAXY,X
	 BCS	  LFM105
;
	 LDA	  <FMCNT
	 AND	  #00000111B
	 BNE	  LFM106
	 INC	  ENYPS1,X
LFM106	 EQU	  $
	 BRA	  LFM120
;
LFM105	 EQU	  $
	 LDA	  ENYPS1,X
	 CMP	  <ENCTPS,X
	 BCC	  LFM110
;
	 JSR	  LFGCL1    ; Up.
	 JMP	  LFM120
;
LFM110	 EQU	  $
	 JSR	  LFGCL0    ; Down.
;
LFM120	 EQU	  $
	 LDA	  ONLFFG,X
	 BMI	  LFM0MM
	 JSR	  PLONLF    ; Plyaer position revise
LFM0MM	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV4    [ Lift No. 2 move process (swing)]	     #
;#####################################################################
LFMOV4	 EQU	  $
	 LDA	  #0EH		  ; Max Speed
	 JSR	  ENRLC2	  ; Right left Calclate
;
	 JSR	  RLMOVE	  ; (out) Wk;Move value
;
LFM200	 EQU	  $
	 LDA	  ONLFFG,X
	 BMI	  LFM210	  ; Player on lift ?
;
;<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>: Yes !
LFM201	 EQU	  $
	 LDA	  PLXPS1	  ; Player position. revise
	 CLC
	 ADC	  <WORK		   ; Wk ; Move value
	 STA	  PLXPS1
;
	 LDA	  <PLXPS0
	 LDY	  <WORK
	 BMI	  LFM205
;
	 ADC	  #0
	 BRA	  LFM208
;
LFM205	 EQU	  $
	 SBC	  #0
LFM208	 EQU	  $
	 STA	  <PLXPS0
	 STY	  LFXMVL	  ; Sclool Value
;
	 JSR	  PLONLF    ; Plyaer position revise
LFM210	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV5    [ On to down lift	]		     #
;#####################################################################
LFMOV5	 EQU	  $
	 LDA	  ONLFFG,X
	 BMI	  LFM510	  ; On lift ?
;				  : yes !
	 JSR	  LFGCLH	  ; Super Hi speed down
	 JSR	  PLONLF
LFM510	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV6    [ Remort controle lift ]		     #
;#####################################################################
LFMOV6	 EQU	  $
	 JSR	  ENCLX0	  ; H move
	 STA	  <WORK		   ;(Wk); Move value
;
	 LDA	  ONLFFG,X
	 BMI	  LFM610	  ; On lift ?
;
	 LDA	  #10H		  ; Yes !
	 STA	  <ENXSD0,X	   ; Move start
;
	 JSR	  LFM201
LFM610	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFMOV2    [ Up only lift move process ]	     #
;#	 JSR	  LFMOV3    [ Dw only lift move process ]	     #
;#####################################################################
LFMOV2	 EQU	  $
LFMOV3	 EQU	  $
	 JSR	  ELM010
	 JMP	  LFM120
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ELMOVE    [ Eleverter move process ]		     #
;#####################################################################
ELMOVE	 EQU	  $
	 JSR	  ELM010
	 BRA	  ELPLON
;
ELM010	 EQU	  $
	 LDA	  GMSTTM	  ;***********************************
	 BNE	  ELMMMM
;
	 LDA	  ENYPS2,X
	 CLC
	 ADC	  ENYSD1,X
	 STA	  ENYPS2,X
;
	 LDA	  ENYPS1,X
	 ADC	  <ENYSD0,X
	 STA	  ENYPS1,X
;
;;;;;;	 LDA	  ENYPS0,X
;;;;;;	 ADC	  ENYSD0,X
;;;;;;	 STA	  ENYPS0,X
	 RTS
;
ELPLON	 EQU	  $
	 LDA	  ONELFG,X
	 BEQ	  ELMMMM
	CMP	#0FFH
	BEQ	ELMMMM
	 JSR	  PLONEL
ELMMMM	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (Y) -- Clear Eria index			     #
;#		     (X) -- Index				     #
;#	 JSR	  ENGAWY    [ Enemy leave check ]		     #
;#####################################################################
CLPTR	 EQU	  048H	    ; Enemy Clear Check right limit data
CLPTL	 EQU	  048H	    ;	      "         left      "
;
ENGAWY	 EQU	  $
ENLDWY	 EQU	  $
	 LDA	  <ENMYNO,X
	 CMP	  #JFS0
	 BEQ	  ENGA90    ; Fish ? (Yes; No. cheack)
;;;;;	 CMP	  #ESHP
;;;;;	 BEQ	  ENGA90    : Fall kame enemy
;
	 LDA	  DSXP01    ;	 Wk+0,1	 DSX0	     DSX1   Wk+2,3
;;;;	 SEC		    :	    |	   |	       |      |
;
	 LDY	  <ENMYNO,X
	 CPY	  #FIEN	    ; Karugary
	 BEQ	  ENGA06
	 CPY	  #FLWR	    ; Flower
	 BNE	  ENGA01
ENGA06	 EQU	  $
	 ADC	  #38H	    ;		FIEN;10H
ENGA01	 EQU	  $	    ;		 |
	 SBC	  #CLPTL    ;	    |	 V |	       |      |
	 STA	  <WORK+1   ;  -----|------I-----------I------|----
	 LDA	  DSXP00    ; Clear | CLPTLII CLPTR| Clear
	 SBC	  #0	    ;	    |<----!I Display I<---->|
	 STA	  <WORK	    ; Area  |	   I Area  I      |	 Area
;			    :	    |	   II      |
	 LDA	  DSXP11    ;  -----|------I-----------I------|----
	 CLC
	 ADC	  #CLPTR
	 STA	  <WORK+3
	 LDA	  DSXP10
	 ADC	  #0
	 STA	  <WORK+2
;
	 LDA	  ENXPS1,X
	 CMP	  <WORK+1
	 LDA	  <ENXPS0,X
	 SBC	  <WORK
	 BMI	  ENGA10
;
	 LDA	  ENXPS1,X
	 CMP	  <WORK+3
	 LDA	  <ENXPS0,X
	 SBC	  <WORK+2
	 BMI	  ENGA90
;
	 LDA	  <ENSTAT,X
	 CMP	  #DROP	    ; Bakudan downinig ?     ;
	 BEQ	  ENGA90    ; Yes! No. Clear	     ;
;						     :	 No.
;;;;	 LDA	  ENMYNO,X			     :
	 CPY	  #FLWR				     ;	  Right check
	 BEQ	  ENGA90    ; Flower ?		     ;
;						     :
	 CPY	  #GFLG				     ;
	 BEQ	  ENGA90    ; Goul flag ?	     ;
;
	 CPY	  #CFLG				     ;
	 BEQ	  ENGA90    ; Castle flag ?	     ;
;			    : no
	 CPY	  #SPRG				     ;
	 BEQ	  ENGA90    ; Spring flag ?	     ;
;			    : no
ENGA10	 EQU	  $
;
;        CPY     #24H            ; LIFT_TEST
;        BNE     ENGA15
;        LDA     <ENSTAT,X
;        BMI     ENGA20
;        PHX
;        TAX
;        JSR     ENCLER
;        PLX
;ENGA15  EQU     $
	 JSR	  ENCLER    ; Enemy state clear
;
;;;;	 CPY	  #BMUS
;;;;	 BNE	  ENGA20    : Mush room ?
;			    : Yes !
;;;;	 JSR	  MSCLER    : Mush state flag clear
;
ENGA20	 EQU	  $
ENGA90	 EQU	  $
	 RTS
;
;---------------------------------------------------------------------------------------------------------------
	 END
