;
	include		mn_hp_smram.asm
;
	 ORG	  00C000H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1992.04.12	    V.1.0  Super Mario-CD
;				   File	 name : SMEND1
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMEND1 ==
		GLB	ENDCTR,MINCTR,FKMOVE,MROMOV,KISSDM
		GLB	PHCINT,MSHINT,PCHCNG,PCHMOV,PCHMV2
		GLB	PCHFIN,PCCLCN
		GLB	ENDCTR2,PHCSUB,PLCHCH
;
;=====================================================================
		EXT	GCALCY,M1SAVE,M2SAVE
		EXT	ENWIND
;
;=========================================================== SMEND1 ==
		EXT	GMEDSL
;
;=====================================================================
;
		EXTEND
		IDX8
		MEM8
;=====================================================================
;
;************************************************************************
;************************************************************************
;
;#####################################################################
;#		      Ar -- Set OAM count ( Ar x 2 )		     #
;#		  CHNOID -- Chara No. data index		     #
;#	 JSL	  PLOMST    [ Player OAM set ]			     #
;#####################################################################
;
PLCHCH	EQU	$
	LDA	!PLNOWR
	BNE	PLCSKP
	LDA	CHNOID
	CMP	#18H
	BEQ	PLCH20
	CMP	#78H
	BNE	PLCH30
PLCH20	EQU	$
	LDA	<FMCNT
	AND	#00000111B
	BNE	PLCH30
	LDA	!SOUND1
	BNE	PLCH30
	LDA	#4
	STA	!SOUND1
PLCH30	EQU	$
	STZ	PLCNFG
	LDA	CHNOID
	LSR	A
	LSR	A
	LSR	A
	INC	PLCNFG
	MEM16
	REP	#20H
	AND	#00FFH
	XBA
;
	CLC
	ADC	#8000H
	STA	PLYADR
;
	LDA	#6000H
	STA	WRTADR
	LDA	#0100H		;Tenso byte suu
	STA	PLYKAZ
	MEM8
	SEP	#20H
	LDA	MLFLG
	BEQ	PLCH10
	LDA	PLYADR+1
	ORA	#40H
	STA	PLYADR+1
PLCH10	EQU	$
	LDA	#0AH
	STA	PLYBNK
PLCSKP	EQU	$
	RTL
;
PHCSUB	EQU	$
	STZ	KINPCT
;
;	LDA	!ENXPS1
;	CLC
;	ADC	#8
;	STA	!ENXPS1
	LDA	#35H
	RTL
;
;************************************************************************
;	JSL	PCCLCN							*
;************************************************************************
PCCLCN		EQU	$
		MEM16
		REP	#20H
		LDX	#1EH
PCL100		EQU	$
		LDA	!MRLGFG
		BEQ	PCL150
		LDA	>PCCLD2,X
		BRA	PCL155
PCL150		EQU	$
		LDA	>PCCLDT,X
PCL155		EQU	$
		STA	!CGWORK+160H,X
		DEX
		DEX
		BPL	PCL100
		MEM8
		SEP	#20H
;
		INC	!CGVMAF
;
		JSR	MSGSET		; MESSAGE SET
;
		RTL
;
PCCLDT		EQU	$
		WORD	734EH,7FFFH,14A5H,5D68H,762EH,27BFH,31BBH,3ABFH
		WORD	0000H,152FH,355DH,525FH,169BH,1C9FH,0C19H,0C19H
;
PCCLD2		EQU	$
		WORD	734EH,7FFFH,14A5H,5588H,724DH,27BFH,31BBH,3ABFH
		WORD	0000H,152FH,355DH,525FH,169BH,3303H,1A40H,1C9FH
;
MSGSET		EQU	$
		PHB
		PHK
		PLB
		PHX
;
		LDA	#0FFH
		STA	!SCCH31
		STZ	!SCCH32		; SCROLL COUNTER CLEAR
		STZ	!KYINTM
;
		LDA	#15H
		STA	!WD212C
		LDA	#2
		STA	!WD212D
;
		IDX16
		REP	#10H
;
		LDA	!CORSNO
		PHA
		LDA	>WKGMNO
		BNE	MSG050
		LDA	!BSLFG
		BEQ	MSG050
		LDA	#0CH
		STA	!CORSNO
MSG050		EQU	$
		LDA	#0
		XBA
		LDA	!MRLGFG
		ASL	A
		ASL	A
		STA	<WORK
		LDA	!CORSNO
		AND	#00001000B
		LSR	A
		LSR	A
		ORA	<WORK
		TAY
		PLA
		STA	!CORSNO
		LDX	MSGDAT,Y
		TXY
		LDX	!VRAMD
MSG100		EQU	$
		LDA	MSGDT1,Y
		STA	!VRAMD+2,X
		INC	A
		BEQ	MSG200
		INX
		INY
		BRA	MSG100
MSG200		EQU	$
		STX	!VRAMD
;
		IDX8
		SEP	#10H
;
		PLX
		PLB
		RTS
;
MSGDAT		EQU	$
		WORD	MSGDT1-MSGDT1
		WORD	MSGDT2-MSGDT1
		WORD	MSGDT3-MSGDT1
		WORD	MSGDT4-MSGDT1
;
MSGDT1		EQU	$
		HEX	59,05,00,11
		WORD	201DH,2011H,200AH,2017H,2014H,2028H,2022H,2018H,201EH
		HEX	59,45,00,0B
		WORD	2016H,200AH,201BH,2012H,2018H,2026H
		HEX	59,85,00,15
		WORD	201DH,2011H,200EH,2028H,2014H,2012H,2017H,2010H,200DH,2018H,2016H
		HEX	59,C5,00,11
		WORD	2012H,201CH,2028H,201CH,200AH,201FH,200EH,200DH,2026H
		HEX	5A,05,00,0D
		WORD	2017H,2018H,2020H,2028H,201DH,201BH,2022H
		HEX	5A,45,00,0B
		WORD	200AH,2028H,2016H,2018H,201BH,200EH
		HEX	5A,85,00,11
		WORD	200DH,2012H,200FH,200FH,2012H,200CH,201EH,2015H,201DH
		HEX	5A,C5,00,0F
		WORD	201AH,201EH,200EH,201CH,201DH,2029H,2029H,2029H
		WORD	0FFFFH
;
MSGDT2		EQU	$
		HEX	59,05,00,11
		WORD	201DH,2011H,200AH,2017H,2014H,2028H,2022H,2018H,201EH
		HEX	59,45,00,11
		WORD	2016H,200AH,201BH,2012H,2018H,2028H,200FH,2018H,201BH
		HEX	59,85,00,11
		WORD	201BH,200EH,201CH,201DH,2018H,201BH,2012H,2017H,2010H
		HEX	59,C5,00,0F
		WORD	2019H,200EH,200AH,200CH,200EH,2028H,201DH,2018H
		HEX	5A,05,00,05
		WORD	2018H,201EH,201BH
		HEX	5A,45,00,0F
		WORD	2014H,2012H,2017H,2010H,200DH,2018H,2016H,2029H
		HEX	5A,85,00,11
		WORD	2011H,201EH,201BH,201BH,200AH,2011H,2028H,201DH,2018H
		HEX	5A,C5,00,11
		WORD	2018H,201EH,201BH,2028H,2011H,200EH,201BH,2018H,202BH
		HEX	5B,05,00,0B
		WORD	2016H,200AH,201BH,2012H,2018H,2026H
		WORD	0FFFFH
;
MSGDT3		EQU	$
		HEX	59,05,00,11
		WORD	201DH,2011H,200AH,2017H,2014H,2028H,2022H,2018H,201EH
		HEX	59,45,00,0B
		WORD	2015H,201EH,2012H,2010H,2012H,2026H
		HEX	59,85,00,15
		WORD	201DH,2011H,200EH,2028H,2014H,2012H,2017H,2010H,200DH,2018H,2016H
		HEX	59,C5,00,11
		WORD	2012H,201CH,2028H,201CH,200AH,201FH,200EH,200DH,2026H
		HEX	5A,05,00,0D
		WORD	2017H,2018H,2020H,2028H,201DH,201BH,2022H
		HEX	5A,45,00,0B
		WORD	200AH,2028H,2016H,2018H,201BH,200EH
		HEX	5A,85,00,11
		WORD	200DH,2012H,200FH,200FH,2012H,200CH,201EH,2015H,201DH
		HEX	5A,C5,00,0F
		WORD	201AH,201EH,200EH,201CH,201DH,2029H,2029H,2029H
		WORD	0FFFFH
;
MSGDT4		EQU	$
		HEX	59,05,00,11
		WORD	201DH,2011H,200AH,2017H,2014H,2028H,2022H,2018H,201EH
		HEX	59,45,00,11
		WORD	2015H,201EH,2012H,2010H,2012H,2028H,200FH,2018H,201BH
		HEX	59,85,00,11
		WORD	201BH,200EH,201CH,201DH,2018H,201BH,2012H,2017H,2010H
		HEX	59,C5,00,0F
		WORD	2019H,200EH,200AH,200CH,200EH,2028H,201DH,2018H
		HEX	5A,05,00,05
		WORD	2018H,201EH,201BH
		HEX	5A,45,00,0F
		WORD	2014H,2012H,2017H,2010H,200DH,2018H,2016H,2029H
		HEX	5A,85,00,11
		WORD	2011H,201EH,201BH,201BH,200AH,2011H,2028H,201DH,2018H
		HEX	5A,C5,00,11
		WORD	2018H,201EH,201BH,2028H,2011H,200EH,201BH,2018H,202BH
		HEX	5B,05,00,0B
		WORD	2015H,201EH,2012H,2010H,2012H,2026H
		WORD	0FFFFH
;
;
;
;************************************************************************
;	JSL	MROMOV
;************************************************************************
MROMOV		EQU	$
		PHX
;
		LDA	!EPMVCT
		BNE	MMV100
		LDA	>WKGMNO
		BEQ	MMV020
		LDA	!MRLGFG
MMV020		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ORA	!EPMVIX
		TAX
		INC	!EPMVIX
		LDA	!EPMVIX
		CMP	#03H
		BNE	MMV030
		LDA	#0FFH
		STA	YCALC0+1
		STZ	YCALC1+1
MMV030		EQU	$
		LDA	>MRMVDT,X
		BNE	MMV050
		INC	!GMMODE
		STZ	PLXSD1
		STZ	PLXSD0
MMV050		EQU	$
		STA	!EPMVCT
		LDA	>MRKYDT,X
		STA	!EPKYDT
MMV100		EQU	$
		DEC	!EPMVCT
		LDA	!EPKYDT
		AND	#00001000B
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WKEYUD
		LDY	!EPKYDT
;
		LDA	!SRSTFG
		BEQ	MMV300
		LDA	!PLXPS1
		CMP	#0A2H
		BCC	MMV300
		LDA	#0A2H
		STA	!PLXPS1
MMV300		EQU	$
;
		PLX
		RTL
;
MRMVDT		EQU	$
		HEX	18,A0,08,01,28,10,03,00
		HEX	10,A0,08,01,28,1E,02,00
;
MRKYDT		EQU	$
		HEX	01,00,41,C1,C9,01,01,00
		HEX	01,00,41,C1,C9,01,01,00
;
;************************************************************************
;	JSL	PCHMV2		(peach move routine)			*
;************************************************************************
PCHMV2		EQU	$
		DEC	!PCMVCT
		LDA	!PCMVCT
		BPL	PMV100
		INC	!PCHIDX
		LDX	!PCHIDX
		CPX	#5
		BNE	PMV101
		LDA	#0A0H
		STA	!PLXPS1
PMV101		EQU	$
		LDA	>PMFMDT,X
		STA	!PCMVCT
PMV100		EQU	$
		LDA	!PCHIDX
		ASL	A
		TAX
		LDA	>PCMTBL,X
		STA	<WORK
		LDA	>PCMTBL+1,X
		STA	<WORK1
		JMP	(WORK)
;
PCMTBL		EQU	$
		WORD	PMVPT0
		WORD	PMVPT1
		WORD	PMVPT1
		WORD	PMVPT2
		WORD	PMVPT3
		WORD	PMVPT0
		WORD	PMVPT0
;
;
PMVPT0		EQU	$
PMVPT1		EQU	$
		RTL
;
PMVPT3		EQU	$
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDA	#0
		LDX	#1
		JSL	>GCALCY
PMVPT2		EQU	$
		DEC	ENXPS1
		RTL
;
PMFMDT		EQU	$
		HEX	00,30,37,1A,10,60,FF
;
;************************************************************************
;	JSL	PCHMOV		(peach move routine)			*
;************************************************************************
PCHMOV		EQU	$
;
		PHX
;
		LDA	!ENOBJX
		CLC
		ADC	#7
		STA	OAM+0B0H
		STA	OAM+0B4H
		LDA	!ENOBJY
		STA	OAM+0B1H
		CLC
		ADC	#10H
		STA	OAM+0B5H
		LDX	!PCHIDX
		CPX	#03H
		BNE	PCST10
		LDA	<FMCNT
		AND	#00000100B
		BNE	PCST10
		LDA	>PCCHDT,X
		INC	A
		INC	A
		BRA	PCST20
PCST10		EQU	$
		LDA	>PCCHDT,X
PCST20		EQU	$
		STA	OAM+0B2H
		CLC
		ADC	#20H
		STA	OAM+0B6H
		LDA	#25H
		STA	OAM+0B3H
		STA	OAM+0B7H
;
		LDA	ENXPS1
		CLC
		ADC	#7
		SEC
		SBC	SCCH1
		LDA	ENXPS0
		SBC	SCCH1+1
		ORA	#02H
		STA	!OAMSB+0B0H
		STA	!OAMSB+0B4H
;
		LDX	!OAMSC
		LDA	!OAM+02,X
		CMP	#0F6H
		BNE	PCST30
		LDA	#0F0H
		STA	!OAM+01,X
		STA	!OAM+05,X
PCST30		EQU	$
		LDA	<ENMYNO+9
		BEQ	PCST80
		LDA	#1CH
		STA	!OAM+1E3H
		STA	!OAM+1E7H
		STA	!OAM+1EBH
		STA	!OAM+1EFH
;
		LDA	#80H
		STA	!OAM+1E2H
		INC	A
		STA	!OAM+1E6H
		LDA	#90H
		STA	!OAM+1EAH
		INC	A
		STA	!OAM+1EEH
PCST80		EQU	$
;
		PLX
		RTL
;
PCCHDT		EQU	$
		HEX	88,88,80,82,86,86,86
;
;************************************************************************
;	JSL	PCHCNG		(ending chr tensou)			*
;************************************************************************
PCHCNG		EQU	$
		LDA	!PCHCNT
		CMP	#0AH
		BCS	PCGFIN
		PHB
		PHK
		PLB
		PHX
;
		ASL	A
		TAX
		INC	!PCHCNT
;
		LDA	PCGBNK,X
		STA	!TSABNK
		MEM16
		REP	#20H
		LDA	#0800H
		STA	!TENKAZ
		LDA	PCGTMO,X
		STA	!TMOADR
		LDA	PCGTSA,X
		STA	!TSAADR
		MEM8
		SEP	#20H
		INC	!PASTEN
;
		PLX
		PLB
PCGFIN		EQU	$
		RTL
;
PCGBNK		EQU	$
		WORD	00008H,0002FH,0002FH,0002FH,0002FH,0002FH,0002FH,0001EH,0001EH,0001AH
;
PCGTSA		EQU	$
		WORD	0A000H,0D100H,0D800H,0E000H,0E800H,0F000H,0F800H,0D000H,0D800H,0E800H
;
PCGTMO		EQU	$
		WORD	03000H,06080H,06400H,06800H,06C00H,07000H,07400H,07800H,07C00H,00400H
;
;
;************************************************************************
;	JSL	PCHFIN		(ending chr tensou)			*
;************************************************************************
PCHFIN		EQU	$
		PHB
		PHK
		PLB
		PHX
;
		LDA	!PCHCNT
		ASL	A
		TAX
		INC	!PCHCNT
;
		LDA	PCFBNK,X
		STA	!TSABNK
		MEM16
		REP	#20H
		LDA	#0800H
		STA	!TENKAZ
		LDA	PCFTMO,X
		STA	!TMOADR
		LDA	PCFTSA,X
		STA	!TSAADR
		MEM8
		SEP	#20H
		INC	!PASTEN
;
		PLX
		PLB
		RTL
;
PCFBNK		EQU	$
		WORD	00008H,00007H,00007H,00007H,00007H,00007H,00007H,00007H,00007H,00007H
;
PCFTSA		EQU	$
		WORD	0A000H,08100H,08800H,09000H,09800H,0A000H,0A800H,0B000H,0B800H,0B800H
;
PCFTMO		EQU	$
		WORD	03000H,06080H,06400H,06800H,06C00H,07000H,07400H,07800H,07C00H,07C00H
;
;************************************************************************
;	JSL	MSHINT		(mashuroom initial)			*
;************************************************************************
MSHINT		EQU	$
		LDA	#2EH		; MASH
		STA	<ENMYNO+9
		LDA	#80H
		STA	<ENSTAT+9
		LDA	#1
		STA	<ENCMOD+9
		LDA	<PLXPS0
		STA	<ENXPS0+9
		LDA	PLXPS1
		STA	ENXPS1+9
		LDA	#1
		STA	ENYPS0+9
		LDA	#018H
		STA	ENYPS1+9
                STZ     !ENXSD0+9
                STZ     !MSFLFG                 ; mush-room init.
		RTL
;
;************************************************************************
;*	JSL	PHCINT		(world 8-4 clear initial)		*
;************************************************************************
PHCINT		EQU	$
		LDA	>WKGMNO		; MARIO-1 ?
		BEQ	PCI100		; YES
		LDA	!CORSNO
		CMP	#08H		; WORLD8?
		BCC	PCI200		; YES
;;;;;;;;;;;;;;;		       JSL     >M2SAVE	       ; MARIO-2 AUTO SAVE
		JMP	PCI200
PCI100		EQU	$
		LDA	!CORSNO
		PHA
		LDA	!GOALRM
		PHA
		LDA	!BSLFG
		BNE	PCI150
		STZ	!GOALRM
		STZ	!CORSNO
;;;;K;;;;		LDA	#1
;;;;K;;;;		STA	!BSLFG
PCI150		EQU	$
;;;;K;;;;		JSL	>M1SAVE		; MARIO-1 AUTO SAVE
		PLA
		STA	!GOALRM
		PLA
		STA	!CORSNO
PCI200		EQU	$
		LDA	#1
		STA	!PCHFLG		; BG SET ON FLG
		STZ	!PCHCNT		; CHR CHANGE COUNTER CLEAR
		STZ	!DEMDPT
;
		RTL
;
;************************************************************************
;*	JSL	KISSDM		(mario & peach kiss demo)		*
;************************************************************************
KISSDM		EQU	$
		LDA	>WKGMNO
		BEQ	KIS000
		JMP	KI2000
KIS000		EQU	$
		PHB
		PHK
		PLB
;
		JSL	>ENWIND			; en window buffer set
;
		LDX	!KISSMD
		LDA	!KISSCT
		CMP	KSFMDT,X		; KISS FLAM DATA
		BCC	KIS010
		STZ	!KISSCT
		INC	!KISSMD
		LDA	!KISSMD
		CMP	#08H
		BCC	KIS010
		BNE	KIS008
		STZ	!HATCNT
KIS008		EQU	$
		LDA	#08H
		STA	!KISSMD
KIS010		EQU	$
		INC	!KISSCT
		LDA	#0
		XBA
		LDA	!KISSMD
		ASL	A
		IDX16
		REP	#10H
		TAY
		LDX	KISMAD,Y
		STX	<WORKA
		LDX	KISSAD,Y
;
		LDY	#0004H
;
KIS100		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KIS150
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KIS120
		LDA	!MRLGFG
		STA	<WORK
KIS120		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KIS100
KIS150		EQU	$
		LDX	<WORKA
KIS200		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KIS250
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		CLC
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KIS220
		LDA	!MRLGFG
		STA	<WORK
KIS220		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KIS200
KIS250		EQU	$
;
		LDA	!KISSMD
		CMP	#08H
		BNE	KIS300
;
;;		LDX	!MRLGFG
;;		LDA	KEYA2,X
;;		ORA	KEYA2L,X
;;		AND	#11000000B
;;		BEQ	KIS260
;;		LDA	!CORSNO
;;		CMP	#0CH
;;		BEQ	KIS260
;;		INC	!GMMODE
;;KIS260		EQU	$
;;		LDA	!SCCH31
;;		BEQ	KIS261
;;		DEC	!SCCH31
;;KIS261		EQU	$
		IDX8
		SEP	#10H
		JSR	ENKYCK
;
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTXMDT,X
		CLC
		ADC	#0B0H
		STA	!OAM+00
		LDA	!HATCNT
		LSR	A
		LSR	A
		STA	<WORK
		LDA	#60H
		SEC
		SBC	<WORK
		STA	!OAM+01
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTCHDT,X
		STA	!OAM+02
		LDA	#26H
		STA	!OAM+03
		LDA	#0
		STA	!OAMSB
;
		INC	!HATCNT
		CPX	#03H
		BNE	KIS300
		STZ	!HATCNT
KIS300		EQU	$
;
		IDX8
		SEP	#10H
		JSR	LUIGCK
		PLB
		RTL
;
KI2000		EQU	$
		LDA	!CORSNO
		CMP	#08H
		BCC	KI2001
		JMP	KI3000
KI2001		EQU	$
		PHB
		PHK
		PLB
;
		JSL	>ENWIND			; en window buffer set
;
		LDX	!KISSMD
		LDA	!KISSCT
		CMP	KSFMD2,X		; KISS FLAM DATA
		BCC	KI2010
		STZ	!KISSCT
		INC	!KISSMD
		LDA	!KISSMD
		CMP	#05H
		BNE	KI2005
		STZ	!HATCNT
KI2005		EQU	$
		CMP	#0FH
		BCC	KI2010
		LDA	#06H
		STA	!KISSMD
KI2010		EQU	$
		INC	!KISSCT
		LDA	#0
		XBA
		LDA	!KISSMD
		ASL	A
		IDX16
		REP	#10H
		TAY
		LDX	KISMA2,Y
		STX	<WORKA
		LDX	KISSAD,Y
;
		LDY	#0004H
;
KI2100		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KI2150
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KI2120
		LDA	!MRLGFG
		STA	<WORK
KI2120		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KI2100
KI2150		EQU	$
		LDX	<WORKA
KI2200		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KI2250
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		CLC
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KI2220
		LDA	!MRLGFG
		STA	<WORK
KI2220		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KI2200
KI2250		EQU	$
;
		LDA	!KISSMD
		CMP	#06H
		BCC	KI2300
;
;;		LDX	!MRLGFG
;;		LDA	KEYA2,X
;;		ORA	KEYA2L,X
;;		AND	#11000000B
;;		BEQ	KI2260
;;		LDA	!CORSNO
;;		CMP	#0CH
;;		BEQ	KI2260
;;		INC	!GMMODE
;;KI2260		EQU	$
;;		LDA	!SCCH31
;;		BEQ	KI2261
;;		DEC	!SCCH31
;;KI2261		EQU	$
		IDX8
		SEP	#10H
		JSR	ENKYCK
;
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTXMDT,X
		CLC
		ADC	#0B0H
		STA	!OAM+00
		LDA	!HATCNT
		LSR	A
		LSR	A
		STA	<WORK
		LDA	#60H
		SEC
		SBC	<WORK
		STA	!OAM+01
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTCHDT,X
		STA	!OAM+02
		LDA	#26H
		STA	!OAM+03
		LDA	#0
		STA	!OAMSB
;
		INC	!HATCNT
		CPX	#03H
		BNE	KI2300
		STZ	!HATCNT
KI2300		EQU	$
;
		IDX8
		SEP	#10H
;
		JSR	LUIGCK
		PLB
		RTL
;
KI3000		EQU	$
		PHB
		PHK
		PLB
;
		JSL	>ENWIND			; en window buffer set
;
		LDX	!KISSMD
		LDA	!KISSCT
		CMP	KSFMD3,X		; KISS FLAM DATA
		BCC	KI3010
		STZ	!KISSCT
		INC	!KISSMD
		LDA	!KISSMD
		CMP	#09H
		BCC	KI3010
		BNE	KI3008
		STZ	!HATCNT
KI3008		EQU	$
		LDA	#09H
		STA	!KISSMD
KI3010		EQU	$
		INC	!KISSCT
		LDA	#0
		XBA
		LDA	!KISSMD
		ASL	A
		IDX16
		REP	#10H
		TAY
		LDX	KISMA3,Y
		STX	<WORKA
		LDX	KISSA3,Y
;
		LDY	#0004H
;
KI3100		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KI3150
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KI3120
		LDA	!MRLGFG
		STA	<WORK
KI3120		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KI3100
KI3150		EQU	$
		LDX	<WORKA
KI3200		EQU	$
		LDA	KISS00,X
		CMP	#0FFH
		BEQ	KI3250
		CLC
		ADC	#80H
		STA	!OAM+01,Y
		INX
		LDA	KISS00,X
		CLC
		ADC	#0C0H
		CLC
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		ADC	!MRLGFG
		STA	!OAM+00,Y
		INX
		LDA	KISS00,X
		STA	!OAM+02,Y
		INX
		STZ	<WORK
		CMP	#080H
		BCS	KI3220
		LDA	!MRLGFG
		STA	<WORK
KI3220		EQU	$
		LDA	KISS00,X
		ORA	<WORK
		ORA	#20H
		STA	!OAM+03,Y
		INX
;
		LDA	#02H
		STA	!OAMSB,Y
		INY
		INY
		INY
		INY
		BRA	KI3200
KI3250		EQU	$
;
		LDA	!KISSMD
		CMP	#09H
		BNE	KI3300
;
;;		LDX	!MRLGFG
;;		LDA	KEYA2,X
;;		ORA	KEYA2L,X
;;		AND	#11000000B
;;		BEQ	KI3260
;;		LDA	!CORSNO
;;		CMP	#0CH
;;		BEQ	KI3260
;;		INC	!GMMODE
;;KI3260		EQU	$
;;		LDA	!SCCH31
;;		BEQ	KI3261
;;		DEC	!SCCH31
;;KI3261		EQU	$
		IDX8
		SEP	#10H
		JSR	ENKYCK
;
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTXMDT,X
		CLC
		ADC	#0B0H
		STA	!OAM+00
		LDA	!HATCNT
		LSR	A
		LSR	A
		STA	<WORK
		LDA	#60H
		SEC
		SBC	<WORK
		STA	!OAM+01
		LDA	!HATCNT
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00000011B
		TAX
		LDA	>HTCHDT,X
		STA	!OAM+02
		LDA	#26H
		STA	!OAM+03
		LDA	#0
		STA	!OAMSB
;
		INC	!HATCNT
		CPX	#03H
		BNE	KI3300
		STZ	!HATCNT
KI3300		EQU	$
;
		IDX8
		SEP	#10H
		JSR	LUIGCK
;
		PLB
		RTL
;
LUIGCK		EQU	$
		LDA	!MRLGFG
		BEQ	LCK200
		LDA	!OAM+06H
		CMP	#0EEH
		BNE	LCK200
		LDA	!OAM+04H
		DEC	A
		DEC	A
		STA	!OAM+04H
		STA	!OAM+08H
		LDA	#82H
		STA	!OAM+06H
		INC	A
		STA	!OAM+0AH
		LDA	!OAM+04H
		CLC
		ADC	#08H
		STA	!OAM+08H
		LDA	#85H
		STA	!OAM+0EH
		LDA	#89H
		STA	!OAM+12H
LCK200		EQU	$
		RTS
;
;
HTCHDT		EQU	$
		HEX	5F,5E,5D,5C
;
HTXMDT		EQU	$
		HEX	00,02,00,FE
;
KSFMDT		EQU	$
		HEX	50,30,08,08,20,20,08,08,FF
;
KSFMD2		EQU	$
		HEX	50,30,08,08,20,20,08,08,0C,08,08,0C,08,08,0C,FF
;
KSFMD3		EQU	$
		HEX	60,08,08,10,14,10,14,10,14,FF
;
KISSAD		EQU	$
		WORD	KISP11-KISS00	; 00
		WORD	KISP12-KISS00	; 01
		WORD	KISP13-KISS00	; 02
		WORD	KISP14-KISS00	; 03
		WORD	KISP15-KISS00	; 04
		WORD	KISP16-KISS00	; 05
		WORD	KISP17-KISS00	; 06
		WORD	KISP18-KISS00	; 07
		WORD	KISP19-KISS00	; 08
		WORD	KISP19-KISS00	; 09
		WORD	KISP19-KISS00	; 0A
		WORD	KISP19-KISS00	; 0B
		WORD	KISP19-KISS00	; 0C
		WORD	KISP19-KISS00	; 0D
		WORD	KISP19-KISS00	; 0E
		WORD	KISP19-KISS00	; 0F
;
KISSA3		EQU	$
		WORD	KISP0B-KISS00	; 00
		WORD	KISP0E-KISS00	; 01
		WORD	KISP0F-KISS00	; 02
		WORD	KISP0C-KISS00	; 03
		WORD	KISP0D-KISS00	; 04
		WORD	KISP0C-KISS00	; 05
		WORD	KISP0D-KISS00	; 06
		WORD	KISP0C-KISS00	; 07
		WORD	KISP0D-KISS00	; 08
		WORD	KISP0C-KISS00	; 09
;
KISMAD		EQU	$
		WORD	KISM11-KISS00	; 00
		WORD	KISM12-KISS00	; 01
		WORD	KISM13-KISS00	; 02
		WORD	KISM14-KISS00	; 03
		WORD	KISM15-KISS00	; 04
		WORD	KISM16-KISS00	; 05
		WORD	KISM17-KISS00	; 06
		WORD	KISM18-KISS00	; 07
		WORD	KISM19-KISS00	; 08
;
KISMA2		EQU	$
		WORD	KISM11-KISS00	; 00
		WORD	KISM12-KISS00	; 01
		WORD	KISM13-KISS00	; 02
		WORD	KISM14-KISS00	; 03
		WORD	KISM15-KISS00	; 04
		WORD	KISM16-KISS00	; 05
		WORD	KISM1B-KISS00	; 06
		WORD	KISM1D-KISS00	; 07
		WORD	KISM1C-KISS00	; 08
		WORD	KISM1B-KISS00	; 09
		WORD	KISM1D-KISS00	; 0A
		WORD	KISM1C-KISS00	; 0B
		WORD	KISM1B-KISS00	; 0C
		WORD	KISM1D-KISS00	; 0D
		WORD	KISM1C-KISS00	; 0E
		WORD	KISM1A-KISS00	; 0F
;
KISMA3		EQU	$
		WORD	KISM0B-KISS00	; 00
		WORD	KISM0E-KISS00	; 01
		WORD	KISM0F-KISS00	; 02
		WORD	KISM0C-KISS00	; 03
		WORD	KISM0D-KISS00	; 04
		WORD	KISM0C-KISS00	; 05
		WORD	KISM0D-KISS00	; 06
		WORD	KISM0C-KISS00	; 07
		WORD	KISM0D-KISS00	; 08
		WORD	KISM0C-KISS00	; 09
;
KISS00		EQU	$
KISP11		EQU	$
		HEX	E8,EC,A0,06
		HEX	E8,FC,A2,06
		HEX	E8,0C,A4,06
		HEX	F8,EC,C0,06
		HEX	F8,FC,C2,06
		HEX	F8,0C,C4,06
		HEX	08,EC,E0,06
		HEX	08,FC,E2,06
		HEX	08,0C,E4,06
		HEX	10,CC,8D,06
		HEX	10,D4,8E,06
		HEX	10,E4,AC,06
		HEX	10,F4,AE,06
		HEX	18,F4,CC,06
		HEX	18,04,CE,06
		HEX	18,14,EC,06
		HEX	FF
;
KISM11		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP12		EQU	$
		HEX	E8,EC,A0,06
		HEX	E8,FC,A2,06
		HEX	E8,0C,A4,06
		HEX	F8,EC,C0,06
		HEX	F8,FC,C2,06
		HEX	F8,0C,C4,06
		HEX	08,EC,E0,06
		HEX	08,FC,E2,06
		HEX	08,0C,E4,06
		HEX	10,CC,8D,06
		HEX	10,D4,8E,06
		HEX	10,E4,AC,06
		HEX	10,F4,AE,06
		HEX	18,F4,CC,06
		HEX	18,04,CE,06
		HEX	18,14,EC,06
		HEX	FF
;
KISM12		EQU	$
		HEX	F0,D0,14,06
		HEX	F0,E0,16,06
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP13		EQU	$
		HEX	E8,EB,A0,06
		HEX	E8,FB,A2,06
		HEX	E8,0B,A4,06
		HEX	F8,EB,C0,06
		HEX	F8,FB,C2,06
		HEX	F8,0B,C4,06
		HEX	08,EB,E0,06
		HEX	08,FB,E2,06
		HEX	08,0B,E4,06
		HEX	10,CB,8D,06
		HEX	10,D3,8E,06
		HEX	10,E3,AC,06
		HEX	10,F3,AE,06
		HEX	18,F3,CC,06
		HEX	18,03,CE,06
		HEX	18,13,EC,06
		HEX	FF
;
KISM13		EQU	$
		HEX	F0,D0,14,06
		HEX	F0,E0,16,06
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP14		EQU	$
		HEX	00,D5,EE,06
		HEX	00,D5,EE,06
		HEX	10,DB,88,06
		HEX	10,E2,89,06
		HEX	E8,EA,A0,06
		HEX	E8,FA,A2,06
		HEX	E8,0A,A4,06
		HEX	F8,EA,C0,06
		HEX	F8,FA,C2,06
		HEX	F8,0A,C4,06
;;		HEX	00,D5,EE,06
		HEX	08,EA,E0,06
		HEX	08,FA,E2,06
		HEX	08,0A,E4,06
;;		HEX	10,DB,88,06
;;		HEX	10,E2,89,06
		HEX	10,F2,8B,06
		HEX	18,F2,CC,06
		HEX	18,02,CE,06
		HEX	18,12,EC,06
		HEX	FF
;
KISM14		EQU	$
		HEX	F0,D0,14,06
		HEX	F0,E0,16,06
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP15		EQU	$
		HEX	00,D4,EE,06
		HEX	00,D4,EE,06
		HEX	10,DA,88,06
		HEX	10,E1,89,06
		HEX	E8,E9,A0,06
		HEX	E8,F9,A2,06
		HEX	E8,09,A4,06
		HEX	F8,E9,C0,06
		HEX	F8,F9,C2,06
		HEX	F8,09,C4,06
;;		HEX	00,D4,EE,06
		HEX	08,E9,E0,06
		HEX	08,F9,E2,06
		HEX	08,09,E4,06
;;		HEX	10,DA,88,06
;;		HEX	10,E1,89,06
		HEX	10,F1,8B,06
		HEX	18,F1,CC,06
		HEX	18,01,CE,06
		HEX	18,11,EC,06
		HEX	FF
;
KISM15		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP16		EQU	$
		HEX	00,D3,EE,06
		HEX	00,D3,EE,06
		HEX	10,D9,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D3,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D9,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISM16		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP17		EQU	$
		HEX	00,D3,EE,06
		HEX	00,D3,EE,06
		HEX	10,D9,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D3,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D9,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISM17		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0E,06
		HEX	E8,E0,0E,46
		HEX	00,D0,3E,06
		HEX	00,E0,3E,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2E,06
		HEX	F8,E0,2E,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM1B		EQU	$		; M2 8-4
		HEX	F0,D0,42,06
		HEX	F0,E0,42,46
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,0C,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,2C,46
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,60,06
		HEX	00,E0,60,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP18		EQU	$
		HEX	00,D3,EE,06
		HEX	00,D3,EE,06
		HEX	10,D9,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D3,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D9,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISM18		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	00,D0,3C,06
		HEX	00,E0,3C,46
		HEX	E8,D0,0C,06
		HEX	E8,E0,0C,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,E0,2C,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM1D		EQU	$		;M2 8-4
		HEX	F0,D0,62,06
		HEX	F0,E0,62,46
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,0C,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,2C,46
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,60,06
		HEX	00,E0,60,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP19		EQU	$
		HEX	00,D3,EE,06
		HEX	00,D3,EE,06
		HEX	10,D9,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D3,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D9,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISM19		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,E0,0C,46
		HEX	00,D0,3C,06
		HEX	00,E0,3C,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,E0,2C,46
		HEX	F8,F0,48,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46	;
		HEX	08,F0,68,46	;
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM1C		EQU	$		;M2 8-4
		HEX	F0,D0,40,06
		HEX	F0,E0,40,46
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,0C,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,2C,46
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,60,06
		HEX	00,E0,60,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM1A		EQU	$		;M2 8-4
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,D0,2A,06
		HEX	E8,E0,0C,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F8,C0,48,06
		HEX	F8,D0,2C,06
		HEX	F8,D0,4A,06
		HEX	F8,E0,2C,46
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,60,06
		HEX	00,E0,60,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISP0B		EQU	$
		HEX	E8,EA,A0,06
		HEX	E8,FA,A2,06
		HEX	E8,0A,A4,06
		HEX	F8,EA,C0,06
		HEX	F8,FA,C2,06
		HEX	F8,0A,C4,06
		HEX	08,EA,E0,06
		HEX	08,FA,E2,06
		HEX	08,0A,E4,06
		HEX	10,CA,8D,06
		HEX	10,D2,8E,06
		HEX	10,E2,AC,06
		HEX	10,F2,AE,06
		HEX	18,F2,CC,06
		HEX	18,02,CE,06
		HEX	18,12,EC,06
		HEX	FF
;
KISP0C		EQU	$
		HEX	00,D2,EE,06
		HEX	00,D2,EE,06
		HEX	10,D8,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D2,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D8,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISP0D		EQU	$
		HEX	00,D2,EE,06
		HEX	00,D2,EE,06
		HEX	10,D8,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A0,06
		HEX	E8,F8,A2,06
		HEX	E8,08,A4,06
		HEX	F8,E8,C0,06
		HEX	F8,F8,C2,06
		HEX	F8,08,C4,06
;;		HEX	00,D2,EE,06
		HEX	08,E8,E0,06
		HEX	08,F8,E2,06
		HEX	08,08,E4,06
;;		HEX	10,D8,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISP0E		EQU	$
		HEX	00,D3,EE,06
		HEX	00,D3,EE,06
		HEX	10,D9,88,06
		HEX	10,E1,89,06
		HEX	E8,E9,A6,06
		HEX	E8,F9,A8,06
		HEX	E8,09,AA,06
		HEX	F8,E9,C6,06
		HEX	F8,F9,C8,06
		HEX	F8,09,CA,06
;;		HEX	00,D3,EE,06
		HEX	08,E9,E6,06
		HEX	08,F9,E8,06
		HEX	08,09,EA,06
;;		HEX	10,D9,88,06
;;		HEX	10,E1,89,06
		HEX	10,F1,8B,06
		HEX	18,F1,CC,06
		HEX	18,01,CE,06
		HEX	18,11,EC,06
		HEX	FF
;
KISP0F		EQU	$
		HEX	00,D2,EE,06
		HEX	00,D2,EE,06
		HEX	10,D8,88,06
		HEX	10,E0,89,06
		HEX	E8,E8,A6,06
		HEX	E8,F8,A8,06
		HEX	E8,08,AA,06
		HEX	F8,E8,C6,06
		HEX	F8,F8,C8,06
		HEX	F8,08,CA,06
;;		HEX	00,D2,EE,06
		HEX	08,E8,E6,06
		HEX	08,F8,E8,06
		HEX	08,08,EA,06
;;		HEX	10,D8,88,06
;;		HEX	10,E0,89,06
		HEX	10,F0,8B,06
		HEX	18,F0,CC,06
		HEX	18,00,CE,06
		HEX	18,10,EC,06
		HEX	FF
;
KISM0B		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,E0,34,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F0,E0,44,06
		HEX	F8,C0,48,06
		HEX	F8,F0,48,46
		HEX	00,D0,3C,06
		HEX	00,E0,64,06
		HEX	F8,D0,2C,06
		HEX	F8,E0,4A,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM0C		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	F0,E0,10,06
		HEX	E8,D0,36,06
		HEX	E8,E0,36,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F0,D0,46,06
		HEX	E8,C0,28,06
		HEX	F8,C0,48,06
		HEX	00,E0,12,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,66,06
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM0D		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	F0,E0,10,06
		HEX	E8,C0,28,06
		HEX	E8,D0,36,06
		HEX	E8,E0,36,46
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F0,D0,46,06
		HEX	F8,C0,48,06
		HEX	00,E0,12,06
		HEX	F8,E0,4A,46
		HEX	F8,F0,48,46
		HEX	00,D0,66,06
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM0E		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,E0,34,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F0,E0,44,06
		HEX	F8,C0,48,06
		HEX	F8,F0,48,46
		HEX	00,D0,3C,06
		HEX	00,E0,64,06
		HEX	F8,D0,2C,06
		HEX	F8,E0,4A,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
KISM0F		EQU	$
		HEX	D8,D0,0A,06
		HEX	D8,E0,08,06
		HEX	E8,C0,28,06
		HEX	E8,D0,0C,06
		HEX	E8,E0,34,06
		HEX	E8,E0,2A,46
		HEX	E8,F0,28,46
		HEX	F0,E0,44,06
		HEX	F8,C0,48,06
		HEX	F8,F0,48,46
		HEX	00,D0,3C,06
		HEX	00,E0,64,06
		HEX	F8,D0,2C,06
		HEX	F8,E0,4A,46
		HEX	08,C0,68,06
		HEX	08,D0,6A,06
		HEX	08,E0,6A,46
		HEX	08,F0,68,46
		HEX	18,C0,6E,46
		HEX	18,D0,6C,46
		HEX	18,E0,6C,06
		HEX	18,F0,6E,06
		HEX	FF
;
;************************************************************************
;*	JSL	ENDCTR		(ending kinopio chr chenge)		*
;************************************************************************
ENDCTR		EQU	$
		LDA	#1EH
		STA	!TSABNK
		MEM16
		REP	#20H
		LDA	#00800H
		STA	TENKAZ
		LDA	#07800H
		STA	TMOADR
		LDA	!CORSNO
		AND	#00FFH
		CMP	#07H
		BNE	ECTR10
		LDA	#0D000H
		BRA	ECTR20
ECTR10		EQU	$
		LDA	#0C000H
ECTR20		EQU	$
		STA	TSAADR
		MEM8
		SEP	#20H
;
		STZ	!ENTIM1
		STZ	!ENDFLG
		STZ	!KINCNT
		STZ	!KINTFG		; INITIAL FLG
;
		LDA	#2
		STA	PASTEN
		RTL
;
ENDCTR2		EQU	$
		PHX
		LDA	#1EH
		STA	!TSABNK
		MEM16
		REP	#20H
		LDA	#00800H
		STA	TENKAZ
		LDA	#07C00H
		STA	TMOADR
		LDA	!CORSNO
		AND	#00FFH
		ASL	A
		TAX
		LDA	>KIADRS,X
		STA	TSAADR
		MEM8
		SEP	#20H
;
		PLX
		RTL
;
MINCTR		EQU	$
;
	LDA	#10000000B		;inc mode
	STA	2115H
;
	MEM16
	REP	#20H
;
	LDA	#06000H
	STA	2116H			;VRAM address set
	LDA	#00000001B+(18H*100H)	;parameter & B bus address
	STA	4300H
	LDA	#8000H			;A bus address
	STA	4302H
	LDX	#07
	STX	4304H
	LDA	#4000H			;number of byte
	STA	4305H
	LDX	#00000001B		;DMA "ON"
	STX	420BH
;
		MEM8
		SEP	#20H
;
		RTL
;
KIADRS		EQU	$
		WORD	0C800H,0C800H,0C800H,0C800H
		WORD	0E800H,0E000H,0E000H,0D000H
		WORD	0C800H,0E800H,0E000H,0E000H
		WORD	0D000H,0D000H,0D000H,0D000H
;
;************************************************************************
;*	JSL	FKMOVE		(kinopio in fukuro move)		*
;************************************************************************
FKMOVE		EQU	$
		LDA	!ENDFLG
		BEQ	FKM050
		JMP	KIMOVE		; KINOPIO MOVE
FKM050		EQU	$
		LDA	<FMCNT
		AND	#00000111B
		BEQ	FKM110
		LDA	!ENTIM1
		BRA	FKM120
FKM110		EQU	$
		INC	!ENTIM1
		LDA	!ENTIM1
		CMP	#03H
		BCC	FKM120
		LDA	RND1
		EOR	RND1+1
		AND	#00000001B
		BNE	FKM115
		LDA	#3
		STA	!ENTIM1
		LDA	#1
		BRA	FKM120
FKM115		EQU	$
		LDA	#0
		STA	!ENTIM1
FKM120		EQU	$
		STA	<WORK
;
		LDA	<ENXPS0
		XBA
		LDA	!ENXPS1
		LDY	#0
		JSR	FKMSB1
;
		LDA	<ENXPS0
		XBA
		LDA	ENXPS1
		MEM16
		REP	#20H
		CLC
		ADC	#0008H
		MEM8
		SEP	#20H
		LDY	#4
		JSR	FKMSB1
;
		LDA	<WORK
		CMP	#02H
		BEQ	FKM300		; 3*3 PUT
		CMP	#0
		BNE	FKM200
		LDA	#83H
		BRA	FKM210
FKM200		EQU	$
		LDA	#80H
FKM210		EQU	$
		STA	!OAM2+02H
		INC	A
		STA	!OAM2+06H
		CLC
		ADC	#1FH
		STA	!OAM2+0AH
		INC	A
		STA	!OAM2+0EH
;
		LDA	#0B0H
		STA	!OAM2+01H
		STA	!OAM2+05H
		LDA	#0C0H
		STA	!OAM2+09H
		STA	!OAM2+0DH
;
		BRA	FKM400
;
FKM300		EQU	$
		LDA	#86H
;
		STA	!OAM2+02H
		INC	A
		STA	!OAM2+06H
		CLC
		ADC	#0FH
		STA	!OAM2+0AH
		INC	A
		STA	!OAM2+0EH
;
		LDA	#0B8H
		STA	!OAM2+01H
		STA	!OAM2+05H
		LDA	#0C0H
		STA	!OAM2+09H
		STA	!OAM2+0DH
;
FKM400		EQU	$
		RTL
;
KIMOVE		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
;
		LDA	!CORSNO
		ASL	A
		TAX
		LDA	!KINTFG
		BNE	KIM100
		JSR	KIINIT
KIM100		EQU	$
;
		LDA	KIJPDT,X
		STA	<WORK
		LDA	KIJPDT+1,X
		STA	<WORK1
		JMP	(WORK)
;
KIJPDT		EQU	$
		WORD	WORLD1	; 01
		WORD	WORLD2	; 02
		WORD	WORLD3	; 03
		WORD	WORLD4	; 04
		WORD	WORLD5	; 05
		WORD	WORLD6	; 06
		WORD	WORLD7	; 07
		WORD	WORLD1	; 08
		WORD	WORLD1	; 09
		WORD	WORLD5	; 0A
		WORD	WORLD6	; 0B
		WORD	WORLD7	; 0C
		WORD	WORLD1	; 0D
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; kinopio puturn change flame data
;
YUSNDT		EQU	$
		HEX	90,00
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; world 1 kinopio move routine
;
WORLD1		EQU	$
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR1000
		JMP	KIMRET
WR1000		EQU	$
		CMP	#03H
		BNE	WR1500
		LDA	!KINTIM
		BNE	WR1500
		JSR	JPCHEK		; JUMP SOUND CHECK
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	!ENYPS1
		CMP	#0B0H
		BCS	WR1200
		LDA	#1
		STA	!YUSNFG
		LDA	!ENYPS1
WR1200		EQU	$
		CMP	#0B8H
		BCC	WR1500
		LDA	#0B8H
		STA	!ENYPS1
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		LDA	#0
		STA	!KICHMD
		LDA	#18H
		STA	!KINTIM
		STZ	!JUMPFG
;
		JSR	PEASU
WR1500		EQU	$
		LDA	!KINTIM
		BNE	WR1510
		LDA	#1
		STA	!KICHMD
		BRA	WR1520
WR1510		EQU	$
		DEC	!KINTIM
WR1520		EQU	$
		LDA	!ENOBJX
		STA	<WORK
		LDA	!ENYPS1
		STA	<WORK1
		LDY	!YUSNFG
		LDA	YUSNDT,Y
		TAY
		LDA	!KICHMD
		JSR	KICS01
;
		JMP	KIMRET
;
WORLD2		EQU	$
;
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR2000
		JMP	KIMRET
WR2000		EQU	$
		CMP	#03H
		BNE	WR2510		; STOP
		LDA	!KINTIM
		BNE	WR2500		; STOP
		LDA	!KINTFG
		CMP	#2
		BNE	WR2100
		STA	!KICHMD
		BRA	WR2510
WR2100		EQU	$
		JSR	JPCHEK
		LDA	#1
		STA	!KICHMD
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	!ENYPS1
		CMP	#0B0H
		BCS	WR2200
		LDA	#1
		STA	!YUSNFG
		LDA	!ENYPS1
WR2200		EQU	$
		CMP	#0B8H
		BCC	WR2510
		LDA	#0B8H
		STA	!ENYPS1
		STZ	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		LDA	#28H
		STA	!KINTIM
		LDA	#2
		STA	!KINTFG
		LDA	#0
		STA	!KICHMD
WR2500		EQU	$
		DEC	!KINTIM
WR2510		EQU	$
		LDA	!ENOBJX
		STA	<WORK
		LDA	!ENYPS1
		STA	<WORK1
		LDY	!YUSNFG
		LDA	YUSNDT,Y
		TAY
		LDA	!KICHMD
		JSR	KICS01
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!ENOBJX
		CLC
		ADC	#10H
		STA	<WORK
		LDA	!KICHMD
		CMP	#2
		BNE	WR2530
;
		JSR	PEASU
		LDA	#3
WR2530		EQU	$
		JSR	KICS01
;
		JMP	KIMRET
;
WORLD3		EQU	$
;
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR3000
		JMP	KIMRET
WR3000		EQU	$
		CMP	#03H
		BEQ	WR3010
		JMP	WR3700
WR3010		EQU	$
		LDA	!KIPTCT
		CMP	#28H
		BCC	WR3600
		CMP	#50H
		BCC	WR3300
		CMP	#58H
		BCC	WR3200		; STOP 3NIN
;
		JSR	JPCHEK
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	#1
		STA	!KICHMD		; JUMP CHR SET
		LDA	!ENYPS1
		CMP	#0B0H
		BCS	WR3050
		LDA	#1
		STA	!YUSNFG		; KINOPIO MAE
		BRA	WR3100
WR3050		EQU	$
		CMP	#0B8H
		BCC	WR3100
		STZ	!YCALC0+1
		STZ	!YCALC1+1
		STZ	!YPOS2+1
		LDA	#0B8H
		STA	!ENYPS1
		STZ	!KICHMD		; STOP CHR SET
		LDA	#1H
		STA	!KINTIM		; KINOPIO TIMER
;
		JSR	PEASU
WR3100		EQU	$
		LDA	!KINTIM
		BNE	WR3200
		LDA	<FMCNT
		AND	#1
		BNE	WR3200
		INC	!ENXPS1+3	; TIMER
WR3200		EQU	$
		JSR	WR3200S
		JMP	KIMRET
;
WR3300		EQU	$
		LDY	#0A0H
		CMP	#2CH
		BCC	WR3500
		CMP	#30H
		BCC	WR3400
		JSR	WR3300S
		BRA	WR3600
WR3400		EQU	$
		JSR	WR3400S
		BRA	WR3600
WR3500		EQU	$
		JSR	WR3500S
;
WR3600		EQU	$
		INC	!KIPTCT		; KINOPIO PUTTERN COUNTER
WR3700		EQU	$
		LDA	!ENOBJX
		STA	<WORK
		LDA	!ENYPS1
		STA	<WORK1
		LDY	!YUSNFG
		LDA	YUSNDT,Y
		TAY
		LDA	!KICHMD
		JSR	KICS01
;
		JMP	KIMRET
;
WR3200S		EQU	$
		LDA	!ENOBJX
		STA	<WORK
		LDA	!ENYPS1
		STA	<WORK1
		LDY	!YUSNFG
		LDA	!YUSNDT,Y
		TAY
		LDA	!KICHMD
		JSR	KICS01
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!ENOBJX
		SEC
		SBC	!ENXPS1+3	; TIMER
		SEC
		SBC	#7
		STA	<WORK
		LDA	!KINTIM
		DEC	A
		BEQ	WR3210S
		LDA	#4
		CLC
		ADC	!KICHMD
WR3210S		EQU	$
		JSR	KICS01
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!ENOBJX
		CLC
		ADC	!ENXPS1+3	; TIMER
		CLC
		ADC	#7
		STA	<WORK
		LDA	!KINTIM
		DEC	A
		BEQ	WR3220S
		LDA	#6
		CLC
		ADC	!KICHMD
WR3220S		EQU	$
		JSR	KICS01
		LDA	!KIPTCT
		BMI	WR3230S
		INC	!KIPTCT
WR3230S		EQU	$
		RTS
;
WR3300S		EQU	$
		LDA	!ENYPS1
		INC	A
		STA	!OAM2+05H,Y
		STA	!OAM2+0DH,Y
		CLC
		ADC	#7
		STA	!OAM2+01H,Y
		STA	!OAM2+09H,Y
		LDA	!ENOBJX
		SEC
		SBC	#0DH
		STA	!OAM2+04,Y
		DEC	A
		STA	!OAM2+00,Y
		LDA	!ENOBJX
		CLC
		ADC	#0DH
		STA	!OAM2+0CH,Y
		INC	A
		STA	!OAM2+08H,Y
		LDA	#0E0H
		STA	!OAM2+06,Y
		STA	!OAM2+0EH,Y
		LDA	#0CEH
		STA	!OAM2+02,Y
		STA	!OAM2+0AH,Y
		LDA	#02DH
		STA	!OAM2+0BH,Y
		STA	!OAM2+0FH,Y
		LDA	#06DH
		STA	!OAM2+03H,Y
		STA	!OAM2+07H,Y
		LDA	#2
		STA	!OAMSB2,Y
		STA	!OAMSB2+4,Y
		STA	!OAMSB2+8,Y
		STA	!OAMSB2+12,Y
		RTS
;
WR3400S		EQU	$
		LDA	!ENOBJX
		SEC
		SBC	#9
		STA	!OAM2+00,Y
		LDA	!ENOBJX
		CLC
		ADC	#9
		STA	!OAM2+04,Y
		LDA	!ENYPS1
		INC	A
		STA	!OAM2+01,Y
		STA	!OAM2+05,Y
		LDA	#0E0H
		STA	!OAM2+02,Y
		STA	!OAM2+06,Y
		LDA	#6DH
		STA	!OAM2+03,Y
		LDA	#2DH
		STA	!OAM2+07,Y
		LDA	#2
		STA	!OAMSB2+00,Y
		STA	!OAMSB2+04,Y
		RTS
;
WR3500S		EQU	$
		LDA	!ENOBJX
		SEC
		SBC	#5
		STA	!OAM2+00,Y
		LDA	!ENOBJX
		CLC
		ADC	#5
		STA	!OAM2+04,Y
		LDA	!ENYPS1
		STA	!OAM2+01,Y
		STA	!OAM2+05,Y
		LDA	#0E0H
		STA	!OAM2+02,Y
		STA	!OAM2+06,Y
		LDA	#6DH
		STA	!OAM2+03,Y
		LDA	#2DH
		STA	!OAM2+07,Y
		LDA	#2
		STA	!OAMSB2+00,Y
		STA	!OAMSB2+04,Y
		RTS
;
WORLD4		EQU	$
;
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR4000
		JMP	KIMRET
WR4000		EQU	$
		INC	!KINTIM
		LDA	!KINTIM
		CMP	#0C0H
		BCC	WR4050
		LDA	#0C0H
		STA	!KINTIM
		LDA	#2
		STA	!KINTFG
		LDA	#1
		STA	!KPICNT
		STA	!KPICNT+1
		STA	!KPICNT+2
		STA	!KPICNT+3
WR4050		EQU	$
		STZ	!ENCLFG
		LDA	!KPIYPS
		BNE	WR4200
		LDA	!KINTFG
		CMP	#2
		BEQ	WR4100
		JSR	W4KDT1
		JMP	KIMRET
WR4100		EQU	$
		JSR	W4KDT2
;
		JMP	KIMRET
;
WR4200		EQU	$
		LDA	!KIPTNO
		BEQ	WR4210
		DEC	!KIPTNO
		LDA	#0
		BRA	WR4220
WR4210		EQU	$
		JSR	PEASU
WR4215		EQU	$
		LDA	#2
WR4220		EQU	$
		STA	!KICHMD
		LDX	#3
		LDY	#0
WR4300		EQU	$
		LDA	!KPIXPS,X
		STA	<WORK
		LDA	#0B8H
		STA	<WORK1
		LDA	!KICHMD
		JSR	KICS01
		TYA
		CLC
		ADC	#10H
		TAY
		STY	!ENCLFG
		DEX
		BPL	WR4300
		JMP	KIMRET
;
W4KDT2		EQU	$
		JSR	JPCHEK		; JUMP SOUND CHECK
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	!ENYPS1
		CMP	#0B0H
		BCS	W4S100
		LDA	#1
		STA	!YUSNFG
W4S100		EQU	$
		LDY	!YUSNFG
		LDA	!YUSNDT,Y
		TAY
		LDA	!ENOBJX
		STA	<WORK
		LDA	!ENYPS1
		CMP	#0B8H
		BCC	W4S110
		LDA	#0B8H
		STZ	!KPICNT
W4S110		EQU	$
		STA	<WORK1
		LDA	!KPICNT
		JSR	KICS01
;
		LDA	!KPIXPS+1
		STA	<WORK
		LDA	!ENYPS1
		SEC
		SBC	#0CH
		CMP	#0B8H
		BCC	W4S210
		LDA	#0B8H
		STZ	!KPICNT+1
		BRA	W4S215
W4S210		EQU	$
		LDA	<FMCNT
		LSR	A
		BCC	W4S213
		INC	!KPIXPS+1
W4S213		EQU	$
		LDA	!ENYPS1
		SEC
		SBC	#0CH
W4S215		EQU	$
		STA	<WORK1
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!KPICNT+1
		CLC
		ADC	#6
		JSR	KICS01
;
		LDA	!KPIXPS+2
		STA	<WORK
		LDA	!ENYPS1
		SEC
		SBC	#18H
		CMP	#0B8H
		BCC	W4S310
		LDA	#0B8H
		STZ	!KPICNT+2
		BRA	W4S315
W4S310		EQU	$
		DEC	!KPIXPS+2
W4S315		EQU	$
		STA	<WORK1
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!KPICNT+2
		CLC
		ADC	#4
		JSR	KICS01
;
		LDA	!KPIXPS+3
		STA	<WORK
		LDA	!ENYPS1
		SEC
		SBC	#24H
		CMP	#0B8H
		BCC	W4S410
		LDA	#0B8H
		STZ	!KPICNT+3
		INC	!KPIYPS		; WORK
		LDA	#28H
		STA	!KIPTNO		; WORK
		LDA	!ENYPS1
		SEC
		SBC	#24H
		BRA	W4S415
W4S410		EQU	$
		INC	!KPIXPS+3
W4S415		EQU	$
		STA	<WORK1
		TYA
		CLC
		ADC	#10H
		TAY
		LDA	!KPICNT+3
		CLC
		ADC	#6
		JSR	KICS01
;
		RTS
;
;
W4KDT1		EQU	$
		LDY	#0B0H
		LDX	#0
W4K100		EQU	$
		LDA	!ENOBJX
		STA	!OAM2+00,Y
		LDA	W4YCDT,X
		STA	!OAM2+01,Y
		LDA	W4YCDT+1,X
		STA	!OAM2+02,Y
		LDA	#2DH
		STA	!OAM2+03,Y
;
		LDA	#2
		STA	!OAMSB2+00,Y
;
		INY
		INY
		INY
		INY
		INX
		INX
		CPX	#12H
		BCC	W4K100
;
		LDA	#6DH
		STA	!OAM2+0C3H
		STZ	!OAMSB2+0C0H
		STZ	!OAMSB2+0BCH
		LDA	!OAM2+0BCH
		CLC
		ADC	#8
		STA	!OAM2+0C0H
;
		LDX	#0
W4K200		EQU	$
		LDA	W4FMDT,X
		CMP	!KINTIM
		BCS	W4K300
		INX
		CPX	#06H
		BNE	W4K200
W4K300		EQU	$
		TXA
		ASL	A
		TAX
		LDA	W4CRDT,X
		STA	<WORK
		LDA	W4CRDT+1,X
		STA	<WORK1
		LDA	#01H
		JMP	(WORK)
;
W4PT01		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0B4H	;U3
		STA	!OAMSB2+0B8H	;U2
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0CCH	;S3
		STA	!OAMSB2+0D0H	;S4
		RTS
;
W4PT02		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0B4H	;U3
		STA	!OAMSB2+0B8H	;U2
		STA	!OAMSB2+0CCH	;S3
		STA	!OAMSB2+0D0H	;S4
		LDA	#9
		STA	!SOUND0
		RTS
;
W4PT03		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0B4H	;U3
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0CCH	;S3
		STA	!OAMSB2+0D0H	;S4
		RTS
;
W4PT04		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0B4H	;U3
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0D0H	;S4
		LDA	#9
		STA	!SOUND0
		RTS
;
W4PT05		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0CCH	;S3
		STA	!OAMSB2+0D0H	;S4
		RTS
;
W4PT06		EQU	$
		STA	!OAMSB2+0B0H	;U4
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0CCH	;S3
		LDA	#9
		STA	!SOUND0
		RTS
;
W4PT07		EQU	$
		STA	!OAMSB2+0C8H	;S2
		STA	!OAMSB2+0CCH	;S3
		STA	!OAMSB2+0D0H	;S4
		RTS
;
W4CRDT		EQU	$
		WORD	W4PT01
		WORD	W4PT02
		WORD	W4PT03
		WORD	W4PT04
		WORD	W4PT05
		WORD	W4PT06
		WORD	W4PT07
;
W4FMDT		EQU	$
		HEX	40,48,58,60,70,78,BF
;
;
W4YCDT		EQU	$
		HEX	97,EA
		HEX	A2,EA
		HEX	AD,EA
		HEX	B8,B6	;
		HEX	B8,B6	;
		HEX	C0,C9	;
		HEX	B3,EA
		HEX	A8,EA
		HEX	9D,EA
;
;
WORLD5		EQU	$
;
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR5000
		JMP	KIMRET
WR5000		EQU	$
		JSR	JPCHEK		; JUMP SOUND CHECK
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	!ENYPS1
		CMP	#0A0H
		BCS	WR5050
		LDA	#1
		STA	!YUSNFG
WR5050		EQU	$
		LDA	!ENYPS1
		CMP	#0B0H
		BCC	WR5100
		LDA	#0B0H
		STA	!ENYPS1
		STZ	YCALC1+1
		STZ	YPOS2
		INC	!KICHMD
		LDA	!KICHMD
		BMI	WR5060
		LDA	#0
		STA	!KICHMD
WR5060		EQU	$
		STA	YCALC0+1
WR5100		EQU	$
		INC	!KINTIM
		LDA	!KINTIM
		CMP	#044H
		BCC	WR5200		; KURU KURU CHR SET
		BNE	WR5110
		LDA	#8
		STA	!SOUND0
WR5110		EQU	$
		LDA	#045H
		STA	!KINTIM
		JSR	W5KST2
;
		JSR	PEASU
		JMP	KIMRET
WR5200		EQU	$
		JSR	W5KST1
;
		JMP	KIMRET
;
W5KST2		EQU	$
		LDA	!ENOBJX
		CLC
		ADC	!KINTIM
		STA	<WORK
		CLC
		ADC	#6
		STA	!OAM2+00H
		CLC
		ADC	#10H
		STA	!OAM2+04H
;
		LDA	<WORK
		STA	!OAM2+10H
		STA	!OAM2+18H	;1
		CLC
		ADC	#8
		STA	!OAM2+14H
;
		LDA	<WORK
		CLC
		ADC	#1CH
		STA	!OAM2+20H
		STA	!OAM2+28H
		CLC
		ADC	#8
		STA	!OAM2+24H
;
		LDA	<WORK
		CLC
		ADC	#6
		STA	!OAM2+30H
		STA	!OAM2+38H
		CLC
		ADC	#8
		STA	!OAM2+34H
;
		LDA	<WORK
		CLC
		ADC	#16H
		STA	!OAM2+40H
		STA	!OAM2+48H
		CLC
		ADC	#8
		STA	!OAM2+44H
;
		LDA	#0B8H
		STA	!OAM2+11H
		STA	!OAM2+15H
		STA	!OAM2+21H
		STA	!OAM2+25H
		STA	!OAM2+31H
		STA	!OAM2+35H
		STA	!OAM2+41H
		STA	!OAM2+45H
		LDA	#0C0H
		STA	!OAM2+01H
		STA	!OAM2+05H
		STA	!OAM2+19H
		STA	!OAM2+29H
		STA	!OAM2+39H
		STA	!OAM2+49H
;
		LDA	#0BEH
		STA	!OAM2+12H	; 2,3
		STA	!OAM2+26H
		LDA	#0BFH
		STA	!OAM2+16H
		STA	!OAM2+22H
		LDA	#0ECH
		STA	!OAM2+1AH
		STA	!OAM2+2AH
		LDA	#0EAH
		STA	!OAM2+02H	; 1
		STA	!OAM2+06H
		LDA	#0B6H
		STA	!OAM2+32H	; 4,5
		STA	!OAM2+36H
		STA	!OAM2+42H
		STA	!OAM2+46H
		LDA	#0C9H
		STA	!OAM2+3AH
		STA	!OAM2+4AH
;
		LDA	#2DH
		STA	!OAM2+03H
		STA	!OAM2+13H
		STA	!OAM2+17H
		STA	!OAM2+1BH
		STA	!OAM2+33H
		STA	!OAM2+3BH
		STA	!OAM2+43H
		STA	!OAM2+4BH
		LDA	#6DH
		STA	!OAM2+07H
		STA	!OAM2+23H
		STA	!OAM2+27H
		STA	!OAM2+2BH
		STA	!OAM2+37H
		STA	!OAM2+47H
;
		LDA	#2
		STA	!OAMSB2+00H
		STA	!OAMSB2+04H
		STA	!OAMSB2+18H
		STA	!OAMSB2+28H
		STA	!OAMSB2+38H
		STA	!OAMSB2+48H
;
		LDX	#3
W5K110		EQU	$
		LDA	!KPICNT,X
		BEQ	W5K210
		CMP	#1EH
		BCC	W5K200
		STZ	!KPICNT,X
		BRA	W5K210
W5K200		EQU	$
		INC	!KPICNT,X
W5K210		EQU	$
		DEX
		BPL	W5K110
;
		LDA	<FMCNT
		AND	#00000111B
		BNE	W5K300
		LDX	#3
W5K230		EQU	$
		LDA	!KPICNT,X
		BEQ	W5K250
		DEX
		BNE	W5K230
W5K250		EQU	$
		LDA	<FMCNT
		AND	#00000011B
		TAY
		LDA	!RND1,Y
		EOR	<FMCNT
		AND	#00011111B
		CLC
		ADC	#0CCH
		STA	!KPIXPS,X
		LDA	!RND2,Y
		EOR	<FMCNT
		AND	#00000111B
		CLC
		ADC	#0B0H
		STA	!KPIYPS,X
		INC	!KPICNT,X
;
W5K300		EQU	$
		LDX	#3
W5K350		EQU	$
		LDA	!KPICNT,X
		LSR	A
		LSR	A
		LSR	A
		TAY
		LDA	PIYODT,Y
		STA	<WORK
		TXA
		ASL	A
		ASL	A
		TAY
		LDA	!KPIXPS,X
		STA	!OAM+00,Y
		LDA	!KPIYPS,X
		STA	!OAM+01,Y
		LDA	<WORK
		STA	!OAM+02,Y
		LDA	#25H
		STA	!OAM+03,Y
;
		DEX
		BPL	W5K350
;
		RTS
;
PIYODT		EQU	$
		HEX	F5,E4,F4,E5
;
W5KST1		EQU	$
		LDY	!YUSNFG
		LDA	YUSNDT,Y
		TAY
		LDA	!ENOBJX
		CLC
		ADC	!KINTIM
		STA	!OAM2+00H,Y
		STA	!OAM2+08H,Y
		CLC
		ADC	#10H
		STA	!OAM2+04H,Y
		STA	!OAM2+0CH,Y
;
		LDA	!ENYPS1
		STA	!OAM2+01H,Y
		STA	!OAM2+05H,Y
		CLC
		ADC	#10H
		STA	!OAM2+09H,Y
		STA	!OAM2+0DH,Y
;
		LDA	!KINTIM
		AND	#00001100B
		TAX
		LDA	#04
		STA	<WORK
W5K100		EQU	$
		LDA	KUCHDT,X
		STA	!OAM2+02H,Y
		LDA	KUATDT,X
		STA	!OAM2+03H,Y
		LDA	#2
		STA	!OAMSB2+00H,Y
		INY
		INY
		INY
		INY
		INX
		DEC	<WORK
		BNE	W5K100
;
		RTS
;
KUCHDT		EQU	$
		HEX	CE,CE,EE,EE
		HEX	E0,E2,E0,E2
		HEX	EE,EE,CE,CE
		HEX	E2,E0,E2,E0
KUATDT		EQU	$
		HEX	2D,4D,2D,4D
		HEX	2D,2D,AD,AD
		HEX	AD,CD,AD,CD
		HEX	4D,4D,CD,CD
;
WORLD6		EQU	$
;
		JSR	FUKUST		; fukuro set routine
;
		LDA	!KINCNT
		BNE	WR6000
		JMP	KIMRET
WR6000		EQU	$
		JSR	JPCHEK		; JUMP SOUND CHECK
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK1
		LDX	#1
		LDA	#0
		JSL	>GCALCY
		LDA	!ENYPS1
		CMP	#0A0H
		BCS	WR6010
		LDA	#1
		STA	!YUSNFG
WR6010		EQU	$
		LDA	!ENYPS1
		CMP	#0B8H
		BCC	WR6020
		LDA	#0B8H
		STA	!ENYPS1
		STZ	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		LDA	!JUMPFG
		CMP	#1
		BNE	WR6200
		LDA	#20H
		STA	!SOUND0
		STA	!JUMPFG
		BRA	WR6200
WR6020		EQU	$
		LDY	!YUSNFG
		LDA	YUSNDT,Y
		TAY
		LDA	YCALC0+1
;		BPL	WR6100
;		JSR	W6KST1
;		JMP	KIMRET
WR6100		EQU	$
		JSR	W6KST2
		JMP	KIMRET
;
WR6200		EQU	$
		LDA	!KINTFG
		CMP	#2
		BEQ	WR6210
		INC	!KINTFG
		LDA	!ENOBJX
		SEC
		SBC	#8
		STA	!ENOBJX
		LDA	!ENXPS1
		SEC
		SBC	#8
		STA	!ENXPS1
		STZ	<FMCNT
WR6210		EQU	$
		LDA	!KIPTCT
		BNE	WR6215
		INC	!KINTIM
		LDA	!KINTIM
		CMP	#40H
		BCC	WR6220
		LDA	#40H
		STA	!KINTIM
WR6215		EQU	$
		INC	!KIPTCT
		LDA	!KIPTCT
		CMP	#88H
		BCC	WR6220
		LDA	#88H
		STA	!KIPTCT
WR6220		EQU	$
		JSR	W6KST3
		JSR	PEASU
		JMP	KIMRET
;
;
W6KST1		EQU	$
		LDA	!ENOBJX
		STA	!OAM2+00H,Y
		STA	!OAM2+08H,Y
		CLC
		ADC	#10H
		STA	!OAM2+04H,Y
		STA	!OAM2+0CH,Y
		LDA	!ENYPS1
		STA	!OAM2+01H,Y
		STA	!OAM2+05H,Y
		CLC
		ADC	#10H
		STA	!OAM2+09H,Y
		STA	!OAM2+0DH,Y
		LDA	#0CEH
		STA	!OAM2+02H,Y
		STA	!OAM2+06H,Y
		STA	!OAM2+0AH,Y
		STA	!OAM2+0EH,Y
		LDA	#2DH
		STA	!OAM2+03H,Y
		LDA	#6DH
		STA	!OAM2+07H,Y
		LDA	#0ADH
		STA	!OAM2+0BH,Y
		LDA	#0CDH
		STA	!OAM2+0FH,Y
;
		LDA	#2
		STA	!OAMSB2+00H,Y
		STA	!OAMSB2+04H,Y
		STA	!OAMSB2+08H,Y
		STA	!OAMSB2+0CH,Y
		RTS
;
W6KST2		EQU	$
		LDA	!ENOBJX
		STA	!OAM2+00H,Y
		STA	!OAM2+08H,Y
		CLC
		ADC	#10H
		STA	!OAM2+04H,Y
		STA	!OAM2+0CH,Y
		LDA	!ENYPS1
		STA	!OAM2+09H,Y
		STA	!OAM2+0DH,Y
		CLC
		ADC	#08H
		STA	!OAM2+01H,Y
		STA	!OAM2+05H,Y
		LDA	#0CEH
		STA	!OAM2+0AH,Y
		STA	!OAM2+0EH,Y
		LDA	#0DEH
		STA	!OAM2+02H,Y
		STA	!OAM2+06H,Y
		LDA	#2DH
		STA	!OAM2+03H,Y
		STA	!OAM2+0BH,Y
		LDA	#06DH
		STA	!OAM2+07H,Y
		STA	!OAM2+0FH,Y
;
		LDA	#2
		STA	!OAMSB2+00H,Y
		STA	!OAMSB2+04H,Y
		STA	!OAMSB2+08H,Y
		STA	!OAMSB2+0CH,Y
		RTS
;
W6KST3		EQU	$
		LDA	!KINTIM
		SEC
		SBC	#28H
		BPL	W6K100
		LDA	#0
W6K100		EQU	$
		LSR	A
		LSR	A
		STA	<WORK
;
		LDA	!KIPTCT
		AND	#00001000B
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK1
		LDA	!ENOBJX
		CLC
		ADC	!KIPTCT
		CLC
		ADC	<WORK1
		STA	!OAM2+00H
		STA	!OAM2+10H
		CLC
		ADC	#10H
		SEC
		SBC	<WORK1
		STA	!OAM2+04H
		STA	!OAM2+14H
		CLC
		ADC	#10H
		SEC
		SBC	<WORK1
		STA	!OAM2+08H
		STA	!OAM2+18H
		LDA	!ENYPS1
		SEC
		SBC	<WORK
		CLC
		ADC	<WORK1
		STA	!OAM2+11H
		STA	!OAM2+15H
		STA	!OAM2+19H
		CLC
		ADC	#8
		STA	!OAM2+01H
		STA	!OAM2+05H
		STA	!OAM2+09H
		LDA	#0DEH
		STA	!OAM2+02H
		STA	!OAM2+0AH
		LDA	#0ECH
		STA	!OAM2+06H
		LDA	#0CEH
		STA	!OAM2+12H
		STA	!OAM2+1AH
		LDA	#0EAH
		STA	!OAM2+16H
		LDA	#2DH
		STA	!OAM2+03H
		STA	!OAM2+07H
		STA	!OAM2+13H
		STA	!OAM2+17H
		LDA	#6DH
		STA	!OAM2+0BH
		STA	!OAM2+1BH
;
		LDA	#2
		STA	!OAMSB2+00H
		STA	!OAMSB2+04H
		STA	!OAMSB2+08H
		STA	!OAMSB2+10H
		STA	!OAMSB2+14H
		STA	!OAMSB2+18H
;
		LDA	!ENOBJX
		CLC
		ADC	!KIPTCT
		INC	A
		INC	A
		STA	!OAM2+20H
		CLC
		ADC	#8
		STA	!OAM2+24H
		INC	A
		STA	!OAM2+28H
		CLC
		ADC	#8
		STA	!OAM2+2CH
		INC	A
		STA	!OAM2+30H
		CLC
		ADC	#8
		STA	!OAM2+34H
		INC	A
		STA	!OAM2+38H
		CLC
		ADC	#8
		STA	!OAM2+3CH
		LDA	#0C8H
		STA	!OAM2+21H
		STA	!OAM2+25H
		STA	!OAM2+29H
		STA	!OAM2+2DH
		STA	!OAM2+31H
		STA	!OAM2+35H
		STA	!OAM2+39H
		STA	!OAM2+3DH
;
		LDA	!KIPTCT
		AND	#00001111B
		CMP	#0FH
		BNE	W6SDSK
		LDA	#0EH
		STA	!SOUND0
W6SDSK		EQU	$
		LDA	!KIPTCT
		AND	#00001000B
		ASL	A
		ORA	#0CBH
		STA	!OAM2+22H
		STA	!OAM2+2AH
		STA	!OAM2+32H
		STA	!OAM2+3AH
		INC	A
		STA	!OAM2+26H
		STA	!OAM2+2EH
		STA	!OAM2+36H
		STA	!OAM2+3EH
;
		LDA	#02DH
		STA	!OAM2+23H
		STA	!OAM2+27H
		STA	!OAM2+2BH
		STA	!OAM2+2FH
		STA	!OAM2+33H
		STA	!OAM2+37H
		STA	!OAM2+3BH
		STA	!OAM2+3FH
;
		LDY	#0
W6K400		EQU	$
		LDA	!OAM2+00,Y
		CMP	#040H
		BCS	W6K500
		LDA	#0F0H
		STA	!OAM2+01,Y
W6K500		EQU	$
		INY
		INY
		INY
		INY
		BNE	W6K400
;
		RTS
;
;
WORLD7		EQU	$
WR7000		EQU	$
		INC	!KINCNT
		LDA	!KINCNT
		CMP	#0D0H
		BCC	WR7010
		JSR	PEASU
		LDA	#0D0H
		STA	!KINCNT
		JMP	WR7020
WR7010		EQU	$
		CMP	#20H
		BCC	WR7020
		PHA
		AND	#00001111B
		BNE	WR7015
		LDA	#0EH
		STA	!SOUND0
WR7015		EQU	$
		PLA
WR7020		EQU	$
		LSR	A
		LSR	A
		LSR	A
		CMP	#03H
		BCC	WR7050
		LDA	#3
WR7050		EQU	$
		PHA
		JSR	W7KST1
		PLA
		CMP	#02H
		BNE	WR7900
		LDA	!JUMPFG
		BNE	WR7900
		LDA	#2BH
		STA	!SOUND0
		STA	!JUMPFG
WR7900		EQU	$
		JMP	KIMRET
;
W7KST1		EQU	$
		ASL	A
		ASL	A
		ASL	A
		TAX
;
		LDY	#8
;
		LDA	#88H
		STA	!OAM2+00H,Y
		STA	!OAM2+08H,Y
		LDA	#90H
		STA	!OAM2+04H,Y
		LDA	#0B0H
		STA	!OAM2+01H,Y
		STA	!OAM2+05H,Y
		LDA	#0C0H
		STA	!OAM2+09H,Y
		LDA	#80H
		STA	!OAM2+02H,Y
		INC	A
		STA	!OAM2+06H,Y
		LDA	#0A0H
		STA	!OAM2+0AH,Y
		LDA	#2DH
		STA	!OAM2+03H,Y
		STA	!OAM2+07H,Y
		STA	!OAM2+0BH,Y
;
		LDY	#00H
;
W7K100		EQU	$
		LDA	FK7DAT,X
		STA	!OAM2+00,Y
		INY
		INX
		CPY	#08H
		BCC	W7K100
;
		LDA	#2
		STA	!OAMSB2+00H
		STA	!OAMSB2+04H
		STA	!OAMSB2+08H
		STA	!OAMSB2+0CH
		STA	!OAMSB2+10H
;
		LDA	#7EH
		CLC
		ADC	!KINCNT
		STA	!OAM2+1CH
		CMP	#88H
		BCS	W6K150
		LDA	#0F0H
		BRA	W6K160
W6K150		EQU	$
		LDA	#0C0H
W6K160		EQU	$
		STA	!OAM2+1DH
		LDA	<FMCNT
		LSR	A
		LSR	A
		AND	#00000010B
		STA	<WORK1
		CLC
		ADC	#0E6H
		STA	!OAM2+1EH
		LDA	#2DH
		STA	!OAM2+1FH
		LDA	#2
		STA	!OAMSB2+1CH
;
		LDY	#20H
		LDX	#6
		LDA	#78H
		CLC
		ADC	!KINCNT
		STA	<WORK
W7K200		EQU	$
		LDA	<WORK
		STA	!OAM2+00,Y
		STA	!OAM2+04,Y
		CMP	#91H
		BCS	W7K210
		LDA	#0F0H
		STA	!OAM2+01,Y
		STA	!OAM2+05,Y
		BRA	W7K220
W7K210		EQU	$
		LDA	#0C0H
		STA	!OAM2+01,Y
		LDA	#0C8H
		STA	!OAM2+05,Y
W7K220		EQU	$
		LDA	#0BAH
		CLC
		ADC	<WORK1
		STA	!OAM2+02,Y
		INC	A
		STA	!OAM2+06,Y
		LDA	#2DH
		STA	!OAM2+03,Y
		STA	!OAM2+07,Y
		INY
		INY
		INY
		INY
		INY
		INY
		INY
		INY
		LDA	<WORK
		SEC
		SBC	#0AH
		STA	<WORK
		DEX
		BNE	W7K200
;
		RTS
;
FK7DAT		EQU	$
		HEX	98,C0,E4,2D
		HEX	90,C0,A1,2D
		HEX	99,BF,E4,2D
		HEX	90,C0,A1,2D
		HEX	9B,BF,E2,2D
		HEX	90,C0,E0,2D
		HEX	90,C0,E0,2D
		HEX	90,C0,E0,2D
;
KIMRET		EQU	$
		LDA	!PECETM
		BEQ	PETM10
		BMI	PETM20
		DEC	!PECETM
		BRA	PETM20
PETM10		EQU	$
		LDA	!PTMFLG
		BNE	PETM20
		INC	!PTMFLG
		LDA	#0B8H
		STA	!PECECH
		LDA	!PLSIZE
		BNE	PETM20
		LDA	#0C8H
		STA	!PECECH
PETM20		EQU	$
;
		PLY
		PLX
		PLB
		RTL
;
;
;******************************************************
;	KINOPIO SET ROUTINE
;******************************************************
;
;	NORMAL KINOPIO SET
;
KICS01		EQU	$
		PHX
		STA	<WORK2
		ASL	A
		CLC
		ADC	<WORK2
		TAX
		LDA	<WORK		; XPOS
		STA	!OAM2+00,Y
		STA	!OAM2+08,Y
		CLC
		ADC	#8
		STA	!OAM2+04,Y
;
		LDA	<WORK1		; YPOS
		STA	!OAM2+01,Y
		STA	!OAM2+05,Y
		CLC
		ADC	#8
		STA	!OAM2+09,Y
;
		LDA	KICHDT,X	; CHR
		STA	!OAM2+02,Y
		LDA	KICHDT+1,X
		STA	!OAM2+06,Y
		LDA	KICHDT+2,X
		STA	!OAM2+0AH,Y
;
		LDA	KIATDT,X	; ATB
		STA	!OAM2+03,Y
		LDA	KIATDT+1,X
		STA	!OAM2+07,Y
		LDA	KIATDT+2,X
		STA	!OAM2+0BH,Y
;
		LDA	#2		; OAMSUB
		STA	!OAMSB2+8,Y
		PLX
		RTS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; KINOPIO CHR DATA
;
KICHDT		EQU	$
		HEX	B6,B6,C9	; STOP
		HEX	B7,B7,CB	; JUMP
		HEX	B8,B9,EC	; PEACE L
		HEX	B9,B8,EC	; PEACE R
		HEX	E3,E2,E4	; MUKI L
		HEX	F3,F2,E6	; JUMP L
		HEX	E2,E3,E4	; MUKI R
		HEX	F2,F3,E6	; JUMP R
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; KINOPIO ATB DATA
;
KIATDT		EQU	$
		HEX	2D,6D,2D	; STOP
		HEX	2D,6D,2D	; JUMP
		HEX	2D,2D,2D	; PEACE L
		HEX	6D,6D,6D	; PEACE R
		HEX	6D,6D,6D	; MUKI L
		HEX	6D,6D,6D	; JUMP L
		HEX	2D,2D,2D	; MUKI R
		HEX	2D,2D,2D	; JUMP R
;
;******************************************************
;	FUKURO SET ROUTINE
;******************************************************
FUKUST	EQU	$
	DEC	!ENTIM1
	LDA	!ENTIM1
	BPL	FKS050
	INC	!KINCNT
	LDA	#7
	STA	!ENTIM1
FKS050	EQU	$
	LDA	!KINCNT
	CMP	#03H
	BCC	FKS100
	LDA	#3
	STA	!KINCNT
FKS100	EQU	$
	PHX
	ASL	A
	TAX
	LDA	KIFKDT,X
	STA	<WORK
	LDA	KIFKDT+1,X
	STA	<WORK+1
	JMP	(WORK)
;
KIFKDT	EQU	$
	WORD	FKPT01
	WORD	FKPT02
	WORD	FKPT03
	WORD	FKPT04
;
;
FKPT01	EQU	$
	LDA	#94H
	STA	!OAM2+58H
	LDA	#0BBH
	STA	!OAM2+59H
	LDA	#0C0H
	STA	!OAM2+5AH
	LDA	#2DH
	STA	!OAM2+5BH
	LDA	#2
	STA	!OAMSB2+58H
;
	LDA	#88H
	STA	!OAM2+60H
	STA	!OAM2+70H
	LDA	#090H
	STA	!OAM2+64H
	STA	!OAM2+74H
	LDA	#0C0H
	STA	!OAM2+71H
	STA	!OAM2+75H
	LDA	#09CH
	STA	!OAM2+72H
	INC	A
	STA	!OAM2+76H
	LDA	#0B8H
	STA	!OAM2+61H
	STA	!OAM2+65H
	LDA	#08CH
	STA	!OAM2+62H
	INC	A
	STA	!OAM2+66H
	LDA	#2DH
	STA	!OAM2+73H
	STA	!OAM2+77H
	STA	!OAM2+63H
	STA	!OAM2+67H
	LDA	#02H
	STA	!OAMSB2+70H
	STA	!OAMSB2+74H
	STA	!OAMSB2+60H
	STA	!OAMSB2+64H
;
	PLX
	RTS
;
FKPT02	EQU	$
	LDA	#9AH
	STA	!OAM2+58H
	LDA	#0BEH
	STA	!OAM2+59H
	LDA	#0C2H
	STA	!OAM2+5AH
	LDA	#2DH
	STA	!OAM2+5BH
	LDA	#2
	STA	!OAMSB2+58H
	LDA	#88H
	STA	!OAM2+70H
	LDA	#90H
	STA	!OAM2+74H
	LDA	#0C0H
	STA	!OAM2+71H
	STA	!OAM2+75H
	LDA	#099H
	STA	!OAM2+72H
	INC	A
	STA	!OAM2+76H
	LDA	#2DH
	STA	!OAM2+73H
	STA	!OAM2+77H
	LDA	#02H
	STA	!OAMSB2+70H
	STA	!OAMSB2+74H
;
	PLX
	RTS
;
;
FKPT03	EQU	$
	LDA	#9CH
	STA	!OAM2+58H
	LDA	#0C1H
	STA	!OAM2+59H
	LDA	#0C4H
	STA	!OAM2+5AH
	LDA	#2DH
	STA	!OAM2+5BH
	LDA	#2
	STA	!OAMSB2+58H
FKPT04	EQU	$
	LDA	#88H
	STA	!OAM2+70H
	LDA	#90H
	STA	!OAM2+74H
	LDA	#0C0H
	STA	!OAM2+71H
	STA	!OAM2+75H
	LDA	#0C6H
	STA	!OAM2+72H
	INC	A
	STA	!OAM2+76H
	LDA	#2DH
	STA	!OAM2+73H
	STA	!OAM2+77H
	LDA	#02H
	STA	!OAMSB2+70H
	STA	!OAMSB2+74H
;
	PLX
	RTS
;
;******************************************************
;	KINOPIO INITIAL SET ROUTINE
;******************************************************
KIINIT		EQU	$
		LDA	#0FH
		STA	!SOUND0
		LDA	!PLSIZE
		EOR	#1
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	#0E0H
		CLC
		ADC	#8
		STA	!PECECH
;
		LDY	#9CH
		LDA	#0BH
		STA	<WORK1
		STZ	<WORK
		LDA	#0
RMCL10		EQU	$
		STA	(WORK),Y
		INY
		CPY	#0BFH
		BNE	RMCL10
		INC	!KINTFG		; INITIAL FIN
		DEC	!PECETM
;
		LDA	!CORSNO
		ASL	A
		TAX
		LDA	INTTBL,X
		STA	<WORK
		LDA	INTTBL+1,X
		STA	<WORK+1
		JMP	(WORK)
;
INTTBL		EQU	$
		WORD	INIT01
		WORD	INIT02
		WORD	INIT03
		WORD	INIT04
		WORD	INIT05
		WORD	INIT06
		WORD	INIT07
		WORD	INIT01
		WORD	INIT01
		WORD	INIT05
		WORD	INIT06
		WORD	INIT07
		WORD	INIT01
;
INIT01		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#4
		STA	!ENXPS1
		LDA	!ENOBJX
		SEC
		SBC	#4
		STA	!ENOBJX
		LDA	#8
		STA	!ENTIM1
;
		LDA	#1
		STA	!SOUND1
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		RTS
;
INIT02		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#0CH
		STA	!ENXPS1
		LDA	!ENOBJX
		SEC
		SBC	#0CH
		STA	!ENOBJX
		LDA	#8
		STA	!ENTIM1
;
		LDA	#1
		STA	!SOUND1
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		RTS
;
INIT03		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#4
		STA	!ENXPS1
		LDA	!ENOBJX
		SEC
		SBC	#4
		STA	!ENOBJX
		LDA	#8
		STA	!ENTIM1
		STZ	!ENXPS1+3
;
		LDA	#1
		STA	!SOUND1
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
;
		STZ	!KIPTCT		; KINOPIO PUTTERN COUNTER
;
		RTS
;
INIT04		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#4
		STA	!ENXPS1
		LDA	!ENOBJX
		SEC
		SBC	#4
		STA	!ENOBJX
		STA	!KPIXPS
		STA	!KPIXPS+1
		STA	!KPIXPS+2
		STA	!KPIXPS+3
		LDA	#1
		STA	!SOUND1
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		STZ	!ENCLFG
		RTS
;
INIT05		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#0CH
		STA	!ENXPS1
		LDA	!ENYPS1
		SEC
		SBC	#0CH
		STA	!ENYPS1
;
		LDA	#1
		STA	!SOUND1
		LDA	#0FEH
		STA	!KICHMD		; CALC WORK
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		RTS
;
INIT06		EQU	$
		LDA	!ENXPS1
		SEC
		SBC	#0CH
		STA	!ENXPS1
		LDA	#1
		STA	!SOUND1
		LDA	#0FDH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		RTS
;
INIT07		EQU	$
		STZ	!SOUND0
		LDA	#0FEH
		STA	YCALC0+1
		STZ	YCALC1+1
		STZ	YPOS2+1
		RTS
;
;
;******************************************************
;	FUKURO CHR SET SUBROUTINE
;******************************************************
FKMSB1		EQU	$
		MEM16
		REP	#20H
		SEC
		SBC	#0008H
		SEC
		SBC	!SCCH1
		STA	<WORK1
		MEM8
		SEP	#20H
;
		STA	!OAM2+00H,Y
		STA	!OAM2+08H,Y
;
		LDA	#2DH
		STA	!OAM2+03H,Y
		STA	!OAM2+0BH,Y
		XBA
		CMP	#0
		BEQ	FKS200
		LDA	#1
FKS200		EQU	$
		ORA	#02H
		STA	!OAMSB2,Y
		STA	!OAMSB2+08,Y
		RTS
;
PEASU		EQU	$
		LDA	!PECECH
		CMP	#0D0H
		BCC	WRPCH
		AND	#00001000B
		BEQ	WRPCH
		LDA	!PECECH
		SEC
		SBC	#08H
		STA	!PECECH
		LDA	#30H
		STA	!PECETM
WRPCH		EQU	$
		RTS
;
ENKYCK		EQU	$		; ENDING KEY CHECK
		LDA	!SCCH31
		BEQ	EKC200
		DEC	!SCCH31
		RTS
EKC200		EQU	$
		LDA	!KYINTM
		CMP	#0C0H
		BCS	EKC300
		INC	!KYINTM
		LDA	!KYINTM
		CMP	#0C0H
		BNE	EKC299			; "push start" set ?
;						; yes
		JSR	PUSH_SET
EKC299		EQU	$
		RTS
;
EKC300		EQU	$
		JSL	>GMEDSL
;;;;		LDA	>WKGMNO
;;;;		BNE	EKC310
;;;;		LDX	!MRLGFG
;;;;		LDA	KEYA2,X
;;;;		BRA	EKC320
;;;;EKC310		EQU	$
;;;;		LDA	KEYA2
;;;;EKC320		EQU	$
;;;;		AND	#11000000B
;;;;		BEQ	EKC100
;;;;		LDA	!CORSNO
;;;;		CMP	#0CH
;;;;		BEQ	EKC100
;;;;		LDA	>WKGMNO
;;;;		BEQ	EKC100
;;;;		INC	!GMMODE
;;;;EKC100		EQU	$
		RTS
;
JPCHEK		EQU	$
		LDA	!JUMPFG
		BNE	WR3025
		LDA	#1
		STA	!SOUND1
		STA	!JUMPFG
WR3025		EQU	$
		RTS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PUSH_SET	EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		PHD				; (D) push
		LDA	#VRAMD&0FF00H
		TCD				; (D) <-- #VRAMD&0FF00H
;
		LDA	#0F15AH
		STA	<VRAMD+2+0
		LDA	#01300H
		STA	<VRAMD+2+2
;
		LDA	#00019H
		STA	<VRAMD+2+4
		LDA	#0001EH
		STA	<VRAMD+2+6
		LDA	#0001CH
		STA	<VRAMD+2+8
		LDA	#00011H
		STA	<VRAMD+2+10
		LDA	#00028H
		STA	<VRAMD+2+12
		LDA	#0001CH
		STA	<VRAMD+2+14
		LDA	#0001DH
		STA	<VRAMD+2+16
		LDA	#0000AH
		STA	<VRAMD+2+18
		LDA	#0001BH
		STA	<VRAMD+2+20
		LDA	#0001DH
		STA	<VRAMD+2+22
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#0FFH
		STA	<VRAMD+2+24
;
		PLD				; (D) pull
;
		LDA	#015H
		STA	!SOUND3
		RTS
;
;
;
;
;
		END
;
