;
	include		mn_hp_smram.asm
;
	 ORG	 0D9968H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1992. 8.17	    V.1.0  Super Mario 2
;				   File	 name : SMENDING
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMENDING =
	 GLB	  MSG9WL,GSMSGE,GSSCUP,GSPAS
	 GLB	  GSENDZ1
;
;=========================================================== SMMAIN ==
	 EXT	  JSRSUB,CFLGM130,OAMCL1,GSED20,SCHEG,GMTITL
	 EXT	  GVCGST,SCBGS0,SCBGS1,CRGNS1,CLSET1
	 EXT	  GVMOD,DEFA,GVBG,W9M1,W9M2
;=========================================================== SMPLAY ==
	 EXT	  DSXPCR,MOZAIK
;=========================================================== SMFRDT ==
	 EXT	  FRDAST,RDCRDT
;=========================================================== SMENMY ==
	 EXT	  GIAL,CLFDOT
;
	 EXT	  ENCSET
;=====================================================================
;
	 GLB	  GMOVSEL,MLSLS20
	 GLB	  GOWIT1,GOWIT2
	GLB	GOSEL20
;
;=========================================================== mario_main ==
	 EXT	  M2SAVE,PS_RESET
;=========================================================== SMMAIN ==
	 EXT	  JSRSUB,OAMCL0
;
	 EXT	  ERPT,CGRS
;=========================================================== SMINIT ==
	 EXT	  GMOVSB,GMOS50,TLBGOT,RDCRDT
;=========================================================== SMPLAY ==
	 EXT	  GPWRD0,SLPPNT
;=========================================================== SMFRDT2 =
	 EXT	  URAINIT
;=========================================================== SMENDING =
;=====================================================================
		EXT	ROM_ERROR
;=====================================================================
		EXTEND
		MEM8
		IDX8
;
;
;
;
;*********************************************************************
;*	 Wait - 1				   (GOWIT1)	     *
;*********************************************************************
GOWIT1	 EQU	  $
	 LDA	  #10H
	 STA	  GTNXTM	  ;wait time set
	 BNE	  GMIT85
;
;
;*********************************************************************
;*	 Wait - 2				   (GOWIT2)	     *
;*********************************************************************
GOWIT2	 EQU	  $
	 LDA	  GTNXTM
	 BEQ	  GMIT85	  ;timer = 0 ?
;				  ;no
	 RTS
;
GMIT85	EQU	$
	INC	GMMODE
	RTS
;
;*********************************************************************
;*	 Game over select sub.			   (GMOVSEL)	     *
;*********************************************************************
SELECT	 EQU	  00100000B
START	 EQU	  00010000B
;
GMCRDT1	 EQU	  $		  ;corsol data
	 HEX	  42,73,0C,2B
;
GMCRDT2	 EQU	  $		  ;corsol y-pos. data
	 HEX	  63,73,83
;
;
GMOVSEL	 EQU	  $
;
	LDA	KEYA2
	AND	#00001100B
	BEQ	GOSEL10		;up or down key push ?
;				;yes
	LDY	#1
	STY	!SOUND3		;key in sound set
	LDY	SELFLG
	AND	#00001000B
	BEQ	GOSEL03		;up key ?
;				;yes
	DEY
	BPL	GOSEL08		;max up ?
;				;yes
	INY			;mode 0
	BRA	GOSEL05
GOSEL03 EQU	$		;down key
	INY
	CPY	#003H
	BNE	GOSEL08		;max down ?
;				;yes
	DEY			;mode 2
GOSEL05 EQU	$
	STZ	!SOUND3		;sound off
GOSEL08 EQU	$
	STY	SELFLG		;mode set
GOSEL10 EQU	$
	LDA	!PSWAIT
	BNE	GOSEL60
	 LDA	  KEYA2
	 AND	  #00010000B
	 BNE	  GOSEL6X	  ;start ?
;				  ;no
	 LDA	  KEYA2
	 AND	  #20H
	 BEQ	  GOSEL20	  ;select ?
;				  ;yes
	LDA	#1
	STA	!SOUND3
;
	 INC	  SELFLG
	 LDA	  SELFLG
	 CMP	  #003H
	 BNE	  GOSEL20
;
	 STZ	  SELFLG
GOSEL20	 EQU	  $
;;;;	LDA	CORSNO
;;;;	CMP	#08H
;;;;	BNE	GOSEL00
;;;;	RTS
GOSEL00 EQU	$
	 LDA	  !SOUND3
	 BEQ	  GOSEL25	;key move ?
;				;no
	STZ	!PASTIM
GOSEL25	 EQU	  $
	 INC	  PASTIM
	 LDA	  PASTIM
	 AND	  #00010000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	ORA	#02H
	STA	!OAMSB
	 LDY	  #03H
GOSEL40	 EQU	  $
	 LDA	  GMCRDT1,Y
	 STA	  OAM,Y
	 DEY
	 BPL	  GOSEL40	  ;oam set end ?
;				  ;yes
	 LDY	  SELFLG
	 LDA	  GMCRDT2,Y
	 STA	  OAM+1		    ;y-pos. set
	 RTS
;
GOSEL6X EQU	$
	LDA	#20H
	STA	!PSWAIT
	LDA	#43H
	STA	!SOUND0
	LDA	#0F3H
	STA	!SOUND2
	LDA	SELFLG
	BEQ	GOSEL60			; save ?
;					; yes
	LDA	#3BH
	STA	!SOUND0
GOSEL60	 EQU	  $
	JSR	GOSEL25		;corsol set
	DEC	!PSWAIT
	LDA	!PSWAIT
	BEQ	GOSEL65
	RTS
GOSEL65 EQU	$
	STZ	!PASTIM
;
;;;;;;;;;;;;;;;;;;;		   PHX				   ; (X) push
;;;;;;;;;;;;;;;;;;;		   LDX	   #000H
;;;;;;;;;;;;;;;;;;;		   TXA
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;ROM_CK_00	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >ROM_CK_S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #ROM_CK_E-ROM_CK_S
;;;;;;;;;;;;;;;;;;;		   BNE	   ROM_CK_00		   ;
;;;;;;;;;;;;;;;;;;;;						   ;
;;;;;;;;;;;;;;;;;;;		   CMP	   #08BH
;;;;;;;;;;;;;;;;;;;		   BEQ	   ROM_CK_S		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; no
;;;;;;;;;;;;;;;;;;;		   PLX				   ; (X) pull
;;;;;;;;;;;;;;;;;;;		   JMP	   >ROM_ERROR
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;ROM_CK_S	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   PLX				   ; (X) pull
		LDY	#04
		STY	PLCNT		;player count set
;;;;;;;;;;;;;;;;;;;ROM_CK_E	   EQU	   $
	 STZ	  ENCOCT1
;
	 LDA	  #0
	 LDY	  #SCCRP1-SCCRP0
GOSEL120 EQU	  $
	 STA	  SCCRP0,Y
	 DEY
	 BPL	  GOSEL120	  ;score clear end ?
;				  ;yes
	 INC	  SEMSFG	  ;see-thru-mushroom flag on
;
	 LDA	  SELFLG
	 BEQ	  GOSEL100	  ;no save & continue ?
;
	 JSL	  >M2SAVE	  ;save
;				  ;no
	 LDA	  SELFLG
	 CMP	  #001H
	 BEQ	  GOSEL100	   ;save & continue ?
	 JMP	  >PS_RESET	  ;reset
;
GOSEL100 EQU	  $
;
	 JMP	  GMOS50
;
;
;	SMENDING
;
;*********************************************************************
;*	 World-9 message display		   (MSG9WL)	     *
;*********************************************************************
MSG9WL	 EQU	  $
	 LDA	  SYMODE
	 CMP	  #GVMOD
	 BEQ	  MG9W40	  ;game over ?
;				  ;no
	 LDA	  W9CKFG
	 BNE	  MG9W20	  ;W-9 message display ?
;				  ;yes
	 LDA	  #W9M1
	 STA	  VRFLG
;;;	    LDA	     #10H
;;;	    STA	     MSDSTM
	 INC	  W9CKFG
MG9W20	 EQU	  $
	 LDA	  #00H
	 STA	  BGBKFG
	INC	BGOTMD
	RTS
;
;
MG9W40	 EQU	  $
	 LDA	  #20H
	 STA	  MSDSTM
;
	 LDA	  #W9M2
	 STA	  VRFLG
	 INC	  GMMODE	       : Next game BG out mode set
	 RTS
;
;
;*********************************************************************
;*	 Mario , Luigi initial data set		   (MLSLPST)	     *
;*********************************************************************
MRLGDT	 EQU	  $
;
;===============  MARIO	 DATA  =======================================
MRGPD0	 EQU	  $		  ;jump up G power
	 HEX	  20		  ; Stop
	 HEX	  20,1E		  ; Walk
	 HEX	  28,28		  ; Run
;
	 HEX	  0D		  ; Swim
	 HEX	  04		  ; Swim on hole
;
MRGPD1	 EQU	  $		  ;jump down G power
	 HEX	  70		  ; Stop
	 HEX	  70,60		  ; Walk
	 HEX	  90,90		  ; Run
;
	 HEX	  0A		  ; Swim
	 HEX	  09		  ; Swim on hole
;
MRSLPD	 EQU	  $		  ;slip data
	 HEX	  E4,98,D0
MLDEN1	 EQU	  $
;
LGGPD0	 EQU	  $		  ;jump up G power
	 HEX	  18		  ; Stop
	 HEX	  18,18		  ; Wolk
	 HEX	  22,22		  ; Run
;
	 HEX	  0D		  ; Swim
	 HEX	  04		  ; Swim on hole
;
LGGPD1	 EQU	  $		  ;jump down G power
	 HEX	  42		  ; Stop
	 HEX	  42,3E		  ; Wolk
	 HEX	  5D,5D		  ; Run
;
	 HEX	  0A		  ; Swim
	 HEX	  09		  ; Swim on hole
;
LGSLPD	 EQU	  $		  ;slip data
	 HEX	  B4,68,A0
MLDEN2	 EQU	  $
;
;
MLSLPST	 EQU	  $
	 LDX	  #60H
;
	 LDY	  #MLDEN2-MRLGDT-1
	 LDA	  MRLGFG
	 BNE	  MLSLS40	  ;mario ?
;				  ;yes
MLSLS20	 EQU	  $
	 LDX	  #0EH
;
	 LDY	  #MLDEN1-MRLGDT-1
MLSLS40	 EQU	  $
	 STX	  SLPPNT
;
	 LDX	  #MLDEN1-MRLGDT-1
MLSLS60	 EQU	  $
	 LDA	  MRLGDT,Y
	 STA	  >GPWRD0,X	  ;slip data set
	 DEY
	 DEX
	 BPL	  MLSLS60	  ;set end ?
;				  ;yes
	 RTS
;
;
;*********************************************************************
;*	 W-8 clear message display		   (GSMSGE)	     *
;*********************************************************************
NXMDT	 EQU	  0CH
;
GSMSGE	 EQU	  $
	 LDA	  LMSCNT	       : get time counter
	 BNE	  GMS120
;
	 LDY	  LMSPNT	       : get message pointer
	 CPY	  #0AH
	 BCS	  GMS200	       : message out put terminated
;
	 INY
	 INY
	 INY
;
	 CPY	  #05H		       : set up world 8 clear sound ?
	 BNE	  GMS100	       : no
;
	 LDA	  #04H		       : set up woild 8 clear sound
	 STA	  0FCH		       : sound @@@@@@@@@@@@
GMS100	 EQU	  $
	 TYA
	 CLC
	 ADC	  #DEFA		       : add defoult
	 STA	  VRFLG
GMS120	 EQU	  $
	 LDA	  LMSCNT
	 CLC
	 ADC	  #04H
	 STA	  LMSCNT	       : compute time counter
	 LDA	  LMSPNT
	 ADC	  #0
	 STA	  LMSPNT	       : set up next pointer
	 RTS
;
GMS200	 EQU	  $
	 LDA	  #NXMDT
	 STA	  GTNXTM	       : Set  Goto next time
GSNW80	 EQU	  $
	 INC	  GMMODE
GSNW85	 EQU	  $
	 LDA	  #00H
	 STA	  RKOSU
	 STA	  MKOSU
	 STA	  KEYCNT
GSNW90	 EQU	  $
	 RTS
;
;
;*********************************************************************
;*	 JSR	  GSSCUP    [ Calc  Player count score ( W-8 ) ]     *
;*********************************************************************
GSSCUP	 EQU	  $
	 LDA	  GTNXTM
	 BNE	  GSNW90      ;* IF  next goto ? (Y:GSCUP100)
;
	 LDA	  PLCNT
	 BMI	  GSSC10      ;player count < 0 ?
;			      ;no
	 LDA	  TLSLTM
	 BNE	  GSNW90      ;score up ?
;			      ;yes
	 LDA	  #30H
	 STA	  TLSLTM
;
	 LDA	  #1H
	 STA	  !SOUND3	 ;<SOUND> set (coin input)
;
	 DEC	  PLCNT
	 LDA	  #01H
	 STA	  WPOIN+1
	 JMP	  CFLGM130    ;100000 up
;
GSSC10	EQU	$
	LDA	#05H
	STA	VWORK2
	LDA	#000H
	STA	VWORK1
	STZ	VWORK8
	STZ	VWORK9
	BRA	GSNW80
;
;
;*********************************************************************
;*	 JSR	  GSPAS		  : Spase Set			     *
;*********************************************************************
GSPAS	 EQU	  $
;;	   LDX	    #08H
;
;;SC010	   EQU	    $
;;	   LDA	    SCDATA,X
;;	   STA	    VRAMD+1,X
;;	   DEX
;;	   BPL	    SC010	    ;set end ?
;				  ;yes
	 INC	  GMMODE
;
	 JSR	  GSNW85	  ;ram clear
;
	 LDA	  #060H
	 STA	  GEBTIM
GEBRTS	 EQU	  $
	 RTS
;
;
;*********************************************************************
;*	 W-8 ending				   (GSENDZ1)	     *
;*********************************************************************
GSENDZ1	 EQU	  $
	 JSR	  GEBGP
;
;;;	    LDA	     0608H
;;;	    BNE	     GSE130	 ;sound end ?
;			      ;yes
GSE100	 EQU	  $
;
	LDA	VWORK2
	BEQ	GSE120
	MEM16
	REP	#20H
;
GSE110	EQU	$
	LDA	VWORK1
	XBA
	STA	VRAMD+2
	LDA	#7E43H
	STA	VRAMD+4
	LDA	#0024H
	STA	VRAMD+6
	LDA	#0FFFFH
	STA	VRAMD+8
	MEM8
	SEP	#20H
	BRA	GSE130
GSE120	EQU	$
;
	LDA	COLERR
	BNE	GSE125
	INC	VWORK8
	LDA	VWORK8
	BNE	GSE130
	INC	VWORK9
	LDA	VWORK9
	CMP	#02
	BNE	GSE130
	STZ	STARCT
	LDA	#1
	STA	URAFLG
GSE125	EQU	$
	LDA	CORSNO
	CMP	#0CH
	BEQ	GSE135
	JMP	MRFDOT
;;;;;;;;BRA	GOSB80
;
GSE130	 EQU	  $
	STZ	COLERR
	STZ	VWORK2
GSE135	EQU	$
	RTS
;
;
;*********************************************************************
;*	 W-8 star count save			   (GOVSB2)	     *
;*********************************************************************
;
;*********************************************************************
;*	 Course data load set			   (CSDTSET)	     *
;*********************************************************************
INFTBL	 EQU	  $
	 HEX	  01		  ;maker code
;;;;	     BYTE     "S","M","B"," " ;game name
	 HEX	  00,01,02,03	 ;game name
	 HEX	  00		  ;version
	 HEX	  00		  ;side
	 HEX	  00		  ;volume
	 HEX	  00,00		  ;yobi
;
;
CSDTPT1	 EQU	  $
	 BYTE	  (CORSDT1)&0FFH		; 0 : W1 ~ W4
	 BYTE	  (CORSDT2)&0FFH		; 1 : W5 ~ W8
	 BYTE	  (CORSDT3)&0FFH		; 2 : ending & W9
	 BYTE	  (CORSDT4)&0FFH		; 3 : another W1 ~ W4
;
CSDTPT2	 EQU	  $
	 BYTE	  (CORSDT1)/100H
	 BYTE	  (CORSDT2)/100H
	 BYTE	  (CORSDT3)/100H
	 BYTE	  (CORSDT4)/100H
;
;
CORSDT	 EQU	  $
CORSDT1	 EQU	  $		  ;W1 ~ W4
	 HEX	  01,05,0F,FF
;
CORSDT2	 EQU	  $		  ;W5 ~ W8
	 HEX	  20,FF
;
CORSDT3	 EQU	  $		  ;Ending & W-9
	 HEX	  10,30,0F,FF
;
CORSDT4	 EQU	  $		  ;ura W1 ~ W4
	 HEX	  40,FF
;
;
;
CORCDT	 EQU	  $		  ;course data load count data
;		   0  1	 2  3
	 HEX	  03,01,03,01
;
;
SAVTBL	 EQU	  $
	 HEX	  0F		  ;access no.
;;;;;;	       BYTE	"S","M","2","S","A","V","E"," "	 ;file neme
	HEX	20,20,20,20,20,20,20,20
	 WORD	  0D29FH	  ;load head address
	 WORD	  00001H	  ;total byte
	 HEX	  00		  ;load status
	 WORD	  0D29FH	  ;save head address
	 HEX	  00		  ;save status
;
;
GOVSB2	 EQU	  $
	 LDA	  #07H
;;QQ	     JSR      PURGE_SAVE      ;purge_save
	 WORD	  INFTBL
	 WORD	  SAVTBL
	 BEQ	  GOSB80	  ;error ?
;				  ;yes
	 INC	  LDCKFG
	RTS
;
GOSB80	 EQU	  $
;;	   LDA	    #0D2H
;;	   STA	    >SNDADR+2
;;	   LDA	    #0A0H
;;	   STA	    >SNDADR+1	    ;sound call address change
;
	 LDA	  #00H
	 STA	  LDCKFG
	 STA	  GMMODE
;
;;QQ	     LDA      URAFLG
;;QQ	     BNE      GOSB90	      ;ura-world ?
;				  ;no
;;	   LDA	    WCLRCT
;;	   CMP	    #0FFH
;;	   BEQ	    GOSB100	    ;all castle clear ?
	LDA	CORSNO
	CMP	#0CH
	BEQ	GOSB90
	LDA	WARPCT
	BEQ	GOSB100
	 LDA	  #00H
	 STA	  WCLRCT
	 STA	  PLCNT
	INC	CORSNO
	JMP	 GSED20		 ;W-9 set
;				  ;no
GOSB90	 EQU	  $
	 LDA	  #00H
	 STA	  WCLRCT
	 STA	  SYMODE
	 JMP	  GMTITL
;
;
GOSB100	 EQU	  $		  ;goto W-9
	 LDA	  #00H
	 STA	  WCLRCT
	 STA	  PLCNT
	 STA	  W9CKFG
	 JMP	  GSED20	  ;W-9 set
;
;
;*********************************************************************
;*	 JSR	  GEBGP		  : Game End &	Pinokio	 set	     *
;*********************************************************************
SPSMD	 EQU	  $
	 HEX	  50,B0,E0,68,98,C8,80
;
SPOMD	 EQU	  $
	 HEX	  50,68,80,98,B0,C8,E0
;
EYSDT	 EQU	  $
	 HEX	  B8,90,70,68,70,90,B8
;
EXPDT	 EQU	  $
	 HEX	  38,48,60,80,A0,B8,C8	   +8
;
;
GEBGP	 EQU	  $
	 LDA	  GEBTIM
	 BEQ	  GEB000       : "2" second's after ?
;
	 DEC	  GEBTIM
	 RTS
;
GEB000	 EQU	  $	       : Yes !
	 JSR	  OAMCL1	  ;oam clear
;
	 LDX	  MKOSU	       : Pinokio kosu
	 CPX	  #07H
	 BEQ	  GEP030       :>MKOSU = 7 ? < YES : GEP030 >
;
	 LDA	  RKOSU
	 AND	  #00011111B
	 BNE	  GEP010
;
	 INC	  MKOSU
	 LDA	  #01H
	 STA	  !SOUND3	 :<SOUND> set (coin input)
	 JMP	  GEP010
;
GEP030	 EQU	  $
	 LDA	  RKOSU
	 AND	  #00011111B
	 BNE	  GEP010
;
	 INC	  KEYCNT
	 LDA	  KEYCNT
	 CMP	  #0BH
	 BCC	  GEP010
;
	 LDA	  #04H
	 STA	  KEYCNT
;
GEP010	 EQU	  $
	 INC	  RKOSU
;
	 LDA	  CORSNO
	 PHA
;
	 LDA	  MKOSU	     : Pinokio kosu
	 PHA
	 TAX
;
GEP020	 EQU	  $
	 LDA	  KEYCNT
	 CMP	  #04H
	 BCC	  GEP040
	 SBC	  #04H
	 TAY
	 LDA	  SPSMD,Y
	 CMP	  SPOMD-1,X
	 BEQ	  GEP050
;
GEP040	 EQU	  $
	 LDY	  SPOMD-1,X
	 STY	  OAMEN	     : OAM INDEX
;
	 LDA	  #GIAL
	 STA	  ENMYNO     : Pinokio display
	 LDA	  EYSDT-1,X
	 STA	  ENYPS1     : Y position
	 LDA	  EXPDT-1,X
	 STA	  ENOBJX     : X position
;
	 LDX	  #00H
	 STX	  CORSNO     : Pinokio
	 STX	  INDEX	     : Index clear
;-----------------------------
	 JSR	  ENCSET     ;: Character set
;-----------------------------
	 DEC	  KINPCT
;
GEP050	 EQU	  $
	 DEC	  MKOSU
	 LDX	  MKOSU
	 BNE	  GEP020     : All end ??
;
	INC	KINPCT
	 PLA		     ; yes
	 STA	  MKOSU
	 PLA
	 STA	  CORSNO
;
	 LDA	  #30H
	 STA	  OAMEN	     : Qeen OAM index
;
	 LDA	  #0B8H
	 STA	  ENYPS1     : Y position
	 RTS
;
;************************************************
;*	 MARIO COLER FADE_OUT			*
;************************************************
MRFDOT	EQU	$
;
	JSL	>CLFDOT
	BCS	MRFDEN
	RTS
MRFDEN	EQU	$
	LDA	#1
	STA	SVCKFG
	JMP	GOSB80
;
;
;--------------------------------
;
	END
