;
	include		mn_hp_smram.asm
;
	 ORG	  0D8000H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1991.12.05	    V.1.0  Super Mario_CD
;				   File	 name : SMMAIN
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	EXT	PS_RESET,ROM_ERROR,MSHINT,PCHMV2,PCCLCN,ENINIT
	EXT	KISSDM,KISSDM,PCHFIN,PHCINT,ENDCTR
	EXT	PCHCNG,MROMOV,ENDCTR2
	GLB	OMCLPS
;=========================================================== SMMAIN ==
	 GLB	  JSRSUB,BGBV90,BGBV100,GMTITL
	 GLB	  TLBGOT,GMBGOT,BGCVST,BGCRST,BGBKES,BGBKST
	 GLB	  BGBLNK,BGCOES,GVBGOT,CLSET1,PRMDSP
	 GLB	  RDKEY,SCHEG,CMPBE
	 GLB	  CAINC,GMSCCL,SCDISP
;
	GLB	MSCL05,ICGMMD,PRM400,OAMCL1,GSED20
;........................................................... ( VRFLG No. )
;........................................................... ( System mode flag )
	 GLB	  SYMODE
	 GLB	  TLMOD,PYMOD,SCMOD,GVMOD
;........................................................... ( Block No. )
	 GLB	  SKY0,HOLE0,HOLE1,GRS0,WATR0,WATR1,CHM0,WOOD3
	 GLB	  HNDR0,CHM2,POLE0,MUSH0,LND0,CHM1,COIN1,CORL0
	 GLB	  CLBK0,BRIK0,BRIK1,BKMUS,BKWOD,BKSTR,GRND0,PUBK1
	 GLB	  WIRE0,WIRE1,PLY0,WIRE2,CAS0,ROCK0,BRGE0
	 GLB	  WOOD0,BGUN0,SPRIG,HDBK0,CSWL0,MSHP0,CHIN0,WCHM0
	 GLB	  STTL0,STEK0,BKBSW,BLNKBK,BRIK2,COIN0,COIN1,SBBK0
	 GLB	  FENC0,WOOD1,WOOD2,BXCON
	 GLB	  BXMUS,BXCON,STBCO,STBMS,BXDET,STBDM,STBSM
	 GLB	  BKMUS,BKDET,BKWOD,BKSTR,RBCOS,SBMUS
	 GLB	  BRMUS,BRDET,BRWOD,BRSTR,BRBCS,BRSMS
	GLB	KIDN,CUTLT,CUTRT,CTLTC,CTRTC,GRNDK
	GLB	STRTR,STRST
;........................................................... ( Cross Bk No. index )
	 GLB	  B00CS,B01CS,B10CS,B11CS
;........................................................... ( Block etc index )
	 GLB	  NOBK0,NOBK1,NOBK2,NOBK3
	 GLB	  THWR0,THWR1,THWR2,THWR3
;........................................................... ( Execpt data )
	 GLB	  CORCDT,DMTMDT
	GLB	OAMC15,AA1
	GLB	TLPROS,OAMCL0
	GLB	SCBGS0,SCBGS1,CRGNS1,GVCGST
	GLB	STARCT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	 GLB	  GSTART    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	EXT	BGDTA0,BD00,BD10,BD50,BD90,BDA0,BDB0,SNOW0,SNOW1
	EXT	MSBGCL,THKM,ERRMS,CGRST,GOVBG,TCOSL,W9MS1,W9MS2
	EXT	BGDTA1,CLGN0,BGTIL,BGGEM,BGD02,BKCG00,SN0,SN1,MSCL
	EXT	DEFA,ERPT,CGRS,TLSL,GVBG,W9M1,W9M2
	EXT	NXTDT1,NXTDT2,NXTDT3,NXTDX1,NXTDT4,NXTDT5,NXTDT6
	EXT	NXTDT7,NXTDT8,NXTDT9,NXTDTA,NXTDTB,ERMSGDT,CGRSDT
	EXT	GVBGDT,WLD9DT1,WLD9DT2
	EXT	CG0,CG1,CG2,CG3,SNOWD0,SNOWD1,MSCLDT,BKCGDT,THKDTM
	EXT	BKCGDT,THKDTM,THKDTL,CASDTA,SLCRST
;=========================================================== SMINIT ==
	 EXT	  OAMCSD,OAMUCT,RAMCL0,RAMCL1,GMOVER
	 EXT	  TLINT0,TLINT1,GMOVSB
	 EXT	  NWFRST,GMINT0
;=========================================================== SMFRDT ==
	 EXT	  CORS00,CORS01,CORS02,CORS03
	 EXT	  CORS04,CORS05,CORS06,CORS07
	 EXT	  RDCRDT
;=========================================================== SMPLAY ==
	 EXT	  GMPROS,GMPLAY,GMPLAY_DEMO,BKSCUP,PLSCORE,PLSCR20
	 EXT	  SCRCAL,BGLNWT,PLATMV,MOZAIK
;........................................................... ( Game mode )
	 EXT	  GMITMD
;........................................................... ( Status )
	 EXT	  BWALK,BJUMP,BDROP
;........................................................... ( Player mode )
	 EXT	  PLMDFL
;=========================================================== SMENMY ==
	 EXT	  ENEMY,BKMEND,ENLDWY,CFLGM105
;........................................................... ( Enemy No. )
	 EXT	  SHTR,BKTR,RDTR,TUTR,EXT0,FTR0,FTR2
	 EXT	  ENDTR,FIEN,JFS0,FTR7,FLWR,BMUS
	 EXT	  LFT0,LFT1,LFT2,LFT3,ELV0,ELV1
	 EXT	  ESHP,IKTR,BKM0,WTR0,WTR1
	 EXT	  DOWN
;=========================================================== SMCSET ==
	 EXT	  PLPSCV,PLCSET,OAMST280,MSPLCS,OAMST2A,ENCSET
;=========================================================== SMCROS ==
	 EXT	  CRBD00
;=========================================================== SMSUB0 ==
		EXT	CRGNS1X,CLSET1X,CLSET2,TILBGDT
		EXT	TILBGPT,KPADIE,TLFLSH
		EXT	OSBSET,PASSUB,CHRCHNG,OMFIND
;=========================================================== SMSUB1 ==
		EXT	GST_INIT,NXTBG,GMOVR,BGMSET,GHORE,YURYUR
		EXT	GMED20,GMED30
;=========================================================== SMSUB2 ==
		EXT	MENSEL,TITLST,DMACT
;=========================================================== SMSND ===
		EXT	VRMCLZ,VRMCL2,VRMCL3
		EXT	SNDPORT
;=========================================================== SMENDING
		EXT	MSG9WL,PAUSE
		EXT	GOWIT1,GOWIT2,GOVINT1,GOVINT2,GSMSGE,GSSCUP
		EXT	GCGCE,GSPAS,GSENDZ1,GOVINT3
		EXT	GOSEL20
	EXT	AA2
;=====================================================================
	EXT	LDINIT
;=====================================================================
		EXT	PLCNT_SET
;=====================================================================
;
;
		EXTEND
		IDX8
		MEM8
;
;#####################################################################
;#	 Game start				   (GSTART)	     #
;#####################################################################
GSTART		EQU	$		; Cold start
		JMP	GST
;
NMI_JUMP	EQU	$
		JMP	INTSUB
;
IRQ_JUMP	EQU	$
		JMP	IRQSUB
;
;
;
GST_ERROR	EQU	$
		JMP	>ROM_ERROR
;
CHKDT0		EQU	0AAH
CHKDT1		EQU	055H
BRAMAD		EQU	700000H
IMAGAD		EQU	702000H
;
;
GST		EQU	$
		BRA	GST000
		LDA	#CHKDT0
		STA	>IMAGAD
		CMP	>BRAMAD
		BNE	GST_ERROR		; check ok ?
;						; yes
		LDA	#CHKDT1
		STA	>IMAGAD
		CMP	>BRAMAD
		BNE	GST_ERROR		; check ok ?
;						; yes
;
GST000		EQU	$
		SEI			;IRQ   disable
		STZ	4200H		;NMI	  "
		STZ	420BH		;DMA	  "
		STZ	420CH		;H-DMA	  "
;
		LDA	#10000000B
		STA	2100H		;  branking "ON"
;
		PHK
		PLB
;
;
		JSL	>GST_INIT		; game-start initial
;
;
		JSL	>VRMCL2		; VRAM clear
;
		JSR	OAMCL0		; OAM clear
;
;
		STZ	!SND3PT0
		STZ	!SND3PT1
		STZ	!SND3FLAG
		STZ	!SND0FLAG
		STZ	!SND0TIME
		STA	!SND3TIME
		LDA	#001H
		STA	!SND2TIME		; sound flag init.
;
;
		LDA	#10000001B	;int on
		STA	<FMCNT
		STA	4200H
;
		CLI			; IRQ "on"
;
;************************************************************************
;*		SFX  Game						*
;************************************************************************
GST400		EQU	$
		LDA	!NMIFLG
		BEQ	GST400			; V-blank NMI?
;						; yes
;;;;;;;;;;;;;;;;;;;		   BRA	   R_M_C_M2E
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;************************************************************************
;;;;;;;;;;;;;;;;;;;;		   ROM memory check					   *
;;;;;;;;;;;;;;;;;;;;************************************************************************
;;;;;;;;;;;;;;;;;;;R_M_C_M2S	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   MEM16
;;;;;;;;;;;;;;;;;;;		   IDX16
;;;;;;;;;;;;;;;;;;;		   REP	   #00110000B		   ; memory,index 16bit mode
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   PHB				   ; (DBR) push
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   LDX	   !ROM_ADDR		   ; (X) <-- rom address
;;;;;;;;;;;;;;;;;;;		   LDY	   !ROM_BANK		   ; (Y) <-- rom bank
;;;;;;;;;;;;;;;;;;;R_M_C_000	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   PHY
;;;;;;;;;;;;;;;;;;;		   PLB				   ; 00~3F(DBR) set
;;;;;;;;;;;;;;;;;;;		   LDA	   0,X			   ; 00bank rom-data
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   PLB				   ; 80~BF(DBR) set
;;;;;;;;;;;;;;;;;;;		   CMP	   0,X			   ; 80bank rom-data
;;;;;;;;;;;;;;;;;;;		   BEQ	   R_M_C_100		   ; memory ok ?
;;;;;;;;;;;;;;;;;;;;						   ; no
;;;;;;;;;;;;;;;;;;;		   SEP	   #00110000B		   ; memory,index 8bit mode
;;;;;;;;;;;;;;;;;;;		   JMP	   >ROM_ERROR
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;R_M_C_100	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   BNE	   R_M_C_200		   ; next ROM_bank ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDX	   #08000H
;;;;;;;;;;;;;;;;;;;		   TYA
;;;;;;;;;;;;;;;;;;;		   ADC	   #00100H
;;;;;;;;;;;;;;;;;;;		   AND	   #0BF3FH
;;;;;;;;;;;;;;;;;;;		   TAY
;;;;;;;;;;;;;;;;;;;R_M_C_200	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   LDA	   >NMIFLG
;;;;;;;;;;;;;;;;;;;		   BEQ	   R_M_C_000		   ; V-blank NMI?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   PLB				   ; (DBR) pull
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   STX	   !ROM_ADDR
;;;;;;;;;;;;;;;;;;;		   STY	   !ROM_BANK
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   MEM8
;;;;;;;;;;;;;;;;;;;		   IDX8
;;;;;;;;;;;;;;;;;;;		   SEP	   #00110000B		   ; memory,index 16bit mode
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;R_M_C_M2E	   EQU	   $
;;;;;;;;;;;;;;;;;;;;
;
;
		JSR	RDKEY		; Read input key data
;
;
;
RANDOM		EQU	$	  ; Random !
		LDA	RDM
		AND	#2
		STA	RNDWK
		LDA	RDM+1
		AND	#2
		EOR	RNDWK
		CLC
		BEQ	RN00
		SEC
RN00		EQU	$
		ROR	RDM+0
		ROR	RDM+1
		ROR	RDM+2
		ROR	RDM+3
		ROR	RDM+4
		ROR	RDM+5
		ROR	RDM+6
;
		JSL	>SNDPORT	; sound port set
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
AA1	EQU	$
	LDA	>KEYMOD+1
	BEQ	FUFU1
		LDA	KEYA2L
		AND	#00100000B
		BEQ	FUFU
;
		INC	PAUSEF
FUFU		EQU	$
		LDA	KEYA2L
		AND	#00010000B
		BNE	FUFU1
;
		LDA	PAUSEF
		AND	#00000001B
		BEQ	FUFU1
		JMP	FUFU2
;
FUFU1		EQU	$
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		LDA	!PASTEN
		BNE	CHCNSK
		JSL	>CHRCHNG
CHCNSK		EQU	$
;
		JSL	>PAUSE		 ; Pause check
;
		JSR	CMPBE		; comper Score
;
		LDA	<ENVRFG
		BNE	YURPAS
		JSL	>YURYUR		; yu-ra yu-ra scroll set
;
YURPAS		EQU	$
		LDA	!SKIPST
		BMI	GST497
		BEQ	GST499
		LDA	!MSDSTM
		BEQ	GST499
		LDA	!KEYA2L
		BMI	GST496
		LDA	!KEYA2
		AND	#090H
		BEQ	GST499
GST496		EQU	$
		STZ	!MSDSTM
		STZ	!SKIPST
		BRA	GST499
;
GST497		EQU	$
		LDA	!KEYA2L
		ORA	!KEYA2
		AND	#040H
		BEQ	GST499
		LDA	!PASCFG
		CMP	#00FH
		BNE	GST499
		LDA	#080H
		STA	!SOUND2
		JMP	>PS_RESET	; go to reset
;
GST499		EQU	$
		LDA	MFFLG
		BEQ	GST500		; mozaiku-fade ?
;					; yes
		JSR	MOZAIK		; mozaiku-fade
		BRA	GST600
;
GST500		EQU	$
		LDA	PASFLG
		LSR	A
		BCS	GST590		; pause on ?
;					; no
		PHD			; (D) push
		LDA	#HIGH TMEM
		XBA
		LDA	#000H
		TCD			; (D) <--
;
		LDA	<GMSTTM
		BEQ	GST520		; Game stop timer on ?
;					; yes
		DEC	<GMSTTM
		BNE	GST540		;
;					;
GST520		EQU	$
TIMER		EQU	$
		LDX	#TMEL0-TMES0-1	; short timer counter
		DEC	<TMEM
		BPL	TI01		; >=0 ?
;					; no
		LDA	#14H
		STA	<TMEM
;
		LDX	#TMEND-TMES0	; all timer counter
TI01		EQU	$
		LDA	<TMEM+1,X
		BEQ	TI02		; =0 ?
;					; no
		DEC	<TMEM+1,X
TI02		EQU	$
		DEX
		BPL	TI01		; end ?
;					; yes
GST540		EQU	$
		PLD			; (D) pull
;
		LDA	!MSDSTM
		BNE	GST541
		LDA	!SKIPST
		AND	#080H
		STA	!SKIPST
;;;;K;;;;		STZ	!SKIPST
;
GST541		EQU	$
		INC	<FMCNT		 ; Clac	 Frame counter
;;;;;
	INC	BBLCNT
	LDA	BBLCNT
	AND	#00011000B
	CMP	#18H
	BNE	KPD000
	STZ	BBLCNT
KPD000	EQU	$
		JSL	>KPADIE		; Coler flashing & Kuppa die shibuki
;;;;;
		LDA	SCRFLG		; 13/15 parts scroll calc !
		BEQ	GST560		;- IF  parts scroll ON ? ( NO ; GST560 )
;
		LDA	<OAMFG
		LSR	A
		BCS	GST560		; oam clear ok ?
;					; yes
		JSR	COOMCL		; Oam control
;//////;		JSR	OAMCL1		; Oam clear
GST560		EQU	$
		JSR	GMMAIN		; Game main !!
		LDA	!WNDMSG
		BMI	GST590
		BRA	GST600
GST590		EQU	$
		JSR	OAMCL0
		JSL	>OMFIND
GST600		EQU	$
FUFU2		EQU	$
		JSL	>OSBSET		; oamsub set
;
		STZ	!NMIFLG
		JMP	GST400
;
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;
;#####################################################################
;#	 JSR	  INTSUB    [ Int subroutine ]			     #
;#####################################################################
VRCLPD		EQU	$		; V-RAM buffer clear point data !
		WORD	VRAMD-VRAMD	; VRAMD	 area
		WORD	BGDBPT-VRAMD	; BGDSBF   "
;
;
INTSUB		EQU	$
;
		PHB
		PHK
		PLB
;
		LDA	4210H
;
		LDA	PASCFG
		BNE	INT010		;
;					;
		LDA	#10000000B
INT010		EQU	$
		STA	2100H
		STZ	420CH		; H-DMA disable
;
		LDA	!NMIFLG
		BEQ	INT020		; NMI flag on ?
;					; yes
		JMP	INTZZZZ
;
INT020		EQU	$
		INC	!NMIFLG
;
		LDX	VRFLG	  ; V-RAM <-- BG data !
		LDA	MRLGFG
		BEQ	MLCH99
		CPX	#0CH
		BNE	MLCH10
		LDX	#1FH
MLCH10		EQU	$
		CPX	#10H
		BNE	MLCH20
		LDX	#20H
MLCH20		EQU	$
		CPX	#13H
		BNE	MLCH99
		LDX	#21H
MLCH99		EQU	$
		LDA	>BGDTA0,X
		STA	<WORK
		LDA	>BGDTA1,X
		STA	<WORK+1
		LDA	#0FH
		STA	4314H
		STA	<WORK2
		JSR	VRAMTR
;
		LDX	VRFLG	  ; V-RAM <-- BG data !
		CPX	#BGGEM
		BNE	INT021			; VRAMD write ?
;						; no
		LDA	>BGDTA0
		STA	<WORK
		LDA	>BGDTA1
		STA	<WORK+1
		LDA	#0FH
		STA	4314H
		STA	<WORK2
		JSR	VRAMTR
INT021		EQU	$
;
;
		PHD				; (D) push
		LDA	#043H
		XBA
		LDA	#000H
		TCD				; (D) <-- #4300H
;
;---------------------------------------------------; BG.2 write
		IDX16
		REP	#00010000B
;
		LDA	#10000001B
		STA	2115H
;
		LDY	#01801H
		STY	<4300H
;
		LDA	B2VFG
		BEQ	INT025		; BG.2 write ?
;					; yes
		LDA	#BANK B2VRAM+2
		STA	<4304H
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDY	#00040H
		LDX	#00000H
		LDA	>B2VRAM+2,X
INT022		EQU	$
		STA	2116H		; Vram address set
;
		TXA
		CLC
		ADC	#B2VRAM+4
		STA	<4302H		; A-bus address set
		STY	<4305H		; data count set
;
		TXA
		CLC
		ADC	#0042H
		TAX
;
		LDA	#0001H
		STA	420BH		; DMA ch "on"
;
		LDA	>B2VRAM+2,X
		BPL	INT022		; data end ?
;					; yes
INT024		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	B2VFG
;
INT025		EQU	$
;---------------------------------------------------; BG.3 write
		LDA	B3VFG
		BEQ	INT029		; BG.3 write ?
;					; yes
		LDA	#BANK B3VRAM+2
		STA	<4304H
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDY	#00038H
		LDX	#00000H
		LDA	>B3VRAM+2,X
INT027		EQU	$
		STA	2116H		; Vram address set
;
		TXA
		CLC
		ADC	#B3VRAM+4
		STA	<4302H		; A-bus address set
		STY	<4305H		; data count set
;
		TXA
		CLC
		ADC	#003AH
		TAX
;
		LDA	#0001H
		STA	420BH		; DMA ch "on"
;
		LDA	>B3VRAM+2,X
		BPL	INT027		; data end ?
;					; yes
INT029		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
;
		STZ	B3VFG
;
		LDA	#10000000B
		STA	2115H
;---------------------------------------------------; OBJ. DMA
		JSR	OBJDMA		;OBJ DMA set
;
;---------------------------------------------------; CG. write
		LDA	!CGVMAF
		BEQ	NASI
		BMI	NASIDA
		IDX16
		REP	#00010000B
;
		STZ	2121H
;
		LDY	#02200H
		STY	<4300H
		LDY	#CGWORK
		STY	<4302H
		LDA	#BANK CGWORK
		STA	<4304H
		LDY	#00200H
		STY	<4305H
;
		LDA	#00000001B
		STA	420BH
;
		IDX8
		SEP	#00010000B
;
		STZ	!CGVMAF
		BRA	NASI
;
NASIDA		EQU	$
		LDA	#001H
		STA	!CGVMAF
NASI		EQU	$
		PLD			; (D) pull
;
;
		LDY	#000H
		LDX	VRFLG	  ; V-RAM BG set after pros !
		CPX	#BGGEM
		BNE	INT030		;- IF  used BGDSBF area ?  ( NO ; INT030 )
;
		INY
		INY
INT030		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	VRCLPD,Y
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		TAX
		STZ	VRAMD,X
		LDA	#0FFFFH
		STA	VRAMD+2,X
;
		LDA	#0000H
		STA	>B2VRAM
		LDA	<ENVRFG
		AND	#00FFH
		BEQ	INT031
		LDA	#0000H
		STA	>B3VRAM
;
INT031		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STZ	VRFLG
INTZZZZ		EQU	$
		LDA	!WD420C
		STA	420CH		; H-DMA flag set
;
		PHD			; (D) push
		LDA	#021H
		XBA
		LDA	#000H
		TCD			; (D) <-- #2100H
;
		LDA	!WD2130
		STA	<2130H		; color window on/off set
		LDA	!WD2131
		STA	<2131H		; add.&sub. set
;
		LDA	!WD2123
		STA	<2123H
		LDA	!WD2124
		STA	<2124H
		LDA	!WD2125
		STA	<2125H		; window on/off set
;
		LDA	!WD212C
		STA	<212CH
		LDA	!WD212D
		STA	<212DH		; display mode set
;
		LDA	!WD212E
		STA	<212EH
		LDA	!WD212F
		STA	<212FH		; window display set
;
		LDA	CGRED
		STA	<2132H
		LDA	CGGRN
		STA	<2132H
		LDA	CGBLU
		STA	<2132H		; color set
;
		LDA	!WD2105
		STA	<2105H		; BG. mode&character size
		LDA	MOZNO
		STA	<2106H
;
		STZ	<2111H
		STZ	<2111H
		LDA	!BBSCHL
		BEQ	INT140
		LDA	!SCCH31
		STA	<210FH
		LDA	!SCCH32
		STA	<210FH
INT140		EQU	$
		LDA	!MFFLG
		BNE	INT160		; scroll count set ok ?
;					; yes
		LDA	SCCH		;BG1_H
		STA	<210DH
		LDA	DSXP00
		STA	<210DH
;
		LDA	!BBSCHL
		BNE	INT150
		LDA	SCCH21
		STA	<210FH
		LDA	SCCH22
		STA	<210FH
INT150		EQU	$
;
		LDA	SCCV		; " _V
		STA	<210EH
		STZ	<210EH
		LDA	SCCV21
		STA	<2110H
		LDA	SCCV22
		STA	<2110H
INT160		EQU	$
		PLD			; (D) PULL
;
		LDX	#10000001B	;NMI enable
		LDA	!SCHFLG
		BEQ	INT200
;------ V-part_scroll set ---------------------------------------------
		LDA	4211H
		LDA	!VSHCTR
		STA	4209H		;V counter-L
		STZ	420AH		;V counter-H
		STZ	4207H		;H counter off
		STZ	4208H		;
		LDX	#10100001B	;V-part_scroll on
INT200		EQU	$
		STX	4200H
;
		PLB
		RTL
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		IRQ  Routine				(IRQSUB)	*
;************************************************************************
IRQSUB		EQU	$
		PHB
		PHK
		PLB
;
		LDA	4211H
		BPL	IRQS80		; part_scroll ?
;					; yes
		LDA	!SCHFLG
		BEQ	IRQS80		; IRQswich on ?
;					; yes
		LDA	!BBSCHL
		BEQ	IRQS20
;
IRQS10		EQU	$
		BIT	4212H
		BVC	IRQS10		; H-DMA on ?
;					; yes
		LDA	!SCCH21
		STA	210FH
		LDA	!SCCH22
		STA	210FH
		BRA	IRQS80
;
IRQS20		EQU	$
		BIT	4212H
		BVC	IRQS20		; H-DMA on ?
;					; yes
		LDA	!SCCH31
		STA	2111H
		LDA	!SCCH32
		STA	2111H
;
IRQS80		EQU	$
		PLB
		RTL
;
;
		MEM8
		IDX8
;
;
;
;#####################################################################
;#	 JSR	  GMMAIN    [ Game main ]			     #
;#####################################################################
GMMAIN		EQU	$	  ; Pouse check !
		LDA	SYMODE
		ASL	A
		TAX
		JMP	(MAINTBL,X)
;;;;;;;;		JSR	JSRSUB
MAINTBL		EQU	$
GM10		WORD	GMTITL		; Game title
GM20		WORD	GMPROS		;      pros
GM25		WORD	GMSCCL		;      score calc
GM30		WORD	GMOVER		; Game over pros
;
TLMOD		EQU	(GM10-GM10)/2	 ; Title
PYMOD		EQU	(GM20-GM10)/2	 ; Game pros
SCMOD		EQU	(GM25-GM10)/2	 ;	scroll calc
GVMOD		EQU	(GM30-GM10)/2	 ; Game over pros
;
;
;
OMCLPS	EQU	$
	JSR	OAMC18
	RTL
;
;';';';';;#####################################################################
;';';';';;#	  JSR	   OAMCTL    [ OAM countrol ( 9's over countrol ) ]   #
;';';';';;#####################################################################
;';';';';OAMCTL	  EQU	   $		   ;  OAM used position roll !
;';';';';	  LDY	   <ENVRFG
;';';';';	  LDA	   #OAMCSD
;';';';';	  STA	   <WORK		 ; <WORK <-- OAM countrol start point
;';';';';;
;';';';';	  LDX	   #OAMUCT
;';';';';;
;';';';';OMCL10	  EQU	   $
;';';';';	  LDA	   OAM00,X
;';';';';	  CMP	   <WORK
;';';';';	  BCC	   OMCL40		;- IF  fix OAM area ?  ( YES ; OMCL40 )
;';';';';;
;';';';';	  LDY	   OAMCCT		; OAM change countrol calc !
;';';';';	  CLC
;';';';';	  ADC	   OAMCTD,Y
;';';';';	  BCC	   OMCL30
;';';';';;
;';';';';	  CLC
;';';';';	  ADC	   <WORK
;';';';';;
;';';';';OMCL30	  EQU	   $
;';';';';	  STA	   OAM00,X
;';';';';;
;';';';';OMCL40	  EQU	   $
;';';';';	  DEX
;';';';';	  BPL	   OMCL10
;';';';';;
;';';';';	  LDX	   OAMCCT
;';';';';	  INX
;';';';';	  CPX	   #OCDEND-OAMCTD+1
;';';';';	  BNE	   OMCL60
;';';';';;
;';';';';	  LDX	   #0
;';';';';;
;';';';';OMCL60	  EQU	   $
;';';';';	  STX	   OAMCCT
;
;#####################################################################
;#	 JSR	  COOMCL    [ Coin use OAM calc ]		     #
;#####################################################################
COOMCL		EQU	$
		PHD
		LDA	#HIGH OAMEN
		XBA
		LDA	#000H
		TCD			; (D) <--
;
;;;;;;;;		LDX	#8		     ; Coin use OAM index calc !
;;;;;;;;		LDY	#2
;;;;;;;;COOM60		EQU	$
;;;;;;;;		LDA	OAMEN+4,Y
;;;;;;;;		STA	<OAMCO-2,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#2*4
;;;;;;;;		STA	<OAMCO+1-2,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#2*4
;;;;;;;;		STA	<OAMCO+2-2,X
;;;;;;;;;
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;;
;;;;;;;;		DEY
;;;;;;;;;		BPL	COOM60
;		LDA	<OAMEN+4+2
;		STA	<OAMCO-2+8
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+1-2+8
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+2-2+8
;;;
;		LDA	<OAMEN+4+1
;		STA	<OAMCO-2+8-3
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+1-2+8-3
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+2-2+8-3
;;;
;		LDA	<OAMEN+4+0
;		STA	<OAMCO-2+8-3-3
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+1-2+8-3-3
;		CLC
;		ADC	#2*4
;		STA	<OAMCO+2-2+8-3-3
;;;
	LDA	#90H
	STA	<OAMCO+00
	LDA	#94H
	STA	<OAMCO+01
	LDA	#98H
	STA	<OAMCO+02
	LDA	#9CH
	STA	<OAMCO+03
	LDA	#0A0H
	STA	<OAMCO+04
	LDA	#0A4H
	STA	<OAMCO+05
	LDA	#0A8H
	STA	<OAMCO+06
	LDA	#0ACH
	STA	<OAMCO+07
	LDA	#058H
	STA	<OAMCO+08
		PLD			; (D) pull
;;;;;;;;		RTS
;
;
;#####################################################################
;#	 JSR	  OAMCL1    [ OAM all clear No.1 ( 204 - 2FF ) ]     #			#
;#####################################################################
OAMCL1	 EQU	  $
;;;;	     LDY      #OAM+4-OAM
	LDA	<KPAFLG
	BNE	OAMC40
;
;#####################################################################
;#	 JSR	  OAMCL0    [ OAM all clear No.0 ( 200 - 2FF ) ]     #
;#####################################################################
OAMCL0	 EQU	  $
;;;;;;;;	LDA	<PLCMOD
;;;;;;T;;	BEQ	OAMC30
OAMC15	EQU	$
	LDA	ENCLFG
	BNE	OAMC35
OAMC18	EQU	$
	 LDX	  #OAM-OAM
	 LDA	  #0F0H
OAMC20	 EQU	  $
	 STA	  OAM+001H,X
	 STA	  OAM+041H,X
	 STA	  OAM+081H,X
	 STA	  OAM+0C1H,X
	 STA	  OAM2+001H,X
	 STA	  OAM2+041H,X
	 STA	  OAM2+081H,X
	 STA	  OAM2+0C1H,X
	STZ	OAMSB+000H,X
	STZ	OAMSB+040H,X
	STZ	OAMSB+080H,X
	STZ	OAMSB+0C0H,X
	STZ	OAMSB+100H,X
	STZ	OAMSB+140H,X
	STZ	OAMSB+180H,X
	STZ	OAMSB+1C0H,X
	 INX
	 INX
	 INX
	 INX
	CPX	#040H
	 BNE	  OAMC20
OAMC30	EQU	$
	 RTS
;
OAMC40	EQU	$
	LDX	#0
	 LDA	  #0F0H
OAMC50	EQU	$
	 STA	  OAM+041H,X
	 STA	  OAM+081H,X
	 STA	  OAM+0C1H,X
	 STA	  OAM2+001H,X
	 STA	  OAM2+041H,X
	 STA	  OAM2+081H,X
	 STA	  OAM2+0C1H,X
	STZ	OAMSB+040H,X
	STZ	OAMSB+080H,X
	STZ	OAMSB+0C0H,X
	STZ	OAMSB+100H,X
	STZ	OAMSB+140H,X
	STZ	OAMSB+180H,X
	STZ	OAMSB+1C0H,X
	 INX
	 INX
	 INX
	 INX
	CPX	#040H
	 BNE	  OAMC50
	RTS
;
OAMC35	EQU	$
;;
	LDA	#0F0H
	STA	OAM+051H
	STA	OAM+055H
	STA	OAM+0B1H
	STA	OAM+0B5H
	STA	OAM+0B9H
	STA	OAM+0BDH
	STA	OAM+0C1H
	STA	OAM+0C5H
	STA	OAM+0C9H
	STA	OAM+0CDH
;	LDX	#0
;	 LDA	  #0F0H
OAMC37	EQU	$
;	STA	OAM+061H,X
;	STA	OAM+071H,X
;	STA	OAM+081H,X
;	STA	OAM+091H,X
;	STA	OAM+0A1H,X
;	STA	OAM+0B1H,X
;	STA	OAM+0C1H,X
;	STZ	OAMSB+060H,X
;	STZ	OAMSB+070H,X
;	STZ	OAMSB+080H,X
;	STZ	OAMSB+090H,X
;	STZ	OAMSB+0A0H,X
;	STZ	OAMSB+0B0H,X
;	STZ	OAMSB+0C0H,X
;	INX
;	INX
;	INX
;	INX
;	CPX	#10H
;	BCC	OAMC37
;	STZ	OAMSB+54H
;
;	LDY	#0
;	TYX
OAMC70	EQU	$
;	LDA	<ENCMOD,X
;	BNE	OAMC60
;	LDA	#0F0H
;	STA	OAM2+01,Y
;	STA	OAM2+05,Y
;	STA	OAM2+09,Y
;	STA	OAM2+13,Y
;	STA	OAM2+17,Y
;	STA	OAM2+21,Y
OAMC60	EQU	$
;	TYA
;	CLC
;	ADC	#18H
;	TAY
;	INX
;	CPX	#0AH
;	BCC	OAMC70
	RTS
;
;#####################################################################
;#	 JSR	  GMTITL    [ Game title ]			     #
;#####################################################################
GMTITL		EQU	$
		LDA	!GMMODE
		ASL	A
		TAX
		JSR	(TITLTBL,X)
;
		LDA	>ZANMAI_FLG
		BEQ	GMTITL_90		; zanmai-demo ?
;						; yes
		STZ	!SOUND0
		STZ	!SOUND1
		STZ	!SOUND2
		STZ	!SOUND3			; demo sound clear
		RTS
;
GMTITL_90	EQU	$
		STZ	!SOUND2			; demo sound clear
		RTS
;
TITLTBL		EQU	$
		WORD	TLINT0	  ; Title initial-0
		WORD	TLBGOT	  ;   "   BG out
		WORD	TLINT1	  ;   "   initial-1
		WORD	TLPROS	  ;   "   process
;
;#####################################################################
;#	 JSR	  TLPROS    [ Title process ]			     #
;#####################################################################
DMTMDT	 EQU	  018H	    ; Demo next start time !
;
;mariomariomario;CSDSBD	  EQU	   $	     ; Display course No. BG data !
;mariomariomario;	  HEX	   04,00,73,00,01,00,00,FF
;
TLPROS	 EQU	  $
	 LDA	  KEYA1		  : In key  player-1
	 AND	  #00010000B
	 BEQ	  GMT020	  ;- IF	 'start' ?		 ( NO : GMT020 )
;
	LDA	PLAYSW
	STA	MLFLG
	STA	MRLGFG
	STZ	PLAYSW
	 STZ	  WCLRCT
	 STZ	  LDCKFG
	 STZ	  URAFLG      ;flag clear
;
	LDA	>WALDRM
	STA	CORSNO
	LDA	>CORSRM
	STA	CORSID
	LDA	GOALRM
	STA	GOALCT
;
;mariomariomario;	 LDA	 RTRYFG
;mariomariomario;	 BNE	 TUR008
;mariomariomario;	 JSL	 >LDINIT
;mariomariomario;	 BRA	 TUR009
;mariomariomario;TUR008	 EQU	 $
;mariomariomario;	 JSL	 >LDINIT2
		JSL	>LDINIT
;
TUR009	EQU	$
	LDA	CORSNO
	CMP	#09H
	BCC	TUR010
	INC	URAFLG
TUR010	EQU	$
;mariomariomario;;
;mariomariomario;	  LDA	   STARCT
;mariomariomario;	  CMP	   #08
;mariomariomario;	  BCC	   TLPRS20     ;star count > 8 ?
;mariomariomario;;			       ;yes
;mariomariomario;	  LDA	   KEYA1L
;mariomariomario;	  AND	   #10000000B
;mariomariomario;	  BEQ	   TLPRS20     ;1key [A] on ?
;mariomariomario;;			       ;yes
;mariomariomario;	  INC	   URAFLG
;mariomariomario;TLPRS20  EQU	   $
		LDA	#000H
		STA	>SAVEBF+(m2_new-SAVEBF) ; new off
	 JMP	  GMT300
;
;
GMT010		EQU	$
		LDA	#000H
		STA	>MR2_TOP+0
		STA	>MR2_TOP+1
		STA	>MR2_TOP+2
		STA	>MR2_TOP+3
		STA	>MR2_TOP+4
		STA	>MR2_TOP+5
		STA	!TOPSCR+0
		STA	!TOPSCR+1
		STA	!TOPSCR+2
		STA	!TOPSCR+3
		STA	!TOPSCR+4
		STA	!TOPSCR+5
		LDA	#008H
		STA	!SOUND0			; top-score clear
		JMP	GMT270
;
GMT020	 EQU	  $
	JSL	>TLFLSH
		LDA	>ZANMAI_FLG
		BNE	GMT060			; zanmai-demo ?
;						; no
		LDA	!KEYA1L
		CMP	#10110000B
		BNE	GMT030			; [A],[L],[R] on ?
;						; yes
		LDA	!KEYA1
		CMP	#10000000B
		BEQ	GMT010			; [B] on ?
;						; no
GMT030		EQU	$
		LDA	>SAVEBF+(m2_new-SAVEBF)
		BMI	GMT040			; new-game ?
;						; no
		LDA	#040H
		STA	!DEMOTM
;
GMT040		EQU	$
;;;;;	JSL	>MENSEL
;;;;K;;;;	  LDA	   KEYA1	   ; In key  player-1
	LDA	!KEYA2			; In key  player-1
	AND	#00101100B
	 BNE	  GMT100	  ;- IF	 'select' ON ?		 ( YES : GMT100 )
;
GMT060		EQU	$
	 LDX	  DEMOTM
	 BNE	  GMT200	  ;- IF	 demo start time ?	 ( NO : GMT200 )
;				  < Demo pros >
;mariomariomario;	  STA	   TLSLTM		; Select time set
;
	 JSL	  >DMACT		; Demo action pros
	 BCC	  GMT240
	 BCS	  GMT270	       ;- IF  end demo ?	 ( YES : GMT270 )
;
GMT080	 EQU	  $
GMT100	 EQU	  $		  ; Select pros !
	 LDA	  DEMOTM
	 BEQ	  GMT270	       ;- IF  demo now ?
;
	 LDA	  #DMTMDT
	 STA	  DEMOTM		    ; Reset  Demo start time
;
	 LDA	  FMCNT
	 AND	  #11111110B
	 STA	  FMCNT			    : flame counter adjust
;
		LDA	>ZANMAI_FLG
		BNE	GMT200			; zanmai demo ?
;						; no
;mariomariomario;	  LDA	   TLSLTM
;mariomariomario;	  BNE	   GMT200		;- IF  next select set ?  ( NO ; GMT200 )
;mariomariomario;;
;mariomariomario;	  LDA	   #10H
;mariomariomario;	  STA	   TLSLTM		     ; Next select time set
;mariomariomario;;
;mariomariomario;;;;	     CPY      #1
;mariomariomario;;;;	     BEQ      GMT140		   ;- IF  'B' select ?	     ( YES ; GMT140 )
;mariomariomario;;
	LDA	KEYA2
;mariomariomario;	 AND	 #00100000B
		BIT	#00100000B
	BEQ	GMT102
;
	 LDA	  PLAYSW	       ; ON 'select' pros !
	 EOR	  #00000001B
;mariomariomario;	  STA	   PLAYSW		     ; Set  1 player or 2 player
;mariomariomario;	 LDA	 #01
;mariomariomario;	 STA	 !SOUND3
		BRA	GMT105
;
GMT102	EQU	$
		AND	#00001100B
		BEQ	GMT108			; up,down key on ?
;						; yes
		EOR	#00001000B
		LSR	A
		LSR	A
		LSR	A
		CMP	!PLAYSW
		BEQ	GMT108			; cursol change ?
;						; yes
GMT105		EQU	$
		STA	!PLAYSW
		LDA	#001H
		STA	!SOUND3
;mariomariomario;	 LDA	 KEYA1
;mariomariomario;	 AND	 #00001100B
;mariomariomario;	 CMP	 #08H
;mariomariomario;	 BEQ	 GMT105
;mariomariomario;	 CMP	 #04H
;mariomariomario;	 BNE	 GMT108
;mariomariomario;	 LDA	 PLAYSW
;mariomariomario;	 BNE	 GMT108
;mariomariomario;	 LDA	 #1
;mariomariomario;	 STA	 !SOUND3
;mariomariomario;	 STA	 PLAYSW
;mariomariomario;	 BRA	 GMT108
;mariomariomario;GMT105	 EQU	 $
;mariomariomario;	 LDA	 PLAYSW
;mariomariomario;	 BEQ	 GMT108
;mariomariomario;	 STZ	 PLAYSW
;mariomariomario;	 LDA	 #1
;mariomariomario;	 STA	 !SOUND3
GMT108	EQU	$
;
	 JSL	  >SLCRST		     ; Set  Select cursor
;;;	    JMP	     GMT200
;
GMT140	EQU	$			; ON 'B' pros !
;;;	    LDX	     CSSLCT
;;;	    INX
;;;	    TXA
;;;	    AND	     #00000111B
;;;	    STA	     CSSLCT
;;;	    JSR	     COSSSB		       ; Course No. set sub
;
GMT180	 EQU	  $
;;;	JSR	SCBGS1
;
GMT200	EQU	$			; Game disply pros !
	STZ	KEYA1
;
GMT240	EQU	$
		LDA	!SOUND3
		PHA				; (A) push
;mariomariomario;	 LDA	 #0
	JSR	GMPLAY_DEMO			; Game play pros
		STZ	!SOUND0
		STZ	!SOUND1
		PLA				; (A) pull
		STA	!SOUND3
;
	LDA	<PLCMOD
	CMP	#PLMDFL
	BNE	STCR90			; IF fail player ?    ( NO ; STCR90 )
	STZ	!MZRTFG			; reset flag ;KK;
;
GMT270	EQU	$			; Title init mode set !
	STZ	SYMODE
	STZ	GMMODE
	STZ	SCRFLG			; parts scroll calc OFF
;
	LDA	#01H
	STA	MFFLG
	INC	BGBKFG			; BG blanking ON
;	LDA	#01
;	STA	MFFLG			;;T;;
;
	RTS
;
GMT300	EQU	$			; Game start init mode set !
;
	LDY	DEMOTM
	BEQ	GMT270			; IF demo now ?	       ( YES ; GMT140 )
;
	ASL	A
	BCC	GMT320			; IF countinue start ? ( NO ; GMT320 )
;
	LDA	#9	;	CTNCOS
	JSR	COSSSB			; Course No. set sub
;
GMT320	EQU	$
	LDA	#29H
	STA	!SOUND3
	LDA	#1
	STA	!ENCLFG
	STA	!PLNOWR
	JSR	PLCSET
	JSL	>RDCRDT			; Read course data
;
	INC	SEMSFG			; See thru mashroom flag ON
	INC	WSMSFG
	INC	PLFSFG			; Player first start flag ON
	INC	SYMODE
;
	LDA	URAFLG
	STA	GMLOOP			; Set Game loop
;
	STZ	GMMODE
	STZ	DEMOTM			; Clear	 Demo timer
;;;	    LDA	     DEMOTM
;;;	    BEQ	     GMT270	     ;demo now ?
;				  ;no
;;;	    INC	     GMMODE
;;;	    JSR	     MLITSET	     ;mario,luigi initial data set
;
;;;	    STZ	     CORSNO
;;;	    STZ	     GOALCT
;;;	    STZ	     CORSID
;
;#####################################################################
;#	 JSR	  SCTMCR    [ Score & Time area clear ]		     #
;#####################################################################
SCTMCR	 EQU	  $
	 LDX	  #TIMSCR-1-CONSCR1	;SCCRP0
;;;;	     LDA      #0
;
STCR30	 EQU	  $
	 STZ	  CONSCR1,X	;SCCRP0,X
	 DEX
	 BPL	  STCR30
;
	PHX
	STZ	<YWORK
	LDA	ENCOCT1
	JSR	STCRSB
	STA	COINCT1+2
	LDA	<YWORK
	STA	COINCT1+1
;
	LDA	#1
	STA	SVCKFG
	PLX
;
STCR90	 EQU	  $
;
	 RTS
;
STCRSB	EQU	$
STCR40	EQU	$
	CMP	#10
	BCC	STCR50
	INC	<YWORK
	SEC
	SBC	#10
	BRA	STCR40
STCR50	EQU	$
	RTS
;
;#####################################################################
;#		     (A) -- Set course No.			     #
;#	 JSR	  COSSSB    [ Course set sub ]			     #
;#####################################################################
COSSSB	 EQU	  $
	 STA	  CORSNO
;;;;	     STA      WCRSNO
;
;;;;	     LDX      #0
;;;;	     STX      CORSID
;;;;	     STX      WCRSID
;
	 RTS
;#####################################################################
;#	 JSR	  GMSCCL    [ Game score calc : One course end ]     #
;#####################################################################
GMSCCL	 EQU	  $
	 JSR	  GMSL80	  ; One world ending score calc
	 LDA	  GMMODE
	 BEQ	  GMSL30
;
	 LDX	  #00H
	 STX	  <INDEX
	 JSR	  ENEMY		  ; Queen pros
;
GMSL30	 EQU	  $
	 JSR	  PLPSCV	  ; Player position convert
	 JMP	  PLCSET	  ;	   chara set
;
GMSL80		EQU	$
	 LDA	FINAL
	BNE	GMSL100
	 LDA	  GMMODE
	 JSR	  JSRSUB
	 WORD	  BKMEND	  ; 0 : big kame ending
	 WORD	  GSCINT	  ; 1 : Inital
	 WORD	  GSCRMV	  ; 2 : Scroll move
	 WORD	  KITIME
	 WORD	  GSNXWD	  ; 3 : Next word set
	 WORD	  GSTCDC	  ; 4 : time count score up
	 WORD	  GSEND		  ; 5 : End pros set
;
GMSL100	 EQU	  $
	 LDA	  GMMODE
	 JSR	  JSRSUB
		WORD	BKMEND		; big kame ending
		WORD	GSCINT2		; Inital
		WORD	GSCRMV		; Scroll move
		WORD	DEMO01
		WORD	DEMO02
		WORD	GSTCDC		; time count score up
		WORD	DEMO03
		WORD	DEMO04
		WORD	DEMO05
		WORD	DEMO06
		WORD	DEMO07
		WORD	DEMO08
		WORD	GSEND		; End pros set
		WORD	GMED120		; D
		WORD	GMED130		; E
;
DEMO01	EQU	$		; KINOKO SET
	LDA	!PLSIZE
	BEQ	DEM010
	JSL	>MSHINT
	INC	!GMMODE
	RTS
DEM010	EQU	$
	INC	!GMMODE
	INC	!GMMODE
	RTS
;
DEMO02	EQU	$
	STZ	!KEYA1
	STZ	!KEYA2
	STZ	!KEYB1
	STZ	!KEYB2
	STZ	!KEYA1L
	STZ	!KEYB1L
	STZ	!KEYA2L
	STZ	!KEYB2L
        LDA     #2
        STA     !TMES6
	JSR	GMPLAY
	LDA	!PLSIZE
	BNE	DEM200
	INC	!GMMODE
DEM200	EQU	$
	RTS
;
DEMO03	EQU	$
	INC	!GMMODE
	INC	!PCHIDX
	RTS
;
DEMO04	EQU	$
	JSL	>PCHMV2
	LDA	!PCHIDX
	CMP	#06H
	BCC	DEM400
	INC	!GMMODE
DEM400	EQU	$
	RTS
;
DEMO05	EQU	$
	LDA	#10H
	STA	!SOUND2
	JSL	>PCCLCN
	JSL	>ENINIT		; en window initial set
	INC	!GMMODE
	RTS
;
DEMO06	EQU	$
	JSL	>KISSDM
	RTS
;
DEMO07	EQU	$
;	LDA	!PASCFG
;	BEQ	DEM700
;	STZ	KEYA2
;	STZ	KEYA2L
;;;;;;; JSL	>KISSDM
;	DEC	!PASCFG
;	RTS
DEM700	EQU	$
;	STZ	!PCHCNT
	INC	!GMMODE
	RTS
;
DEMO08	EQU	$
;	JSL	>PCHFIN
;	LDA	!PCHCNT
;	CMP	#0AH
;	BCC	DEM800
	INC	!GMMODE
;	INC	!PASCFG
DEM800	EQU	$
	RTS
;
GMED120		EQU	$
		JSL	>GMED20
		RTS
;
GMED130		EQU	$
		JSL	>GMED30
		RTS
;
;
;#####################################################################
;#	 JSR	  GSTCDC    [ Time count score up ]		     #
;#####################################################################
GSTCDC	 EQU	  $
	 LDA	  GTNXTM
	 CMP	  #NXMDT-2
	 BCS	  GST100	  ;calc. time ?
;				  ;yes
	LDA	2143H
	AND	#01111111B
	CMP	#04BH
	BEQ	GSCSN10
	LDA	#4BH
	STA	!SOUND3
GSCSN10 EQU	$
	 JSR	  CFLGM105	  ;time count score up
;
	 LDA	  TIMSCR+3
	 ORA	  TIMSCR+4
	 ORA	  TIMSCR+5
	 BNE	  GST100	  ;time = 0 ?
;				  ;yes
	LDA	#4CH
	STA	!SOUND3
	STA	!SVCKFG
	 LDA	  #30H
	 STA	  TLSLTM
	 LDA	  #06H
	 STA	  GTNXTM
	 INC	  GMMODE
GST100	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  GSCINT    [ Game score calc inital ]		     #
;#####################################################################
GSCINT2	 EQU	  $
	JSL	>PHCINT
	BRA	GSCI10
GSCINT	 EQU	  $
	LDA	!PASTEN
	BEQ	GSCINTX
	JSL	>ENDCTR2
GSCI10	EQU	$
	 LDX	  DSXP10
	 INX
	 STX	  SCCLXP	  ; Scroll end position
;
;;	   LDA	    #08H
;;	   STA	    0FCH	    ; Sound  fanfer  @@@@@@
;
	 JMP	  ICGMMD    ; MEMORY DOWN
;
GSCINTX EQU	$
	JSL	>ENDCTR
	RTS
;
;#####################################################################
;#	 JSR	  GSCRMV    [ Game score pros scroll move ]	     #
;#####################################################################
GSCRMV	EQU	$
	LDA	<KPAFLG
	BEQ	KPJP10
	RTS
;
KPJP10	EQU	$
	LDA	!PCHFLG
	BEQ	KPJP15
	JSL	>PCHCNG
KPJP15	EQU	$
	LDY	#0
	STY	GSCRFG
;
	LDA	<PLXPS0		; Clac player auto move !
	CMP	SCCLXP
	BNE	GSCP40
;
	LDA	!CORSNO
	CMP	#07H
	BEQ	GSCP35
	CMP	#0CH
	BNE	GSCP30
GSCP35	EQU	$
	INC	GSCRFG
	JSL	>MROMOV
	BRA	GSCP50
GSCP30	EQU	$
	CMP	#02H
	BNE	GSCP37
	LDA	PLXPS1
	CMP	#044H
	BCS	GSCP50
	BRA	GSCP40
GSCP37	EQU	$
	LDA	PLXPS1
	CMP	#54H
	BCS	GSCP50		; IF player stop position ? ( YES ; GSCP50 )
;
GSCP40	EQU	$
	INC	GSCRFG
	INY
GSCP50	EQU	$
	TYA
	JSR	PLATMV		; Player auto move
;
	LDA	DSXP00		; Clac scroll auto move !
	CMP	SCCLXP
	BEQ	GSCP70		; IF scroll end position ? ( YES ; GSC70 )
;
	LDA	SCSPDB
	CLC
	ADC	#80H
	STA	SCSPDB
;
	LDA	#1
	ADC	#0
	TAY
	JSR	SCRCAL		; Scroll calc
	JSR	BGLNWT		; BG line block wright & Frame data read
;
	INC	GSCRFG
;
GSCP70	EQU	$
	LDA	GSCRFG
	BEQ	GSNW80		; IF auto scroll & auto player move end ? ( YES ; GSNW80 )
;
	RTS
;
;#####################################################################
;#	 JSR	  KITIME    [ Kinopio timer  ]			     #
;#####################################################################
KITIME	EQU	$
	INC	KINCNT
	LDA	KINCNT
	CMP	#070H
	BNE	KITRET
	LDA	#1
	STA	!ENDFLG
	STZ	KINCNT
	INC	GMMODE
KITRET	EQU	$
	RTS
;
;#####################################################################
;#	 JSR	  GSNXWD    [ Next word calc ]			     #
;#####################################################################
NXMDT	 EQU	  008H
;
GSNXWD	EQU	$
	LDA	LMSCNT		; get time counter
	BNE	LMS060
;
	LDA	LMSPNT
	BEQ	LMS020		; get message pointer
;
;;;;	CMP	#09H		; high cut point ?
	CMP	#08H		; high cut point ?
	BCS	LMS060		; yes
;
;;;	LDY	CORSNO
;;;	CPY	#07H
;;;	BNE	LMS010
;
;;;	CMP	#03H		; following message ?
;;;	BCC	LMS060		; no
;;;	SBC	#01H
;;;	BRA	LMS020
;
LMS010	EQU	$
;;;	CMP	#02H		; following message ?
;;;	BCC	LMS060		; no
	CMP	#01H		; following message ?
	BCC	LMS060		; no
;
LMS020	EQU	$
	TAY
;;;	BNE	LMS030		; Thank you mode ?
;				; yes
;;;	LDA	MRLGFG		; "MARIO" ?
	BEQ	LMS040		; yes
;;;	INY
;;;	BNE	LMS040
;
LMS030	EQU	$
;;;	INY
;;;	LDA	CORSNO		; get world no.
;;;	CMP	#07H		; world 8 ?
;;;	BEQ	LMS040		; yes
;
;;;	DEY
;;;	CPY	#04H		; end of display ?
;;;	BCS	LMS080		; yes
;
;;;	CPY	#03H		; high cut point ?
;;;	BCS	LMS060		; yes
;
	CPY	#03H		; end of display ?
	BCS	LMS080		; yes
;
	CPY	#02H		; high cut point ?
	BCS	LMS060		; yes
;
LMS040	EQU	$
;;;	CPY	#03H		; set up world 8 clear sound ?
;;;	BNE	LMS050		; no
;
;;	LDA	#1CH		; set up woild 8 clear sound
;;	STA	!SOUND2		; sound @@@@@@@@@@@@
;
LMS050	EQU	$
	TYA
	CLC
	ADC	#DEFA		; add defoult
	STA	VRFLG
;
LMS060	EQU	$
	LDA	LMSCNT
	CLC
	ADC	#04H
	STA	LMSCNT		; timer inc.
	LDA	LMSPNT
	ADC	#0
	STA	LMSPNT		; set up next pointer
;;;	CMP	#07H
	CMP	#06H
LMS080	EQU	$
;
	BCC	GSNW90		; IF end message display ? ( NO ; GSNW90 )
;
	LDA	#6
	LDA	#NXMDT
	STA	GTNXTM		; Set Goto next timer
	STA	ENCLFG
;
GSNW80	EQU	$
	INC	GMMODE
;
GSNW90	EQU	$
;
	RTS
;
;#####################################################################
;#	 JSR	  GSEND	    [ Game score pros end set ]		     #
;#####################################################################
GSEND	EQU	$
	LDA	GTNXTM
	BNE	GSED90
;
GSED20	 EQU	  $
;
;;K;;	LDA	#0		; Set  Goto next course !
;;K;;	STA	CORSID		; Course index
;;K;;	STA	GOALCT		; Gorl counter
;;K;;	STA	GMMODE
	STZ	CORSID		; Course index
	STZ	GOALCT		; Gorl counter
	STZ	GMMODE
;
		LDA	!WNDMSG
		CMP	#090H
		BEQ	GSED48
;
	 LDA	  CORSNO
	 CLC
	 ADC	  #01H
	 CMP	  #0CH
	 BCC	  GSED40	  ;limit ?
;				  ;yes
	 LDA	  #0CH
GSED40	 EQU	  $
	CMP	#08H
	BNE	GSED45
	LDA	!WARPCT
	BEQ	GSED45
	LDA	#1
	STA	!URAFLG
	INC	CORSNO
GSED45	EQU	$
	INC	CORSNO		; Next course No.
GSED48	EQU	$
	JSL	>RDCRDT		; Read next course in word data
;
	INC	PLFSFG		; Player first start flag ON
;
	LDA	#PYMOD
	STA	SYMODE
;
GSED90	EQU	$
;
	RTS
;
GSE100	 EQU	  $		  ; Set	 Goto coruse select mode !
	 LDA	  KEYA1
	 ORA	  KEYB1
	 AND	  #01000000B
	 BEQ	  GSE130	       ;- IF  'B' ON ?		   ( YES ; GSE130 )
;
	 LDA	  #1
	 STA	  URAFLG		     ; 'B' select flag ON
;
	 LDA	  #0FFH
	 STA	  PLCNT
;
	 JSR	  GMOVSB
;
GSE130	 EQU	  $
;
	 RTS
;
;#########################################################
;#	       (X):Index				 #
;#	 JSR	  SCDISP     Small score display & up	 #
;#########################################################
SCCSDT	 EQU	  $	;     Disp  Obj data
	 HEX	  FF,FF	   ; Dammy
;
	 HEX	  F6,FB	   ;  100  ;  1
	 HEX	  F7,FB	   ;  200  ;  2
	 HEX	  F8,FB	   ;  400  ;  3
	 HEX	  F9,FB	   ;  500  ;  4
	 HEX	  FA,FB	   ;  800  ;  5
	 HEX	  F6,0E	   ; 1000  ;  6
	 HEX	  F7,0E	   ; 2000  ;  7
	 HEX	  F8,0E	   ; 4000  ;  8
	 HEX	  F9,0E	   ; 5000  ;  9
	 HEX	  FA,0E	   ; 8000  ;  A
;
	 HEX	  FD,FE	   ; 1UP   ;  B
;
SCUPD1	 EQU	  $	; Score inc data 1  ( to <WORK )
	 HEX	  FF	   ; Dammy
;
	 HEX	  41	   ;  100
	 HEX	  42	   ;  200
	 HEX	  44	   ;  400
	 HEX	  45	   ;  500
	 HEX	  48	   ;  800
	 HEX	  31	   ; 1000
	 HEX	  32	   ; 2000
	 HEX	  34	   ; 4000
	 HEX	  35	   ; 5000
	 HEX	  38	   ; 8000
;
	 HEX	  00	   ; 0 PTS
;
;SCUPD2	  EQU	   $	 : Score inc data 2  ( to WOTK+1 )
;;;;	 HEX	  FF	   : Dammy
;
;;;;	 HEX	  04		  :  100
;;;	 HEX	  04		  :  200
;;;;	 HEX	  04		  :  400
;;;;	 HEX	  04		  :  500
;;;;	 HEX	  04		  :  800
;;;;	 HEX	  03		  : 1000
;;;;	 HEX	  03		  : 2000
;;;;	 HEX	  03		  : 4000
;;;;;	 HEX	  03		  : 5000
;;;;	 HEX	  03		  : 8000
;
SCDISP	 EQU	  $
;	LDA	ENCLFG
;	BEQ	SCD005
;	RTS
;SCD005 EQU	$
	 LDA	  SCFLAG,X
	 BEQ	  GSED90	 ; (RETURN)
	 CMP	  #0BH
	 BCC	  SCD000
	 LDA	  #0BH
	 STA	  SCFLAG,X
	CPX	#09H
	BEQ	SCD000
	STA	!HDCRCT
SCD000	 EQU	  $
	 TAY
;
	 LDA	  SCDPTM,X
	 BNE	  SCD020
	 STA	  SCFLAG,X
	 RTS
;
SCD020	 EQU	  $
	 DEC	  SCDPTM,X
;
	 CMP	  #2BH
	 BNE	  SCD030
;---- Score up ----------
	 CPY	  #0BH
	 BNE	  SCD001
;
;;;;;;;;		INC	!PLCNT		 ; Existra player
;;;;;;;;		LDA	!PLCNT			 ;;;TTT;;
;;;;;;;;		CMP	#0FFH
;;;;;;;;		BNE	CSDDD
;;;;;;;;		DEC	PLCNT
		JSL	>PLCNT_SET		; player count set
CSDDD	EQU	$
;
	 LDA	  #05H		  ; <S! sound
	 STA	  !SOUND3
SCD001	 EQU	  $
	 LDA	  SCUPD1,Y
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAX
	 LDA	  SCUPD1,Y
	 AND	  #0FH
	 STA	  WPOIN,X
	 JSR	  BKSCUP
;----- Score display ----
SCD030	 EQU	  $
SCD040	 EQU	  $
	LDX	<INDEX
;;;T;;;		LDX	 DWBKID
;;;T;;;		LDY	 !OAMSC,X
	LDY	OAMSC
SCD042	EQU	$
	LDA	OAM+01,Y
	CMP	#0F0H
	BEQ	SCD045
	INY
	INY
	INY
	INY
	INY
	INY
	INY
	INY
	CPY	#90H
	BNE	SCD042
	LDY	OAMSC
SCD045	 EQU	  $
;;	 LDA	  FMCNT
;;	 LSR	  A
;;	 BCC	  E11
;
	 LDA	  SCOBJY,X
	 CMP	  #18H
	 BCC	  E11
	 SBC	  #1
	 STA	  SCOBJY,X
E11	 EQU	  $
	 LDA	  SCOBJY,X
;;T;;	      SBC      #8
	 JSR	  OAMST280
;
	STX	<TWORK4
;;	DEX
	TXA
	ASL	A
	TAX
	MEM16
	REP	#20H
	LDA	SCXPOS,X
	STA	<TWORK6
	CLC
	ADC	#08H
	STA	<TWORK2
	MEM8
	SEP	#20H
	LDX	<TWORK4
	STZ	<TWORK1
	LDA	<TWORK6+1
	BEQ	OSB010
	LDA	<TWORK1
	ORA	#01
	STA	<TWORK1
OSB010	EQU	$
	LDA	<TWORK1
	STA	OAMSB,Y
;
	LDA	SCFLAG,X
	CMP	#06H
	BCS	OSB015
OSB013	EQU	$
	STZ	<TWORK1
	BRA	OSB020
OSB015	EQU	$
	CMP	#0BH
	BEQ	OSB013
	LDA	#02H
	STA	<TWORK1
OSB020	EQU	$
	LDA	<TWORK2+1
	BEQ	OSB025
	LDA	<TWORK1
	ORA	#01H
	STA	<TWORK1
OSB025	EQU	$
	LDA	<TWORK1
	STA	OAMSB+04,Y
;
	 LDA	  <TWORK6
	 STA	  OAM+00,Y	;X
	 LDA	  <TWORK2
	 STA	  OAM+04,Y	;X
;
	 LDA	  SCFLAG,X
	 ASL	  A
	 TAX
	 LDA	  SCCSDT,X
	 STA	  OAM+02,Y	;C
	 LDA	  SCCSDT+1,X
	 STA	  OAM+06,Y	;C
;
	TAX
	 LDA	  #32H		    ; Color
	 STA	  OAM+03,Y	;A
	CPX	#0EH
	BNE	OSB030
	INC	A
OSB030	EQU	$
	 STA	  OAM+07,Y	;A
;
SCD010	 EQU	  $
	 LDX	  <INDEX
	 RTS
;
;#####################################################################
;#	 JSR	  TLBGOT    [ Title & Demo BG out ]		     #
;#	 JSR	  GMBGOT    [ Game BG out ]			     #
;#	 JSR	  GVBGOT    [ Game over BG out ]		     #
;#####################################################################
TLBGOT		EQU	$
GMBGOT		EQU	$
GVBGOT		EQU	$
		LDA	BGOTMD
		ASL	A
		TAX
		JMP	(BGOTTBL,X)
;;;;;;;;		JSR	JSRSUB
BGOTTBL		EQU	$
BOMD10	 WORD	  CRGNS0    ; 0 Color generate No.0
	 WORD	  MPLCGS    ; 1 Message player color generater
	 WORD	  SCBGS0    ; 2 Score BG No.0
	 WORD	  SCBGS1    ; 3		 No.1
;
	 WORD	  BGMSS0    ; 4 BG messarge "TIME UP !"
	 WORD	  MSDSCK    ; 5 Messarge display time check
	 WORD	  BGMSS1    ; 6 BG messarge "WORLD 1-4 ..." & "GAME OVER "
	 WORD	  MSG9WL    ; 7 World-9 message (information & game over)
	 WORD	  MSDSCK    ; 8 Messarge display time check
;
BOMD70	 WORD	  BGSET0    ; 9 Game  BG
;
	 WORD	  CRGNS1    ; A Color generater No.1
	 WORD	  CLSET1    ; B Player color & BG. color ( Color generater )
	 WORD	  MSCLST    ; C Mush room BG. color set	 ( Color generater )
;
	 WORD	  BGTLST    ; D Title BG
	 WORD	  TLSLCS    ; E Title select cursor
	 WORD	  TPSCST    ; F Top score
;
MSBMD0	 EQU	  (BOMD10-BOMD10)/2
GMBGMD	 EQU	  (BOMD70-BOMD10)/2
;
;
;#####################################################################
;#	 JSR	  CRGNS0    [ Color generate set No.0 ]		     #
;#####################################################################
CRGNS0	EQU	$
;;;;;;;;	JSR	OAMCL0		; OAM clear
;;;;;;;;	JSR	VRMCL2		; V-RAM one page clear
;
	LDA	SYMODE
	BEQ	CGST90		; IF title ? ( YES ; CGST90 )
;
GVCGST	 EQU	  $
	LDX	#CLGN0+2
	BRA	CGST30
;;K;;	JMP	CGST30
;
;#####################################################################
;#	 JSR	  MPLCGS    [ Messarge player color generater set ]  #
;#####################################################################
MPLCGS	EQU	$
	LDA	NIGTFG
	PHA
;
	LDA	POWLEV
	PHA
;
	STZ	POWLEV
;
	LDA	#2
	STA	NIGTFG
;
;?? 03.12.03 ??		JSR	 CLSET2
	JSL	>CLSET2
;
	PLA
	STA	POWLEV
;
	PLA
	STA	NIGTFG
	JMP	ICBOMD
;
;#####################################################################
;#	 JSR	  CRGNS1    [ Color generate set No.1 ]		     #
;#####################################################################
;?? 03.12.03 ??;
;?? 03.12.03 ??CLGNDT	EQU	$		;C.G. ADRESS INDEX
;?? 03.12.03 ??;		   W	   G	   UG	   C
;?? 03.12.03 ?? BYTE	CG0-CG0,CG1-CG0,CG2-CG0,CG3-CG0
;?? 03.12.03 ??;
CRGNS1	EQU	$
		LDA	<ENVRFG
		JSL	>BGMSET
		JSL	>CRGNS1X
		RTS
;?? 03.12.03 ?? LDX	<ENVRFG
;?? 03.12.03 ?? LDA	CLGNDT,X
;?? 03.12.03 ?? IDX16
;?? 03.12.03 ?? MEM16
;?? 03.12.03 ?? REP	#00110000B
;?? 03.12.03 ?? AND	#00FFH
;?? 03.12.03 ?? TAY
;?? 03.12.03 ??		LDX	#0000H
;?? 03.12.03 ??;
;?? 03.12.03 ?? JSR	CGLOP
;?? 03.12.03 ??;
CGST30	EQU	$
;?? 03.12.03 ?? IDX8
;?? 03.12.03 ?? MEM8
;?? 03.12.03 ?? SEP	#00110000B
	STZ	VRFLG
	LDA	#01H
	STA	!CGVMAF
;
CGST90	EQU	$
	JMP	ICBOMD
;
;?? 03.12.03 ??CGLOP	EQU	$
;?? 03.12.03 ?? MEM16
;?? 03.12.03 ?? IDX16
;?? 03.12.03 ?? LDA	CG0,Y
;?? 03.12.03 ?? STA	!CGWORK,X
;?? 03.12.03 ??;
;?? 03.12.03 ?? LDA	CG0+07EH,Y
;?? 03.12.03 ?? STA	!CGWORK+100H,X
;?? 03.12.03 ??		INX
;?? 03.12.03 ??		INX
;?? 03.12.03 ??		INY
;?? 03.12.03 ??		INY
;?? 03.12.03 ?? CPX	#100H
;?? 03.12.03 ??		BNE	CGLOP
;?? 03.12.03 ?? MEM8
;?? 03.12.03 ?? IDX8
;?? 03.12.03 ?? RTS
;
;#####################################################################
;#	 JSR	  CLSET1    [ Player color & BG. color set ]	     #
;#####################################################################
;?? 03.12.03 ??CLDT1	EQU	 $
;?? 03.12.03 ??;	NIGTFG =  4   5	  6   7
;?? 03.12.03 ??;
;?? 03.12.03 ??		BYTE	 00H,00H,04H,CG3-CG0
;?? 03.12.03 ??;
;?? 03.12.03 ??CLDT2	EQU	 $
;?? 03.12.03 ?? WORD	7E94H,7E94H,0000H,0000H
;?? 03.12.03 ?? WORD	0000H,7E94H,0000H,0000H
;?? 03.12.03 ??;
;?? 03.12.03 ??MRCLDT	EQU	 $
;?? 03.12.03 ??LGCLDT	 EQU	  $
;?? 03.12.03 ??FICLDT	 EQU	  $
;?? 03.12.03 ?? WORD	45BCH,7FFFH,0C63H,0111H,0DB9H,22DDH,2D9CH,3ABFH ; Mario
;?? 03.12.03 ?? WORD	0000H,0000H,40A3H,49E7H,5F2EH,20BCH,1096H,000FH ;
;?? 03.12.03 ??;
;?? 03.12.03 ??;LGCLDT	 EQU	$
;?? 03.12.03 ??;	WORD	7E94H,7FFFH,02FFH,4310H		;Luigi
;?? 03.12.03 ??;
;?? 03.12.03 ??;FICLDT	 EQU	$
;?? 03.12.03 ??;	WORD	7E94H,03FFH,02FFH,001FH
;
CLSET1	 EQU	  $
		JSL	>CLSET1X
		RTS
;
;?? 03.12.03 ??		LDY	 NIGTFG
;?? 03.12.03 ??		BEQ	 CLS110
;?? 03.12.03 ??;
;?? 03.12.03 ?? LDA	CLDT1-4,Y
;?? 03.12.03 ?? MEM16
;?? 03.12.03 ?? REP	#00100000B
;?? 03.12.03 ?? LDX	#0000H
;?? 03.12.03 ?? AND	#00FFH
;?? 03.12.03 ?? TAY
;?? 03.12.03 ?? AND	#00F0H
;?? 03.12.03 ?? BNE	BOCG3
;?? 03.12.03 ??;
;?? 03.12.03 ?? LDA	SNOWD0,Y
;?? 03.12.03 ?? STA	!CGWORK,X
;?? 03.12.03 ?? LDA	SNOWD0+02H,Y
;?? 03.12.03 ?? STA	!CGWORK+02H,X
;?? 03.12.03 ?? LDA	SNOWD0+04H,Y
;?? 03.12.03 ?? STA	!CGWORK+04H,X
;?? 03.12.03 ?? LDA	SNOWD0+06H,Y
;?? 03.12.03 ?? STA	!CGWORK+06H,X
;?? 03.12.03 ?? JMP	DAN
;?? 03.12.03 ??;
;?? 03.12.03 ??BOCG3	EQU	$
;?? 03.12.03 ?? IDX16
;?? 03.12.03 ?? REP	#00010000B
;?? 03.12.03 ?? JSR	CGLOP
;?? 03.12.03 ??;
;?? 03.12.03 ??DAN	EQU	$
;?? 03.12.03 ?? MEM8
;?? 03.12.03 ?? IDX8
;?? 03.12.03 ?? SEP	#00110000B
;?? 03.12.03 ?? STZ	VRFLG
;?? 03.12.03 ?? INC	CGVMAF
;?? 03.12.03 ??;
;?? 03.12.03 ??CLS110	EQU	 $
;?? 03.12.03 ??		INC	 BGOTMD
;?? 03.12.03 ??;#####################################################################
;?? 03.12.03 ??;#	JSR	 CLSET2	   [ Player color set ]			    #
;?? 03.12.03 ??;#####################################################################
;?? 03.12.03 ??CLSET2	EQU	 $
;?? 03.12.03 ??;
;?? 03.12.03 ??		LDY	 #0
;?? 03.12.03 ??		LDA	 MRLGFG	   ; Mario;0	Luigi;1
;?? 03.12.03 ??		BEQ	 CLS210
;?? 03.12.03 ??;
;?? 03.12.03 ??		LDY	 #20H	     ; Luigi
;?? 03.12.03 ??CLS210	EQU	 $
;?? 03.12.03 ??;
;?? 03.12.03 ??		LDA	 POWLEV	   ; With fire ?
;?? 03.12.03 ??		CMP	 #2
;?? 03.12.03 ??		BNE	 CLS220
;?? 03.12.03 ??;
;?? 03.12.03 ??		LDY	 #40H	     ; Yes !
;?? 03.12.03 ??CLS220	EQU	 $
;?? 03.12.03 ??;
;?? 03.12.03 ?? MEM16
;?? 03.12.03 ?? REP	#00100000B
;?? 03.12.03 ?? LDX	#00H
;?? 03.12.03 ??CHLOP	EQU	$
;?? 03.12.03 ?? LDA	MRCLDT,Y
;?? 03.12.03 ?? STA	!CGWORK+100H,X
;?? 03.12.03 ?? INX
;?? 03.12.03 ?? INX
;?? 03.12.03 ?? INY
;?? 03.12.03 ?? INY
;?? 03.12.03 ?? CPX	#20H
;?? 03.12.03 ?? BNE	CHLOP
;?? 03.12.03 ??;
;?? 03.12.03 ??		LDY	 NIGTFG
;?? 03.12.03 ??		BNE	 CLS240
;?? 03.12.03 ??;
;?? 03.12.03 ?? LDY	<ENVRFG
;?? 03.12.03 ??CLS240	EQU	$
;?? 03.12.03 ?? LDA	CLDT2,Y
;?? 03.12.03 ?? STA	!CGWORK+100H		; Obj "00" color set
;?? 03.12.03 ?? MEM8
;?? 03.12.03 ?? SEP	#00100000B
;?? 03.12.03 ??;
;?? 03.12.03 ?? LDA	VRAMD
;MEMDEC1  EQU	   $		   ; mmmmmmmmmmmmmmmmmmmm
;	  STA	   VRAMD	   ; Kosu revise
;	  RTS
;
;#####################################################################
;#	 JSR	  MSCLST    [ Mush room color set ]		     #
;#####################################################################
MSCLST	 EQU	  $
	INC	BGOTMD
;;		JSL	>MSCLSTX
		RTS
;?? 03.12.03 ??		LDA	 OBSTFG
;?? 03.12.03 ??		CMP	 #1
;?? 03.12.03 ??		BNE	 MSCL10		 ; Mushroom ?
;?? 03.12.03 ??;
;?? 03.12.03 ?? MEM16
;?? 03.12.03 ?? REP	#00100000B
;?? 03.12.03 ?? LDA	MSCLDT
;?? 03.12.03 ?? STA	!CGWORK
;?? 03.12.03 ?? LDA	MSCLDT+02H
;?? 03.12.03 ?? STA	!CGWORK+02H
;?? 03.12.03 ?? LDA	MSCLDT+04H
;?? 03.12.03 ?? STA	!CGWORK+04H
;?? 03.12.03 ?? LDA	MSCLDT+06H
;?? 03.12.03 ?? STA	!CGWORK+06H
;?? 03.12.03 ?? MEM8
;?? 03.12.03 ?? SEP	#00100000B
;?? 03.12.03 ??;
;?? 03.12.03 ?? INC	CGVMAF
;?? 03.12.03 ?? LDA	#00H
MSCL05	 EQU	  $
	STA	VRFLG
MSCL10	 EQU	  $
	 JMP	  ICBOMD	  ; INC	 BGOTMD
;
;#####################################################################
;#	 JSR	  SCBGS0    [ Score BG set No.0 ]		     #
;#####################################################################
SCBGS0	 EQU	  $
	 LDA	  #0
	 JSR	  PRMDSP    ;
	LDA	MRLGFG
	BEQ	SCBGRT
	LDA	#15H
	STA	VRAMD+06
	LDA	#1EH
	STA	VRAMD+08
	LDA	#12H
	STA	VRAMD+10
	STA	VRAMD+14
	LDA	#10H
	STA	VRAMD+12
SCBGRT	EQU	$
	 JMP	  ICBOMD    ; INC  BGOTMD
;
;#####################################################################
;#	 JSR	  SCBGS1    [ Score BG set No.1 ]		     #
;#####################################################################
SCBGS1	EQU	$
	JSR	PLSCORE		;score display
;
	MEM16
	IDX16
	REP	#00110000B	; memory , index 16 bit mode
;
	LDX	VRAMD
;
	LDA	#7358H		; BG address set
	STA	VRAMD+2,X
	LDA	#0500H		; ko-su-u
	STA	VRAMD+4,X
;
	MEM8
	SEP	#00100000B	; memory 8 bit mode
;
	LDA	CORSNO
	INC	A
	STA	VRAMD+6,X
	LDA	#20H
	STA	VRAMD+7,X
	STA	VRAMD+9,X
	STA	VRAMD+11,X
	LDA	#24H
	STA	VRAMD+8,X
;;;;;;;;;;;;;	     LDA     SYMODE
;;;;;;;;;;;;;	     BEQ     TITL10
	LDA	GOALCT
TITL10	EQU	$
	INC	A
	STA	VRAMD+10,X		;world no. set
	LDA	#0FFH
	STA	VRAMD+12,X
;
		LDA	SYMODE
		BNE	TITL90			; title ?
;						; yes
		LDA	>ZANMAI_FLG
		BNE	TITL90			; zanmai-demo ?
;						; no
		LDA	>SAVEBF+(m2_new-SAVEBF)
		BMI	TITL90			; new-game ?
;						; yes
		LDA	>SAVEBF+(m2_world-SAVEBF)
		INC	A
		STA	!VRAMD+6,X
		LDA	>SAVEBF+(m2_world+1-SAVEBF)
		INC	A
		STA	VRAMD+10,X		;world,course no. reset
TITL90		EQU	$
	MEM16
	REP	#00100000B		; memory 16 bit mode
;
	TXA
	CLC
	ADC	#000AH
	STA	VRAMD
;
	MEM8
	IDX8
	SEP	#00110000B		; memory , index 8 bit mode
;
	JMP	ICBOMD			; INC  BGOTMD
;
;#####################################################################
;#	 JSR	  BGMSS0    [ BG messarge "TIME UP" ]		     #
;#####################################################################
BGMSS0	EQU	$
	LDA	TMUPFG
	BEQ	BMS190		; IF time up over ?  ( NO ; BMS190 )
;
	STZ	TMUPFG		; Clear Time up flag
;
	LDY	#0
	JSR	OAMC15
	JSL	>GMOVR
	LDA	#001H
	STA	!SKIPST
	LDA	#2		; BG set "TIME UP"
	JMP	BMS050
;
BMS190	EQU	$
	INC	BGOTMD		; Next messarge display mode
	JMP	ICBOMD		; INC  BGOTMD
;
;#####################################################################
;#	 JSR	  BGMSS1    [ BG messarge "WORLD ..." & "GAME O.." ] #
;#####################################################################
BGMSS1	 EQU	  $
	 LDA	  SYMODE
	 BEQ	  BMS080	  ;- IF	 title ?		  ( YES ; BMS080 )
;
	 CMP	  #GVMOD
	 BEQ	  BMS070	  ;- IF	 game over ?		  ( YES ; BMS070 )
;
	 LDA	  CHEVFG
	 BNE	  BMS080	  ;- IF	 first start ?		  ( NO ; BMS080 )
;
	 LDY	  <ENVRFG
	 CPY	  #3
	 BEQ	  BMS030	  ;- IF	 castle ?		  ( YES ; BMS030 )
;
	 LDA	  MGSTFG
	 BNE	  BMS080	  ;- IF	 messarge stop flag ON ?  ( YES ; BMS080 )
;
BMS030	 EQU	  $		  ; Messarge "WORD.." & "MARIO.." !
;
	 JSR	  MSPLCS	       ; Symbole player chara set
;
	JSL	>NXTBG			; next BG window
;
	LDA	#1			; BG set "WORD.." & "X nn"
;
BMS050	 EQU	  $
	 JSR	  PRMDSP
	 JSR	  MSDSTS	       ; Messarge display time set
;
		STZ	!WD2123
		STZ	!WD2124
		STZ	!WD2125
		STZ	!WD2130
		LDA	#00100000B
		STA	!WD2131
		STZ	!WD420C
;
	LDA	#02
	STA	MFFLG
	STZ	FADFLG
	STZ	PASCFG
	STZ	MOZNO
	STZ	BGBKFG		; BG blanking OFF
	RTS
;
;
BMS080	 EQU	  $		  ; Next BG out mode title !
	 LDA	  #GMBGMD
	 STA	  BGOTMD
	 RTS
;
BMS070	EQU	$		; BG messarge "GAME OVER" !
		STZ	!WD2123
		STZ	!WD2124
		STZ	!WD2125
		STZ	!WD2130
		LDA	#00100000B
		STA	!WD2131
		STZ	!WD420C
;
;;;;	     LDA      #12H
	LDA	BGBKFG
	BEQ	BMS075
	STZ	FADFLG
	STZ	BGBKFG			; BG blanking OFF
	STZ	PASCFG
	LDA	#2
	STA	MFFLG
	JSL	>GMOVR
BMS075	EQU	$
	JSR	GOSEL20
	LDA	#09H
	 STA	  GMOVTM	       ; Game over message display time
	 LDA	  #3
	 JSR	  PRMDSP	       ; BG set "GAME OVER"
	 JMP	  ICGMMD	       ; INC  GMMODE
;
;#####################################################################
;#	 JSR	  BGSET0    [ Game BG set ]			     #
;#####################################################################
BGSET0	 EQU	  $
	LDA	BGBKFG
	BEQ	BGST20
	CMP	#01H
	BEQ	BGST30
	BRA	BGST10
BGST20	EQU	$
	LDA	#1
	STA	MFFLG
	STZ	FADFLG
	BRA	GMBS90
BGST10	EQU	$
	 INC	  BGBKFG	  ; BG blanking ON
;
BGST30	EQU	$
	 JSR	  NWFRST	  ; New frame data set
;
	 LDA	  NWSTCT
	 BNE	  BGST30	  ;- IF	 2 block line set end ?	   ( NO ; GMBS10 )
;
	 DEC	  BSBGCT
	 BPL	  GMBS80	  ;- IF	 24 block line set end ?   ( NO ; GMBS80 )
;
	 INC	  BGOTMD
;
GMBS80	 EQU	  $
	 LDA	  #BGGEM
	 STA	  VRFLG
;
GMBS90	EQU	$
	 RTS
;
;#####################################################################
;#	 JSR	  BGTLST    [ Title BG set ]			     #
;#####################################################################
BGTLST		EQU	$
		LDA	SYMODE
		BNE	TPSS90		; IF  title mode ?  ( NO ; TPSS90 )
;
		JSL	>TITLST
		STZ	MLFLG
		LDA	#080H
		STA	!SKIPST
;
;;		LDA	#13H		; title
;;		STA	!SOUND2		;  sound set
		LDA	#BGTIL
		JMP	MSCL05
;
;#####################################################################
;#	 JSR	  TLSLCS    [ Title select cursor set ]		     #
;#####################################################################
TLSLCS	 EQU	  $
	 LDA	  SYMODE
	 BNE	  TPSS90	  ;- IF	 title mode ?  ( NO ; TPSS90 )
;
	 LDX	  #0
;
TLSC40	 EQU	  $
	 STA	  0300H,X
	 STA	  0400H,X	       ; Clear	RAM 300H-400H
	 DEX
	 BNE	  TLSC40
;
	 JSL	  >SLCRST		; Set	 Title BG cursor
;
;#####################################################################
;#	 JSR	  ICBOMD    [ INC  BGOTMD ]			     #
;#####################################################################
ICBOMD	 EQU	  $
	 INC	  BGOTMD
;
	 RTS
;
;#####################################################################
;#	 JSR	  TPSCST    [ Top score set ]			     #
;#####################################################################
TPSCST	 EQU	  $
	 LDA	  #0FAH
	 JSR	  PLSCR20   ; Display  Top score
;
TPSS90	 EQU	  $
;#####################################################################
;#	 JSR	  ICGMMD    [ INC  GMMODE ]			     #
;#####################################################################
ICGMMD	 EQU	  $
	 INC	  GMMODE
;
	 RTS
;
;#####################################################################
;#	 Data of PRMDSP						     #
;#####################################################################
INFDTM	 EQU	  $
	 HEX	  58,43,00,09
	 WORD		2016H,200AH,201BH,2012H,2018H		  ; "MARIO"
	 HEX	  58,52,00,15
	 WORD		2020H,2018H,201BH,2015H,200DH		  ; "WORLD"
	 WORD		2028H,2028H,201DH,2012H,2016H,200EH	  ; "  TIME"
	 HEX	  58,68,00,09
	 WORD		2000H,2028H,2028H,2427H,2025H		  ; "0   @X"
	 HEX	  FF						  ; end of data
;
INFDTL	 EQU	  $
	 HEX	  58,43,00,09
	 WORD		2015H,201EH,2012H,2010H,2012H		  ; "LUIGI"
	 HEX	  58,52,00,15
	 WORD		2020H,2018H,201BH,2015H,200DH		  ; "WORLD"
	 WORD		2028H,2028H,201DH,2012H,2016H,200EH	  ; "  TIME"
	 HEX	  58,68,00,09
	 WORD		2000H,2028H,2028H,2427H,2025H		  ; "0   @X"
	 HEX	  FF						  ; end of data
;
WLDDTM	 EQU	  $
	HEX	59,6D,00,0F
	 WORD		2028H,2028H,2028H,2025H			  ; "  X "
CAPADR	 EQU	  $
	 WORD		2028H					  ; " "
LFTADR	 EQU	  $
	 WORD		2028H					  ; " "
	 WORD		2028H					  ; " "
	WORD		2028H					  ; " "Test
	 HEX	  59,E0,40,FE					  ; display cls
	 WORD		0028H					  ;  ( TIME UP message )
	HEX	59,0B,00,11
;;;;	     HEX      59,4B,00,11
	 WORD		2020H,2018H,201BH,2015H,200DH,2028H	  ; "WORLD"
WLDADR	 EQU	  $
	 WORD		2028H,2024H				  ; " -"
GOLADR	 EQU	  $
	 WORD		2028H					  ; " "
	HEX	58,AC,40,0D
;;;;	     HEX	  59,0C,40,0D
	 WORD		2028H					  ; "       "
	 HEX	  FF						  ; end of data
;
TIMDTM	 EQU	  $						  ; "MARIO"
	 HEX	  09,6D,00,09
	 WORD		19E0H,19E1H,19E2H,19E3H,19E4H
	 HEX	  09,8D,00,09
	 WORD		19F0H,19F1H,19F2H,19F3H,19F4H
TIMDTA	 EQU	  $
	 HEX	  09,AC,00,0D
	 WORD		19CAH,19CBH,19CCH,19CDH			  ; "TIME"
	 WORD		0024H,19CEH,19CFH			  ; " UP"
	 HEX	  09,CC,00,0D
	 WORD		19DAH,19DBH,19DCH,19DDH			  ; "TIME"
	 WORD		0024H,19DEH,19DFH			  ; " UP"
	 HEX	  FF						  ; end of data
;
GOVDTM	 EQU	  $						  ; "MARIO"
;mmmmmmmmmmmmm	       HEX	09,AC,40,12
;mmmmmmmmmmmmm	 WORD	  0024H
;mmmmmmmmmmmmm	       HEX	09,CC,40,12
;mmmmmmmmmmmmm	 WORD	  0024H
;mmmmmmmmmmmmm	       HEX	09,8C,00,01
;mmmmmmmmmmmmm	 WORD	  0024H
;mmmmmmmmmmmmm;
;mmmmmmmmmmmmm	       HEX	09,0B,00,13
;mmmmmmmmmmmmm	 WORD		19C0H,19C1H,19C2H,19C3H,19C4H		  ; "GAME"
;mmmmmmmmmmmmm	       WORD		19C5H,19C6H,19C7H,19C8H,19C9H		  ; " OVER"
;mmmmmmmmmmmmm	       HEX	09,2B,00,13
;mmmmmmmmmmmmm	 WORD		19D0H,19D1H,19D2H,19D3H,19D4H		  ; "GAME"
;mmmmmmmmmmmmm	       WORD		19D5H,19D6H,19D7H,19D8H,19D9H		  ; " OVER"
;mmmmmmmmmmmmm	       HEX	FF						  ; end of data
;
;	  HEX	   09,6D,00,09
;	  WORD		 19E0H,19E1H,19E2H,19E3H,19E4H
;	  HEX	   09,8D,00,09
;	 WORD		19F0H,19F1H,19F2H,19F3H,19F4H
GOVDTA	 EQU	  $
;;;NOM;;;	  HEX	   09,AC,40,12
;;;NOM;;;	 WORD	  0024H
;;;NOM;;;	  HEX	   09,8C,00,11
;;;NOM;;;	 WORD	  0024H
;;;NOM;;;	  WORD	   080CH,0818H,0817H,081DH,0812H,0817H,081EH,080EH ; "CONTINUE"
;;;NOM;;;	  HEX	   09,CC,00,0D
;;;NOM;;;	  WORD	   0024H,081BH,080EH,081DH,081BH,0822H,0024H	   ; "RETRY"
;
	 HEX	  09,CC,40,0C					  ; beta
	 WORD	  0024H
	 HEX	  09,AB,00,0F
	 WORD	  02A1H,02A2H,02A3H,02A4H,02A5H,02A6H,02A7H,02A8H ; "continue"
	 HEX	  09,EB,00,19
	 WORD	  02AEH,02AFH,02B0H,02B1H,02ADH,02A1H,02A2H,02A3H ; "save & continue"
	 WORD	  02A4H,02A5H,02A6H,02A7H,02A8H
	 HEX	  0A,2B,00,11
	 WORD	  02AEH,02AFH,02B0H,02B1H,02ADH,02A9H,02AAH,02ABH ; "save & quit"
	 WORD	  02ACH
;
	 HEX	  09,0B,00,13
	 WORD		19C0H,19C1H,19C2H,19C3H,19C4H		  ; "GAME"
	 WORD		19C5H,19C6H,19C7H,19C8H,19C9H		  ; " OVER"
	 HEX	  09,2B,00,13
	 WORD		19D0H,19D1H,19D2H,19D3H,19D4H		  ; "GAME"
	 WORD		19D5H,19D6H,19D7H,19D8H,19D9H		  ; " OVER"
	 HEX	  FF						  ; end of data
;
;
WELDTA	EQU	$
	HEX	05,84,00,29
	WORD		0820H,080EH,0815H,080CH,0818H,0816H,080EH ; "WELCOME"
	WORD		0024H,081DH,0818H,0024H			  ; " TO "
	WORD		0820H,080AH,081BH,0819H,0024H		  ; "WARP "
	WORD		0823H,0818H,0817H,080EH,082BH		  ; "ZONE!"
CRCDTA	EQU	$
	HEX	05,E5,00,01
CR1ADR	EQU	$
	WORD		0824H					  ; " "
	HEX	05,ED,00,01
CR2ADR	EQU	$
	WORD		0824H					  ; " "
	HEX	05,F5,00,01
CR3ADR	EQU	$
	WORD		0824H					  ; " "
EODADR	EQU	$
	HEX	FF						  ; end of data
;
;
LUIGDT	 EQU	  $
	WORD		19E5H,19E6H,19E7H,19E8H,19E9H		   ; "LUIGI"
	WORD		19F5H,19F6H,19F7H,19F8H,19F9H
	WORD		2015H,201EH,2012H,2010H,2012H		   ; "LUIGI"
;
;
CORCDT	 EQU	  $	   Dummy
;
	 HEX	  02	;0 : warp course no.  W1-2	   UG-0
	 HEX	  03	;1 : warp course no.		   G-20
	 HEX	  04	;2 : warp course no.		   UG-1
	 HEX	  01	;3 : warp course no.  W3-1	   G-5
	 HEX	  06	;4 : warp course no.  W5-1	   G-11
	 HEX	  07	;5 : warp course no.  W5-2	   UG-3
	 HEX	  08	;6 : warp course no.		   G-20
	 HEX	  05	;7 : warp course no.  W7-4 & W8-1  G-11
;
	 HEX	  0B	;8 : warp course no.  WA-2	   (Ura-world)
	 HEX	  0C	;9 : warp course no.  WA-3	   (Ura-world)
	 HEX	  0D	;A : warp course no.  WB-4	   (Ura-world)
;
DATIDX	 EQU	  $
	 BYTE	  INFDTM-INFDTM	  ; Information data index (1 and 2 player game mode)
	 BYTE	  INFDTL-INFDTM	  ;
	 BYTE	  WLDDTM-INFDTM	  ; World,Left data index  (1 and 2 player game mode)
	 BYTE	  WLDDTM-INFDTM	  ; Dummy
	 BYTE	  TIMDTM-INFDTM	  ; Time up data index	   (2 player game mode)
	 BYTE	  TIMDTA-INFDTM	  ; Time up data index	   (1 player game mode)
	 BYTE	  GOVDTM-INFDTM	  ; Game over data index   (2 player game mode)
	 BYTE	  GOVDTA-INFDTM	  ; Game over data index   (1 player game mode)
	 BYTE	  WELDTA-INFDTM	  ; Warp zone data index   (1 and 2 player game mode)
	 BYTE	  WELDTA-INFDTM	  ; Warp zone data index   (1 and 2 player game mode)
;
DATIDX2	  EQU	   $
	 BYTE	  HIGH INFDTM-INFDTM   ; Information data index (1 and 2 player game mode)
	 BYTE	  HIGH INFDTL-INFDTM   ;
	 BYTE	  HIGH WLDDTM-INFDTM   ; World,Left data index	(1 and 2 player game mode)
	 BYTE	  HIGH WLDDTM-INFDTM   ; Dummy
	 BYTE	  HIGH TIMDTM-INFDTM   ; Time up data index	(2 player game mode)
	 BYTE	  HIGH TIMDTA-INFDTM   ; Time up data index	(1 player game mode)
	 BYTE	  HIGH GOVDTM-INFDTM   ; Game over data index	(2 player game mode)
	 BYTE	  HIGH GOVDTA-INFDTM   ; Game over data index	(1 player game mode)
	 BYTE	  HIGH WELDTA-INFDTM   ; Warp zone data index	(1 and 2 player game mode)
	 BYTE	  HIGH WELDTA-INFDTM   ; Warp zone data index	(1 and 2 player game mode)
;
;;;;;;;;;;;;;;;;	HEX	00,00,00,00,00,00,00,01,01,01
;
;#####################################################################
;#		     (A) -- Mode of BG data			     #
;#			    0 : Information BG			     #
;#			    1 : World,Left BG			     #
;#			    2 : Time up BG			     #
;#			    3 : Game over BG			     #
;#			    4 : Warp zone BG - 1		     #
;#			    5 : Warp zone BG - 2		     #
;#			    6 : Warp zone BG - 3		     #
;#	 JSR	  PRMDSP    [ Message display ]			     #
;#####################################################################
PRM015	EQU	$
	 LDA	  PLAYSW		    ; 1 player game mode ?
	 BEQ	  PRM020		    ; no
;
	 INY				    ; set 1 player game mode
	BRA	PRM020
;
PRMDSP	 EQU	  $
	 PHA
	 ASL	  A			    ; A <-- A x 2
	 TAY
;;K;;	CPY	#0
	BEQ	PRM015
	 CPY	  #04H			    ; Time up; , Game over or Warp zoon BG mode ?
	 BCC	  PRM020		    ; no
;
	 CPY	  #08H			    ; Warp zone BG mode ?
	 BCC	  PRM010		    ; no
;
	 LDY	  #08H			    ; set Warp zone BG mode
;
PRM010	 EQU	  $
	 LDA	  PLAYSW		    ; 1 player game mode ?
	 BNE	  PRM020		    ; no
;
	 INY				    ; set 1 player game mode
;
PRM020	EQU	$
	STY	<KWORK0
	LDX	DATIDX,Y		  ; get BG data index
	LDA	CORSNO
	CMP	#08H
	BNE	PRM040
	CPY	#7
	BNE	PRM040
	DEY
	LDX	DATIDX,Y
	STY	<KWORK0
;
PRM040	EQU	$
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	LDA	DATIDX2,Y
	AND	#00FFH
	XBA
	STA	<TWORK2
	TXA
	AND	#00FFH
	ORA	<TWORK2
	TAX
;
	LDY	#0000H
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
PRM045	EQU	$
	 LDA	  INFDTM,X		    ; get BG data
	 CMP	  #0FFH			    ; end of data ?
	 BEQ	  PRM060		    ; yes
;
	STA	VRAMD+2,Y		; put BG data
	INX
	INY
;;K;;	      BNE      PRM040			 ; (JMP)
	BRA	PRM045			; (JMP)
;
PRM060	 EQU	  $
	 LDA	  #0FFH
	 STA	  VRAMD+2,Y		    ; put end code
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	 PLA
	 TAX
	 CMP	  #04H			    ; Warp zone BG mode ?
;;K;;	      BCS      PRM400			 ; yes
	BCC	PRM410
	JMP	PRM400
PRM410	EQU	$
	 DEX				    ; Wold,Left BG mode ?
	 BNE	  PRM080		    ; no
;
AAA	EQU	$
;	LDA	KEYA1
;	BEQ	PRM413
;	LDA	#20H
;	STA	PLCNT
PRM413	EQU	$
	 LDA	  PLCNT			    ; get player left
;;K;;	      CLC
;;K;;	      ADC      #1
	INC	A
	 CMP	  #10
	 BCC	  PRM070
;
	STZ	<YWORK
	STZ	<YWORK1
PRM063	EQU	$
	SEC
	SBC	#100
	BCC	PRM064
	INC	<YWORK
	BRA	PRM063
PRM064	EQU	$
	CLC
	ADC	#100
PRM065	EQU	$
	SEC
	SBC	#10
	BCC	PRM067
	INC	<YWORK1
	BRA	PRM065
PRM067	EQU	$
	CLC
	ADC	#10
	STA	<YWORK2
;;;	LDA	<YWORK1
;;;	CMP	#10
;;;	BCC	PRM068
;;;	SEC
;;;	SBC	#10
	LDY	<YWORK
	BEQ	PRM068
	STY	 VRAMD+2+(CAPADR-WLDDTM)   ; put number of player's high
PRM068	EQU	$
	LDA	<YWORK1
	STA	 VRAMD+2+(LFTADR-WLDDTM)   ; put number of player's high
	LDA	<YWORK2
PRM070	 EQU	  $
	 STA	  VRAMD+2+(LFTADR+2-WLDDTM)   ; put number of player's low
	 LDY	  CORSNO		    ; get Wold no.
	 INY
	 STY	  VRAMD+2+(WLDADR-WLDDTM)   ; put Wold no.
	 LDY	  GOALCT		    ; get Goal no.
	 INY
	 STY	  VRAMD+2+(GOLADR-WLDDTM)   ; put Goal no.
	 RTS
;
PRM080	 EQU	  $
	 LDA	  PLAYSW		    ; 1 player game mode ?
	 BEQ	  PRM200		    ; yes
;
	 LDA	  MRLGFG		    ; get "MARIO" or "LUIGI" mode   -- 0 ; "MARIO"
;									       1 : "LUIGI"
	 DEX				    ; Time up BG mode ?
	 BNE	  PRM090		    ; no
;
	 LDY	  SYMODE		    ; get system mode
	 CPY	  #GVMOD		    ; game over process ?
	 BEQ	  PRM090		    ; yes
	LDA	WPLCNT
	BMI	PRM085
	LDA	MRLGFG
	EOR	#00000001B		; reverse "MARIO" , "LUIGI" mode
	BRA	PRM090
PRM085	EQU	$
	LDA	MRLGFG
;
PRM090	EQU	$
	LSR	A			; player is "MARIO" ?
	BCC	PRM200			; yes
;
	LDY	#09H
	LDA	<KWORK0
	CMP	#04H
	BEQ	PRM100
	CMP	#06H
	BNE	PRM150
;
PRM100	EQU	$
	LDA	LUIGDT,Y		; get "LUIGI" BG data
	STA	VRAMD+6,Y		; put "LUIGI" BG data
	LDA	LUIGDT+0AH,Y
	STA	VRAMD+14H,Y
	DEY				; end of data ?
	BPL	PRM100			; no
	BRA	PRM200
;
PRM150	EQU	$
	LDA	LUIGDT+14H,Y		; get "LUIGI" BG data
	STA	VRAMD+6,Y		; put "LUIGI" BG data
	DEY				; end of data ?
	BPL	PRM150			; no
;
PRM200	EQU	$
	RTS
;
;
PRM400	 EQU	  $
	 PHA
;
	 LDY	  VRAMD
	PHX
	LDX	#0
PRM415	 EQU	  $
	 LDA	  WELDTA,X
	 STA	  VRAMD+2,Y
	INX
	INY
	CMP	#0FFH
	 BNE	  PRM415	  ;data set end ?
;				  ;yes
	PLX
	 PLA
	 SEC
	 SBC	  #10000000B
	 TAX				    ; make Warp zone no. index
	STY	VRAMD
;
PRM420	 EQU	  $
	 LDA	  CORCDT,X		    : get Warp zone no.
;;;;	     STA      VRAMD+2+(CR2ADR-WELDTA)	: put Warp zone no.
	STA	VRAMD+2-9,Y
;
;;;;	     LDA      #(EODADR-WELDTA)		: get number of data
;;;;	STA	VRAMD
	RTS
;
;	  SBC	   #04H
;	  ASL	   A
;	  ASL	   A
;	  TAX				     ; make Warp zone no. index
;	  LDY	   #(CR1ADR-CR1ADR)	     ; get Warp zone no. vramd index
;
;PRM420	  EQU	   $
;	  LDA	   CORCDT,X		     ; get Warp zone no.
;	  STA	   VRAMD+2+(CR1ADR-WELDTA),Y ; put Warp zone no.
;	  INX
;	  INY
;	  INY
;	  INY
;	  INY
;	 INY
;	 INY
;	  CPY	   #(CR3ADR+6-CR1ADR)	     ; end of data set ?
;	  BCC	   PRM420		     ; no
;
;	 MEM16
;	 REP	  #00100000B		; memory 16 bit mode
;
;	  LDA	   #(EODADR-WELDTA)	     ; get number of data;
;	 CLC
;	 ADC	  VRAMD
;	 STA	  VRAMD			; put number of data
;
;	 MEM8
;	 SEP	  #00100000B		; memory 8 bit mode
;
;	 RTS
;
;#####################################################################
;#	 JSR	  MSDSCK    [ Message display time check ]	     #
;#####################################################################
MSDSCK	 EQU	  $
	 LDA	  MSDSTM
	 BNE	  MSDC90    ;- IF  next OK ?  ( NO ; MSDC90 )
;
;;T;;	      JSR      OAMCL0	 ; OAM all clear
;
		LDA	SYMODE
		CMP	#GVMOD
		BEQ	MSDSTS		; Game over ?
;					; no
		LDA	#001H
		STA	!MFFLG		; fade out set
;
;#####################################################################
;#	 JSR	  MSDSTS    [ Messarge display time set ]	     #
;#####################################################################
MSDSTS	 EQU	  $
	 LDA	  #7
	 STA	  MSDSTM
;
	 INC	  BGOTMD
;
MSDC90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#	 JSR	  BGCVST    [ BG convert set ]			     #
;#####################################################################
;
BGCVST		EQU	$
;
		LDA	!PHEDFG
		BNE	MSDC90
;
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16 bit mode
;
		LDY	BGDBPT
		STY	<WORK		; <WORK , <WORK+1 <-- BGDSBF index
;
		LDA	VRWTA0		; BG adress set !
		STA	BGDSBF,Y
		XBA
		STA	GSTAD
;
		LDA	#3D80H		; kazu set
		STA	BGDSBF+2,Y
;
		LDA	#0024H		; nu-ki data set
		STA	BGDSBF+4,Y
		STA	BGDSBF+6,Y
		STA	BGDSBF+8,Y
		STA	BGDSBF+10,Y
;
		IDX8
		MEM8
		SEP	#00110000B	; memory , index 8bit mode
		LDX	#00H
;
		LDA	!GLADFG
		BEQ	BGCV10
		STA	!GLGTFG
		LDA	!VRWTA0
		STA	!STPADH
		LDA	!VRWTA0+1
		INC	A
		STA	!STPADL
;
BGCV10		EQU	$		; BG convert !
		STX	<WORK+2		; <WORK+2 <-- NWFRLD index
;
		LDA	NWFRLD,X	; Convert data table address calc !
		AND	#11000000B
;
		ASL	A
		ROL	A
		ROL	A
		TAY
;
		LDA	BGCDA0,Y
		STA	<WORK+6
;
		LDA	BGCDA1,Y
		STA	<WORK+7
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		TXA
		AND	#00FFH
		TAX
		LDA	NWFRLD,X
		AND	#003FH
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK+3
;
		LDA	NWSTCT
		AND	#0001H
		EOR	#0001H
		ASL	A
		ASL	A
		ADC	<WORK+3
		TAY
;				       < BG convert >
		LDX	<WORK0		; Xr <-- BGDSBF set index
		LDA	(<WORK+6),Y
		STA	BGDSBF+12,X
;
		INY
		INY
;
		LDA	(<WORK+6),Y
		STA	BGDSBF+14,X
;
		INC	<WORK
		INC	<WORK
		INC	<WORK
		INC	<WORK		; INC 4	 BGDSBF set index
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDX	<WORK+2		; Xr <-- NWFRLD index
		INX
		CPX	#NWF1L-NWFRLD+1
		BCS	BGCV40		; IF convert end ? ( NO ; BGCV10 )
		JMP	BGCV10
;
BGCV40		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDY	BGDBPT
;
		LDA	BGDSBF+12,Y
		CMP	#18A2H
		BEQ	YEYR
		CMP	#18A3H
		BNE	YNEYR
YEYR		EQU	$
		STA	BGDSBF+4,Y
		STA	BGDSBF+6,Y
		STA	BGDSBF+8,Y
		STA	BGDSBF+10,Y
;
YNEYR		EQU	$
;
		LDA	<WORK
		CLC
		ADC	#000EH
		TAY
		LDA	#0FFFFH
		STA	BGDSBF,Y	; End corde set
;
		STY	BGDBPT		; Next BG display buffer index calc
;
		LDA	SKYFLG
		AND	#00FFH
		BNE	BGCV50
		LDA	<ENVRFG
		AND	#00FFH
		BEQ	BGCV50
		CMP	#0003H
		BEQ	BGCV50
;
		LDA	BGDSBF-10,Y
		CMP	#086AH
		BEQ	BGCV54
		CMP	#0863H
		BNE	BGCV53
BGCV54		EQU	$
		INC	GSITAL
;
BGCV53		EQU	$
		LDA	BGDSBF-10,Y
		CMP	#0024H
		BEQ	BGCV51
		CMP	#10A4H
		BEQ	BGCV51
		CMP	#0A08H
		BNE	BGCV52
		LDA	GSITAL
		AND	#0FF00H
		STA	GSITAL
		BRA	BGCV52
BGCV51		EQU	$
		LDA	GSITAL
		ORA	#0100H
		STA	GSITAL
BGCV52		EQU	$
		JSL	>GHORE
BGCV50		EQU	$
;
		IDX8
		MEM8
		SEP	#00110000B		; memory , index 8bit mode
;
		INC	VRWTA1			; INC  V-RAM write address
		LDA	VRWTA1
		AND	#1FH
		BNE	BGCV8
;
		STZ	VRWTA1
;
		LDA	VRWTA0
		EOR	#4
		STA	VRWTA0
;
BGCV8		EQU	$
		LDA	#BGGEM
		STA	VRFLG			; VRFLG set
;
		RTS
;
;#####################################################################
;#	 JSR	  BGCRST    [ BG area color display set ]	     #
;#####################################################################
BGCRST	 EQU	  $
	RTS
;
;#####################################################################
;#	 JSR	  BGBLNK		Block BG. blinking.	     #
;#####################################################################
BGBLDT	EQU	$
;	WORD	02FFH,02FFH,02FFH,117AH
;	WORD	14B0H,117AH
;
BGBLNK	EQU	$
;	LDA	<FMCNT
;	AND	#00000111B
;	BNE	BGBRET
;
;	MEM16
;	REP	#00100000B		; memory 16 bit mode
;
;	LDY	BGBLCT
;	LDA	BGBLDT,Y
;	STA	!CGWORK+90H
;
;	MEM8
;	SEP	#00100000B		; memory 8 bit mode
;
;	INC	BGBLCT
;	LDA	BGBLCT
;	CMP	#6
;	BCC	BGBRET
;
;	STZ	BGBLCT
;
;	INC	!CGVMAF
BGBRET	EQU	$
	RTS
;
;#####################################################################
;#	 BG block  erase & again set BG data			     #
;#####################################################################
BGBKCD	EQU	$				; BG block chara No. data !
RTBK	HEX	45,0C,45,0C,47,0C,47,0C		; Return brick-0
	HEX	47,0C,47,0C,47,0C,47,0C		;	 brick-1
	HEX	57,0C,58,0C,59,0C,5A,0C		;	 bonus block
;
BCED	EQU	$
BBED	HEX	24,00,24,00,24,00,24,00		; Coin erase data
BGBC	EQU	$
;
;#####################################################################
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGCOES    [ BG coin erase ]			     #
;#####################################################################
BGCOES	EQU	$
	LDY	VRAMD
	INY
	LDA	#(BBED-BGBKCD)/8
;
BGCE40	EQU	$
	JSR	BGBVSB
;
	LDA	#BGD02
	STA	VRFLG
;
	JMP	BGBV100
;
;#####################################################################
;#		     (X) -- Index ( Display again block )	     #
;#		     (A) -- Set block No.			     #
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGBKST    [ BG Block set ]			     #
;#####################################################################
BGBKST	EQU	$
	JSR	BGBKS0
;
	INC	ABVSCT		; INC  Again block BG VRAMD set counter
	DEC	AGBKSW,X	; DEC	    "      timer
;
BGBK90	EQU	$
;
	RTS
;
;#####################################################################
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGBKES    [ BG Block erase ]			     #
;#####################################################################
BGBKES	EQU	$
	LDA	#0
;
;#####################################################################
;#		     (A) -- Set block No.			     #
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGBKS0    [ BG block set subroutine-0 ]	     #
;#####################################################################
BGBKS0	 EQU	  $
	 LDY	  #(BBED-BGBKCD)/8     ; Erase BG
	 CMP	  #0
	 BEQ	  BGBK70	  ;- IF	 block erase ?	      ( YES ; BGBK70 )
;
	 LDY	  #(RTBK-BGBKCD)/8     ; Return brick-0 ( ground )
	 CMP	  #RBCOS
	 BEQ	  BGBK70	  ;- IF	 repeat coin brick ?  ( YES ; BGBK70 )
;
	 CMP	  #BRIK0
	 BEQ	  BGBK70	  ;- IF	 return brick-0	 ?    ( YES ; BGBK70 )
;
	 INY			       ; Return brick-1 ( underground )
;
	 CMP	  #BRBCS
	 BEQ	  BGBK70	  ;- IF	 repeat coin brick ?  ( YES ; BGBK70 )
;
	 CMP	  #BRIK1
	 BEQ	  BGBK70	  ;- IF	 return brick-1	 ?    ( YES ; BGBK70 )
;
	 INY			       ; Return bonus block
;
BGBK70	 EQU	  $
;#####################################################################
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGBKS1    [ BG block set subroutine-1 ]	     #
;#####################################################################
BGBKS1	 EQU	  $
	 TYA
	 LDY	  VRAMD
	 INY
	 JSR	  BGBVSB	       ; BG Block set sub
;
BGBV100	 EQU	  $
;
	 MEM16
	 REP	  #00100000B		; memory 16 bit mode
;
	 LDA	  VRAMD			; New VRAMD Pointer cala !
	 CLC				;
	 ADC	  #10H			;
	 STA	  VRAMD			;
;
	 MEM8
	 SEP	  #00100000B		; memory 8 bit mode
;
	 RTS
;
;#####################################################################
;#		     (A) -- Set BG data table pointer		     #
;#		     (Y) -- Used V-RAM buffer index		     #
;#		  WORK+2 -- Frame table index			     #
;#		  WORK+6 -- Frame table address (L)		     #
;#		  WORK+7 --			(H)		     #
;#	 JSR	  BGBVSB    [ BG Block V-RAM buffer set sub ]	     #
;#####################################################################
BGBVSB	 EQU	  $
	 STX	  <WORK
	 STY	  <WORK+1
;
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 TAX
;
	 LDY	  #00H		  ; Convert  frame table address to BG address !
	 LDA	  <WORK+6
	 CMP	  #0D0H
	 BCC	  BGBV30
;
	 LDY	  #04H
;
BGBV30	EQU	$
	STY	<WORK+3
;
	AND	#0FH
	ASL	A
	STA	<WORK+4
;
	STZ	<WORK+5
;
	LDA	<WORK+2
	CLC
	ADC	#20H
	ASL	A
	ROL	<WORK+5
;
	ASL	A
	ROL	<WORK+5
;
	ADC	<WORK+4
	STA	<WORK+4
;
	LDA	<WORK+5
	ADC	<WORK+3
	STA	<WORK+5
;
	LDY	<WORK+1
BGBV90	EQU	$
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16 bit mode
;
	TYA
	AND	#00FFH
	TAY
	TXA
	AND	#00FFH
	TAX
;
	LDA	<WORK+4			; BG address set !
	XBA
	STA	VRAMD+1,Y
;
	CLC
	ADC	#2000H
	STA	VRAMD+9,Y
;
	LDA	#0300H			; Set BG status set !
	STA	VRAMD+3,Y
	STA	VRAMD+11,Y
;
	LDA	BGBKCD,X
	STA	VRAMD+5,Y
	LDA	BGBKCD+2,X
	STA	VRAMD+7,Y
;
	LDA	BGBKCD+4,X
	STA	VRAMD+13,Y
	LDA	BGBKCD+6,X
	STA	VRAMD+15,Y
;
	LDA	#0FFFFH			; End corde set !
	STA	VRAMD+17,Y
;
	MEM8
	IDX8
	SEP	#00110000B		; memory , index 8 bit mode
;
	LDX	<WORK
;
	 RTS
;
;
;#####################################################################
;#	 Convert BG data					     #
;#####################################################################
BGCDA0	 EQU	  $
	 BYTE	  (BGCVD0)&0FFH	    ; Area color 00
	 BYTE	  (BGCVD1)&0FFH	    ;	   "     01
	 BYTE	  (BGCVD2)&0FFH	    ;	   "     10
	 BYTE	  (BGCVD3)&0FFH	    ;	   "     11
;
BGCDA1	 EQU	  $
	 BYTE	  (BGCVD0)/100H
	 BYTE	  (BGCVD1)/100H
	 BYTE	  (BGCVD2)/100H
	 BYTE	  (BGCVD3)/100H
;
;< Color 00 >
;
BGCVD0	EQU	$
B0000	WORD	0024H,0024H,0024H,0024H				      ; Thru
B0010	WORD	0027H,0027H,0027H,0027H				      ; Hole-1
	WORD	0024H,09E3H,0024H,0024H,0024H,0024H,0024H,09E0H
B0020	WORD	0024H,0024H,0024H,08D2H,08D0H			      ; Grass-0
	WORD	08D3H,08D1H,08D4H,0024H,08D5H,0024H,0024H
B0060	WORD	0024H,2A20H,0024H,2A20H				      ; Hand rail-0 ( Bridge )
	WORD	0024H,2881H,0024H,2A20H,0024H,2A20H,0024H,2880H
B0080	WORD	0024H,187FH,187FH,0024H				      ; Chain-0
B0090	WORD	08B8H,08BAH,08B9H,08BBH,08B8H,08BCH,08B9H,08BDH	      ; Wood-1
	WORD	08BAH,08BCH,08BBH,08BDH
;K;
B1050	WORD	1204H,1210H,1205H,1211H,1206H,1212H,1205H,1211H	      ; Land pole
	WORD	1206H,1212H,1207H,1213H,1204H,1210H,1207H,1213H
	WORD	1200H,1210H,1201H,1211H,1202H,1212H,1201H,1211H
	WORD	1202H,1212H,1203H,1213H,1200H,1210H,1203H,1213H
;
BC00	EQU	$
;
NB00	EQU	$
B0A10	WORD	0860H,0864H,0861H,0865H,0862H,0866H,0863H,0867H	      ; I-chimney
B0A20	WORD	0860H,0864H,0861H,0865H,0862H,0866H,0863H,0867H	      ; I-chimney
	WORD	0868H,0868H,0869H,0869H,0897H,0897H,086AH,086AH
	WORD	8864H,8860H,8865H,8861H,8866H,8862H,8867H,8863H
B0A30	WORD	104BH,104CH,104DH,104EH,104DH,104FH,104DH,104AH	      ; Land
	WORD	104DH,104EH,1050H,1051H
B0A40	WORD	186BH,1870H,182CH,182DH,186CH,1871H,186DH,1872H	      ; Mushroom
	WORD	186EH,1873H,186FH,1874H,386CH,3871H,386DH,3872H
B0A50	WORD	0886H,088AH,0887H,088BH,0888H,088CH,0888H,088CH	      ; L-chimney
	WORD	0889H,088DH,0869H,0869H,088EH,0891H,088FH,0892H
	WORD	0898H,0893H,0898H,0893H,0890H,0894H,0869H,0869H
B0A60	WORD	1D4AH,1D5AH,1D4BH,1D5BH				      ; Corl
B0A90	WORD	0024H,0024H,0024H,0024H				      ; Dammy data
;
WB00	EQU	$
B0AB0	WORD	0024H,082FH,0024H,083DH				      ; Gole pole
	WORD	18A2H,18A2H,18A3H,18A3H
B0AC0	WORD	0024H,0024H,0024H,0024H				      ; Wood-0
;
;< Color 01 >
;
BGCVD1	EQU	$
B1010	WORD	18A2H,18A2H,18A3H,18A3H				      ; Elv wire-0 ( Vertical )
B1020	WORD	1899H,0024H,1899H,0024H				      ; wire-1 ( Horizotal )
B1030	WORD	0024H,18A2H,183EH,183FH				      ; pulley ( left )
	WORD	185BH,185CH,0024H,18A3H				      ;	       ( right )
B1035	WORD	1024H,1024H,1024H,1024H				      ; wire-2 ( wire color set dammy )
B1060	WORD	1214H,1216H,1215H,1217H				      ; Woody fence
B1070	WORD	0CBEH,0CBEH,0CBFH,0CBFH				      ; Wood-2 ( wood-1 pole )
B1080	WORD	1875H,189FH,1876H,589FH				      ; Mush room pole
	WORD	189FH,189FH,589FH,589FH
;
BC01	EQU	$
B1820	WORD	0C45H,0C47H,0C45H,0C47H				; Brick-0
B1830	WORD	0C47H,0C47H,0C47H,0C47H,0C27H,0C27H,0C27H,0C27H ; Brick-1
	WORD	0C47H,0C47H,0C47H,0C47H
B1870	WORD	0C45H,0C47H,0C45H,0C47H				; Pile up block
B1880	WORD	0A08H,0A18H,0A09H,0A19H,0A0AH,0A1AH,0A0BH,0A1BH ; Ground-0
B18B0	WORD	0C45H,0C47H,0C45H,0C47H				; Mushroom	     in brick-0
B18B8	WORD	0C45H,0C47H,0C45H,0C47H				; Mushroom	     in brick-0
B18C0	WORD	0C45H,0C47H,0C45H,0C47H				; Wood		     in
B18D0	WORD	0C45H,0C47H,0C45H,0C47H				; Super star	     in
B18D4	WORD	0C45H,0C47H,0C45H,0C47H				; Repeat coin	     in
B18D8	WORD	0C45H,0C47H,0C45H,0C47H				; Special mushroom   in
B18E0	WORD	0C47H,0C47H,0C47H,0C47H				; Bonus	  mushroom   in brick-1
B18E8	WORD	0C47H,0C47H,0C47H,0C47H				; Bonus	  mushroom   in brick-1
B18F0	WORD	0C47H,0C47H,0C47H,0C47H				;	  wood	     in
B1900	WORD	0C47H,0C47H,0C47H,0C47H				;	  super star in
B1910	WORD	0C47H,0C47H,0C47H,0C47H				; Repeat  coin	     in
B1920	WORD	0C47H,0C47H,0C47H,0C47H				; Special mushroom   in
B1930	WORD	0024H,0024H,0024H,0024H				; Coin		     in see thru block
B1940	WORD	0024H,0024H,0024H,0024H				; Mushroom	     in
B1950	WORD	0024H,0024H,0024H,0024H				; Mushroom	     in
B1960	WORD	0024H,0024H,0024H,0024H				; Mushroom	     in
B1972	WORD	0024H,0024H,0024H,0024H				; see thru tu-ru
B1973	WORD	0024H,0024H,0024H,0024H				; see thru star
;
NB01	EQU	$
B1A10	WORD	0CABH,0CACH,0CADH,0CAEH					; No break block
B1A55	WORD	09E6H,09F6H,09E7H,09F7H,09E8H,09F8H,09E9H,09F9H		;	   pile up block-3 ( in castle )
	WORD	09E6H,09F6H,09E9H,09F9H,09CAH,09DAH,09CBH,09DBH
	WORD	09EAH,09FAH,09EBH,09FBH,09C6H,09D6H,09C7H,09D7H
	WORD	29CAH,29DAH,29CBH,29DBH
B1A60	WORD	3221H,0024H,3221H,0024H					;	   bridge-0
B1A70	WORD	0E26H,0E28H,0E27H,0E29H					;	   big gun-0
	WORD	0E2AH,0E2CH,0E2BH,0E2DH					;
	WORD	0C2AH,0C2AH,0C40H,0C40H					;
B1A80	WORD	0024H,0024H,0024H,0024H					;	   spring bord ( Dammy )
	WORD	0024H,0C47H,0024H,0C47H					;	   spring bord ( Dammy )
B1A90	WORD	1082H,1084H,1083H,1085H,0916H,0918H,0917H,0919H		;	   rock
	WORD	0918H,0919H,0918H,0919H,3082H,3084H,3083H,3085H		;
	WORD	2916H,2918H,2917H,2919H
B1AA0	WORD	0C24H,0C47H,0C24H,0C47H					;
B1AB0	WORD	0886H,088AH,0887H,088BH,088EH,0891H,088FH,0892H		; Exit chimeny in water
;
WB01	 EQU	  $
B1B00	 WORD	   0024H,002FH,0024H,003DH			       ; Wood-2
;
;< Color 10 >
;
BGCVD2	 EQU	  $	     ;v		  v	      v		  v
B2040	WORD	18ECH,0024H,18EDH,0024H,10C8H,10A4H,10C9H,10A4H
	WORD	38E0H,38E2H,38E1H,38E3H,18EEH,0024H,18EFH,0024H		; Water face
B2050	WORD	10A4H,10A4H,10A4H,10A4H,3896H,3896H,3896H,3896H		; Water
;
BC10	 EQU	  $	     ;|		  |	      |		  |
NB10	 EQU	  $
B2A10	 WORD	   10B0H,10B1H,10B2H,10B3H			       ; Cloud brick
B2A80	 WORD	   0C9BH,0C9DH,0C9CH,0C9EH			       ; Steel bridge
WB10	 EQU	  $
;
;< Color 11 >
;
BGCVD3	EQU	$	   ;v		v	    v		v
B1040	WORD	0E40H,0E50H,0E41H,0E51H,0E42H,0E52H,0E43H,0E53H		; Gole castle
	WORD	0E44H,0E54H,0E45H,0E55H,0E46H,0E56H,0E47H,0E57H		;
	WORD	0E48H,0E58H,0E49H,0E59H,0E4AH,0E5AH,0E4BH,0E5BH		;
	WORD	4E4BH,4E5BH,4E4AH,4E5AH,4E49H,4E59H,4E48H,4E58H		;
	WORD	4E47H,4E57H,4E46H,4E56H,4E45H,4E55H,4E44H,4E54H		;
	WORD	4E43H,4E53H,4E42H,4E52H,4E41H,4E51H,4E40H,4E50H		;
	WORD	0E63H,0E73H,0E5CH,0E66H,0E5DH,0E67H,0E62H,0E72H		;
	WORD	0E72H,0E73H,0E5EH,0E66H,0E5FH,0E67H,0E73H,0E72H		;
	WORD	0024H,0024H,0E60H,0E70H,0E61H,0E71H,0E62H,0E72H		;
	WORD	0E63H,0E73H,0E62H,0E72H,0E63H,0E73H,0E64H,0E74H		;
	WORD	0E65H,0E75H,0024H,0024H,0024H,0024H,0E4CH,0E70H		;
	WORD	0E4DH,0E71H,0E73H,0E72H,0E72H,0E73H,0E73H,0E72H		;
	WORD	0E72H,0E73H,0E4EH,0E74H,0E4FH,0E75H,0024H,0024H		;
	WORD	0E61H,0E66H,0E62H,0E72H,0E63H,0E73H,0E64H,0E67H		;
	WORD	0E72H,0E73H,4E67H,8E66H,4E66H,8E67H,0E73H,0E72H		;
	WORD	0E40H,0E50H,0E44H,0E54H,4E44H,4E54H,4E40H,4E50H		;
	WORD	0E40H,0E50H,0E42H,0E52H,0E43H,0E53H,0E44H,0E54H		;
	WORD	4E44H,4E54H,4E43H,4E53H,4E42H,4E52H,4E40H,4E50H		;
	WORD	0024H,0024H,0CCCH,0CCEH,0CCDH,0CCFH,0024H,0024H		;
	WORD	0CCCH,0CCEH,0CCDH,0CCFH					;
BC11	EQU	$
BBLK	EQU	$
B3810	 WORD	   0453H,0455H,0454H,0456H			       ; Bonus coin	  in block
B3820	 WORD	   0453H,0455H,0454H,0456H			       ;       mushroom	  in
B3830	 WORD	   0453H,0455H,0454H,0456H			       ;       mushroom	  in
B3890	 WORD	   04A5H,04A7H,04A6H,04A8H			       ; Bonus coin
B38A0	 WORD	   04A5H,04A7H,04A6H,04A8H			       ; Bonus coin in water
B38B0	WORD	09EAH,09FAH,09D2H,09E2H,09EAH,09FAH,09F2H,09FBH
	WORD	09F3H,09DAH,09CBH,09DBH,09CAH,09DAH,09C3H,09E2H
B38B5	WORD	09CAH,09DAH,09F0H,09DBH,09D2H,09E1H,09EBH,09FBH
	WORD	09F1H,09FAH,09EBH,09FBH,09C0H,09E1H,09CBH,09DBH
B38C0	WORD	09C8H,09D4H,09C5H,09D5H,09E4H,09F4H,09E5H,09F5H
	WORD	09C8H,09D4H,09C8H,09D4H,09E4H,09F4H,09F4H,09E4H
B38C1	WORD	09CAH,09DAH,09C3H,09D3H,09EAH,09FAH,09D2H,09D2H
B38C2	WORD	09C0H,09D0H,09CBH,09DBH,09D2H,09D2H,09EBH,09FBH
B3880	WORD	2A08H,2A18H,2A09H,2A19H				; Ground-0
;
NB11	 EQU	  $
B3A10	 WORD	   0C57H,0C59H,0C58H,0C5AH			       ; No break return bonus block
B3A90	 WORD	   047BH,047DH,047CH,047EH			       ; Steck
WB11	 EQU	  $
;
;
;#####################################################################
;#	 BG Block corde No.					     #
;#####################################################################
;						 < Color 00 >
HOLE0	 EQU	  (B0000-BGCVD0)/8+00000000B	      ; Hole-0
SKY0	 EQU	  HOLE0				      ; Sky
HOLE1	 EQU	  (B0010-BGCVD0)/8+00000000B	      ; Hole-1
GRS0	 EQU	  (B0020-BGCVD0)/8+00000000B	      ; Grass-0
HNDR0	 EQU	  (B0060-BGCVD0)/8+00000000B	      ; Hand rail-0 ( bridge )
CHIN0	 EQU	  (B0080-BGCVD0)/8+00000000B	      ; Chain-0
WOOD1	 EQU	  (B0090-BGCVD0)/8+00000000B	      ; Wood-1
PUBK1	 EQU	  (B1050-BGCVD0)/8+00000000B	      ; Land pole
;
CHM0	 EQU	  (B0A10-BGCVD0)/8+00000000B	      ; I-chimney ( enter )
CHM2	 EQU	  (B0A20-BGCVD0)/8+00000000B	      ;		  ( no enter )
MUSH0	 EQU	  (B0A40-BGCVD0)/8+00000000B	      ; Mush room -0
LND0	 EQU	  (B0A30-BGCVD0)/8+00000000B	      ; Land-0
CHM1	 EQU	  (B0A50-BGCVD0)/8+00000000B	      ; L-chimney
CORL0	 EQU	  (B0A60-BGCVD0)/8+00000000B	      ; Corl
BKBSW	 EQU	  (B0A90-BGCVD0)/8+00000000B	      ; Dammy data ( Block breack switch )
POLE0	 EQU	  (B0AB0-BGCVD0)/8+00000000B	      ; Gole pole
WOOD0	 EQU	  (B0AC0-BGCVD0)/8+00000000B	      ; Wood-0
;
;						 < Color 01 >
WIRE0	 EQU	  (B1010-BGCVD1)/8+01000000B	      ; Elevatore wire ( Vertical )
WIRE1	 EQU	  (B1020-BGCVD1)/8+01000000B	      ;		  wire ( Vorizotal )
PLY0	 EQU	  (B1030-BGCVD1)/8+01000000B	      ;		  pulley
WIRE2	 EQU	  (B1035-BGCVD1)/8+01000000B	      ;		  wire ( Wire color set dammy )
;K;PUBK1    EQU	     (B1050-BGCVD1)/8+01000000B		 ; Land pole
FENC0	 EQU	  (B1060-BGCVD1)/8+01000000B	      ; Fence-0
WOOD2	 EQU	  (B1070-BGCVD1)/8+01000000B	      ; Pole wood-1
MSHP0	 EQU	  (B1080-BGCVD1)/8+01000000B	      ; Mushroom pole-0
;
BRIK0	 EQU	  (B1820-BGCVD1)/8+01000000B	      ; Brick-0
BRIK1	 EQU	  (B1830-BGCVD1)/8+01000000B	      ; Brick-1
GRND0	 EQU	  (B1880-BGCVD1)/8+01000000B	      ; Ground-0
BKMUS	 EQU	  (B18B0-BGCVD1)/8+01000000B	      ; Mushroom	 in brick-0
BKDET	 EQU	  (B18B8-BGCVD1)/8+01000000B	      : Death Mushroom
BKWOD	 EQU	  (B18C0-BGCVD1)/8+01000000B	      ; Wood		 in
BKSTR	 EQU	  (B18D0-BGCVD1)/8+01000000B	      ; Super star	 in
RBCOS	 EQU	  (B18D4-BGCVD1)/8+01000000B	      ; Repeat	coin	 in
SBMUS	 EQU	  (B18D8-BGCVD1)/8+01000000B	      ; Special mushroom in
BRMUS	 EQU	  (B18E0-BGCVD1)/8+01000000B	      ; Mushroom	 in brick-1
BRDET	 EQU	  (B18E8-BGCVD1)/8+01000000B	      : Death Mushroom
BRWOD	 EQU	  (B18F0-BGCVD1)/8+01000000B	      ; Wood		 in
BRSTR	 EQU	  (B1900-BGCVD1)/8+01000000B	      ; Super star	 in
BRBCS	 EQU	  (B1910-BGCVD1)/8+01000000B	      ; Repeat	coin	 in
BRSMS	 EQU	  (B1920-BGCVD1)/8+01000000B	      ; Special mushroom in
STBCO	 EQU	  (B1930-BGCVD1)/8+01000000B	      ; Coin		 in see thru block
STBMS	 EQU	  (B1940-BGCVD1)/8+01000000B	      ; Mushroom	 in see thru block
;
STBDM	 EQU	  (B1950-BGCVD1)/8+01000000B	      ; Death	mushroom in see thru block
STBSM	 EQU	  (B1960-BGCVD1)/8+01000000B	      ; Bouns	mushroom in see thru block
STRTR	 EQU	  (B1972-BGCVD1)/8+01000000B	      ; see thru tu-ru
STRST	 EQU	  (B1973-BGCVD1)/8+01000000B	      ; see thru star
;
HDBK0	 EQU	  (B1A10-BGCVD1)/8+01000000B	      ; No break hard block
CSWL0	 EQU	  (B1A55-BGCVD1)/8+01000000B	      ;		 castle wall
BRGE0	 EQU	  (B1A60-BGCVD1)/8+01000000B	      ;		 bridge-0
BGUN0	 EQU	  (B1A70-BGCVD1)/8+01000000B	      ;		 big gun-0
SPRIG	 EQU	  (B1A80-BGCVD1)/8+01000000B	      ;		 spring bord
ROCK0	 EQU	  (B1A90-BGCVD1)/8+01000000B	      ;		 rock
SBBK0	 EQU	  (B1AA0-BGCVD1)/8+01000000B	      ;		 brick on spring bord
WCHM0	 EQU	  (B1AB0-BGCVD1)/8+01000000B	      ;		 exit chimney in water
;
WOOD3	 EQU	  (B1B00-BGCVD1)/8+01000000B	      ; Wood-3	( ground --! sky )
;
;						 < Color 10 >
WATR0	 EQU	  (B2040-BGCVD2)/8+10000000B	      ; Water face
WATR1	 EQU	  (B2050-BGCVD2)/8+10000000B	      ; Water
;
CLBK0	 EQU	  (B2A10-BGCVD2)/8+10000000B	      ; No break cloub block
STTL0	 EQU	  (B2A80-BGCVD2)/8+10000000B	      ; Steel bridge
;
;						 < Color 11 >
CAS0	 EQU	  (B1040-BGCVD3)/8+11000000B	      ; Castle
BXCON	 EQU	  (B3810-BGCVD3)/8+11000000B	      ; Bonus coin	 in block
BXMUS	 EQU	  (B3820-BGCVD3)/8+11000000B	      ;	      mushroom	 in
BXDET	 EQU	  (B3830-BGCVD3)/8+11000000B	      ;	      death mushroom   in
COIN0	 EQU	  (B3890-BGCVD3)/8+11000000B	      ; Bonus coin
COIN1	 EQU	  (B38A0-BGCVD3)/8+11000000B	      ;		   in water
CTLTC	EQU	(B38B0-BGCVD3)/8+11000000B
CTRTC	EQU	(B38B5-BGCVD3)/8+11000000B
KIDN	EQU	(B38C0-BGCVD3)/8+11000000B
CUTLT	EQU	(B38C1-BGCVD3)/8+11000000B
CUTRT	EQU	(B38C2-BGCVD3)/8+11000000B
GRNDK	EQU	(B3880-BGCVD3)/8+11000000B		; Glound-0 ;K;
;
BRIK2	 EQU	  (B3A10-BGCVD3)/8+11000000B	      ; No break return bonus block
STEK0	 EQU	  (B3A90-BGCVD3)/8+11000000B	      ; Steck
;
B00CS	 EQU	  (BC00-BGCVD0)/8+00000000B	 ; Cross block table index data !
B01CS	 EQU	  (BC01-BGCVD1)/8+01000000B
B10CS	 EQU	  (BC10-BGCVD2)/8+10000000B
B11CS	 EQU	  (BC11-BGCVD3)/8+11000000B
;
NOBK0	 EQU	  (NB00-BGCVD0)/8+00000000B	 ; No block & Super block index data !
NOBK1	 EQU	  (NB01-BGCVD1)/8+01000000B
NOBK2	 EQU	  (NB10-BGCVD2)/8+10000000B
NOBK3	 EQU	  (NB11-BGCVD3)/8+11000000B
;
THWR0	 EQU	  (WB00-BGCVD0)/8+00000000B	 ; Tuch wire index data !
THWR1	 EQU	  (WB01-BGCVD1)/8+01000000B
THWR2	 EQU	  (WB10-BGCVD2)/8+10000000B
THWR3	 EQU	  (WB11-BGCVD3)/8+11000000B
;
BLNKBK	 EQU	  (BBLK-BGCVD3)/8+11000000B	 ; Blink block table index data !
;
;***********************************************************
;*****	      COMMON SUBROUTIN	   VER.59/12/20	       *****
;***********************************************************
;*********************************************************************
;*		     (A) -- Call subroutine pointer		     *
;*	 JSR	  JSRSUB    [ Subrutine index call ]		     *
;*********************************************************************
JSRSUB	 EQU	  $
	 ASL	  A
	 TAY
	 PLA
	 STA	  <WORK+4
	 PLA
	 STA	  <WORK+5
;
	 INY
	 LDA	  (<WORK+4),Y
	 STA	  <WORK+6
;
	 INY
	 LDA	  (<WORK+4),Y
	 STA	  <WORK+7
	 JMP	  (WORK+6)
;
;
;
;
;
;
;;;;;;;;;*********************************************************************
;;;;;;;;;*	 VRAM 2 page clear			   (VRMCL2)	     *
;;;;;;;;;*********************************************************************
;;;;;;;;VRMCL2		EQU	$
;;;;;;;;;*********************************************************************
;;;;;;;;;*	 VRAM 1 page clear			   (VRMCL1)	     *
;;;;;;;;;*********************************************************************
;;;;;;;;VRMCL1		EQU	$
;;;;;;;;;*********************************************************************
;;;;;;;;;*	 RAM CLEAR [OLD]			   (VCL)	     *
;;;;;;;;;*********************************************************************
;;;;;;;;VCL		EQU	$
;;;;;;;;		PHD			; (D) push
;;;;;;;;;
;;;;;;;;		LDA	#024H		; CRA NO
;;;;;;;;		STA	<WORK
;;;;;;;;		STZ	2115H		;inc mode set
;;;;;;;;;
;;;;;;;;		MEM16
;;;;;;;;		REP	#00100000B
;;;;;;;;;
;;;;;;;;		LDA	#4300H
;;;;;;;;		TCD			; (D) <-- #4300H
;;;;;;;;;
;;;;;;;;		LDA	#0000H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;		LDA	#00001000B+(18H*100H)	;parameter & B bus address
;;;;;;;;		STA	<4300H
;;;;;;;;		STZ	<4302H
;;;;;;;;		STZ	<4304H
;;;;;;;;		LDA	#0800H		;number of byte
;;;;;;;;		STA	<4305H
;;;;;;;;		LDY	#00000001B	;DMA "ON"
;;;;;;;;		STY	420BH
;;;;;;;;;
;;;;;;;;		STA	<4305H
;;;;;;;;		LDA	#0000H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;		SEP	#00100000B
;;;;;;;;;
;;;;;;;;		STZ	WORK		; ATT
;;;;;;;;		LDA	#10000000B	;inc mode set
;;;;;;;;		STA	2115H
;;;;;;;;		LDA	#19H		;B bus address
;;;;;;;;		STA	<4301H
;;;;;;;;		STY	420BH		; BG.1 VCL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;		LDA	#024H		; CRA NO.
;;;;;;;;		STA	WORK
;;;;;;;;		STZ	2115H		;inc mode set
;;;;;;;;;
;;;;;;;;		MEM16
;;;;;;;;		REP	#00100000B
;;;;;;;;;
;;;;;;;;		LDA	#1000H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;		LDA	#00001000B+(18H*100H)	;parameter & B bus address
;;;;;;;;		STA	<4300H
;;;;;;;;		STZ	<4302H
;;;;;;;;		STZ	<4304H
;;;;;;;;		LDA	#0400H		;number of byte
;;;;;;;;		STA	<4305H
;;;;;;;;		STY	420BH
;;;;;;;;;
;;;;;;;;		STA	<4305H
;;;;;;;;		LDA	#1000H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;		SEP	#00100000B
;;;;;;;;;
;;;;;;;;		STZ	WORK		; ATT
;;;;;;;;		LDA	#10000000B	;inc mode set
;;;;;;;;		STA	2115H
;;;;;;;;		LDA	#19H		;B bus address
;;;;;;;;		STA	<4301H
;;;;;;;;		STY	420BH		; BG.2 VCL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;		LDA	#28H		; CRA NO
;;;;;;;;		STA	WORK
;;;;;;;;		STZ	2115H		;inc mode set
;;;;;;;;;
;;;;;;;;		MEM16
;;;;;;;;		REP	#00100000B
;;;;;;;;;
;;;;;;;;		LDA	#5800H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;		LDA	#00001000B+(18H*100H)	;parameter & B bus address
;;;;;;;;		STA	<4300H
;;;;;;;;;;;;	LDA	#WORK		;A bus address
;;;;;;;;		STZ	<4302H
;;;;;;;;		STZ	<4304H
;;;;;;;;		LDA	#0800H		;number of byte
;;;;;;;;		STA	<4305H
;;;;;;;;;;;;	LDY	#00000001B	;DMA "ON"
;;;;;;;;		STY	420BH
;;;;;;;;;
;;;;;;;;		STA	<4305H
;;;;;;;;		LDA	#5800H		;VRAM address set
;;;;;;;;		STA	2116H
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;		SEP	#00100000B
;;;;;;;;;
;;;;;;;;		STZ	WORK		; ATT
;;;;;;;;		LDA	#10000000B	;inc mode set
;;;;;;;;		STA	2115H
;;;;;;;;		LDA	#19H		;B bus address
;;;;;;;;		STA	<4301H
;;;;;;;;		STY	420BH		; BG.3 VCL
;;;;;;;;;
;;;;;;;;		PLD			; (D) pull
;
;
;
;
;
;*********************************************************************
;*	 KEY input [4016H] [4017H]		   (KEYAB)	     *
;*********************************************************************
RDKEY	 EQU	  $
		LDA	4212H
		LSR	A
		BCS	RDKEY		; key read ok ?
;					; yes
	 STZ	  4016H
;
;
KEYSET	EQU	$
		LDA	>P_KEYMD0
		TAX
	 LDA	  4218H,X		  ; 1P contoroler
	 STA	  KEYA1L
	 TAY
	 EOR	  KEYBFL
	 AND	  KEYA1L
	 STA	  KEYA2L		; [X,Y,L,R] key
	 STY	  KEYBFL
;
	 LDA	  4219H,X
	 STA	  KEYA1
	 TAY
	 EOR	  KEYBF
	 AND	  KEYA1
	 STA	  KEYA2		; [A,B,sl,st,u,d,l,r] key
	 STY	  KEYBF
;
;;;;;;;;	 LDA	  421AH			; 2P contoroler
;;;;;;;;	 STA	  KEYA1L+1
;;;;;;;;	 TAY
;;;;;;;;	 EOR	  KEYBFL+1
;;;;;;;;	 AND	  KEYA1L+1
;;;;;;;;	 STA	  KEYA2L+1	; [X,Y,L,R] key
;;;;;;;;	 STY	  KEYBFL+1
;;;;;;;;;
;;;;;;;;	 LDA	  421BH
;;;;;;;;	 STA	  KEYA1+1
;;;;;;;;	 TAY
;;;;;;;;	 EOR	  KEYBFL+2
;;;;;;;;	 AND	  KEYA1+1
;;;;;;;;	 STA	  KEYA2+1	; [A,B,sl,st,u,d,l,r] key
;;;;;;;;	 STY	  KEYBFL+2
;;;;;;;;;\\\\\\\\\\\\\\\	 RTS
;;;;;;;;	LDA	KEYB1
;;;;;;;;	TSB	KEYA1
;;;;;;;;	LDA	KEYB2
;;;;;;;;	TSB	KEYA2
;;;;;;;;	LDA	KEYB1L
;;;;;;;;	TSB	KEYA1L
;;;;;;;;	LDA	KEYB2L
;;;;;;;;	TSB	KEYA2L
;;;;;;;;;
	RTS
;
;
;
;
;****************************************************************
;*	OBJ DMA							*
;****************************************************************
OBJDMA		EQU	$
		STZ	<4300H	;DMA control parameter
;
		MEM16
		REP	#00100000B
;
		STZ	2102H	;OAM address set ( 00~ )
;
		LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
		STA	<4301H
		LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H)	;DMA A bus address(H,B)
		STA	<4303H
		LDA	#0220H		;DMA number of byte
		STA	<4305H
		LDX	#00000001B	;DMA ch "ON"
		STX	420BH
;
		MEM8
		SEP	#00100000B
;
		LDA	#10000000B	;OAM rotation set
		STA	2103H
		STZ	2102H
;;;;;;;;	RTS
;
;****************************************************************
;*	OBJ DMA		Charcter kakikae	;;T;;		*
;****************************************************************
;;;					DMA	SET
;;	LDA	<ENVRFG
;;	CMP	#02
;;	BEQ	DMARET
;;;
		LDA	!PASTEN
		BNE	PASSKI
		JSR	PLCHNG
		LDA	BGWFG2
		BNE	DMARET
		LDA	WRTFLG
		BEQ	DMARET
;;;;;;;;		LDA	#10000000B		;inc mode
;;;;;;;;		STA	2115H
PASSKI		EQU	$
		MEM16
		REP	#20H

		LDA	TMOADR
		STA	2116H			;VRAM address set
		LDA	#00000001B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		LDA	TSAADR			;A bus address
		STA	<4302H
		LDY	TSABNK
		STY	<4304H
		LDA	TENKAZ			;number of byte
		STA	<4305H
;;;;;;;;		LDX	#00000001B		;DMA "ON"
		STX	420BH
		MEM8
		SEP	#20H
		LDA	!PASTEN
		BEQ	DMARET
		DEC	!PASTEN
		BEQ	DMARET
		LDA	TSAADR+1
		CLC
		ADC	#8
		STA	TSAADR+1
		LDA	TMOADR+1
		CLC
		ADC	#4
		STA	TMOADR+1
DMARET		EQU	$
		STZ	BGWFG2
		RTS
;
PLCHNG		EQU	$
		LDA	PLCNFG
		BEQ	PLCRET
;;;;;;;;		LDA	#10000000B		;inc mode
;;;;;;;;		STA	2115H
		MEM16
		REP	#20H

		LDA	WRTADR
		STA	2116H			;VRAM address set
		LDA	#00000001B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		LDA	PLYADR			;A bus address
		STA	<4302H
		LDY	PLYBNK
		STY	<4304H
		LDA	PLYKAZ			;number of byte
		STA	<4305H
;;;;;;;;		LDX	#00000001B		;DMA "ON"
		STX	420BH
		MEM8
		SEP	#20H
PLCRET		EQU	$
		RTS
;
;************************************************************************
;*		Vram write				(VRAMTR)	*
;************************************************************************
;;;;;;;;		LDX	VRFLG	  ; V-RAM <-- BG data !
;;;;;;;;		LDA	BGDTA0,X
;;;;;;;;		STA	<WORK
;;;;;;;;		LDA	BGDTA1,X
;;;;;;;;		STA	<WORK+1
;;;;;;;;		STZ	<WORK2
VRAMTR		EQU	$
		IDX16
		REP	#00010000B	; index 16bit mode
;
;;;;;;;;		STZ	4314H		; data address (B) set
		STZ	<WORK6
;
		LDY	#00000H
VMR050		EQU	$
		LDA	[<WORK0],Y
		BPL	VMR100		; end ?
;					; yes
		SEP	#00110000B	; memory,index 8bit mode
		RTS
;
VMR100		EQU	$
		STA	<WORK4
		INY
		LDA	[<WORK0],Y
		STA	<WORK3
		INY
		LDA	[<WORK0],Y
		AND	#10000000B
		ASL	A
		ROL	A
		STA	<WORK7
;
		LDA	[<WORK0],Y
		AND	#01000000B
		STA	<WORK5
		LSR	A
		LSR	A
		LSR	A
		ORA	#00000001B
		STA	4310H		; inc. mode set
;
		LDA	#018H
		STA	4311H		; B-bus address set
;;;;;;;;;;take
;;;;;;;;		LDA	<WORK2
;;;;;;;;		STA	4314H		; data address bank set
;;;;;;;;;;take
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<WORK3
		STA	2116H		; Vram address set
;
		LDA	[<WORK0],Y
		XBA
		AND	#03FFFH
		TAX
		INX
		STX	4315H		; data count
;
		INY
		INY
		TYA
		CLC
		ADC	<WORK0
		STA	4312H		; data address (L,H) set
;
		LDA	<WORK5
		BEQ	VTR150		; kyotsu ?
;					; yes
		INX
		TXA
		LSR	A
		TAX
		STX	4315H		; data count reset
;
		MEM8
		SEP	#00100000B	; memory 8bit set
;
		LDA	<WORK5
		LSR	A
		LSR	A
		LSR	A
		STA	4310H
;
		LDA	<WORK7
		STA	2115H		; Vram address auto inc.
;
		LDA	#00000010B
		STA	420BH		; DMA ch "ON"
;
;
		LDA	#019H
		STA	4311H		; B-bus address set
;;;;;;;;;;take
;;;;;;;;		LDA	<WORK2
;;;;;;;;		STA	4314H		; data address bank set
;;;;;;;;;;take
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		TYA
;///////		CLC
		ADC	<WORK0
		INC	A
		STA	4312H		; data address (L,H) set
;
		LDA	<WORK3
		STA	2116H		; Vram address set
;
		STX	4315H		; data count
;
		LDX	#0002H
VTR150		EQU	$
		STX	<WORK3
		TYA
		CLC
		ADC	<WORK3
		TAY
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<WORK7
		ORA	#10000000B
		STA	2115H		; VRAM address auto inc.
;
		LDA	#00000010B
		STA	420BH		; DMA ch "ON"
;
		LDA	[<WORK0],Y
;// 03.05.13 //		BPL	VMR100		; end ?
;// 03.05.13 //;					; yes
		BMI	VMR200		; end ?
;					; no
		JMP	VMR100
;
VMR200		EQU	$
		SEP	#00110000B	; memory,index 8bit mode
		RTS
;
;
;
;
		MEM8
		IDX8
;
;;;;;*********************************************************************
;;;;;*	     2000H,CTLR0 set			       (CTLRST)		 *
;;;;;*********************************************************************
;;;;CTLRST   EQU      $
;;;;	     STA      2000H
;;;;	     STA      CTLR0
;;;;	     RTS
;
;*********************************************************************
;*	 SCHEG							     *
;*********************************************************************
SCFORM	 EQU	  $	    ; Score display address data !
	 HEX	  EF,00,06,0	      ; Top.
	 HEX	  62,00,06,0	      ; Player-1
	 HEX	  62,00,06,0	      ; Player-2
	 HEX	  6D,00,02,0	      ; Coin count (player-1)
	 HEX	  6D,00,02,0	      ; Coin point (player-2)
	 HEX	  7A,00,03,0	      ; Timer.
;
DA	 EQU	  $
;		   T P1 P2 C1 C2 TM
;	 (A)	   0  1	 2  3  4  5
	 BYTE	  06,12,12,24,24,36
;
SCHEG	 EQU	  $
	 STA	  <WORK
	 JSR	  SCH
	 LDA	  <WORK
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
SCH	 EQU	  $
;;K;;	      CLC
;;K;;	      ADC      #01H
	INC	A
	 AND	  #0FH
	 CMP	  #06H
	 BCS	  SE020	      ;limit over ?
;			      ;no
	PHA
	ASL	A
	ASL	A
	TAY
	LDA	#58H
	LDX	#20H
	CPY	#00H
	BNE	SE005		; top ?
;				; yes
	LDA	#02H
	LDX	#08H
SE005	EQU	$
	STX	<KWORK6
	LDX	VRAMD
	STA	VRAMD+2,X
	LDA	SCFORM,Y
	STA	VRAMD+3,X
	 LDA	  SCFORM+1,Y
	 STA	  VRAMD+4,X
	 LDA	  SCFORM+2,Y
	 STA	  <WORK+3
	 ASL	  A
	 DEC	  A
	 STA	  VRAMD+5,X
	 STX	  <WORK+2
;
	 PLA
	 TAX
	 LDA	  DA,X
	 SEC
	 SBC	  SCFORM+2,Y
	 TAY
	 LDX	  <WORK+2
SE010	 EQU	  $
	 LDA	  SCORE,Y
	 STA	  VRAMD+6,X
	 LDA	  <KWORK6
	 STA	  VRAMD+7,X
	 INX
	 INX
	 INY
	 DEC	  <WORK+3
	 BNE	  SE010	      ;end ?
;			      ;yes
	 LDA	  #0FFH
	 STA	  VRAMD+6,X
	 INX
	 INX
	 INX
	 INX
;
	 STX	  VRAMD
;
SE020	 EQU	  $
	 RTS
;
;*********************************************************************
;*	 CAINC	  &   CADEC					     *
;*********************************************************************
CAINC	 EQU	  $
	 LDA	  SYMODE
	 CMP	  #TLMOD
	 BEQ	  CA025
;
	 LDX	  #05H
CA010	 EQU	  $
	 LDA	  WPOIN,X
	 CLC
	 ADC	  SCORE,Y
	 BMI	  CA050	      ;
;			      ;
	 CMP	  #0AH
	 BCS	  CA070	      ;
;			      ;
CA020	 EQU	  $
	 STA	  SCORE,Y
	 DEY
	 DEX
	 BPL	  CA010
;
CA025	 EQU	  $
	 LDA	  #00H
	 LDX	  #06H
CA030	 EQU	  $
	 STA	  WPOIN-1,X
	 DEX
	 BPL	  CA030	      ;
;			      ;
	 RTS
;
CA050	 EQU	  $
	 DEC	  WPOIN-1,X
	 LDA	  #09H
	 BNE	  CA020	      ;
;			      ;
CA070	 EQU	  $
	CPX	#0
	BNE	CA075
;
	LDX	#5
	LDA	#9
CA080	EQU	$
	STA	PLYSC1,X
	DEX
	BNE	CA080
	LDA	#0AH*2-1
;
CA075	EQU	$
	 SEC
	 SBC	  #0AH
	 INC	  WPOIN-1,X
	 JMP	  CA020
;
;
;*********************************************************************
;*	 Score compare [new]			   (CMPBE)	     *
;*********************************************************************
CMPBE		EQU	$
		PHD			; (D) push
		LDA	#HIGH SCORE
		XBA
		LDA	#000H
		TCD			; (D) <-- SCORE
;
		LDX	#05H		; 1 player check
;;;;;;;;		JSR	CMPOTP
;;ML		LDA	<MRLGFG
;;ML		BEQ	CMPBE1		; mario ?
;					; no
;;ML		LDX	#0BH		; 2 player check
CMPBE1		EQU	$
CMPOTP		EQU	$		; compare 1 or 2 player , high score store
		LDY	#05H
		SEC
CMP020		EQU	$
		LDA	<SCORE+6,X
		SBC	SCORE,Y
		DEX
		DEY
		BPL	CMP020
;
		BCC	CMPRET		; high score < 1 or 2 player's score ?
		INX			 ; yes
		INY
CMP040		EQU	$
		LDA	<SCORE+6,X
		STA	SCORE,Y		; store new high score
		INX
		INY
		CPY	#06H
		BCC	CMP040
CMPRET		EQU	$
		PLD			; (D) pull
		RTS
;
;
	END
