; 
         INCLUDE  mn_hp_smram.asm
; 
; 
;=========================================================== SMSND ==
		GLB	VRMCLZ,VRMCL2,VRMCL3
		GLB	SNDPORT,HDMAON,HDMAMV
;====================================================================
; 
; 
		ORG	048000H
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
; 
;*********************************************************************
;*       VRAM 2 page clear                         (VRMCLZ)          *
;*********************************************************************
VRMCLZ		EQU	$
		PHD			; (D) push
;
		LDA	#024H		; CRA NO.
		STA	<WORK
		STZ	2115H		;inc mode set
;
		MEM16
		REP	#00100000B
;
		LDA	#4300H
		TCD			; (D) <-- #4300H
;
		LDA	#0800H		;VRAM address set
		STA	2116H
		LDA	#00001000B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		STZ	<4302H
		STZ	<4304H
		LDA	#00400H		;number of byte
		STA	<4305H
		LDY	#00000001B	;DMA "ON"
		STY	420BH
;
		STA	<4305H
		LDA	#0800H		;VRAM address set	
		STA	2116H
;
		STZ	WORK		; ATT 
		LDX	#10000000B	;inc mode set
		STX	2115H
		LDX	#19H		;B bus address
		STX	<4301H
		STY	420BH		; BG.2 VCL
;
;
;
		LDX	#024H		; CRA NO
		STX	WORK
		STZ	2115H		;inc mode set
;
		LDA	#00000H		;VRAM address set
		STA	2116H
		LDA	#00001000B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		STZ	<4302H
		STZ	<4304H
		LDA	#00800H		;number of byte
		STA	<4305H
		STY	420BH
;
		STA	<4305H
		LDA	#0000H		;VRAM address set	
		STA	2116H
;
		STZ	WORK		; ATT 
		LDX	#10000000B	;inc mode set
		STX	2115H
		LDX	#19H		;B bus address
		STX	<4301H
		STY	420BH		; BG.1 VCL
;
;
;
		LDX	#28H		; CRA NO
		STX	WORK
		STZ	2115H		;inc mode set
;
		LDA	#5878H		;VRAM address set
		STA	2116H
		LDA	#00001000B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		STZ	<4302H
		STZ	<4304H
		LDA	#0800H-(078H);;;*2)		;number of byte
		STA	<4305H
		STY	420BH
;
		STA	<4305H
		LDA	#5878H		;VRAM address set	
		STA	2116H
;
		STZ	WORK		; ATT 
		LDX	#10000000B	;inc mode set
		STX	2115H
		LDX	#19H		;B bus address
		STX	<4301H
		STY	420BH		; BG.3 VCL
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		PLD			; (D) pull
		RTL
;
;
;
;*********************************************************************
;*       VRAM 2 page clear                         (VRMCL2)          *
;*********************************************************************
VRMCL2		EQU	$
		LDA	#28H		; CRA NO
		STA	<WORK
		STZ	2115H		;inc mode set
;
		MEM16
		REP	#00100000B
;
		LDA	#5800H		;VRAM address set
		STA	2116H
		LDA	#00001000B+(18H*100H)	;parameter & B bus address
		STA	4300H
		STZ	4302H
		STZ	4304H
		LDA	#0200H		;number of byte
		STA	4305H
		LDY	#00000001B
		STY	420BH
;
		STA	4305H
		LDA	#5800H		;VRAM address set	
		STA	2116H
;
		MEM8
		SEP	#00100000B
;
		STZ	<WORK		; ATT 
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDA	#19H		;B bus address
		STA	4301H
		STY	420BH		; BG.3 VCL
		RTL
;
;
;
;
;*********************************************************************
;*       VRAM 2 page clear                         (VRMCL3)          *
;*********************************************************************
VRMCL3		EQU	$
		PHD			; (D) push
;
		LDA	#027H		; CRA NO
		STA	<WORK
		STZ	2115H		;inc mode set
;
		MEM16
		REP	#00100000B
;
		LDA	#4300H
		TCD			; (D) <-- #4300H
;
		LDA	#0000H		;VRAM address set
		STA	2116H
		LDA	#00001000B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		STZ	<4302H
		STZ	<4304H
		LDA	#0400H		;number of byte
		STA	<4305H
		LDY	#00000001B
		STY	420BH
;
		STA	<4305H
		LDA	#0000H		;VRAM address set	
		STA	2116H
;
		LDX	#00CH
		STX	WORK		; ATT 
		LDX	#10000000B	;inc mode set
		STX	2115H
		LDX	#19H		;B bus address
		STX	<4301H
		STY	<420BH		; BG.1 VCL
;
;
		LDX	#024H		; CRA NO
		STX	WORK
		STZ	2115H		;inc mode set
;
		LDA	#0800H		;VRAM address set
		STA	2116H
		STZ	<4302H
		STZ	<4304H
		LDA	#00400H		;number of byte
		STA	<4305H
		STY	420BH
;
		STA	<4305H
		LDA	#0800H		;VRAM address set	
		STA	2116H
;
		MEM8
		SEP	#00100000B
;
		STZ	WORK		; ATT 
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDA	#19H		;B bus address
		STA	<4301H
		STY	420BH		; BG.2 VCL
;
		PLD			; (D) pull
		RTL
;
;
;
;
;
;*****************************************************************
;*       NMI routine  Sound port set                             *
;*****************************************************************
SNDPORT		EQU	$
;------- sound port set ----------------------------------------------
		LDA	!SOUND2
		BNE	SPORT40		; sound "on" ?
;					; no
		LDY	2142H
		CPY	!SVSND2
		BNE	SPORT80		; transfer ok ?
;					; yes
SPORT40		EQU	$
		STA	2142H
		STA	!SVSND2
		STA	!SOUND2		; sound port set
SPORT80		EQU	$
		LDA	!SOUND0
		STA	2140H
		LDA	!SOUND1
		STA	2141H
		LDA	!SOUND3
		STA	2143H
;
		STZ	!SOUND0
		STZ	!SOUND1
		STZ	!SOUND2
		STZ	!SOUND3
		RTL
; 
; 
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		H-DMA init. set				(HDMAON)	*
;************************************************************************
HDADRTBL	EQU	$			; H-DMA address
		WORD	HDMADR_00-HDMADR_00	; 0 : hiru-Gradation
		WORD	HDMADR_10-HDMADR_00	; 1 : yoru-Gradation
		WORD	HDMADR_20-HDMADR_00	; 2 : water-Gradation
		WORD	HDMADR_30-HDMADR_00	; 3 : KINOKO-Gradation
;
HDDTTBL		EQU	$			; H-DMA data
		WORD	HDMADT_00-HDMADT_00
		WORD	HDMADT_10-HDMADT_00
		WORD	HDMADT_20-HDMADT_00
		WORD	HDMADT_30-HDMADT_00
;
;
HDADRTLE	EQU	$			; H-DMA address end
		WORD	HDMEAR_00-HDMADR_00
		WORD	HDMEAR_10-HDMADR_10
		WORD	HDMEAR_20-HDMADR_20
		WORD	HDMEAR_30-HDMADR_30
;
HDDTTLE		EQU	$			; H-DMA data end
		WORD	HDMAED_00-HDMADT_00
		WORD	HDMAED_10-HDMADT_10
		WORD	HDMAED_20-HDMADT_20
		WORD	HDMAED_30-HDMADT_30
;
;
HDMAON		EQU	$
		STZ	420CH
		STZ	!WD420C		; H-DMA ch "off"
		STZ	!WD212E
		STZ	!WD212F
		STZ	!WD2123
		STZ	!WD2124
		STZ	!WD2125
		STZ	!WD2130
		LDX	#00100000B
		STX	!WD2131		;
		CMP	#0FFH
		BNE	HDMAO00		; H-DMA off ?
;					; yes
		RTL
;
;
HDMAO00		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		STA	<WORK0
		ASL	A
		TAY
		PHY			; (Y) push
		LDA	HDADRTLE,Y
		STA	<WORK1
		LDX	HDADRTBL,Y
		LDY	#000H
HDMAO20		EQU	$
		LDA	HDMADR_00,X
		STA	!HDMADR0,Y
		LDA	HDMADR_01,X
		STA	!HDMADR1,Y
		LDA	HDMADR_02,X
		STA	!HDMADR2,Y
		INX
		INY
		CPY	<WORK1
		BNE	HDMAO20		;
;					;
;
		PLY			; (Y) pull
		LDA	HDDTTLE,Y
		STA	<WORK1
		LDX	HDDTTBL,Y
		LDY	#000H
HDMAO40		EQU	$
		LDA	HDMADT_00,X
		STA	HDMABF0,Y
		LDA	HDMADT_01,X
		STA	HDMABF1,Y
		LDA	HDMADT_02,X
		STA	HDMABF2,Y
		INX
		INY
		CPY	<WORK1
		BNE	HDMAO40		;
;					;
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#03240H
		STX	4350H
		STX	4360H
		STX	4370H		; inc. mode & B-bus address set
;
		LDX	#HDMADR0
		STX	4352H
		LDX	#HDMADR1
		STX	4362H
		LDX	#HDMADR2
		STX	4372H		; A-bus address (L,H)
;
		LDA	#BANK HDMADR0
		STA	4354H
		STA	4364H
		STA	4374H		;               (B)
;
		LDA	#BANK HDMABF0
		STA	4357H
		LDA	#BANK HDMABF1
		STA	4367H
		LDA	#BANK HDMABF2
		STA	4377H		; data bank
;
		LDA	#001H
		STA	!HDMAMVC
;
		LDA	<WORK0
		CMP	#002H
		BNE	HDMAO100	; water ?
;					; yes
		LDX	#02841H
		STX	4340H
		LDX	#HDMADR
		STX	4342H
		LDA	#BANK HDMADR
		STA	4344H
		LDA	#BANK HDMABF
		STA	4347H
;
		LDA	#00010111B
		STA	WD212E
		STZ	WD212F
;
		STZ	WD2123		; window mask (BG2:off , BG1:off )
		STZ	WD2124		;             (BG4:off , BG3:off )
		LDA	#10000000B
		STA	WD2125		;             (COL:on  , OBJ:off )
		LDA	#00010000B
		STA	WD2130
		LDA	#00110011B
		STA	WD2131
;
		LDA	#11110000B
		STA	!WD420C		; H-DMA ch "ON" !!
;
		STZ	!CGWORK
		STZ	!CGWORK+1
		INC	!CGVMAF
;
		SEP	#00010000B	; index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
HDMAO100	EQU	$
		LDA	#11100000B
		STA	!WD420C		; H-DMA ch "ON" !!
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		H-DMA move				(HDMAMV)	*
;************************************************************************
HDMAPTD		EQU	$
;			  0    1    2    3    4    5    6    7
		BYTE	03*0,03*1,03*2,03*3,03*3,03*2,03*1,03*0
;
HDMACTD		EQU	$
		HEX	000C,000C,000C,001C,000C,000C,000C,001C
;
HDMAMVD		EQU	$
		HEX	0001,0001,0001,0001,00FF,00FF,00FF,00FF
;
;
;
HDMAMV		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		DEC	!HDMAMVC
		BNE	HDMMV40		; move ?
;					; yes
		LDX	!HDMAMPT
		LDA	HDMACTD,X
		STA	!HDMAMVC
		LDY	HDMAPTD,X
		LDA	!HDMADR0+3*0,Y
		CLC
		ADC	HDMAMVD,X
		STA	!HDMADR0+3*0,Y
		STA	!HDMADR1+3*0,Y
		STA	!HDMADR2+3*0,Y
;
;
		INX
		TXA
		AND	#00000111B
		STA	!HDMAMPT
HDMMV40		EQU	$
		PLB			; (DBR) reset
		RTL
;
;
;
;
;===============  H-DMA data  =======================================
HDMADR		EQU	$
		BYTE	00000000B+27H
		WORD	HDMABF
		BYTE	00000000B+02H
		WORD	HDMABF+2
		BYTE	00
;
;
;
HDMADR_00	EQU	$
HDMADR_10	EQU	$
HDMADR_30	EQU	$
		BYTE	00000000B+40H
		WORD	HDMABF0
		BYTE	00000000B+08H
		WORD	HDMABF0+1
		BYTE	00000000B+08H
		WORD	HDMABF0+2
		BYTE	00000000B+08H
		WORD	HDMABF0+3
		BYTE	00000000B+06H
		WORD	HDMABF0+4
		BYTE	00000000B+06H
		WORD	HDMABF0+5
		BYTE	00000000B+06H
		WORD	HDMABF0+6
		BYTE	00000000B+06H
		WORD	HDMABF0+7
		BYTE	00000000B+08H
		WORD	HDMABF0+8
		BYTE	00000000B+04H
		WORD	HDMABF0+9
		BYTE	00000000B+04H
		WORD	HDMABF0+10
		BYTE	00000000B+04H
		WORD	HDMABF0+11
		BYTE	00000000B+04H
		WORD	HDMABF0+12
		BYTE	00000000B+04H
		WORD	HDMABF0+13
		BYTE	00000000B+03H
		WORD	HDMABF0+14
		BYTE	00000000B+01H
		WORD	HDMABF0+15
		BYTE	00
HDMEAR_00	EQU	$
HDMEAR_10	EQU	$
HDMEAR_30	EQU	$
;
HDMADR_20	EQU	$
		BYTE	00000000B+20H
		WORD	HDMABF0
		BYTE	00000000B+02H
		WORD	HDMABF0+1
		BYTE	00000000B+02H
		WORD	HDMABF0+2
		BYTE	00000000B+03H
		WORD	HDMABF0+3
		BYTE	00000000B+03H
		WORD	HDMABF0+4
		BYTE	00000000B+04H
		WORD	HDMABF0+5
		BYTE	00000000B+04H
		WORD	HDMABF0+6
		BYTE	00000000B+05H
		WORD	HDMABF0+7
		BYTE	00000000B+06H
		WORD	HDMABF0+8
		BYTE	00000000B+07H
		WORD	HDMABF0+9
		BYTE	00000000B+08H
		WORD	HDMABF0+10
		BYTE	00000000B+09H
		WORD	HDMABF0+11
		BYTE	00000000B+0AH
		WORD	HDMABF0+12
		BYTE	00000000B+0BH
		WORD	HDMABF0+13
		BYTE	00000000B+0CH
		WORD	HDMABF0+14
		BYTE	00000000B+01H
		WORD	HDMABF0+15
		BYTE	00
HDMEAR_20	EQU	$
;
;
HDMADR_01	EQU	$
HDMADR_11	EQU	$
		BYTE	00000000B+40H
		WORD	HDMABF1
		BYTE	00000000B+08H
		WORD	HDMABF1+1
		BYTE	00000000B+08H
		WORD	HDMABF1+2
		BYTE	00000000B+08H
		WORD	HDMABF1+3
		BYTE	00000000B+06H
		WORD	HDMABF1+4
		BYTE	00000000B+06H
		WORD	HDMABF1+5
		BYTE	00000000B+06H
		WORD	HDMABF1+6
		BYTE	00000000B+06H
		WORD	HDMABF1+7
		BYTE	00000000B+08H
		WORD	HDMABF1+8
		BYTE	00000000B+04H
		WORD	HDMABF1+9
		BYTE	00000000B+04H
		WORD	HDMABF1+10
		BYTE	00000000B+04H
		WORD	HDMABF1+11
		BYTE	00000000B+04H
		WORD	HDMABF1+12
		BYTE	00000000B+04H
		WORD	HDMABF1+13
		BYTE	00000000B+03H
		WORD	HDMABF1+14
		BYTE	00000000B+01H
		WORD	HDMABF1+15
		BYTE	00
;
HDMADR_21	EQU	$
		BYTE	00000000B+20H
		WORD	HDMABF1
		BYTE	00000000B+02H
		WORD	HDMABF1+1
		BYTE	00000000B+02H
		WORD	HDMABF1+2
		BYTE	00000000B+03H
		WORD	HDMABF1+3
		BYTE	00000000B+03H
		WORD	HDMABF1+4
		BYTE	00000000B+04H
		WORD	HDMABF1+5
		BYTE	00000000B+04H
		WORD	HDMABF1+6
		BYTE	00000000B+05H
		WORD	HDMABF1+7
		BYTE	00000000B+06H
		WORD	HDMABF1+8
		BYTE	00000000B+07H
		WORD	HDMABF1+9
		BYTE	00000000B+08H
		WORD	HDMABF1+10
		BYTE	00000000B+09H
		WORD	HDMABF1+11
		BYTE	00000000B+0AH
		WORD	HDMABF1+12
		BYTE	00000000B+0BH
		WORD	HDMABF1+13
		BYTE	00000000B+0CH
		WORD	HDMABF1+14
		BYTE	00000000B+01H
		WORD	HDMABF1+15
		BYTE	00
;
;
HDMADR_02	EQU	$
HDMADR_12	EQU	$
		BYTE	00000000B+40H
		WORD	HDMABF2
		BYTE	00000000B+08H
		WORD	HDMABF2+1
		BYTE	00000000B+08H
		WORD	HDMABF2+2
		BYTE	00000000B+08H
		WORD	HDMABF2+3
		BYTE	00000000B+06H
		WORD	HDMABF2+4
		BYTE	00000000B+06H
		WORD	HDMABF2+5
		BYTE	00000000B+06H
		WORD	HDMABF2+6
		BYTE	00000000B+06H
		WORD	HDMABF2+7
		BYTE	00000000B+08H
		WORD	HDMABF2+8
		BYTE	00000000B+04H
		WORD	HDMABF2+9
		BYTE	00000000B+04H
		WORD	HDMABF2+10
		BYTE	00000000B+04H
		WORD	HDMABF2+11
		BYTE	00000000B+04H
		WORD	HDMABF2+12
		BYTE	00000000B+04H
		WORD	HDMABF2+13
		BYTE	00000000B+03H
		WORD	HDMABF2+14
		BYTE	00000000B+01H
		WORD	HDMABF2+15
		BYTE	00
;
HDMADR_22	EQU	$
		BYTE	00000000B+20H
		WORD	HDMABF2
		BYTE	00000000B+02H
		WORD	HDMABF2+1
		BYTE	00000000B+02H
		WORD	HDMABF2+2
		BYTE	00000000B+03H
		WORD	HDMABF2+3
		BYTE	00000000B+03H
		WORD	HDMABF2+4
		BYTE	00000000B+04H
		WORD	HDMABF2+5
		BYTE	00000000B+04H
		WORD	HDMABF2+6
		BYTE	00000000B+05H
		WORD	HDMABF2+7
		BYTE	00000000B+06H
		WORD	HDMABF2+8
		BYTE	00000000B+07H
		WORD	HDMABF2+9
		BYTE	00000000B+08H
		WORD	HDMABF2+10
		BYTE	00000000B+09H
		WORD	HDMABF2+11
		BYTE	00000000B+0AH
		WORD	HDMABF2+12
		BYTE	00000000B+0BH
		WORD	HDMABF2+13
		BYTE	00000000B+0CH
		WORD	HDMABF2+14
		BYTE	00000000B+01H
		WORD	HDMABF2+15
		BYTE	00
;
;
;
;
HDMADT_00	EQU	$		; (R) Hiru-Gradation
;			    0        1        2        3        4        5        6        7
		BYTE	00AH+20H
		BYTE	00BH+20H
		BYTE	00CH+20H
		BYTE	00DH+20H
		BYTE	00EH+20H
		BYTE	00FH+20H
		BYTE	010H+20H
		BYTE	011H+20H
		BYTE	012H+20H
		BYTE	013H+20H
		BYTE	014H+20H
		BYTE	015H+20H
		BYTE	016H+20H
		BYTE	017H+20H
		BYTE	018H+20H
		BYTE	018H+20H
HDMAED_00	EQU	$
;
HDMADT_10	EQU	$		; (R) Yoru-Gradation
;			    0        1        2        3        4        5        6        7
		BYTE	007H+20H
		BYTE	006H+20H
		BYTE	005H+20H
		BYTE	004H+20H
		BYTE	003H+20H
		BYTE	002H+20H
		BYTE	001H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
HDMAED_10	EQU	$
;
HDMADT_20	EQU	$		; (R) Water
		BYTE	018H+20H
		BYTE	00BH+20H
		BYTE	00AH+20H
		BYTE	009H+20H
		BYTE	008H+20H
		BYTE	007H+20H
		BYTE	006H+20H
		BYTE	005H+20H
		BYTE	004H+20H
		BYTE	003H+20H
		BYTE	002H+20H
		BYTE	001H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
		BYTE	000H+20H
HDMAED_20	EQU	$
;
HDMADT_30	EQU	$		; (R) KINOKO-Hiru-Gradation
;			    0        1        2        3        4        5        6        7
		BYTE	01AH+20H
		BYTE	01BH+20H
		BYTE	01CH+20H
		BYTE	01DH+20H
		BYTE	01EH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
		BYTE	01FH+20H
HDMAED_30	EQU	$
;
;
HDMADT_01	EQU	$		; (G)
		BYTE	011H+40H
		BYTE	012H+40H
		BYTE	013H+40H
		BYTE	014H+40H
		BYTE	015H+40H
		BYTE	016H+40H
		BYTE	017H+40H
		BYTE	018H+40H
		BYTE	019H+40H
		BYTE	01AH+40H
		BYTE	01BH+40H
		BYTE	01CH+40H
		BYTE	01DH+40H
		BYTE	01EH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
;
HDMADT_11	EQU	$		; (G)
		BYTE	007H+40H
		BYTE	006H+40H
		BYTE	005H+40H
		BYTE	004H+40H
		BYTE	003H+40H
		BYTE	002H+40H
		BYTE	001H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
		BYTE	000H+40H
;
HDMADT_21	EQU	$		; (G)
		BYTE	01FH+40H
		BYTE	011H+40H
		BYTE	010H+40H
		BYTE	00FH+40H
		BYTE	00EH+40H
		BYTE	00DH+40H
		BYTE	00CH+40H
		BYTE	00BH+40H
		BYTE	00AH+40H
		BYTE	009H+40H
		BYTE	008H+40H
		BYTE	007H+40H
		BYTE	006H+40H
		BYTE	005H+40H
		BYTE	004H+40H
		BYTE	003H+40H
;
HDMADT_31	EQU	$		; (G)
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
		BYTE	01FH+40H
;
;
HDMADT_02	EQU	$		; (B)
		BYTE	014H+80H
		BYTE	015H+80H
		BYTE	016H+80H
		BYTE	017H+80H
		BYTE	018H+80H
		BYTE	019H+80H
		BYTE	01AH+80H
		BYTE	01BH+80H
		BYTE	01CH+80H
		BYTE	01DH+80H
		BYTE	01EH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
;
HDMADT_12	EQU	$		; (B)
		BYTE	00DH+80H
		BYTE	00CH+80H
		BYTE	00BH+80H
		BYTE	00AH+80H
		BYTE	009H+80H
		BYTE	008H+80H
		BYTE	007H+80H
		BYTE	006H+80H
		BYTE	005H+80H
		BYTE	004H+80H
		BYTE	003H+80H
		BYTE	002H+80H
		BYTE	001H+80H
		BYTE	000H+80H
		BYTE	000H+80H
		BYTE	000H+80H
;
HDMADT_22	EQU	$		; (B)
		BYTE	01FH+80H
		BYTE	01CH+80H
		BYTE	01BH+80H
		BYTE	01AH+80H
		BYTE	019H+80H
		BYTE	018H+80H
		BYTE	017H+80H
		BYTE	016H+80H
		BYTE	015H+80H
		BYTE	014H+80H
		BYTE	013H+80H
		BYTE	012H+80H
		BYTE	011H+80H
		BYTE	010H+80H
		BYTE	00FH+80H
		BYTE	00EH+80H
;
HDMADT_32	EQU	$		; (B)
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
		BYTE	01FH+80H
;
;
;
HDMABF		EQU	$
;			      0       1       2       3       4       5       6       7
		HEX	0FF,000
		HEX	000,0FF
;
;
;
;
;
;
                    END
