;
		INCLUDE mn_mario_ram.asm
;
;------------------------------------------------------------------------
;
;		MARIO-COLLECTION	1992.09.01(TUE)
;
;------------------------------------------------------------------------
;
		ORG	0009980H
;
;========================================================================
		GLB	TITLE_INT
		GLB	SELECT2,SELECT3,GSINIT
		GLB	WINDON,WINDOFF,MRPLIX
;
		GLB	FADEPLAY,GMRMST,M4SVCLR
;
;========================================================================
		EXT	DMA_M_M,CGDATA,ROM_ERROR
;
		EXT	PPURINT
;
		EXT	BGM_SNDTR,VOICE_SNDTR,BGM_SNDTR1
;
		EXT	SVDTSU,SVRMCK
;========================================================================
		EXT	MD_demo
;
;========================================================================
R_M_C_M1S	EQU	038170H
R_M_C_M1E	EQU	0381A8H
;
R_M_C_M2S	EQU	0D8182H
R_M_C_M2E	EQU	0D81BAH
;
R_M_C_MU0S	EQU	118032H
R_M_C_MU0E	EQU	11806AH
R_M_C_MU1S	EQU	13E722H
R_M_C_MU1E	EQU	13E75AH
R_M_C_MU2S	EQU	129202H
R_M_C_MU2E	EQU	12923AH
R_M_C_MU3S	EQU	14F929H
R_M_C_MU3E	EQU	14F961H
;
R_M_C_M30S	EQU	208049H
R_M_C_M30E	EQU	208081H
R_M_C_M31S	EQU	20A626H
R_M_C_M31E	EQU	20A65EH
;
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;************************************************************************
;*		Title					(TITLE)		*
;************************************************************************
SELTABLE	EQU	$
		WORD	TTL_000			; 0 : power on init
		WORD	TTL_100			; 1 : fade-in
		WORD	TTL_200			; 2 : obj print
		WORD	TTL_300			; 3 : fade-out & title init.
ttl_500		WORD	TTL_500			; 4 : fade-in
demo		WORD	TTL_1000		; 5 : title demo (shadow:4s)
		WORD	SOUND_WAIT		; 6 : sound-wait
		WORD	SOUND_WAIT		; 7 : sound-wait
		WORD	SOUND_WAIT		; 8 : sound-wait
		WORD	SOUND_WAIT		; 9 : sound-wait
		WORD	SOUND_SET		; A : sound-set
		WORD	TTL_1500		; B : sound-check-0
		WORD	SWICH_OFF		; C : swich-off-check
		WORD	SWICH_ON		; D : swich-on-check
		WORD	SWICH_OFF		; E : swich-off-check
		WORD	SWICH_ON		; F : swich-on-check
		WORD	SWICH_OFF		;10 : swich-off-check
		WORD	SWICH_ON		;11 : swich-on-check
		WORD	SWICH_OFF		;12 : swich-off-check
sndc		WORD	SWICH_ON		;13 : swich-on-check
		WORD	SOUND_WAIT		;14 : sound-wait
		WORD	SOUND_WAIT		;15 : sound-wait
		WORD	SOUND_WAIT		;16 : sound-wait
		WORD	SOUND_WAIT		;17 : sound-wait
		WORD	SOUND_WAIT		;18 : sound-wait
		WORD	TTL_2000		;19 : title demo (shadow:4s)
		WORD	SWICH_OFF_1		;1A : swich-on-check
vsnd		WORD	TTL_3000		;1B : title demo (light:17.5s)
		WORD	TTL_4000		;1C : fade-out
		WORD	TTL_8000		;1D : fade-out
tend		WORD	TTL_END_WAIT		;1E : title wait
		WORD	TTL_END			;1F : title end (game start)
;
t_demo		EQU	(demo-SELTABLE)/2
t_sndc		EQU	(sndc-SELTABLE)/2
t_vsnd		EQU	(vsnd-SELTABLE)/2
t_end		EQU	(tend-SELTABLE)/2
;
;
TITLE_INT	EQU	$
		LDA	<GMMODE
		ASL	A
		TAX
		JSR	(SELTABLE,X)
;
		LDA	<GMMODE
		CMP	#(ttl_500-SELTABLE)/2
		BCC	TTL_I_400		;
;						;
		JSR	NINSET
;
		LDA	<GMMODE
		CMP	#t_demo
		BCC	TTL_I_400		;
;						;
		CMP	#t_end
		BCS	TTL_I_400		;
;						;
		LDA	<KEYA1
		ORA	<KEYB1
		ORA	<KYINFG
		AND	#10H
		STA	<KYINFG
;
		LDA	<KYINFG
		BEQ	TTL_I_400		; title end ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK(light) set
;
		LDA	#00000H
		STA	>CGWORK
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B		; light set
;
		INC	!CGDMAF
;
		JSR	BGCGIT			; BG. reset
;
		LDA	#050H
		STA	<DEMOTIME
		STZ	<DEMOTIME+1
		LDA	#00CH
		STA	<FLSHCT
		STZ	<FLSIDX			; title flash
;
		LDA	#t_end
		STA	<GMMODE
		LDA	#011H
		STA	!SOUND0
		LDA	#029H
		STA	<SOUND3
TTL_I_400	EQU	$
		RTL
;
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Power on init.			(TTL_000)		t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_000		EQU	$
		LDA	#000H
		STA	>ZANMAI_FLG		; zanmai demo flag off
		STZ	<DMTMPT			; demo time data point clear
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGRAM
		STA	>CGWORK
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	!CGDMAF
;
		LDA	#00010000B
		STA	!DPMAIN
		LDA	#00100000B
		STA	!WD2131
;
		STZ	!WD2100
		INC	<GMMODE
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Fade-in					(TTL_100)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_100		EQU	$
		JSR	MARKST			; mark display
		INC	!WD2100
		LDA	!WD2100
		CMP	#00001111B
		BNE	TTL_180			; fade-in end ?
;						; yes
		INC	<GMMODE
TTL_180		EQU	$
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Obj. (coin) display			(TTL_200)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_200		EQU	$
		LDA	<MARKCT
		CMP	#61H
		BNE	TTL_210			;
;						;
		LDA	#1
		STA	<SOUND3
		STA	<FLSEND
		LDA	#2
		STA	<FLSHCT
		STZ	<FLSIDX
TTL_210		EQU	$
		JSR	MARKST			; mark display
		LDA	<FLSEND
		BEQ	TTL_220			;
;						;
		JSR	MRKFLS
TTL_220		EQU	$
		DEC	<MARKCT
		BNE	TTL_180			;
;						;
		INC	<GMMODE
		LDA	#0F0H
		STA	<YSPED0
		STZ	<SPDIDX
;
		BRA	TTL_300
;;;;;;;;;;;;;;;;;;;		   JMP	   TTL_300
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_221	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_M1S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_M1E-R_M_C_M1S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_221		   ; mario-1 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #044H
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_222	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_M2S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_M2E-R_M_C_M2S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_222		   ; mario-2 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #034H
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_223	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_MU0S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_MU0E-R_M_C_MU0S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_223		   ; mario-usa-0 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #0FFH
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_224	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_MU1S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_MU1E-R_M_C_MU1S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_224		   ; mario-usa-1 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #0FFH
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_225	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_MU2S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_MU2E-R_M_C_MU2S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_225		   ; mario-usa-2 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #0FFH
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_226	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_MU3S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_MU3E-R_M_C_MU3S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_226		   ; mario-usa-3 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #0FFH
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_227	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_M30S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_M30E-R_M_C_M30S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_227		   ; mario-3-0 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #0FFH
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_ERR		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDA	   #000H
;;;;;;;;;;;;;;;;;;;		   TAX
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;TTL_228	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >R_M_C_M31S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #R_M_C_M31E-R_M_C_M31S
;;;;;;;;;;;;;;;;;;;		   BNE	   TTL_228		   ; mario-3-1 total end ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   CMP	   #065H
;;;;;;;;;;;;;;;;;;;		   BEQ	   TTL_300		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; no
;;;;;;;;;;;;;;;;;;;TTL_ERR	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   JMP	   ROM_ERROR
;
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Fade-out & title init.			(TTL_300)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_380		EQU	$
		RTS
;
;
TTL_300		EQU	$
;;;;K;;;;		LDA	#30H
;;;;K;;;;		STA	<FLSHCT
		STZ	<FLSHCT
		LDA	#1
		STA	<FLSEND
		JSR	MARKST			; mark display
		DEC	!WD2100
		BNE	TTL_380			; fade-out end ?
;						; yes
		LDA	#10000000B
		STA	02100H
		STA	!WD2100			; blanking on!!
;
		JSR	BGCGIT
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0F800H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGWORK
;
		LDY	#10000000B
		STY	02115H			; inc mode
		LDA	#06000H
		STA	02116H			; Vram address
		LDA	#01801H
		STA	04300H			; B-bus addess & control paramater
		LDA	#028000H
		STA	04302H			; A-bus address (L,H)
		LDY	#BANK 028000H
		STY	04304H			;		(B)
		LDA	#02000H
		STA	04305H			; data count
		LDY	#00000001B
		STY	0420BH			; DMA on!!
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00000010B
		STA	!DPMAIN
		LDA	#00010001B
		STA	!DPSUB
		LDA	#00000010B
		STA	!WD2130
		LDA	#00100000B
		STA	!WD2131
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B
;
;;;;K;;;;		LDA	#00100001B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001001B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010001B
;;;;K;;;;		STA	!WD2132B
;
		LDA	#03EH
		STA	!SOUND0
;
		INC	!CGDMAF
		STZ	!WD2100			; blanking off
;
		INC	<GMMODE
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Fade-in					(TTL_500)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_500		EQU	$
		INC	!WD2100
		LDA	!WD2100
		CMP	#00001111B
		BNE	TTL_580			; fade-in end ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#04000/16+20H
		STA	<DEMOTIME
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	<GMMODE
;
TTL_580		EQU	$
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title demo (shadow)			(TTL_1000)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_1000	EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	<DEMOTIME
		CMP	#00020H
		BCC	TTL_1040		; move ?
;						; yes
		SEP	#00100000B		; memory 8bit mode
;
		JSR	BGCGMN
TTL_1040	EQU	$
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	TTL_1180		; time = 0 ?
;						; yes
		SEP	#00100000B		; memory 8bit mode
;
		JSR	BGCGIT
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK(light) set
;
		LDA	#00000H
		STA	>CGWORK
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B		; light set
;
;;;;K;;;;		LDA	#00100101B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001101B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010101B
;;;;K;;;;		STA	!WD2132B		; light set
;
		INC	!CGDMAF
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#017500/16
		STA	<DEMOTIME
		LSR	A
		CLC
		ADC	#00010H
		STA	!FRASH2
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	<GMMODE
;
		LDA	#011H
		STA	!SOUND0
TTL_1180	EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title demo (light)			(TTL_1500)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_1500	EQU	$
		JSR	TLFLSH
;
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	TTL_1180		; time = 0 ?
;						; yes
		SEP	#00100000B		; memory 8bit mode
;
		JSR	BGCGIT
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0F800H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK(shadow) set
;
		LDA	#00000H
		STA	>CGWORK
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01000000B
		STA	!WD2132G
		LDA	#10011000B
		STA	!WD2132B		; shadow set
;;;;K;;;;		LDA	#00100001B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001001B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010001B
;;;;K;;;;		STA	!WD2132B		; shadow set
;
		INC	!CGDMAF
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00002H
		STA	<DEMOTIME
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	<GMMODE
;
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Swich off check				(SWICH_OFF)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
SWICH_OFF	EQU	$
		JSR	TLFLSH
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	SW_OFF80		; time = 0 ?
;						; yes
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGWORK
;
		LDA	#00004H
		STA	<DEMOTIME
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B
;
;;;;K;;;;		LDA	#00100101B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001101B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010101B
;;;;K;;;;		STA	!WD2132B
;
		INC	!CGDMAF
		INC	<GMMODE
SW_OFF80	EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Swich off check				(SWICH_OFF)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
SWICH_OFF_1	EQU	$
		JSR	BGCGMN			; CG. change
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	SW_OFF_1_80		; time = 0 ?
;						; yes
		LDA	#060H
		STA	<FLSHCT
		STZ	<FLSIDX
		STZ	!CSIDX0
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGWORK
;
		LDA	#01000/16
		STA	<DEMOTIME
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B
;
;;;;K;;;;		LDA	#00100101B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001101B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010101B
;;;;K;;;;		STA	!WD2132B
;
		INC	!CGDMAF
		INC	<GMMODE
SW_OFF_1_80	EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Swich on check				(SWICH_ON)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
SWICH_ON	EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	SW_ON80			; time = 0 ?
;						; yes
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0F800H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGWORK
;
		LDA	#00002H
		LDX	<GMMODE
		CPX	#t_sndc
		BNE	SW_ON40			;
;						;
		LDX	#011H
		STX	!SOUND0
SW_ON40		EQU	$
		STA	<DEMOTIME
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	!CGDMAF
		INC	<GMMODE
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B
;;;;K;;;;		LDA	#00100001B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001001B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010001B
;;;;K;;;;		STA	!WD2132B
SW_ON80		EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title sound wait			(SOUND_WAIT)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
SOUND_SET	EQU	$
		JSR	BGM_SNDTR		; B.G.M. sound transfer
;
		LDA	#001H
		STA	!SOUND2
SOUND_WAIT	EQU	$
		INC	<GMMODE
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title demo (shadow)			(TTL_2000)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_2000	EQU	$
		JSR	BGCGMN
;
		JSR	VOICE_SNDTR		; Voice sound transfer
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#04000/16
		STA	<DEMOTIME
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title demo (light)			(TTL_3000)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_3000	EQU	$
		JSR	TLFLSH
;
		JSR	BGCGMN
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	TTL_3180		; time = 0 ?
;						; yes
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	#0FA00H
		LDY	#007H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>CGWORK
;
		LDA	#00111111B
		STA	!WD2132R
		LDA	#01001100B
		STA	!WD2132G
		LDA	#10000000B
		STA	!WD2132B
;
;;;;K;;;;		LDA	#00100101B
;;;;K;;;;		STA	!WD2132R
;;;;K;;;;		LDA	#01001101B
;;;;K;;;;		STA	!WD2132G
;;;;K;;;;		LDA	#10010101B
;;;;K;;;;		STA	!WD2132B
;
		LDA	#0390H
		STA	<DEMOTIME
		LSR	A
		CLC
		ADC	#00020H
		STA	!FRASH2
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	!CGDMAF
		LDA	#080H
		STA	!FRCT08
		STA	!FRCT32
		STZ	!YOSIDX
;						; yes
		JSR	BGM_SNDTR		; B.G.M. sound transfer
TTL_3180	EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title demo (light)			(TTL_4000)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_4000	EQU	$
		JSR	TLFLSH
		JSR	BGCGMN1
;
		REP	#00100000B		; memory 16bit mode
;
		DEC	<DEMOTIME
		BNE	TTL_4180		; time = 0 ?
;						; yes
		SEP	#00100000B		; memory 8bit mode
;
		INC	<GMMODE
;
		LDA	#080H
		STA	!SOUND2
TTL_4180	EQU	$
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Wait					(TTL_8000)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_8000	EQU	$
		DEC	!WD2100
		BNE	TTL_4180		; fade-out end ?
;						; yes
		LDA	#00000000B
		STA	02100H
		STA	!WD2100			; blanking on!!
;
		JSR	BGM_SNDTR1		; B.G.M. sound transfer
;
		STZ	<GMMODE
		LDA	#MD_demo
		STA	<SLMODE
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title end wait				(TTL_END_WAIT)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
TTL_END_WAIT	EQU	$
		JSR	TLFLSH
;
		DEC	<DEMOTIME
		BNE	TTL_END_W040		; wait end ?
;						; yes
		LDA	#040H
		STA	<SOUND3
		INC	<GMMODE
TTL_END_W040	EQU	$
		RTS
;
;
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Title end				(TTL_END)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
WIPE_CDD	EQU	$
;;;;K;;;;		WORD	09000H+00H*20H,09000H+01H*20H,09000H+02H*20H,09000H+03H*20H
;;;;K;;;;		WORD	09000H+04H*20H,09000H+05H*20H,09000H+06H*20H,09000H+07H*20H
;;;;K;;;;		WORD	09000H+08H*20H,09000H+09H*20H,09000H+0AH*20H,09000H+0BH*20H
;;;;K;;;;		WORD	09000H+0CH*20H,09000H+0DH*20H,09000H+0EH*20H,09000H+0FH*20H
;;;;K;;;;		WORD	09000H+10H*20H,09000H+11H*20H,09000H+12H*20H,09000H+13H*20H
;;;;K;;;;		WORD	09000H+14H*20H,09000H+15H*20H,09000H+16H*20H,09000H+17H*20H
;;;;K;;;;		WORD	09000H+18H*20H,09000H+19H*20H,09000H+1AH*20H,09000H+1BH*20H
;;;;K;;;;		WORD	09000H+1CH*20H,09000H+1DH*20H,09000H+1EH*20H,09000H+1FH*20H
;;;;K;;;;		WORD	09000H+20H*20H,09000H+20H*20H,09000H+20H*20H
		WORD	0E800H+00H*20H,0E800H+01H*20H,0E800H+02H*20H,0E800H+03H*20H
		WORD	0E800H+04H*20H,0E800H+05H*20H,0E800H+06H*20H,0E800H+07H*20H
		WORD	0E800H+08H*20H,0E800H+09H*20H,0E800H+0AH*20H,0E800H+0BH*20H
		WORD	0E800H+0CH*20H,0E800H+0DH*20H,0E800H+0EH*20H,0E800H+0FH*20H
		WORD	0E800H+10H*20H,0E800H+11H*20H,0E800H+12H*20H,0E800H+13H*20H
		WORD	0E800H+14H*20H,0E800H+15H*20H,0E800H+16H*20H,0E800H+17H*20H
		WORD	0E800H+18H*20H,0E800H+19H*20H,0E800H+1AH*20H,0E800H+1BH*20H
		WORD	0E800H+1CH*20H,0E800H+1DH*20H,0E800H+1EH*20H,0E800H+1FH*20H
		WORD	0E800H+20H*20H,0E800H+20H*20H,0E800H+20H*20H
WIPE_CDE	EQU	$
;
;
TTL_END		EQU	$
		LDA	<FCNT
		LSR	A
		BCS	TTL_E80			; wipe move ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDX	<DEMOTIME
		LDA	>WIPE_CDD,X
		STA	<WIPE_ADR
;
		INX
		INX
		STX	<DEMOTIME
		CPX	#WIPE_CDE-WIPE_CDD
		BNE	TTL_E80			; end ?
;						; yes
		INC	<SLMODE
		STZ	<GMMODE
		STZ	<DEMOTIME
		LDA	#10000000B
		STA	!WD2100			; blanking on!!
TTL_E80		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;
;
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
;s		Obj-mark set				(MARKST)	s
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
MARKDT		EQU	$
		HEX	00,02,04,06
		HEX	20,22,24,26
		HEX	08,0A,0C,0E
		HEX	28,2A,2C,2E
		HEX	40,42,44,46
;
;
MARKST		EQU	$
		LDY	#000H
		TYX
		LDA	#50H
		STA	<WORK
MARK20		EQU	$
		LDA	#60H
		STA	<WORK1
MARK30		EQU	$
		LDA	<WORK1
		STA	!OAM+00,Y
		LDA	<WORK
		STA	!OAM+01,Y
		LDA	MARKDT,X
		STA	!OAM+02,Y
		INX
		LDA	#2EH
		STA	!OAM+03,Y
		PHY
		TYA
		LSR	A
		LSR	A
		TAY
		LDA	#2
		STA	!OAMSB,Y
		PLY
		INY
		INY
		INY
		INY
		LDA	<WORK1
		CLC
		ADC	#10H
		STA	<WORK1
		CMP	#0A0H
		BCC	MARK30			;
;						;
		LDA	<WORK
		CLC
		ADC	#10H
		STA	<WORK
		CMP	#0A0H
		BCC	MARK20			;
;						;
		RTS
;
;
;;;;K;;;;MRFDAT		EQU	$
;;;;K;;;;		HEX	02,02,02,02
MRCDT1		EQU	$
		WORD	7FFFH,2BBCH,43FFH
		WORD	171CH,7FFFH,2BBCH
		WORD	171CH,2BBCH,7FFFH
		WORD	0A59H,171CH,2BBCH
MRCDT2		EQU	$
		WORD	53FFH,171CH,0A59H
		WORD	53FFH,171CH,0A59H
		WORD	53FFH,7FFFH,2BBCH
		WORD	53FFH,171CH,0A59H
;
MRKFLS		EQU	$
		LDA	<FLSIDX
		ASL	A
		STA	<WORK
		ASL	A
		CLC
		ADC	<WORK
		TAY			; DATA READ INDEX
;
		LDX	#0
;
MRK100		EQU	$
		LDA	MRCDT1,Y
		STA	>CGWORK+01ECH,X
		LDA	MRCDT2,Y
		STA	>CGWORK+01FAH,X
		INY
		INX
		CPX	#06H
		BCC	MRK100
;
		INC	!CGDMAF
;
		DEC	<FLSHCT
		BNE	MRK500
		INC	<FLSIDX
		LDX	<FLSIDX
		CPX	#4
		BCC	MRK200
		STZ	<FLSIDX
		STZ	<FLSHCT
		STZ	<FLSEND
		BRA	MRK500
MRK200		EQU	$
;;;;K;;;;		LDA	MRFDAT,X
		LDA	#002H
		STA	<FLSHCT
MRK500		EQU	$
		RTS
;
;
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
;s		Obj-(@1993 Nintendo) set		(NINSET)	s
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
NINSET		EQU	$
		LDA	#48H
		STA	<WORK
		LDY	#0
		TYX
;
NIN100		EQU	$
		LDA	<WORK
		STA	!OAM+180H,Y
		LDA	#0C8H
		STA	!OAM+181H,Y
		TYA
		LSR	A
		ORA	#0E0H
		STA	!OAM+182H,Y
		LDA	#22H
		STA	!OAM+183H,Y
		LDA	#2
		STA	!OAMSB2+020H,X
		INY
		INY
		INY
		INY
		LDA	<WORK
		CLC
		ADC	#10H
		STA	<WORK
		INX
		CPX	#7
		BNE	NIN100
;
		PHB
		PHK
		PLB
		IDX16
		REP	#00010000B		; index 16bit mode
		LDA	#074H
		STA	!OAM+00H
		LDA	#03DH
		STA	!OAM+01H
		LDA	#09EH
		STA	!OAM+02H
		LDA	#022H
		STA	!OAM+03H
		LDA	#002H
		STA	!OAMSB
;
		LDY	#004H
		LDX	#001H
		LDA	#OBJXPOS+008H		; "SUPER MARIO"
		STA	<WORK0			;  "ALL*STARS" set
		LDA	#010H
		STA	<WORK1
		LDA	#TILRGD1-TILRGD0
		STA	<WORK2
		LDA	#00AH
		STA	<WORK3
NIN200		EQU	$
		LDA	<WORK0
		STA	!OAM+00H,Y		; X-pos set
		LDA	<WORK1
		STA	!OAM+01H,Y		; Y-pos set
		LDA	TILRGD0,X
		STA	!OAM+02H,Y
		LDA	#020H
		STA	!OAM+03H,Y
		LDA	#002H
		STA	!OAMSB,X
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		INY
		INY
		INY
		INY
		INX
		DEC	<WORK2			; 4 chara mode set end ?
		BEQ	NIN300			;	YES -> NIN300
		DEC	<WORK3			; 1 line end ?
		BNE	NIN200			;	NO -> NIN200
NIN210		EQU	$
		LDA	#OBJXPOS+008H		; next line set
		STA	<WORK0			;
		LDA	<WORK1			;
		CLC				;
		ADC	#010H			;
		STA	<WORK1			;
		LDA	#00BH			;
		STA	<WORK3			;
		BRA	NIN200			;
;
NIN300		EQU	$			; 1 chara mode obj character set
		LDA	#OBJXPOS+008H
		STA	<WORK0
NIN310		EQU	$
		LDA	<WORK0
		STA	!OAM+00H,Y		; X-pos set
		LDA	#040H
		STA	!OAM+01H,Y		; Y-pos set
		LDA	TILRGD0,X
		STA	!OAM+02H,Y
		LDA	#020H
		STA	!OAM+03H,Y
		STZ	!OAMSB,X
		LDA	<WORK0
		CLC
		ADC	#008H
		STA	<WORK0
		INY
		INY
		INY
		INY
		INX
		CPX	#(TILRGD2-TILRGD0)
		BNE	NIN310
;
NIN400		EQU	$			;    "SUPER"
		LDA	#OBJXPOS+040H		; "MARIO WORLD" set
		STA	<WORK0
		LDA	#04CH
		STA	<WORK1
NIN410		EQU	$
		LDA	<WORK0
		STA	!OAM+00H,Y		; X-pos set
		LDA	<WORK1
		STA	!OAM+01H,Y		; Y-pos set
		LDA	TILRGD0,X
		STA	!OAM+02H,Y
		LDA	#022H
		STA	!OAM+03H,Y
		LDA	#002H
		STA	!OAMSB,X
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		INY
		INY
		INY
		INY
		INX
		CPX	#(TILRGD3-TILRGD0)
		BNE	NIN410
;
NIN500		EQU	$
		LDA	#OBJXPOS+010H
		STA	<WORK0
NIN510		EQU	$
		LDA	<WORK0
		STA	!OAM+00H,Y		; X-pos set
		LDA	#05CH
		STA	!OAM+01H,Y		; Y-pos set
		LDA	TILRGD0,X
		STA	!OAM+02H,Y
		LDA	#022H
		STA	!OAM+03H,Y
		LDA	#002H
		STA	!OAMSB,X
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		INY
		INY
		INY
		INY
		INX
		CPX	#(TILRGD4-TILRGD0)
		BNE	NIN510
;
NIN600		EQU	$
		LDA	#OBJXPOS+010H
		STA	<WORK0
		LDA	#0B6H
		STA	<WORK2
		LDA	#006H
		STA	<WORKA
		JSR	NIN610
;
NIN700		EQU	$
		LDA	#OBJXPOS+080H
		STA	<WORK0
		LDA	#0BCH
		STA	<WORK2
		LDA	#004H
		STA	<WORKA
		JSR	NIN610
;
		LDA	#OBJXPOS+0A0H
		STA	!OAM+00H,Y
		STA	!OAM+04H,Y
		STA	!OAM+08H,Y
		LDA	#054H
		STA	!OAM+01H,Y
		STA	!OAM+0DH,Y
		LDA	#07FH
		STA	!OAM+02H,Y
		LDA	#022H
		STA	!OAM+03H,Y
		STA	!OAM+07H,Y
		STA	!OAM+0BH,Y
		STA	!OAM+0FH,Y
		STZ	!OAMSB,X
		STZ	!OAMSB+01H,X
		STZ	!OAMSB+02H,X
		STZ	!OAMSB+03H,X
;
		LDA	#05CH
		STA	!OAM+05H,Y
		LDA	#08FH
		STA	!OAM+06H,Y
;
		LDA	#064H
		STA	!OAM+09H,Y
		LDA	#07EH
		STA	!OAM+0AH,Y
;
		LDA	#OBJXPOS+0A8H
		STA	!OAM+0CH,Y
		LDA	#08EH
		STA	!OAM+0EH,Y
;
		IDX8
		SEP	#00010000B		; index 8bit mode
		PLB
		RTS
;
;
		IDX16
NIN610		EQU	$
		LDA	<WORK0
		STA	!OAM+00H,Y		; X-pos set
		LDA	#054H
		STA	!OAM+01H,Y		; Y-pos set
		LDA	<WORK2
		STA	!OAM+02H,Y
		LDA	#022H
		STA	!OAM+03H,Y
		STZ	!OAMSB,X
		LDA	<WORK0
		CLC
		ADC	#008H
		STA	<WORK0
		INC	<WORK2
		INY
		INY
		INY
		INY
		INX
		DEC	<WORKA
		BNE	NIN610
		RTS
		IDX8
;
;
OBJXPOS		EQU	022H
;
TILRGD0		EQU	$-1
		HEX	000,002,004,006,008,00A,00C,00E,070,072
		HEX	020,022,024,026,028,02A,02C,02E,090,092,094
		HEX	040,042,044,046,048,04A,04C,04E,0B0,0B2,0B4
;
TILRGD1		EQU	$-1
		HEX	060,061,062,063,064,065,066,067,068,069,06A
		HEX	06B,06C,06D,06E,06F,0D0,0D1,0D2,0D3,0D4,084,085
;
TILRGD2		EQU	$
		HEX	076,078,07A,07C
;
TILRGD3		EQU	$
		HEX	0C6,0C8,0CA,096,098,09A,09C,0CC,0CE
;
TILRGD4		EQU	$
;
;
;
;
;
;
;
;************************************************************************
;*		Fade play				(FADEPLAY)	*
;************************************************************************
FADEPLAY	EQU	$
;;;;;;;;		LDA	<FCNT
;;;;;;;;		LSR	A
;;;;;;;;		BCS	FDPL_80			; wipe move ?
;;;;;;;;;						; yes
;;;;;;;;		MEM16
;;;;;;;;		REP	#00100000B		; memory 16bit mode
;;;;;;;;;
;;;;;;;;		LDX	<DEMOTIME
;;;;;;;;		LDA	>WIPE_CDD,X
;;;;;;;;		STA	<WIPE_ADR
;;;;;;;;;
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		STX	<DEMOTIME
;;;;;;;;		CPX	#WIPE_CDE-WIPE_CDD
;;;;;;;;		BNE	FDPL_80			; end ?
;;;;;;;;;						; yes
		DEC	!WD2100
		BNE	FDPL_80			;
;						;
		INC	<SLMODE
		STZ	<GMMODE
		STZ	<DEMOTIME
		LDA	#10000000B
		STA	!WD2100			; blanking on!!
FDPL_80		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTL
;
;
;
;
;
;
;
;************************************************************************
;*		Select-bg-set				(GSINIT)	*
;************************************************************************
GSINIT		EQU	$
		LDA	>PLNOWK
		STA	<PLAYNO
		LDA	>GMNOWK
		STA	<GAMENO
		STA	!SLMRFG
;
		LDX	#001H
		JSL	>PPURINT
;
		JSR	BGM_SNDTR1		; B.G.M. transfer
;
		LDA	#00001111B
		STA	!WD2100			; blanking off
		INC	!CGDMAF
;
		INC	<SLMODE
		STZ	<GMMODE
		LDA	#WIPE_CDE-WIPE_CDD-2
		STA	<DEMOTIME
		STZ	<FCNT
;
		JSR	SLINIT
;
		LDA	#041H
		STA	<SOUND3
;
;
		JMP	SELECT2
;
;
;
SLINIT		EQU	$
		IDX16
		REP	#10H
;
		LDY	#00H
GSI010		EQU	$
		LDA	#0
		XBA
		PHY
		TYA
		ASL	A
		TAY
		LDX	MRPLIX,Y
		PLY
		LDA	>MR1PLA+(m1_world-MR1PLA),X
		BMI	GSI012
		INC	A
GSI012		EQU	$
		STA	WALDDT,Y
		STA	WALDNO,Y
		LDA	>MR1PLA+(m1_world-MR1PLA)+1,X
		BMI	GSI014
		INC	A
GSI014		EQU	$
		STA	<WORK
		TYA
		AND	#00000001B
		BEQ	GSI018
		TYA
		AND	#00000010B
		BNE	GSI018
		LDA	<WORK
		BRA	GSI019
GSI018		EQU	$
		LDA	#0FFH
GSI019		EQU	$
		STA	CORSDT1,Y
		STA	CORSNO,Y
		LDA	>MR1PLA+(m2_warp-MR2PLA),X
		STA	WARPDT,Y
		LDA	>MR1PLA+(m1_ura-MR1PLA),X
		STA	URADAT,Y
		PHX
		TYX
		STA	>URADAT2,X
		PLX
		INY
		CPY	#10H
		BCC	GSI010
;
		IDX8
		SEP	#10H
;
		RTS
;
SLADDT		EQU	$
;;;;K;;;;		WORD	6127H,612DH,6133H,6139H
;;;;K;;;;		WORD	6187H,618DH,6193H,6199H
;;;;K;;;;		WORD	61E7H,61EDH,61F3H,61F9H
;;;;K;;;;		WORD	6247H,624DH,6253H,6259H
;
;
;************************************************************************
;*	select move data						*
;************************************************************************
SLMVDT		EQU	$
		HEX	019H,019H,019H,01DH,01DH
;
;
;************************************************************************
;*		Select-game				(SELECT2)	*
;************************************************************************
;;;;K;;;;SELECT2S	EQU	$
;;;;K;;;;		STZ	<KEYA1
;;;;K;;;;		STZ	<KEYB1
;;;;K;;;;		STZ	<KEYA2
;;;;K;;;;		STZ	<KEYB2
;;;;K;;;;		STZ	<KEYA1L
;;;;K;;;;		STZ	<KEYB1L
;;;;K;;;;		STZ	<KEYA2L
;;;;K;;;;		STZ	<KEYB2L
;
SELECT2		EQU	$
		LDA	<GMMODE
		BNE	SELECT_2		; in ?
;						; yes
		LDA	<FCNT
		LSR	A
		BCS	SEL_2_080		; wipe move ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDX	<DEMOTIME
		LDA	>WIPE_CDD,X
		STA	<WIPE_ADR
;
		DEX
		DEX
		STX	<DEMOTIME
		BPL	SEL_2_080		; end ?
;						; yes
		LDA	#02H
		STA	!SOUND2
;
		INC	<GMMODE
		LDX	#001H
		STX	!SLCHFG			; select character set flag ON
		LDA	#049D800H		; select character
		STA	!SLCHAD			;	address (high,low) set
		STZ	!WD2108
		STZ	!WD210B			; BG.2 screen off
;
;;;;K;;;;		LDA	#00110010B
;;;;K;;;;		STA	<WD2123			; window mask (BG.2 , BG.1)
;;;;K;;;;		STZ	<WD2124			;	      (BG.4 , BG.3)
;;;;K;;;;		LDA	#11000000B
;;;;K;;;;		STA	<WD2125			;	      (Col  , Obj )
;;;;K;;;;		STZ	<WD212E			; window main
;;;;K;;;;		STZ	<WD212F			;	 sub
;
		LDA	#00000001B
		STA	!DPMAIN
		LDA	#00100000B
		STA	<WD2130
		LDA	#01100001B
		STA	<WD2131
;
;;;;K;;;;		LDA	#01000000B
;;;;K;;;;		STA	<WD420C			; window on
SEL_2_080	EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTL
;
SELECT_2	EQU	$
		LDA	!SCHCTR			; right part scroll ?
		BNE	SLCT00			;	YES -> SLCT00
		LDA	!SCHCTL			; left part scroll ?
		BNE	SLCT10			;	YES -> SLCT10
		LDX	!SLONFG			; window disp open ?
		BEQ	SLCT001			;   YES -> SLCT500
		JMP	SLCT500
SLCT001		EQU	$
		LDX	!SLOFFG			; window open ?
		BEQ	SLCT002			;   YES -> SLCT500
		JMP	SLCT500
SLCT002		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00000011B		; right , left key ON ?
		BEQ	SLCT50			;	NO -> SLCT50
		AND	#00000001B
		BEQ	SLCT15
		LDX	!SLMRFG
		LDA	SLMVDT,X
		STA	!SCHCTR
		INC	!SLMRFG
		LDA	#001H
		STA	<SOUND3
		LDA	!SLMRFG
		CMP	#005H
		BNE	SLCT00
		STZ	!SLMRFG
;
SLCT00		EQU	$
		DEC	!SCHCTR			; right move
		BEQ	SLCT50
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	!SCHV10
		CLC
		ADC	#00004H
		AND	#001FFH
		STA	!SCHV10
		MEM8
		SEP	#00100000B		; memory 8bit mode
		BRA	SLCT50
;
SLCT15		EQU	$
		DEC	!SLMRFG
		LDA	!SLMRFG
		AND	#00FH
		CMP	#005H
		BCC	SLCT155
		LDA	#004H
		STA	!SLMRFG
SLCT155		EQU	$
		TAX
		LDA	SLMVDT,X
		STA	!SCHCTL
		LDA	#001H
		STA	<SOUND3
SLCT10		EQU	$
		DEC	!SCHCTL			; left moce
		BEQ	SLCT50
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	!SCHV10
		SEC
		SBC	#00004H
		AND	#001FFH
		STA	!SCHV10
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
SLCT50		EQU	$
		LDA	!SCHCTR
		ORA	!SCHCTL
		BEQ	SLCT500
		JMP	CSLRET			; goto RTL
SLCT500		EQU	$
		STZ	<WORK0
		LDA	!GOGMFG			; game start flag ON ?
		BEQ	SLCT610			;	ON -> SLCT610
		DEC	!SONWAT
		LDA	!SONWAT
		BNE	SLCT605
		LDA	#006H
		STA	<SLMODE
SLCT605		EQU	$
		LDA	!FRCT16			; yo-shi eye move ON ?
		BMI	SLCT608			;	NO -> SLCT608
		DEC	!FRCT16			; yo-shi eye move OK ?
		BNE	SLCT608			;	NO -> SLCT608
		JSR	YSEYE			; yo-shi eye move
SLCT608		EQU	$
		JMP	CSLRET			; goto RTL
;
SLCT610		EQU	$
		LDA	!SLOFFG			; on window ?
		BEQ	SLCT503			;	NO -> SLCT503
		LDA	<KEYA2
		ORA	<KEYB2
		ORA	<KEYA2L
		ORA	<KEYB2L
		AND	#01000000B		; "X","Y" button ON ?
		STA	<WORK0
		BNE	SLCT506			;	YES -> SLCT506
		LDA	!SLONFG			; select disp open ?
		BNE	SLCT506			;	YES -> SLCT506
		BRA	SLCT508
;
SLCT503		EQU	$
		LDA	!SLONFG			; select disp open ?
		BNE	SLCT506			;	YES -> SLCT506
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00010000B		; "START" key ON ?
		STA	<WORK0
		BNE	SLCT505			;   YES -> SLCT505
		BRA	SLCT508
;
SLCT505		EQU	$
		LDA	<WORK0
		PHA
		JSR	SLBFST
		PLA
		STA	<WORK0
SLCT506		EQU	$
		LDA	!SLMRFG
		ASL	A
		TAX
		JSR	(SLCTMR,X)
		JMP	CSLRET			; goto RTL
SLCT508		EQU	$
		LDA	!SLOFFG			; window open --> SLCT600
		BNE	SLCT600			;	close --> RTL
		JMP	CSLRET			; goto RTL
;
;
SLCT600		EQU	$
		LDA	<WORKC
		STA	<WORK			; GAME SELECT NO
		LDA	!SLMRFG
		STA	<GAMENO
;
		LDA	!FRCT16			; yo-shi eye move ON ?
		BMI	SLCT602			;	NO -> SLCT602
		DEC	!FRCT16			; yo-shi eye move OK ?
		BNE	SLCT602			;	NO -> SLCT602
		JSR	YSKCST			; yo-shi ku-chi move
		JMP	CSLRET			; goto RTL
;
SLCT602		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00100000B		; "SELECT" key on ?
		BEQ	SLCT650			;	NO -> SLCT650
		LDA	<GAMENO
		CMP	#004H			; mario world ?
		BNE	SLCT603			;	NO -> SLCT603
		LDA	#02AH
		STA	<SOUND3
		JMP	CSLRET			; goto RTL
SLCT603		EQU	$
		LDA	>KEYMOD
		EOR	#00000001B
		STA	>KEYMOD
		LDA	#1
		STA	<SOUND3
		JSR	BTNSLT
		JMP	CSLRET			; goto RTL
;
SLCT650		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00001100B
		LSR	A
		LSR	A
		TAX
		LDA	<PLAYNO
		CLC
		ADC	CORSDT,X
		AND	#00000011B
		STA	<PLAYNO
		TXY
		BEQ	NTW006
;
		LDA	!SLONFG
		BNE	NTW005
		LDA	!SLOFFG
		BEQ	NTW005
		JSR	CARSOL		; carsol key set
		LDA	#023H
		STA	<SOUND3
		JMP	CSLRET		; goto RTL
NTW005		EQU	$
		LDA	<PLAYNO
;
NTW006		EQU	$
		ASL	A
		ASL	A
		CLC
		ADC	<GAMENO
		STA	<WORK1		; GAME SELECT NO
;
		TAX
;;;;K;;;;		LDA	<GMCLMD		; data clear ?
;;;;K;;;;		BEQ	NTW008		;  NO  -> NTW008
;;;;K;;;;		JMP	CSL200		;  YES -> CSL200
;;;;K;;;;NTW008		EQU	$
		LDA	<GAMENO
		CMP	#004H		; mario 4 ?
		BEQ	NTW008BB	;	YES -> NTW008BB
		LDA	<WALDNO,X
		INC	A		; NEW file ?
		BNE	NTW008BB	;	NO -> NTW008BB
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00010000B	; "START" key ON ?
		BEQ	NTW0085
		JMP	GMGOTO		; GAME START !!
;
NTW0085		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#10000011B
		STA	<WORK0
		LDA	<KEYA2L
		ORA	<KEYB2L
		AND	#10000000B
		ORA	<WORK0
		AND	#10000011B	; "A","B" & left,rtght key on ?
		BEQ	NTW008GG	;	NO  -> NTW008GG
NTWX005		EQU	$
		LDA	#2AH
		STA	<SOUND3
NTW008GG	EQU	$
		JMP	CSLRET		; goto RTL
;
NTW008BB	EQU	$
		TXA
		AND	#00000011B
		CMP	#001H		; mario 2 ?
		BNE	NTWX06		;	NO -> NTWX06
		JMP	NTWOLD		;	YES -> NTWOLD
;
;--------------------------------------- WORLD SELECT
NTWX06		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#10000011B	; "B" & left,rtght key on ?
		STA	<WORK0
		BNE	NTWX07
		JMP	NTCORS		; !NO
;
NTWX07		EQU	$
		LDA	<GAMENO
		AND	#004H		; mario 4 ?
		BNE	NTWX005		;	YES -> NTWX005
		LDA	<WORK0
		AND	#00000010B	; left key ON ?
		BEQ	NTWX075
		JMP	WLDDEC		; goto WLDDEC
NTWX075		EQU	$
		LDA	<WALDNO,X
		CMP	#02H
		BCS	NTWX07X
		LDA	#2AH
		STA	<SOUND3
NTWX07X		EQU	$
		LDA	<GAMENO
		BNE	NTWX10CC
		LDA	>URADAT2,X
		BNE	NTWX10AA
NTWX10CC	EQU	$
		LDA	<WALDDT,X
		CMP	#01H
		BEQ	NTWX10BB
NTWX10AA	EQU	$
		LDA	#04CH
		STA	<SOUND3
NTWX10BB	EQU	$
		INC	<WALDNO,X
		LDA	<GAMENO
		BNE	NTW010ZZ
		LDA	>URADAT2,X	;URA MODE
		BEQ	NTW010ZZ
;
		LDA	<URADAT,X
		BNE	URA100
		LDA	<WALDNO,X
		CMP	#09H
		BCC	SLWDST
		LDA	#1
		STA	<URADAT,X
		STA	<WALDNO,X
		STA	<CORSNO,X
		BRA	SLWDST
;
URA100		EQU	$
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BEQ	NTW015ZX
		BCC	NTW010ZX
		STZ	<URADAT,X
		LDA	#1
NTW010ZX	EQU	$
		STA	<WALDNO,X
		BRA	SLWDST
NTW015ZX	EQU	$
		STA	<WALDNO,X
		LDA	#1
		STA	<CORSNO,X
		BRA	SLWDST
;
NTW010ZZ	EQU	$
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BEQ	NTW015
		BCC	NTW010
		LDA	#1
NTW010		EQU	$
		STA	<WALDNO,X
		BRA	SLWDST
NTW015		EQU	$
		STA	<WALDNO,X
		LDA	#001H
		STA	<CORSNO,X
		LDA	!SLMRFG
		CMP	#001H
		BNE	SLWDST
		JSR	SLCSST		; corse select set
;
SLWDST		EQU	$
		JSR	WRLDST		; world select set
		JMP	NTCORS
;
;--------------------------------------- world dec.
WLDDEC		EQU	$
		LDA	<WALDNO,X
		CMP	#002H
		BCS	WDDC00
		LDA	#02AH
		STA	<SOUND3
WDDC00		EQU	$
		LDA	<GAMENO		; mario 1 ?
		BNE	WDDC03		;	NO -> WDDC03
		LDA	>URADAT2,X
		BNE	WDDC10
WDDC03		EQU	$
		LDA	<WALDDT,X	; select OK ?
		CMP	#001H		;	YES -> WDDC10
		BNE	WDDC10		;  NO ->
		JMP	NTCORS		;	goto RTL
;
WDDC10		EQU	$
		LDA	#04CH
		STA	<SOUND3
		DEC	<WALDNO,X
		LDA	<GAMENO		; mario 1 ?
		BNE	WDDC20		;	NO -> WDDC20
		LDA	>URADAT2,X
		BEQ	WDDC20
		LDA	<WALDNO,X	; nomal corse ?
		BNE	WDDC20		;	NO -> WDDC20
		LDA	<URADAT,X
		BNE	WDDC15
		LDA	>URADAT2,X
		STA	<URADAT,X
		BRA	WDDC20
WDDC15		EQU	$
		STZ	<URADAT,X
		LDA	#008H
		STA	<WALDNO,X
;
WDDC20		EQU	$
		LDA	<WALDNO,X
		BNE	WDDC90
		LDA	<WALDDT,X
		STA	<WALDNO,X
;
WDDC90		EQU	$
		JSR	WRLDST		; world select set
		JMP	NTCORS		; goto RTL
;
;--------------------------------------- COURS SELECT
NTWOLD		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#10000011B	; "B" key ON ?
		BNE	NTW016		;	YES -> NTW016
		JMP	NTCORS
;
NTW016		EQU	$
		LDA	<WALDDT,X
		CMP	#001H
		BEQ	NTW017DD
		BRA	NTW017CC
NTW017DD	EQU	$
		LDA	<CORSDT1,X
		CMP	#1
		BNE	NTW017CC
		LDA	#2AH
		BRA	NTW017BB
NTW017CC	EQU	$
		LDA	#04CH
NTW017BB	EQU	$
		STA	<SOUND3
;
		LDA	<KEYA2
		ORA	<KEYB2
		BMI	NTW017AA
		AND	#00000001B	; right key ON ?
		BNE	NTW017AA
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BNE	NTW0171
		DEC	<CORSNO,X	; corse dec.
		BNE	NTW0170
		DEC	<WALDNO,X	; world dec.
		BEQ	NTW01715
		LDA	#004H
		STA	<CORSNO,X
NTW0170		EQU	$
		BRA	NTW0175
NTW0171		EQU	$
		DEC	<CORSNO,X	; corse dec.
		BNE	NTW0175
		LDA	#004H
		STA	<CORSNO,X
		DEC	<WALDNO,X	; world dec.
		BNE	NTW0175
NTW01715	EQU	$
		LDA	<WALDDT,X
		STA	<WALDNO,X
		LDA	<CORSDT1,X
		STA	<CORSNO,X
NTW0175		EQU	$
		LDA	<WARPDT,X
		BEQ	NTW0178
		LDA	<WALDNO,X
		CMP	#09H
		BNE	NTW0178
		DEC	<WALDNO,X
NTW0178		EQU	$
		JMP	NTW035
;
NTW017AA	EQU	$
		INC	<CORSNO,X		; corse inc.
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BEQ	NTW020
		LDA	<CORSNO,X
		CMP	#005H
		BCC	NTW030
		INC	<WALDNO,X		; world inc.
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BEQ	NTW025
		BCC	NTW025
		BRA	NTW023
NTW020		EQU	$
		LDA	<CORSNO,X
		CMP	<CORSDT1,X
		BEQ	NTW030
		BCC	NTW030
		INC	<WALDNO,X
		LDA	<WALDNO,X
		CMP	<WALDDT,X
		BEQ	NTW030
		BCC	NTW030
NTW023		EQU	$
		LDA	#001H
		STA	<WALDNO,X
NTW025		EQU	$
		LDA	#1
NTW030		EQU	$
		STA	<CORSNO,X
		LDA	<WARPDT,X
		BEQ	NTW035
		LDA	<WALDNO,X
		CMP	#09H
		BNE	NTW035
		INC	<WALDNO,X
NTW035		EQU	$
		JSR	WRLDST		; world select set
		JSR	SLCSST		; corse select set
;
NTCORS		EQU	$
;;;;K;;;;		LDA	#00H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	<WORKF
;;;;K;;;;		STA	<WORK1
;;;;K;;;;		LDA	<PLAYNO
;;;;K;;;;		ASL	A
;;;;K;;;;		ASL	A
;;;;K;;;;		ORA	<GAMENO
;;;;K;;;;		STA	<WORKC
;;;;K;;;;		TAX
;;;;K;;;;		STZ	<WORKD
;;;;K;;;;		ASL	A
;;;;K;;;;		TAY
;;;;K;;;;		LDA	SLADDT,Y
;;;;K;;;;		STA	<WORK2
;;;;K;;;;		LDA	SLADDT+1,Y
;;;;K;;;;		STA	<WORK3
;;;;K;;;;		LDA	<WALDNO,X
;;;;K;;;;		STA	<WORK4
;;;;K;;;;		STZ	<WORK5
;;;;K;;;;		LDA	<CORSNO,X
;;;;K;;;;		STA	<WORK6
;;;;K;;;;		STZ	<WORK7
;;;;K;;;;;
;;;;K;;;;		STX	<INDEX
;;;;K;;;;;
;;;;K;;;;CSL030		EQU	$
		LDA	<KEYA2L
		ORA	<KEYB2L
		AND	#10000000B		; "A" key on ?
		BNE	CSL050
;;;;K;;;;		LDX	<WORKC
;
GMGOTO		EQU	$
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00010000B	; "START" KEY ON?
		BEQ	CSLRET
;
		LDA	#029H		; GAME START !!
		STA	<SOUND3
		STA	!GOGMFG
		LDA	#010H
		STA	!SONWAT
		LDA	#01110000B
		STA	!WD2108
		LDA	#01010000B
		STA	!WD210B		; BG.2 screen(wipe) set
		STZ	<DEMOTIME
		LDA	<GAMENO
		CMP	#004H		; mario world ?
		BNE	CSL070		;	NO -> CSLRET
		JSR	YSEYE		; yo-shi eye move
		BRA	CSLRET
;
CSL050		EQU	$
		LDA	<GAMENO
		CMP	#004H		; mario 4 ?
		BNE	CSL055		;	NO -> CSL055
		LDA	<PLAYNO
		ASL	A
		TAY
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	M4SVIDX,Y
		LDA	>MR4PLA+08DH,X	; "NEW" file ?
		BNE	CSL055		;	NO -> CSL055
		LDA	#02AH
		BRA	CSL058
CSL055		EQU	$
		STZ	!GOGMFG
;;;;K;;;;		LDA	#4
;;;;K;;;;		STA	<GMCLMD
		INC	<SLMODE
		LDA	#022H
CSL058		EQU	$
		STA	<SOUND3
		IDX8
		SEP	#00010000B	; index 8bit mode
;
CSLRET		EQU	$
		RTL
;
;
;
CSL070		EQU	$
		LDA	<PLAYNO
		ASL	A
		ASL	A
		ADC	<GAMENO
		LDA	<WALDNO,X
		INC	A
		BNE	CSL100
		LDA	#0
		STA	>WALDRM
		STA	>CORSRM
		LDA	<GMCLMD
		CMP	#04H
		BNE	CSLFIN
		LDA	#2AH
		STA	<SOUND3
		DEC	<SLMODE
		STZ	<GMCLMD
		BRA	CSLFIN
CSL100		EQU	$
;;;;K;;;;		LDA	<GMCLMD
;;;;K;;;;		CMP	#04H
;;;;K;;;;		BNE	CSL110
;;;;K;;;;		LDA	#22H
;;;;K;;;;		STA	!SOUND3
;;;;K;;;;;
;;;;K;;;;		LDA	#01000000B
;;;;K;;;;		STA	!WD2130		; clear mode on!!
;;;;K;;;;CSL110		EQU	$
		LDA	<WALDNO,X
		DEC	A
		BPL	CSL110A
		LDA	#0
CSL110A		EQU	$
		STA	>WALDRM
		LDA	<CORSNO,X
		DEC	A
		BPL	CSL110B
		LDA	#0
CSL110B		EQU	$
		STA	>CORSRM
CSLFIN		EQU	$
		LDA	<PLAYNO
		ASL	A
		ASL	A
		CLC
		ADC	<GAMENO
		ASL	A
		TAX
		LDA	MRPLIX,X
		STA	>SVINDX
		LDA	MRPLIX+1,X
		STA	>SVINDX+1
		RTL
;
;;;;K;;;;CSL200		EQU	$
;;;;K;;;;		RTL
;;;;K;;;;		LDA	<KEYA2
;;;;K;;;;		ORA	<KEYB2
;;;;K;;;;		AND	#10H
;;;;K;;;;		BEQ	CSL450
;;;;K;;;;		INC	<SLMODE
;;;;K;;;;;
;;;;K;;;;CSL450		EQU	$
;;;;K;;;;;;
;;;;K;;;;		LDA	#00H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	<WORKF
;;;;K;;;;		STA	<WORK1
;;;;K;;;;		LDA	<PLAYNO
;;;;K;;;;		ASL	A
;;;;K;;;;		ASL	A
;;;;K;;;;		ORA	<GAMENO
;;;;K;;;;		STA	<WORKC
;;;;K;;;;		TAX
;;;;K;;;;		STZ	<WORKD
;;;;K;;;;		ASL	A
;;;;K;;;;		TAY
;;;;K;;;;		LDA	SLADDT,Y
;;;;K;;;;		STA	<WORK2
;;;;K;;;;		LDA	SLADDT+1,Y
;;;;K;;;;		STA	<WORK3
;;;;K;;;;		LDA	<WALDNO,X
;;;;K;;;;		STA	<WORK4
;;;;K;;;;		STZ	<WORK5
;;;;K;;;;		LDA	<CORSNO,X
;;;;K;;;;		STA	<WORK6
;;;;K;;;;		STZ	<WORK7
;;;;K;;;;;
;;;;K;;;;		RTL
;
MRPLIX		EQU	$
		WORD	MR1PLA-MR1PLA
		WORD	MR2PLA-MR1PLA
		WORD	MRUPLA-MR1PLA
		WORD	MR3PLA-MR1PLA
		WORD	MR1PLB-MR1PLA
		WORD	MR2PLB-MR1PLA
		WORD	MRUPLB-MR1PLA
		WORD	MR3PLB-MR1PLA
		WORD	MR1PLC-MR1PLA
		WORD	MR2PLC-MR1PLA
		WORD	MRUPLC-MR1PLA
		WORD	MR3PLC-MR1PLA
		WORD	MR1PLD-MR1PLA
		WORD	MR2PLD-MR1PLA
		WORD	MRUPLD-MR1PLA
		WORD	MR3PLD-MR1PLA
;
;
;
SRMCLR		EQU	$		; SAVE RAM CLEAR
		LDA	<PLAYNO
		ASL	A
		ASL	A
		CLC
		ADC	<GAMENO
		ASL	A
		TAX
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	MRPLIX,X
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		TAX
		LDA	#0FFFFH
		STA	>MR1PLA,X
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		JMP	SVRMCK
;
;
;
GMRMST		EQU	$		; GAME RAM SET	(7FFB00H-)
		PHB
		LDA	#BANK SAVERM
		PHA
		PLB
;
		IDX16
		REP	#10H
		LDA	#20H
		STA	<WORKE
		LDA	#1
		STA	<WORKF
;
		LDX	#0
		LDY	SVINDX
GMRM10		EQU	$
		LDA	SAVERM,Y
		STA	>SAVEBF,X
		INY
		INX
		CPX	<WORKE
		BNE	GMRM10
;
		LDA	WALDRM
		STA	>SAVEBF
		LDA	CORSRM
		STA	>SAVEBF+1
;
		LDA	>GMNOWK
		STA	<WORK
		BNE	M1SKIP
;
		LDA	>PLNOWK
		ASL	A
		ASL	A
		ORA	<WORK
		XBA
		LDA	#0
		XBA
		TAX
		LDA	>URADAT2,X
		STA	>SAVEBF+(m1_ura-MR1PLA)
;
M1SKIP		EQU	$
		LDA	#0
		XBA
		LDA	>PLNOWK
		AND	#00000011B
		ASL	A
		ASL	A
		TAX
;
		IDX8
		SEP	#10H
		PLB
		RTL
;
;
;
SLCTMR		EQU	$
		WORD	MARIO1
		WORD	MARIO2
		WORD	MARIOUA
		WORD	MARIO3
		WORD	MARIO4
;
;
;****************************************************************
;*	select initial buffer set				*
;*								*
;****************************************************************
SLBFST		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDX	#080H
		LDA	#002FFH
;
SLBFLP		EQU	$
		STA	!SLCTBF+000H,X
		STA	!SLCTBF+080H,X
		STA	!SLCTBF+100H,X
		STA	!SLCTBF+180H,X
		STA	!SLCTBF+200H,X
		STA	!SLCTBF+280H,X
		STA	!SLCTBF+300H,X
		DEX
		DEX
		BPL	SLBFLP
;
		LDY	<PLAYNO
		LDX	SLDT03,Y
		LDA	#0034FH
		STA	!SLCTBF+0DAH,X
;
		LDX	#000H			; "FILE" set
SLBF00		EQU	$
		LDA	SLDT00,X
		CMP	#0FFFFH
		BEQ	SLBF05
		STA	!SLCTBF+0DCH,X
		STA	!SLCTBF+130H,X
		STA	!SLCTBF+184H,X
		STA	!SLCTBF+1D8H,X
		INX
		INX
		BRA	SLBF00
;
SLBF05		EQU	$
		LDX	#000H
		LDA	#00360H
SLBF10		EQU	$
		STA	!SLCTBF+0BEH,X
		STA	!SLCTBF+112H,X
		STA	!SLCTBF+166H,X
		STA	!SLCTBF+1BAH,X
		INC	A
		INX
		INX
		CPX	#008H
		BNE	SLBF10
;
		IDX16
		REP	#00010000B		; index 16bit mode
		LDX	#00000H
		LDA	#0025AH			; "A"-"D" set
		STA	<WORK0
SLBF20		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+0B8H,X
		LDA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK0
		TXA
		CLC
		ADC	#0002AH
		TAX
		CPX	#00150H
		BNE	SLBF20
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		LDX	#080H
		STX	!FRCT16
		LDA	#049D800H
		STA	!SLCHAD
		LDX	#001H
		STX	!SLCHFG
		LDA	!SLMRFG
		AND	#00004H			; mario world ?
		BEQ	SLBF305			;	NO -> SLBF305
		JSR	SLYSST			; yo-si set
		JMP	SLBF99
;
SLBF305		EQU	$
		LDX	#000H			; "PUSH SELECT BUTTON" set
		LDA	#0038BH
SLBF30		EQU	$
		STA	!SLCTBF+222H,X
		INC	A
		INX
		INX
		CPX	#014H
		BNE	SLBF30
;
		LDX	#000H
SLBF40		EQU	$			; button set
		LDA	SLDT01+000H,X
		STA	!SLCTBF+27CH,X
		LDA	SLDT01+008H,X
		STA	!SLCTBF+2A6H,X
		LDA	SLDT01+010H,X
		STA	!SLCTBF+2D0H,X
		LDA	SLDT01+018H,X
		STA	!SLCTBF+2FAH,X
		INX
		INX
		CPX	#008H
		BNE	SLBF40
;
		LDA	#00368H			; "DUSH" & "JUMP" set
		STA	<WORK0
		LDA	#00378H
		STA	<WORK2
		LDX	#000H
SLBF43		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+284H,X
		STA	!SLCTBF+2CAH,X
		LDA	<WORK2
		STA	!SLCTBF+2AEH,X
		STA	!SLCTBF+302H,X
		INC	<WORK0
		INC	<WORK2
		INX
		INX
		CPX	#006H
		BNE	SLBF43
;
		LDA	#00380H			; "TYPE A" set
		LDX	#000H
SLBF45		EQU	$
		STA	!SLCTBF+322H,X
		INC	A
		INX
		INX
		CPX	#00CH
		BNE	SLBF45
;
		LDA	>KEYMOD
		AND	#000FFH
		BEQ	SLBF48
		LDA	#00368H
		STA	!SLCTBF+302H
		INC	A
		STA	!SLCTBF+304H
		INC	A
		STA	!SLCTBF+306H
		LDA	#00386H
		STA	!SLCTBF+32AH
		INC	A
		STA	!SLCTBF+32CH
;
SLBF48		EQU	$
SLBF99		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
		MEM16
SLYSST		EQU	$			; yo-si set
		STZ	!YOSIDX
		LDA	#049E800H
		STA	!SLCHAD
;
		LDX	#000H
SLYS00		EQU	$
		LDA	SLDT04+000H,X
		STA	!SLCTBF+250H,X
		LDA	SLDT04+00CH,X
		STA	!SLCTBF+27AH,X
		LDA	SLDT04+018H,X
		STA	!SLCTBF+2A4H,X
		LDA	SLDT04+024H,X
		STA	!SLCTBF+2CEH,X
		LDA	SLDT04+030H,X
		STA	!SLCTBF+2F8H,X
		LDA	SLDT04+03CH,X
		STA	!SLCTBF+322H,X
		INX
		INX
		CPX	#(SLDT05-SLDT04)/6
		BNE	SLYS00
;
		RTS
		MEM8
;
;
SLDT00		EQU	$
		WORD	0022AH,0023AH,0024AH,002B0H,002B0H
		WORD	002B0H,00370H,00371H,00372H,00373H
		WORD	0FFFFH
;
SLDT01		EQU	$
		WORD	00364H,00365H,00366H,00367H
		WORD	00374H,00375H,00376H,00377H
		WORD	0036BH,0036CH,0036DH,0036EH
		WORD	0037BH,0037CH,0037DH,0037EH
		WORD	0FFFFH
;
SLDT02		EQU	$
		WORD	00383H,00395H,00396H,00397H,00383H,002FFH
		WORD	00398H,00399H,0039AH,00383H,002FFH,0035FH
;
SLDT03		EQU	$
		HEX	000H,054H,0A8H,0FCH
;
SLDT04		EQU	$
		WORD	002FFH,00364H,00365H,00366H,00367H,002FFH
		WORD	0036AH,00374H,00375H,00376H,00377H,0436AH
		WORD	0037AH,00384H,00385H,00386H,00387H,00378H
		WORD	00379H,0036BH,0036CH,0036DH,0036EH,04379H
		WORD	002FFH,0037BH,0037CH,0037DH,0037EH,002FFH
		WORD	0038FH,00390H,00391H,00392H,00393H,00394H
;
SLDT05		EQU	$
;
;
;********************************************************
;*	yo-shi eye move					*
;*							*
;********************************************************
YSEYE		EQU	$
		LDY	!YOSIDX
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
		LDA	#0DC7EH			; address
		STA	>VRAMD+2,X		;	07EDCH
		LDA	#00400H			; ko-su-u
		STA	>VRAMD+4,X		;	00004H
		LDA	YSEYEDT,Y
		STA	>VRAMD+6,X
		INC	A
		STA	>VRAMD+8,X
		LDA	#0FFFFH
		STA	>VRAMD+10,X
		LDA	>VRAMD
		CLC
		ADC	#00008H
		STA	>VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INC	!YOSIDX
		INC	!YOSIDX
		TYA
		LSR	A
		TAY
		LDA	YSCNT,Y
		STA	!FRCT16
		CMP	#080H
		BNE	EYEPS
		STZ	!YOSIDX
EYEPS		EQU	$
		RTS
;
;
YSEYEDT		EQU	$
		WORD	0038DH,0038BH,00376H
;
YSCNT		EQU	$
		HEX	002H,004H,080H
		HEX	008H,004H,080H
;
;
;********************************************************
;*	yo-shi ku-chi move				*
;*							*
;********************************************************
YSKCST		EQU	$
		LDX	!YOSIDX
		PHB
		LDA	#BANK VRAMD
		PHA
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDY	!VRAMD
		LDA	#0FB7EH			; address
		STA	!VRAMD+2,Y		;	07EFBH
		LDA	#00400H			; ko-su-u
		STA	!VRAMD+4,Y		;	00004H
		LDA	>KCDT00,X
		STA	!VRAMD+6,Y
		LDA	>KCDT10,X
		STA	!VRAMD+8,Y
;
		LDA	#01B7FH			; address
		STA	!VRAMD+0AH,Y		;	07F1BH
		LDA	#00600H			; ko-su-u
		STA	!VRAMD+0CH,Y		;	00006H
		LDA	>KCDT20,X
		STA	!VRAMD+0EH,Y
		LDA	>KCDT30,X
		STA	!VRAMD+10H,Y
		LDA	>KCDT40,X
		STA	!VRAMD+12H,Y
;
		LDA	#03B7FH			; address
		STA	!VRAMD+14H,Y		;	07F3BH
		LDA	#00600H			; ko-su-u
		STA	!VRAMD+16H,Y		;	00006H
		LDA	>KCDT50,X
		STA	!VRAMD+18H,Y
		LDA	>KCDT60,X
		STA	!VRAMD+1AH,Y
		LDA	>KCDT70,X
		STA	!VRAMD+1CH,Y
;
		LDA	#0FFFFH
		STA	!VRAMD+1EH,Y
		LDA	!VRAMD
		CLC
		ADC	#0001CH
		STA	!VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		INC	!YOSIDX
		INC	!YOSIDX
		TXA
		LSR	A
		TAX
		LDA	KCDT80,X
		STA	!FRCT16
		CMP	#080H
		BNE	KCSTPS
		STZ	!YOSIDX
KCSTPS		EQU	$
		RTS
;
KCDT00		EQU	$
		WORD	00385H,00270H,00385H,00385H
;
KCDT10		EQU	$
		WORD	00386H,00259H,00386H,00386H
;
;
KCDT20		EQU	$
		WORD	00368H,00280H,00279H,0036CH
;
KCDT30		EQU	$
		WORD	00369H,00269H,00289H,0036DH
;
KCDT40		EQU	$
		WORD	0039CH,0039CH,0039CH,0036EH
;
;
KCDT50		EQU	$
		WORD	0039DH,0039DH,0039DH,0037CH
;
KCDT60		EQU	$
		WORD	0039EH,0039EH,0039EH,0037DH
;
KCDT70		EQU	$
		WORD	0039FH,0039FH,0039FH,0037EH
;
KCDT80		EQU	$
		HEX	002H,008H,008H,080H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	MARIO 1					+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MARIO1		EQU	$
		LDA	!SLOFFG
		BNE	MR1050
		LDA	!SLONCT
		BNE	MR1000
		LDA	<WORK0
		BNE	MR1003
		LDA	#001H
		STA	!SLOFFG
		STZ	!SLONFG
		JMP	MR1090
;
MR1003		EQU	$			; wind open init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00300H			; "SUPER MARIO" set
		STA	<WORK0
		LDA	#00310H
		STA	<WORK2
		LDX	#000H
MR1005		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+038H,X
		LDA	<WORK2
		STA	!SLCTBF+062H,X
		INC	<WORK0
		INC	<WORK2
		INX
		INX
		CPX	#010H
		BNE	MR1005
		STZ	!SLBFCT
		LDA	#WALDNO
		STA	<WORK0
		JSR	WORLDNO			; world NO ram buffer set
;
		LDA	#MR1PLA+(m1_2play-MR1PLA)
		STA	<WORK0
		LDX	#BANK MR1PLA
		STX	<WORK2
		JSR	PL12ST			; "1p" , "2p" set
;
		LDA	#078E5H
		STA	!SLONAD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#001H
		STA	!SLONFG
		LDA	#015H
		STA	!SLONCT
;
MR1000		EQU	$
		JSR	SLWDOP
		BRA	MR1090
;
MR1050		EQU	$
		LDA	!SLONCT
		BNE	MR1070
		LDA	<WORK0
		BNE	MR1053
		STZ	!SLONFG
		STZ	!SLOFFG
		BRA	MR1090
;
MR1053		EQU	$			; wind close init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#0070AH
		STA	!SLBFCT
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#001H
		STA	!SLONFG
		LDA	#016H
		STA	!SLONCT
;
MR1070		EQU	$
		JSR	SLWDOP2
;
MR1090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	MARIO 2					+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MARIO2		EQU	$
		LDA	!SLOFFG
		BEQ	MR2001
		JMP	MR2050
MR2001		EQU	$
		LDA	!SLONCT
		BNE	MR2000
		LDA	<WORK0
		BNE	MR2003
		LDA	#001H
		STA	!SLOFFG
		STZ	!SLONFG
		JMP	MR2090
;
MR2003		EQU	$
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00300H
		STA	<WORK0
		LDA	#00310H
		STA	<WORK2
		LDX	#000H
MR2005		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+038H,X
		LDA	<WORK2
		STA	!SLCTBF+062H,X
		INC	<WORK0
		INC	<WORK2
		INX
		INX
		CPX	#010H
		BNE	MR2005
		LDX	#000H
		LDA	#001F8H
MR2008		EQU	$
		STA	!SLCTBF+08CH,X
		INC	A
		INX
		INX
		CPX	#010H
		BNE	MR2008
		STZ	!SLBFCT
		LDA	#WALDNO
		INC	A
		STA	<WORK0
		JSR	WLDCOS			; world & corse NO ram buffer set
;
		LDA	#078F1H
		STA	!SLONAD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#001H
		STA	!SLONFG
		LDA	#015H
		STA	!SLONCT
;
MR2000		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#0000FH
		STA	<WORK0			; left count set
		LDA	#00006H
		STA	<WORK2			; right count set
		LDA	#0001EH
		STA	<WORK4
		LDA	#0000CH
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP1
		BRA	MR2090
;
MR2050		EQU	$
		LDA	!SLONCT
		BNE	MR2070
		LDA	<WORK0
		BNE	MR2053
		STZ	!SLONFG
		STZ	!SLOFFG
		BRA	MR2090
;
MR2053		EQU	$			; window close init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00722H
		STA	!SLBFCT
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#001H
		STA	!SLONFG
		LDA	#016H
		STA	!SLONCT
;
MR2070		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#0000FH
		STA	<WORK0			; left count set
		LDA	#00006H
		STA	<WORK2			; right count set
		LDA	#0001EH
		STA	<WORK4
		LDA	#0000CH
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP3
;
MR2090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	MARIO USA				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MARIOUA		EQU	$
		LDA	!SLOFFG
		BEQ	MRU001
		JMP	MRU050
MRU001		EQU	$
		LDA	!SLONCT
		BNE	MRU000
		LDA	<WORK0
		BNE	MRU003
		LDA	#001H
		STA	!SLOFFG
		STZ	!SLONFG
		JMP	MRU090
;
MRU003		EQU	$			; wind open init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00300H
		STA	<WORK0
		LDA	#00310H
		STA	<WORK2
		LDX	#000H
MRU005		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+036H,X
		LDA	<WORK2
		STA	!SLCTBF+060H,X
		INC	<WORK0
		INC	<WORK2
		INX
		INX
		CPX	#010H
		BNE	MRU005
		LDA	#0030BH
		STA	!SLCTBF+046H
		LDA	#0031BH
		STA	!SLCTBF+070H
		STZ	!SLBFCT
		LDA	#WALDNO
		INC	A
		INC	A
		STA	<WORK0
		JSR	WORLDNO			; world NO ram buffer set
;
		LDA	#078FDH
		STA	!SLONAD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#001H
		STA	!SLONFG
		LDA	#015H
		STA	!SLONCT
;
MRU000		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00003H
		STA	<WORK0
		LDA	#00012H
		STA	<WORK2
		LDA	#00006H
		STA	<WORK4
		LDA	#00024H
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP1
		BRA	MRU090
;
MRU050		EQU	$
		LDA	!SLONCT
		BNE	MRU070
		LDA	<WORK0
		BNE	MRU053
		STZ	!SLONFG
		STZ	!SLOFFG
		BRA	MRU090
;
MRU053		EQU	$			; window close init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#0073AH
		STA	!SLBFCT
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#001H
		STA	!SLONFG
		LDA	#016H
		STA	!SLONCT
;
MRU070		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00003H
		STA	<WORK0
		LDA	#00012H
		STA	<WORK2
		LDA	#00006H
		STA	<WORK4
		LDA	#00024H
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP3
;
MRU090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	MARIO 3					+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MARIO3		EQU	$
		LDA	!SLOFFG
		BEQ	MR3001
		JMP	MR3050
MR3001		EQU	$
		LDA	!SLONCT
		BNE	MR3000
		LDA	<WORK0
		BNE	MR3003
		LDA	#001H
		STA	!SLOFFG
		STZ	!SLONFG
		JMP	MR3090
;
MR3003		EQU	$
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00300H
		STA	<WORK0
		LDA	#00310H
		STA	<WORK2
		LDX	#000H
MR3005		EQU	$
		LDA	<WORK0
		STA	!SLCTBF+036H,X
		LDA	<WORK2
		STA	!SLCTBF+060H,X
		INC	<WORK0
		INC	<WORK2
		INX
		INX
		CPX	#010H
		BNE	MR3005
		LDA	#0030CH
		STA	!SLCTBF+046H
		LDA	#0031CH
		STA	!SLCTBF+070H
		STZ	!SLBFCT
		LDA	#WALDNO
		INC	A
		INC	A
		INC	A
		STA	<WORK0
		JSR	WORLDNO			; world NO ram buffer set
;
		LDA	#MR3PLA+(m3_2play-MR3PLA)
		STA	<WORK0
		LDX	#BANK MR3PLA
		STX	<WORK2
		JSR	PL12ST			; "1p" , "2p" set
;
		LDA	#07CE9H
		STA	!SLONAD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#001H
		STA	!SLONFG
		LDA	#015H
		STA	!SLONCT
;
MR3000		EQU	$
		JSR	SLWDOP
		BRA	MR3090
;
MR3050		EQU	$
		LDA	!SLONCT
		BNE	MR3070
		LDA	<WORK0
		BNE	MR3053
		STZ	!SLONFG
		STZ	!SLOFFG
		BRA	MR3090
;
MR3053		EQU	$			;  window close init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00F12H
		STA	!SLBFCT
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#001H
		STA	!SLONFG
		LDA	#016H
		STA	!SLONCT
;
MR3070		EQU	$
		JSR	SLWDOP2

;
MR3090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	MARIO 4					+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MARIO4		EQU	$
		LDA	!SLOFFG
		BNE	MR4050
		LDA	!SLONCT
		BNE	MR4000
		LDA	<WORK0
		BNE	MR4003
		LDA	#001H
		STA	!SLOFFG
		STZ	!SLONFG
		JMP	MR4090
;
MR4003		EQU	$			; wind open init set
		LDA	#03FH
		STA	<SOUND3
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#MR4DAT			; "SUPER MARIO WORLD" set
		STA	<WORK0
		LDY	#000H
MR4005		EQU	$
		LDA	(<WORK0),Y
		STA	!SLCTBF+034H,Y
		CLC
		ADC	#00010H
		STA	!SLCTBF+05EH,Y
		INY
		INY
		CPY	#(MR4DAT1-MR4DAT)
		BNE	MR4005
		STZ	!SLBFCT
		IDX16
		REP	#00010000B		; index 16bit mode
		LDX	#00000H
		TXY
		LDA	#00004H
		STA	<WORK2
		JSR	M4WLDST			; world NO ram buffer set
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		LDA	#07CF7H
		STA	!SLONAD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#001H
		STA	!SLONFG
		LDA	#015H
		STA	!SLONCT
;
MR4000		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00009H
		STA	<WORK0
		LDA	#0000CH
		STA	<WORK2
		LDA	#00012H
		STA	<WORK4
		LDA	#00018H
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP1
		BRA	MR4090
;
MR4050		EQU	$
		LDA	!SLONCT
		BNE	MR4070
		LDA	<WORK0
		BNE	MR4053
		STZ	!SLONFG
		STZ	!SLOFFG
		BRA	MR4090
;
MR4053		EQU	$			; window close init set
		LDA	#03FH
		STA	<SOUND3
		MEM16				; memory 16bit mode
		REP	#00100000B
		LDA	#00F2EH
		STA	!SLBFCT
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#001H
		STA	!SLONFG
		LDA	#016H
		STA	!SLONCT
;
MR4070		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#00009H
		STA	<WORK0
		LDA	#0000CH
		STA	<WORK2
		LDA	#00012H
		STA	<WORK4
		LDA	#00018H
		STA	<WORK6
		MEM8
		SEP	#00100000B		; memory 8bit mode
		JSR	SLWDOP3
;
MR4090		EQU	$
		RTS
;
;
		MEM16
		IDX16
M4WLDST		EQU	$
		LDA	>MR4PLA+08DH,X
		BEQ	M4W100
		LDA	#002FFH
		STA	!SLCTBF+0BEH,Y
		STA	!SLCTBF+0C0H,Y
		STA	!SLCTBF+0C4H,Y
		LDA	#002B0H
		STA	!SLCTBF+0E8H,Y
		STA	!SLCTBF+0EAH,Y
		STA	!SLCTBF+0EEH,Y
		LDA	>MR4PLA+08CH,X
		AND	#000FFH
		STZ	<WORK0
M4W010		EQU	$
		CMP	#0000AH
		BCC	M4W015
		SBC	#0000AH
		INC	<WORK0
		BRA	M4W010
;
M4W015		EQU	$
		INC	A
		ORA	#00340H
		STA	!SLCTBF+0C2H,Y
		ORA	#00010H
		STA	!SLCTBF+0ECH,Y
		LDA	<WORK0
		BEQ	M4W100
		INC	A
		ORA	#00340H
		STA	!SLCTBF+0C0H,Y
		ORA	#00010H
		STA	!SLCTBF+0EAH,Y
M4W100		EQU	$
		LDA	>MR4PLA+08CH,X
		AND	#000FFH
		CMP	#96
		BCC	M4W150
		LDA	#0039BH
		STA	!SLCTBF+0E8H,Y
M4W150		EQU	$
		TXA
		CLC
		ADC	#0008FH
		TAX
		TYA
		CLC
		ADC	#00054H
		TAY
		DEC	<WORK2
		BNE	M4WLDST
		RTS
		MEM8
		IDX8
;
;
MR4DAT		EQU	$
		WORD	00300H,00301H,00302H,00303H	; SUPER
		WORD	00304H,00305H,00306H,00307H	; MARIO
		WORD	001C3H,001E3H,001B7H,001D7H	; WORLD
MR4DAT1		EQU	$
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	world NO ram buffer set				+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
;
WORLDNO		EQU	$
		LDX	#000H			; world NO set
		TXY
WLD000		EQU	$
		LDA	(<WORK0),Y
		INC	A
		AND	#000FFH
		BEQ	WLD010
		ORA	#00340H
		STA	!SLCTBF+0C0H,X
		ORA	#00010H
		STA	!SLCTBF+0EAH,X
		LDA	#002DFH
		STA	!SLCTBF+0ECH,X
		LDA	#002B0H
		STA	!SLCTBF+0E8H,X
		STA	!SLCTBF+0EEH,X
		LDA	#002FFH
		STA	!SLCTBF+0BEH,X
		STA	!SLCTBF+0C2H,X
		STA	!SLCTBF+0C4H,X
WLD010		EQU	$
		TXA
		CLC
		ADC	#00054H
		TAX
		INY
		INY
		INY
		INY
		CPY	#010H
		BNE	WLD000
;
		LDA	!SLMRFG
		AND	#00007H
		CMP	#00002H
		BCS	WLD030
		LDX	#000H
		TXY
WLD020		EQU	$
		LDA	<URADAT,X
		AND	#000FFH
		BEQ	WLD025
		LDA	#0039BH
		STA	!SLCTBF+0E8H,Y
WLD025		EQU	$
		TYA
		CLC
		ADC	#00054H
		TAY
		INX
		INX
		INX
		INX
		CPX	#010H
		BEQ	WLD030
		BRA	WLD020
;
WLD030		EQU	$
		RTS
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	world & corse NO ram buffer set			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
;
WLDCOS		EQU	$
		LDX	#000H			; world NO set
		TXY
WDCS00		EQU	$
		LDA	(<WORK0),Y
		INC	A
		AND	#000FFH
		BEQ	WDCS10
		ORA	#00340H
		STA	!SLCTBF+0BEH,X
		ORA	#00010H
		STA	!SLCTBF+0E8H,X
		LDA	#002DFH
		STA	!SLCTBF+0EAH,X
		LDA	#002EFH
		STA	!SLCTBF+0ECH,X
		LDA	#002FFH
		STA	!SLCTBF+0C0H,X
		STA	!SLCTBF+0C2H,X
		LDA	!CORSNO,Y
		XBA
		AND	#000FFH
		INC	A
		ORA	#00340H
		STA	!SLCTBF+0C4H,X
		ORA	#00010H
		STA	!SLCTBF+0EEH,X
WDCS10		EQU	$
		TXA
		CLC
		ADC	#00054H
		TAX
		INY
		INY
		INY
		INY
		CPY	#010H
		BNE	WDCS00
		RTS
;
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	1 play						+
;+	2 play set					+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
PL12ST		EQU	$
		IDX16
		REP	#00010000B		; index 16bit mode
		LDA	!SLMRFG
		AND	#00007H
		STA	<WORKA
;
		LDA	#00000H
		TAX
		STA	<WORK4
PL1200		EQU	$
		LDY	<WORK4
		LDA	[<WORK0],Y
		AND	#000FFH
		CMP	#000FFH
		BEQ	PL1250
		CLC
		ADC	<WORKA
		ASL	A
		TAY
;
		LDA	PL12DT,Y
		STA	!SLCTBF+0F0H,X
		INC	A
		STA	!SLCTBF+0F2H,X
;
PL1250		EQU	$
		LDA	<WORK4
		CLC
		ADC	#MR1PLB-MR1PLA
		STA	<WORK4
		TXA
		CLC
		ADC	#00054H
		TAX
		AND	#00100H
		BEQ	PL1200
		IDX8
		SEP	#00010000B		; index 8bit mode
		RTS
		MEM8
;
;
PL12DT		EQU	$
		WORD	0039CH,0039EH,00000H,00000H
		WORD	0039CH,0039EH
;
;
;
;********************************************************
;*	select wind open sub				*
;*							*
;********************************************************
SLWDOP		EQU	$
		LDA	>VRAMD
		TAX
;
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	#00015H
		STA	<WORK4
		LDA	!SLONAD
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	#0002AH
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
WDOPLP		EQU	$
		LDY	!SLBFCT
		LDA	!SLCTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INC	!SLBFCT
		INC	!SLBFCT
		DEC	<WORK4
		BNE	WDOPLP
;
		LDA	!SLONAD
		CLC
		ADC	#00020H
		STA	!SLONAD
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		DEC	!SLONCT
		RTS
;
;
;
SLWDOP1		EQU	$
		LDA	>VRAMD
		TAX
;
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	<WORK0			; left count
		LDA	<WORK2			; right count
; left set
		LDA	!SLONAD
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	<WORK4			; left ko-su-u set
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
WDOP1L1		EQU	$
		LDY	!SLBFCT
		LDA	!SLCTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INC	!SLBFCT
		INC	!SLBFCT
		DEC	<WORK0			; left count down
		BNE	WDOP1L1
; right set
		LDA	!SLONAD
		AND	#07FE0H
		EOR	#00400H
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	<WORK6			; right ko-su-u set
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
WDOP1L2		EQU	$
		LDY	!SLBFCT
		LDA	!SLCTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INC	!SLBFCT
		INC	!SLBFCT
		DEC	<WORK2			; right count down
		BNE	WDOP1L2
;
		LDA	!SLONAD
		CLC
		ADC	#00020H
		STA	!SLONAD
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		DEC	!SLONCT
		RTS
;
;
;
SLWDOP2		EQU	$
		LDA	>VRAMD
		TAX
;
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	#00015H
		STA	<WORK4
		LDA	!SLONAD
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	#0002AH
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PHB
		LDA	#BANK SLDTBF
		PHA
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>SLBFCT
		TAY
WDOPLP2		EQU	$
		LDA	!SLDTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		DEC	<WORK4
		BNE	WDOPLP2
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	!SLONAD
		SEC
		SBC	#00020H
		STA	!SLONAD
		LDA	!SLBFCT
		SEC
		SBC	#00040H
		STA	!SLBFCT
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		DEC	!SLONCT
		LDA	!SLONCT
		BNE	WDOP2PS
		STZ	!SLONFG
		STZ	!SLOFFG
WDOP2PS		EQU	$
		RTS
;
;
;
SLWDOP3		EQU	$
		LDA	>VRAMD
		TAX
;
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	<WORK0			; left count
		LDA	<WORK2			; right count
; left set
		LDA	!SLONAD
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	<WORK4			; left ko-su-u set
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PHB
		LDA	#BANK SLDTBF
		PHA
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>SLBFCT
		TAY
WDOP2L1		EQU	$
		LDA	!SLDTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		DEC	<WORK0			; left count down
		BNE	WDOP2L1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
; right set
		LDA	!SLONAD
		AND	#07FE0H
		EOR	#00400H
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	<WORK6			; right ko-su-u set
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PHB
		LDA	#BANK SLDTBF
		PHA
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		TYA
		CLC
		ADC	#007C0H
		AND	#00FFFH
		TAY
WDOP2L2		EQU	$
		LDA	!SLDTBF,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		DEC	<WORK2			; right count down
		BNE	WDOP2L2
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	!SLONAD
		SEC
		SBC	#00020H
		STA	!SLONAD
		LDA	!SLBFCT
		SEC
		SBC	#00040H
		STA	!SLBFCT
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		DEC	!SLONCT
		LDA	!SLONCT
		BNE	WDOP3PS
		STZ	!SLONFG
		STZ	!SLOFFG
WDOP3PS		EQU	$
		RTS
;
;
;********************************************************
;*	button select set				*
;*							*
;********************************************************
BTNSLT		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
;
		LDA	BSLTAD0,Y
		XBA
		STA	>VRAMD+02H,X
		LDA	#00006H
		XBA
		STA	>VRAMD+04H,X
;
		PHY
		LDA	>KEYMOD
		AND	#00001H
		ASL	A
		TAY
		LDA	BSLTDT,Y
		STA	>VRAMD+06H,X
		INC	A
		STA	>VRAMD+08H,X
		INC	A
		STA	>VRAMD+0AH,X
		PLY
		TXA
		CLC
		ADC	#0000AH
		TAX
;
		LDA	BSLTAD1,Y
		XBA
		STA	>VRAMD+2,X
		LDA	#00004H
		XBA
		STA	>VRAMD+4,X
;
		LDA	>KEYMOD
		AND	#00001H
		ASL	A
		ADC	#00384H
		STA	>VRAMD+6,X
		INC	A
		STA	>VRAMD+8,X
;
		TXA
		CLC
		ADC	#00008H
		STA	>VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTS
;
BSLTAD0		EQU	$
		WORD	07B2CH,07B38H,07F24H,07F30H
;
BSLTAD1		EQU	$
		WORD	07B4BH,07B57H,07F43H,07F4FH
;
BSLTDT		EQU	$
		WORD	00378H,00368H
;
;
;********************************************************
;*	carsol key set					*
;*							*
;********************************************************
CARSOL		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#002FFH
		STA	<WORK0
		STA	<WORK2
		STA	<WORK4
		STA	<WORK6
		STA	<WORK8
		STA	<WORKA
		STA	<WORKC
		LDA	<PLAYNO
		AND	#00003H
		ASL	A
		ASL	A
		TAX
		LDA	#0034FH
		STA	<WORK0,X
;
		LDA	>VRAMD
		TAX
;
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
		LDA	CRSLAD,Y
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	#0800EH
		XBA
		STA	>VRAMD+2,X
		INX
		INX
;
		LDY	#000H
CRSLST		EQU	$
		LDA	!WORK0,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		CPY	#00EH
		BNE	CRSLST
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTS
;
CRSLAD		EQU	$
		WORD	07989H,07995H,07D81H,07D8DH,07D9BH
;
;
;****************************************************************
;*	world select						*
;*				work0 -> address low		*
;*				work1 ->   "     high           *
;****************************************************************
WRLDST		EQU	$
		PHX
		PHY
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
;
		LDA	!SLMRFG
		AND	#00007H
		STA	<WORK0
		ASL	A
		TAY
		LDA	<PLAYNO
		AND	#000FFH
		XBA
		LSR	A
		LSR	A
		ADC	WLDADR,Y
		STA	<WORK2			; u-ra star address
		XBA
		STA	>VRAMD+2,X		; address set
		INX
		INX
		LDA	#08004H
		XBA
		STA	>VRAMD+2,X		; ko-su-u set
;
		INX
		INX
		LDA	<PLAYNO
		AND	#00003H
		ASL	A
		ASL	A
		ADC	<WORK0
		TAY
		LDA	!WALDNO,Y
		AND	#000FFH
		CLC
		ADC	#00341H
		STA	>VRAMD+2,X
		INX
		INX
		ORA	#00010H
		STA	>VRAMD+2,X
		INX
		INX
;
		LDA	<WORK0
		BNE	WRLD00
		LDA	!URADAT,Y		; ho-si on,off set
		AND	#000FFH
		ASL	A
		TAY
		LDA	<WORK2
		CLC
		ADC	#0001FH
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	#00002H
		XBA
		STA	>VRAMD+2,X
		INX
		INX
		LDA	HOSIDT,Y
		STA	>VRAMD+2,X
		INX
		INX
;
WRLD00		EQU	$
		LDA	#0FFFFH			; end code
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLY
		PLX
		RTS
;
;
;****************************************************************
;*	select corse set					*
;*								*
;****************************************************************
SLCSST		EQU	$
		PHX
		PHY
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
;
		LDA	<PLAYNO
		AND	#000FFH
		XBA
		LSR	A
		LSR	A
		ADC	#0797FH
		XBA
		STA	>VRAMD+2,X		; address set
		INX
		INX
		LDA	#08004H
		XBA
		STA	>VRAMD+2,X		; ko-su-u set
;
		INX
		INX
		LDA	<PLAYNO
		AND	#00003H
		ASL	A
		ASL	A
		TAY
		LDA	!CORSNO+1,Y
		AND	#000FFH
		CLC
		ADC	#00341H
		STA	>VRAMD+2,X
		INX
		INX
		ORA	#00010H
		STA	>VRAMD+2,X
		INX
		INX
		LDA	#0FFFFH			; end code
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLY
		PLX
		RTS
;
WLDADR		EQU	$
		WORD	07971H,0797CH,07D69H,07D75H
;
HOSIDT		EQU	$
		WORD	002B0H,0039BH
;
;
;****************************************************************
;*	eraser mode						*
;*								*
;****************************************************************
WINDON		EQU	$
ERSMD0		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
		PHY
		LDA	!ERASDT
		AND	#000FH
		XBA
		LSR	A
		LSR	A
		LSR	A
		STA	<WORKE
		TAX
		LDA	ERSAD0,Y
		SEC
		SBC	<WORKE
		STA	<WORK0			; address up set
		LDA	ERSCNT,Y
		STA	<WORK2			; ko-su-u set
		LDA	!ERASDT
		AND	#0000FH
		ASL	A
		TAY
		LDA	ERSDAT0,Y
		STA	<WORK8
		STZ	<WORK4
;
		LDA	>VRAMD
		TAX
;
		JSR	OPNSUB
;
		PLY
		LDA	ERSCNT+0AH,Y
		BEQ	ERS020
		LDA	<WORK0
		AND	#07FE0H
		EOR	#00400H
		STA	<WORK0			; address set
		LDA	ERSCNT+0AH,Y
		STA	<WORK2			; ko-su-u set
;
		JSR	OPNSUB
;
ERS020		EQU	$
		PHY
		LDA	ERSAD1,Y
		CLC
		ADC	<WORKE
		STA	<WORK0			; address up set
		LDA	ERSCNT,Y
		STA	<WORK2			; ko-su-u set
		LDA	!ERASDT
		AND	#0000FH
		ASL	A
		TAY
		LDA	ERSDAT1,Y
		STA	<WORK8
		STZ	<WORK4
;
		JSR	OPNSUB
;
		PLY
		LDA	ERSCNT+0AH,Y
		BEQ	ERS050
		LDA	<WORK0
		AND	#07FE0H
		EOR	#00400H
		STA	<WORK0			; address set
		LDA	ERSCNT+0AH,Y
		STA	<WORK2			; ko-su-u set
;
		JSR	OPNSUB
;
ERS050		EQU	$
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!ERASDT
		LDA	!ERASDT
		CMP	#0004H
		BNE	ERSEND
		INC	<SLMODE
		STZ	!NEWFLG
ERSEND		EQU	$
		RTL
;
;--------------------------------- window open sub
		MEM16
OPNSUB		EQU	$
		PHY
		LDA	<WORK0
		XBA
		STA	>VRAMD+2,X		; vram address set
		INX
		INX
		LDA	<WORK2
		XBA
		STA	>VRAMD+2,X		; vram count set
		INX
		INX
		LSR	<WORK2
;
		LDY	<WORK4
ERS000		EQU	$
		LDA	(<WORK8),Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		DEC	<WORK2
		BNE	ERS000
		STY	<WORK4			; count ta-i-hi
		PLY
		RTS
		MEM8
;
;
;
;
;
WINDOFF		EQU	$
ERSMD1		EQU	$
;
ERS100		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
;
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
		PHY
		LDA	!ERASDT
		AND	#000FH
		XBA
		LSR	A
		LSR	A
		LSR	A
		STA	<WORKE
		TAX
		LDA	ERSAD0,Y
		CLC
		ADC	<WORKE
		STA	<WORK0			; address up set
		LDA	ERSCNT,Y
		STA	<WORK2			; ko-su-u set
		LDA	#ERSDT8
		STA	<WORK8
		STZ	<WORK4
;
		LDA	>VRAMD
		TAX
;
		JSR	OPNSUB
;
		PLY
		LDA	ERSCNT+0AH,Y
		BEQ	ERS120
		LDA	<WORK0
		AND	#07FE0H
		EOR	#00400H
		STA	<WORK0			; address set
		LDA	ERSCNT+0AH,Y
		STA	<WORK2			; ko-su-u set
;
		JSR	OPNSUB
;
ERS120		EQU	$
		PHY
		LDA	ERSAD1,Y
		SEC
		SBC	<WORKE
		STA	<WORK0			; address up set
		LDA	ERSCNT,Y
		STA	<WORK2			; ko-su-u set
		LDA	#ERSDT8
		STA	<WORK8
		STZ	<WORK4
;
		JSR	OPNSUB
;
		PLY
		LDA	ERSCNT+0AH,Y
		BEQ	ERS150
		LDA	<WORK0
		AND	#07FE0H
		EOR	#00400H
		STA	<WORK0			; address set
		LDA	ERSCNT+0AH,Y
		STA	<WORK2			; ko-su-u set
;
		JSR	OPNSUB
;
ERS150		EQU	$
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		DEC	!ERASDT
		LDA	!ERASDT
		BPL	ERS1ED
		STZ	!ERASDT
		LDA	#002H
		STA	<SLMODE
		STZ	<GMCLMD
		STZ	<SL3FLG
ERS1ED		EQU	$
		RTL
;
;
ERSAD0	EQU	$
	WORD	07AEFH,07AFBH,07EE7H,07EF3H,07AE1H
;
ERSAD1	EQU	$
	WORD	07B0FH,07B1BH,07F07H,07F13H,07B01H
;
ERSCNT	EQU	$
	WORD	00016H,0000AH,00016H,00016H,00016H
	WORD	00000H,0000CH,00000H,00000H,00000H
;
ERSDAT0 EQU	$
	WORD	ERSDT3,ERSDT2,ERSDT1,ERSDT0
;
ERSDAT1 EQU	$
	WORD	ERSDT4,ERSDT5,ERSDT6,ERSDT7
;
ERSDT0	EQU	$
	WORD	00388H,00389H,00389H,00389H,00389H,00389H,00389H,00389H,00389H,00389H,04388H
ERSDT1	EQU	$
	WORD	0038AH,00383H,00395H,00396H,00397H,00383H,002FFH,002FFH,002FFH,002FFH,0438AH
ERSDT2	EQU	$
	WORD	0038AH,002FFH,002FFH,002FFH,00398H,00399H,0039AH,00383H,002FFH,0035FH,0438AH
ERSDT3	EQU	$
	WORD	0038AH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,0438AH
ERSDT4	EQU	$
	WORD	0038AH,002FFH,002FFH,0034FH,0036FH,0037FH,002FFH,002FFH,002FFH,002FFH,0438AH
ERSDT5	EQU	$
	WORD	0038AH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,0438AH
ERSDT6	EQU	$
	WORD	0038AH,002FFH,002FFH,002FFH,00381H,00383H,00397H,002FFH,002FFH,002FFH,0438AH
ERSDT7	EQU	$
	WORD	08388H,08389H,08389H,08389H,08389H,08389H,08389H,08389H,08389H,08389H,0C388H
;
ERSDT8	EQU	$
	WORD	002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH,002FFH
;
;
;
;
;************************************************************************
;*		Select-game				(SELECT3)	*
;************************************************************************
;
SELECT3		EQU	$
		LDA	<KEYA2L
		ORA	<KEYB2L
		AND	#10000000B
		STA	<WORK0
;
		LDA	<KEYA2
		ORA	<KEYB2
		AND	#00111100B
		ORA	<WORK0
		BEQ	SL3040
		STA	<WORK0
		AND	#02CH			; "UP ","DOWN","SELECT" key on ?
		BEQ	SL3050			;	NO -> SL3050
		LDA	!NEWFLG
		EOR	#004H
		STA	!NEWFLG
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	>VRAMD
		TAX
;
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
		LDA	SL3ADR,Y
		XBA
		STA	>VRAMD+02H,X
		LDA	#08006H
		XBA
		STA	>VRAMD+04H,X
		LDA	#002FFH
		STA	>VRAMD+06H,X
		STA	>VRAMD+08H,X
		STA	>VRAMD+0AH,X
;
		PHX
		LDX	!NEWFLG
		LDA	#0034FH
		STA	>VRAMD+06H,X
		PLX
;
		LDA	#0FFFFH
		STA	>VRAMD+0CH,X
		TXA
		CLC
		ADC	#0000CH
		STA	>VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	#023H
		STA	<SOUND3
;
SL3040		EQU	$
		JMP	SL3END
;
SL3050		EQU	$
		LDA	<WORK0
		AND	#10010000B		; "START" key on ?
		BNE	SL3055			;	YES -> SL3055
SL3053		EQU	$
		LDA	#022H
		STA	<SOUND3
		JMP	SL3END			;	NO -> SL3END
SL3055		EQU	$
		LDA	#005H
		STA	<SOUND3
		INC	<SLMODE
		LDA	!NEWFLG
		BEQ	SL3053
		LDA	!SLMRFG
		CMP	#004H
		BEQ	SL3060
		STA	<WORK0
		LDA	<PLAYNO
		AND	#003H
		ASL	A
		ASL	A
		ADC	<WORK0
		TAX
		LDA	#0FFH
		STA	<WALDNO,X
		STA	<CORSNO,X
		LDA	#000H
		STA	<URADAT,X
		JSR	SRMCLR
		BRA	SL3065
;
SL3060		EQU	$
		LDA	<PLAYNO
		STA	<WORK0
		JSL	>M4SVCLR		; mario 4 save ram clear
		JSR	YSKCST			; yo-shi ku-chi move
;
SL3065		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD			; "NEW" set
		TAX
;
		LDA	!SLMRFG
		AND	#00007H
		ASL	A
		TAY
		LDA	SL3ESAD,Y
		STA	<WORK0
		LDA	!PLAYNO
		AND	#00003H
		XBA
		LSR	A
		LSR	A
		ADC	<WORK0
		STA	<WORK0
		LDA	SL3ESCT,Y
		STA	<WORK2
		STZ	<WORKE
;
		JSR	NEWSET
;
		LDA	!SLMRFG
		AND	#00007H
		CMP	#00001H
		BNE	SL3070
		PHY
		LDA	#07D60H
		STA	<WORK0
		LDA	!PLAYNO
		AND	#00003H
		XBA
		LSR	A
		LSR	A
		ADC	<WORK0
		STA	<WORK0
		LDA	#00004H
		STA	<WORK2
;
		JSR	NEWSET
		PLY
;
SL3070		EQU	$
;
		LDA	SL3ESAD,Y
		STA	<WORK0
		LDA	!PLAYNO
		AND	#00003H
		XBA
		LSR	A
		LSR	A
		ADC	#00020H
		ADC	<WORK0
		STA	<WORK0
		LDA	SL3ESCT,Y
		STA	<WORK2
;
		JSR	NEWSET
;
		LDA	!SLMRFG
		AND	#00007H
		CMP	#00001H
		BNE	SL3090
		LDA	#07D80H
		STA	<WORK0
		LDA	!PLAYNO
		AND	#00003H
		XBA
		LSR	A
		LSR	A
		ADC	<WORK0
		STA	<WORK0
		LDA	#00004H
		STA	<WORK2
;
		JSR	NEWSET
;
SL3090		EQU	$
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
SL3END		EQU	$
		RTL
;
;
		MEM16
NEWSET		EQU	$
		PHY
		LDA	<WORK0
		XBA
		STA	>VRAMD+2,X		; address set
		INX
		INX
		LDA	<WORK2
		XBA
		STA	>VRAMD+2,X		; count set
		XBA
		LSR	A
		AND	#000FFH
		STA	<WORK4
		INX
		INX
NEWLOP		EQU	$			; data set
		LDY	<WORKE
		LDA	SL3ESDT,Y
		STA	>VRAMD+2,X
		INC	<WORKE
		INC	<WORKE
		INX
		INX
		DEC	<WORK4
		BNE	NEWLOP
		PLY
		RTS
		MEM8
;
;
M4SVCLR		EQU	$
		PHB
		PHK
		PLB
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	<WORK0
		AND	#00003H
		ASL	A
		TAY
		LDX	M4SVIDX,Y
		LDY	#00047H
		LDA	#00000H
M4CLR0		EQU	$
		STA	>MR4PLA+0000H,X
		STA	>MR4PLA+023CH,X
		INX
		INX
		DEY
		BNE	M4CLR0
		STA	>MR4PLA-001H,X
		STA	>MR4PLA+023BH,X
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 16bit mode
		PLB
		RTL
;
;
SL3ADR		EQU	$
		WORD	07B12H,07B1EH,07F0AH,07F16H,07B04H
;
SL3ESAD		EQU	$
		WORD	07970H,0797CH,07D68H,07D74H,07962H
;
SL3ESCT		EQU	$
		WORD	0000CH,00008H,0000CH,0000CH,0000CH
;
SL3ESDT		EQU	$
		WORD	00360H,00361H,00362H,00363H,002FFH,002FFH
		WORD	00370H,00371H,00372H,00373H,002FFH,002FFH
;
M4SVIDX		EQU	$
		WORD	00000H,0008FH,0011EH,001ADH
;
;
;
CORSDT		EQU	$
		HEX	00,01,FF
;
GAMEDT		EQU	$
;;;;K;;;;		HEX	07,08,09,0A,7F
;;;;K;;;;		HEX	17,18,19,1A,7F
;;;;K;;;;;
;;;;K;;;;		HEX	07,08,09,0A,0E
;;;;K;;;;		HEX	17,18,19,1A,1E
;;;;K;;;;;
;;;;K;;;;		HEX	17,18,19,1A,7F
;;;;K;;;;		HEX	7F,7F,0B,0C,0D
;;;;K;;;;;
;;;;K;;;;		HEX	07,08,09,0A,0F
;;;;K;;;;		HEX	17,18,19,1A,1F
;
PLAYDT		EQU	$
;;;;K;;;;		HEX	1B,1C,1D,20
;;;;K;;;;		HEX	1B,1C,1D,21
;;;;K;;;;		HEX	1B,1C,1D,30
;;;;K;;;;		HEX	1B,1C,1D,31
;
MARIDT		EQU	$
;;;;K;;;;		HEX	65,66,67
;;;;K;;;;		HEX	75,76,77
;
;
;
;
;
		MEM8
		IDX8
;
;
;****************************************************************
;*	BG change main 1					*
;*								*
;****************************************************************
BGCGMN1		EQU	$
		PHB
		PHK
		PLB
;
		LDA	!YOSIDX
		BMI	BGMN150
		DEC	!FRCT08
		BNE	BGMN150
		JSR	YOSISTS
		LDA	#008H
		STA	!FRCT08
		STA	<SCRVFG
;
BGMN150		EQU	$
		LDA	!FRCT32
		BEQ	BGMN190
		DEC	!FRCT32
		BNE	BGMN190
		JSR	MROST2
		INC	<SCRVFG
;
BGMN190		EQU	$
		PLB
		RTS
;
;
;****************************************************************
;*	BG change main						*
;*								*
;****************************************************************
BGCGMN		EQU	$
		PHB
		PHK
		PLB
;
		DEC	!FRCT12
		BNE	BGMN020
		JSR	LGSET1
		JSR	KNPSET
		JSR	CSRST2
		JSR	DDRSET
		JSR	MROST0
		LDA	#009H
		STA	!FRCT12
		STA	<SCRVFG
;
BGMN020		EQU	$		; 16
		DEC	!FRCT16
		BNE	BGMN030
		JSR	LGSET0
		JSR	KUPSET
		LDA	#010H
		STA	!FRCT16
		STA	<SCRVFG
;
BGMN030		EQU	$		; 32
		DEC	!FRCT32
		BNE	BGMN050
		JSR	PCHSET
		JSR	CSRST1
		LDA	#020H
		STA	!FRCT32
		STA	<SCRVFG
;
BGMN050		EQU	$
		PLB
		RTS
;
;
;****************************************************************
;*	BG change init						*
;*								*
;****************************************************************
BGCGIT		EQU	$
		PHB
		PHK
		PLB
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDX	#8000H
		LDY	#TITLBF
		LDA	#07FFH
		MVN	#03CH,#BANK TITLBF
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		PLB
;
		LDA	#00BH
		STA	!FRCT12
		LDA	#008H
		STA	!FRCT08
		LDA	#010H
		STA	!FRCT16
		LDA	#020H
		STA	!FRCT32
;
		LDA	#001H
		STA	<SCRVFG
		STZ	!TLPSFG
		LDA	#060H
		STA	<FLSHCT
		STZ	<FLSIDX
;
		RTS
;
;
;
;****************************************************************
;*	luige set						*
;*								*
;****************************************************************
LGSET0		EQU	$			; head set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!LGIDX0
		AND	#00003H
		ASL	A
		TAX
		LDA	LGHEAD,X
		STA	<WORK0			; address set
		LDA	#003A6H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!LGIDX0
		RTS
;
;
LGSET1		EQU	$			; hand set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!LGIDX1
		AND	#000FFH
		ASL	A
		TAX
		LDA	LGHAND,X
		STA	<WORK0			; address set
		LDA	#00464H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!LGIDX1
		LDA	!LGIDX1
		CMP	#00BH
		BCC	LGSE1E
		STZ	!LGIDX1
;
LGSE1E		EQU	$
		RTS
;
;
LGHEAD		EQU	$
		WORD	LGHEAD0,LGHEAD1,LGHEAD2,LGHEAD1
;
LGHAND		EQU	$
		WORD	LGHAND0,LGHAND0
		WORD	LGHAND1,LGHAND1,LGHAND1,LGHAND1
		WORD	LGHAND2
		WORD	LGHAND1,LGHAND1,LGHAND1,LGHAND1
;
;
;
;****************************************************************
;*	peach set						*
;*								*
;****************************************************************
PCHSET		EQU	$			; head set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!PCIDX
		AND	#00001H
		ASL	A
		TAX
		LDA	PCHEAD,X
		STA	<WORK0			; address set
		LDA	#00392H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!PCIDX
		RTS
;
;
PCHEAD		EQU	$
		WORD	PCHEAD0,PCHEAD1
;
;
;
;****************************************************************
;*	kinopio set						*
;*								*
;****************************************************************
KNPSET		EQU	$			; head set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!KNIDX
		AND	#00001H
		ASL	A
		TAX
		LDA	KNHEAD,X
		STA	<WORK0			; address set
		LDA	#004ECH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		LDA	!KNIDX
		AND	#00003H
		ASL	A
		TAX
		LDA	KNPYSDT,X
		STA	>TITLBF+04F0H
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!KNIDX
		LDA	!KNIDX
		AND	#001H
		BEQ	KNPSET5
		JSR	YOSIST			; yo-si set
KNPSET5		EQU	$
		RTS
;
;
KNHEAD		EQU	$
		WORD	KNHEAD0,KNHEAD1
;
KNPYSDT		EQU	$
		WORD	0010FH,00202H,00277H,00278H
;
;
;
;****************************************************************
;*	casarin set						*
;*								*
;****************************************************************
;;;;K;;;;CSRST0		EQU	$			; eye set
;;;;K;;;;		LDA	#BANK CSEYE0
;;;;K;;;;		STA	<WORK2			; bank set
;;;;K;;;;		MEM16
;;;;K;;;;		IDX16
;;;;K;;;;		REP	#00110000B		; memory , index 16bit mode
;;;;K;;;;;
;;;;K;;;;		LDA	!CSIDX0
;;;;K;;;;		AND	#00003H
;;;;K;;;;		ASL	A
;;;;K;;;;		TAX
;;;;K;;;;		LDA	CSEYE,X
;;;;K;;;;		STA	<WORK0			; address set
;;;;K;;;;		LDA	#00476H
;;;;K;;;;		STA	<WORK4			; index set
;;;;K;;;;		JSR	RMBFST			; ram buffer set
;;;;K;;;;;
;;;;K;;;;		MEM8
;;;;K;;;;		IDX8
;;;;K;;;;		SEP	#00110000B		; memory , index 8bit mode
;;;;K;;;;		INC	!CSIDX0
;;;;K;;;;		LDA	!CSIDX0
;;;;K;;;;		AND	#00FH
;;;;K;;;;		CMP	#003H
;;;;K;;;;		BNE	CSRST05
;;;;K;;;;		LDA	#080H
;;;;K;;;;		STA	!CSIDX0
;;;;K;;;;;
;;;;K;;;;CSRST05		EQU	$
;;;;K;;;;		RTS
;
CSRST1		EQU	$			; hand set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!CSIDX1
		AND	#00001H
		ASL	A
		TAX
		LDA	CSHAND,X
		STA	<WORK0			; address set
		LDA	#005B4H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!CSIDX1
		RTS
;
CSRST2		EQU	$			; sipo set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!CSIDX2
		ASL	A
		TAX
		LDA	CSSIPO,X
		STA	<WORK0			; address set
		LDA	#005FCH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!CSIDX2
		LDA	!CSIDX2
		CMP	#003H
		BNE	CSRST25
		STZ	!CSIDX2
CSRST25		EQU	$
		RTS
;
;
;;;;K;;;;CSEYE		EQU	$
;;;;K;;;;		WORD	CSEYE0,CSEYE1,CSEYE0
;
CSHAND		EQU	$
		WORD	CSHAND0,CSHAND1
;
CSSIPO		EQU	$
		WORD	CSSIPO0,CSSIPO1,CSSIPO2
;
;
;
;****************************************************************
;*	kurbo set						*
;*								*
;****************************************************************
KRBSET		EQU	$			; head set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!KBIDX
		AND	#00003H
		ASL	A
		TAX
		LDA	KBHEAD,X
		STA	<WORK0			; address set
		LDA	#0054EH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!KBIDX
		LDA	!KBIDX
		AND	#00FH
		CMP	#003H
		BNE	KRBSET5
		LDA	#080H
		STA	!KBIDX
;
KRBSET5		EQU	$
		RTS
;
KBHEAD		EQU	$
		WORD	KBHEAD0,KBHEAD1,KBHEAD0
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;****************************************************************
;;;;K;;;;;*	bakdan set						*
;;;;K;;;;;*								*
;;;;K;;;;;****************************************************************
;;;;K;;;;BKDSET		EQU	$			; se-n set
;;;;K;;;;		LDA	#BANK BKDK0
;;;;K;;;;		STA	<WORK2			; bank set
;;;;K;;;;		MEM16
;;;;K;;;;		IDX16
;;;;K;;;;		REP	#00110000B		; memory , index 16bit mode
;;;;K;;;;;
;;;;K;;;;		LDA	!BKIDX
;;;;K;;;;		AND	#00003H
;;;;K;;;;		ASL	A
;;;;K;;;;		TAX
;;;;K;;;;		LDA	BKDK,X
;;;;K;;;;		STA	<WORK0			; address set
;;;;K;;;;		LDA	#00544H
;;;;K;;;;		STA	<WORK4			; index set
;;;;K;;;;		JSR	RMBFST			; ram buffer set
;;;;K;;;;;
;;;;K;;;;		MEM8
;;;;K;;;;		IDX8
;;;;K;;;;		SEP	#00110000B		; memory , index 8bit mode
;;;;K;;;;		INC	!BKIDX
;;;;K;;;;		LDA	!BKIDX
;;;;K;;;;		AND	#004H
;;;;K;;;;		BEQ	BKDST9
;;;;K;;;;		LDA	#080H
;;;;K;;;;		STA	!BKIDX
;;;;K;;;;;
;;;;K;;;;BKDST9		EQU	$
;;;;K;;;;		RTS
;;;;K;;;;;
;;;;K;;;;BKDK		EQU	$
;;;;K;;;;		WORD	BKDK0,BKDK1,BKDK2,BKDK0
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;****************************************************************
;;;;K;;;;;*	togezow set						*
;;;;K;;;;;*								*
;;;;K;;;;;****************************************************************
;;;;K;;;;TGZSET		EQU	$			; eye set
;;;;K;;;;		LDA	#BANK TGZW0
;;;;K;;;;		STA	<WORK2			; bank set
;;;;K;;;;		MEM16
;;;;K;;;;		IDX16
;;;;K;;;;		REP	#00110000B		; memory , index 16bit mode
;;;;K;;;;;
;;;;K;;;;		LDA	!TGIDX
;;;;K;;;;		AND	#00001H
;;;;K;;;;		ASL	A
;;;;K;;;;		TAX
;;;;K;;;;		LDA	TGZW,X
;;;;K;;;;		STA	<WORK0			; address set
;;;;K;;;;		LDA	#00672H
;;;;K;;;;		STA	<WORK4			; index set
;;;;K;;;;		JSR	RMBFST			; ram buffer set
;;;;K;;;;;
;;;;K;;;;		MEM8
;;;;K;;;;		IDX8
;;;;K;;;;		SEP	#00110000B		; memory , index 8bit mode
;;;;K;;;;		LDA	!TGIDX
;;;;K;;;;		BEQ	TGZSET1
;;;;K;;;;		LDA	!TGIDX
;;;;K;;;;		ORA	#080H
;;;;K;;;;		STA	!TGIDX
;;;;K;;;;TGZSET1		EQU	$
;;;;K;;;;		INC	!TGIDX
;;;;K;;;;		RTS
;;;;K;;;;;
;;;;K;;;;TGZW		EQU	$
;;;;K;;;;		WORD	TGZW0,TGZW1
;
;
;****************************************************************
;*	ddriges set						*
;*								*
;****************************************************************
DDRSET		EQU	$			; all set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!DDIDX
		AND	#00003H
		ASL	A
		TAX
		LDA	DDRGS,X
		STA	<WORK0			; address set
		LDA	#000F4H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!DDIDX
		RTS
;
DDRGS		EQU	$
		WORD	DDRGS0,DDRGS1,DDRGS2,DDRGS3
;
;
;****************************************************************
;*	mario set						*
;*								*
;****************************************************************
MROST0		EQU	$			; head set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!MRIDX0
		AND	#0000FH
		ASL	A
		TAX
		LDA	MRHEAD,X
		STA	<WORK0			; address set
		LDA	#00458H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		LDA	MRHED,X
		STA	<WORK0			; address set
		LDA	#0041AH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		LDA	!MRIDX0
		BNE	MROST3
		JSR	MROST1
		STZ	!MRIDX1
		BRA	MROST5
MROST3		EQU	$
		CMP	#006H
		BCC	MROST5
		JSR	MROST1
;
MROST5		EQU	$
		INC	!MRIDX0
		LDA	!MRIDX0
		CMP	#00AH
		BCC	MRHEDPS
		STZ	!MRIDX0
MRHEDPS		EQU	$
		RTS
;
;
MROST1		EQU	$			; hand set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!MRIDX1
		AND	#00003H
		ASL	A
		TAX
		LDA	MRHNDS,X
		STA	>TITLBF+051EH
;
		LDA	MRHAND,X
		STA	<WORK0			; address set
		LDA	#004A0H
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!MRIDX1
		RTS
;
;
MROST2		EQU	$			; eye set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	#001B0H
		STA	>TITLBF+045CH
		LDA	#001C0H
		STA	>TITLBF+049CH
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		RTS
;
;
;
MRHEAD		EQU	$
		WORD	MRHEAD0,MRHEAD1,MRHEAD2,MRHEAD1
		WORD	MRHEAD0,MRHEAD1,MRHEAD2,MRHEAD3
		WORD	MRHEAD3,MRHEAD3
;
MRHED		EQU	$
		WORD	MRHEAD4,MRHEAD5,MRHEAD6,MRHEAD5
		WORD	MRHEAD4,MRHEAD5,MRHEAD6,MRHEAD7
		WORD	MRHEAD7,MRHEAD7
;
MRHNDS		EQU	$
		WORD	0007FH,001D4H,001D4H,001D4H
;
MRHAND		EQU	$
		WORD	MRHAND0,MRHAND1,MRHAND1,MRHAND1
;
;
;
;****************************************************************
;*	kuppa set						*
;*								*
;****************************************************************
KUPSET		EQU	$			; hand set
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!KPIDX
		AND	#000FFH
		ASL	A
		TAX
		LDA	KPHAND,X
		STA	<WORK0			; address set
		LDA	#0040EH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!KPIDX
		LDA	!KPIDX
		CMP	#008H
		BCC	KUPSTE
		STZ	!KPIDX
;
KUPSTE		EQU	$
		RTS
;
KPHAND		EQU	$
		WORD	KPHAND0,KPHAND0,KPHAND0
		WORD	KPHAND1
		WORD	KPHAND2,KPHAND2,KPHAND2
		WORD	KPHAND1
;
;
;****************************************************************
;*	yo-si set						*
;*								*
;****************************************************************
YOSIST		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!YOSIDX
		AND	#00001H
		ASL	A
		TAX
		LDA	YOSIDT,X
		STA	<WORK0			; address set
		LDA	#003EEH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!YOSIDX
		RTS
;
;
YOSISTS		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!YOSIDX
		AND	#00007H
		ASL	A
		TAX
		LDA	YOSIDTS,X
		STA	<WORK0			; address set
		LDA	#003EEH
		STA	<WORK4			; index set
		JSR	RMBFST			; ram buffer set
;
		LDA	KIMYS,X
		STA	>TITLBF+04F0H
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		INC	!YOSIDX
		LDA	!YOSIDX
		CMP	#005H
		BNE	YOSIPSS
		LDA	#080H
		STA	!YOSIDX
YOSIPSS		EQU	$
		RTS
;
YOSIDT		EQU	$
		WORD	YOSIDT0,YOSIDT1
;
YOSIDTS		EQU	$
		WORD	YOSIDT1,YOSIDT2,YOSIDT3,YOSIDT4,YOSIDT0
;
KIMYS		EQU	$
		WORD	00277H,00277H,00277H,00277H,0010FH
;
;
;
;
;****************************************************************
;*	ram buffer set						*
;*								*
;****************************************************************
;
		MEM16
		IDX16
;
RMBFST		EQU	$
		PHX
		PHY
		LDY	#00000H
RMBFINT		EQU	$
		LDX	<WORK4			; titl ram buffer index set
;
RMBFLOP		EQU	$
		LDA	(<WORK0),Y		; data read
		BEQ	RMBFPAS			; next ? (YES -> RMBFPAS)
		BMI	RMBFEND			; end ?	 (YES -> RMBFEND)
		STA	>TITLBF,X		; titl ram buffer set
		INX
		INX
		INY
		INY
		BRA	RMBFLOP
;
RMBFPAS		EQU	$
		INY
		INY
		LDA	<WORK4			; ram buffer inc.
		CLC
		ADC	#0040H
		STA	<WORK4
		BRA	RMBFINT
;
RMBFEND		EQU	$
		PLY
		PLX
		RTS
;
		MEM8
		IDX8
;
;
;
;
;****************************************************************
;*	MARIO TITL DATA						*
;*								*
;****************************************************************
;
;-------------------------------------------------------LUIGE
LGHEAD0		EQU	$
		WORD	001D6H,001D7H,001D8H,00000H
		WORD	001D9H,001DAH,001DBH,001DCH,00000H
		WORD	001DDH,001DEH,001DFH,00240H,00000H
		WORD	001E0H,001E1H,001E2H,0FFFFH
;
LGHEAD1		EQU	$
		WORD	00111H,00112H,00113H,00000H
		WORD	00121H,00122H,00123H,00124H,00000H
		WORD	00106H,00107H,00108H,00109H,00000H
		WORD	00116H,00117H,00118H,0FFFFH
;
LGHEAD2		EQU	$
		WORD	001E3H,001E4H,001E5H,00000H
		WORD	001E6H,001E7H,001E8H,001E9H,00000H
		WORD	001EAH,001EBH,001ECH,001EDH,00000H
		WORD	001EEH,001EFH,001F0H,0FFFFH
;
LGHAND0		EQU	$
		WORD	00115H,00000H
		WORD	00125H,00126H,00000H
		WORD	00105H,0010AH,0FFFFH
;
LGHAND1		EQU	$
		WORD	001F1H,00000H
		WORD	001F2H,001F3H,00000H
		WORD	001F4H,001F5H,0FFFFH
;
LGHAND2		EQU	$
		WORD	001F6H,00000H
		WORD	001F7H,001F8H,00000H
		WORD	001F9H,001FAH,0FFFFH
;
;-------------------------------------------------------PEACH
PCHEAD0		EQU	$
		WORD	00019H,0001AH,0001BH,0001CH,00000H
		WORD	00029H,0002AH,0002BH,0002CH,00000H
		WORD	00039H,0003AH,0003BH,0003CH,0FFFFH
;
PCHEAD1		EQU	$
		WORD	0021AH,0021BH,0021CH,0021DH,00000H
		WORD	0021EH,0021FH,00220H,00221H,00000H
		WORD	00222H,00223H,00224H,00225H,0FFFFH
;
;-------------------------------------------------------KINOPIO
KNHEAD0		EQU	$
		WORD	0010DH,0010EH,0010FH,00131H,00000H
		WORD	0011DH,0011EH,0011FH,00141H,00000H
		WORD	0012DH,0012EH,0012FH,00151H,00000H
		WORD	0000DH,0000EH,0000FH,000E5H,00000H
		WORD	0001DH,0001EH,0001FH,000F4H,00000H
		WORD	0002DH,0002EH,0002FH,0FFFFH
;
KNHEAD1		EQU	$
		WORD	00200H,00201H,00202H,00203H,00000H
		WORD	00204H,00205H,00206H,00207H,00000H
		WORD	00208H,00209H,0020AH,0020BH,00000H
		WORD	0020CH,0020DH,0020EH,0020FH,00000H
		WORD	00210H,00211H,00212H,00213H,00000H
		WORD	0002DH,00214H,00215H,0FFFFH
;
;-------------------------------------------------------CASARIN
;;;;K;;;;CSEYE0		EQU	$
;;;;K;;;;		WORD	00143H,00144H,00000H
;;;;K;;;;		WORD	00153H,00154H,0FFFFH
;;;;K;;;;;
;;;;K;;;;CSEYE1		EQU	$
;;;;K;;;;		WORD	001ACH,001ADH,00000H
;;;;K;;;;		WORD	00153H,001AEH,0FFFFH
;
CSHAND0		EQU	$
		WORD	00148H,00135H,00000H
		WORD	00158H,00145H,00000H
		WORD	00149H,00155H,0FFFFH
;
CSHAND1		EQU	$
		WORD	00248H,00249H,00000H
		WORD	00258H,00259H,00000H
		WORD	00268H,00269H,0FFFFH
;
CSSIPO0		EQU	$
		WORD	001A0H,001A1H,00000H
		WORD	001A2H,001A3H,00000H
		WORD	001A4H,0FFFFH
;
CSSIPO1		EQU	$
		WORD	001A5H,001A6H,00000H
		WORD	001A7H,001A8H,00000H
		WORD	001A9H,0FFFFH
;
CSSIPO2		EQU	$
		WORD	001AAH,001ABH,00000H
		WORD	001ACH,001ADH,00000H
		WORD	001AEH,0FFFFH
;
;-------------------------------------------------------KURBO
KBHEAD0		EQU	$
		WORD	00087H,00088H,00000H
		WORD	00097H,00098H,00099H,0FFFFH
;
KBHEAD1		EQU	$
		WORD	001FBH,001FCH,00000H
		WORD	001FDH,001FEH,001FFH,0FFFFH
;;;;K;;;;;
;;;;K;;;;;-------------------------------------------------------BAKDAN
;;;;K;;;;BKDK0		EQU	$
;;;;K;;;;		WORD	00082H,00083H,0FFFFH
;;;;K;;;;;
;;;;K;;;;BKDK1		EQU	$
;;;;K;;;;		WORD	00216H,00217H,0FFFFH
;;;;K;;;;;
;;;;K;;;;BKDK2		EQU	$
;;;;K;;;;		WORD	00218H,00219H,0FFFFH
;;;;K;;;;;
;;;;K;;;;;-------------------------------------------------------TOGEZOW
;;;;K;;;;TGZW0		EQU	$
;;;;K;;;;		WORD	000F8H,000F9H,0FFFFH
;;;;K;;;;;
;;;;K;;;;TGZW1		EQU	$
;;;;K;;;;		WORD	0023EH,0023FH,0FFFFH
;
;-------------------------------------------------------DDRIGES
DDRGS0		EQU	$
		WORD	0015BH,0015CH,0015DH,00000H
		WORD	0015EH,0015FH,00160H,00161H,00000H
		WORD	00162H,00163H,00164H,00165H,00166H,00000H
		WORD	00167H,00168H,00169H,0016AH,0016BH,0FFFFH
;
DDRGS1		EQU	$
		WORD	0016CH,0016DH,0016EH,00000H
		WORD	0016FH,00170H,00171H,00172H,00000H
		WORD	00173H,00174H,00175H,00176H,00177H,00000H
		WORD	00178H,00179H,0017AH,0017BH,0017CH,0FFFFH
;
DDRGS2		EQU	$
		WORD	0017DH,0017EH,0017FH,00000H
		WORD	00180H,00181H,00182H,00183H,00000H
		WORD	00184H,00185H,00186H,00187H,00188H,00000H
		WORD	00189H,0018AH,0018BH,0018CH,0018DH,0FFFFH
;
DDRGS3		EQU	$
		WORD	0018EH,0018FH,00190H,00000H
		WORD	00191H,00192H,00193H,00194H,00000H
		WORD	00195H,00196H,00197H,00198H,00199H,00000H
		WORD	0019AH,0019BH,0019CH,0019DH,0019EH,0FFFFH
;
;-------------------------------------------------------MARIO
MRHEAD0		EQU	$
		WORD	0004CH,0004DH,0004EH,0004FH,00000H
		WORD	0005CH,0005DH,0005EH,0005FH,00000H
		WORD	0006CH,0006DH,0006EH,0006FH,0FFFFH
;
MRHEAD1		EQU	$
		WORD	001B4H,001B5H,001B6H,001B7H,00000H
		WORD	001B8H,001B9H,001BAH,001BBH,00000H
		WORD	001BCH,001BDH,001BEH,001BFH,0FFFFH
;
MRHEAD2		EQU	$
		WORD	001C4H,001C5H,001C6H,001C7H,00000H
		WORD	001C8H,001C9H,001CAH,001CBH,00000H
		WORD	001CCH,001CDH,001CEH,001CFH,0FFFFH
;
MRHEAD3		EQU	$
		WORD	001C4H,001C5H,001C6H,001C7H,00000H
		WORD	001C8H,001C9H,001CAH,001D0H,00000H
		WORD	001CCH,001CDH,001CEH,001D2H,0FFFFH
;
MRHEAD4		EQU	$
		WORD	0003DH,0003EH,0003FH,0FFFFH
;
MRHEAD5		EQU	$
		WORD	001B1H,001B2H,001B3H,0FFFFH
;
MRHEAD6		EQU	$
		WORD	001C1H,001C2H,001C3H,0FFFFH
;
MRHEAD7		EQU	$
		WORD	001C1H,001C2H,001C3H,0FFFFH
;
MRHAND0		EQU	$
		WORD	00150H,00000H
		WORD	0013BH,00104H,00000H
		WORD	0013CH,0FFFFH
;
MRHAND1		EQU	$
		WORD	001D1H,00000H
		WORD	001D3H,001D3H,00000H
		WORD	001D5H,0FFFFH
;
;-------------------------------------------------------KUPPA
KPHAND0		EQU	$
		WORD	00037H,00038H,00000H
		WORD	00047H,00048H,00049H,00000H
		WORD	00057H,00058H,00059H,00000H
		WORD	00067H,00068H,00069H,0FFFFH
;
KPHAND1		EQU	$
		WORD	00226H,00227H,00000H
		WORD	00228H,00229H,0022AH,00000H
		WORD	0022BH,0022CH,0022DH,00000H
		WORD	00067H,0022FH,00230H,0FFFFH
;
KPHAND2		EQU	$
		WORD	00231H,00232H,00000H
		WORD	00233H,00234H,00235H,00000H
		WORD	00236H,00237H,00238H,00000H
		WORD	00067H,0023AH,0023BH,0FFFFH
;-------------------------------------------------------YOSI
YOSIDT0		EQU	$
		WORD	00243H,00244H,00245H,00246H,00000H
		WORD	00253H,00254H,00255H,00256H,00000H
		WORD	00263H,00264H,00265H,00266H,00000H
		WORD	00273H,00274H,00275H,00276H,0FFFFH
;
YOSIDT1		EQU	$
		WORD	0024AH,0024BH,0024CH,0024DH,00000H
		WORD	0025AH,0025BH,0025CH,0025DH,00000H
		WORD	0026AH,0026BH,0026CH,0026DH,00000H
		WORD	0027AH,0027BH,0027CH,0027DH,0FFFFH
;
YOSIDT2		EQU	$
		WORD	0024AH,0024BH,0024CH,0024DH,00000H
		WORD	0025AH,0025BH,0025CH,0025DH,00000H
		WORD	0026AH,0026EH,0026FH,0026DH,00000H
		WORD	0027AH,0027EH,0027FH,0027DH,0FFFFH
;
YOSIDT3		EQU	$
		WORD	0024AH,0024BH,0024CH,0024DH,00000H
		WORD	0025AH,0025BH,0025CH,0025DH,00000H
		WORD	0026AH,0024EH,0024FH,0026DH,00000H
		WORD	0027AH,0025EH,0025FH,0027DH,0FFFFH
;
YOSIDT4		EQU	$
		WORD	0024AH,0024BH,0024CH,0024DH,00000H
		WORD	0025AH,0025BH,0025CH,0025DH,00000H
		WORD	0026AH,00270H,00271H,0026DH,00000H
		WORD	0027AH,00272H,00279H,0027DH,0FFFFH
;
;
;
;************************************************************************
;*		Title flashing				(TLFLSH)	*
;************************************************************************
TLFLSH		EQU	$
		LDA	<FLSHCT
		BEQ	TLF050
		JMP	TLF800
TLF050		EQU	$
		LDA	<FLSIDX
		CMP	#01CH
		BEQ	TLF700
		LDA	#004H
		STA	<FLSHCT
;
		PHB
		PHK
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	<FLSIDX
		AND	#000FFH
		STA	<WORK4
		CMP	#0000EH
		BCS	TLF300
		LDA	#01CH			; CGWORK address set
		SEC
		SBC	<WORK4
		TAX
;
		LDY	#000H
TLF100		EQU	$			; flashing color set
		LDA	FLSCOL,Y
		STA	>CGWORK+0100H,X
		LDA	<WORK4
		BEQ	TLF500
		DEC	<WORK4
		DEC	<WORK4
		INX
		INX
		INY
		INY
		BRA	TLF100
;
TLF300		EQU	$
		LDA	<FLSIDX
		AND	#000FFH
		SEC
		SBC	#0000CH
		TAY
		LDX	#000H
TLF350		EQU	$
		LDA	FLSCOL,Y
		STA	>CGWORK+010EH,X
		INY
		INY
		INX
		INX
		CPX	#010H
		BNE	TLF350
;
TLF500		EQU	$
		LDY	<FLSIDX
		CPY	#012H
		BCS	TLF600
		LDA	FLSCL,Y
		STA	<WORK0
		LDX	#000H
		TXY
TLF550		EQU	$
		LDA	(<WORK0),Y
		STA	>CGWORK+012EH,X
		INX
		INX
		INX
		INX
		INY
		INY
		CPY	#(FLSCL2-FLSCL1)
		BNE	TLF550
;
TLF600		EQU	$
		INC	<FLSIDX
		INC	<FLSIDX
		INC	!CGDMAF
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		BRA	TLF800
;
TLF700		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	<DEMOTIME
		CMP	!FRASH2
		BNE	TLF750
		LDA	#0F0H
		STA	<FLSHCT
		STZ	<FLSIDX
TLF750		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		BRA	TLF900
;
TLF800		EQU	$
		DEC	<FLSHCT
TLF900		EQU	$
		RTS
;
;
FLSCOL		EQU	$
		WORD	07F52H,07FD7H,07FFDH,07FFFH,07FFDH,07FD7H,07F52H
		WORD	07ECFH,07ECFH,07ECFH,07ECFH,07ECFH,07ECFH,07ECFH
		WORD	07ECFH
;
FLSCL		EQU	$
		WORD	FLSCL8,FLSCL8,FLSCL7,FLSCL6,FLSCL5
		WORD	FLSCL4,FLSCL3,FLSCL2,FLSCL1
;
FLSCL1		EQU	$
		WORD	008FFH,007E4CH,003A3H,031FH,000F7H
;
FLSCL2		EQU	$
		WORD	015FFH,07EAFH,013E6H,0137FH,0015AH
;
FLSCL3		EQU	$
		WORD	021BFH,07F12H,023E9H,023DFH,001BDH
;
FLSCL4		EQU	$
		WORD	02E1FH,07F15H,033ECH,033FFH,00E1FH
;
FLSCL5		EQU	$
		WORD	03A7FH,07FD8H,047F0H,043FFH,01A7FH
;
FLSCL6		EQU	$
		WORD	046DFH,07FFBH,05BF3H,053FFH,026DFH
;
FLSCL7		EQU	$
		WORD	0533FH,07FFEH,06BF7H,063FFH,0333FH
;
FLSCL8		EQU	$
		WORD	05F9FH,07FFFH,07FFDH,073FFH,03F9FH
;
;
;
;
;
;
;
;
;
		END
