;************************************************************************
;*		    Serial Communication module				*
;*									*
;*		      Programmed by Y.Nishida				*
;*									*
;*						[ Jun.18, 1993 ]	*
;************************************************************************

		native
		extend

		include		PPUregs.h
		include		CPUregs.h
		include		SuperFXregs.h

		include		SystemWorks.h
		include		SuperFXworks.h

BANK7E		sect		REL

		global		PPIinitialize
		global		SCCinitialize
		global		EnableSCCint
		global		DisableSCCint
		global		SCCinterrupt
		global		SCCsendStart

		global		SCCactiveDTR
		global		SCCinactiveDTR
		global		SCCcheckDCD

		global		SCCactiveRTS
		global		SCCinactiveRTS
		global		SCCcheckCTS

		global		SCCclearBuffer

;=============== Device control I/O ports ===============================

SCC_ctrlPortB	equ		005F00H			; SCC channel B control port address
SCC_dataPortB	equ		005F01H			; SCC channel B data    port address
SCC_ctrlPortA	equ		005F02H			; SCC channel A control port address
SCC_dataPortA	equ		005F03H			; SCC channel A data    port address
;------------------------------------------------------------------------
PPI_portC	equ		005F12H			; PPI parallel port C
PPI_ctrl	equ		005F13H			; PPI command register

;************************************************************************
;*	Initialize PPI(uPD71055)					*
;*									*
;*	Disable PPI interrupt						*
;************************************************************************

		mem8
		idx8
PPIinitialize
		php
		sep		#00110000B		; Memory,Index 8 bit mode
		sei					; Disable IRQ
;------------------------------------------------------------------------
		lda		#10000010B		; PPI mode 0
		sta		PPI_ctrl		; portA out; portB in; portC out
		lda		#00000001B
		sta		PPI_portC		; Mask IRQ
;------------------------------------------------------------------------
		plp
		rtl

;************************************************************************
;*	Initialize SCC(Z8530)						*
;*									*
;************************************************************************

		mem8
		idx8
SCCinitialize
		php
		sep		#00110000B		; Memory,Index 8 bit mode
		sei					; 荞݂̋֎~

;=============== SCC Hardware reset =====================================

		lda		#09H
		sta		SCC_ctrlPortA		; WR09
		lda		#11000000B
		sta		SCC_ctrlPortA		; Hardware Reset

;=============== Initialize SCC channel A ===============================

		lda		#09H
		sta		SCC_ctrlPortA		; WR09
		lda		#10000000B
		sta		SCC_ctrlPortA		; Reset SCC channel A
;------------------------------------------------------------------------
		lda		#0BH
		sta		SCC_ctrlPortA		; WR11
		lda		#11010100B
		sta		SCC_ctrlPortA		; Set clock mode

;=============== Initialize SCC channel B ===============================
SCCinitialize10
		ldx		#00H
;------------------------------------------------------------------------
Repeat$		lda		>SCCinitialData,x
		bmi		Exit$
		sta		SCC_ctrlPortB
		inx
		lda		>SCCinitialData,x
		sta		SCC_ctrlPortB
		inx
		bra		Repeat$
;------------------------------------------------------------------------
Exit$		lda		#11101000B		; WR05
		sta		<transmitStatus
;------------------------------------------------------------------------
		plp
		rtl

;=============== SCC channel B initial data =============================
;
;				reg#   data
SCCinitialData	byte		009H,01000000B		; WR09: Reset SCC channel B
		byte		00EH,00000000B		; WR14: Stop baurate generator
		byte		001H,00000000B		; WR01: Disable interrupt
		byte		003H,11000000B		; WR03: Disable serial input
		byte		005H,11100010B		; WR05: Disable serial output
		byte		00FH,00000000B		; WR15: Disable all Status-Interrupt
		byte		000H,00010000B		; WR00: Reset Status-Interrupt
		byte		000H,00010000B		; WR00: Reset Status-Interrupt
		byte		00BH,01010000B		; WR11: Set clock mode
;------------------------------------------------------------------------
		byte		00CH,00111110B		; WR12: Set baurate low   (2400bps)
		byte		00DH,00000000B		; WR13: Set baurate high
		byte		00EH,00000001B		; WR14: Start Baurate generator
		byte		004H,01000100B		; WR04: Set stop bit 1 & non parity
		byte		003H,11000001B		; WR03: Enable serial input
		byte		005H,11101000B		; WR05: Enable serial output
		byte		009H,00001010B		; WR09: Enable interrupt ( master switch )
		byte		001H,00010010B		; WR01: Enable send/receive interrupt
		byte		0FFH
;------------------------------------------------------------------------
;	 RS232C baurate.
;
;	   300bps	510
;	   600bps	254
;	  1200bps	126
;	  2400bps	 62
;	  4800bps	 30
;	  9600bps	 14
;	 19200bps	  6


;************************************************************************
;*	Enable SCC interrupt						*
;*									*
;************************************************************************

		mem8
EnableSCCint
		php
		sep		#00100100B		; Disable IRQ
;------------------------------------------------------------------------
		lda		#09H
		sta		SCC_ctrlPortA		; Set control register number
		lda		#00001010B
		sta		SCC_ctrlPortA		; WR09: Enable SCC interrupt
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Disbale SCC interrupt						*
;*									*
;************************************************************************

		mem8
DisableSCCint
		php
		sep		#00100100B		; Disable IRQ
;------------------------------------------------------------------------
		lda		#09H
		sta		SCC_ctrlPortA		; Set control register number
		lda		#00000010B
		sta		SCC_ctrlPortA		; WR09: Disable SCC interrupt
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	SCC interrupt routine						*
;*									*
;************************************************************************

		mem8
		idx8
SCCinterrupt
		lda		#03H
		sta		SCC_ctrlPortA
		lda		SCC_ctrlPortA		; WR03: interrupt flags
;------------------------------------------------------------------------
		lsr		a			; channel B external interrupt ?
		bcs		SCCstatusInt		; Yes.
		lsr		a			; channel B send interrupt ?
		bcs		SCCsendInt		; Yes.
		lsr		a			; channel B reseive interrupt ?
		bcs		SCCreceiveInt		; Yes.
;------------------------------------------------------------------------
		lda		#00111000B
		sta		SCC_ctrlPortA		; WR00: SCC channel A IUS reset
		rts

;************************************************************************
;*	SCC external status interrupt routine (error interrupt)		*
;*									*
;************************************************************************

		mem8
		idx8
SCCstatusInt
		lda		SCC_dataPortB		; Dammy read.
		lda		#00110000B
		sta		SCC_ctrlPortB		; WR00: Reset error.
		lda		#00111000B
		sta		SCC_ctrlPortB		; WR00: SCC channel B IUS reset
		inc		<commError
		rts

;************************************************************************
;*	SCC transmission interrupt routine				*
;*									*
;************************************************************************

		mem8
		idx8
SCCsendInt
		lda		<TxCounter		; Data avairable ?
		beq		NoData$			; No.
;------------------------------------------------------------------------
		ldx		<TxPointer
		lda		TxDataBuffer,x
		sta		SCC_dataPortB		; Put data into transmitor.
		inx
		stx		<TxPointer
		dec		<TxCounter
		bra		Exit$
;------------------------------------------------------------------------
NoData$		lda		#00101000B
		sta		SCC_ctrlPortB		; Reset transmission IP
;------------------------------------------------------------------------
Exit$		lda		#00111000B
		sta		SCC_ctrlPortB		; WR00: SCC channel B IUS reset
		rts

;************************************************************************
;*	SCC reseption interrupt routine					*
;*									*
;************************************************************************

		mem8
		idx8
SCCreceiveInt
		lda		<RxCounter
		bne		SCCreceiveInt20
;------------------------------------------------------------------------
SCCreceiveInt10	lda		SCC_dataPortB
		sta		<RxCounter
		stz		<RxPointer
		jsr		SCCinactiveDTR
		bra		SCCreceiveInt21
;------------------------------------------------------------------------
SCCreceiveInt20	lda		SCC_dataPortB		; Get data from FIFO.
		ldx		<RxPointer
		sta		RxDataBuffer,x
		inx
		stx		<RxPointer
		dec		<RxCounter
;------------------------------------------------------------------------
SCCreceiveInt21	lda		#00111000B
		sta		SCC_ctrlPortB		; WR00: SCC channel B IUS reset
		rts

;************************************************************************
;*	Start transmission						*
;*									*
;************************************************************************

		mem8
SCCsendStart
		php
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		sta		<TxCounter
		stz		<TxPointer
		sta		SCC_dataPortB
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Active DTR (DTR = low)						*
;*									*
;************************************************************************

		mem8
SCCactiveDTR
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		#05H
		sta		SCC_ctrlPortB
		lda		<transmitStatus
		ora		#10000000B		; WR05: Enable serial output
		sta		SCC_ctrlPortB
		sta		<transmitStatus
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Inactive DTR (DTR = high)					*
;*									*
;************************************************************************

		mem8
SCCinactiveDTR
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		#05H
		sta		SCC_ctrlPortB
		lda		<transmitStatus
		and		#01111111B		; WR05: Enable serial output
		sta		SCC_ctrlPortB
		sta		<transmitStatus
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Active RTS (RTS = low)						*
;*									*
;************************************************************************

		mem8
SCCactiveRTS
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		#05H
		sta		SCC_ctrlPortB
		lda		<transmitStatus
		ora		#00000010B		; WR05: Enable serial output
		sta		SCC_ctrlPortB
		sta		<transmitStatus
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Inactive RTS (RTS = high)					*
;*									*
;************************************************************************

		mem8
SCCinactiveRTS
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		#05H
		sta		SCC_ctrlPortB
		lda		<transmitStatus
		and		#11111101B		; WR05: Enable serial output
		sta		SCC_ctrlPortB
		sta		<transmitStatus
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Check DCD							*
;*									*
;************************************************************************

		mem8
SCCcheckDCD
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		SCC_ctrlPortB
		and		#00001000B
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Check CTS							*
;*									*
;************************************************************************

		mem8
SCCcheckCTS
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		lda		SCC_ctrlPortB
		and		#00100000B
;------------------------------------------------------------------------
		plp
		rts

;************************************************************************
;*	Clear input buffer						*
;*									*
;************************************************************************

		mem8
SCCclearBuffer
		php
		sep		#00100100B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		DisableSCCint
		stz		TxCounter
		stz		TxPointer
		stz		RxCounter
		stz		RxPointer
		lda		SCC_dataPortB
		lda		SCC_dataPortB
		lda		SCC_dataPortB
		lda		SCC_dataPortB
		jsr		EnableSCCint
;------------------------------------------------------------------------
		plp
		rts

		end
