;****************************************************************************
;*		Mode 7 experiment Control subroutins                        *
;*						1991.06.21                  *
;****************************************************************************
		glb	Motion_control
;
;;;		ext	Tan,Calc_direction,Calc_vector_velocity
		ext	Calc_move_direction
		ext	Sin_data,Cos_data
		ext	Check_bg_screen
		ext	Check_collision
;
		include rp5a22
		include rp5c77
		include work
		include buffer
;****************************************************************************
;		data
limmit_power	equ	010h
tempolary	equ	012h
;
sign_data	equ	018h
centrifugal_flag  equ   01ah
force_power	equ	01ch
accel_data	equ	020h
engine_brake	equ	022h
;
direction_check	equ	010h		;3 direction status check
dif_BO_FO	equ	012h		;angle diffe body and force
dif_MO_FO	equ	014h		;      ;     move and force
;
steering_data	equ	030h
;****************************************************************************
		prog
Motion_control
		php
		jsr	!Check_bg_screen	;look up BG screen buffer
		jsr	!Check_collision	;check bummping obj
		mem8
		idx8
		sep	#00110000b
		lda	#00100000b
		trb	<status_flag		;status flag b5=storobo mode
		ldx	#02h
		jsr	!Control_sub		;upper screen player's control
		ldx	#00h
		jsr	!Control_sub		;lower screen player's control
		plp
		rts
;----------------------------------------------------------------------------
		mem8
		idx8
Control_sub
		sep	#00110000b
;
		lda	<button_trigger+01h,x
		bit	#00100000b
		beq	Not_debug_mode		;change debug mode
		lda	<debug_flag
		inc	a
		and	#00000011b
		sta	<debug_flag		;debug flag=00-03
		bra	Next_control
Not_debug_mode
;;;;;		lda     <button_status+01h,x
		bit	#00010000b
		beq	Not_pose_mode		;pose-on or pose-off
		lda	#10000000b		;status flag b7=pose mode
		eor	<status_flag
		sta	<status_flag
;;;;;		bra	Next_control
Not_pose_mode
		lda	<button_trigger+00h,x
		bit	#button_R
		beq	Check_reset		;control strobo mode
		lda	#00100000b
		tsb	<status_flag
Check_reset
		lda	<button_status+01h,x
		and	#11110000b
		cmp	#11110000b		;reset=ST,SL,YandB
		bne	Next_control
		lda	#11000000b
		sta	<status_flag
		rts
Next_control
		lda	<status_flag
		bpl	Calc_palameter
		bit	#00100000b
		bne	Calc_palameter
		rts
;----------------------------------------------------------------------------
Calc_palameter
;---------------------------------------------------move direction calclation
		mem8
		idx8
		lda	!object_flag+01h,x
		beq	XY_control
;----------------------------------------------------------------------------
Slik_cart
		jsr	!Calc_move_direction
;;;;;		jsr     !Gear_check
;;;;		jsr	!Slic_steering
		jsr     !Slic_power
		jsr	!Slic_cornering		;(and sttring)
		jsr	!Slipp_effect
		jsr     !Camera_control
		rts
;----------------------------------------------------------------------------
Fzero_control
;		jsr	!Gear_check
;		jsr	!Engine_control
;		jsr	!Steering_angle
;		jsr	!Calc_force_direction
;		jsr	!Set_camera_direc
;		rts	
;----------------------------------------------------------------------------
XY_control
		jsr	!Calc_move_direction
		jsr	!Gear_check
		jsr	!Force_control
		jsr	!Steering_speed
		jsr	!Camera_control
		rts
;----------------------------------------------------------------------------
		mem16
		idx8
Slipp_effect
		rep	#00100000b
		lda	!driving_force+00h,x
		bpl	Plus_slip_effect
		eor	#0ffffh
		inc	a
Plus_slip_effect
		sta	<tempolary
		mem8
		sep	#00100000b
;;		lda	!move_direction+01h,x
		lda	<camera_direction+01h,x
		sec
		sbc	!force_direction+01h,x
		bpl	MO_FO_plus
		eor	#0ffh
		inc	a
MO_FO_plus
		cmp	#40h
		bcc	Under_40h
		stz	!cornering_force+00h,x
		stz	!cornering_force+01h,x
		sbc	#080h
		eor	#0ffh
		inc	a
Under_40h
		tay
		lda	!Cos_data,y
		asl	a	
		sta	!Multiplicand
		lda	<tempolary+00h
		sta	!Multiplier
		ldy	<tempolary+01h
		mem16
		rep	#00100000b
		lda	#00ffh
		and	!Multiply+01h
		sty	!Multiplier
		ldy	!cornering_force+00h,x
		clc
		nop
		adc	!Multiply
		sty	!Multiplier
		ldy	!driving_force+01h,x
		bpl	Plus_diriving_effect
		eor	#0ffffh
		inc	a
Plus_diriving_effect
		sta	!driving_force+00h,x
		lda	#00ffh
		ldy	!cornering_force+01h,x
		and	!Multiply+01h
		sty	!Multiplier
		nop
		nop
		nop
		clc
		adc	!Multiply
		ldy	!steering_speed+01h,x
		bmi	Plus_cornering
		eor	#0ffffh
		inc	a
Plus_cornering
		sta	!cornering_force+00h,x
		rts
Cut_powers
		mem8
		stz	!cornering_force+00h,x
		stz	!cornering_force+01h,x
Not_slip_effect
		rts
;----------------------------------------------------------------------------
		mem16
		idx8
Slic_cornering
		rep	#00100000b
		lda	!steering_speed+00h,x
		bpl	Not_ST_minus
		eor	#0ffffh
		inc	a
Not_ST_minus		
		sta	!Multiplicand-01h
		ldy	!vector_velocity+01h,x
		sty	!Multiplier		;ST high * VV high
		tay				;y=ST low
		phy				;
		ldy	!vector_velocity+00h,x
		lda	!Multiply-01h
		sty	!Multiplier		;ST high * VV low
		ldy	!vector_velocity+01h,x
		and	#0ff00h
		clc
		adc	!Multiply
		sty	!Multiplicand
		ply				;y=ST low * VV high
		sty	!Multiplier
		clc
		nop
		nop
		nop
		adc	!Multiply
		pha
		ldy	!cornering_quality+01h,x
		sty	!Multiplicand
		sta	!Multiplier
		xba
		tay
		lda	#00ffh
		and	!Multiply+01h
		sty	!Multiplier
		clc
		nop
		nop
		nop
		adc	!Multiply
		sta	!cornering_resist,x
		ldy	!cornering_quality+00h,x
		sty	!Multiplicand
		pla
		xba
		sta	!Multiplier
		xba
		tay
		nop
		lda	!Multiply
		sty	!Multiplier
		xba
		and	#0ff00h
		clc
		adc	!Multiply
		cmp	!cornering_maximum,x
		bcc	Not_slipping_st
		lda	!cornering_maximum,x
Not_slipping_st
		sta	!cornering_force,x
		mem16
		idx8
Slic_steering
		rep	#00100000b
		lda	!vector_velocity,x
		cmp	#10h
		bcs	Rotate_slic
		stz	!steering_speed,x
		stz	!cornering_force,x
		stz	!cornering_resist,x
		rts
Rotate_slic
		lda	<button_status+00h,x
						;push L button ?
		bit	#0000001000000000b
		beq	No_L_slic
		lda	!steering_speed,x
		bpl	Nomal_L_steering
		clc
;;;		adc	!steering_accel,x
		adc	!fast_steering,x
		bra	Set_steering_slic
Nomal_L_steering
		clc
;;		adc	!steering_accel,x
		adc	!slow_steering,x
		bra	Set_steering_slic
No_L_slic
		bit	#0000000100000000b
		beq	No_R_slic
		lda	!steering_speed,x
		bmi	Nomal_R_steering
		sec
;;		sbc	!steering_accel,x
		sbc	!fast_steering,x
		bra	Set_steering_slic
Nomal_R_steering
		sec
;;		sbc	!steering_accel,x
		sbc	!slow_steering,x
		bra	Set_steering_slic
No_R_slic
;Steering_reduce
		lda	!steering_speed,x
		bmi	Reduce_minus_slic
		sec
;;		sbc	!steering_reduce,x
		sbc	!slow_steering,x
		bcs	Set_steering_slic
		lda	#00h
		bra	Set_steering_slic
Reduce_minus_slic
		clc
;;		adc	!steering_reduce,x
		adc	!slow_steering,x
		bcc	Set_steering_slic
		lda	#00h
Set_steering_slic
		sta     !steering_speed,x
;
		bmi	Minus_slic_steering
		cmp	!maximum_steering,x
		bcc	Set_slic_camera
		lda	!maximum_steering,x
		sta	!steering_speed,x
		bra	Set_slic_camera
Minus_slic_steering
		eor	#0ffffh
		inc	a
		cmp	!maximum_steering,x
		bcc	Set_slic_camera
		lda	!maximum_steering,x
		eor	#0ffffh
		inc	a
		sta	!steering_speed,x
Set_slic_camera;-------------------------------------------------------------
		lda	!steering_speed,x
		bpl	ST_sign_plus
		eor	#0ffffh
		inc	a
ST_sign_plus
		sta	<steering_data
		mem8
		sep	#00110000b
		lda	!force_direction+01h,x
		sec
		sbc	<camera_direction+01h,x
		bpl	FO_CA_plus
		eor	#0ffh
		inc	a
FO_CA_plus
		tay
		lda	!Cos_data,y
		asl	a
		sta	!Multiplicand
		lda	<steering_data+00h
		sta	!Multiplier
		ldy	<steering_data+01h
		mem16
		rep	#00100000b
		lda	#00ffh
		and	!Multiply+01h
		sty	!Multiplier
		clc
		nop
		nop
		nop
		adc	!Multiply
		ldy	!steering_speed+01h,x
		bpl	Steering_effect_plus
		eor	#0ffffh
		inc	a
Steering_effect_plus
		sta	<steering_data
;ST_plus_again
;;;;;;;;		lda	!steering_speed,x
		clc
;;;		adc	!force_direction,x
		adc	!body_direction,x
		pha
		sec
;;;		sbc	!move_direction,x
		sbc	<camera_direction,x
		bpl	FO_MO_plus
		eor	#0ffffh
		inc	a
FO_MO_plus
		cmp	#03c00h
		bcs	Over_limitt
		pla
		sta	!body_direction,x
;Set_force_direction
		pha
		sec
		sbc	!force_direction,x
		bcs	Set_c_flag_force
		bpl	Turn_left_force
;C_clear_minus
		eor	#0ffffh
		inc	a
		bra	Turn_right_force
Set_c_flag_force
		bpl	Turn_left_force
		eor	#0ffffh
		inc	a
		bra	Turn_right_force
Turn_left_force
		cmp	#01000h
		bcs	Over_plus_force
		cmp	#00160h
		bcc	Dont_move_force
		lda	!force_direction,x
		clc
		adc	#0160h
		sta	!force_direction,x
Dont_move_force
		pla
		rts
Over_plus_force
		pla
		sec
		sbc	#01000h
		sta	!force_direction,x
		rts
Turn_right_force
		cmp	#01000h
		bcs	Over_minus_force
		cmp	#0160h
		bcc	Dont_move_force
		lda	!force_direction,x
		sec
		sbc	#0160h
		sta	!force_direction,x
		pla
		rts		
Over_minus_force
		pla
		clc
		adc	#01000h
		sta	!force_direction,x
		rts
Over_limitt
		stz	!cornering_force,x
		stz	!driving_force,x
		pla
		rts		
;----------------------------------------------------------------------------
		mem16
		idx8
Slic_power
		rep	#00100000b
		stz	!bg_friction,x
		lda	!vector_velocity,x
		cmp	#0010h
		bcc	Slow_velo_slic
		lda	#0100h
		sta	!bg_friction,x
		lda	!bg_data,x
		and	#00ffh
		bne	Not_on_the_dart
		lda	#0400h
		sta	!bg_friction,x
Not_on_the_dart
Slow_velo_slic
;
		lda     <button_status+00h,x
		bit	#0100000010000000b
		bne     Braking_on_slic
		bpl     Accel_off_slic
;		bit     #0100000010000000b
;		bne     Braking_on_slic
;
		stz	!braking_power,x
		lda	!engine_power,x
		clc
;;;;		adc	!fast_accel,x
		adc	#010h
		cmp	!maximum_power,x
		bcc	Set_engine_slic
		bra	Over_engine
Accel_off_slic
		lda	!engine_power,x
		sec
;;;		sbc	!slow_accel,x
		sbc	#010h
		bcs	Set_engine_slic
		lda	#00h
		bra	Set_engine_slic
Braking_on_slic
		lda	!braking_power,x
		cmp	!maximum_braking,x
		bcs	Over_braking
		clc
;;;		adc	!braking_data,x
		adc	#020h
;;;		lda	!maximum_power,x
		sta	!braking_power,x
Over_braking
		lda	!engine_power,x
		sec
;;		sbc	!fast_accel,x
		sbc	#040h
		bcs	Set_engine_slic
		lda	#00h
Set_engine_slic
		sta	!engine_power,x
Over_engine
		lda	!engine_power,x
		sec
		sbc	!cornering_resist,x
		sec
		sbc	!braking_power,x
		sec
		sbc	!bg_friction,x
		sta	!driving_force,x
		bpl	Not_minus_force
		lda	!vector_velocity,x
		cmp	#0010h
		bcs	Not_minus_force
		stz	!driving_force,x
		stz	!vector_velocity,x
		stz	!velocity_xl,x
		stz	!velocity_xh,x
		stz	!velocity_yl,x
		stz	!velocity_yh,x
		lda	!body_direction,x
;;;		sta	!force_direction,x
		sta	!move_direction,x
Not_minus_force
		rts
;----------------------------------------------------------------------------
		mem16
		idx8
Steering_angle
		rep	#00100000b
		sep	#00010000b
		lda	!vector_velocity,x
		cmp	#0020h
		bcs	Steering_controlable
		rts
Steering_controlable
		lda	<button_status+00h,x
		bit	#0000000100000000b
		beq	Not_right_steering
		lda	!steering_angle,x
		sec
		sbc	!steering_accel	,x
		bpl	Set_steering_angle
		sta	!steering_angle,x
		eor	#0ffffh
		inc	a
		cmp	!maximum_steering,x
		bcc	Return_angle
		lda	!maximum_steering,x
		eor	#0ffffh
		inc	a
		bra	Set_steering_angle
Not_right_steering;----------------------------------------------------------
		bit	#0000001000000000b
		beq	Not_steering
		lda	!steering_angle,x
		clc
		adc	!steering_accel,x
		bmi	Set_steering_angle
		cmp	!maximum_steering,x
		bcc	Set_steering_angle		
		lda	!maximum_steering,x
		bra	Set_steering_angle
Not_steering;----------------------------------------------------------------
		lda	!steering_angle,x
		beq	Return_angle
		bmi	Now_right_steering
;Now_left_steering
		sec
		sbc	!steering_reduce,x
		bcs	Set_steering_angle
		lda	#0000h
		bra     Set_steering_angle
Now_right_steering
		clc
		adc	!steering_reduce,x
		bcc	Set_steering_angle
		lda	#0000h
Set_steering_angle
		sta	!steering_angle,x
Return_angle
		rts
;----------------------------------------------------------------------------
		mem16
		idx8
Engine_control
		rep	#00100000b
		lda	!gear_status,x
		bit	#0001h
		beq	Low_engine
;High_engine;----------------------------------------------------------------
		stz	<engine_brake
		lda	!high_accel,x
		sta	!accel_data
		ldy	<button_status+01h,x
		bpl	Off_accel_high
		bra	Accel_high_gear
Low_engine;------------------------------------------------------------------
;calc_engine_brake
		lda	!vector_velocity,x
		asl	a
		asl	a
		asl	a
		sta	<engine_brake
;----------------------------------------------------------------------------
		lda	!low_accel,x
		sta	<accel_data
		ldy	<button_status+01h,x
		bpl	Off_accel_low
;Accel_low_gear;-------------------------------------------------------------
		lda	!low_quality,x
		sta	!Multiplicand	
		lda	!vector_velocity+00h,x
		cmp	!special_velo2,x
		bcc	Low_lebel12
		lda	!special_velo2,x
Low_lebel12
		sec
		sbc	!special_velo1,x
		bcs	Low_lebel2
Low_lebel1
		eor	#0ffffh
		inc	a
Low_lebel2
		tay
		xba
		sta	!Multiplier
		nop
		sec
		lda	#1111111100000000b
		and	!Multiply-01h
		sty	!Multiplier
		sbc	!low_maximum,x
		nop
		clc
		adc	!Multiply+00h
		bra     Set_force_power
Off_accel_high
		lda	!low_accel,x
		sta	<accel_data
Off_accel_low
Low_lebel3
High_lebel1
		lda	#00h
		bra	Set_force_power
Accel_high_gear
		ldy	!high_quality,x
		sty	!Multiplicand
;
		lda     !vector_velocity+00h,x
		sec
		sbc	!special_velo3,x
		bcs	High_lebel2
		eor	#0ffffh
		inc	a
High_lebel2
		tay
		xba
		sta	!Multiplier
		sec
		lda	#1111111100000000b
		and	!Multiply-01h
		sty	!Multiplier
		nop
		sbc	!high_maximum,x
		clc
		adc	!Multiply+00h
Set_force_power
		eor	#0ffffh
		inc	a
		bmi	Over_power
		cmp	!engine_power,x
		bcc	Over_power
		lda	!engine_power,x
		clc
		adc	<accel_data
		bra	Set_Engine_Power	
Over_power
		lda	!engine_power,x
		sec
		sbc	!high_accel,x
		bcs	Set_Engine_Power
		lda	#0000h
;-------------------------------------------------------------------
Set_Engine_Power
		sta	!engine_power,x
		eor	#0ffffh
		inc	a
;;;;;		sta	<force_power
;;;		adc	!mu_data,x
		adc	#200h		;test=const
		adc	#400h
		sta	<force_power
					;friction effect
		lda	!gear_status,x
		bit	#0000000000000001b
		bne	High_friction
;Low_friction;------------------------------------------------------
		lda	<force_power
		clc
		adc	<engine_brake		
		sta	<force_power
		bra	Calc_braking
High_friction;------------------------------------------------------
		ldy	!air_quality,x
		sty	!Multiplicand
		ldy	!vector_velocity+01h,x
		sty	!Multiplier
		ldy	!vector_velocity+00h,x
		lda	#1111111100000000b
		nop
		and	!Multiply-01h
		sty	!Multiplier
		clc
		adc	<force_power
		nop
		adc	!Multiply+00h
		sta	<force_power
;cornering friction
		lda	!steering_angle+00h,x
		bpl	Steering_left_fic
		eor	#0ffffh
		inc	a
Steering_left_fic
		sta	!Multiplicand-01h
		ldy	!cornering_power+01h,x
		sty	!Multiplier
		ldy	!cornering_power+00h,x
		lda	#1111111100000000b
		nop
		and	!Multiply-01h
		sty	!Multiplier
		clc
		adc	<force_power
		nop
		adc	!Multiply+00h
		sta	<force_power
Calc_braking;-------------------------------------------------------
		lda	<button_status+00h,x
		bit	#0100000010000000b
		bne	Press_button
		stz     !braking_power,x
		lda	<force_power
		bra	Set_vector_velocity
Press_button;
		lda	!vector_velocity,x
		cmp	#0100h
		bcs	Not_zero_speed
		stz	!engine_power,x
		stz	<force_power
;;;;		rts
Not_zero_speed
		lda	!braking_power,x
		cmp	!maximum_braking,x
		bcs	No_more_braking
		clc
		adc	!braking_data,x
		sta	!braking_power,x
No_more_braking
		clc
		adc	<force_power
;
Set_vector_velocity
		bmi	Force_minus
		xba
		and	#00ffh
		bra	Sbc_velo
Force_minus
		xba
		ora	#0ff00h
Sbc_velo
		sec
		sbc	!vector_velocity,x
		eor	#0ffffh
		inc	a
		bpl	Vector_plus
		lda	#0000h
Vector_plus
		sta	!vector_velocity,x
		rts
;-------------------------------------------------------------------
		mem16
		idx8
Calc_force_direction
		rep	#00100000b
		sep	#00010000b
;Calc cornering force
		lda	!steering_angle,x
		bne	Go_on_direc
		stz	!cornering_force,x
		jmp	!Check_direction
Go_on_direc
		bpl	Not_angle_minus
		eor	#0ffffh
		inc	a
Not_angle_minus
		cmp	#1000h
;;;;		cmp	#0800h
		bcc	Calc_cornering_force
Over_max_steering
		sec
		sbc	#02000h
;;		sbc	#01000h
Minus_conering_force
		eor	#0ffffh
		inc	a
Calc_cornering_force
		sta	!Multiplicand-01h
		ldy	!cornering_data+00h,x
		sty	!Multiplier
		ldy	!cornering_data+01h,x
		lda	#0000000011111111b
		nop
		and	!Multiply-01h
		sty	!Multiplier
		clc
		nop
		nop
		nop
		adc	!Multiply
No_conering_force
		sta	!cornering_force,x
;;;
;Calc force direction
		lda	!vector_velocity,x
		cmp	#0040h
		bcs	Not_minimum_velo
		stz	!steering_angle,x
		rts
Not_minimum_velo
		cmp	#0300h
		bcs	Cornering_effect
		sec
		sbc	#0300h
		eor	#0ffffh
		inc	a
		adc	#0300h		
;		ldy	!steering_angle+01h,x
;		stz	!steering_angle,x
;		beq	Return_Angle	
;		bpl	Set_direction
;		eor	#0ffffh
;		inc	a
;		bra	Set_direction
Return_Angle
;		rts
Cornering_effect
		sta	<tempolary+04h
		stz	<tempolary+00h
		lda	!cornering_force,x
		sta	<tempolary+02h
;		lda	!vector_velocity,x
;		sta	<tempolary+04h
		lda	#0ffh
Check_cf_loop
		cmp	<tempolary+02h
		bcc	Shift_tempolary
		cmp	<tempolary+04h
		bcs	Goto_divide
Shift_tempolary
		lsr	<tempolary+04h
		lsr	<tempolary+02h
		ror	<tempolary+00h
		bra	Check_cf_loop
Goto_divide
		lda	<tempolary+01h
		sta	!Dividend
		ldy	<tempolary+04h
		beq	Sol_infinity
		sty	!Divisor
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		lda	!Quotient
		cmp	#00200h
		bcc	Not_over_roaling
Sol_infinity
		lda	#00200h
Not_over_roaling
		ldy	!steering_angle+01h,x
		bpl	Rotate_left_side
		eor	#0ffffh
		inc	a
Rotate_left_side
Set_direction
		clc
		adc	!force_direction+00h,x
		sta	!force_direction+00h,x
;;;		sta	!camera_direction,x
		sta	!body_direction,x
		rts
;
		lda	!steering_angle,x
		bpl	ST_angle_plus
		eor	#0ffffh
		inc	a
ST_angle_plus
		adc	#01000h
		sta	!Multiplicand-01h
		ldy	!vector_velocity+01h,x
		sty	!Multiplier
		ldy	!vector_velocity+00h,x
		nop
		nop
		lda	!Multiply-01h
		sty	!Multiplier
		and	#0ff00h
		nop
		nop
		clc
		adc	!Multiply
;
		sec
		sbc	#0300h
		rts
;;;		bcs	Slip_effect
;-------------------------------------------------------------------
Check_direction
Decrece_diff
;		lda	!direction_data,x
;		beq	Not_slip_angle
;		bmi	DR_data_minus
;		sec
;		sbc	#0018h
;		bcs	Set_slip_return
;		stz	!direction_data,x
;		bra	Not_slip_angle
D;R_data_minus
;		clc
;		adc	#0018h
;		bcc	Set_slip_return
;		stz	!direction_data,x
;		bra	Not_slip_angle
;Set_slip_return
;		sta	!direction_data,x
;		eor	#0ffffh
;		inc	a
;		clc
;		adc	!camera_direction,x
;		sta	!force_direction,x
;		rts
;Not_slip_angle
;		lda	!force_direction,x
;		sta	!camera_direction,x
;		rts
;;		lda	#0000h
;
;;;;;;;;;		cmp	!slip_direction,x
;		sta	!slip_direction,x
;		bcs	Increce_slip
;		stz	!slip_direction,x
;Decrece_slip;------------------------------------------------------
;		lda	!direction_data,x
;		beq	Not_diffrence_direc
;;
;		sec
;		sbc	#0010h
;;		
;		bcs	Cont_slipping
;		stz	!direction_data,x
;		rts
;Cont_slipping
;		sta	!direction_data,x
;		ldy	!steering_angle+01h,x
;		bpl	Cont_sl_plus
;		eor	#0ffffh
;		inc	a
;C;ont_sl_plus
;		clc
;		adc	!camera_direction,x
;		sta	!force_direction,x
;		rts	
;N;ot_diffrence_direc
;		lda	!force_direction,x
;		sta	!camera_direction,x
;		rts		
;-------------------------------------------------------------------
;Slip_effect
;Increce_slip;-------------------------------------------------------;
;		ldy	!steering_angle+01h,x
;		bmi	Steering_R_turn
;steering_L_turn
;		cmp	!direction_data,x
;		bcc	Over_L_turn
;Over_R_turn
;		lda	!direction_data,x
;		clc
;		adc	#0018h
;		bra	Set_F_direc
;Steering_R_turn
;		eor	#0ffffh
;		inc	a
;		cmp	!direction_data,x
;		bcc	Over_R_turn
;Over_L_turn
;		lda	!direction_data,x
;		sec
;		sbc	#0018h
;Set_F_direc
;		sta	!direction_data,x
;SF_direc_plus
;		clc
;		adc	!force_direction,x
;		sta	!camera_direction,x
;		rts
;----------------------------------------------------------------------------
;		mem8
;		idx8
;Calc_move_direction
;'		lda	!vector_velocity+01h,x
;';		bne	Cont_calc_MD
;		lda	!vector_velocity+00h,x
;		cmp	#040h
;		bcc	Not_set_MD
;Cont_calc_MD
;		phx
;		lda	!velocity_yh+00h,x
;		xba
;		lda	!velocity_yl+01h,x
;		mem16
;		idx16
;		rep	#00110000b
;		tay
;		mem8
;		sep	#00100000b
;		lda	!velocity_xh+00h,x
;		xba
;		lda	!velocity_xl+01h,x
;		mem16
;		rep	#00100000b
;		tax
;;
;;		jsr	!Tan
;		jsr	!Calc_direction
;		mem8
;		idx8
;		plx
;		bcs	Not_set_MD
;						;c=set
;		pha
;		sec
;		sbc	!move_direction+01h,x
;		bpl	Def_move_plus
;		eor	#0ffh
;		inc	a
;D;ef_move_plus
;		cmp	#020h
;		bcc	Set_move_direction
;		pla
;N;ot_set_MD
;		jsr	!Calc_vector_velocity
;		rts
;;;;		
;Set_move_direction
;		pla
;		sta	!move_direction+01h,x
;		jsr	!Calc_vector_velocity
;		rts
;-------------------------------------------------------------------
Gear_check
		mem8
		sep	#00100000b
		lda	<button_trigger+01h,x
		bit	#00001000b
		beq	Not_button_up
		lda	!gear_status,x
		bit	#00000001b
		bne	Not_change_gear
Trigger_high
		lda	#10000001b
		sta	!gear_status,x
		rts
Not_button_up
		bit	#00000100b
		beq	Not_button_down
		lda	!gear_status,x
		bit	#00000001b
		beq	Not_change_gear
Trigger_low
		lda	#10000000b
		sta	!gear_status,x
Not_button_down
Not_change_gear
		rts
;-----------------------------------------force direction calclation
		mem16
		idx8
Steering_speed
		rep	#00100000b
		lda	!vector_velocity,x
		cmp	#40h
		bcs	Rotate_on
;;		lda	!camera_direction,x
		lda	!body_direction,x
		sta	!force_direction,x
		stz	!steering_speed,x
		rts
Rotate_on
		lda	<button_status+00h,x
						;push L button ?
		bit	#0000001000000000b
		beq	No_L_button
		lda	!steering_speed,x
		bpl	Rotate_left
		lda	#00000h
		bra	Set_steering
Rotate_left
		clc
		adc	!steering_accel,x
		bra	Set_steering
No_L_button
		bit	#0000000100000000b
		beq	No_R_button
		lda	!steering_speed,x
		bmi	Rotate_right
		lda	#0ffffh
		bra	Set_steering
Rotate_right
		sec
		sbc	!steering_accel,x
		bra	Set_steering
No_R_button
Steering_reduce
		lda	!steering_speed,x
		bmi	Reduce_minus
		sec
		sbc	!steering_reduce,x
		bcs	Set_steering
		lda	#00h
		bra	Set_S_speed
Reduce_minus
		clc
		adc	!steering_reduce,x
		bcc	Set_steering
		lda	#00h
		bra	Set_S_speed
Set_steering
		pha
		bpl	Plus_steering
		eor	#0ffffh
		inc	a
Plus_steering
		cmp	!maximum_steering,x
		bcc	Not_limmit_steering
		pla
		bmi	Minus_limmit
		lda	!maximum_steering,x
		bra	Set_S_speed
Minus_limmit
		lda	!maximum_steering,x
		eor	#0ffffh
		inc	a
		bra	Set_S_speed
Not_limmit_steering
		pla
Set_S_speed
		sta	!steering_speed,x
		clc
;		adc	!camera_direction,x
;		sta	!camera_direction,x
		adc	!body_direction,x
		sta	!body_direction,x
		lda	!gear_status,x
		bit	#0000000000000001b
		bne	High_gear_steering
;		lda	!camera_direction,x
		lda	!body_direction,x
		sta	!force_direction,x
		rts
High_gear_steering
;;;
;;		lda	!camera_direction,x
		lda	!body_direction,x
		sec
		sbc	!force_direction,x
		bcs	RF_001
		bmi	RF_003
		bra	Rotate_force_left
RF_003
		eor	#0ffffh
		inc	a
		bra	Rotate_force_right	
RF_001
		bmi	RF_002
		bra	Rotate_force_left
RF_002
		eor	#0ffffh
		inc	a
Rotate_force_right
		cmp	#0a0h
		bcs	Camera_dif_100
;;;		lda	!camera_direction,x
		lda	!body_direction,x
		bra	Set_force_direc
Camera_dif_100
		lda	!force_direction,x
		sec
		sbc	#0a0h
		bra	Set_force_direc
Rotate_force_left
		cmp	#0a0h
		bcs	Camera_dif_200
;		lda	!camera_direction,x
		lda	!body_direction,x
		bra	Set_force_direc
Camera_dif_200
		lda	!force_direction,x
		clc
		adc	#0a0h
Set_force_direc
		sta	!force_direction,x
		rts
;------------------------------------------------------------------
Force_control
Check_accel
		mem16
		rep	#00100000b
		lda	<button_status+00h,x
		bpl	Accel_off
Accel_on
		bit	#0100000010000000b
		bne	Braking_on
;Not_braking
		stz	!braking_power,x
		lda	!gear_status,x
		bit	#00000001b
		bne	Set_high_gear
;------------------------------------------------------------------
Set_low_gear
		lda	!vector_velocity,x
		cmp	!special_velo1,x
		bcs	Over_low_speed
		lda	!engine_power,x
		clc
		adc	!slow_accel,x
		bra	Set_engine_power
Over_low_speed
		lda	!engine_power,x
		sec
		sbc	!fast_reduce,x
		bra	Set_engine_power
;------------------------------------------------------------------
Set_high_gear
		lda	!vector_velocity,x
		cmp	!special_velo2,x
		bcs	Max_power
Min_power
		lda	!engine_power,x
		clc
		adc	!slow_accel,x
		bra	Set_engine_power	
Max_power
		lda	!engine_power,x
		clc
		adc	!fast_accel,x
Set_engine_power
		cmp	!maximum_power,x
		bcs	Calc_friction
		sta	!engine_power,x
		bra	Calc_friction
;-------------------------------------------------------------------
Accel_off
		bit	#0100000010000000b
		bne	Braking_on
		lda	!gear_status,x
		bit	#0000000000000001b
		beq	Off_low_gear
;Off_high_gear
		lda	!engine_power,x
		sec
		sbc	!slow_reduce,x
		bcs	Set_accel_off
		lda	#0000h
		bra	Set_accel_off
Off_low_gear
		lda	!engine_power,x
		sec
		sbc	!fast_reduce,x
		bcs	Set_accel_off
		lda	#0000h
Set_accel_off
		sta	!engine_power+00h,x
		bra	Calc_friction
;-------------------------------------------------------------------
Braking_on
		lda	!engine_power,x
		sec
		sbc	!fast_reduce,x
		bcs	Set_brake_on
		lda	#0000h
Set_brake_on
		sta	!engine_power,x
;;;
		lda	!vector_velocity,x
		bne	Not_engine_stop
		stz	!engine_power,x
Not_engine_stop
		lda	!braking_power,x
		clc
		adc	!braking_data,x
		cmp	!maximum_braking,x
		bcc	Set_brake_data
		lda	!maximum_braking,x
Set_brake_data
		sta	!braking_power,x
;---------------------------------------------Not BG check version
		mem16
Calc_friction
		lda	!gear_status,x
		bit	#0000000000000001b
		bne	Fric_high_gear
Fric_low_gear;------------------------------------------------------
		lda	!button_status,x
		bpl	Fric_high_gear
;		lda	!vector_velocity,x
;		cmp	!special_velo,x
;		bcc	Not_over_velocity
;		stz	!driving_force,x
;		lda	!maximum_braking,x
;		eor	#0ffffh
;		inc	a
;		sta	!friction_power,x
;		bra	Minus_force_power		
Not_over_velocity
		clc
		lda	#0000h
		bra	High_torque_set
Fric_high_gear;-----------------------------------------------------
;;;;;;;;;	ldy	!mu_data,x
		ldy	#020h			;standerd velue
		sty	!Multiplicand
		ldy	!friction_quality+00h,x
		sty	!Multiplier
		nop
		nop
		nop
		nop
		lda	!Product+00h
		sta	!bg_friction,x
						;anti BG friction
High_torque_set
		adc	!braking_power,x
		eor	#0ffffh
		inc	a
		sta	!friction_power,x
						;total friction
Set_driving_force
		clc
		adc	!engine_power,x
		bmi	Minus_force_power
		sta	!driving_force,x
		stz	!friction_power,x
		bra	Gap_function
Minus_force_power
		lda	!vector_velocity+00h,x
		cmp	#0020h
		bcs	Gap_function
		stz     !driving_force,x
		stz	!friction_power,x
		stz	!velocity_xl,x
		stz	!velocity_xh,x
 		stz	!velocity_yl,x
		stz	!velocity_yh,x
		stz	!vector_velocity,x
Gap_function
		lda	!vector_velocity,x
		cmp	#0100h
		bcs	Exist_gap_func
		lda	#0000h
		bra	Set_air_fric
Exist_gap_func
		mem8
		sep	#00110000b
		lda	!move_direction+01h,x
		sec
		sbc	!force_direction+01h,x
		bpl	Not_over_80h
		eor	#0ffh
		inc	a
Not_over_80h
		lsr	a
		sta	!Multiplicand
		lda	!gap_quality,x
		sta	!Multiplier
		mem16
		rep	#00100000b
		nop
		nop
		clc
		lda	!Product+00h
		adc	#100h
;;;;;;;;;	sta	!gap_function,x
		sta	<tempolary+00h
		sta	!Multiplicand-01h	
						;* gap func (high)
		ldy	!air_quality+01h,x
		sty	!Multiplier
						;*air qual (high)
		phy
		ldy	!air_quality+00h,x
		nop
		nop
		lda	!Product+00h
		sty	!Multiplier
						;*  gap func (high)
						;*  air qual (low)
		cmp	#0080h
		bcs	Over_air_fric
		xba
		sta	<tempolary+02h
		ldy	<tempolary+00h
		lda	!Product+01h
		sty	!Multiplicand
		ply
		sty	!Multiplier
						;*  gap func (low)
						;*  air qual (high)
		and	#00ffh
		sta	<tempolary+00h
		clc
		lda	!Product+01h
		and	#00ffh
		adc	<tempolary+02h
		adc	<tempolary+00h
		eor	#0ffffh
		inc	a
		sta	!air_friction+00h,x
		rts
Over_air_fric
		ply
		lda	#08000h
						;(minus 7fffh)
Set_air_fric
		sta	!air_friction+00h,x
		rts
;----------------------------------------------------------------------------
Camera_control
Set_camera_direc
                mem8
                idx8
                sep     #00110000b
		lda	<control_status
		beq	Subjective_view
;Objective_view
		lda	!move_direction+01h,x
		sec
		sbc	<camera_direction+01h,x
		beq	Dont_move_camera
		bpl	Plus_mo_ca
		cmp	#0e0h
		bcc	Dont_move_camera
		dec	<camera_direction+01h,x
		bra	Set_back_scroll
Plus_mo_ca
		cmp	#020h
		bcs	Dont_move_camera
		inc	<camera_direction+01h,x
		bra	Set_back_scroll
Subjective_view;-------------------------------------------------------------
		lda	!force_direction+01h,x
		sta	!body_direction+01h,x
Set_camera_direction
		sta	<camera_direction+01h,x
Set_back_scroll;
Dont_move_camera
                ldy	<camera_direction+01h,x
                lda     !Sin_data,y
                sta     <sin_component+00h,x
                lda     !Cos_data,y
                sta     <cos_component+00h,x
                lda     <camera_direction+01h,x
                clc
                eor     #0ffh
                inc     a
                rol     a
                rol     a
                pha
                rol     a
                asl     a
                and     #00000110b
                tay
                lda     !Back_v_data,y
                sec
                sbc     !Ofset_data,x
                sta     <back_v,x
                pla
                and     #11111100b
		sta	<back_h,x
 		rts
;----------------------------------------------------------------------------		
Back_v_data
		word    0000h,0020h,0040h,0060h
Ofset_data
		word    0000h,0070h
		end
