;*******************************************************************
;*		Mode 7 experiment Control subroutins               *
;*						1991.02.01         *
;*******************************************************************
		glb	Motion_control
;
		ext	Tan
		ext	Sin_data,Cos_data
;
		include rp5a22
		include rp5c77
		include work
		include buffer
;*******************************************************************
		data
limmit_power	equ	010h
tempolary	equ	012h
sign_data	equ	018h
centrifugal_flag  equ   01ah
;*******************************************************************
		prog
Motion_control
		php
		mem8
		idx8
		sep	#00110000b
		ldx	#00h
		jsr	!Control_sub
		ldx	#02h
		jsr	!Control_sub
		plp
		rts
;-------------------------------------------------------------------
Control_sub
		lda	<button_trigger+01h,x
		bit	#00100000b
		beq	Not_debug_mode
		lda	<debug_flag
		inc	a
		and	#00000011b
		sta	<debug_flag
		bra	Next_control
Not_debug_mode
;;;;;		lda     <button_status+01h,x
		bit	#00010000b
		beq	Not_pose_mode
		lda	#10000000b
		eor	<status_flag
		sta	<status_flag
;;;;;		bra	Next_control
Not_pose_mode
		lda	<button_status+01h,x
		and	#11110000b
		cmp	#11110000b
		bne	Next_control
		lda	#11000000b
		sta	<status_flag
		rts
Next_control
		lda	<status_flag
		bpl	Calc_palameter
		rts
;
Calc_palameter
;-----------------------------------------move direction calclation
		phx
		lda	!velocity_yh+00h,x
		xba
		lda	!velocity_yl+01h,x
		mem16
		idx16
		rep	#00110000b
		tay
		mem8
		sep	#00100000b
		lda	!velocity_xh+00h,x
		xba
		lda	!velocity_xl+01h,x
		mem16
		rep	#00100000b
		tax
;
		jsr	!Tan
		mem8
		idx8
		plx
		bcs	Set_move_direction
Veloxy_equ_zero
						;c=clear
		lda	!force_direction+01h,x
Set_move_direction
		sta	!move_direction+00h,x
		ldy	!drive_status,x
		bpl	Check_slipping
;-------------------------------------------------------------------
On_slipping
		mem16
		rep	#00100000b
		stz	<centrifugal_flag
		lda	!centrifugal_x,x
		beq	No_centx
		bpl	On_slipx_plus
		clc
		adc	!bg_friction,x
		bcc	Keep_centx
		lda	#0000h
		dec	<centrifugal_flag
		bra	Keep_centx
On_slipx_plus
		sec
		sbc	!bg_friction,x
		bcs     Keep_centx
No_centx
		lda	#0000h
		dec	<centrifugal_flag
Keep_centx
		sta	!centrifugal_x,x
;
		lda	!centrifugal_y,x
		beq	No_centy
		bpl	On_slipy_plus
		clc
		adc	!bg_friction,x
		bcc	Keep_centy
No_centy
		lda	#0000h
		dec	<centrifugal_flag
		bra	Keep_centy
On_slipy_plus
		sec
		sbc	!bg_friction,x
		bcs	Keep_centy
		lda	#0000h
		dec	<centrifugal_flag
Keep_centy
		sta	!centrifugal_y,x
		bra	Check_cent_flag		
;-------------------------------------------------------------------
		mem8
Check_slipping
;		sec
;		sbc	!force_direction+01h,x
;		bpl	Rotate_velo_plus
;		eor	#0ffh
;		inc	a
;Rotate_velo_plus
;		cmp	#014h
;		bcs	Start_slipping
;		jmp	!No_centrifugal
;;-------------------------------------------------------------------
;		mem8
;Start_slipping
;		lda	#0ffh
;		sta	!drive_status,x
		mem16		
		rep	#00100000b
;		lda	!vector_velocity,x
;		cmp	#0180h
;		bcs	On_centrifugal
;		mem8
;		sep	#00100000b
;		bra	No_centrifugal
On_centrifugal
		stz	<centrifugal_flag
		mem16
		lda	!acceleration_xl,x
		bmi	Accelx_minus
		cmp	!bg_friction,x
		eor	#0ffffh
		inc	a
		bcs	Centx_plus
		bra	Centx_minus
Accelx_minus
		eor	#0ffffh
		inc	a
		cmp	!bg_friction,x
		bcs	Centx_plus
Centx_minus
		dec	<centrifugal_flag
Centx_plus
		sta	!centrifugal_x,x
;Set_centy----------------------------------------------------------
		lda	!acceleration_yl,x
		bmi	Accely_minus
		cmp	!bg_friction,x
		eor	#0ffffh
		inc	a
		bcs	Centy_plus
		bra	Centy_minus
Accely_minus
		eor	#0ffffh
		inc	a
		cmp	!bg_friction,x
		bcs	Centy_plus
Centy_minus
		dec	<centrifugal_flag
Centy_plus
		sta	!centrifugal_y,x
;-------------------------------------------------------------------
Check_cent_flag
		ldy	<centrifugal_flag
		cpy	#0feh
		bne	Starting_slipping
		lda	!drive_status,x
		and	#0ff00h
		sta	!drive_status,x
		bra	Steering_control
Starting_slipping
		lda	!velocity_xl,x
		sta	!slip_velo_xl,x
		lda     !velocity_xh,x
		sta	!slip_velo_xh,x
		lda     !velocity_yl,x    
		sta	!slip_velo_yl,x
		lda	!velocity_yh,x
		sta	!slip_velo_yh,x
		bra	Steering_control
;-------------------------------------------------------------------
End_centrifugal
		sep	#00100000b
		mem8
No_centrifugal
		stz	!drive_status,x	
;-----------------------------------------force direction calclation
		mem16
		rep	#00100000b
Steering_control
;Steering_effects
		lda	!vector_velocity+00h,x
;		lsr	a
;		lsr	a
		lsr	a
		cmp	#0080h
		bcc	Not_over_effects
Maximum_effects
		lda	#07fh
Not_over_effects
		sta	!steering_effect+00h,x
;
		ldy	!drive_status,x
		bpl	Nomal_steering
Slipping_steering
		lda	#0007fh
		sta	!steering_effect,x
		lda	!steering_speed,x
		bmi	Slipping_minus
		sec
		sbc	#0010h
		cmp	#0080h
		bcs	Set_S_speed
		lda	#0080h
		bra	Set_S_speed
Slipping_minus
		clc
		adc	#0010h
		cmp	#0ff80h
		bcc	Set_S_speed
		lda	#0ff80h
		bra	Set_S_speed
;-------------------------------------------------------------------
Nomal_steering
;Search sterring button
		lda	<button_status+00h,x
						;push L button ?
		bit	#0000001000000000b
		beq	No_L_button
		lda	!steering_speed,x
		bpl	Rotate_left
		lda	#00000h
		bra	Set_steering
Rotate_left
		clc
		adc	!steering_accel,x
		bra	Set_steering
No_L_button
		bit	#0000000100000000b
		beq	No_R_button
		lda	!steering_speed,x
		bmi	Rotate_right
		lda	#0ffffh
		bra	Set_steering
Rotate_right
		sec
		sbc	!steering_accel,x
		bra	Set_steering
No_R_button
Steering_reduce
		lda	!steering_speed,x
		bmi	Reduce_minus
		sec
		sbc	!steering_reduce,x
		bcs	Set_steering
		lda	#00h
		bra	Set_S_speed
Reduce_minus
		clc
		adc	!steering_reduce,x
		bcc	Set_steering
		lda	#00h
		bra	Set_S_speed
Set_steering
		pha
		bpl	Plus_steering
		eor	#0ffffh
		inc	a
Plus_steering
		cmp	!maximum_steering,x
		bcc	Not_limmit_steering
		pla
		bmi	Minus_limmit
		lda	!maximum_steering,x
		bra	Set_S_speed
Minus_limmit
		lda	!maximum_steering,x
		eor	#0ffffh
		inc	a
		bra	Set_S_speed
Not_limmit_steering
		pla
Set_S_speed
		sta	!steering_speed,x
;------------------------------------------------------------------
Gear_control
		mem8
		sep	#00100000b
		lda	<button_trigger+01h,x
		bit	#00001000b
		beq	Not_button_up
		lda	!gear_status,x
		bit	#00000001b
		bne	Not_change_gear
		lda	#10000001b
		sta	!gear_status,x
		bra	Set_high_gear
Not_button_up
		bit	#00000100b
		beq	Not_button_down
		lda	!gear_status,x
		bit	#00000001b
		beq	Not_change_gear
		lda	#10000000b
		sta	!gear_status,x
		bra	Set_low_gear
Not_button_down
Not_change_gear
		mem8
		lda	!gear_status,x
		bit	#00000001b
		bne	Set_high_gear
;------------------------------------------------------------------
Set_low_gear
		mem16
		rep	#00100000b
		lda	!vector_velocity,x
		cmp	!special_velo1,x
		bcc	Max_power
;		sec
;		sbc	!special_velo2,x
;		bcs	Min_power
;		eor	#0ffffh
;		inc	a
;		bra	Calc_limmit
Min_power
		lda	!minimum_power,x
		bra	Calc_engine_power
Max_power
		lda	!maximum_power,x
		bra	Calc_engine_power
;------------------------------------------------------------------
Set_high_gear
		rep 	#00100000b
		lda	!vector_velocity,x
		cmp	!special_velo2,x
		bcs	Max_power
;		sec
;		sbc	!special_velo1,x
;		bcc	Min_power
;------------------------------------------------------------------
Calc_limmit
		ldy	!engine_quality+01h,x
		sty	!Multiplicand
		tay
		sty	!Multiplier
		xba
		tay
		nop
		nop
		nop
		lda	!Product+00h
		sty	!Multiplier
		nop
		nop
		sta	<tempolary
		clc
		lda	!Product+01h
		and	#0ff00h
		adc	<tempolary+00h
		adc	!minimum_power+00h,x
;------------------------------------------------------------------
Calc_engine_power
	        sta	!limmit_power_h,x
Accelection_control
		ldy	<button_status+01h,x
		bpl	No_B_button
		cmp	!engine_power_h,x
		bcc	No_more_power
		lda	!engine_power_h+00h,x
		clc
		adc	!accel_data+00h,x
		sta	!engine_power_h+00h,x		
		bra	Check_brake
No_B_button
No_more_power
		lda	!engine_power_h+00h,x
		sec
		sbc	!reduce_data+00h,x
		sta	!engine_power_h+00h,x
		bcs	Check_brake
Engine_power_off
		stz	!engine_power_h+00h,x
Check_brake
		lda	<button_status+00h,x
		bit	#0100000010000000b
		bne	ON_Y_button
		lda	#00h
		bra	Set_brake_data
ON_Y_button
		lda	!vector_velocity,x
		bne	Not_engine_stop
		stz	!engine_power_h,x
Not_engine_stop
		lda	!braking_power,x
		clc
		adc	!braking_data,x
		cmp	!maximum_braking,x
		bcc	Set_brake_data
		lda	!maximum_braking,x
Set_brake_data
		sta	!braking_power,x
;---------------------------------------------Not BG check version
		mem16
Calc_friction
;;;;;;;;;	ldy	!mu_data,x
		ldy	#020h			;standerd velue
		sty	!Multiplicand
		ldy	!friction_quality+00h,x
		sty	!Multiplier
		nop
		nop
		nop
		nop
		lda	!Product+00h
		sta	!bg_friction,x
						;anti BG friction
		adc	!braking_power,x
		eor	#0ffffh
		inc	a
		sta	!friction_power,x
						;total friction
Set_driving_force
		clc
		adc	!engine_power_h,x
		bmi	Minus_force_power
		sta	!driving_force,x
		stz	!friction_power,x
		bra	Gap_function
Minus_force_power
		stz	!driving_force,x
		lda	!vector_velocity+00h,x
		cmp	#0020h
		bcs	Gap_function
		stz	!friction_power,x
		stz	!velocity_xl,x
		stz	!velocity_xh,x
 		stz	!velocity_yl,x
		stz	!velocity_yh,x
		stz	!vector_velocity,x
Gap_function
		lda	!vector_velocity,x
		cmp	#0100h
		bcs	Exist_gap_func
		lda	#0000h
		bra	Set_air_fric
Exist_gap_func
		mem8
		sep	#00110000b
		lda	!move_direction+00h,x
		sec
		sbc	!force_direction+01h,x
		bpl	Not_over_80h
		eor	#0ffh
		inc	a
Not_over_80h
		lsr	a
		sta	!Multiplicand
		lda	!gap_quality,x
		sta	!Multiplier
		mem16
		rep	#00100000b
		nop
		nop
		clc
		lda	!Product+00h
		adc	#100h
;;;;;;;;;	sta	!gap_function,x
		sta	<tempolary+00h
		sta	!Multiplicand-01h	
						;* gap func (high)
		ldy	!air_quality+01h,x
		sty	!Multiplier
						;*air qual (high)
		phy
		ldy	!air_quality+00h,x
		nop
		nop
		lda	!Product+00h
		sty	!Multiplier
						;*  gap func (high)
						;*  air qual (low)
		cmp	#0080h
		bcs	Over_air_fric
		xba
		sta	<tempolary+02h
		ldy	<tempolary+00h
		lda	!Product+01h
		sty	!Multiplicand
		ply
		sty	!Multiplier
						;*  gap func (low)
						;*  air qual (high)
		and	#00ffh
		sta	<tempolary+00h
		clc
		lda	!Product+01h
		and	#00ffh
		adc	<tempolary+02h
		adc	<tempolary+00h
		eor	#0ffffh
		inc	a
		sta	!air_friction+00h,x
		bra	Set_camera_direc
Over_air_fric
		ply
		lda	#08000h
						;(minus 7fffh)
Set_air_fric
		sta	!air_friction+00h,x
Set_camera_direc
                mem8
                idx8
                sep     #00110000b
                lda     !direction+01h,x
                sta     <camera_direc+01h,x
                tay
                lda     !Sin_data,y
                sta     <sin_component+00h,x
                lda     !Cos_data,y
                sta     <cos_component+00h,x
Set_back_scroll;
                lda     <camera_direc+01h,x
                clc
                eor     #0ffh
                inc     a
                rol     a
                rol     a
                pha
                rol     a
                asl     a
                and     #00000110b
                tay
                lda     !Back_v_data,y
                sec
                sbc     !Ofset_data,x
                sta     <back_v,x
                pla
                and     #11111100b
                sta     <back_h,x
 		rts
;--------------------------------------------------------------------		
Back_v_data
		word    0000h,0020h,0040h,0060h
Ofset_data
		word    0000h,0070h
		end
