;****************************************************************************
;*          Modo no.7 examination initiarize progr			    *
;*                                            				    * 
;*					     1991.06.21			    *
;****************************************************************************
		glb	Initialize_process
		glb	Selection_process
		glb	Clear_OAM
		ext	Parth_data1
		ext	Parth_data2
		ext	Cos_data,Sin_data
		ext	COS,Tan
		ext	Display_select
		include rp5a22
		include rp5c77
		include work
		include buffer
		include D77C25
;*****************************************************************************
tempolary	equ	010h
pointer		equ	018h
address		equ	01ah
counter		equ	01ch
angle_data	equ	020h
multi_data	equ	020h
;
x_counter	equ	020h
y_counter	equ	022h
screen_address	equ	024h
;
;angle_data	equ	010h
dist_data	equ	012h
;*****************************************************************************
		prog
		mem8
		idx8
Initialize_process
		;----------this process will carry out before 
		;---------the main routine starts 
		php
		jsr     !Parth_init
		jsr	!Multiply_init
		jsr	!Resister_clear
		jsr	!VRAM_init_100
		jsr	!Direction_init
		jsr	!Clear_OAM
		jsr	!DSP_init
		plp
 		rts
;-----------------------------------------------------------------------------
		mem8
		idx8
DSP_init
		ldx	#128
		lda	#dsp_reset
Reset_dsp_loop
		sta	>DSP_data
		dex
		bne	Reset_dsp_loop
		rts
;-----------------------------------------------------------------------------
Selection_process
		php
		mem8
		idx8
		sep	#00110000b
;
		jsr	!Selection_control
		bcs	Start_the_game
		plp
		rts
Start_the_game		
		stz	!NMI_control
		lda	#10001111b
		sta	!PPU_control
						;blanking		
						;chose game mode
		jsr	!VRAM_init_200		; and	
		jsr	!RAM_init		;     start !!!
		jsr	!Clear_OAM
;
		lda	#10000001b
		sta	!NMI_control		;NMI enable
		lda	#10000011b
		sta     !Through_screen+00h
		lda	#00001111b
		sta	!PPU_control		;blanking off
;2
		lda	#02h
		sta	<game_status
		plp
		cli				;IRQ enable
		rts
;-----------------------------------------------------------------------------
		mem8
		idx8
Selection_control
		lda	<control_status
		cmp	#02h
		bcc	Nomal_control_status
		stz	<control_status
Nomal_control_status
		lda	!obj_character+00h
		cmp	#03h
		bcc	Nomal_chara_num1
		stz	!obj_character+00h
		lda	!Character_palet_data
		sta	!obj_character+01h
Nomal_chara_num1
		lda	!obj_character+02h
		cmp	#03h
		bcc	Nomal_chara_num2
		stz	!obj_character+02h
		lda	!Character_palet_data
		sta	!obj_character+03h
Nomal_chara_num2
		lda	<map_number
		cmp	#05h
		bcc	Nomal_map_num
		lda	#01h
		sta	<map_number
Nomal_map_num
		lda	<select_pointer
		cmp	#04h
		bcc	Nomal_select
		stz	<select_pointer
Nomal_select
;
		ldy	#02h
Select_loop
		lda	!button_trigger+01h,y	;
						;if you press A,B or start BT	
						;   game start !!(set c bit)
		bit	#11010000b	
		beq	Continue_selection
		sec
		rts
Continue_selection;----------------------------------------------------------
		bit	#00001000b
		beq	Not_press_up
		lda	<select_pointer
		dec	a
		and	#00000011b
		sta	<select_pointer
		bra	Go_to_display
Not_press_up
		bit	#00000100b
		beq	Not_press_down
		lda	<select_pointer
		inc	a
		and	#00000011b
		sta	<select_pointer
		bra	Go_to_display
Not_press_down
		bit	#00000011b
		beq	Not_press_LR
		lda	<select_pointer
		asl	a
		tax
		jsr	(!Select_sub,x)
Not_press_LR
		dey
		dey
		bpl	Select_loop
Go_to_display
		jsr	!Display_select
;
		clc
		rts
;----------------------------------------------------------------------------
Select_sub	word	Select_status,Select_driver1,Select_driver2,Select_map
;----------------------------------------------------------------------------
Select_status
		lda	<control_status
		inc	a
		and	#00000001b
		sta	<control_status
		rts
Select_driver1
		lda	!obj_character+00h
		inc	a
		cmp	#03h
		bcc	Set_driver_01
		lda	#00h
Set_driver_01
		sta	!obj_character+00h
		tax
		lda	!Character_palet_data,x
		sta	!obj_character+01h
		rts
Select_driver2
		lda	!obj_character+02h
		inc	a
		cmp	#03h
		bcc	Set_driver_02
		lda	#00h
Set_driver_02
		sta	!obj_character+02h
		tax
		lda	!Character_palet_data,x
		sta	!obj_character+03h
		rts
Select_map
		lda	<map_number
		inc	a
		cmp	#05h
		bcc	Set_map_num
		lda	#00h
Set_map_num
		sta	<map_number
Not_change_select
		rts
;****************************************************************************
Multiply_init
		php
		mem8
		idx16
		rep	#00010000b
		sep	#00100000b
		ldx	#00h
		stz	<angle_data+00h
		stz	<angle_data+01h
Multiply_loop100
		ldy	<angle_data
		lda	!Sin_data,y
		sta	!Multiplicand
		stz	<dist_data
Multiply_loop200
		lda	<dist_data
		sta	!Multiplier
		nop
		nop
		nop
		nop
		lda	!Multiply+01h
		sta	>multiply_buffer+00h,x
;;		lda	!Multiply+01h
;;		sta	>multiply_buffer+01h,x	
;;;		inx
		inx	
		inc	<dist_data
		bne	Multiply_loop200	
Next_angle
		lda	<angle_data
		inc	a
		cmp	#040h
		beq	End_multiply_loop
		sta	<angle_data
		bra	Multiply_loop100
End_multiply_loop
		plp
		rts
;*****************************************************************************
Direction_init
		php
		mem16
		idx16
		rep	#00110000b
		ldx	#00h
		stz	<x_counter
Set_direc_loop1
		stz	<y_counter
Set_direc_loop2
		phx
		ldy	<y_counter
		cpy	<x_counter
		bcc	X_bigger_Y
		ldx	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		bra	Set_direc_buffer
X_bigger_Y
		mem16
		idx16
		ldx	<y_counter
		ldy	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		sec
		sbc	#040h
		eor	#0ffh
		inc	a
Set_direc_buffer
		sta	>direc_buffer,x
		inx
		mem16
		rep	#00110000b
		lda	<y_counter
		cmp	#003fh
;;;		cpy	#003fh
		beq	Next_x_angle
		inc	<y_counter
		bra	Set_direc_loop2
Next_x_angle
		lda	<x_counter
		inc	a
		cmp	#0040h
		beq	End_direc_loop
		sta	<x_counter
		bra	Set_direc_loop1
End_direc_loop
		plp
		rts
;****************************************************************************
Parth_init
		php
		mem8
		idx16
		rep	#00010000b
		sep	#00100000b
		ldx	#00h
		stz	<counter 
loop_h1
		idx16
		phx
		mem8
		idx8
		sep	#00110000b
		ldx	<counter
		lda	!Cos_data,x
		sta	<angle_data
		idx16
		rep	#00010000b
		plx	 
		ldy	#00h
loop_h2
		lda	!Parth_data2+00h,y
		sta	!211bh
		lda	!Parth_data2+01h,y
		sta	!211bh
		lda	<angle_data
		sta	!211ch
		lda     !2135h
		sta	>7f2000h,x
		lda	!2136h
		sta	>7f2001h,x
		inx
		inx
		iny
		iny
		cpy 	#00c0h
		bcc	loop_h2
		lda	<counter
		inc 	a
		cmp	#081h
		beq	Camera_pos_set
		sta	<counter
		bra	loop_h1
Camera_pos_set
		mem8
		idx8
		sep	#00110000b
;;;		lda	#056h		;from camera to player
		lda	#040h
		sta	!211bh
		stz	!211bh
		ldx	#00h
		ldy	#07fh		;Angle=-80h~00h
					;cos=-1~1
Camera_loop		
		lda	!Cos_data,y
		sta	!211ch
		lda	!2135h
		sta	!1000h,x
		lda	!2136h
		sta	!1001h,x
		inx
		inx
		dey
		bpl	Camera_loop
End_loop
		plp
		rts
;*****************************************************************************
Resister_clear
		php
		mem8
		idx8
		sep	#00110000b
		lda	#00000010b
		sta	!Sprite_size
					;sprite size=8or16 b567=00
					;OBJ bank use 0&1  b34=00
					;OBJ base addr=4000h b012=04

		lda	#00000111b
		sta	!Screen_mode
					;BG char size=8 b4567=00
					;use Mode 7     b012=07
		stz	!Screen_mosaic
					;not use Mosaic
		stz	!Screen_bank+00h
					;mode7's screen addr=0000h
		lda	#01110011b
		sta	!Screen_bank+01h
					;mode1's screen addr=7000
					;screen size=03h
		lda	#01100000b
		sta	!Screen_segment
					;mode7's(BG1) char seg.=0
					;mode1's(BG2) char seg.=6
		lda	#10000000b
		sta	!Screen_flip
					;out of screen=no.0 char b67=10
		lda	#01h
		ldx	#0ffh
;
		stz	!Rotation_A	;A parameter low 8 bit
		sta	!Rotation_A	;            high
		stz	!Rotation_B	;B parameter low 8 bit
		stz	!Rotation_B	;            high
		stz	!Rotation_C	;C parameter low 8 bit
		stz	!Rotation_C	;            high
		stz	!Rotation_D	;D parameter low 8 bit
		sta	!Rotation_D	;            high
;
		stz	!Rotation_center+00h	;x center
		lda	#02h
		sta	!Rotation_center+00h
		stz	!Rotation_center+01h	;y center
		sta	!Rotation_center+01h
;
		lda	#80h
		ldx	#01h
		sta	!Scroll_0H
		stx	!Scroll_0H
		sta	!Scroll_0V
		stx	!Scroll_0V
;
		stz	!Window_control+00h
		stz	!Window_control+02h
						;winndow off
		lda	#00010000b
		sta	!Through_screen+00h
;						;through main
						;main=BG12& OBJ
		stz	!Through_screen+01h
						;through sub disable
		lda	#00110000b
		sta	!Color_control		 
						;color window off
		stz	!Color_brend 
						;color add disable
		lda	#11100000b
		sta	!Color_bias
						;color bias data
		stz	!PPU_option
						;b7=0 not super inpose
						;b6=0 not ext input
						;b45  not use
						;b3=0 not 512 mode
						;b2=0 224 line/1 field
						;b1=0 OBJ V select
						;b0=0 non interless 
		stz	!Timer_H+00h
		stz	!Timer_H+01h
						;H count timer
		stz	!Timer_V+00h
		stz	!Timer_V+01h
						;V count timer
		stz	!Out_expansive
						;Joystick enable
		plp
		rts
;*****************************************************************************
		mem8
		idx8
VRAM_init_100
		php
		sep	#00110000b
		ldy	#01h
Set_BG_char
		lda	#080h
		sta	!Screen_step
						;b7=1 H bit INC
						;b0123=INC step(1)
		stz	!Screen_address+00h
		stz	!Screen_address+01h
						;set start address
		stz	!DMA_0+00h
						;b7=ROM to PPU
						;b6=absolute address
						;b4=auto increment
						;b3=auto increment
						;b012=word select
		lda	#19h
		sta	!DMA_0+01h
						;set 2119h resister
		stz	!DMA_0+02h
		lda	#080h
		sta	!DMA_0+03h
		lda	#03h
		sta	!DMA_0+04h
						;from 38000h address
		stz	!DMA_0+05h
		lda	#040h
		sta	!DMA_0+06h
						;trans quantity=4000h
		sty	!DMA_burst
						;start channel 0_DMA
Set_back_char
		stz     !Screen_address+00h
		lda	#060h
		sta	!Screen_address+01h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		stz	!DMA_0+02h
		lda	#0c0h
		sta	!DMA_0+03h
		lda	#03h
		sta	!DMA_0+04h
						;from 3c000h address
		stz	!DMA_0+05h
		lda	#020h
		sta	!DMA_0+06h
						;trans quantity=2000h
		sty	!DMA_burst
						;start channel 0_DMA
Set_alphabet
		stz     !Screen_address+00h
		lda	#040h
		sta	!Screen_address+01h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
 		stz	!DMA_0+02h
		lda	#0c0h
		sta	!DMA_0+03h
		lda	#04h
		sta	!DMA_0+04h
						;from 4c000h address
		stz	!DMA_0+05h
		lda	#020h
		sta	!DMA_0+06h
						;trans quantity=2000h
		sty	!DMA_burst
						;start channel 0_DMA

Set_color
		stz	!Color_address
						;CG_RAM start address
		lda	#00000010b
		sta	!DMA_0+00h
						;b012=set data twice
		lda	#022h
		sta	!DMA_0+01h
						;set 2122h
		stz     !DMA_0+02h
		lda	#0feh
		sta	!DMA_0+03h
		lda	#04h
		sta     !DMA_0+04h
						;from 4fe00h address
		stz     !DMA_0+05h
		lda	#02h
		sta     !DMA_0+06h
						;trans quantity=200h
		sty     !DMA_burst
						;start channel 0_DMA
Set_back_screen
		mem16
		idx8
		rep	#00100000b
;
		ldy	#00000001b
		sty     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		ldy     #18h
		sty     !DMA_0+01h
						;set 2119h
;
		ldx	#00h
		lda	#07000h
		sta     !Screen_address+00h
Set_back_loop
		lda	!Back_address+00h,x
		jsr	!Set_DMA_param		
		inx
		inx
		cpx	#08h
		bcc	Set_back_loop
		bne	Set_back_branch
		lda	#07400h
		sta     !Screen_address+00h
Set_back_branch
		cpx	#10h
		bcc	Set_back_loop
		plp
		rts
;-----------------------------------------------------------------------------
		mem16
		idx8
Set_DMA_param		
		sta	!DMA_0+02h
		ldy	#03h
		sty	!DMA_0+04h
						;data  address
		lda	#100h
		sta	!DMA_0+05h
						;trans quantity=40h
		ldy	#00000001b
		sty	!DMA_burst
						;start channel 0_DMA
		rts
;-----------------------------------------------------------------------------
Back_address
		word	0e700h,0ef00h,0f700h,0ff00h
		word	0ef00h,0f700h,0ff00h,0e700h
;-----------------------------------------------------------------------------
OBJ_data_address
		word    0a000h,0004h		;x-y conrol 1
		word	08000h,0004h		;f-zero control 1
Screen_data_bank
		byte	010h,011h,012h,013h,014h		
;-----------------------------------------------------------------------------
		mem8
		idx8
VRAM_init_200
;;
Set_obj_char
		php
		sep	#00110000b
;
		ldy	#001h
;
		stz     !Screen_address+00h
		lda	#50h
		sta	!Screen_address+01h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda     #18h
		sta     !DMA_0+01h
						;set 2119h
		stz	!DMA_0+05h
		lda	#020h
		sta	!DMA_0+06h
						;trans quantity=4000h
;Select objct
;		lda	<control_status
;		asl	a
;		asl	a
;		tax
;		lda	!OBJ_data_address+00h,x
;		sta	!DMA_0+02h
;		lda	!OBJ_data_address+01h,x
;		sta	!DMA_0+03h
;		lda	!OBJ_data_address+02h,x
;		sta	!DMA_0+04h		
		stz	!DMA_0+02h
		lda	#080h
		sta	!DMA_0+03h
		lda	#07h
		sta	!DMA_0+04h
		sty	!DMA_burst
						;start channel 0_DMA
Set_mode7_screen
		stz	!Screen_step
						;b7=0 L bit INC
						;b0123=INC step(1)
		stz     !Screen_address+00h
		stz	!Screen_address+01h
						;set start address
		ldx	<map_number
		lda	!Screen_data_bank,x
		sta	<screen_address+02h		;select screen bank
		mem16
		idx16
		rep	#00110000b
		ldx	#00h
Set_screen_loop
		rep	#00110000b
		stz	<pointer
		txa
		cmp 	#2000h
		rol	<pointer
		and	#01fffh
		cmp	#1000h
		rol	<pointer
		asl	<pointer
		pha
		and	#0000000001100000b
		lsr	a
		lsr	a
		ora	<pointer
		tay
		lda	!Offset_data,y
		sta	<screen_address
		pla
		pha
		and	#0000000000011111b
		asl	a
		sta	<tempolary
		pla
		and	#0000111110000000b
		lsr	a
		ora	<tempolary
		clc
		adc	<screen_address+00h
		sta	<screen_address+00h
		mem8
		sep	#00100000b
		lda	[<screen_address]
		sta	>screen_buffer,x
					   ;screen buffeer=7fa000h
		inx
		cpx	#04000h
		bne	Set_screen_loop
;-----------------------------------------------------------------------------
;From screen buffer to VRAM area
		lda	#000h
		sta	!Screen_step
;						;b7=0 L bit INC
;						;b0123=INC step(1)
		stz	!Screen_address+00h
		stz	!Screen_address+01h
;						;set start address
		stz	!DMA_0+00h
;						;b7=ROM to PPU
;						;b6=absolute address
;						;b4=auto increment
;						;b3=auto increment
;						;b012=word select
		lda	#18h
		sta	!DMA_0+01h
;						;set 2119h resister
		stz	!DMA_0+02h
		lda	#0a0h
		sta	!DMA_0+03h
		lda	#07fh
		sta	!DMA_0+04h
;						;from 38000h address
		stz	!DMA_0+05h
		lda	#040h
		sta	!DMA_0+06h
;						;trans quantity=4000
		lda	#001h
		sta	!DMA_burst
;						;start channel 0_DMA
		plp
		rts
;-----------------------------------------------------------------------------
Offset_data
		word	08000h,09000h,0c000h,0d000h
		word	08800h,09800h,0c800h,0d800h
		word	0a000h,0b000h,0e000h,0f000h
		word	0a800h,0b800h,0e800h,0f800h
;
Screen_buffer	equ	020000h
;
Initial_priority
		word	4000h,4102h,4204h,4306h,4408h,450ah,460ch,470eh
		;       40-47=dummy priority data
;----------------------------------------------------------------------------
;-------------(low) vram address & (high) b0=use obj higher bank-------------
Obj_num_data1
		word	0100h,0104h,0108h,010ch,0140h,0144h,0148h,014ch
Obj_num_data2
		word	0180h,0184h,0188h,018ch,01c0h,01c4h,01c8h,01cch
;*****************************************************************************
RAM_init
		php
		mem8
		idx8
		sep	#00110000b
		stz	<frame_counter
		stz	<IRQ_flag
		lda	#02h
		sta	<screen_mode
		lda	<control_status
		sta	!object_flag+01h	;  XY contol	
		sta	!object_flag+03h	;      or 
						;   F-ZERO control
		lda	#080h
		sta	!object_flag+00h
		sta	!object_flag+02h
;----------------------------------------------------------------------------
Obj_priority_init
		ldx	#0eh
Set_prio_loop
		lda	!Initial_priority,x
		sta	!obj_priority_1+00h,x
		sta	!obj_priority_2+00h,x
		dex
		dex
		bpl	Set_prio_loop
;----------------------------------------------------------------------------
		mem16
		rep	#00100000b
		ldx	#0eh
Obj_number_loop
		lda	!Obj_num_data1,x
		sta	!obj_number1,x			;for screen 1
		lda	!Obj_num_data2,x
;;;		ora	!Obj_palet_data,x
		sta	!obj_number2,x			;for screen 2
		stz	!obj_size1,x			;low=obj size
		stz	!obj_size2,x			; &high=obj angle 
		dex
		dex
		bpl	Obj_number_loop
;----------------------------------------------------------------------------
;
		ldx	#02h
Set_buffer_loop
Common_initial
		mem8
		sep	#00100000b
;
		lda	!obj_character+01h
		sta	!obj_number1+01h
		sta	!obj_number2+01h
		lda	!obj_character+03h
		sta	!obj_number1+03h
		sta	!obj_number2+03h
;
		mem16
		rep	#00100000b
		lda	#08000h
		sta	!force_direction+00h,x
		sta	!move_direction,x
		sta	!body_direction,x
		sta	<camera_direction,x
						;move direction
						;rotate velocity
		stz	!vector_velocity+00h,x
		stz	!velocity_xl+00h,x
		stz	!velocity_xh+00h,x
		stz	!velocity_yl+00h,x
		stz	!velocity_yh+00h,x
		stz	!driving_force,x
		stz	!gear_status,x	       ;+00h gear status
				               ;+01h drive status
;
		stz	!mycar_pose,x
;
		lda	!object_flag,x
		bit	#0000000100000000b
		bne	Slic_initial
;;;;;;		bne	Fzero_initial
		jmp	!XY_initial
;----------------------------------------------------------------------------
Slic_initial
		lda	#0100h
		sta	!weight_data,x
		lda	#0100h
		sta	!gravity_data,x
;gear & power
		stz	!engine_power,x
		lda	#0018h
		sta	!fast_accel,x
		lda	#0008h
		sta	!slow_accel,x
		lda	#0060h
		sta	!fast_reduce,x
		lda	#0020h
		sta	!slow_reduce,x
		lda	#01800h
		sta	!maximum_power,x
		lda	#01000h
		sta	!minimum_power,x
		lda	#00120h
		sta	!special_velo1,x
		lda	#00e0h
		sta	!special_velo2,x
;steering
		stz	!steering_speed,x
		lda	#00180h
		sta	!maximum_steering,x
		lda	#0030h
		sta	!slow_steering,x
		lda	#0060h
		sta	!fast_steering,x
;braking
		stz	!braking_power,x
		lda	#020h
		sta	!braking_data,x
		lda	!maximum_power,x
		lsr	a
		lsr	a
		sec
		sbc	!maximum_power,x
		eor	#0ffffh
		inc	a
		sta	!maximum_braking,x
		lda	#0080h
		sta	!friction_quality,x
		lda	#0800h
		sta	!maximum_velocity,x
		lda	#040h
		sta	!gap_quality,x
		lda	#000fdh
		sta	!air_quality+00h,x
		lda	#0020h
		sta	!friction_quality,x
;
		stz	!cornering_resist,x
		stz	!cornering_force,x
;
		lda	#0800ch
		sta	!cornering_quality,x
						;low=cornering force
						;high=cornering resist
		lda	#01000h
		sta	!cornering_maximum,x
		jmp	!Next_initial
;----------------------------------------------------------------------------
;Fzero_initial
;gear & power
;		stz	!engine_power,x
;		lda	#006h
;		sta	!high_accel,x
;		lda	#0028h
;		sta	!low_accel,x
;		lda	#03000h
;		sta	!low_maximum,x
;		lda	#03000h
;		sta	!high_maximum,x
;;
;		lda	#0010h
;		sta	!low_quality,x
;		lda	#0008h
;		sta	!high_quality,x
;
;		lda	#0c0h
;		sta	!special_velo1,x
;		lda	#0280h
;		sta	!special_velo2,x
;		lda	#0400h
;		sta	!special_velo3,x
;		lda	#02400h
;		sta	!special_velo4,x
;steering
;		stz	!steering_angle,x
;		lda	#0900h
;		sta	!maximum_steering,x
;		lda	#0060h
;		sta	!steering_accel,x
;		lda	#0040h
;		sta	!steering_reduce,x
;cornering
;		stz	!cornering_force,x
;;;;;		stz	!cornering_fx,x
;;;;		stz	!cornering_fy,x
;		lda	#06000h
;		sta	!cornering_data,x
;		lda	#00180h
;		sta	!cornering_power,x
;air friction
;		lda	#05h
;		sta	!air_quality,x
;braking
;		stz	!braking_power,x
;		lda	#080h
;		sta	!braking_data,x
;		lda	#2000h
;		sta	!maximum_braking,x
;
;		jmp	!Next_initial
;-----------------------------------------------------------------------------
XY_initial
		lda	#0100h
		sta	!weight_data,x
		lda	#0100h
		sta	!gravity_data,x
;gear & power
		stz	!engine_power,x
		lda	#0018h
		sta	!fast_accel,x
		lda	#0008h
		sta	!slow_accel,x
		lda	#0060h
		sta	!fast_reduce,x
		lda	#0020h
		sta	!slow_reduce,x
		lda	#03000h
		sta	!maximum_power,x
		lda	#02000h
		sta	!minimum_power,x
		lda	#00120h
		sta	!special_velo1,x
		lda	#00e0h
		sta	!special_velo2,x
;steering
		stz	!steering_speed,x
		lda	#00300h
		sta	!maximum_steering,x
		lda	#0018h
		sta	!slow_steering
		lda	#0030h
		sta	!fast_steering,x
;;;;;;		stz	!steering_effect,x
;braking
		stz	!braking_power,x
		lda	#020h
		sta	!braking_data,x
		lda	!maximum_power,x
		lsr	a
		lsr	a
		sec
		sbc	!maximum_power,x
		eor	#0ffffh
		inc	a
		sta	!maximum_braking,x
		lda	#0080h
		sta	!friction_quality,x
		lda	#0800h
		sta	!maximum_velocity,x
		lda	#008h
		sta	!gap_quality,x
		lda	#0fc00h
		sta	!air_quality+00h,x
;
		stz	!cornering_resist,x
		stz	!cornering_force,x
		lda	#01000h
		sta	!cornering_maximum,x
		lda	#0800ch
		sta	!cornering_quality,x
						;low=for cornering force
						;high=for cornering resist
;Calc parameter
		lda	!weight_data,x
		sta	<multiplicand
		lda	!maximum_power,x
		jsr	!Multi_weight
		cmp	#8000h
		bcc	Not_limmit_max
		lda	#07fffh
Not_limmit_max
		lda	!fast_accel,x
		jsr	!Multi_weight
		sta	!fast_accel,x
;
		lda	!slow_accel,x
		jsr	!Multi_weight
		sta	!slow_accel,x
;
		lda	!fast_reduce,x
		jsr	!Multi_weight
		sta	!fast_reduce,x
;
		lda	!slow_reduce,x
		jsr	!Multi_weight
		sta	!slow_reduce,x
;
		lda	!braking_data,x
		jsr	!Multi_weight
		sta	!braking_data,x
;
		lda	!maximum_braking,x
		jsr	!Multi_weight
		sta	!maximum_braking,x
;						;
		lda	!maximum_power+01h,x
		and	#00ffh
		lsr	a
		sta	!friction_quality,x
;
;		lda	!maximum_power,x
;		sta	<dividend
;		lda	!maximum_velocity,x
;		sta	<divisor
;		jsr	!Div_1616
;		mem8
;		sep	#00100000b
;;;		lda	<ans_low+01h
;		lda	#0fah				
;		sta	!air_quality+00h,x
;;		mem16
;		rep	#00100000b
;		sec
;		lda	!maximum_power,x
;		sbc	!minimum_power,x
;		sta	<dividend
;;;;;;;		sec
;		lda	!special_velo2,x
;;;;;;;;		sbc	!special_velo1,x
;		sta	<divisor
;		jsr	!Div_1616
;		mem8
;		sep	#00100000b
;		sta	!engine_quality+01h,x		;;;test
;
		mem16
		rep	#00100000b
Next_initial;	
		dex
		dex
		bmi	End_drive_loop
		jmp	!Set_buffer_loop
End_drive_loop
;Set position data
		lda	<control_status
		asl	a
		asl	a
		asl	a
		asl	a
		tay
		ldx	#00h
Position_loop
		lda	!Posx_data,y
		sta	!position_xh,x
		stz	!position_xl,x
		lda	!Posy_data,y
		sta	!position_yh,x
		stz	!position_yl,x
		lda	#0ffffh
		sta	!obj_pointa,x		;00h=screen1 01h=screen2
		iny
		iny
		inx
		inx
		cpx	#10h
		bne	Position_loop
;
		ldx	#0eh
Another_loop
		mem16
		rep	#00100000b
		lda	#0ff80h
		sta	!object_flag,x
		lda	#08000h
		sta	!force_direction,x
		sta	!move_direction,x
		sta	!body_direction,x
		mem8
		sep	#00100000b
		lda	!OBJ_character_data-02h,x
		sta	!obj_character+00h,x
		tay
		lda	!Character_palet_data,y
		sta	!obj_character+01h,x
		sta	!obj_number1+01h,x
		sta	!obj_number2+01h,x
		dex
		dex
		cpx	#02h
		bne	Another_loop
		plp
		rts
;----------------------------------------------------------------------------
OBJ_character_data;	02h car ------0eh car
		word	00,01,02,00,01,02
Character_palet_data
;-------------color palet data
		byte    02h,04h,08h
;			mario,luigi,kuppa		
;----------------------------------------------------------------------------
Posx_data
Posx_data_00
;		word	280h,284h,200h,27ch,28ch,278h,290h,274h
		word	235h,23ch,220h,227h,22eh,243h,24ah,251h
Posx_data_01
		word	074h,070h,060h,058h,05ch,064h,06ch,068h
;----------------------------------------------------------------------------
Posy_data
Posy_data_00
		word	208h,208h,208h,208h,208h,208h,208h,208h
Posy_data_01
		word    22ch,224h,220h,218h,210h,214h,21ch,228h
;----------------------------------------------------------------------------
		mem16
Multi_weight
		sta	<multiplier
		jsr	!Multi_1616
		mem8
		sep	#00100000b
		xba
		lda	<ans_low+01h
		rep	#00100000b
		rts
;------------------------------------------------------------------
Clear_OAM
		php
		mem8
		idx16
		rep	#00010000b
		sep	#00100000b
;;;		ldx	#0400h
		ldx	#0440h
;;		lda	#080h
		lda	#01010101b
Clear_OAM_main
		sta	!0bbfh,x
		dex
		bne	Clear_OAM_main
;		ldx	#040h
;		lda	#055h
;Clear_OAM_sub
;		sta	!0fbfh,x
;		dex
;		bne	Clear_OAM_sub
		plp
		rts
;------------------------------------------------------------------
Multi_1616
;					mem 16 bit
;					idx  8 bit
;					multiplicand 16bit 00,01h
;					multiplier   16bit 02,03h
;					ans. low     16bit 04,05h
;					ans. high    16bit 05,06h
		mem16
		idx8
		ldy	<multiplicand+01h
		sty	!Multiplicand
		ldy	<multiplier+01h
		sty	!Multiplier
		ldy	<multiplier+00h
		phx
		ldx	<multiplicand+00h
		nop
		lda	!Product+00h
		sty	!Multiplier
		sta	<tempolary+00h
		ldy	<multiplier+01h
		nop
		nop
		lda	!Product+00h
		stx	!Multiplicand
		sty	!Multiplier
		sta	<tempolary+02h
		plx
		nop
		nop
		lda	!Product+00h
		clc
		adc	<tempolary+02h
		xba
		sta	<ans_low
		and	#00ffh
		adc	<tempolary+00h
		sta	<ans_high
		rts
;		
;------------------------------------------------------------------
Div_1616
		mem16
		idx8
;					dividend   00,01h
;					divisor	   02,03h
;					ans low    04,05h	   
;					ans high   06h,07h
		stz	<tempolary+00h
		lda	<divisor
Devide_loop
		cmp	#0100h
		bcc	Goto_divide
		lsr	a
		lsr	<dividend
		ror	<tempolary+00h
		bra	Devide_loop
Goto_divide
		tay
		lda	#00ffh
		tsb	<tempolary+00h
		lda	<dividend
		sta	!Dividend
		sty	!Divisor
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		lda	!Quotient
		sta	<ans_high
		lda	!Residue+00h
		and	#000ffh
		ora	<tempolary
		xba
		sta	!Dividend
		sty	!Divisor
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		ldy	!Quotient+00h
		sty	<ans_low+01h
		lda	!Quotient+01h
		and	#00ffh
		clc
		adc	<ans_high
		sta	<ans_high
		rts
		end 
