;****************************************************************************
;*		Mode 7 examination BG control program                       *
;*                                                                          *
;*						 1991.06.05		    *
;****************************************************************************
		glb	Set_screen
 		glb	BG_control
		glb	Calc_position
		glb	Set_camera_pos
;
;		glb	COS,SIN
		ext	Cos_data,Sin_data
		ext	IRQ_1
		include rp5a22
		include rp5c77
		include	work
		include	buffer
;****************************************************************************
sin_data	equ	010h
cos_data	equ	011h
angle_data	equ	sin_data
counter		equ	012h
counter1	equ	counter
counter2	equ	14h
;
tempolary	equ	008h		;6byte	
;
grand_resist	equ	018h
air_resist	equ	01ch
ofset_data	equ	020h		;calc hdma data offset data
;****************************************************************************
;		NMI routin use
power_x         equ     0f0h            ;4byte
power_y         equ     0f4h
cornering_datax equ	0f8h		;4byte
cornering_datay equ	0fch
;****************************************************************************
;
		prog
;----------------------------------------------------------------------------
Set_screen					;V_blank prossess
		php
;
		mem8
		idx8
		sep	#00110000b
;
Set_parth
		lda	#02h
		sta	<IRQ_flag
		jsr	!IRQ_1
		ldx	#00h
H_DMA_loop
		lda	!H_DMA_data+00h,x
		sta	!DMA_1,x
		lda	!H_DMA_data+08h,x
		sta	!DMA_2,x
		lda	!H_DMA_data+10h,x
		sta	!DMA_3,x
		lda	!H_DMA_data+18h,x
		sta	!DMA_4,x
		inx
		cpx	#08h
		bne	H_DMA_loop
;
		lda	#00011110b
		sta	!DMA_syncro
						;H_DMA switch
		plp
		rts
;-----------------------------------------------------------------------------
H_DMA_data
;		byte	01000010b
;		byte	1bh,020h,04h,00h,00h,00h,07eh
;		byte	01000010b
;		byte	1ch,030h,04h,00h,00h,00h,07eh
;		byte	01000010b
;		byte	1dh,040h,04h,00h,00h,00h,07eh
;		byte	01000010b
;		byte	1eh,020h,04h,00h,00h,00h,07eh
;
		byte	01000010b
		byte	1bh,020h,04h,00h,00h,00h,07fh
		byte	01000010b
		byte	1ch,030h,04h,00h,00h,00h,07fh
		byte	01000010b
		byte	1dh,040h,04h,00h,00h,00h,07fh
		byte	01000010b
		byte	1eh,020h,04h,00h,00h,00h,07fh
;	
		;indirect address & write twice
		;write resister 211bh,211ch,211dh &211eh
		;table address  0420h,0430h,0440h,0420h
		;trans quantity =00h  (dummy)
		;data address bank = 07fh
;*****************************************************************************
Calc_position
					;entry x=index 0,2,4,
		mem16
		idx8
		lda	!object_flag+00h,x
		bpl	Move_object
		rts
Move_object
		and	#0ff00h
		bne	Slic_control
;;;;;		bne	Fzero_control
		jmp	!XY_control
;-----------------------------------------------------------------------------
		mem8
Slic_control
		sep	#00110000b
		lda	!driving_force+00h,x
		sta	!211bh
		lda	!driving_force+01h,x
		sta	!211bh
		ldy     !force_direction+01h,x
		lda	!Sin_data,y
		pha				;>>>sin data
		lda	!Cos_data,y
		sta	!211ch			;multiple cos data
		ply				;y=sin data<<<<
;;;;;		pha				;>>>cos_data
		mem16
		rep	#00100000b
		stz	<power_y+02h	
		lda	!2135h 
		sta	<power_y+00h
		bpl	Powery_plus_slic
		dec	<power_y+02h
Powery_plus_slic
		sty	!211ch			;multiple sin data
		stz	<power_x+02h
		lda	!2135h
		sta	<power_x+00h
		bpl	Powerx_plus_slic
		dec	<power_x+02h
Powerx_plus_slic				;Calc cornering effect
;;;		phy				;>>>>sin data
		ldy	!cornering_force+00h,x
		sty	!211bh
		ldy	!cornering_force+01h,x
		sty	!211bh
;;;;;		ply				;sin_data<<<
		ldy	!move_direction+01h,x
		lda	!Sin_data,y
		tay
		sty	!211ch
		stz	<cornering_datay+02h
		lda	!2135h
		sta	<cornering_datay+00h
		bpl	Highy_plus_corner
		dec	<cornering_datay+02h
Highy_plus_corner
Cornering_plusy
;;;;		ply				;cos_data<<<
		ldy	!move_direction+01h,x
		lda	!Cos_data,y
		tay
		sty	!211ch
		stz	<cornering_datax+02h
		lda	!2135h
		eor	#0ffffh
		inc	a
		sta	<cornering_datax+00h
		bpl	Highx_plus_corner
		dec	<cornering_datax+02h
Highx_plus_corner
;
Calc_air_resistance
		ldy	!velocity_xl+01h,x
		sty	!211bh
		ldy	!velocity_xh+00h,x
		sty	!211bh
		ldy	!air_quality+00h,x
		sty	!211ch
		clc
		lda	!2134h
		adc	<power_x+00h
		sta	<power_x+00h
		lda	!2135h
		and	#0ff00h
		bpl	Highx_plus_slic
		ora	#00ffh
Highx_plus_slic
		xba
		adc	<power_x+02h
		sta	<power_x+02h
;veloy
		ldy	!velocity_yl+01h,x
		sty	!211bh
		ldy	!velocity_yh+00h,x
		sty	!211bh
		ldy	!air_quality+00h,x
		sty	!211ch
		clc
		lda	!2134h
		adc	<power_y+00h
		sta	<power_y+00h
		lda	!2135h
		and	#0ff00h
		bpl	Highy_plus_slic
		ora	#00ffh
Highy_plus_slic
		xba
		adc	<power_y+02h
		sta	<power_y+02h
;
		clc
		lda	!velocity_xl,x
		adc	<power_x+00h
		sta	!velocity_xl,x
		lda	!velocity_xh,x
		adc	<power_x+02h
		sta	!velocity_xh,x		
		clc
		lda	!velocity_yl,x
		adc	<power_y+00h
		sta	!velocity_yl,x
		lda	!velocity_yh,x
		adc	<power_y+02h
		sta	!velocity_yh,x
;
		clc
		lda	!velocity_xl,x
		adc	<cornering_datax+00h
		sta	!velocity_xl,x
		lda	!velocity_xh,x
		adc	<cornering_datax+02h
		sta	!velocity_xh,x
		clc
		lda	!velocity_yl,x
		adc	<cornering_datay+00h
		sta	!velocity_yl,x
		lda	!velocity_yh,x
		adc	<cornering_datay+02h
		sta	!velocity_yh,x
;;
		jmp     !Set_position
;-----------------------------------------------------------------------------
Fzero_control
		mem8
		sep	#00100000b
		lda	!vector_velocity+00h,x
		sta	!211bh
		lda	!vector_velocity+01h,x
		sta	!211bh
		ldy	!force_direction+01h,x
		lda	!Sin_data,y
		pha				;>>>>>sin data
		lda	!Cos_data,y
		sta	!211ch
		ply				;<<<<<sin data
		phy				;>>>>>>>sin data
		pha				;>>>>>>>>>cos data
		mem16
		rep	#00100000b
		lda	!2134h
		sta	!velocity_yl,x
		lda	2135h
		bmi	Veloy_minus
		and	#0ff00h		
		bra	Set_uppery
Veloy_minus	
		ora	#00ffh
Set_uppery
		xba
		sta	!velocity_yh+00h,x
		sty	!211ch
		lda	!2134h
		sta	!velocity_xl,x
		lda	!2135h
		bmi	Velox_minus
		and	#0ff00h
		bra	Set_upperx
Velox_minus	
		ora	#000ffh
Set_upperx
		xba	
		sta	!velocity_xh+00h,x
;
;		ldy	!cornering_force+00h,x
;		sty	!211bh
;		ldy	!cornering_force+01h,x
;		sty	!211bh
;		ldy	!steering_angle+01h,x
;		bmi	Rotate_right
;Rotate_left
;		ply				;<<<cos_data
;		sty	!211ch
;		lda	!2135h
;		sta	!cornering_fx,x
;						;sin(x+90)=cos x
;		ply
;						;<<<<<sin data
;		sty	!211ch
;		lda	!2135h
;		eor	#0ffffh
;		inc	a
;		sta	!cornering_fy,x	
;						;cos(x+90)=-sin x
;		jmp	!Set_position
Rotate_right
;		ply				;<<<cos_data
;		sty	!211ch
;		lda	!2135h
;		eor	#0ffffh
;		inc	a
;		sta	!cornering_fx,x
;						;sin(x-90)=-cos x
;		ply
;						;<<<<<sin data
;		sty	!211ch
;		lda	!2135h
;		sta	!cornering_fy,x	
;						;cos(x-90)=sin x
		jmp	!Set_position
;;------------------------------------------------------------------
XY_control
;		ldy	!steering_speed+00h,x
;		sty	!211bh
;		ldy	!steering_speed+01h,x
;		sty	!211bh
;		ldy	!steering_effect+00h,x
;		sty	!211ch
;		lda	!2135h
;		clc
;;;;;;		adc	!force_direction+00h,x
;;;;;		sta	!force_direction+00h,x
;		adc	!camera_direction+00h,x
;		sta	!camera_direction+00h,x		;test
;;;
;		ldy	!drive_status+00h,x
;		bmi	Slipping_drive	
;		jmp	!Nomal_driving
;Slipping_drive
;		stz	<power_x+02h
;		lda	!centrifugal_x,x
;		sta	<power_x+00h
;		bpl	Slip_x_plus
;		dec	<power_x+02h
;S;lip_x_plus
;		stz	<power_y+02h
;		lda	!centrifugal_y,x
;		sta	<power_y+00h
;		bpl	Slip_y_plus
;		dec	<power_y+02h
;Slip_y_plus
;		stz	!friction_power,x
;		bra	Calclate_velocity
;-------------------------------------------------------------------
Nomal_driving
;Set_position
		mem8
		sep	#00100000b
		ldy     !force_direction+01h,x
		lda	!Sin_data,y
		pha				;>>>>>>>
		lda	!Cos_data,y
		tay
		lda	!driving_force+00h,x
		sta	!211bh
		lda	!driving_force+01h,x
		sta	!211bh
		sty	!211ch
		mem16
		rep	#00100000b
		stz	<power_y+02h	
		lda	!2135h 
		sta	<power_y+00h
		bpl	Powery_plus
		dec	<power_y+02h
Powery_plus
;		pha
;		sec
;		sbc	!acceleration_y,x
;		sta	!power_varyy,x
;		pla
;		sta	!acceleration_y,x
		ply				;<<<<<<<
		sty	!211ch
		stz	<power_x+02h
		lda	!2135h
		sta	<power_x+00h
		bpl	Powerx_plus
		dec	<power_x+02h
Powerx_plus
;		pha
;		sec
;		sbc	!acceleration_x,x
;		sta	!power_varyx,x
;		pla
;		sta	!acceleration_x,x
;-------------------------------------------------------------------
Calclate_velocity
		stz	<grand_resist+02h
		lda	!friction_power,x
		ldy	!velocity_xl+01h,x
		sty	!211bh
		ldy	!velocity_xh+00h,x
		sty	!211bh
		bpl	Fricx_minus
		eor	#0ffffh
		inc	a
Fricx_minus
		sta	<grand_resist+00h
		cmp	#08000h
		bcc	Fricx_plus
		dec	<grand_resist+02h
Fricx_plus
		ldy	!air_friction+01h,x
		sty	!211ch
		lda	#0000h
		ldy	!2136h
		bpl	Highx_plus
		tya
		ora	#0ff00h
		bra	Set_highx
Highx_plus
		tya
Set_highx
		sta	<air_resist+02h
		lda	!2134h
		sta	<air_resist+00h
					;air_resisting_power
;
		lda	<power_x+00h
		clc
		adc	<grand_resist+00h
		pha
		lda	<power_x+02h
		adc	<grand_resist+02h
		sta	<tempolary+00h
		pla	
		clc
		adc	<air_resist+00h
		pha
		lda	<tempolary+00h
		adc	<air_resist+02h
		sta	<tempolary+00h
;;
		clc
		pla
		adc	!velocity_xl+00h,x
		sta	!velocity_xl+00h,x
		lda	!tempolary+00h
		adc	!velocity_xh+00h,x
		sta	!velocity_xh+00h,x
;
;velocity y--------------------------------------------------------
		stz	<grand_resist+02h
		lda	!friction_power,x
		ldy	!velocity_yl+01h,x
		sty	!211bh
		ldy	!velocity_yh+00h,x
		sty	!211bh
		bpl	Fricy_minus
		eor	#0ffffh
		inc	a
Fricy_minus
		sta	<grand_resist+00h
		cmp	#08000h
		bcc	Fricy_plus
		dec	<grand_resist+02h
Fricy_plus
		ldy	!air_friction+01h,x
		sty	!211ch
		lda	#0000h
		ldy	!2136h
		bpl	Highy_plus
		tya
		ora	#0ff00h
		bra	Set_highy
Highy_plus
		tya
Set_highy
		sta	<air_resist+02h
		lda	!2134h
		sta	<air_resist+00h
					;air_resisting_power
;
		lda	<power_y+00h
		clc
		adc	<grand_resist+00h
		pha
		lda	<power_y+02h
		adc	<grand_resist+02h
		sta	<tempolary+00h
		pla	
		clc
		adc	<air_resist+00h
		pha
		lda	<tempolary+00h
		adc	<air_resist+02h
		sta	<tempolary+00h
;
		clc
		pla
		adc	!velocity_yl+00h,x
		sta	!velocity_yl+00h,x
		lda	!tempolary+00h
		adc	!velocity_yh+00h,x
		sta	!velocity_yh+00h,x
;-------------------------------------------------------------------
Set_position
		lda	!position_xl+00h,x
		clc
		adc	!velocity_xl+00h,x
		sta	!position_xl+00h,x
		lda	!position_xh+00h,x
		adc	!velocity_xh+00h,x
		sta	!position_xh+00h,x
;
		lda	!position_yl+00h,x
		clc
		adc	!velocity_yl+00h,x
		sta	!position_yl+00h,x
		lda	!position_yh+00h,x
		adc	!velocity_yh+00h,x
		sta	!position_yh+00h,x
;-------------------------------------------------------------------
Set_camera_pos
					;ban Mode 7
					;Entry x=set index
		mem8
		idx8
		sep	#00110000b
		lda	<camera_direction+01h,x
		pha
		bpl	No_cmy_minus
		eor	#0ffh
		cmp	#07fh
		beq	No_cmy_minus
		inc	a
No_cmy_minus
		asl	a
		tay
		mem16
		rep	#00100000b
		lda	!camera_data,y
		clc
		adc	!position_yh,x
		sta	<camera_posy,x
		mem8
		sep	#00100000b
		pla
		sec
		sbc	#040h
		bpl	No_cmx_minus
		eor	#0ffh
		cmp	#07fh
		beq	No_cmx_minus
		inc	a
No_cmx_minus	
		asl	a
		tay
		mem16
		rep	#00100000b
		lda	!camera_data,y
		clc
		adc	!position_xh,x
		sta	<camera_posx,x
;
		rts
;-------------------------------------------------------------------
BG_control
		mem8
		idx8
		php
		sep	#00110000b
		lda	#0e0h
		sta	<ofset_1v
		stz	<ofset_1v+01h
;;;		lda	#050h
		lda	#054h
		sta	<ofset_2v
		lda	#01h
		sta	<ofset_2v+01h
Set_mode2
		lda	#010h  
						;10h line not trans
		sta	!0420h
		sta	!0430h
		sta	!0440h
;
		lda	#014h
		sta	!0426h
		sta	!0436h
		sta	!0446h
						;same data
						;trans 10h line
		stz	!0421h
		stz	!0427h
		stz	!0431h
		stz	!0437h
		stz	!0441h
		stz	!0447h
		lda	#060h
		sta	!0422h
		sta	!0432h
		sta	!0442h
;
;;;;;		lda	#060h
		sta	!0428h
		sta	!0438h
		sta	!0448h
						;dummy addr 1400h
		lda	#0dch
		sta	!0423h
		sta	!0429h
		sta	!0433h			;1 line 1 data 5ch line
						;B7 set & 5ch=dch
;
;;;		lda	#0e0h
		lda	#0dfh
		sta	!0439h
		sta	!0443h
		sta	!0449h
						;1 line 1 data 60h line
						;B7 set & 60h=e0h	
		stz	!042ch
		stz	!043ch
		stz	!044ch
						;00=stop code
		ldx	#03h
		lda	<camera_direction+01h
		clc
		adc	#80h
		tay
		stz	<ofset_data
		lda	#0c0h
		jsr	!Calc_hdma
		ldx	#09h
		lda	<camera_direction+03h
		clc
		adc	#80h
 		tay
;;;		lda	#08h
		stz	<ofset_data
		lda	#0c0h
		jsr	!Calc_hdma
;
		lda	#02h
		sta	<IRQ_flag
		plp	
		rts
;-------------------------------------------------------------------
mode1_dummy	equ	7e9000h
mode2_dummy	equ	7f6000h
;-------------------------------------------------------------------
		mem8
		idx8
Calc_hdma				;x resister=buffer address
					;y resister=dirction
					;A resister
					;	X=0e0h(mode1)
					;	X=0c0h(mode2)
		sty	<angle_data
		sta	!Multiplicand
					;
		tya
		bpl	CL_001
		eor	#0ffh		inc	a
CL_001
		sta	!Multiplier
		lda	<angle_data
		sec
		sbc	#040h
		bpl	CL_002
		eor	#0ffh
		inc	a
CL_002
		tay
		lda	!Product+00h
		clc
		adc	<ofset_data
		sta	!hdma_buffer+01h,x
		lda	!Product+01h
		clc
		adc	#020h
		sta	!hdma_buffer+02h,x
		sty	!Multiplier
		lda	<angle_data
		clc
		adc	#040h
		bpl	CL_003
		eor	#0ffh
		inc	a
CL_003	
		tay
		lda	!Product+00h
;;		clc
;;		adc	<ofset_data
		sta	!hdma_buffer+11h,x	
		lda	!Product+01h
		sty	!Multiplier
		clc
		adc	#020h
		sta	!hdma_buffer+12h,x
		lda	!Product+00h
		clc
		adc	<ofset_data
		sta	!hdma_buffer+21h,x
		lda	!Product+01h
		clc
		adc	#020h
		sta	!hdma_buffer+22h,x
		rts	
;*******************************************************************
;*	circular function			mem8 idx8 A=angle  *
;*							  A=ans.   *
;*******************************************************************
;		IDX8
;		MEM8
;COS		CLC 
;		ADC	#64
;SIN		ASL	A 
;		BPL	sin_skip
;		EOR	#11111111B 
;		INC	A 
;sin_skip	BCS	sin_minus 
;		LSR	A 
;		TAX 
;		LDA	!Circular_table,X
;		RTS 
;s;in_minus	LSR	A 
;		TAX 
;		LDA	#1 
;		SBC	!Circular_table,X
;		RTS 
;--------------------------------------------------------------------
;Circular_table	BYTE	000,003,006,009,012,016,019,022 
;		BYTE	025,028,031,034,037,040,043,046 
;		BYTE	049,051,054,057,060,063,065,068 
;		BYTE	071,073,076,078,081,083,085,088 
;		BYTE	090,092,094,096,098,100,102,104 
;		BYTE	106,107,109,111,112,113,115,116 
;		BYTE	117,118,120,121,122,122,123,124 
;		BYTE    124,125,126,126,126,127,127,127
;		BYTE    127
		end

