;****************************************************************************
;*          Modo no.7 examination main program				    *
;*									    *
;*						1991.05.30		    *
;****************************************************************************
		glb	IRQ_1
		ext	Initialize_process
		ext	Selection_process
		ext	Calc_position
		ext	Position_calc1,Position_calc2
		ext	Set_obj_sc1,Set_obj_sc2		
		ext	Obj_priority_screen1,Obj_priority_screen2
		ext	Set_camera_pos
		ext	Set_screen
		ext	Motion_control
		ext	BG_control
		ext	OBJ_control,Set_OAM_screen1,Set_OAM_screen2
		ext	Set_trans_buffer1,Set_trans_buffer2
		ext	OBJ_transport
;;;;;		ext	Vector_calc
		include	rp5a22
		include rp5c77
		include work
		include buffer
;****************************************************************************
;		data
;****************************************************************************
;
		prog
;
		mem8
		idx8
Reset_entry
		native
		sei
		rep	#00001001b
		xce 
		mem8
		idx8
		stz	!NMI_control	;NMI disable
					;H,Vtimer disable
					;joystick disable
		stz	!DMA_syncro	;H_DMA chanel 
		lda	#10001111b
		sta	!PPU_control	;224 dot mode
					;not interless mode
					;not super inpose
					;blanking on
					;fade out max
		tsc			;stack pointa>>>A resister
		lda	#0ffh
	 	tcs			;A resister>>>stack pointa

		jsr	!Initialize_process
;
		lda	#10000001b
		sta	!NMI_control
						;NMI eneble
		lda	#00001111b
		sta	!PPU_control		;blanking off	
		stz	<status_flag
		stz	<debug_flag	
		stz	<game_status
		stz	<trans_counter
		stz	<camera_status
		stz	<dsp_status
;;;		stz	<control_status		;default=xy-control
;						
;****************************************************************************
Main_loop
		sep	#00110000b
		lda	<status_flag
		bit	#01000000b
		bne	Reset_entry
					;status flag reset bit	
		stz	<NMI_flag
Wait_NMI
		lda	>NMI_flag
		beq	Wait_NMI
;
		ldx	<game_status
		jsr	(!Process_address,x)
		bra	Main_loop
;-------------------------------------------------------------------
Playing_process
		jsr	!BG_control
		lda	#0fh
		sta	!2100h
;		
		mem8
		idx8
		sep	#00110000b
		lda	<debug_flag
		cmp	#01h
		bne	Not_01_debug
		lda	#0ch
		sta	!2100h
Not_01_debug
		jsr	!Motion_control
		lda	<debug_flag
		cmp	#01h
		bne	NO_01_debug
		lda	#08h
		sta	!2100h
NO_01_debug
		jsr	!OBJ_control
		mem8
		sep	#00110000b
		lda	<debug_flag
		cmp	#01h
		bne	Not_debug_disp
		lda	#0fh
		sta	!2100h
Not_debug_disp
		rts
;****************************************************************************
Process_address
		word	Selection_process,Playing_process
;****************************************************************************
NMI_entry
		rep	#00110000b
		mem16
		idx16
		pha
		phx
		phy
		phd
		phb
		lda	#00h
		tcd	
		sep	#00110000b
		mem8
		idx8
		pha
		plb			;Set data bank resister
		inc	<frame_counter
		lda	!NMI_status
		ldx	<NMI_flag
		bne	Prosses_over
		dec	<NMI_flag
;
		ldx	<game_status
		jsr	(!NMI_address,x) 	; fast prosses !!!  
;
Prosses_over
		rep	#00110000b
		mem16
		idx16
		plb
		pld
		ply
		plx
		pla
Not_use
		rti
;*******************************************************************
IRQ_entry
		php
		mem16
		idx16
		rep	#00110000b
		pha
		phx
		phy
;		phd
;		phb
;		lda	#00h
;		tcd
		mem8
		idx8
		sep	#00110000b
No_debug_IRQ
;;;;;		pha
;;;;;		plb
		lda	!4211h
		ldx	<IRQ_flag
		bne	IRQ_prossess
		mem16
		idx16
		rep	#00110000b
;;;;;;		plb
;;;;;;		pld
		ply
		plx
		pla
		plp
		rti
IRQ_prossess
Wait_H_blank
		mem8
		idx8
		bit	!Blank_status
		bvc	Wait_H_blank
		ldx	<IRQ_flag
		jsr	(!IRQ_subroutin,x)
		mem16
		idx16
		rep	#00110000b
;;;;		plb
;;;;		pld
		ply
		plx
		pla
		plp
		rti
;----------------------------------------------------------------------------
IRQ_subroutin
		word	IRQ_0,IRQ_2,IRQ_3,IRQ_4,IRQ_5
;----------------------------------------------------------------------------
IRQ_1
		mem8
		idx8
		lda	#00000001b
		sta	!Screen_mode    	;Set mode1
;;;;		lda	#00010010b
		lda	#00000001b
		trb	!Through_screen
;;;;;		sta	!Through_screen
;						;Cut BG1
;		lda	!camera_posx+00h
;		sta	!Rotation_X
;		lda	!camera_posx+01h
;		sta	!Rotation_X
;		lda	!camera_posy+00h
;		sta	!Rotation_Y
;		lda	!camera_posy+01h
;		sta	!Rotation_Y
		mem16
		rep	#00100000b
		lda	!camera_posx+00h
		sec
		sbc	#080h
		sta	<scroll_h+00h
		lda	!camera_posy+00h
		sec
		sbc	<ofset_1v
		sta	<scroll_v+00h
;
		mem8
		sep	#00110000b
		lda	<scroll_h+00h
		sta	!Scroll_0H
		lda	<scroll_h+01h
		sta	!Scroll_0H
		lda	<scroll_v+00h
		sta	!Scroll_0V
		lda	<scroll_v+01h
		sta	!Scroll_0V
;;;
		lda	<back_h+00h
		sta	!Scroll_1H
		stz	!Scroll_1H
		lda	<back_v+00h
		sta	!Scroll_1V
		stz	!Scroll_1V
;
		lda	#10110001b
		sta	!Timer_control		;eneble timer
		lda	#0c0h
		sta	!Timer_H+00h
		stz	!Timer_H+01h
		lda	#0fh
		sta	!Timer_V+00h
		stz	!Timer_V+01h
IRQ_0;-----------------------------------------------------------------------
		rts
;IRQ_2;-----------------------------------------------------------------------
;		lda	#10110001b
;		sta	!Timer_control		;eneble timer
;		lda	#00fh
;		sta	!Timer_V+00h		;set IRQ line
;		lda	#04h
;		sta	<IRQ_flag
;
IRQ_2
		mem8
		idx8
		lda	!camera_posx+00h
		sta	!Rotation_X
		lda	!camera_posx+01h
		sta	!Rotation_X
		lda	!camera_posy+00h
		sta	!Rotation_Y
		lda	!camera_posy+01h
		sta	!Rotation_Y
;		lda	<scroll_h+00h
;		sta	!Scroll_0H
;		lda	<scroll_h+01h
;		sta	!Scroll_0H
;		lda	<scroll_v+00h
;		sta	!Scroll_0V
;		lda	<scroll_v+01h
;		sta	!Scroll_0V
;;  
		lda	#00000111b
		sta	!Screen_mode
		lda	#00010011b
		sta	!Through_screen
						;On BG1(mode7)
		lda	#04h
		sta	<IRQ_flag
		lda	#10110001b
		sta	!Timer_control		;eneble timer
;;;;		lda	#06fh
		lda	#06bh			;for test program
		sta	!Timer_V+00h
;
;;		jsr     !Position_calc2
;;		jsr	!Set_obj_sc2
;;		jsr	!Set_trans_buffer2
;
		rts
IRQ_3;-----------------------------------------------------------------------
		mem8
		idx8
		lda	#10000000b
		sta	!2100h			;set blanking
		lda	#00000001b
		sta	!Screen_mode
;						;set mode 7
;		lda	!camera_posx+02h
;		sta	!Rotation_X
;		lda	!camera_posx+03h
;		sta	!Rotation_X
;		lda	!camera_posy+02h
;		sta	!Rotation_Y
;		lda	!camera_posy+03h
;		sta	!Rotation_Y
						;set mode 1
		lda	<back_h+02h
		sta	!Scroll_1H
		stz	!Scroll_1H
		lda	<back_v+02h
		sta	!Scroll_1V
		lda	#0ffh
		sta	!Scroll_1V 

		lda	#00010010b
		sta	!Through_screen
						;cut bg1(mode7)
		lda	#10110001b
		sta	!Timer_control		;eneble timer
;;;		lda	#07fh
		lda	#073h			;test program
		sta	!Timer_V+00h
						;blanking
		lda	#06h
		sta	<IRQ_flag
		mem16
		rep	#00100000b
		lda	!camera_posx+02h
		sec
		sbc	#080h
		sta	<scroll_h+00h
		lda	!camera_posy+02h
		sec
		sbc	<ofset_2v
		sta	<scroll_v+00h
;
		mem8
		idx8
		sep	#00110000b
		lda	<scroll_h+00h
		sta	!Scroll_0H
		lda	<scroll_h+01h
		sta	!Scroll_0H
		lda	<scroll_v+00h
		sta	!Scroll_0V
		lda	<scroll_v+01h
		sta	!Scroll_0V
;
		jsr	!Set_OAM_screen2	;reset OAM data
;
		sep	#00110000b
		rts
IRQ_4;-----------------------------------------------------------------------
		mem8
		idx8
		lda	<debug_flag
		cmp	#01h
		bne	Not_debug11
		lda	#0ch
		sta	!2100h
		bra	Debug_11
Not_debug11
		lda	#0fh
		sta	!2100h			;cut blanking
Debug_11
		lda	#08h
		sta	<IRQ_flag
;
		lda	#10110001b
		sta	!Timer_control		;eneble timer
		lda	#07fh			;test program
		sta	!Timer_V+00h
;
		rts		
IRQ_5;-----------------------------------------------------------------------
		mem8
		idx8
		lda	#00000111b
		sta	!Screen_mode
		lda	#00010001b
		sta	!Through_screen
		lda	!camera_posx+02h
		sta	!Rotation_X
		lda	!camera_posx+03h
		sta	!Rotation_X
		lda	!camera_posy+02h
		sta	!Rotation_Y
		lda	!camera_posy+03h
		sta	!Rotation_Y
;		lda	<scroll_h+00h
;		sta	!Scroll_0H
;		lda	<scroll_h+01h
;		sta	!Scroll_0H
;		lda	<scroll_v+00h
;		sta	!Scroll_0V
;		lda	<scroll_v+01h
;		sta	!Scroll_0V
		lda	#10000001b
		sta	!Timer_control		;disable timer
;		lda	<debug_flag
;		cmp	#02h
;		bne	Not_debug_500
;		lda	#08h
;		sta	!2100h
;Not_debug_500	
;		jsr	!Position_calc1
;		sep	#00110000b
;		lda	<debug_flag
;		cmp	#02h
;		bne	Not_debug_501
;		lda	#0fh
;		sta	!2100h
;Not_debug_501
;
;		jsr     !Set_obj_sc1
;		jsr	!Set_trans_buffer1
;
		rts
;*******************************************************************
NMI_address
		word	NMI_process100,NMI_process200
;-------------------------------------------------------------------
NMI_process100
;;;		jsr     !OAM_buffer
		jsr	!Set_OAM_screen1
		jsr	!Scan_controler
		rts
;-------------------------------------------------------------------
NMI_process200
;
		sep	#00110000b
		jsr     !OBJ_transport
		jsr	!Set_OAM_screen1
		jsr	!Set_screen
		jsr	!Scan_controler
;
		mem16
		idx8
		rep	#00100000b
		lda	<status_flag-01h
						;pose mode ?
		bpl	Moving_mode
		bit	#0010000000000000b
		beq	Skip_calc_pos
Moving_mode;
		ldx	#00h
		jsr	!Calc_position
		ldx	#02h
		jsr	!Calc_position
Skip_calc_pos	
		rts		
;-------------------------------------------------------------------
;		mem8
;		idx8
;OAM_buffer
;		stz	!Sprite_address+00h	;2102h
;		stz	!Sprite_address+01h
;		stz	!DMA_0+00h		;DMA control
;		lda	#04h
;		sta	!DMA_0+01h
;						;set 2104h resister
;		stz	!DMA_0+02h
;		lda	#02h
;		sta	!DMA_0+03h
;		stz	!DMA_0+04h
;						;sprite buffer=200h
;		sta	!DMA_0+06h
;		lda	#020h
;		sta	!DMA_0+05h
;						;data quantity=220h
;		lda	#01h
;		sta	!DMA_burst
;						;DMA switch on
;		rts
;-------------------------------------------------------------------
;;;		lda	#00000001b
;;;		sta	!Screen_mode    	;Set mode1
;-------------------------------------------------------------------
Scan_controler
		mem16
		idx8
		rep	#00100000b
		sep	#00010000b
		ldx	#02h
Button_loop
		lda	!Button,x		;read 4218h
		sta	<button_status,x	;set button status
		pha
		eor	<button_stock,x
		pha
		and	<button_status,x
		sta	<button_trigger,x	;set button trigger
		pla
		and	<button_stock,x
		sta	<button_clear,x		;clear button trigger
		pla
		sta	<button_stock,x		;pre 1frame button
;
		dex
		dex
		bpl	Button_loop
		rts
;*******************************************************************
		org	0ffeah
		word	NMI_entry
		org	0ffeeh
		word	IRQ_entry
		org	0fffch
		word	Reset_entry	
		end
