;*********************************************************************
;	pers game state flow
;					programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../DEF/Register.def
;----------------------------------------------------------------------
	GLB	state_begin
	EXT	State_title,State_Xtitle
	EXT	State_Sgame,State_game,State_pause
;----------------------------------------------------------------------
	;EXT	State_CGedit,State_M7edit,State_M1edit
;----------------------------------------------------------------------
;	S.....	state start process
;	......	main process
;	X.....	state end process
;----------------------------------------------------------------------
		EXTEND
		PROG
;**********************************************************************
;		game state flow
;**********************************************************************
		MEM8
		IDX8
;----------------------------------------------------------------------
state_begin
state_title	DW	State_title,state_title
		DW	push_start,state_Xtitle
		DW	hold_state
state_Xtitle	DW	State_Xtitle,state_Xtitle
		DW	flag_1,state_Sgame
		DW	flag_2,state_Sgame
		DW	hold_state
;----------------------------------------------------------------------
state_Sgame	DW	State_Sgame,state_game
		DW	hold_state
state_game	DW	State_game,state_game
		DW	push_start,state_pause
		DW	hold_state
state_pause	DW	State_pause,state_pause
		DW	push_start,state_game
		DW	push_select,state_title
		DW	hold_state
;----------------------------------------------------------------------
		IF	0
;
		DW	secret_X,state_CGedit
		DW	secret_Y,state_M7edit
		DW	secret_A,state_M1edit
;======================================================================
state_CGedit	DW	State_CGedit,state_CGedit
		DW	push_start,state_title
		DW	hold_state
state_M7edit	DW	State_M7edit,state_M7edit	
		DW	push_start,state_title
		DW	hold_state
state_M1edit	DW	State_M1edit,state_M1edit
		DW	push_start,state_title
		DW	hold_state
;======================================================================
		ENDIF
;**********************************************************************
;		flag exit
;**********************************************************************
		mem16
		idx16
flag_3		LDA	#3		;W(B)
		BRA	flag_entry
flag_2		LDA	#2		;W(B)
		BRA	flag_entry
flag_1		LDA	#1		;W(B)
flag_entry	EOR	<branch_flag	;W(B)
		AND	#00000011B	;W(B)
		BNE	flag_return
		SEP	#00100000B
		MEM8
		STZ	<branch_flag	;B
		REP	#00100000B
		MEM16
		PLA			;<<
flag_return	RTS
;======================================================================
;************************************************************************
;	single state manager			State.asm
;************************************************************************
entry		EQU	0
exit		EQU	2
condition	EQU	4
branch		EQU	6
second_stack	EQU	001BFH
;-----------------------------------------------------------------------
		GLB	Stop_state,Wait_state
		GLB	Delay_state,Idle_state
;-----------------------------------------------------------------------
		GLB	state
		GLB	Initiate_state,Manage_state
		GLB	hold_state,force_state
		GLB	push_start,push_select
;-----------------------------------------------------------------------
		DATA
state		DS	2
state_stack	DS	2
;-----------------------------------------------------------------------
		PROG
;************************************************************************
;		State main
;************************************************************************
		mem16
		idx16				;mWxW
;-----------------------------------------------------------------------
Condition_state	JSR	(!condition,X)
		CLC
		TXA				;WW
		ADC	#4			;W
		TAX				;WW
		BRA	Condition_state
;-----------------------------------------------------------------------
Manage_state	LDX	<state			;W
		JSR	Condition_state
state_branch	LDA	<branch,X		;W
		TAX
Initiate_state	STX	<state			;W
		TSC				;WW
		STA	<state_stack		;W
		LDA	#second_stack		;W
		TCS				;WW
		JMP	(!entry,X)
;-----------------------------------------------------------------------
Stop_state	REP	#00110000B
		MEM16
		IDX16
		LDY	<state			;W
		LDX	<exit,Y			;W
		STX	<state			;W
		LDA	#second_stack		;W
		TCS				;WW
		JMP	(!entry,X)
;-----------------------------------------------------------------------
wait_state	REP	#00110000B
		MEM16
		IDX16
		TSX				;WW
		LDA	<state_stack		;W
		STX	<state_stack		;W
		TCS				;WW
		RTS
;-----------------------------------------------------------------------
Wait_state	PHP				;>
		JSR	wait_state
		PLP				;<
		RTS
;-----------------------------------------------------------------------
Delay_state	PHA				;> or >>
		JSR	Wait_state
		PLA				;< or <<
		DEC	A			;B or W
		BNE	Delay_state
		RTS
;-----------------------------------------------------------------------
Idle_state	JSR	Wait_state
		BRA	Idle_state
;-----------------------------------------------------------------------
hold_state	PLA				;<<
		PLA				;<<
		TSX				;WW
		LDA	<state_stack		;W
		STX	<state_stack		;W
		TCS				;WW
		RTS
;-----------------------------------------------------------------------
force_state	PLA				;<<
		BRA	state_branch
;-----------------------------------------------------------------------
;=======================================================================
secret_select	LDA	#button_select
		BRA	secret_common
;-----------------------------------------------------------------------
secret_Y	LDA	#button_Y*256
		BRA	secret_common
;-----------------------------------------------------------------------
secret_X	LDA	#button_X*256
		BRA	secret_common
;-----------------------------------------------------------------------
secret_A	LDA	#button_A
;-----------------------------------------------------------------------
secret_common	AND	<trigger
		BEQ	push_return
		LDA	<button				;W
		AND	#(button_L+button_R)*256
		CMP	#(button_L+button_R)*256
		BNE	push_return
		BRA	push_next
;-----------------------------------------------------------------------
push_key	LDA	#1111000011111111B
		BRA	push_common
;-----------------------------------------------------------------------
push_A		LDA	#0000000010000000B	;W (push A)
		BRA	push_common
;-----------------------------------------------------------------------
push_X		LDA	#1000000000000000B	;W (push X)
		BRA	push_common
;-----------------------------------------------------------------------
push_Y		LDA	#0100000000000000B	;W (push Y)
		BRA	push_common
;-----------------------------------------------------------------------
push_select	LDA	#0000000000100000B	;W (push select)
		BRA	push_common
;-----------------------------------------------------------------------
push_start	LDA	#0000000000010000B	;W (push start)
push_common	AND	<trigger		;W
		BEQ	push_return
push_next	PLA				;<<
push_return	RTS
;-----------------------------------------------------------------------
		END
