;*********************************************************************
;		Pers test module
;					programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../DEF/Register.def
;----------------------------------------------------------------------
		EXT	Initiate_state,Manage_state,state_begin
		EXT	First_debug
;----------------------------------------------------------------------
	;	EXT	Reset_config
		EXT	Clear_RAM
		EXT	Init_system,Clear_sprite,Clear_color		
		EXT	param_tennis
		EXT	Center_1
;----------------------------------------------------------------------
		GLB	Clear_WORK,DMA_color,DMA_sprite,Scan_button
;----------------------------------------------------------------------
		COMN
work		DS	2
;----------------------------------------------------------------------
		DATA
;----------------------------------------------------------------------
		EXTEND
		PROG
;----------------------------------------------------------------------
; screen_check		*000 0000 (d7)	manage meter
;			0*00 0000 (d6)	NMI step (1.ON 0.OFF)
;			00*0 0000 (d5)	NMI step count
;			0000 0*** (d3-d0) debug select number 
;**********************************************************************
;		program entry ( RESET )
;**********************************************************************
RESET
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
; PBR	PC	DBR	SP	D	C(B,A)	X	Y	P(NVMXDIZC)E
; 00	(FFFC)	00	01**	0000	00**	00**	00**	**1101**
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
		NATIVE
;----------------------------------------------------------------------
		mem8
		idx8		
		CLC
		XCE			; set native mode
		SEP	#30H
		SEI			; IRQ disable
		STZ	!NMI_control	; NMI disable
		STZ	!DMA_syncro	; H DMA off
		STZ	!DMA_burst	; V DMA off
		LDA	#10000000B	; screen branking
		STA	!PPU_control
;----------------------------------------------------------------------
		TSC
		LDA	#0FFH		;(B)
		TCS			; set stack pointer
		STZ	!Out_expansive	; 4016H
		STA	!Out_auxilary	; 4201H
;----------------------------------------------------------------------
		REP	#00110000B
		MEM16
		IDX16
		JSR	Check_power	; power ON check
	;;	JSR	Boot_sound	; load sound program
;----------------------------------------------------------------------
		JSR	Clear_WORK_RES	; reset RAM clear
		JSR	Init_system	; PPU CPU resgister
		JSR	Reset_DSP	; DSP initial
;----------------------------------------------------------------------
		LDX	#state_begin	; <- start address
		JSR	Initiate_state	
;----------------------------------------------------------------------
state_idle	SEP	#00110000B
		MEM8
		IDX8
		STZ	<nmi_flag	; (NMI-OK)
		LDA	<nmi_control	;
		ORA	#10110001B	; cont read OK
		STA	<nmi_control	;
		STA	!NMI_control	;
wait_nmi_loop	BIT	<nmi_control	;
		BMI	wait_nmi_loop	;
		DEC	<nmi_flag	; (NMI-NO)
		REP	#00110000B
		MEM16
		IDX16
		JSR	Manage_state	;
		BRA	state_idle	
;----------------------------------------------------------------------
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;************************************************************************
;		Reset DSP
;************************************************************************
Reset_DSP	SEP	#00110000B
		MEM8
		IDX8
		LDX	#128		;B 
		LDA	#dsp_reset	;B
reset_dsp_loop	STA	>DSP_data	;B
		DEX			;B
		BNE	reset_dsp_loop	;B
		REP	#00110000B
		MEM16
		IDX16
		RTS
;************************************************************************
;		Initialize work
;************************************************************************
Clear_WORK_RES	JSR	Clear_ZP	; RAM clear 0000H - 00EFH 
Clear_WORK	JSR	Clear_MR	; RAM clear 0500H - 1DFFH
		RTS
;-------------------------------------------------------------------------
Clear_ZP	JSR	Clear_RAM
		DW	0000H
		DL	0		; 000H - 0EFH clear
		DW	00F0H		; byte count
Clear_MR	JSR	Clear_RAM
		DW	0000H
		DL	0500H		; 500H - 1DFFH clear
		DW	1900H		; byte count	
;************************************************************************
;		Check power
;************************************************************************
		mem16
		idx16
Check_power	LDA	#6917H			;W (power on keyword)
		CMP	!power_check		;W
		BNE	ON_power
		RTS
;-----------------------------------------------------------------------
ON_power	STA	!power_check		;W (Set power on keyword)
		LDA	#01			;W
		STA	!syori_over		;W
;-----------------------------------------------------------------------
		LDA	#8
		STA	!hit_size
		ASL	A
		STA	!hit_size2
;-----------------------------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		STZ	<mode			;B game mode select
		STZ	<screen_check		;B screen debug
		JSL	>First_debug		;
	;	JSR	Reset_config		; button select
		REP	#00110000B
		MEM16
		IDX16
		RTS
;**********************************************************************
;		NMI prosess
;**********************************************************************
;----------------------------------------------------------------------
Native_NMI	REP	#00110000B
		MEM16
		IDX16
		PHB				; >( data bank Reg. )
		PHK				; >
		PLB				; <
		PHD				; >> ( direct Reg. )
		PHA				; >> (A)
		PHX				; >> (X)
		PHY				; >> (Y)
;-----------------------------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		LDA	!NMI_status		;B read flag
		BIT	<nmi_flag		;B frame over?
		BMI	nmi_exit		;B yes -> exit
		TRB	<nmi_control		;B
;-----------------------------------------------------------------------
		REP	#00110000B
		MEM16
		IDX16
		LDX	#nmi_vector1		;W main nmi control
		JSR	(!0,X)
;-----------------------------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		LDA	<ppu_control		;B ON screen
		STA	!PPU_control		;B
		JSR	Debug_step		;B step mode?
		BVS	nmi_exit		;B yes -> skip
		INC	<frame			;B
;-----------------------------------------------------------------------
nmi_exit	REP	#00110000B
		MEM16
		IDX16
		LDX	#nmi_vector2		;W IRQ process
		JSR	(!0,X)
;-----------------------------------------------------------------------
		PLY				; << (Y)
		PLX				; << (X)
		PLA				; << (A)
		PLD				; <
		PLB				; <
		RTI
;*********************************************************************
;		NMI step
;*********************************************************************
;	V <- ON		(frame stop)
;	     OFF 	(nomal)
;-----------------------------------------------------------------------
		mem8
Debug_step	BIT	<screen_check		;B
		BVC	nmi_nomal		;B
		LDA	#00100000B		;B
		TRB	<screen_check		;B
		BNE	nmi_nomal		;B
		RTS				;(Vflag set)
nmi_nomal	CLV				;(clear flag)
		RTS				;
;*********************************************************************
;		color set process
;*********************************************************************
;cf.
;		buffer	000 - 1FF		nomal set
;----------------------------------------------------------------------
		mem16
		idx8
DMA_color	SEP	#10H			;
		LDX	#0			;B	
		STX	!Color_address		;B
		LDA	#2202H			;W
		STA	!DMA_0+0		;W 2122H L,L
		LDA	#color_buffer		;W color buffer
		STA	!DMA_0+DMA_address	;W A bus address
		STX	!DMA_0+DMA_address+2	;B
		LDA	#200H			;W byte count 200H
		STA	!DMA_0+DMA_count	;W
		LDY	#01H			;B DMA channel 1
		STY	!DMA_burst		;B
		REP	#10H			;
		RTS
;*********************************************************************
;		sprite set process
;*********************************************************************
;cf.
;		buffer	000 - sprite count	nomal set
;		buffer	sprite count - 1FF	V position clear
;		buffer	200 - 21F		sub set
;----------------------------------------------------------------------
DMA_sprite	SEP	#10H			; 
		STZ	!Sprite_address		;W
		LDA	#0402H			;W 2104H L,L
		STA	!DMA_0+0		;W
		LDA	#sprite_buffer		;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		LDY	#0			;B
		STY	!DMA_0+DMA_address+2	;B
		LDA	<sprite_count		;W
		STA	!DMA_0+DMA_count	;W
		LDX	#01H			;B DMA channel 1
		STX	!DMA_burst		;B
;;		REP	#10H
;;		RTS
;----------------------------------------------------------------------
		LDY	#00001010B		;B const data L,L
		STY	!DMA_0+0		;B
		EOR	#0FFFFH			;W
		SEC
		ADC	#0200H			;W
		STA	!DMA_0+DMA_count	;W
		LDA	#sprite_clear		;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		STX	!DMA_burst		;B
;----------------------------------------------------------------------
		LDY	#00000010B		;B data L,L
		STY	!DMA_0+0		;B
		LDA	#0020H
		STA	!DMA_0+DMA_count	;W
		LDA	#sprite_buffer+200H	;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		STX	!DMA_burst		;B
;----------------------------------------------------------------------
		REP	#10H
		RTS
;=======================================================================
sprite_clear	DW	0E0E0H
;=======================================================================
;*********************************************************************
;		sprite set process
;*********************************************************************
;cf.
;		buffer	000 - oam count		nomal set
;		buffer	oam count - 1FF		V position clear
;		buffer	200 - 21F		sub set
;----------------------------------------------------------------------
DMA_oam		SEP	#10H			; 
		STZ	!Sprite_address		;W
		LDA	#0402H			;W 2104H L,L
		STA	!DMA_0+0		;W
		LDA	#oam_buffer		;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		LDY	#0			;B
		STY	!DMA_0+DMA_address+2	;B
		LDA	<oam_count		;W
		CMP	#200H
		BCC	skipper
sos		JMP	sos
skipper		STA	!DMA_0+DMA_count	;W
		LDX	#01H			;B DMA channel 1
		STX	!DMA_burst		;B
;;		REP	#10H
;;		RTS
;----------------------------------------------------------------------
		LDY	#00001010B		;B const data L,L
		STY	!DMA_0+0		;B
		EOR	#0FFFFH			;W
		SEC
		ADC	#0200H			;W
		STA	!DMA_0+DMA_count	;W
		LDA	#sprite_clear		;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		STX	!DMA_burst		;B
;----------------------------------------------------------------------
		LDY	#00000010B		;B data L,L
		STY	!DMA_0+0		;B
		LDA	#0020H
		STA	!DMA_0+DMA_count	;W
		LDA	#oam_buffer+200H	;W A bus address
		STA	!DMA_0+DMA_address+0	;W
		STX	!DMA_burst		;B
;----------------------------------------------------------------------
		REP	#10H
		RTS
;=======================================================================
;*********************************************************************
;		button scan process
;*********************************************************************
		mem16
		idx16
Scan_button	LDX	#2
button_next	LDA	!Button+0,X		;W
;----------------------------------------------------------------------
;(convert button bit )
		ASL	A			;W
		ROL	A			;W
		XBA	
		ROR	A			;W
		ROR	A			;W
		BCC	button_skip
		EOR	#0080H			;W
button_skip	
;----------------------------------------------------------------------
;(config button bit )
	;;;;	BIT	!config_flag		;W
	;;;;	BPL	config_exit
		BRA	config_exit
		TXY				;WW
		BEQ	config_skip		
		LDY	#0CH			;W	player2 offset
config_skip	STA	!config_stock		;W
		AND	#0000000000111111B	;W
check_X		ASL	!config_stock		;W
		BCC	check_Y	
		ORA	!config1_X,Y		;W
check_Y		ASL	!config_stock		;W
		BCC	check_L			
		ORA	!config1_Y,Y		;W
check_L		ASL	!config_stock		;W
		BCC	check_R
		ORA	!config1_L,Y		;W
check_R		ASL	!config_stock		;W
		BCC	check_A		
		ORA	!config1_R,Y		;W
check_A		ASL	!config_stock		;W damy
		ASL	!config_stock		;W damy
		ASL	!config_stock		;W damy
		ASL	!config_stock		;W damy
		ASL	!config_stock		;W
		BCC	check_B
		ORA	!config1_A,Y		;W
check_B		ASL	!config_stock		;W
		BCC	config_exit	
		ORA	!config1_B,Y		;W
config_exit
;----------------------------------------------------------------------
;(set button & trigger)
		TAY
		ORA	<button,X		;W
		EOR	<button,X		;W
		STY	<button,X		;W
		STA	<trigger,X		;W
		DEX				;W
		DEX				;W
		BPL	button_next		; next 2 player scan
;----------------------------------------------------------------------
		RTS
;*********************************************************************
;		IRQ process
;*********************************************************************
Native_IRQ	REP	#00110000B
		MEM16
		IDX16
		PHB				; >( data bank Reg. )
		PHK				; >
		PLB				; <
		PHD				; >> ( direct Reg. )
		PHA				; >> (A)
		PHX				; >> (X)
		PHY				; >> (Y)
;-------------------------------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		BIT	!Timer_status		;B
		LDA	!IRQ_flag
		BNE	next_IRQ
open_IRQ	
;
		LDX	#080H			;B
		STX	!PPU_control		;B
		LDA	<ppu_control		;B
		STX	<ppu_control		;B
		STA	!ppu_backup		;B >(backup ppu control)
;
		INC	!IRQ_flag		;B
		LDA	#073H			;B (next timer)
		STA	!Timer_V+0		;B
;
		LDX	#30H		; BUG WAIT
lp		DEX			; BUG WAIT
		BPL	lp		; BUG WAIT

		JSR	Center_1		; set center X,Y 
		JSR	DMA_oam			; set oam
;
		BRA	exit_IRQ
;-------------------------------------------------------------------------
		mem8
next_IRQ	LDA	!debug_ppu_cont		;B
		STA	!PPU_control		;B
		LDA	!ppu_backup		;< (backup ppu control)
		STA	<ppu_control		;B
;-------------------------------------------------------------------------
exit_IRQ	REP	#00110000B
		MEM16
		IDX16
		PLY				; << (Y)
		PLX				; << (X)
		PLA				; << (A)
		PLD				; <
		PLB				; <
		RTI
;*********************************************************************
;		emulation mode interrupt
;*********************************************************************
NOT_USE
Emulate_IRQ
Emulate_NMI	RTI
;**********************************************************************
;		break process		
;**********************************************************************
Native_BRK
Emulate_BRK	STA	>0CF8000H
		STA	>0CF8000H
;***********************************************************************
;		RESET VECTOL
;***********************************************************************
;------------------------------------------ ; emulation mode ---------
		ORG	0FFF4H
		DW	Emulate_BRK
		DW	Emulate_BRK
		DW	Emulate_BRK
		DW	Emulate_NMI	; not use
		DW	RESET		; program entry
		DW	Emulate_IRQ	; not use 	( !!! Bug )
;------------------------------------------ ; mative mode ------------
		ORG	0FFE4H
		DW	Native_BRK
		DW	Native_BRK
		DW	Native_BRK
		DW	Native_NMI	; NMI entry
		DW	NOT_USE
		DW	Native_IRQ	; IRQ entry
;=====================================================================
			END
