;***********************************************************************
;		TEN Perspective process	VS mode
;					programed by H.Yajima
;***********************************************************************
		INCLUDE ../../SFX/RP5A22
		INCLUDE ../../SFX/RP5C77
		INCLUDE ../../DSP/D77C25
		INCLUDE	../DEF/Register.def
;-----------------------------------------------------------------------
		GLB	Gradient_0,Gradient_1
		GLB	Center_1
		GLB	Init_persp_VS
;-----------------------------------------------------------------------
pers_start	EQU	000H		; 0 line start
pers_full	EQU	128		; 128 line loop
;-----------------------------------------------------------------------
start_raster	EQU	000H		; start line
center_raster	EQU	060H		; 
VS_start	EQU	000H+70H	; VS start line
VS_center	EQU	060H+70H	; 
;-----------------------------------------------------------------------
center_H	EQU	0007FH		
;-----------------------------------------------------------------------
_VS		EQU	020H
;-----------------------------------------------------------------------
		COMN
temporary
pointer
pointer0	DS	4
pointer1	DS	4
pointer2	DS	4
pointer3	DS	4
counter		DS	2
;====================================================================
;		DATA
;axis_X		DS	4
;axis_Y		DS	4
;axis_Z		DS	4
;pose_P		DS	2
;pose_Q		DS	2
;pose_R		DS	2
;camera		DS	2
;zoom		DS	2
;center_X	DS	2
;center_Y	DS	2
;horizon	DS	2
;gradiece	DS	2
;virtual_center	DS	2
;
;====================================================================
persp_buffer	EQU	400000H		;
;====================================================================
		ORG	persp_value	; 1980H
;-----------------------------------------------------------------------
perspective_X	DS	2		; center X
perspective_Y	DS	2		; center Y
perspective_x	DS	2		; VS center X
perspective_y	DS	2		; VS center Y
perspective_H	DS	2		; scroll H
perspective_V	DS	2		; scroll V
perspective_h	DS	2		; VS scroll H	
perspective_v	DS	2		; VS scroll V
;-----------------------------------------------------------------------
DMA_A0_param	DS	10H		; pers DMA buffer
DMA_B0_param	DS	10H
DMA_C0_param	DS	10H
DMA_D0_param	DS	10H
;-----------------------------------------------------------------------
pers_flag	DS	1		; ( 0...off 1...on )
;======================================================================
dma_offset_0010		EQU	2	; DMA parameter label
;----------------------------------------------------------------------
		EXTEND
		PROG
		mem16
		idx16
;**********************************************************************
;		Gradient parameter set
;**********************************************************************
Gradient_0	CLC
		LDA	<pose_P			;W
		ADC	#03800H			;W (4000) offset
		STA	<gradience		;W
		PEA	DSP_bank
		PLB
		SEP	#00100000B
		MEM8
		LDA	#dsp_parameter		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<axis_X+2		;W
		STA	!DSP_data		;W coordinate X
		LDA	<axis_Y+2		;W
		STA	!DSP_data		;W coordinate Y
		LDA	<axis_Z+2		;W
		STA	!DSP_data		;W coordinate Z
		LDA	<camera			;W
		STA	!DSP_data		;W sight distance
		LDA	<zoom			;W
		STA	!DSP_data		;W sight angle
		LDA	<pose_Q			;W
		STA	!DSP_data		;W sight direction
		LDA	<gradience
		STA	!DSP_data		;W sight gradience
		CLC
		LDA	#center_raster		;W
		BIT	!DSP_status
		BPL	$-3
		ADC	!DSP_data		;W offset
		STA	<virtual_center		;W
		CLC
		ADC	!DSP_data		;W horizon
		STA	!horizon		;W
		SEC
		LDA	!DSP_data		;W
		STA	<center_X		;W
		STA	!perspective_X		;W Set center X
		SBC	#center_H		;W
		STA	!perspective_H		;W Set scroll H
		SEC
		LDA	!DSP_data		;W
		STA	<center_Y		;W
		STA	!perspective_Y		;W Set center Y
		SBC	<virtual_center		;W
		INC	A			;W
		STA	!perspective_V		;W Set scroll V
		PLB
		RTS
;-----------------------------------------------------------------------
;**********************************************************************
;		angle A,B,C,D
;**********************************************************************
angle_A		DW	A_00,A_01,A_10,A_11
angle_B		DW	B_00,B_01,B_10,B_11
angle_C		DW	C_00,C_01,C_10,C_11
angle_D		DW	D_00,D_01,D_10,D_11
;-----------------------------------------------------------------------
A_00		TYA			; Mcos X 	(0-90) 
		RTS
A_01		TYA			; Mcos X 	(90-180)
		ORA	#04000H		
		RTS
A_10		TYA			; Mcos X 	(180-270)
		EOR	#03F00H		; = Mcos(180-X)	(90-180)
		ORA	#04000H
			RTS
A_11		TYA			; Mcos X	(270-360)
		EOR	#03F00H		; = Mcos(180-X) (0-90)
		RTS
;-----------------------------------------------------------------------
B_00		TYA			; -Nsin X (0-90)	
		ORA	#04000H		; = Ncos(X+90) (90-180)
		RTS
B_01		TYA			; -Nsin X (90-180)
		EOR	#03F00H		; = Ncos(X+90) (180-270)
		ORA	#04000H		; = Ncos(90-X) (90-180)
		RTS
B_10		TYA			; -Nsin X (180-270)
		EOR	#03F00H		; = Ncos(X+90) (270-360)
		RTS			; = Ncos(90-X) (0-90) 
B_11		TYA			; -Nsin X (270-360)
		RTS			; = Ncos(X+90) (0-90)
;-----------------------------------------------------------------------
C_00		TYA			; Msin X (0-90)
		EOR	#3F00H		; = Msin(X-90) (270-360)
		RTS			; = Msin(90-X) (0-90)
C_01		TYA			; Msin X (90-180)
		RTS			; = Msin(X-90) (0-90)
C_10		TYA			; Msin X (180-270)
		ORA	#04000H		; = Msin(X-90) (90-180)
		RTS
C_11		TYA			; Msin X (270-360)
		EOR	#03F00H		; = Msin(X-90) (180-270)
		ORA	#04000H		; = Msin(90-X) (90-180)
		RT;-----------------------------------------------------------------------
D_00		TYA			; Ncos X (0-90)
		RTS
D_01		TYA			; Ncos X (90-180)
		ORA	#4000H
		RTS
D_10		TYA			; Ncos X (180-270)
		EOR	#3F00H		; =Ncos X (90-180)
		ORA	#4000H
		RTS
D_11		TYA			; Ncos X (270-360)
		EOR	#3F00H		; =Ncos X (0-90)
		RTS
;==========================================================================
Center_1	SEP	#00100000B
		MEM8
		LDA	!perspective_x+0	;B
		STA	!Rotation_X		;B
		LDA	!perspective_x+1	;B
		STA	!Rotation_X		;B
		LDA	!perspective_y+0	;B
		STA	!Rotation_Y		:B
		LDA	!perspective_y+1	;B
		STA	!Rotation_Y		;B
		LDA	!perspective_h+0	;B
		STA	!Scroll_H		;B
		LDA	!perspective_h+1	;B
		STA	!Scroll_H		;B
		LDA	!perspective_v+0	;B
		STA	!Scroll_V		;B
		LDA	!perspective_v+1	;B
		STA	!Scroll_V		;B
		REP	#00100000B
		MEM16
		RTS
;-----------------------------------------------------------------------
Gradient_1	
Center_0	SEP	#00100000B
		MEM8
		LDA	!perspective_X+0	;B
		STA	!Rotation_X		;B
		LDA	!perspective_X+1	;B
		STA	!Rotation_X		;B
		LDA	!perspective_Y+0	;B
		STA	!Rotation_Y		:B
		LDA	!perspective_Y+1	;B
		STA	!Rotation_Y		;B
		LDA	!perspective_H+0	;B
		STA	!Scroll_H		;B
		LDA	!perspective_H+1	;B
		STA	!Scroll_H		;B
		LDA	!perspective_V+0	;B
		STA	!Scroll_V		;B
		LDA	!perspective_V+1	;B
		STA	!Scroll_V		;B
		REP	#00100000B
		MEM16
;-----------------------------------------------------------------------
		LDA	<pose_Q
		AND	#03F00H
		TAY			; buffer pointer
		LDA	<pose_Q
		AND	#0FF00H
		ROL	A		; carry
		ROL	A		; d15bit
		ROL	A		; d14bit 
		ROL	A		; ASL A
		AND	#0110B
		TAX			; jump table
		JSR	(!angle_A,X)
		STA	!DMA_A0_param+1	; M * cos X
		JSR	(!angle_B,X)
		ORA	#08000H
		STA	!DMA_B0_param+1	; N * -sin X
		JSR	(!angle_C,X)
		STA	!DMA_C0_param+1	; M * sin X
		JSR	(!angle_D,X)
		ORA	#08000H
		STA	!DMA_D0_param+1	; N * cos X
;-----------------------------------------------------------------------
		LDA	<pose_Q+_VS
		AND	#03F00H
		TAY			; buffer pointer
		LDA	<pose_Q+_VS
		AND	#0FF00H
		ROL	A		; carry
		ROL	A		; d15bit
		ROL	A		; d14bit 
		ROL	A		; ASL A
		AND	#0110B
		TAX			; jump table
		JSR	(!angle_A,X)
		CLC
		ADC	#00008H
		STA	!DMA_A0_param+7	; M * cos X
		JSR	(!angle_B,X)
		CLC
		ADC	#00008H+08000H
		STA	!DMA_B0_param+7	; N * -sin X
		JSR	(!angle_C,X)
		CLC
		ADC	#00008H
		STA	!DMA_C0_param+7	; M * sin X
		JSR	(!angle_D,X)
		CLC
		ADC	#00008H+08000H
		STA	!DMA_D0_param+7	; N * cos X
;-----------------------------------------------------------------------
		CLC
		LDA	<pose_P+_VS		;W
		ADC	#03800H			;W (4000)
		STA	<gradience+_VS		;W
		PEA	DSP_bank
		PLB
		SEP	#00100000B
		MEM8
		LDA	#dsp_parameter		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<axis_X+2+_VS		;W
		STA	!DSP_data		;W coordinate X
		LDA	<axis_Y+2+_VS		;W
		STA	!DSP_data		;W coordinate Y
		LDA	<axis_Z+2+_VS		;W
		STA	!DSP_data		;W coordinate Z
		LDA	<camera+_VS		;W
		STA	!DSP_data		;W sight distance
		LDA	<zoom+_VS		;W
		STA	!DSP_data		;W sight angle
		LDA	<pose_Q+_VS		;W
		STA	!DSP_data		;W sight direction
		LDA	<gradience+_VS		;W
		STA	!DSP_data		;W sight gradience
		CLC
		LDA	#VS_center		;W
		BIT	!DSP_status
		BPL	$-3
		ADC	!DSP_data		;W offset
		STA	<virtual_center+_VS	;W
		CLC
		ADC	!DSP_data		;W horizon
	;;;;	STA	!horizon		;W
		SEC
		LDA	!DSP_data		;W
		STA	<center_X+_VS		;W
		STA	!perspective_x		;W Set VS center X
		SBC	#center_H		;W
		STA	!perspective_h		;W Set VS scroll H
		SEC
		LDA	!DSP_data		;W
		STA	<center_Y+_VS		;W
		STA	!perspective_y		;W Set VS center Y
		SBC	<virtual_center+_VS	;W
		INC	A			;W
		STA	!perspective_v		;W Set VS scroll V
		PLB
		RTS
;**********************************************************************
;		DMA parameter
;**********************************************************************
dma_parameter 	DB	dma_indirect+dma_offset_0010,Rotation_A
		DL	DMA_A0_param
		DB	0,0,40H
		DB	dma_indirect+dma_offset_0010,Rotation_B
		DL	DMA_B0_param
		DB	0,0,40H
		DB	dma_indirect+dma_offset_0010,Rotation_C
		DL	DMA_C0_param
		DB	0,0,40H
		DB	dma_indirect+dma_offset_0010,Rotation_D
		DL	DMA_D0_param
0		DB	0,0,40H
perspective_0	DB	0,0,0
;**********************************************************************
;		Initial pers
;**********************************************************************
Init_persp_VS
		SEP	#00110000B
		MEM8
		IDX8
		LDA	#DMA_high		;B
		STA	<pointer+1		;B
		LDA	#DMA_7			;B
		LDX	#8*4			;B
		SEC
initiate_repeat STA	<pointer+0		;B
		LDY	#7			;B
initiate_loop	DEX
		LDA	!dma_parameter,X	;B
		STA	(<pointer),Y		;B
		DEY
		BPL	initiate_loop
		LDA	<pointer+0		;B
		SBC	#16			;B
		CMP	#DMA_3			;B
		BNE	initiate_repeat
		REP	#00110000B
		MEM16
		IDX16
;----------------------------------------------------------------------
		JSR	Initial_pers	
		JSR	Buffer_raster
;----------------------------------------------------------------------
		SEP	#00100000B
		MEM8
		LDA	#80H+6BH		;B line count (mode7)
		STA	!DMA_A0_param+0		;B	
		STA	!DMA_B0_param+0		;B
		STA	!DMA_C0_param+0		;B
		STA	!DMA_D0_param+0		;B
		STA	!DMA_A0_param+6		;B
		STA	!DMA_B0_param+6		;B
		STA	!DMA_C0_param+6		;B
		STA	!DMA_D0_param+6		;B
;----------------------------------------------------------------------
		LDA	#08H			;B line count (branking) 
		STA	!DMA_A0_param+3		;B
		STA	!DMA_B0_param+3		;B
		STA	!DMA_C0_param+3		;B
		STA	!DMA_D0_param+3		;B
		LDA	#0			; end code
		STA	!DMA_A0_param+9		;B
		STA	!DMA_B0_param+9		;B
		STA	!DMA_C0_param+9		;B
		STA	!DMA_D0_param+9		;B
		REP	#00100000B
		MEM16
		LDA	#0			;W same data address 
		STA	!DMA_A0_param+4		;W
		STA	!DMA_B0_param+4		;W
		STA	!DMA_C0_param+4		;W
		STA	!DMA_D0_param+4		;W
		RTS	
;**********************************************************************
;		RASTER BUFFERING
;**********************************************************************
Buffer_raster	LDA	!persp_flag	;W(B)
		AND	#0FFH		;W(B)
		BEQ	raster_exit	
		STZ	<pose_Q+0	; reset angle Q
raster_loop	JSR	Gradient_0
		JSR	Set_raster
		LDA	<pose_Q+0	; angle Q (0-180)
		CLC
		ADC	#0100H
		STA	<pose_Q+0
		CMP	#8000H
		BNE	raster_loop
raster_exit	RTS
;----------------------------------------------------------------------
Set_raster	PEA	DSP_bank
		PLB
		SEP	#00100000B
		MEM8
		LDA	#dsp_raster		;B
		STA	!DSP_data		;B
		REP	#00110001B
		MEM16
		IDX16
		LDA	#pers_start+1		;W start raster
		SBC	<virtual_center		;W screen center
		STA	!DSP_data		;W
		LDA	<pose_Q			;W
		AND	#0FF00H			;W
		TAX				;WW
;----------------------------------------------------------------------
		LDY	#pers_full		;W full raster
buffering_loop	BIT	!DSP_status
		BPL	$-3
		LDA	!DSP_data		;W read A
		STA	>persp_buffer+0000H,X	;W
		LDA	!DSP_data		;W read B
		LDA	!DSP_data		;W read C
		LDA	!DSP_data		;W read D
		STA	>persp_buffer+8000H,X	;W
		INX				;W
		INX				;W
		DEY				;W
		BNE	buffering_loop
		LDA	#dsp_abort		;W
		LDX	!DSP_status
		BPL	$-3
		STA	!DSP_data		;W
		STA	!DSP_data		;W
		STA	!DSP_data		;W
		STA	!DSP_data		;W
		PLB
		RTS
;**********************************************************************
;		parameter initial
;**********************************************************************
Initial_pers	LDX	#0			; screen
		LDY	#camera_data1
		JSR	Set_TVcamera
		LDX	#_VS			; VS screen
		LDY	#camera_data2
		JMP	Set_TVcamera		;(RTS)
;-------------------------------------------------------------------------
Set_TVcamera	LDA	!0,Y
		STA	<camera,X
		LDA	!2,Y
		STA	<zoom,X
		LDA	!4,Y
		STA	<axis_X+2,X
		LDA	!6,Y
		STA	<axis_Y+2,X
		LDA	!8,Y
		STA	<axis_Z+2,X
		LDA	!10,Y
		STA	<pose_P,X
		LDA	!12,Y
		STA	<pose_Q,X
	;;	LDA	!14,Y
	;;	STA	<offset_X,X
	;;	LDA	!16,Y
	;;	STA	<offset_Y,X
	;;	LDA	!18,Y
	;;	STA	<offset_Z,X
		RTS
;-------------------------------------------------------------------------
camera_data1	DW	00030H		; camera	
		DW	00100H		; zoom	
		DW	0200H		; ax
		DW	0300H		; ay
		DW	0		; az
		DW	0FC00H		; pose_P
		DW	0		; pose_Q
;-------------------------------------------------------------------------
camera_data2	DW	00030H		; camera	
		DW	00100H		; zoom	
		DW	0200H		; ax
		DW	0300H		; ay
		DW	0		; az
		DW	0FC00H		; pose_P
		DW	0		; pose_Q
;-------------------------------------------------------------------------
		END
