/************************************************************************
		Hex Calculator  version 1.00
		    programmed by Y.Nishida
						[ Jun.14, 1989 ]
 ************************************************************************/

#include	<stdio.h>
#include	<ctype.h>
#include	<sys/ioctl.h>

#define		TRUE		1
#define		FALSE		0
#define		ERROR		-1
#define		DEC		0
#define		HEX		1

int	arg1 = 0 ;		/* number 1		*/
int	arg2 = 0 ;		/* number 2		*/
int	dav  = 0 ;		/* data avirable	*/
int	func = 0 ;		/* calucurate function	*/
int	mode = DEC ;		/* calcurate mode	*/


main()
{
	int	cc,fg = TRUE ;

	set_tty( 1 ) ;
	initscrn() ;

	while ( fg ) {
		switch ( cc = getch()) {
			case 'Q'   : fg = FALSE ;	break ;
			case '\t'  : cng_mode() ;	break ;
			case '\033': all_clear() ;	break ;
			case '='   : set_func( 0,cc ) ;	break ;
			case '+'   : set_func( 1,cc ) ;	break ;
			case '-'   : set_func( 2,cc ) ;	break ;
			case '*'   : set_func( 3,cc ) ;	break ;
			case '/'   : set_func( 4,cc ) ;	break ;
			case 'X'   : del_num() ;	break ;
			default    : set_num( cc ) ;	break ;
		}
	}
	puts( "\033[2J" ) ;
	set_tty( 2 ) ;
}

/*************** all clear ***********************************************/

all_clear()
{
	arg1 = arg2 = 0 ;
	dav  = func = 0 ;

	printf( "\033[3;3H%18d\033[4;20H \n",arg1 ) ;
}

/*************** change mode *********************************************/

cng_mode()
{
	int	arg ;

	arg = ( dav ) ? arg1 : arg2 ;

	if ( mode == DEC ) {
		mode = HEX ;
		puts( "\033[4;3Hhex" ) ;
		printf( "\033[3;3H%18X\n",arg ) ;
	}
	else {
		mode = DEC ;
		puts( "\033[4;3Hdec" ) ;
		printf( "\033[3;3H%18d\n",arg ) ;
	}
}

/*************** set function ********************************************/

set_func( mo,cc )
int	mo,cc ;
{
	if ( dav ) {
		if ( func ) {
			switch ( func ) {
				case 1: arg2 += arg1 ;	break ;
				case 2: arg2 -= arg1 ;	break ;
				case 3: arg2 *= arg1 ;	break ;
				case 4: 
					if ( arg1 == 0 ) {
						diverr() ;
						return ;
					}
					arg2 /= arg1 ;
					break ;
			}
			if ( mode == DEC )  printf( "\033[3;3H%18d\n",arg2 ) ;
				      else  printf( "\033[3;3H%18X\n",arg2 ) ;
		}
		else {
			arg2 = arg1 ;
		}
		dav = arg1 = 0 ;
	}
	func = mo ;
	printf( "\033[4;20H%c\n",cc ) ;
}

/*************** set number *********************************************/

set_num( cc )
int	cc ;
{
	if ( mode == DEC ) {
		if ( isdigit( cc )) {
			arg1 = arg1 * 10 + cc - '0' ;
			printf( "\033[3;3H%18d\n",arg1 ) ;
		}
	}
	else {
		if ( isxdigit( cc )) {
			if ( cc < 'A' ) arg1 = arg1 * 16 + cc - '0' ;
				   else arg1 = arg1 * 16 + cc - 'A' + 10 ;
			printf( "\033[3;3H%18X\n",arg1 ) ;
		}
	}
	dav = 1 ;
}

/*************** delete number ******************************************/

del_num()
{
	if ( dav == 1 && arg1 != 0 ) {
		if ( mode == DEC ) {
			arg1 /= 10 ;
			printf( "\033[3;3H%18d\n",arg1 ) ;
		}
		else {
			arg1 /= 16 ;
			printf( "\033[3;3H%18X\n",arg1 ) ;
		}
	}
}

/*************** divition by zoro error *********************************/

diverr()
{
	printf( "\033[3;3H             error\n" ) ;
	while ( getch() != '\033' ) ;
	all_clear() ;
}

/*************** initialize screen **************************************/

initscrn()
{
	puts( "\033[2J\033[01;01Hcalcurator  ver 1.00" ) ;
	puts( "+--------------------+" ) ;
	puts( "|                  0 |" ) ;
	puts( "| dec                |" ) ;
	puts( "+--------------------+" ) ;
}

/*************** get chracter from console ******************************/

getch()
{
	char	cc ;

	if ( read( 0,&cc,1 ) == ERROR ) cc = 0 ;
	if ( isalpha( cc )) cc = toupper( cc ) ;
	return ( cc ) ;
}

/*************** set tty ************************************************/

set_tty( mo )
int	mo ;
{
	static	struct  sgttyb  ttyctrl ;
	static	short	backstat = 0 ;

	if ( mo == 1 ) {
		ioctl( 0,TIOCGETP,&ttyctrl ) ;
		backstat         = ttyctrl.sg_flags ;
		ttyctrl.sg_flags = ( ttyctrl.sg_flags & ~ECHO ) | CBREAK ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
		puts( "\033[?25l" ) ;
	}
	else if ( mo == 2 ) {
		ttyctrl.sg_flags = backstat ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
		puts( "\033[?25h" ) ;
	}
}
