/************************************************************************
	Convert binary file into assembler source file ver. 0.10
			Programmed by Y.Nishida
						[ Jul.31, 1991 ]
 ************************************************************************/

#include	<stdio.h>

void main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*rfp,*wfp ;

	printf( "Convert binary file into assembler source file ver. 0.10\n" ) ;
	if ( argc != 3 ) {
		printf( "Usage: cnvsource  binary_file  source_file\n" ) ;
		exit( 1 ) ;
	}
	if (( rfp = fopen( *++argv,"r" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	if (( wfp = fopen( *++argv,"w" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	convert( rfp,wfp ) ;
	fclose( rfp ) ;
	fclose( wfp ) ;
}

convert( rfp,wfp )
FILE	*rfp,*wfp ;
{
	int	cc,nn=0 ;

	while (( cc = fgetc( rfp )) != EOF ) {
		switch ( nn++ ) {
			case 0:
				fprintf( wfp,"\t\tbyte\t\t0%02XH",cc ) ;
				break ;
			case 7:
				fprintf( wfp,",0%02XH\n",cc ) ;
				nn = 0 ;
				break ;
			default:
				fprintf( wfp,",0%02XH",cc ) ;
				break ;
		}
	}
	if ( nn != 0 ) fputc( '\n',wfp ) ;
}
