/************************************************************************
	       \[Xt@C쐬vO  2.00
		Copyright (C) 1990,91 by Y.Nishida
						[ Oct.31, 1991 ]
 ************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
/*  #include	    <io.h>	*/

#define COMPLETE	0
#define ERROR		1
#define AS_SOURCE	0
#define CC_SOURCE	1
#define SEEK_SET	0

typedef union {
	int	number ;
	char	chrdat[4] ;
} Data ;

typedef struct {
	char	*first ;
	char	*second ;
} FString ;


int	start_address	= 0x000000 ;	/*  ϊJnAhX			*/
int	end_address	= 0xffffff ;	/*  ϊIAhX			*/
int	number_of_datas = -1 ;		/*  ϊf[^̌		*/
int	size_of_data	= 1 ;		/*  ϊf[^̃TCY		*/
int	source_select	= AS_SOURCE ;	/*  ϊ\[X̎		*/
int	data_in_line	= 16 ;		/*  Ps̃f[^			*/

char	*binary_file_name ;		/*  oCit@Cւ̃|C^	*/
char	*source_file_name ;		/*  \[Xt@Cւ̃|C^	*/


FString format_strings[2][4] = {
	"\t\tdc.b\t\t$%02X",",$%02X",
	"\t\tdc.w\t\t$%04X",",$%04X",
	"","",
	"\t\tdc.l\t\t$%08X",",$%08X",

	"\t\t0x%02x",",0x%02x",
	"\t\t0x%04x",",0x%04x",
	"","",
	"\t\t0x%08x",",0x%08x"
} ;

void	Convert_Data( FILE *,FILE * ) ;
int	Check_Options( int,char ** ) ;
int	Get_Number( char * ) ;
void	Display_Usage( void ) ;

/************************************************************************/
/*	C								*/
/************************************************************************/

void main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*rfp,*wfp ;

	printf( "\[Xt@C쐬vO  2.00\n" ) ;
	if ( Check_Options( argc,argv ) == ERROR ) {
		Display_Usage() ;
		exit( 1 ) ;
	}
	if ( number_of_datas <= 0 ) {
		printf( "f[^̃AhX͈͂ԈĂ܂.\n" ) ;
		exit( 1 ) ;
	}
	if ( data_in_line <= 0 ) {
		printf( "Ps̃f[^̎w肪ԈĂ܂.\n" ) ;
		exit( 1 ) ;
	}
	if (( rfp = fopen( binary_file_name,"rb" )) == NULL ) {
		printf( "oCit@C܂.\n" ) ;
		exit( 1 ) ;
	}
	if (( wfp = fopen( source_file_name,"wt" )) == NULL ) {
		printf( "o̓t@C쐬ł܂.\n" ) ;
		exit( 1 ) ;
	}
	if ( start_address < filelength( fileno(rfp))) {
		Convert_Data( rfp,wfp ) ;
	}
	else {
		printf( "X^[gAhX傫߂܂.\n" ) ;
	}
	fclose( rfp ) ;
	fclose( wfp ) ;
}

/************************************************************************/
/*	f[^̕ϊs						*/
/************************************************************************/

void Convert_Data( rfp,wfp )
FILE	*rfp,*wfp ;
{
	Data	data ;
	int	count ;
	char	*format1,*format2,*chrptr ;

	data.number = 0 ;
	count	    = 0 ;
	chrptr	    = &data.chrdat[4-size_of_data] ;
	format1	    = format_strings[source_select][size_of_data-1].first ;
	format2	    = format_strings[source_select][size_of_data-1].second ;

	if ( start_address > 0 ) {
		fseek( rfp,start_address,SEEK_SET ) ;
	}
	while ( number_of_datas-- ) {
		if ( fread( chrptr,size_of_data,1,rfp ) != 1 )	break ;

		if ( count == 0 ) fprintf( wfp,format1,data.number ) ;
			     else fprintf( wfp,format2,data.number ) ;

		if ( ++count == data_in_line ) {
			count = 0 ;
			fputc( '\n',wfp ) ;
		}
	}
	if ( count != 0 ) fputc( '\n',wfp ) ;
}

/************************************************************************/
/*	IvṼ`FbNs					*/
/************************************************************************/

int Check_Options( argc,argv )
int	argc ;
char	**argv ;
{
	int	count = 0 ;

	while ( --argc ) {
		if ( **++argv == '-' ) {
			switch ( *++*argv ) {
				case 'a':
					source_select = AS_SOURCE ;
					break ;
				case 'c':
					source_select = CC_SOURCE ;
					break ;
				case 's':
					start_address = Get_Number( ++*argv ) ;
					break ;
				case 'e':
					end_address	= Get_Number( ++*argv ) ;
					number_of_datas = -1 ;
					break ;
				case 'n':
					number_of_datas = Get_Number( ++*argv ) ;
					break ;
				case 'd':
					data_in_line = Get_Number( ++*argv ) ;
					break ;
				case 'b':
					size_of_data = 1 ;	/*  set byte size	*/
					break ;
				case 'w':
					size_of_data = 2 ;	/*  set word size	*/
					break ;
				case 'l':
					size_of_data = 4 ;	/*  set long size	*/
					break ;
				default:
					printf( "-%c: ȃIvVw肵܂.\n", **argv ) ;
					return ( ERROR ) ;
			}
		}
		else {
			switch ( count ) {
				case 0:
					binary_file_name = *argv ;
					count++ ;
					break ;
				case 1:
					source_file_name = *argv ;
					count++ ;
					break ;
				default:
					printf( "%s: ȃt@Cw肵܂.\n", *argv ) ;
					return ( ERROR ) ;
			}
		}
	}
	if ( number_of_datas == -1 ) {
		number_of_datas = ( end_address - start_address + 1 ) / size_of_data ;
	}
	return ( count != 2 ) ;
}

/************************************************************************/
/*	𐮐ɕϊ						*/
/************************************************************************/

int Get_Number( string )
char	*string ;
{
	int	number = 0 ;

	if ( *string == '$' ) {
		string++ ;
		while ( isxdigit( *string )) {
			int cc = *string++ ;
			if ( cc <= '9' ) {
				number = number * 16 + cc - '0' ;
			}
			else if ( cc <= 'F' ) {
				number = number * 16 + cc - 'A' + 10 ;
			}
			else {
				number = number * 16 + cc - 'a' + 10 ;
			}
		}
	}
	else {
		number = atoi( string ) ;
	}
	return ( number ) ;
}

/************************************************************************/
/*	gp@\						*/
/************************************************************************/

void Display_Usage()
{
	printf( "gp@: source [IvV] <oCit@C> <eLXgt@C>\n" ) ;
	printf( "    -a: AZu\[X`ŏo͂\n" ) ;
	printf( "    -c: b̃\[X`ŏo͂\n" ) ;
	printf( "    -s: ϊJnAhX̎w\n" ) ;
	printf( "    -e: ϊIAhX̎w\n" ) ;
	printf( "    -n: ϊf[^̌̎w\n" ) ;
	printf( "    -b: oCgPʂŕϊ\n" ) ;
	printf( "    -w: [hPʂŕϊ\n" ) ;
	printf( "    -l: O[hPʂŕϊ\n" ) ;
	printf( "    -d: Psɏo͂f[^\n" ) ;
}
