/****************************************************************
	Set see through character  versiton 1.00
		  Programmed by Y.Nishida
					[ Nov.21, 1989 ]
 ****************************************************************/

#include	<stdio.h>
#include	<ctype.h>

#define		unchar		unsigned char
#define		unshort		unsigned short
#define		SCRSIZE		0x2300

unchar	scrbuf[SCRSIZE] ;		/* screen file buffer	*/
unshort	clrcode ;			/* clear code		*/

int	getcode() ;
void	fileload(),filesave(),setting() ;


/******* main function ******************************************/

void main( argc,argv )
int	argc ;
char	**argv ;
{
	puts( "Set see through character  versiton 1.00" ) ;
	if ( argc < 3 ) {
		fputs( "usage: through <clear code> <file1> [ <file2> ... ]\n",stderr ) ;
		exit( 1 ) ;
	}
	clrcode = (unshort)getcode( *++argv ) ;
	argc -- ;

	while ( --argc ) {
		fileload( *++argv,(char *)scrbuf ) ;
		printf( "Setting file \"%s\"\n", *argv ) ;
		setting( scrbuf ) ;
		filesave( *argv,(char *)scrbuf ) ;
	}
	exit( 0 ) ;
}

/******* get clear code *****************************************/

int getcode( str )
char	*str ;
{
	int	ch,nn=0 ;

	ch = *str ;
	while ( isxdigit( ch )) {
		     if ( ch <= '9' ) ch -= '0' ;
		else if ( ch <= 'F' ) ch -= 'A'-10 ;
		else		      ch -= 'a'-10 ;
		nn = nn * 16 + ch ;
		ch = *++str ;
	}
	return ( nn ) ;
}

/******* load file **********************************************/

void fileload( fname,buff )
char	*fname,*buff ;
{
	FILE	*fp ;

	if (( fp = fopen( fname,"r" )) == NULL ) {
		perror( fname ) ;
		exit( 1 ) ;
	}
	fread( buff,sizeof(char),SCRSIZE,fp ) ;
	fclose( fp ) ;
}

/******* save file **********************************************/

void filesave( fname,buff )
char	*fname,*buff ;
{
	FILE	*fp ;

	if (( fp = fopen( fname,"w" )) == NULL ) {
		perror( fname ) ;
		exit( 1 ) ;
	}
	fwrite( buff,sizeof(char),SCRSIZE,fp ) ;
	fclose( fp ) ;
}

/*******  check clear code **************************************/

void setting( buff )
unchar	*buff ;
{
	static	int	flgofs[4] = { 0x2100,0x2104,0x2200,0x2204 } ;
	auto	unchar	*dat,*flg ;
	auto	int	cd,ix,iy,ib,scr ;

	for ( dat=buff,scr=0 ; scr<4 ; scr++ ) {
		flg = buff + flgofs[scr] ;

		for ( iy=0 ; iy<32 ; iy++ ) {
			for ( ix=0 ; ix<4 ; ix++ ) {
				cd = *flg++ ;
				for ( ib=0 ; ib<8 ; ib++ ) {
					if ( !( cd & 0x80 )) {
						*(dat+0) = clrcode & 0x00ff ;
						*(dat+1) = clrcode >> 8 ;
					}
					cd <<= 1 ;
					dat += 2 ;
				}
			}
			flg += 4 ;
		}
	}
}
